<?php

namespace Drupal\dkan_dataset_archiver;

use Drupal\Component\Datetime\TimeInterface;
use Drupal\Core\Entity\EntityTypeBundleInfoInterface;
use Drupal\Core\Entity\EntityTypeManagerInterface;
use Drupal\Core\Messenger\MessengerInterface;
use Drupal\Core\StringTranslation\StringTranslationTrait;

/**
 * Manager for working with DKAN Dataset Archive entities.
 */
class DdaArchiveManager {

  use StringTranslationTrait;
  /**
   * The entity type manager.
   *
   * @var \Drupal\Core\Entity\EntityTypeManagerInterface
   */
  protected $entityTypeManager;

  /**
   * Drupal\Core\Entity\EntityTypeBundleInfoInterface definition.
   *
   * @var \Drupal\Core\Entity\EntityTypeBundleInfoInterface
   */
  protected $entityTypeBundleInfo;

  /**
   * The messenger service.
   *
   * @var \Drupal\Core\Messenger\MessengerInterface
   */
  protected $messenger;

  /**
   * The time service.
   *
   * @var \Drupal\Component\Datetime\TimeInterface
   */
  protected $time;

  /**
   * Constructor.
   *
   * @param \Drupal\Core\Entity\EntityTypeManagerInterface $entityTypeManager
   *   The entity type manager.
   * @param \Drupal\Component\Datetime\TimeInterface $time
   *   The time service.
   * @param \Drupal\Core\Entity\EntityTypeBundleInfoInterface $entity_type_bundle_info
   *   The EntityTypeBundleInfoInterface service.
   * @param \Drupal\Core\Messenger\MessengerInterface $messenger
   *   The messenger service.
   */
  public function __construct(EntityTypeManagerInterface $entityTypeManager, TimeInterface $time, EntityTypeBundleInfoInterface $entity_type_bundle_info, MessengerInterface $messenger) {
    $this->entityTypeManager = $entityTypeManager;
    $this->time = $time;
    $this->entityTypeBundleInfo = $entity_type_bundle_info;
    $this->messenger = $messenger;
  }

  /**
   * Returns all Archives.
   *
   * @return \Drupal\dkan_dataset_archiver\Entity\DdaArchiveInterface[]
   *   Array of active Archives indexed by their ids.
   *
   * @throws \Drupal\Component\Plugin\Exception\InvalidPluginDefinitionException
   * @throws \Drupal\Component\Plugin\Exception\PluginNotFoundException
   */
  public function getDdaArchives(): array {
    /** @var \Drupal\dkan_dataset_archiver\Entity\DdaArchiveInterface[] $dDaArchive */
    // @todo Evaluate if this can be removed.
    $ddaArchive = $this->entityTypeManager
      ->getStorage('dda_archive')
      ->loadByProperties(['status' => 1]);
    return $ddaArchive;
  }

}
