<?php

namespace Drupal\Tests\dkan_dataset_archiver\Functional;

use Drupal\Tests\BrowserTestBase;

/**
 * Tests for the /admin/dkan/archiver side of the dataset archiver module.
 *
 * @group alt_text_validation
 */
class AdminTest extends BrowserTestBase {

  /**
   * Modules to install.
   *
   * @var array
   */
  protected static $modules = [
    'dkan_dataset_archiver',
    'user',
    'field',
  ];

  /**
   * The theme to default to during tests.
   *
   * @var string
   */
  protected $defaultTheme = 'stark';

  /**
   * A user permed for administrating alt_text_validation.
   *
   * @var \Drupal\user\UserInterface
   */
  private $permedUser;

  /**
   * A non-permed user.
   *
   * @var \Drupal\user\UserInterface
   */
  private $normalUser;

  /**
   * Perform initial setup tasks that run before every test method.
   */
  public function setUp(): void {
    parent::setUp();
    $this->permedUser = $this->DrupalCreateUser([
      'administer dkan dataset archiver settings',
    ]);
    $this->normalUser = $this->DrupalCreateUser([]);
  }

  /**
   * Tests that the settings page can be reached with the right perms.
   */
  public function testSettingsPageExists(): void {
    $this->drupalLogin($this->permedUser);
    $this->drupalGet('admin/dkan/archiver');
    $this->assertSession()->statusCodeEquals(200);
    // Assert no warnings or errors.
    $this->assertSession()->statusMessageNotExists('warning');
    $this->assertSession()->statusMessageNotExists('error');
  }

  /**
   * Tests that the settings page can't be reached with without perms.
   */
  public function testSettingsPageAccessDenied(): void {
    $this->drupalLogin($this->normalUser);
    $this->drupalGet('admin/dkan/archiver');
    $this->assertSession()->statusCodeEquals(403);
  }

}
