<?php

namespace Drupal\Tests\dkan_dataset_archiver\Unit\Commands;

use Drupal\dkan_dataset_archiver\Drush\Commands\ArchiveCommands;
use Drupal\dkan_dataset_archiver\Service\ArchiveService;
use Drupal\dkan_dataset_archiver\Service\ProviderService;
use Drupal\Tests\dkan_dataset_archiver\Traits\ProviderTestTrait;
use MockChain\Chain;
use MockChain\Options;
use PHPUnit\Framework\TestCase;
use Symfony\Component\DependencyInjection\ContainerInterface;

/**
 * ArchiveCommands unit tests.
 *
 * @package Drupal\Tests\dkan_dataset_archiver\Unit\Commands
 */
class ArchiveCommandsTest extends TestCase {

  use ProviderTestTrait;

  /**
   * Test fetch().
   */
  public function testFetch() {

    $container = $this->getContainer()
      ->add(ArchiveService::class, 'fetch');

    $archiveCommands = ArchiveCommands::create($container->getMock());
    $archiveCommands->fetch();

    $this->assertTrue(TRUE);
  }

  /**
   * Test archiveProvider().
   */
  public function testArchiveProvider() {

    $container = $this->getContainer()
      ->add(ArchiveService::class, 'scheduleArchiving');

    $archiveCommands = ArchiveCommands::create($container->getMock());
    $archiveCommands->archiveProvider('foo,bar');

    $this->assertTrue(TRUE);
  }

  /**
   * Test createAnnualArchives().
   */
  public function testCreateAnnualArchives() {

    $container = $this->getContainer()
      ->add(ArchiveService::class, 'createAnnualArchives');

    $archiveCommands = ArchiveCommands::create($container->getMock());
    $archiveCommands->createAnnualArchives();

    $this->assertTrue(TRUE);
  }

  /**
   * Test currentArchive().
   */
  public function testCurrentArchive() {

    $container = $this->getContainer()
      ->add(ArchiveService::class, 'createDownloadAll');
    $archiveCommands = ArchiveCommands::create($container->getMock());
    $archiveCommands->currentArchive('foo,bar');

    $this->assertTrue(TRUE);
  }

  /**
   * Get container.
   */
  private function getContainer() {

    $mockProvider1 = $this->getProviderChain(['id' => 'foo'])->getMock();
    $mockProvider2 = $this->getProviderChain(['id' => 'bar'])->getMock();

    $options = (new Options())
      ->add('dkan_dataset_archiver.provider_service', ProviderService::class)
      ->add('dkan_dataset_archiver.archive_service', ArchiveService::class)
      ->index(0);

    return (new Chain($this))
      ->add(ContainerInterface::class, 'get', $options)
      ->add(ProviderService::class, 'get', [$mockProvider1, $mockProvider2]);
  }

}
