<?php

namespace Drupal\dkan_dataset_archiver\Service;

use Aws\Credentials\CredentialProvider;
use Aws\S3\S3Client;

/**
 * Aws S3 service.
 *
 * @package Drupal\dkan_dataset_archiver\Service
 */
class AwsS3Service {

  /**
   * S3 client.
   *
   * @var \Aws\S3\S3Client
   */
  private $client;

  /**
   * S3 client getter.
   *
   * @return \Aws\S3\S3Client
   *   S3 client.
   */
  public function getS3Client(): S3Client {

    if (!empty($this->client)) {
      $c = CredentialProvider::env();
      $composed = CredentialProvider::chain($c);
      /** @var \GuzzleHttp\Promise\Promise $promise */
      $promise = $composed();
      $awsCredentials = $promise->wait();
      $this->client = new S3Client([
        'version' => 'latest',
        'region' => 'us-east-1',
        'credentials' => $awsCredentials,
      ]);
      $this->client->registerStreamWrapper();
    }

    return $this->client;
  }

}
