<?php

namespace Drupal\dkan_dataset_archiver\FileFetcher;

use Contracts\FactoryInterface;
use Drupal\dkan_dataset_archiver\FileFetcher\Processor\S3;

/**
 * Factory to create file fetchers with S3 support.
 */
class FileFetcherFactory implements FactoryInterface {

  /**
   * The factory to decorate.
   *
   * @var \Contracts\FactoryInterface
   */
  private $factory;

  /**
   * Constructor.
   *
   * @param \Contracts\FactoryInterface $factory
   *   The factory to decorate.
   */
  public function __construct(FactoryInterface $factory) {
    $this->factory = $factory;
  }

  /**
   * {@inheritDoc}
   */
  public function getInstance(string $identifier, array $config = []) {
    $config['processors'] = array_merge(
      [S3::class],
      $config['processors'] ?? []
    );
    if (!isset($config['keep_original_filename'])) {
      $config['keep_original_filename'] = TRUE;
    }
    return $this->factory->getInstance($identifier, $config);
  }

}
