<?php

namespace Drupal\dkan_dataset_archiver_remote_storage\Hook;

use Drupal\Core\Config\ConfigFactoryInterface;
use Drupal\Core\DependencyInjection\ContainerInjectionInterface;
use Drupal\Core\Hook\Attribute\Hook;
use Drupal\Core\Routing\RouteMatchInterface;
use Drupal\Core\State\StateInterface;
use Drupal\dkan_dataset_archiver\Service\ArchiveService;
use Drupal\dkan_dataset_archiver\Service\Util;
use League\CommonMark\CommonMarkConverter;
use Psr\Log\LoggerInterface;
use Symfony\Component\DependencyInjection\ContainerInterface;

/**
 * Class CoreHooks.
 *
 * Contains hooks that are specific to Drupal core operations.
 */
class CoreHooks implements ContainerInjectionInterface {

  /**
   * The archive service.
   *
   * @var \Drupal\dkan_dataset_archiver\Service\ArchiveService
   */
  protected $archiveService;

  /**
   * The config factory service.
   *
   * @var \Drupal\Core\Config\ConfigFactoryInterface
   */
  protected $configFactory;

  /**
   * The dkan_dataset_archiver logger channel.
   *
   * @var \Psr\Log\LoggerInterface
   */
  protected $logger;

  /**
   * The state service.
   *
   * @var \Drupal\Core\State\StateInterface
   */
  protected $state;

  /**
   * Constructs a CoreHooks object.
   *
   * @param \Drupal\dkan_dataset_archiver\Service\ArchiveService $archive_service
   *   The dkan dataset archive service.
   * @param \Drupal\Core\Config\ConfigFactoryInterface $config_factory
   *   The config factory service.
   * @param \Psr\Log\LoggerInterface $logger
   *   The logger channel.
   * @param \Drupal\Core\State\StateInterface $state
   *   The state service.
   */
  public function __construct(
    ArchiveService $archive_service,
    ConfigFactoryInterface $config_factory,
    LoggerInterface $logger,
    StateInterface $state,
  ) {
    $this->archiveService = $archive_service;
    $this->configFactory = $config_factory;
    $this->logger = $logger;
    $this->state = $state;
  }

  /**
   * {@inheritdoc}
   */
  public static function create(ContainerInterface $container): self {
    return new static(
      $container->get('dkan_dataset_archiver.archive_service'),
      $container->get('config.factory'),
      $container->get('logger.channel.dkan_dataset_archiver'),
      $container->get('state'),
    );
  }

  /**
   * Implements hook_help().
   */
  #[Hook('help')]
  public static function help(string $route_name, RouteMatchInterface $route_match): string | NULL {
    // Check if the route name matches the help page.
    switch ($route_name) {
      case 'help.page.dkan_dataset_archiver_remote_storage':
        // Make a converter instance.
        $converter = new CommonMarkConverter([
          'html_input' => 'strip',
          'allow_unsafe_links' => FALSE,
        ]);
        $text = file_get_contents(__DIR__ . '/../../README.md');
        return $converter->convert($text);
    }
    return NULL;
  }

}
