<?php

namespace Drupal\dkan_dataset_archiver_remote_storage\Service;

use Drupal\Component\Uuid\Uuid;
use Drupal\Core\Config\ConfigFactoryInterface;
use Drupal\Core\Datetime\DrupalDateTime;
use Drupal\Core\DependencyInjection\ContainerInjectionInterface;
use Drupal\Core\Entity\EntityTypeManagerInterface;
use Drupal\Core\File\FileExists;
use Drupal\Core\File\FileSystemInterface;
use Drupal\Core\Queue\DelayedRequeueException;
use Drupal\Core\Queue\QueueFactory;
use Drupal\Core\Queue\SuspendQueueException;
use Drupal\datetime\Plugin\Field\FieldType\DateTimeItemInterface;
use Drupal\dkan_dataset_archiver_remote_storage\AwsS3Trait;
use Drupal\dkan_dataset_archiver\Entity\DdaArchiveInterface;
use Drupal\dkan_dataset_archiver\Service\Util;
use Drupal\dkan_dataset_archiver\HelperTrait;
use Drupal\dkan_dataset_archiver\Service\ArchiveService;
use Drupal\file\Entity\File;
use Drupal\file\FileInterface;
use Drupal\file\FileRepositoryInterface;
use Drupal\metastore_search\Search;
use Drupal\metastore\Storage\DataFactory;
use Drupal\metastore\Storage\NodeData;
use Drupal\node\NodeInterface;
use Procrastinator\Result;
use Psr\Log\LoggerInterface;
use Psr\Log\LogLevel;
use Symfony\Component\DependencyInjection\ContainerInterface;
use Symfony\Component\Finder\Finder;


/**
 * The Remote Storage Service.
 */
class RemoteStorageService implements ContainerInjectionInterface {
  use AwsS3Trait;

  /**
   * The archive service.
   *
   * @var \Drupal\dkan_dataset_archiver\Service\ArchiveService
   */
  protected $archiveService;

  /**
   * The entity type manager.
   *
   * @var \Drupal\Core\Entity\EntityTypeManagerInterface
   */
  protected $entityTypeManager;

  /**
   * The file repository service.
   *
   * @var \Drupal\file\FileRepositoryInterface
   */
  protected $fileRepository;

  /**
   * The file system service.
   *
   * @var \Drupal\Core\File\FileSystemInterface
   */
  protected $fileSystem;

  /**
   * The archiver settings.
   *
   * @var \Drupal\Core\Config\ImmutableConfig
   */
  protected $archiverSettings;

    /**
   * The dkan_dataset_archiver_remote_storage logger channel.
   *
   * @var \Psr\Log\LoggerInterface
   */
  protected $logger;

    /**
   * The queue factory.
   *
   * @var \Drupal\Core\Queue\QueueFactory
   */
  protected $queue;

/**
   * {@inheritDoc}
   *
   * @param \Drupal\dkan_dataset_archiver\Service\ArchiveService $archiveService
   *   The dkan_dataset_archiver archive service.
   * @param \Drupal\Core\Config\ConfigFactoryInterface $config_factory
   *   The config factory.
   * @param \Drupal\dkan_dataset_archiver\Service\Util $util
   *   Utility.
   * @param \Drupal\Core\Entity\EntityTypeManagerInterface $entityTypeManager
   *   The entity type manager.
   * @param \Drupal\file\FileRepositoryInterface $file_repository
   *   The file repository service.
   * @param \Drupal\Core\File\FileSystemInterface $file_system
   *   The file system service.
   * @param \Psr\Log\LoggerInterface $logger
   *   The dkan_dataset_archiver logger channel.
   * @param \Drupal\Core\Queue\QueueFactory $queue
   *   The queue factory.
   */
  public function __construct(
    ArchiveService $archiveService,
    ConfigFactoryInterface $config_factory,
    EntityTypeManagerInterface $entityTypeManager,
    FileRepositoryInterface $file_repository,
    FileSystemInterface $file_system,
    LoggerInterface $logger,
    QueueFactory $queue,
  ) {
    $this->archiveService = $archiveService;
    $this->queue = $queue;
    $this->logger = $logger;
    $this->entityTypeManager = $entityTypeManager;
    $this->fileRepository = $file_repository;
    $this->fileSystem = $file_system;
    $this->archiverSettings = $config_factory->get('dkan_dataset_archiver.settings');
  }

  /**
   * {@inheritDoc}
   */
  public static function create(ContainerInterface $container): self {
    return new static(
      $container->get('dkan_dataset_archiver.archive_service'),
      $container->get('config.factory'),
      $container->get('entity_type.manager'),
      $container->get('file.repository'),
      $container->get('file_system'),
      $container->get('logger.channel.dkan_dataset_archiver_remote_storage'),
      $container->get('queue'),
    );
  }

  /**
   * Add an archive to the remote file sync queue.
   *
   * @param \Drupal\dkan_dataset_archiver\Entity\DdaArchiveInterface $archive
   *   The archive entity.
   */
  public function addToRemoteFileSyncQueue(DdaArchiveInterface $archive): void {
    if (in_array($this->archiverSettings->get('storage_locations'), ['remote', 'local_and_remote'])) {
      $data = [
        'archive_id' => $archive->id(),
        'title' => $archive->getName(),
      ];
      /** @var \Drupal\Core\Queue\QueueInterface $remoteFileSyncQueue */
      $remoteFileSyncQueue = $this->queue->get('archive_remote_file_sync');
      // @todo Consider checking to see if the file actually changed.
      $queue_id = $remoteFileSyncQueue->createItem($data);
      $this->logger->info(
        "Archive '@title' (ID: @id) queued for remote file sync, queue_id: %queueId", [
          '@title' => $archive->getName(),
          '@id' => $archive->id(),
          '%queueId' => $queue_id,
        ]
      );
    }
  }

/**
   * Sync files to Remote.
   *
   * @param array $data
   *  Array with archive id.
   */
  public function syncToRemote(array $data): void {
    if (!$this->canSync()) {
      // Sync is not enabled, so bail out silently.
      return;
    }

    $remote_type = $this->archiverSettings->get('remote_type');
    $remote_address = $this->archiverSettings->get('remote_address');
    // Sort out what kind of remote.  Currently only supports AWS, but the
    // structure is here to expand.
    switch (TRUE) {
      case ($remote_type === 'aws:s3' && !empty($remote_address)):
        $this->s3Bucket = str_replace('s3://', '', $remote_address);
        $fileSystem = $this->getAwsS3Filesystem();
        break;

      case (empty($remote_address)):
        $this->logger->error('Remote address not set for remote sync. Unable to sync.');
        throw new SuspendQueueException("Remote address not set for remote sync. Unable to sync.");
        return;

      default:
        $this->logger->error('Remote type @type not supported for remote sync.', ['@type' => $remote_type]);
        throw new \Exception("Remote type $remote_type not supported for remote sync.");
        return;

    }
    // Load the archive from data.
    $archive_id = $data['archive_id'] ?? NULL;
    $storage = $this->entityTypeManager->getStorage('dda_archive');
    /** @var \Drupal\dkan_dataset_archiver\Entity\DdaArchiveInterface $archive */
    $archive = $storage->load($archive_id);
    // Get the files.
     $file_base = ($archive->isPrivate()) ? Util::getDrupalPrivateFilesDirectory() : Util::getDrupalPublicFilesDirectory();
     $resource_files = $archive->getResourceFileItems();
    // Grab and alter the paths.
    foreach ($resource_files as $resource_file) {
      /** @var \Drupal\file\FileInterface $resource_file */
      $local_file_path = "{$resource_file->getFileUri()}";
      // NEED TO SET $this->s3Bucket to the bucket.


      $destination = $local_file_path;

      $destination = str_replace(['public://', 'private://'], "/", $destination);
      //$destination = str_replace(['public://', 'private://'], "{$remote_address}/", $destination);
      // Adjust for private or public destination.
      $replacement = ($archive->isPrivate()) ? '/dataset_archives/private/' : '/dataset_archives/public/';
      $destination = str_replace(['/dataset-archives/private/', '/dataset-archives/'], $replacement, $destination);
  //@todo LEFT OFF HERE!!!!!
      // Get original file timestamp.
      $original_timestamp = filemtime($local_file_path);


       // @todo this is not right.  Disconnected.
  //    $stream = fopen($destination, 'w');
   //   stream_set_chunk_size($stream, 10 * 1000 * 1000);
     // $fileSystem->copy($local_file_path, $destination);
    $success =  $fileSystem->putStream($destination, fopen($local_file_path, 'r'));
  //    $success = copy($local_file_path, $destination);
      $booga=TRUE;
   //   fclose($stream);
      if (!$success) {
        $this->logger->error(
          'Failed to copy file from %source to %destination for archive ID: @id.', [
            '%source' => $local_file_path,
            '%destination' => $destination,
            '@id' => $archive_id,
          ]
        );
      }
      else {
        // Apply the original file timestamp to the new file.
        if ($original_timestamp) {
          // @todo touch is not supported by aws :(
         // touch($destination, $original_timestamp);
        }

        $this->logger->notice(
          'Successfully copied file from %source to %destination for archive ID: @id.', [
            '%source' => $local_file_path,
            '%destination' => $destination,
            '@id' => $archive_id,
          ]
        );
      }

    // DO we ned this>?  fclose($stream);
      // VALIDATE THE COPY SUCCEEDED.

    // Copy them each to the remote.
    }

    // @todo Optionally remove local files if sync was successful.
    if ($this->archiverSettings->get('storage_locations') === 'remote') {
      // Remove local files from the archive .

      // Remove local files from the filesystem.

    }

    // @todo save the archive with the new locations added.
    // Add a meaningful revision message.  (somehow keep this save from triggering a a new sync)
  }

  /**
   * Determine if remote sync is possible.
   *
   * @return bool
   *   TRUE if remote sync can occur.
   */
  protected function canSync (): bool {
    $remote_sync = $this->archiverSettings->get('storage_locations');
    $remote_allowed = in_array($remote_sync, ['remote', 'local_and_remote']);
    return $remote_allowed;
  }
}
