There is a problem with dkan core not playing nice with the [project_composer](https://www.drupal.org/project/project_composer) and its inability to find dkan core's sub-modules.

The problem is identified in this [github discussion](https://github.com/GetDKAN/dkan/discussions/4149). Unfortunately, until dkan core is released on Drupal.org, this problem necessitates a patching solution.

If your sites docroot is named 'docroot' this might work correctly.

## How to know if it worked?
If you examine the dkan_dataset_archiver.info.yml you should see several dependencies for dkan. If you do not see them, the patch failed.

## What if it did not work?
 Quite likely your path to the module did not match `docroot/modules/contrib/dkan_dataset_archiver` so the patch could not be found.  You will need to add the patches entry from this module's composer.json to your own root level composer.json and will have to adjust the location of the patch to match your site. Unfortunately, the patch from this module will fail, even though your local patches will work. The fail creates noise but will fail catastrophically if you do not have the following line in your composer.json within the 'extra' element.

 `"composer-exit-on-patch-failure": false,`

 If composer will just not play nicely, the other temporary option is to download the module and add it to your custom modules directory and patch it manually.  None of this is ideal and  hopefully will be resolved soon in DKAN Core.
