<?php

namespace Drupal\dkan_dataset_archiver\Drush\Commands;

use Drupal\Core\Utility\Token;
use Drupal\dkan_dataset_archiver\Service\ArchiveService;
use Drush\Attributes as CLI;
use Drush\Commands\DrushCommands;
use Symfony\Component\DependencyInjection\ContainerInterface;

/**
 * A Drush command file.
 */
final class DkanDatasetArchiverCommands extends DrushCommands {

  /**
   * The archive service.
   *
   * @var \Drupal\dkan_dataset_archiver\Service\ArchiveService
   */
  private $archiveService;

  /**
   * Constructs a DkanDatasetArchiverCommands object.
   */
  public function __construct(
    private Token $token,
    private ArchiveService $dkanDatasetArchiverArchiveService,
  ) {
    parent::__construct();
    $this->archiveService = $dkanDatasetArchiverArchiveService;
  }

  /**
   * {@inheritdoc}
   */
  public static function create(ContainerInterface $container) {
    return new static(
      $container->get('token'),
      $container->get('dkan_dataset_archiver.archive_service'),
    );
  }

  /**
   * Command description here.
   */
  #[CLI\Command(name: 'dkan_dataset_archiver:create-annual')]
  #[CLI\Usage(name: 'dkan_dataset_archiver:create-annual', description: "ONLY FOR DEVELOPMENT AND TESTING: Generates this year's annual archives.")]
  public function createAnnual() {
    $io = $this->io();

    if ($io->confirm(dt('This should only be run for testing, not on Production. Prematurely generate annual dataset archives?'))) {
      // User confirmed, proceed with deletion logic.
      $io->success(dt('Queueing annual archives.'));
      $this->archiveService->queueAnnualArchives('individual');
      $this->logger()->success(dt('Queueing keyword annual archives.'));
      $this->archiveService->queueAnnualArchives('aggregate', 'keyword');
      $this->logger()->success(dt('Queueing theme annual archives.'));
      $this->archiveService->queueAnnualArchives('aggregate', 'theme');
      $this->logger()->success(dt('Queueing of annuals complete.'));
      $this->logger()->success(dt('You must now run "drush cron".'));
    }
    else {
      $io->warning(dt('Annual archive creation cancelled.'));
    }
  }

}
