<?php

namespace Drupal\dkan_dataset_archiver\Plugin\QueueWorker;

use Drupal\Core\Plugin\ContainerFactoryPluginInterface;
use Drupal\Core\Queue\Attribute\QueueWorker;
use Drupal\Core\Queue\QueueWorkerBase;
use Drupal\Core\StringTranslation\TranslatableMarkup;
use Drupal\dkan_dataset_archiver\Service\ArchiveService;
use Symfony\Component\DependencyInjection\ContainerInterface;

/**
 * Defines 'individual_zips' queue worker.
 *
 * @todo Determine if we even need this.
 */
#[QueueWorker(
  id: 'individual_zips',
  title: new TranslatableMarkup('Make individual zips.'),
  cron: ['time' => 90]
)]
class IndividualZips extends QueueWorkerBase  implements ContainerFactoryPluginInterface {

  /**
   * The archive service.
   *
   * @var \Drupal\dkan_dataset_archiver\Service\ArchiveService
   */
  protected $archiveService;

  /**
   * Constructs an IndividualZips object.
   * @param array $configuration
   *   A configuration array containing information about the plugin instance.
   * @param string $plugin_id
   *   The plugin ID for the plugin instance.
   * @param mixed $plugin_definition
   *   The plugin implementation definition.
   * @param \Drupal\dkan_dataset_archiver\Service\ArchiveService $archive_service
   *   The archive service.
   */
  public function __construct(array $configuration, $plugin_id, $plugin_definition, ArchiveService $archiveService) {
    parent::__construct($configuration, $plugin_id, $plugin_definition);
    $this->archiveService = $archiveService;
  }

  /**
   * {@inheritdoc}
   */
  public static function create(ContainerInterface $container, array $configuration, $plugin_id, $plugin_definition): self {
    return new static(
      $configuration,
      $plugin_id,
      $plugin_definition,
      $container->get('dkan_dataset_archiver.archive_service')
    );
  }

  /**
   * {@inheritdoc}
   */
  public function processItem($data): void {
    $this->archiveService->createIndividualZip($data);
  }

}
