<?php

namespace Drupal\dkan_dataset_archiver\Hook;

use Drupal\Core\Hook\Attribute\Hook;
use Drupal\Core\Routing\RouteMatchInterface;
use League\CommonMark\CommonMarkConverter;

/**
 * Class CoreHooks.
 *
 * Contains hooks that are specific to Drupal core operations.
 */
class CoreHooks {

  /**
   * Implements hook_help().
   */
  #[Hook('help')]
  public static function help(string $route_name, RouteMatchInterface $route_match): string | NULL {
    // Check if the route name matches the help page.
    switch ($route_name) {
      case 'help.page.dkan_dataset_archiver':
        // Make a converter instance.
        $converter = new CommonMarkConverter([
          'html_input' => 'strip',
          'allow_unsafe_links' => FALSE,
        ]);
        $text = file_get_contents(__DIR__ . '/../../README.md');
        return $converter->convert($text);
    }
    return NULL;
  }

}
