<?php

namespace Drupal\dkan_dataset_archiver\Plugin\QueueWorker;

use Drupal\Core\Queue\Attribute\QueueWorker;
use Drupal\Core\Queue\QueueWorkerBase;
use Drupal\Core\StringTranslation\TranslatableMarkup;
use Drupal\dkan_dataset_archiver\Service\ArchiveService;
use Symfony\Component\DependencyInjection\ContainerInterface;

/**
 * Defines 'archive_provider' queue worker.
 */
#[QueueWorker(
  id: 'archive_provider',
  title: new TranslatableMarkup('Archive current files for a provider.'),
  cron: ['time' => 30]
)]
class ArchiveProvider extends QueueWorkerBase {

  /**
   * The archive service.
   *
   * @var \Drupal\dkan_dataset_archiver\Service\ArchiveService
   */
  protected $archiveService;

  /**
   * Constructs a new ArchiveProvider object.
   *
   * @param \Drupal\dkan_dataset_archiver\Service\ArchiveService $archiveService
   *   The archive service.
   */
  public function __construct(ArchiveService $archiveService) {
    $this->archiveService = $archiveService;
  }

  /**
   * {@inheritdoc}
   */
  public static function create(ContainerInterface $container): self {
    return new static(
      $container->get('dkan_dataset_archiver.archive_service')
    );
  }

  /**
   * {@inheritdoc}
   */
  public function processItem($data): void {
    $this->archiveService->runArchiving($data);
  }

}
