<?php

namespace Drupal\Tests\dkan_dataset_archiver\Functional;

use Drupal\Tests\BrowserTestBase;

/**
 * Test our AWS S3 service.
 *
 * @package Drupal\dkan_dataset_archiver\Tests\Functional
 */
class AwsS3ServiceTest extends BrowserTestBase {

  /**
   * {@inheritdoc}
   */
  protected static $modules = [
    'dkan_dataset_archiver',
  ];

  /**
   * {@inheritdoc}
   */
  protected $defaultTheme = 'stark';

  /**
   * Test our getter.
   */
  public function testGetS3Client() {
    /** @var \Drupal\dkan_dataset_archiver\Service\AwsS3Service $awsS3 */
    $awsS3 = $this->container->get('dkan_dataset_archiver.aws_s3_service');

    $client = $awsS3->getS3Client();
    $this->assertEquals('Aws\S3\S3Client', get_class($client));
  }

}
