<?php

namespace Drupal\dkan_dataset_archiver;

use Drupal\Core\Site\Settings;
use Drupal\dkan_dataset_archiver\FileFetcher\Processor\S3;
use Drupal\dkan_dataset_archiver\Service\Util;
use Procrastinator\Result;

/**
 * A trait with helpers for file fetching.
 */
trait HelperTrait {

  /**
   * Keep track of S3 file URLs used during a request.
   */
  private array $s3FileUrls = [];

  /**
   * No idea what this does @todo figure it out and document it.
   */
  public function reset(): void {
    // Remove file_fetcher jobs.
    foreach ($this->s3FileUrls as $s3FileUrl) {
      $fileFetcher = $this->getFileFetcher($s3FileUrl);
      $path = $fileFetcher->getStateProperty('destination');
      if (file_exists($path)) {
        unlink($path);
      }
      $store = $fileFetcher->storage;
      if ($store) {
        $store->remove($fileFetcher->identifier);
      }
    }
  }

  /**
   * No idea what this does @todo figure it out and document it.
   */
  private function getFileFetcher($s3FileUrl, $destination = NULL, $keepOriginalFilename = TRUE) {

    if (!isset($destination)) {
      $destination = Settings::get('file_temp_path');
      if (!$destination) {
        $destination = getenv('AH_SITE_ENVIRONMENT') ? '/mnt/tmp' : '/tmp';
      }
      // Append the full path in the case of a test run.
      elseif (str_contains($destination, 'simpletest')) {
        $destination = '/var/www/html/docroot/' . $destination;
      }
    }

    $this->s3FileUrls[] = $s3FileUrl;
    $identifier = Util::machinize($s3FileUrl);

    $config = [
      'filePath' => $s3FileUrl,
      'processors' => [S3::class],
      'temporaryDirectory' => $destination,
      'keep_original_filename' => $keepOriginalFilename,
    ];

    // @todo Dependency inject this service.
    /** @var \Contracts\FactoryInterface $fileFetcherFactory */
    $fileFetcherFactory = \Drupal::service('dkan.common.file_fetcher');
    return $fileFetcherFactory->getInstance($identifier, $config);
  }

  /**
   * Figure out what this does and document it. @todo.
   *
   * @param string $path
   *   Path to JSON file.
   *
   * @return string
   *   Decoded JSON data.
   */
  private function getJsonData($path): string {
    $dataJson = file_get_contents($path);
    // $dataJson = mb_convert_encoding($dataJson, 'UTF-8', mb_list_encodings());
    return json_decode($dataJson);
  }

  /**
   * Figure out what this does and document it. @todo.
   *
   * @param mixed $data
   *   Data to include in the result.
   */
  private function getResultWithData($data): Result {
    $result = new Result();
    $result->setStatus(Result::DONE);
    $result->setData(json_encode($data));
    return $result;
  }

  /**
   * Figure out what this does and document it. @todo.
   *
   * @param array $results
   *   Results @todo say more.
   * @param array $errors
   *   Errors @todo say more.
   *
   * @return \Procrastinator\Result
   *   Result object.
   */
  private function createResultFromResults(array $results, array $errors): Result {
    $result = new Result();
    $status = !empty($this->errors) ? Result::ERROR : Result::DONE;
    $result->setStatus($status);

    $data = json_encode(array_map(function (string $string) {
      return json_decode($string);
    }, array_filter(array_map(function (Result $result) {
      return $result->getData();
    }, $results), function ($string) {
      return !empty($string);
    })));
    $result->setData($data);

    $ids = [];
    $errorMessages = array_map(function (Result $result) use (&$ids) {
      $error = $result->getError();
      $parts = explode('#', $error);
      if (count($parts) >= 2) {
        $error = trim($parts[0]);
        $ids[md5($error)][] = trim($parts[1]);
      }
      return $error;
    }, $errors);

    $finalErrorMessages = [];
    $errorMessagesCount = array_count_values($errorMessages);
    foreach ($errorMessagesCount as $message => $total) {
      $suffix = ($total > 1) ? " (x{$total})" : '';

      if (isset($ids[md5($message)])) {
        $my_ids = array_slice($ids[md5($message)], 0, 3);
        $suffix .= ' #' . implode(',', $my_ids);
      }
      $finalErrorMessages[] = $message . $suffix;
    }

    $error = implode(PHP_EOL, $finalErrorMessages);
    $result->setError($error);

    return $result;
  }

}
