<?php

namespace Drupal\dkan_dataset_archiver;

use Drupal\Core\Access\AccessResult;
use Drupal\Core\Entity\EntityAccessControlHandler;
use Drupal\Core\Entity\EntityInterface;
use Drupal\Core\Session\AccountInterface;

/**
 * Access controller for the DdaArchive entity.
 *
 * @see \Drupal\dkan_dataset_archiver\Entity\DdaArchive.
 */
class DdaArchiveAccessControlHandler extends EntityAccessControlHandler {

  /**
   * {@inheritdoc}
   */
  protected function checkAccess(EntityInterface $entity, $operation, AccountInterface $account) {
    /** @var \Drupal\dkan_dataset_archiver\Entity\DdaArchiveInterface $entity */
    switch ($operation) {
      case 'view':
        if (!$entity->isPublished()) {
          return AccessResult::allowedIfHasPermission($account, 'view unpublished dataset archive');
        }
        if ($entity->get('private')->value) {
          return AccessResult::allowedIfHasPermission($account, 'view private dataset archive');
        }
        return AccessResult::allowedIfHasPermission($account, 'view dataset archive');

      case 'update':
        return AccessResult::allowedIfHasPermission($account, 'edit dataset archive');

      case 'delete':
        return AccessResult::allowedIfHasPermission($account, 'delete dataset archive');
    }

    // Unknown operation, no opinion.
    return AccessResult::neutral();
  }

  /**
   * {@inheritdoc}
   */
  protected function checkCreateAccess(AccountInterface $account, array $context, $entity_bundle = NULL) {
    return AccessResult::allowedIfHasPermission($account, 'add dataset archive');
  }

}
