<?php

namespace Drupal\dkan_dataset_archiver\Plugin\QueueWorker;

use Drupal\Core\Queue\Attribute\QueueWorker;
use Drupal\Core\Queue\QueueWorkerBase;
use Drupal\Core\StringTranslation\TranslatableMarkup;
use Drupal\dkan_dataset_archiver\Service\ArchiveService;
use Symfony\Component\DependencyInjection\ContainerInterface;

/**
 * Defines 'backup_to_s3' queue worker.
 */
#[QueueWorker(
  id: 'backup_to_s3',
  title: new TranslatableMarkup('Backup a local file to S3.'),
  cron: ['time' => 30]
)]
class BackupToS3 extends QueueWorkerBase {

  /**
   * The archive service.
   *
   * @var \Drupal\dkan_dataset_archiver\Service\ArchiveService
   */
  protected $archiveService;

  /**
   * Constructs a BackupToS3 object.
   *
   * @param \Drupal\dkan_dataset_archiver\Service\ArchiveService $archiveService
   *   The archive service.
   */
  public function __construct(ArchiveService $archiveService) {
    $this->archiveService = $archiveService;
  }

  /**
   * {@inheritdoc}
   */
  public static function create(ContainerInterface $container): self {
    return new static(
      $container->get('dkan_dataset_archiver.archive_service')
    );
  }

  /**
   * {@inheritDoc}
   */
  public function processItem($data): void {
    $this->archiveService->backupToS3($data);
  }

}
