<?php

namespace Drupal\Tests\dkan_dataset_archiver\Functional;

use Drupal\Tests\BrowserTestBase;

/**
 * Test our AWS S3 service.
 *
 * @package Drupal\dkan_dataset_archiver\Tests\Functional
 */
class AwsS3ServiceTest extends BrowserTestBase {

  /**
   * {@inheritdoc}
   */
  protected static $modules = [
    'common',
    'dkan_dataset_archiver_remote_storage',
    'dkan_dataset_archiver',
    'field',
    'file',
    'link',
    'metastore_search',
    'metastore',
    'options',
    'user',
    'views',
  ];

  /**
   * {@inheritdoc}
   */
  protected $defaultTheme = 'stark';

  /**
   * Perform initial setup tasks that run before every test method.
   */
  public function setUp(): void {
    parent::setUp();

    // Adjust Enable the various archiving options that have endpoints.
    $this->config('dkan_dataset_archiver.settings')
      ->set('archive_by_keyword', TRUE)
      ->set('archive_by_theme', TRUE)
      ->set('create_current_download', TRUE)
      ->set('create_annual_archives', TRUE)
      ->set('storage_locations', 'local_and_remote')
      ->set('remote_type', 'aws:s3')
      ->set('remote_region', 'us-east-1')
      ->set('remote_address', 'S3://no-real-bucket')
      ->save();
    putenv("AWS_ACCESS_KEY_ID=some_value");
    $_ENV['AWS_ACCESS_KEY_ID'] = 'some_value';

    putenv("AWS_SECRET_ACCESS_KEY=some_value");
    $_ENV['AWS_SECRET_ACCESS_KEY'] = 'some_value';
  }

  /**
   * Test our getter.
   */
  public function testGetS3Client() {
    /** @var \Drupal\dkan_dataset_archiver_remote_storage\Service\AwsS3Service $awsS3 */
    $awsS3 = $this->container->get('dkan_dataset_archiver_remote_storage.aws_s3_service');

    $client = $awsS3->getS3Client();
    $this->assertEquals('Aws\S3\S3Client', get_class($client));
  }

}
