<?php

namespace Drupal\Tests\dkan_dataset_archiver\Unit\Commands {

  use Drupal\Core\Config\ConfigFactoryInterface;
  use Drupal\Core\Config\ImmutableConfig;
  use Drupal\Core\Entity\EntityTypeManager;
  use Drupal\Core\Language\LanguageInterface;
  use Drupal\Core\Language\LanguageManager;
  use Drupal\Core\Utility\Token;
  use Drupal\dkan_dataset_archiver\Drush\Commands\DkanDatasetArchiverCommands;
  use Drupal\dkan_dataset_archiver\Service\ArchiveService;
  use Drupal\file\FileRepositoryInterface;
  use Drupal\Tests\dkan_dataset_archiver\Traits\LoggerTestTrait;
  use Drupal\Tests\UnitTestCase;
  use League\Flysystem\Filesystem;
  use MockChain\Chain;
  use MockChain\Options;
  use Psr\Log\LoggerInterface;
  use Symfony\Component\DependencyInjection\ContainerBuilder;
  use Symfony\Component\DependencyInjection\ContainerInterface;

  /**
   * DkanDatasetArchiverCommands unit tests.
   *
   * @package Drupal\Tests\dkan_dataset_archiver\Unit\Commands
   */
  class ArchiverCommandsTest extends UnitTestCase {
    use LoggerTestTrait;

    /**
     * {@inheritdoc}
     */
    protected function setUp(): void {
      parent::setUp();
      $container = $this->createMock(ContainerInterface::class);
      $configArchiverSettings = $this->getMockBuilder(ImmutableConfig::class)
        ->disableOriginalConstructor()
        ->getMock();
      $configArchiverSettings->method('get')->willReturnMap([
        ['archive_years_retained', 5],
        ['create_annual_archives', TRUE],
        ['archive', '1'],
        ['aggregation_delay', 0],
      ]);
      $configDateSettings = $this->getMockBuilder(ImmutableConfig::class)
        ->disableOriginalConstructor()
        ->getMock();
      $configDateSettings->method('get')->willReturnMap([
        ['timezone', NULL],
      ]);
      $configFactory = $this->createMock(ConfigFactoryInterface::class);

      $configFactory->method('get')->willReturnMap([
        ['system.date', $configDateSettings],
        ['dkan_dataset_archiver.settings', $configArchiverSettings],
      ]);
      $languageManager = $this->createMock(LanguageManager::class);
      $languageInterface = $this->createMock(LanguageInterface::class);
      $languageInterface
        ->expects($this->any())
        ->method('getId')
        ->willReturn('en');
      $languageManager->method('getCurrentLanguage')->willReturn($languageInterface);

      $container->method('get')
        ->willReturnMap([
          ['dkan_dataset_archiver.archive_service', $this->createMock(ArchiveService::class)],
          ['entity_type.manager', $this->createMock(EntityTypeManager::class)],
          ['language_manager', $languageManager],
          ['config.factory', $configFactory],
          ['file.repository', $this->createMock(FileRepositoryInterface::class)],
          ['token', $this->createMock(Token::class)],
          [
            'logger.channel.dkan_dataset_archiver',
            $this->getLoggerChain(TRUE)->getMock()->get('logger.channel.dkan_dataset_archiver'),
          ],
          ['dkan_dataset_archiver.filesystem', $this->createMock(Filesystem::class)],
          ['drush.style', $this->getMockBuilder('\Drush\Style\DrushStyle')->disableOriginalConstructor()->getMock()],
        ]);

      \Drupal::setContainer($container);
    }

    /**
     * Test createAnnualArchives().
     */
    public function testCreateAnnualArchives() {
      $archiveCommands = DkanDatasetArchiverCommands::create(\Drupal::getContainer());
      $archiveCommands->createAnnual();
      // Basically asserts that it got this far without error.
      $this->assertTrue(TRUE);
    }

    /**
     * Test createCurrent().
     */
    public function testCreateCurrent() {
      $archiveCommands = DkanDatasetArchiverCommands::create(\Drupal::getContainer());
      $archiveCommands->createCurrent();
      // Basically asserts that it got this far without error.
      $this->assertTrue(TRUE);
    }

  }

}

namespace Drush\Style {

  use Symfony\Component\Console\Style\SymfonyStyle;

  if (!class_exists('\Drush\Style\DrushStyle')) {
    /**
     * DkanDatasetArchiverCommands unit tests.
     *
     * This exists only to cover the DrushStyle class used in the commands test.
     * Yes it is an embarrassing shim to get tests running.
     */
    class DrushStyle extends SymfonyStyle {}
  }

}

namespace {
  if (!function_exists('dt')) {

    /**
     * Helper function to test Helper\Storage::getVersion.
     *
     * Rudimentary translation system, akin to Drupal's t() function.
     *
     * @param string $message
     *   String to process, possibly with replacement item.
     * @param array $replace
     *   An associative array of replacement items.
     *
     * @return string
     *   The processed string for a message.
     */
    function dt(string $message, array $replace = []): string {
      return strtr($message, $replace);
    }

  }

}
