<?php

namespace Drupal\Tests\dkan_dataset_archiver\Traits;

use Drupal\Core\Logger\LoggerChannelFactory;
use Drupal\Core\Logger\LoggerChannelInterface;
use MockChain\Chain;

/**
 * Trait for using logger within tests.
 *
 * @package Drupal\Tests\dkan_dataset_archiver\Traits
 */
trait LoggerTestTrait {

  /**
   * Logger chain.
   *
   * @var \MockChain\Chain
   */
  protected Chain $loggerChain;

  /**
   * Instantiate and get the logger chain.
   *
   * @param bool $reset
   *   Whether to reset the logger chain.
   *
   * @return \MockChain\Chain
   *   The logger chain.
   */
  private function getLoggerChain($reset = FALSE): Chain {
    if (empty($this->loggerChain) || $reset === TRUE) {
      $this->loggerChain = (new Chain($this))
        ->add(LoggerChannelFactory::class, 'get', LoggerChannelInterface::class, 'names')
        ->add(LoggerChannelInterface::class, 'log', NULL, 'logs')
        ->addd('error', NULL, 'errors')
        ->addd('warning', NULL, 'warnings')
        ->addd('notice', NULL, 'notices');

    }
    return $this->loggerChain;
  }

}
