<?php

namespace Drupal\Tests\dkan_dataset_archiver\Unit\Util;

use Drupal\Core\DependencyInjection\ContainerBuilder;
use Drupal\dkan_dataset_archiver\Service\Util;
use Drupal\Tests\UnitTestCase;

/**
 * Tests for Util.
 *
 * @group dkan_dataset_archiver
 */
class UtilTest extends UnitTestCase {

  /**
   * Setup the container.
   */
  protected function setUp(): void {
    parent::setUp();
    $container = new ContainerBuilder();
    $config_factory = $this->getConfigFactoryStub([
      'dkan_dataset_archiver.settings' => [
        'archive_private' => 'in_public',
      ],
    ]);
    $container->set('config.factory', $config_factory);
    \Drupal::setContainer($container);
  }

  /**
   * Test deduceLocaleFileStream with various URL formats.
   *
   * @dataProvider provideUrlVariations
   */
  public function testDeduceLocaleFileStream($file_url, $private, $expected) {
    $result = Util::deduceLocaleFileStream($file_url, $private);
    $this->assertEquals($expected, $result, 'Local file stream deduction failed.');
  }

  /**
   * Data provider for testDeduceLocaleFileStream.
   *
   * @return array
   *   Array of test cases with URL, private flag, and expected result.
   */
  public function provideUrlVariations() {
    return [
      // Test 1: Public URL with /sites/ and /files/.
      [
        'http://example.com/sites/default/files/document.csv',
        FALSE,
        'public://document.csv',
      ],
      // Test 2: Public URL with /site/ (singular) and /files/.
      [
        'http://example.com/site/files/archive.zip',
        FALSE,
        'public://archive.zip',
      ],
      // Test 3: Private URL with /sites/ and /files/.
      [
        'http://example.com/sites/default/files/non-private-doc.pdf',
        FALSE,
        'public://non-private-doc.pdf',
      ],
      // Test 4: URL with nested path after /files/.
      [
        'http://example.com/sites/default/files/nested/path/document.csv',
        FALSE,
        'public://nested/path/document.csv',
      ],
      // Test 5: URL without /site or /sites/ (should return NULL).
      [
        'http://example.com/downloads/document.csv',
        FALSE,
        NULL,
      ],
    ];
  }

}
