<?php

namespace Drupal\dkan_dataset_archiver\Event;

use Drupal\Component\EventDispatcher\Event;
use Drupal\dkan_dataset_archiver\Entity\DdaArchive;

/**
 * Event triggered when a dataset archive is saved.
 */
class ArchivePostSaveEvent extends Event {
  const EVENT_NAME = 'dkan_dataset_archiver.archive_post_save';

  /**
   * The DdaArchive object.
   *
   * @var \Drupal\dkan_dataset_archiver\Entity\DdaArchive
   */
  protected $archive;

  /**
   * Constructs a new ArchiveSave event.
   *
   * @param \Drupal\dkan_dataset_archiver\Entity\DdaArchive $archive
   *   The DdaArchive object.
   */
  public function __construct(DdaArchive $archive) {
    $this->archive = $archive;
  }

  /**
   * Gets the DdaArchive object.
   *
   * @return \Drupal\dkan_dataset_archiver\Entity\DdaArchive
   *   The DdaArchive object.
   */
  public function getArchive(): DdaArchive {
    return $this->archive;
  }

}
