<?php

namespace Drupal\Tests\dkan_dataset_archiver\Unit\Controller;

use Drupal\Core\Cache\CacheBackendInterface;
use Drupal\Core\Config\ConfigFactoryInterface;
use Drupal\Core\Entity\EntityTypeManager;
use Drupal\Core\File\FileSystem as DrupalFileSystem;
use Drupal\Core\StreamWrapper\StreamWrapperManager;
use Drupal\dkan_dataset_archiver\Controller\ArchiveApiController;
use Drupal\file\FileRepositoryInterface;
use Drupal\Tests\dkan_dataset_archiver\Traits\LoggerTestTrait;
use League\Flysystem\Filesystem as LeagueFilesystem;
use MockChain\Chain;
use MockChain\Options;
use PHPUnit\Framework\TestCase;
use Symfony\Component\DependencyInjection\ContainerInterface;

/**
 * Test for ArchiveApiController.
 */
class ArchiveApiControllerTest extends TestCase {
  use LoggerTestTrait;

  /**
   * Test of the file system.
   */
  public function testSetFileSystem() {
    $container = $this->getContainer()->getMock();
    \Drupal::setContainer($container);
    $mockFileSystem = (new Chain($this))
      ->add(LeagueFilesystem::class)
      ->getMock();

    $archiveController = ArchiveApiController::create($container);
    $archiveController->setFileSystem($mockFileSystem);

    $this->assertTrue(TRUE);
  }

  /**
   * Get a mock container with commonly used services.
   *
   * @return \MockChain\Chain
   *   The mock container.
   */
  private function getContainer(): Chain {
    $options = (new Options())
      ->add('file_system', DrupalFileSystem::class)
      ->add('stream_wrapper_manager', StreamWrapperManager::class)
      ->add('cache.default', CacheBackendInterface::class)
      ->add('logger.channel.dkan_dataset_archiver', $this->getLoggerChain(TRUE)->getMock()->get('logger.channel.dkan_dataset_archiver'))
      ->add('config.factory', $this->createMock(ConfigFactoryInterface::class))
      ->add('entity_type.manager', EntityTypeManager::class)
      ->add('file.repository', FileRepositoryInterface::class)

      ->index(0);

    return (new Chain($this))
      ->add(ContainerInterface::class, 'get', $options)
      ->add(DrupalFileSystem::class, 'realPath', __DIR__ . '/../../../files')
      ->add(CacheBackendInterface::class, 'get', FALSE);
  }

}
