<?php

namespace Drupal\dkan_dataset_archiver\Form;

use Drupal\Core\Form\ConfirmFormBase;
use Drupal\Core\Form\FormStateInterface;
use Drupal\Core\Url;

/**
 * Provides a confirmation form for deleting a dataset archive revision.
 */
class DdaArchiveRevisionDeleteForm extends ConfirmFormBase {

  /**
   * The revision ID to delete.
   *
   * @var int
   */
  protected $revisionId;

  /**
   * {@inheritdoc}
   */
  public function getFormId() {
    return 'dda_archive_revision_delete_form';
  }

  /**
   * {@inheritdoc}
   */
  public function getQuestion() {
    return $this->t('Are you sure you want to delete this archive revision?');
  }

  /**
   * {@inheritdoc}
   */
  public function getCancelUrl() {
    return new Url('dkan_dataset_archiver.archive_revisions');
  }

  /**
   * {@inheritdoc}
   */
  public function getConfirmText() {
    return $this->t('Delete');
  }

  /**
   * {@inheritdoc}
   */
  public function buildForm(array $form, FormStateInterface $form_state, $revision_id = NULL) {
    $this->revisionId = $revision_id;
    return parent::buildForm($form, $form_state);
  }

  /**
   * {@inheritdoc}
   */
  public function submitForm(array &$form, FormStateInterface $form_state) {
    // Add logic to delete the revision here.
    // Example: \Drupal::service('dkan_dataset_archiver.archive_manager')->deleteRevision($this->revisionId);.
    $this->messenger()->addStatus($this->t('The archive revision has been deleted.'));
    $form_state->setRedirectUrl($this->getCancelUrl());
  }

}
