<?php

namespace Drupal\Tests\dkan_dataset_archiver\Unit\Commands {

  use Drupal\Core\Config\ConfigFactoryInterface;
  use Drupal\Core\Entity\EntityTypeManager;
  use Drupal\Core\Utility\Token;
  use Drupal\dkan_dataset_archiver\Drush\Commands\DkanDatasetArchiverCommands;
  use Drupal\dkan_dataset_archiver\Service\ArchiveService;
  use Drupal\file\FileRepositoryInterface;
  use Drupal\Tests\dkan_dataset_archiver\Traits\LoggerTestTrait;
  use Drupal\Tests\UnitTestCase;
  use League\Flysystem\Filesystem;
  use MockChain\Chain;
  use MockChain\Options;
  use Psr\Log\LoggerInterface;
  use Symfony\Component\DependencyInjection\ContainerInterface;

  /**
   * DkanDatasetArchiverCommands unit tests.
   *
   * @package Drupal\Tests\dkan_dataset_archiver\Unit\Commands
   */
  class ArchiverCommandsTest extends UnitTestCase {
    use LoggerTestTrait;

    /**
     * Test createAnnualArchives().
     */
    public function testCreateAnnualArchives() {
      $container = $this->getContainer();
      $archiveCommands = DkanDatasetArchiverCommands::create($container);
      $archiveCommands->createAnnual();
      // Basically asserts that it got this far.
      $this->assertTrue(TRUE);
    }

    /**
     * Test createCurrent().
     */
    public function testCreateCurrent() {
      $container = $this->getContainer();
      $archiveCommands = DkanDatasetArchiverCommands::create($container);
      $archiveCommands->createCurrent();
      // Basically asserts that it got this far.
      $this->assertTrue(TRUE);
    }

    /**
     * Get container.
     */
    private function getContainer() {
      $container = $this->createMock(ContainerInterface::class);

      $container->method('get')
        ->willReturnMap([
          ['dkan_dataset_archiver.archive_service', $this->createMock(ArchiveService::class)],
          ['entity_type.manager', $this->createMock(EntityTypeManager::class)],
          ['config.factory', $this->createMock(ConfigFactoryInterface::class)],
          ['file.repository', $this->createMock(FileRepositoryInterface::class)],
          ['token', $this->createMock(Token::class)],
          [
            'logger.channel.dkan_dataset_archiver',
            $this->getLoggerChain(TRUE)->getMock()->get('logger.channel.dkan_dataset_archiver'),
          ],
          ['dkan_dataset_archiver.filesystem', $this->createMock(Filesystem::class)],
          ['drush.style', $this->getMockBuilder('\Drush\Style\DrushStyle')->disableOriginalConstructor()->getMock()],
        ]);

      return $container;
    }

  }

}

namespace Drush\Style {

  use Symfony\Component\Console\Style\SymfonyStyle;

  if (!class_exists('\Drush\Style\DrushStyle')) {
    /**
     * DkanDatasetArchiverCommands unit tests.
     *
     * This exists only to cover the DrushStyle class used in the commands test.
     * Yes it is an embarrassing shim to get tests running.
     */
    class DrushStyle extends SymfonyStyle {}
  }

}

namespace {
  if (!function_exists('dt')) {

    /**
     * Helper function to test Helper\Storage::getVersion.
     *
     * Rudimentary translation system, akin to Drupal's t() function.
     *
     * @param string $message
     *   String to process, possibly with replacement item.
     * @param array $replace
     *   An associative array of replacement items.
     *
     * @return string
     *   The processed string for a message.
     */
    function dt(string $message, array $replace = []): string {
      return strtr($message, $replace);
    }

  }

}
