<?php

namespace Drupal\dkan_dataset_archiver_remote_storage;

use Aws\S3\S3Client;
use League\Flysystem\AwsS3v3\AwsS3Adapter;
use League\Flysystem\Filesystem;

/**
 * Trait to provide AWS S3 functionality.
 */
trait AwsS3Trait {

  /**
   * The S3 bucket name.
   *
   * @var string
   */
  private $s3Bucket;

  /**
   * The filesystem object.
   *
   * @var \League\Flysystem\Filesystem|null
   */
  private $filesystem = NULL;

  /**
   * Gets the S3 client.
   *
   * @return \Aws\S3\S3Client
   *   The S3 client.
   */
  public function getS3Client(): S3Client {
    /** @var \Drupal\dkan_dataset_archiver_remote_storage\Service\AwsS3Service $awsS3 */
    $awsS3 = \Drupal::service('dkan_dataset_archiver_remote_storage.aws_s3_service');

    return $awsS3->getS3Client();
  }

  /**
   * Sets the AWS S3 filesystem.
   *
   * @param \League\Flysystem\Filesystem $filesystem
   *   The filesystem.
   */
  public function setAwsS3FileSystem(Filesystem $filesystem): void {
    $this->filesystem = $filesystem;
  }

  /**
   * Gets the AWS S3 filesystem, creating it if needed.
   *
   * @return \League\Flysystem\Filesystem
   *   The filesystem.
   */
  private function getAwsS3Filesystem(): Filesystem {
    if (is_null($this->filesystem)) {
      $this->filesystem = new Filesystem(new AwsS3Adapter($this->getS3Client(), $this->s3Bucket));
    }
    return $this->filesystem;
  }

}
