<?php

/**
 * @file
 * Deployment hooks for the dkan_dataset_archiver module.
 */

/**
 * Create the initial 'current' archives for all published datasets.
 *
 * Unable to run this with hook_install due to race conditions.
 *
 * If your deploy method does not used Drush deploy, you will need to run the
 * Drush command 'drush dkan_dataset_archiver:create-current' after deployment
 * to queue the creation of current archives.
 */
function dkan_dataset_archiver_deploy_0001() {
  // Create the initial 'current' archives for all published datasets.
  /** @var \Drupal\dkan_dataset_archiver\Service\ArchiveService $archive_service */
  $archive_service = \Drupal::service('dkan_dataset_archiver.archive_service');
  $count = $archive_service->reQueueCurrentArchiving();
  \Drupal::logger('dkan_dataset_archiver')->info('DKAN Dataset Archiver module installed and queued @count "current" archives.', ['@count' => $count]);
}
