# Document Library (dl)

A comprehensive document management system for Drupal 10+ that provides hierarchical folder organization, version control, download tracking, and favorites functionality.

## Features

- **Fieldable Content Entity**: Full integration with Drupal's Field UI for customizable document fields
- **Hierarchical Folders**: Organize documents in nested folder structures (custom table-based, not taxonomy)
- **File Management**: Support for multiple storage backends (Public, Private, OCI Object Storage)
- **Version Control**: Track document versions with notes and history
- **Download Tracking**: Monitor document downloads with user and timestamp data
- **Favorites**: Allow users to bookmark documents for quick access
- **Search**: Full-text search across document titles, descriptions, and tags
- **Permissions**: Granular access control for viewing, uploading, editing, and deleting documents

## Installation

1. Enable the module:
   ```bash
   drush en dl -y
   ```

2. Clear cache:
   ```bash
   drush cr
   ```

3. Configure permissions at `/admin/people/permissions#module-dl`

## Configuration

### Field Configuration

Configure document fields at:
- **Manage fields**: `/admin/structure/document/settings/fields`
- **Manage form display**: `/admin/structure/document/settings/form-display`
- **Manage display**: `/admin/structure/document/settings/display`

Available fields:
- `field_file` - File upload (configurable upload destination)
- `field_description` - Text area for document description
- `field_version` - Version number/label
- `field_tags` - Comma-separated tags

### Module Settings

Configure general settings at `/admin/config/content/document-library/settings`:
- Items per page
- Enable/disable versioning
- Enable/disable download tracking
- Enable/disable favorites
- Theme (Light/Dark/Auto)
- Show file thumbnails

### Upload Destination

To change where files are stored:
1. Go to `/admin/structure/document/settings/fields`
2. Click "Edit" on the "Document File" field
3. Click "Field settings"
4. Select upload destination (Public/Private/OCI)

## Usage

### Creating Documents

- Frontend: `/documents/upload` or `/documents/upload?folder={folder_id}`
- Admin: `/documents/add`

The system automatically redirects upload URLs to the entity add form, preserving the folder context.

### Viewing Documents

- Single document: `/documents/{id}`
- Library homepage: `/documents`
- Folder view: `/documents/folder/{folder_id}`
- Search: `/documents/search`
- Favorites: `/documents/favorites`

### Managing Folders

- Create folder: `/documents/folder/create` or `/documents/folder/create/{parent_id}`
- Edit folder: `/documents/folder/{id}/edit`
- Admin folders: `/admin/content/documents/folders`

## Database Structure

### Main Tables

- `document` - Document entities (base table)
- `document__field_file` - File references
- `document__field_description` - Document descriptions
- `document__field_version` - Version labels
- `document__field_tags` - Tags/keywords
- `dl_folders` - Folder hierarchy (custom implementation)
- `dl_versions` - Version history
- `dl_downloads` - Download tracking
- `dl_favorites` - User favorites

## Permissions

- `access document library` - View documents and folders
- `upload documents` - Create new documents
- `download documents` - Download document files
- `edit documents` - Edit own documents
- `delete documents` - Delete own documents
- `manage all documents` - Manage any document
- `create folders` - Create new folders
- `edit folders` - Edit folder names and structure
- `delete folders` - Delete folders
- `administer document library` - Full administrative access

## Development

### Folder System

The module uses a custom folder system stored in the `dl_folders` table with hierarchical path tracking. This provides better performance than taxonomy for deep folder structures.

Folder structure:
- `folder_id` - Primary key
- `name` - Folder name
- `slug` - URL-safe name
- `parent_id` - Parent folder ID (0 = root)
- `path` - Full path from root
- `depth` - Nesting level
- `status` - Published status
- `created` - Creation timestamp
- `changed` - Last modified timestamp

### Entity Structure

Documents are content entities with both base fields and configurable fields:

Base fields (defined in code):
- `id` - Document ID
- `uuid` - Universal identifier
- `uid` - Owner user ID
- `title` - Document title
- `folder_id` - Folder reference
- `downloads` - Download counter
- `status` - Published status
- `created` - Creation timestamp
- `changed` - Last modified timestamp

Configurable fields (manageable via Field UI):
- `field_file` - File reference
- `field_description` - Long text
- `field_version` - String
- `field_tags` - String

### Custom Routes

The module provides custom controllers for enhanced functionality:
- Document view includes version history, favorites, and breadcrumbs
- Download tracking with IP and timestamp logging
- Folder navigation with breadcrumb trails

### Templates

Twig templates are provided for:
- `dl-library-page.html.twig` - Main library homepage
- `dl-folder-page.html.twig` - Folder view
- `dl-document-view.html.twig` - Document detail page
- `dl-search-page.html.twig` - Search results
- `dl-favorites-page.html.twig` - User favorites
- `dl-admin-documents.html.twig` - Admin document list
- `dl-admin-folders.html.twig` - Admin folder management

## Troubleshooting

### Documents not appearing in Field UI

Clear cache and verify field storage configuration exists:
```bash
drush cr
drush config:get field.storage.document.field_file
```

### Upload destination not changing

The form alter hook unlocks the uri_scheme setting. Verify:
```bash
drush config:get field.storage.document.field_file settings.uri_scheme
```

### Route conflicts

If document pages show 404:
1. Clear routing cache: `drush cr`
2. Verify entity route provider is working: `drush eval "print_r(\Drupal::service('router.route_provider')->getRouteByName('entity.document.canonical'));"`

## Support

For issues or feature requests, contact the site administrator.

## Credits

Developed for ESNAD document management requirements.
