<?php

/**
 * @file
 * Tokens for Document Library module.
 */

use Drupal\Core\Render\BubbleableMetadata;

/**
 * Implements hook_token_info().
 */
function dl_token_info() {
  $info = [];

  // Add entity-specific tokens that file field can use
  // These will be available as [entity:document:folder-path] etc
  $info['tokens']['entity']['document:folder-name'] = [
    'name' => t('Document folder name'),
    'description' => t('The name of the folder containing the document.'),
  ];

  $info['tokens']['entity']['document:folder-slug'] = [
    'name' => t('Document folder slug'),
    'description' => t('The URL-friendly slug of the folder containing the document.'),
  ];

  $info['tokens']['entity']['document:folder-path'] = [
    'name' => t('Document folder path'),
    'description' => t('The full folder path with slugs (e.g., finance/reports).'),
  ];

  $info['tokens']['entity']['document:folder-id'] = [
    'name' => t('Document folder ID'),
    'description' => t('The numeric ID of the folder containing the document.'),
  ];

  return $info;
}

/**
 * Implements hook_tokens().
 */
function dl_tokens($type, $tokens, array $data, array $options, BubbleableMetadata $bubbleable_metadata) {
  $replacements = [];

  // Handle entity tokens for document entity
  if ($type == 'entity' && !empty($data['entity'])) {
    $entity = $data['entity'];

    // Check if this is a document entity
    if ($entity->getEntityTypeId() == 'document') {
      /** @var \Drupal\dl\Entity\Document $document */
      $document = $entity;
      $folder_manager = \Drupal::service('dl.folder_manager');

      foreach ($tokens as $name => $original) {
        switch ($name) {
          case 'document:folder-name':
            $folder_id = $document->get('folder_id')->value;
            if ($folder_id > 0) {
              $folder = $folder_manager->getFolder($folder_id);
              $replacements[$original] = $folder ? $folder->name : 'root';
            } else {
              $replacements[$original] = 'root';
            }
            break;

          case 'document:folder-slug':
            $folder_id = $document->get('folder_id')->value;
            if ($folder_id > 0) {
              $folder = $folder_manager->getFolder($folder_id);
              $replacements[$original] = $folder ? $folder->slug : 'root';
            } else {
              $replacements[$original] = 'root';
            }
            break;

          case 'document:folder-path':
            $folder_id = $document->get('folder_id')->value;
            if ($folder_id > 0) {
              $slug_path = $folder_manager->getFolderSlugPath($folder_id);
              $replacements[$original] = $slug_path ?: 'root';
            } else {
              $replacements[$original] = 'root';
            }
            break;

          case 'document:folder-id':
            $folder_id = $document->get('folder_id')->value;
            $replacements[$original] = $folder_id > 0 ? $folder_id : '0';
            break;
        }
      }
    }
  }

  return $replacements;
}
