<?php

namespace Drupal\dl\Entity;

use Drupal\Core\Entity\ContentEntityInterface;
use Drupal\Core\Entity\EntityChangedInterface;
use Drupal\user\EntityOwnerInterface;

/**
 * Provides an interface for Document entities.
 */
interface DocumentInterface extends ContentEntityInterface, EntityChangedInterface, EntityOwnerInterface {

  /**
   * Gets the document title.
   *
   * @return string
   *   Title of the document.
   */
  public function getTitle();

  /**
   * Sets the document title.
   *
   * @param string $title
   *   The document title.
   *
   * @return \Drupal\dl\Entity\DocumentInterface
   *   The called document entity.
   */
  public function setTitle($title);

  /**
   * Gets the document creation timestamp.
   *
   * @return int
   *   Creation timestamp of the document.
   */
  public function getCreatedTime();

  /**
   * Sets the document creation timestamp.
   *
   * @param int $timestamp
   *   The document creation timestamp.
   *
   * @return \Drupal\dl\Entity\DocumentInterface
   *   The called document entity.
   */
  public function setCreatedTime($timestamp);

  /**
   * Returns the document published status indicator.
   *
   * @return bool
   *   TRUE if the document is published.
   */
  public function isPublished();

  /**
   * Sets the published status of a document.
   *
   * @param bool $published
   *   (optional) TRUE to set this document to published, FALSE to unpublished.
   *   Defaults to NULL for BC compatibility.
   *
   * @return \Drupal\dl\Entity\DocumentInterface
   *   The called document entity.
   */
  public function setPublished($published = NULL);

  /**
   * Sets the document to unpublished.
   *
   * @return \Drupal\dl\Entity\DocumentInterface
   *   The called document entity.
   */
  public function setUnpublished();

  /**
   * Gets the download count.
   *
   * @return int
   *   The number of times this document has been downloaded.
   */
  public function getDownloadCount();

  /**
   * Increments the download count.
   *
   * @return \Drupal\dl\Entity\DocumentInterface
   *   The called document entity.
   */
  public function incrementDownloadCount();

}
