<?php

namespace Drupal\dl\Form;

use Drupal\Core\Entity\ContentEntityForm;
use Drupal\Core\Form\FormStateInterface;

/**
 * Form controller for Document edit forms.
 */
class DocumentForm extends ContentEntityForm {

  /**
   * {@inheritdoc}
   */
  public function buildForm(array $form, FormStateInterface $form_state) {
    $form = parent::buildForm($form, $form_state);

    // Attach library for styling.
    $form['#attached']['library'][] = 'dl/document-library';

    // Pre-fill folder_id from query parameter if creating new document.
    $entity = $this->entity;
    if ($entity->isNew()) {
      $folder = \Drupal::request()->query->get('folder');
      if ($folder !== NULL && is_numeric($folder)) {
        $entity->set('folder_id', (int) $folder);
      }
    }

    return $form;
  }

  /**
   * {@inheritdoc}
   */
  public function save(array $form, FormStateInterface $form_state) {
    $entity = $this->entity;

    $status = parent::save($form, $form_state);

    switch ($status) {
      case SAVED_NEW:
        $this->messenger()->addStatus($this->t('Created the %label Document.', [
          '%label' => $entity->label(),
        ]));
        break;

      default:
        $this->messenger()->addStatus($this->t('Saved the %label Document.', [
          '%label' => $entity->label(),
        ]));
    }

    $form_state->setRedirect('entity.document.canonical', ['document' => $entity->id()]);

    return $status;
  }

}
