<?php

namespace Drupal\dl\Form;

use Drupal\Core\Form\FormBase;
use Drupal\Core\Form\FormStateInterface;

/**
 * Class DocumentSettingsForm.
 *
 * This form is REQUIRED for Field UI to work with the Document entity.
 * The field_ui_base_route in the entity annotation points to this form's route.
 */
class DocumentSettingsForm extends FormBase {

  /**
   * {@inheritdoc}
   */
  public function getFormId() {
    return 'document_settings';
  }

  /**
   * {@inheritdoc}
   */
  public function submitForm(array &$form, FormStateInterface $form_state) {
    // Empty implementation of the submit form.
  }

  /**
   * {@inheritdoc}
   */
  public function buildForm(array $form, FormStateInterface $form_state) {
    $form['document_settings'] = [
      '#markup' => $this->t('Settings form for Document entity. Use the tabs above to manage fields, form display, and display settings.'),
    ];

    return $form;
  }

}
