<?php

namespace Drupal\dl\Form;

use Drupal\Core\Form\FormBase;
use Drupal\Core\Form\FormStateInterface;
use Drupal\Core\Url;

/**
 * Redirects legacy field config to new Field UI.
 */
class FieldConfigRedirectForm extends FormBase {

  /**
   * {@inheritdoc}
   */
  public function getFormId() {
    return 'dl_field_config_redirect';
  }

  /**
   * {@inheritdoc}
   */
  public function buildForm(array $form, FormStateInterface $form_state) {
    // Immediately redirect to the new Field UI.
    $form_state->setRedirectUrl(Url::fromRoute('entity.entity_form_display.document.default'));

    $form['message'] = [
      '#markup' => $this->t('Redirecting to the new Field UI at Structure > Documents > Manage form display...'),
    ];

    return $form;
  }

  /**
   * {@inheritdoc}
   */
  public function submitForm(array &$form, FormStateInterface $form_state) {
    // Redirect handled in buildForm.
  }

}
