<?php

namespace Drupal\dl\Form;

use Drupal\Core\Form\ConfigFormBase;
use Drupal\Core\Form\FormStateInterface;

/**
 * Configure Document Library settings.
 */
class SettingsForm extends ConfigFormBase
{

  /**
   * {@inheritdoc}
   */
  protected function getEditableConfigNames()
  {
    return ['dl.settings'];
  }

  /**
   * {@inheritdoc}
   */
  public function getFormId()
  {
    return 'dl_settings_form';
  }

  /**
   * {@inheritdoc}
   */
  public function buildForm(array $form, FormStateInterface $form_state)
  {
    $config = $this->config('dl.settings');

    $form['info'] = [
      '#markup' => '<p>' . $this->t('File upload settings (max size, extensions) are now configured per field at <a href="@url">Structure → Documents → Manage form display</a>.', [
        '@url' => '/admin/structure/document/form-display',
      ]) . '</p>',
    ];

    $form['general'] = [
      '#type' => 'details',
      '#title' => $this->t('General Settings'),
      '#open' => TRUE,
    ];

    $form['general']['items_per_page'] = [
      '#type' => 'number',
      '#title' => $this->t('Items Per Page'),
      '#default_value' => $config->get('items_per_page') ?: 20,
      '#min' => 5,
      '#max' => 100,
    ];

    $form['features'] = [
      '#type' => 'details',
      '#title' => $this->t('Features'),
      '#open' => TRUE,
    ];

    $form['features']['enable_versioning'] = [
      '#type' => 'checkbox',
      '#title' => $this->t('Enable Version Control'),
      '#default_value' => $config->get('enable_versioning') ?? TRUE,
    ];

    $form['features']['enable_downloads_tracking'] = [
      '#type' => 'checkbox',
      '#title' => $this->t('Track Downloads'),
      '#default_value' => $config->get('enable_downloads_tracking') ?? TRUE,
    ];

    $form['features']['enable_favorites'] = [
      '#type' => 'checkbox',
      '#title' => $this->t('Enable Favorites'),
      '#default_value' => $config->get('enable_favorites') ?? TRUE,
    ];

    $form['features']['enable_comments'] = [
      '#type' => 'checkbox',
      '#title' => $this->t('Enable Comments'),
      '#default_value' => $config->get('enable_comments') ?? FALSE,
    ];

    $form['ui'] = [
      '#type' => 'details',
      '#title' => $this->t('User Interface'),
      '#open' => TRUE,
    ];

    $form['ui']['theme'] = [
      '#type' => 'select',
      '#title' => $this->t('Theme'),
      '#options' => [
        'light' => $this->t('Light'),
        'dark' => $this->t('Dark'),
        'auto' => $this->t('Auto (System)'),
      ],
      '#default_value' => $config->get('theme') ?: 'light',
    ];

    $form['ui']['show_thumbnails'] = [
      '#type' => 'checkbox',
      '#title' => $this->t('Show File Thumbnails'),
      '#default_value' => $config->get('show_thumbnails') ?? TRUE,
    ];

    return parent::buildForm($form, $form_state);
  }

  /**
   * {@inheritdoc}
   */
  public function submitForm(array &$form, FormStateInterface $form_state)
  {
    $this->config('dl.settings')
      ->set('items_per_page', $form_state->getValue('items_per_page'))
      ->set('enable_versioning', $form_state->getValue('enable_versioning'))
      ->set('enable_downloads_tracking', $form_state->getValue('enable_downloads_tracking'))
      ->set('enable_favorites', $form_state->getValue('enable_favorites'))
      ->set('enable_comments', $form_state->getValue('enable_comments'))
      ->set('theme', $form_state->getValue('theme'))
      ->set('show_thumbnails', $form_state->getValue('show_thumbnails'))
      ->save();

    parent::submitForm($form, $form_state);
  }
}
