<?php

namespace Drupal\dl\Controller;

use Drupal\Core\Controller\ControllerBase;
use Drupal\Core\Url;
use Symfony\Component\HttpFoundation\RedirectResponse;

/**
 * Redirects old upload URLs to new entity add form.
 */
class DocumentUploadRedirectController extends ControllerBase {

  /**
   * Redirects to entity add form with folder parameter.
   *
   * @param int $folder
   *   The folder ID (optional).
   *
   * @return \Symfony\Component\HttpFoundation\RedirectResponse
   *   Redirect to entity add form.
   */
  public function redirectToAdd($folder = 0) {
    // Redirect to entity add form with folder as query parameter.
    $url = Url::fromRoute('entity.document.add_form', [], [
      'query' => ['folder' => $folder],
    ]);

    return new RedirectResponse($url->toString());
  }

}
