// modules are defined as an array
// [ module function, map of requires ]
//
// map of requires is short require name -> numeric require
//
// anything defined in a previous bundle is accessed via the
// orig method which is the require for previous bundles

(function (
  modules,
  entry,
  mainEntry,
  parcelRequireName,
  externals,
  distDir,
  publicUrl,
  devServer
) {
  /* eslint-disable no-undef */
  var globalObject =
    typeof globalThis !== 'undefined'
      ? globalThis
      : typeof self !== 'undefined'
      ? self
      : typeof window !== 'undefined'
      ? window
      : typeof global !== 'undefined'
      ? global
      : {};
  /* eslint-enable no-undef */

  // Save the require from previous bundle to this closure if any
  var previousRequire =
    typeof globalObject[parcelRequireName] === 'function' &&
    globalObject[parcelRequireName];

  var importMap = previousRequire.i || {};
  var cache = previousRequire.cache || {};
  // Do not use `require` to prevent Webpack from trying to bundle this call
  var nodeRequire =
    typeof module !== 'undefined' &&
    typeof module.require === 'function' &&
    module.require.bind(module);

  function newRequire(name, jumped) {
    if (!cache[name]) {
      if (!modules[name]) {
        if (externals[name]) {
          return externals[name];
        }
        // if we cannot find the module within our internal map or
        // cache jump to the current global require ie. the last bundle
        // that was added to the page.
        var currentRequire =
          typeof globalObject[parcelRequireName] === 'function' &&
          globalObject[parcelRequireName];
        if (!jumped && currentRequire) {
          return currentRequire(name, true);
        }

        // If there are other bundles on this page the require from the
        // previous one is saved to 'previousRequire'. Repeat this as
        // many times as there are bundles until the module is found or
        // we exhaust the require chain.
        if (previousRequire) {
          return previousRequire(name, true);
        }

        // Try the node require function if it exists.
        if (nodeRequire && typeof name === 'string') {
          return nodeRequire(name);
        }

        var err = new Error("Cannot find module '" + name + "'");
        err.code = 'MODULE_NOT_FOUND';
        throw err;
      }

      localRequire.resolve = resolve;
      localRequire.cache = {};

      var module = (cache[name] = new newRequire.Module(name));

      modules[name][0].call(
        module.exports,
        localRequire,
        module,
        module.exports,
        globalObject
      );
    }

    return cache[name].exports;

    function localRequire(x) {
      var res = localRequire.resolve(x);
      if (res === false) {
        return {};
      }
      // Synthesize a module to follow re-exports.
      if (Array.isArray(res)) {
        var m = {__esModule: true};
        res.forEach(function (v) {
          var key = v[0];
          var id = v[1];
          var exp = v[2] || v[0];
          var x = newRequire(id);
          if (key === '*') {
            Object.keys(x).forEach(function (key) {
              if (
                key === 'default' ||
                key === '__esModule' ||
                Object.prototype.hasOwnProperty.call(m, key)
              ) {
                return;
              }

              Object.defineProperty(m, key, {
                enumerable: true,
                get: function () {
                  return x[key];
                },
              });
            });
          } else if (exp === '*') {
            Object.defineProperty(m, key, {
              enumerable: true,
              value: x,
            });
          } else {
            Object.defineProperty(m, key, {
              enumerable: true,
              get: function () {
                if (exp === 'default') {
                  return x.__esModule ? x.default : x;
                }
                return x[exp];
              },
            });
          }
        });
        return m;
      }
      return newRequire(res);
    }

    function resolve(x) {
      var id = modules[name][1][x];
      return id != null ? id : x;
    }
  }

  function Module(moduleName) {
    this.id = moduleName;
    this.bundle = newRequire;
    this.require = nodeRequire;
    this.exports = {};
  }

  newRequire.isParcelRequire = true;
  newRequire.Module = Module;
  newRequire.modules = modules;
  newRequire.cache = cache;
  newRequire.parent = previousRequire;
  newRequire.distDir = distDir;
  newRequire.publicUrl = publicUrl;
  newRequire.devServer = devServer;
  newRequire.i = importMap;
  newRequire.register = function (id, exports) {
    modules[id] = [
      function (require, module) {
        module.exports = exports;
      },
      {},
    ];
  };

  // Only insert newRequire.load when it is actually used.
  // The code in this file is linted against ES5, so dynamic import is not allowed.
  // INSERT_LOAD_HERE

  Object.defineProperty(newRequire, 'root', {
    get: function () {
      return globalObject[parcelRequireName];
    },
  });

  globalObject[parcelRequireName] = newRequire;

  for (var i = 0; i < entry.length; i++) {
    newRequire(entry[i]);
  }

  if (mainEntry) {
    // Expose entry point to Node, AMD or browser globals
    // Based on https://github.com/ForbesLindesay/umd/blob/master/template.js
    var mainExports = newRequire(mainEntry);

    // CommonJS
    if (typeof exports === 'object' && typeof module !== 'undefined') {
      module.exports = mainExports;

      // RequireJS
    } else if (typeof define === 'function' && define.amd) {
      define(function () {
        return mainExports;
      });
    }
  }
})({"2CsLN":[function(require,module,exports,__globalThis) {
var global = arguments[3];
var HMR_HOST = null;
var HMR_PORT = null;
var HMR_SERVER_PORT = 1234;
var HMR_SECURE = false;
var HMR_ENV_HASH = "439701173a9199ea";
var HMR_USE_SSE = false;
module.bundle.HMR_BUNDLE_ID = "96a19782655b092e";
"use strict";
/* global HMR_HOST, HMR_PORT, HMR_SERVER_PORT, HMR_ENV_HASH, HMR_SECURE, HMR_USE_SSE, chrome, browser, __parcel__import__, __parcel__importScripts__, ServiceWorkerGlobalScope */ /*::
import type {
  HMRAsset,
  HMRMessage,
} from '@parcel/reporter-dev-server/src/HMRServer.js';
interface ParcelRequire {
  (string): mixed;
  cache: {|[string]: ParcelModule|};
  hotData: {|[string]: mixed|};
  Module: any;
  parent: ?ParcelRequire;
  isParcelRequire: true;
  modules: {|[string]: [Function, {|[string]: string|}]|};
  HMR_BUNDLE_ID: string;
  root: ParcelRequire;
}
interface ParcelModule {
  hot: {|
    data: mixed,
    accept(cb: (Function) => void): void,
    dispose(cb: (mixed) => void): void,
    // accept(deps: Array<string> | string, cb: (Function) => void): void,
    // decline(): void,
    _acceptCallbacks: Array<(Function) => void>,
    _disposeCallbacks: Array<(mixed) => void>,
  |};
}
interface ExtensionContext {
  runtime: {|
    reload(): void,
    getURL(url: string): string;
    getManifest(): {manifest_version: number, ...};
  |};
}
declare var module: {bundle: ParcelRequire, ...};
declare var HMR_HOST: string;
declare var HMR_PORT: string;
declare var HMR_SERVER_PORT: string;
declare var HMR_ENV_HASH: string;
declare var HMR_SECURE: boolean;
declare var HMR_USE_SSE: boolean;
declare var chrome: ExtensionContext;
declare var browser: ExtensionContext;
declare var __parcel__import__: (string) => Promise<void>;
declare var __parcel__importScripts__: (string) => Promise<void>;
declare var globalThis: typeof self;
declare var ServiceWorkerGlobalScope: Object;
*/ var OVERLAY_ID = '__parcel__error__overlay__';
var OldModule = module.bundle.Module;
function Module(moduleName) {
    OldModule.call(this, moduleName);
    this.hot = {
        data: module.bundle.hotData[moduleName],
        _acceptCallbacks: [],
        _disposeCallbacks: [],
        accept: function(fn) {
            this._acceptCallbacks.push(fn || function() {});
        },
        dispose: function(fn) {
            this._disposeCallbacks.push(fn);
        }
    };
    module.bundle.hotData[moduleName] = undefined;
}
module.bundle.Module = Module;
module.bundle.hotData = {};
var checkedAssets /*: {|[string]: boolean|} */ , disposedAssets /*: {|[string]: boolean|} */ , assetsToDispose /*: Array<[ParcelRequire, string]> */ , assetsToAccept /*: Array<[ParcelRequire, string]> */ , bundleNotFound = false;
function getHostname() {
    return HMR_HOST || (typeof location !== 'undefined' && location.protocol.indexOf('http') === 0 ? location.hostname : 'localhost');
}
function getPort() {
    return HMR_PORT || (typeof location !== 'undefined' ? location.port : HMR_SERVER_PORT);
}
// eslint-disable-next-line no-redeclare
let WebSocket = globalThis.WebSocket;
if (!WebSocket && typeof module.bundle.root === 'function') try {
    // eslint-disable-next-line no-global-assign
    WebSocket = module.bundle.root('ws');
} catch  {
// ignore.
}
var hostname = getHostname();
var port = getPort();
var protocol = HMR_SECURE || typeof location !== 'undefined' && location.protocol === 'https:' && ![
    'localhost',
    '127.0.0.1',
    '0.0.0.0'
].includes(hostname) ? 'wss' : 'ws';
// eslint-disable-next-line no-redeclare
var parent = module.bundle.parent;
if (!parent || !parent.isParcelRequire) {
    // Web extension context
    var extCtx = typeof browser === 'undefined' ? typeof chrome === 'undefined' ? null : chrome : browser;
    // Safari doesn't support sourceURL in error stacks.
    // eval may also be disabled via CSP, so do a quick check.
    var supportsSourceURL = false;
    try {
        (0, eval)('throw new Error("test"); //# sourceURL=test.js');
    } catch (err) {
        supportsSourceURL = err.stack.includes('test.js');
    }
    var ws;
    if (HMR_USE_SSE) ws = new EventSource('/__parcel_hmr');
    else try {
        // If we're running in the dev server's node runner, listen for messages on the parent port.
        let { workerData, parentPort } = module.bundle.root('node:worker_threads') /*: any*/ ;
        if (workerData !== null && workerData !== void 0 && workerData.__parcel) {
            parentPort.on('message', async (message)=>{
                try {
                    await handleMessage(message);
                    parentPort.postMessage('updated');
                } catch  {
                    parentPort.postMessage('restart');
                }
            });
            // After the bundle has finished running, notify the dev server that the HMR update is complete.
            queueMicrotask(()=>parentPort.postMessage('ready'));
        }
    } catch  {
        if (typeof WebSocket !== 'undefined') try {
            ws = new WebSocket(protocol + '://' + hostname + (port ? ':' + port : '') + '/');
        } catch (err) {
            // Ignore cloudflare workers error.
            if (err.message && !err.message.includes('Disallowed operation called within global scope')) console.error(err.message);
        }
    }
    if (ws) {
        // $FlowFixMe
        ws.onmessage = async function(event /*: {data: string, ...} */ ) {
            var data /*: HMRMessage */  = JSON.parse(event.data);
            await handleMessage(data);
        };
        if (ws instanceof WebSocket) {
            ws.onerror = function(e) {
                if (e.message) console.error(e.message);
            };
            ws.onclose = function() {
                console.warn("[parcel] \uD83D\uDEA8 Connection to the HMR server was lost");
            };
        }
    }
}
async function handleMessage(data /*: HMRMessage */ ) {
    checkedAssets = {} /*: {|[string]: boolean|} */ ;
    disposedAssets = {} /*: {|[string]: boolean|} */ ;
    assetsToAccept = [];
    assetsToDispose = [];
    bundleNotFound = false;
    if (data.type === 'reload') fullReload();
    else if (data.type === 'update') {
        // Remove error overlay if there is one
        if (typeof document !== 'undefined') removeErrorOverlay();
        let assets = data.assets;
        // Handle HMR Update
        let handled = assets.every((asset)=>{
            return asset.type === 'css' || asset.type === 'js' && hmrAcceptCheck(module.bundle.root, asset.id, asset.depsByBundle);
        });
        // Dispatch a custom event in case a bundle was not found. This might mean
        // an asset on the server changed and we should reload the page. This event
        // gives the client an opportunity to refresh without losing state
        // (e.g. via React Server Components). If e.preventDefault() is not called,
        // we will trigger a full page reload.
        if (handled && bundleNotFound && assets.some((a)=>a.envHash !== HMR_ENV_HASH) && typeof window !== 'undefined' && typeof CustomEvent !== 'undefined') handled = !window.dispatchEvent(new CustomEvent('parcelhmrreload', {
            cancelable: true
        }));
        if (handled) {
            console.clear();
            // Dispatch custom event so other runtimes (e.g React Refresh) are aware.
            if (typeof window !== 'undefined' && typeof CustomEvent !== 'undefined') window.dispatchEvent(new CustomEvent('parcelhmraccept'));
            await hmrApplyUpdates(assets);
            hmrDisposeQueue();
            // Run accept callbacks. This will also re-execute other disposed assets in topological order.
            let processedAssets = {};
            for(let i = 0; i < assetsToAccept.length; i++){
                let id = assetsToAccept[i][1];
                if (!processedAssets[id]) {
                    hmrAccept(assetsToAccept[i][0], id);
                    processedAssets[id] = true;
                }
            }
        } else fullReload();
    }
    if (data.type === 'error') {
        // Log parcel errors to console
        for (let ansiDiagnostic of data.diagnostics.ansi){
            let stack = ansiDiagnostic.codeframe ? ansiDiagnostic.codeframe : ansiDiagnostic.stack;
            console.error("\uD83D\uDEA8 [parcel]: " + ansiDiagnostic.message + '\n' + stack + '\n\n' + ansiDiagnostic.hints.join('\n'));
        }
        if (typeof document !== 'undefined') {
            // Render the fancy html overlay
            removeErrorOverlay();
            var overlay = createErrorOverlay(data.diagnostics.html);
            // $FlowFixMe
            document.body.appendChild(overlay);
        }
    }
}
function removeErrorOverlay() {
    var overlay = document.getElementById(OVERLAY_ID);
    if (overlay) {
        overlay.remove();
        console.log("[parcel] \u2728 Error resolved");
    }
}
function createErrorOverlay(diagnostics) {
    var overlay = document.createElement('div');
    overlay.id = OVERLAY_ID;
    let errorHTML = '<div style="background: black; opacity: 0.85; font-size: 16px; color: white; position: fixed; height: 100%; width: 100%; top: 0px; left: 0px; padding: 30px; font-family: Menlo, Consolas, monospace; z-index: 9999;">';
    for (let diagnostic of diagnostics){
        let stack = diagnostic.frames.length ? diagnostic.frames.reduce((p, frame)=>{
            return `${p}
<a href="${protocol === 'wss' ? 'https' : 'http'}://${hostname}:${port}/__parcel_launch_editor?file=${encodeURIComponent(frame.location)}" style="text-decoration: underline; color: #888" onclick="fetch(this.href); return false">${frame.location}</a>
${frame.code}`;
        }, '') : diagnostic.stack;
        errorHTML += `
      <div>
        <div style="font-size: 18px; font-weight: bold; margin-top: 20px;">
          \u{1F6A8} ${diagnostic.message}
        </div>
        <pre>${stack}</pre>
        <div>
          ${diagnostic.hints.map((hint)=>"<div>\uD83D\uDCA1 " + hint + '</div>').join('')}
        </div>
        ${diagnostic.documentation ? `<div>\u{1F4DD} <a style="color: violet" href="${diagnostic.documentation}" target="_blank">Learn more</a></div>` : ''}
      </div>
    `;
    }
    errorHTML += '</div>';
    overlay.innerHTML = errorHTML;
    return overlay;
}
function fullReload() {
    if (typeof location !== 'undefined' && 'reload' in location) location.reload();
    else if (typeof extCtx !== 'undefined' && extCtx && extCtx.runtime && extCtx.runtime.reload) extCtx.runtime.reload();
    else try {
        let { workerData, parentPort } = module.bundle.root('node:worker_threads') /*: any*/ ;
        if (workerData !== null && workerData !== void 0 && workerData.__parcel) parentPort.postMessage('restart');
    } catch (err) {
        console.error("[parcel] \u26A0\uFE0F An HMR update was not accepted. Please restart the process.");
    }
}
function getParents(bundle, id) /*: Array<[ParcelRequire, string]> */ {
    var modules = bundle.modules;
    if (!modules) return [];
    var parents = [];
    var k, d, dep;
    for(k in modules)for(d in modules[k][1]){
        dep = modules[k][1][d];
        if (dep === id || Array.isArray(dep) && dep[dep.length - 1] === id) parents.push([
            bundle,
            k
        ]);
    }
    if (bundle.parent) parents = parents.concat(getParents(bundle.parent, id));
    return parents;
}
function updateLink(link) {
    var href = link.getAttribute('href');
    if (!href) return;
    var newLink = link.cloneNode();
    newLink.onload = function() {
        if (link.parentNode !== null) // $FlowFixMe
        link.parentNode.removeChild(link);
    };
    newLink.setAttribute('href', // $FlowFixMe
    href.split('?')[0] + '?' + Date.now());
    // $FlowFixMe
    link.parentNode.insertBefore(newLink, link.nextSibling);
}
var cssTimeout = null;
function reloadCSS() {
    if (cssTimeout || typeof document === 'undefined') return;
    cssTimeout = setTimeout(function() {
        var links = document.querySelectorAll('link[rel="stylesheet"]');
        for(var i = 0; i < links.length; i++){
            // $FlowFixMe[incompatible-type]
            var href /*: string */  = links[i].getAttribute('href');
            var hostname = getHostname();
            var servedFromHMRServer = hostname === 'localhost' ? new RegExp('^(https?:\\/\\/(0.0.0.0|127.0.0.1)|localhost):' + getPort()).test(href) : href.indexOf(hostname + ':' + getPort());
            var absolute = /^https?:\/\//i.test(href) && href.indexOf(location.origin) !== 0 && !servedFromHMRServer;
            if (!absolute) updateLink(links[i]);
        }
        cssTimeout = null;
    }, 50);
}
function hmrDownload(asset) {
    if (asset.type === 'js') {
        if (typeof document !== 'undefined') {
            let script = document.createElement('script');
            script.src = asset.url + '?t=' + Date.now();
            if (asset.outputFormat === 'esmodule') script.type = 'module';
            return new Promise((resolve, reject)=>{
                var _document$head;
                script.onload = ()=>resolve(script);
                script.onerror = reject;
                (_document$head = document.head) === null || _document$head === void 0 || _document$head.appendChild(script);
            });
        } else if (typeof importScripts === 'function') {
            // Worker scripts
            if (asset.outputFormat === 'esmodule') return import(asset.url + '?t=' + Date.now());
            else return new Promise((resolve, reject)=>{
                try {
                    importScripts(asset.url + '?t=' + Date.now());
                    resolve();
                } catch (err) {
                    reject(err);
                }
            });
        }
    }
}
async function hmrApplyUpdates(assets) {
    global.parcelHotUpdate = Object.create(null);
    let scriptsToRemove;
    try {
        // If sourceURL comments aren't supported in eval, we need to load
        // the update from the dev server over HTTP so that stack traces
        // are correct in errors/logs. This is much slower than eval, so
        // we only do it if needed (currently just Safari).
        // https://bugs.webkit.org/show_bug.cgi?id=137297
        // This path is also taken if a CSP disallows eval.
        if (!supportsSourceURL) {
            let promises = assets.map((asset)=>{
                var _hmrDownload;
                return (_hmrDownload = hmrDownload(asset)) === null || _hmrDownload === void 0 ? void 0 : _hmrDownload.catch((err)=>{
                    // Web extension fix
                    if (extCtx && extCtx.runtime && extCtx.runtime.getManifest().manifest_version == 3 && typeof ServiceWorkerGlobalScope != 'undefined' && global instanceof ServiceWorkerGlobalScope) {
                        extCtx.runtime.reload();
                        return;
                    }
                    throw err;
                });
            });
            scriptsToRemove = await Promise.all(promises);
        }
        assets.forEach(function(asset) {
            hmrApply(module.bundle.root, asset);
        });
    } finally{
        delete global.parcelHotUpdate;
        if (scriptsToRemove) scriptsToRemove.forEach((script)=>{
            if (script) {
                var _document$head2;
                (_document$head2 = document.head) === null || _document$head2 === void 0 || _document$head2.removeChild(script);
            }
        });
    }
}
function hmrApply(bundle /*: ParcelRequire */ , asset /*:  HMRAsset */ ) {
    var modules = bundle.modules;
    if (!modules) return;
    if (asset.type === 'css') reloadCSS();
    else if (asset.type === 'js') {
        let deps = asset.depsByBundle[bundle.HMR_BUNDLE_ID];
        if (deps) {
            if (modules[asset.id]) {
                // Remove dependencies that are removed and will become orphaned.
                // This is necessary so that if the asset is added back again, the cache is gone, and we prevent a full page reload.
                let oldDeps = modules[asset.id][1];
                for(let dep in oldDeps)if (!deps[dep] || deps[dep] !== oldDeps[dep]) {
                    let id = oldDeps[dep];
                    let parents = getParents(module.bundle.root, id);
                    if (parents.length === 1) hmrDelete(module.bundle.root, id);
                }
            }
            if (supportsSourceURL) // Global eval. We would use `new Function` here but browser
            // support for source maps is better with eval.
            (0, eval)(asset.output);
            // $FlowFixMe
            let fn = global.parcelHotUpdate[asset.id];
            modules[asset.id] = [
                fn,
                deps
            ];
        }
        // Always traverse to the parent bundle, even if we already replaced the asset in this bundle.
        // This is required in case modules are duplicated. We need to ensure all instances have the updated code.
        if (bundle.parent) hmrApply(bundle.parent, asset);
    }
}
function hmrDelete(bundle, id) {
    let modules = bundle.modules;
    if (!modules) return;
    if (modules[id]) {
        // Collect dependencies that will become orphaned when this module is deleted.
        let deps = modules[id][1];
        let orphans = [];
        for(let dep in deps){
            let parents = getParents(module.bundle.root, deps[dep]);
            if (parents.length === 1) orphans.push(deps[dep]);
        }
        // Delete the module. This must be done before deleting dependencies in case of circular dependencies.
        delete modules[id];
        delete bundle.cache[id];
        // Now delete the orphans.
        orphans.forEach((id)=>{
            hmrDelete(module.bundle.root, id);
        });
    } else if (bundle.parent) hmrDelete(bundle.parent, id);
}
function hmrAcceptCheck(bundle /*: ParcelRequire */ , id /*: string */ , depsByBundle /*: ?{ [string]: { [string]: string } }*/ ) {
    checkedAssets = {};
    if (hmrAcceptCheckOne(bundle, id, depsByBundle)) return true;
    // Traverse parents breadth first. All possible ancestries must accept the HMR update, or we'll reload.
    let parents = getParents(module.bundle.root, id);
    let accepted = false;
    while(parents.length > 0){
        let v = parents.shift();
        let a = hmrAcceptCheckOne(v[0], v[1], null);
        if (a) // If this parent accepts, stop traversing upward, but still consider siblings.
        accepted = true;
        else if (a !== null) {
            // Otherwise, queue the parents in the next level upward.
            let p = getParents(module.bundle.root, v[1]);
            if (p.length === 0) {
                // If there are no parents, then we've reached an entry without accepting. Reload.
                accepted = false;
                break;
            }
            parents.push(...p);
        }
    }
    return accepted;
}
function hmrAcceptCheckOne(bundle /*: ParcelRequire */ , id /*: string */ , depsByBundle /*: ?{ [string]: { [string]: string } }*/ ) {
    var modules = bundle.modules;
    if (!modules) return;
    if (depsByBundle && !depsByBundle[bundle.HMR_BUNDLE_ID]) {
        // If we reached the root bundle without finding where the asset should go,
        // there's nothing to do. Mark as "accepted" so we don't reload the page.
        if (!bundle.parent) {
            bundleNotFound = true;
            return true;
        }
        return hmrAcceptCheckOne(bundle.parent, id, depsByBundle);
    }
    if (checkedAssets[id]) return null;
    checkedAssets[id] = true;
    var cached = bundle.cache[id];
    if (!cached) return true;
    assetsToDispose.push([
        bundle,
        id
    ]);
    if (cached && cached.hot && cached.hot._acceptCallbacks.length) {
        assetsToAccept.push([
            bundle,
            id
        ]);
        return true;
    }
    return false;
}
function hmrDisposeQueue() {
    // Dispose all old assets.
    for(let i = 0; i < assetsToDispose.length; i++){
        let id = assetsToDispose[i][1];
        if (!disposedAssets[id]) {
            hmrDispose(assetsToDispose[i][0], id);
            disposedAssets[id] = true;
        }
    }
    assetsToDispose = [];
}
function hmrDispose(bundle /*: ParcelRequire */ , id /*: string */ ) {
    var cached = bundle.cache[id];
    bundle.hotData[id] = {};
    if (cached && cached.hot) cached.hot.data = bundle.hotData[id];
    if (cached && cached.hot && cached.hot._disposeCallbacks.length) cached.hot._disposeCallbacks.forEach(function(cb) {
        cb(bundle.hotData[id]);
    });
    delete bundle.cache[id];
}
function hmrAccept(bundle /*: ParcelRequire */ , id /*: string */ ) {
    // Execute the module.
    bundle(id);
    // Run the accept callbacks in the new version of the module.
    var cached = bundle.cache[id];
    if (cached && cached.hot && cached.hot._acceptCallbacks.length) {
        let assetsToAlsoAccept = [];
        cached.hot._acceptCallbacks.forEach(function(cb) {
            let additionalAssets = cb(function() {
                return getParents(module.bundle.root, id);
            });
            if (Array.isArray(additionalAssets) && additionalAssets.length) assetsToAlsoAccept.push(...additionalAssets);
        });
        if (assetsToAlsoAccept.length) {
            let handled = assetsToAlsoAccept.every(function(a) {
                return hmrAcceptCheck(a[0], a[1]);
            });
            if (!handled) return fullReload();
            hmrDisposeQueue();
        }
    }
}

},{}],"7qSnJ":[function(require,module,exports,__globalThis) {
/*
DFG 3D-Viewer
Copyright (C) 2025 - Daniel Dworak

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details at 
https://www.gnu.org/licenses/.
*/ //Supported file formats: OBJ, DAE, FBX, PLY, IFC, STL, XYZ, JSON, 3DS, PCD, glTF
var parcelHelpers = require("@parcel/transformer-js/src/esmodule-helpers.js");
parcelHelpers.defineInteropFlag(exports);
parcelHelpers.export(exports, "Viewer", ()=>Viewer);
var _coreJs = require("./core.js");
var _viewerSettingsJs = require("./viewer-settings.js");
var _utilsJs = require("./utils.js");
var _viewerUtilsJs = require("./viewer-utils.js");
var _loadersJs = require("./loaders.js");
var _metadataJs = require("./metadata.js");
//three.js core
var _initJs = require("./init.js");
var _initJsDefault = parcelHelpers.interopDefault(_initJs);
//three.js components
var _tweenModuleJs = require("three/examples/jsm/libs/tween.module.js");
var _tweenModuleJsDefault = parcelHelpers.interopDefault(_tweenModuleJs);
var _orbitControlsJs = require("three/examples/jsm/controls/OrbitControls.js");
var _transformControlsJs = require("three/examples/jsm/controls/TransformControls.js");
var _fontLoaderJs = require("three/examples/jsm/loaders/FontLoader.js");
var _textGeometryJs = require("three/examples/jsm/geometries/TextGeometry.js");
//custom libraries
var _statsJs = require("stats.js");
var _statsJsDefault = parcelHelpers.interopDefault(_statsJs);
var _lilGuiEsmMinJs = require("./js/external_libs/lil-gui.esm.min.js");
var _objectSettingsJs = require("./object-settings.js");
var _mainJs = require("./spinner/main.js");
var _iiifApiJs = require("./IIIF/iiif-api.js");
const SOURCE = typeof __BUILD_SOURCE__ !== 'undefined' ? __BUILD_SOURCE__ : "";
const IS_PROD = typeof __IS_PROD__ !== 'undefined' ? __IS_PROD__ : "prod";
const Viewer = {
    CONFIG: null,
    camera: null,
    scene: null,
    renderer: null,
    stats: null,
    controls: null,
    loader: null,
    ambientLight: null,
    dirLight: null,
    dirLightTarget: null,
    cameraLight: null,
    cameraLightTarget: null,
    dirLights: [],
    imported: null,
    mainObject: [],
    metadataContentTech: null,
    mainCanvas: null,
    distanceGeometry: new (0, _initJsDefault.default).Vector3(),
    entityID: "",
    metadataUrl: null,
    iiifConfigURL: {
        url: "https://raw.githubusercontent.com/IIIF/3d/main/manifests/4_transform_and_position/model_transform_scale_position.json",
        name: "Inbuilt"
    },
    testModelURL: 'https://raw.githubusercontent.com/IIIF/3d/main/assets/astronaut/astronaut.glb',
    clock: null,
    editor: true,
    FULLSCREEN: false,
    mixer: null,
    tween: null,
    container: null,
    scrollTop: null,
    rect: null,
    fileObject: {
        originalPath: '',
        filename: '',
        basename: '',
        extension: '',
        path: '',
        uri: '',
        newExtension: ''
    },
    bottomLineGUI: null,
    loadedFile: null,
    fileElement: null,
    COPYRIGHTS: false,
    EXIT_CODE: 1,
    gridSize: null,
    noMTL: false,
    canvasText: null,
    viewEntity: null,
    fullscreenMode: null,
    originalMetadata: [],
    spinnerContainer: null,
    spinnerElement: null,
    guiContainer: null,
    metadataContainer: null,
    spinner: null,
    circle: null,
    lilGui: null,
    raycaster: new (0, _initJsDefault.default).Raycaster(),
    pointer: new (0, _initJsDefault.default).Vector2(),
    onUpPosition: new (0, _initJsDefault.default).Vector2(),
    onDownPosition: new (0, _initJsDefault.default).Vector2(),
    bottomOffsetFullscreen: 0,
    geometry: new (0, _initJsDefault.default).BoxGeometry(20, 20, 20),
    transformControl: null,
    transformControlLight: null,
    transformControlLightTarget: null,
    transformControlClippingPlaneX: null,
    transformControlClippingPlaneY: null,
    transformControlClippingPlaneZ: null,
    cameraCoords: null,
    helperObjects: [],
    lightObjects: [],
    lightHelper: null,
    lightHelperTarget: null,
    selectedObject: false,
    selectedObjects: [],
    selectedFaces: [],
    pickingTexture: null,
    windowHalfX: null,
    windowHalfY: null,
    transformType: "",
    transformText: {
        "Transform 3D Object": "select type",
        "Transform Light": "select type",
        "Transform Mode": "Local"
    },
    materialsPropertiesText: {
        "Edit material": "select by name"
    },
    colors: {
        DirectionalLight: "0xFFFFFF",
        AmbientLight: "0x404040",
        CameraLight: "0xFFFFFF",
        BackgroundColor: "#FFFFFF",
        BackgroundColorOuter: "#D2D2D2"
    },
    materialProperties: {
        color: "0xFFFFFF",
        emissiveColor: "0x404040",
        emissive: 1,
        metalness: 0
    },
    intensity: {
        startIntensityDir: 1,
        startIntensityAmbient: 1,
        startIntensityCamera: 1
    },
    saveProperties: {
        Position: true,
        Rotation: true,
        Scale: true,
        Camera: true,
        DirectionalLight: true,
        AmbientLight: true,
        CameraLight: true,
        BackgroundColor: true,
        BackgroundColorOuter: true
    },
    backgroundType: {
        "Background Type": "gradient"
    },
    backgroundOuterFolder: null,
    EDITOR: false,
    RULER_MODE: false,
    lineMaterial: new (0, _initJsDefault.default).LineBasicMaterial({
        color: 0x0000ff
    }),
    linePoints: [],
    gui: null,
    hierarchyFolder: null,
    GUILength: 35,
    zoomImage: 1,
    ZOOM_SPEED_IMAGE: 0.1,
    compressedFile: "",
    archiveType: "",
    planeParams: {
        planeX: {
            constantX: 0,
            negated: false,
            displayHelperX: false
        },
        planeY: {
            constantY: 0,
            negated: false,
            displayHelperY: false
        },
        planeZ: {
            constantZ: 0,
            negated: false,
            displayHelperZ: false
        },
        outline: {
            visible: false
        },
        clippingMode: {
            x: false,
            y: false,
            z: false
        }
    },
    clippingPlanes: null,
    planeHelpers: null,
    clippingFolder: null,
    propertiesFolder: null,
    planeObjects: [],
    editorFolder: null,
    materialsFolder: null,
    textMesh: null,
    textMeshDistance: null,
    ruler: [],
    rulerObject: null,
    lastPickedFace: {
        id: "",
        color: "",
        object: ""
    },
    loadedTimes: 0,
    _ext: '',
    async MainInit () {
        const res = await fetch(`./viewer-settings.json?t=${Date.now()}`, {
            cache: "no-store"
        });
        this.CONFIG = await res.json();
        console.log("Loaded viewer-settings.json", this.CONFIG.viewer);
        if (Object.keys(this.CONFIG).length === 0) this.CONFIG = {
            mainUrl: "https://dfg-repository.wisski.cloud",
            baseNamespace: "https://dfg-repository.wisski.cloud",
            metadataUrl: "https://dfg-repository.wisski.cloud",
            baseModulePath: "/modules/dfg_3dviewer-main/viewer",
            entity: {
                bundle: "bd3d7baa74856d141bcff7b4193fa128",
                fieldDf: "field_df",
                idUri: "/wisski/navigate/(.*)/view",
                viewEntityPath: "/wisski/navigate/",
                attributeId: "wisski_id",
                metadata: {
                    source: "IIIF"
                }
            },
            viewer: {
                container: "DFG_3DViewer",
                fileUpload: "fbf95bddee5160d515b982b3fd2e05f7",
                fileName: "faa602a0be629324806aef22892cdbe5",
                imageGeneration: "f605dc6b727a1099b9e52b3ccbdf5673",
                lightweight: 0,
                salt: "Z7FYJMmTiEzcGp4lTpuk4LiA",
                scaleContainer: {
                    x: 0.85,
                    y: 1.4
                },
                gallery: {
                    container: "block-bootstrap5-content",
                    imageClass: "field--name-fd6a974b7120d422c7b21b5f1f2315d9",
                    imageId: ""
                },
                background: "radial-gradient(circle, rgb(255, 255, 255) 0%, rgb(210, 210, 210) 100%)",
                performanceMode: {
                    Performance: "high-performance"
                }
            }
        };
        console.log(`Powered by Three.js (v${(0, _initJsDefault.default).REVISION}) - DFG 3D-Viewer`);
        this.CONFIG.entity.metadata.source = SOURCE;
        this.container = document.getElementById(this.CONFIG.viewer.container);
        this.scrollTop = window.scrollY || document.documentElement.scrollTop;
        this.rect = this.container.getBoundingClientRect();
        this.fileObject.originalPath = this.container.getAttribute("3d");
        this.CONFIG.viewer.canvasDimensions = {
            x: this.rect.width * Number(this.CONFIG.viewer.scaleContainer.x),
            y: this.rect.height * Number(this.CONFIG.viewer.scaleContainer.y)
        };
        this.bottomLineGUI = this.CONFIG.viewer.canvasDimensions.y - 85;
        if (this.CONFIG.viewer.lightweight === true) this.CONFIG.viewer.lightweight = container.getAttribute("proxy");
        if (this.CONFIG.viewer.lightweight === null || this.CONFIG.viewer.lightweight === false) {
            var elementsURL = window.location.pathname;
            elementsURL = elementsURL.match(this.CONFIG.entity.idUri);
            if (elementsURL !== null) {
                this.entityID = elementsURL[1];
                this.container.setAttribute(this.CONFIG.entity.attributeId, this.entityID);
            }
        }
        // Initialize clipping planes at startup
        this.core = (0, _viewerUtilsJs.initClippingPlanes)();
        // Initialize objectsConfig in core
        (0, _coreJs.setCore)('objectsConfig', (0, _objectSettingsJs.objectsConfig));
        (0, _objectSettingsJs.objectsConfig).setupIndex = (0, _objectSettingsJs.objectsConfig).index = 0;
        this.tween = new (0, _tweenModuleJsDefault.default).Tween();
        (0, _coreJs.setCore)('tween', this.tween);
        this.container.classList.add("mainContainer");
        if (this.container.hasAttribute("basePath")) this.CONFIG.baseModulePath = this.container.getAttribute("basePath");
        this.setModelPaths(this.fileObject);
        this.CONFIG.viewer.exportPath = "/export_xml_single/";
        this.loadedFile = this.fileObject.basename + "." + this.fileObject.extension;
        this.spinnerContainer = document.createElement("div");
        this.spinnerContainer.id = "spinnerContainer";
        this.spinnerElement = document.createElement("div");
        this.spinnerElement.id = "spinner";
        this.spinnerElement.className = "lv-determinate_circle lv-mid md";
        this.spinnerElement.setAttribute("data-label", "Loading...");
        this.spinnerElement.setAttribute("data-percentage", "true");
        this.spinnerContainer.appendChild(this.spinnerElement);
        this.container.appendChild(this.spinnerContainer);
        this.spinnerContainer.style.left = "50%" - this.spinnerContainer.getBoundingClientRect().width + "px";
        this.guiContainer = document.createElement("div");
        this.guiContainer.id = "guiContainer";
        this.guiContainer.className = "guiContainer";
        this.container.appendChild(this.guiContainer);
        this.gui = new (0, _lilGuiEsmMinJs.GUI)({
            container: guiContainer
        });
        this.metadataContainer = document.createElement("div");
        this.metadataContainer.setAttribute("id", "metadata-container");
        this.spinner = new (0, _mainJs.lv)();
        this.spinner.initLoaderAll();
        this.spinner.startObserving();
        this.circle = (0, _mainJs.lv).create(this.spinnerElement);
        (0, _coreJs.setCore)('colors', this.colors);
        (0, _coreJs.setCore)("planeHelpers", this.planeHelpers);
        (0, _coreJs.setCore)("planeParams", this.planeParams);
        // Initialize materialsPropertiesText in core
        (0, _coreJs.setCore)('materialsPropertiesText', this.materialsPropertiesText);
        (0, _coreJs.setCore)('intensity', this.intensity);
        this.clippingPlanes = this.core;
        (0, _coreJs.setCore)("clippingPlanes", this.clippingPlanes);
        this.clock = new (0, _initJsDefault.default).Clock();
        window.addEventListener("load", ()=>{
            requestAnimationFrame(()=>{
                const rect = this.container.getBoundingClientRect();
                this.updateSize();
                this.animate();
            });
        });
    },
    setModelPaths (fileObject1) {
        fileObject1.filename = fileObject1.originalPath.split("/").pop();
        fileObject1.basename = fileObject1.filename.substring(0, fileObject1.filename.lastIndexOf("."));
        fileObject1.extension = fileObject1.filename.substring(fileObject1.filename.lastIndexOf(".") + 1);
        fileObject1.path = fileObject1.originalPath.substring(0, fileObject1.originalPath.lastIndexOf(fileObject1.filename));
        fileObject1.uri = fileObject1.path.replace(this.CONFIG.mainUrl + "/", "");
    },
    addTextWatermark (_text, _scale) {
        var textGeo;
        var materials = [
            new (0, _initJsDefault.default).MeshStandardMaterial({
                color: 0xffffff,
                flatShading: true,
                side: (0, _initJsDefault.default).DoubleSide,
                depthTest: false,
                depthWrite: false,
                transparent: true,
                opacity: 0.4
            }),
            new (0, _initJsDefault.default).MeshStandardMaterial({
                color: 0xffffff,
                flatShading: true,
                side: (0, _initJsDefault.default).DoubleSide,
                depthTest: false,
                depthWrite: false,
                transparent: true,
                opacity: 0.4
            })
        ];
        const loader = new (0, _fontLoaderJs.FontLoader)();
        loader.load('.' + CONFIG.baseModulePath + "/fonts/helvetiker_regular.typeface.json", function(font) {
            const textGeo = new (0, _textGeometryJs.TextGeometry)(_text, {
                font,
                size: _scale * 3,
                height: _scale / 10,
                curveSegments: 5,
                bevelEnabled: true,
                bevelThickness: _scale / 8,
                bevelSize: _scale / 10,
                bevelOffset: 0,
                bevelSegments: 1
            });
            textGeo.computeBoundingBox();
            //const centerOffset = - 0.5 * (textGeo.boundingBox.max.x - textGeo.boundingBox.min.x);
            Viewer.textMesh = new (0, _initJsDefault.default).Mesh(textGeo, materials);
            Viewer.textMesh.rotation.z = Math.PI;
            Viewer.textMesh.rotation.y = Math.PI;
            Viewer.textMesh.position.x = 0;
            Viewer.textMesh.position.y = 0;
            Viewer.textMesh.position.z = 0;
            Viewer.textMesh.renderOrder = 1;
            Viewer.scene.add(Viewer.textMesh);
        });
    },
    addTextPoint (_text, _scale, _point) {
        var textGeo;
        var materials = [
            new (0, _initJsDefault.default).MeshStandardMaterial({
                color: 0x0000ff,
                flatShading: true,
                side: (0, _initJsDefault.default).DoubleSide,
                depthTest: false,
                depthWrite: false,
                transparent: true,
                opacity: 0.4
            }),
            new (0, _initJsDefault.default).MeshStandardMaterial({
                color: 0x0000ff,
                flatShading: true,
                side: (0, _initJsDefault.default).DoubleSide,
                depthTest: false,
                depthWrite: false,
                transparent: true,
                opacity: 0.4
            })
        ];
        const loader = new (0, _fontLoaderJs.FontLoader)();
        var textSize = _scale / 10;
        loader.load('.' + CONFIG.baseModulePath + "/fonts/helvetiker_regular.typeface.json", function(font) {
            const textGeo = new (0, _textGeometryJs.TextGeometry)(_text, {
                font: font,
                size: _scale * 3,
                height: textSize,
                curveSegments: 4,
                bevelEnabled: true,
                bevelThickness: textSize,
                bevelSize: textSize,
                bevelOffset: 0,
                bevelSegments: 1,
                depth: textSize
            });
            textGeo.computeBoundingBox();
            Viewer.textMeshDistance = new (0, _initJsDefault.default).Mesh(textGeo, materials);
            Viewer.textMeshDistance.position.set(_point.x, _point.y, _point.z);
            Viewer.textMeshDistance.renderOrder = 1;
            Viewer.rulerObject.add(Viewer.textMeshDistance);
        });
    },
    selectObjectHierarchy (_id) {
        let search = true;
        for(let i = 0; i < selectedObjects.length && search === true; i++)if (selectedObjects[i].id === _id) {
            search = false;
            if (selectedObjects[i].selected === true) {
                scene.getObjectById(_id).material = selectedObjects[i].originalMaterial;
                scene.getObjectById(_id).material.needsUpdate = true;
                selectedObjects[i].selected = false;
                selectedObjects.splice(selectedObjects.indexOf(selectedObjects[i]), 1);
            }
        }
        if (search) {
            selectedObjects.push({
                id: _id,
                selected: true,
                originalMaterial: scene.getObjectById(_id).material.clone()
            });
            const tempMaterial = scene.getObjectById(_id).material.clone();
            tempMaterial.color.setHex("0x00FF00");
            scene.getObjectById(_id).material = tempMaterial;
            scene.getObjectById(_id).material.needsUpdate = true;
        }
    },
    recreateBoundingBox (object) {
        var _min = new (0, _initJsDefault.default).Vector3();
        var _max = new (0, _initJsDefault.default).Vector3();
        if (object instanceof (0, _initJsDefault.default).Object3D) {
            object.traverse(function(mesh) {
                if (mesh instanceof (0, _initJsDefault.default).Mesh) {
                    mesh.geometry.computeBoundingBox();
                    var bBox = mesh.geometry.boundingBox;
                    // compute overall bbox
                    _min.x = Math.min(_min.x, bBox.min.x + mesh.position.x);
                    _min.y = Math.min(_min.y, bBox.min.y + mesh.position.y);
                    _min.z = Math.min(_min.z, bBox.min.z + mesh.position.z);
                    _max.x = Math.max(_max.x, bBox.max.x + mesh.position.x);
                    _max.y = Math.max(_max.y, bBox.max.y + mesh.position.y);
                    _max.z = Math.max(_max.z, bBox.max.z + mesh.position.z);
                }
            });
            var bBox_min = new (0, _initJsDefault.default).Vector3(_min.x, _min.y, _min.z);
            var bBox_max = new (0, _initJsDefault.default).Vector3(_max.x, _max.y, _max.z);
            var bBox_new = new (0, _initJsDefault.default).Box3(bBox_min, bBox_max);
            object.position.set((bBox_new.min.x + bBox_new.max.x) / 2, bBox_new.min.y, (bBox_new.min.z + bBox_new.max.z) / 2);
        }
        return object;
    },
    prepareGalleryImages (imageElementsChildren) {
        imageElementsChildren = imageElementsChildren.filter(function(_image) {
            return (0, _utilsJs.isValidUrl)(_image.innerHTML);
        });
        imageElementsChildren.forEach(function(imgLink, index) {
            imgLink.innerHTML = '<img loading="lazy" src="' + imgLink.innerHTML + '" width="200px" height="200px" alt="" class="img-fluid image-style-wisski-preview">';
        });
    },
    handleImages (fileElement1, mainElement, imageElements, imageElementsChildren) {
        if (typeof (imageElementsChildren == undefined)) imageElementsChildren = imageElements;
        var imageList = document.createElement("div");
        imageList.setAttribute("id", "image-list");
        var modalGallery = document.createElement("div");
        var modalImage = document.createElement("img");
        modalImage.setAttribute("class", "modalImage");
        modalGallery.addEventListener("wheel", function(e) {
            e.preventDefault();
            e.stopPropagation();
            if (e.deltaY > 0 && zoomImage > 0.15) modalImage.style.transform = `scale(${zoomImage -= ZOOM_SPEED_IMAGE})`;
            else if (e.deltaY < 0 && zoomImage < 5) modalImage.style.transform = `scale(${zoomImage += ZOOM_SPEED_IMAGE})`;
            return false;
        });
        var modalClose = document.createElement("span");
        modalGallery.setAttribute("id", "modalGallery");
        modalGallery.setAttribute("class", "modalGallery");
        modalClose.setAttribute("class", "closeGallery");
        modalClose.setAttribute("title", "Close");
        modalClose.innerHTML = "&times";
        modalClose.onclick = function() {
            modalGallery.style.display = "none";
        };
        document.addEventListener("click", function(event) {
            if (!modalGallery.contains(event.target) && !imageList.contains(event.target)) {
                modalGallery.style.display = "none";
                zoomImage = 1.5;
                modalImage.style.transform = `scale(1.5)`;
            }
        });
        modalGallery.appendChild(modalImage);
        modalGallery.appendChild(modalClose);
        for(let i = 0; imageElementsChildren.length - i >= 0; i++)if (imageElementsChildren[i] !== undefined && imageElementsChildren[i].innerHTML !== undefined) {
            var imgList = imageElementsChildren[i].getElementsByTagName("a");
            for(let j = 0; j < imgList.length; j++){
                imgList[j].setAttribute("href", "#");
                imgList[j].setAttribute("src", imgList[j].firstChild.src);
                imgList[j].setAttribute("class", "image-list-item");
            }
            imgList = imageElementsChildren[i].getElementsByTagName("img");
            //for single thumbnail
            if (imgList.length == 1) {
                imgList[0].style.maxWidth = "fit-content";
                imgList[0].style.maxHeight = "180px";
            }
            for(let j = 0; j < imgList.length; j++)imgList[j].onclick = function() {
                modalGallery.style.display = "block";
                modalGallery.style.zIndex = 999;
                imageList.style.zIndex = 0;
                imageList.style.display = "hidden";
                modalImage.src = this.src;
            };
            imageList.appendChild(imageElementsChildren[i]);
        }
        fileElement1[0].insertAdjacentElement("beforebegin", modalGallery);
        mainElement.insertAdjacentElement("beforebegin", imageList);
    //mainElement.insertBefore(imageList, fileElement[0]);
    },
    buildGallery () {
        if (fileElement.length > 0) {
            var mainElement = document.getElementById(CONFIG.viewer.gallery.container);
            var imageElements;
            if (CONFIG.viewer.gallery.imageClass !== "") {
                imageElements = document.getElementsByClassName(CONFIG.viewer.gallery.imageClass);
                if (imageElements.length > 0) {
                    var galleryLabel = document.getElementsByClassName("field__label");
                    if (galleryLabel !== undefined) galleryLabel[0].innerText = "";
                }
            } else if (CONFIG.viewer.gallery.imageId !== "") imageElements = document.getElementById(CONFIG.viewer.gallery.imageId);
            else console.log("No gallery created");
            if (imageElements !== null) {
                if (imageElements.length > 0) {
                    if (imageElements[0].innerHTML !== undefined) {
                        let imagesList = Array.from(imageElements[0].getElementsByClassName("field__items")[0].childNodes);
                        prepareGalleryImages(imagesList);
                        //imageElements[0].classList.add("field--type-image");
                        imageElements[0].classList.add("field--label-hidden");
                        imageElements[0].classList.add("field__items");
                        handleImages(fileElement, mainElement, imagesList, imageElements);
                    } else handleImages(fileElement, mainElement, imageElements);
                } else if (imageElements.childNodes !== undefined && imageElements.childNodes.length > 0) {
                    if (typeof imageElements.childNodes[0].innerHTML == "string" || typeof imageElements.childNodes[1].innerHTML == "string") {
                        //handle links and convert to img
                        let imagesList = Array.from(imageElements.childNodes);
                        prepareGalleryImages(imagesList);
                        imageElements.classList.add("field--type-image");
                        imageElements.classList.add("field--label-hidden");
                        imageElements.classList.add("field__items");
                        handleImages(fileElement, mainElement, imagesList, imageElements);
                    } else handleImages(fileElement, mainElement, imageElements);
                }
            }
        }
    },
    async setupEmptyCamera (_camera, _object, _helperObjects) {
        var boundingBox = new (0, _initJsDefault.default).Box3();
        if (Array.isArray(_object)) for(let i = 0; i < _object.length; i++)boundingBox.setFromObject(_object[i]);
        else boundingBox.setFromObject(_object);
        var size = new (0, _initJsDefault.default).Vector3();
        boundingBox.getSize(size);
        camera.position.set(size.x, size.y, size.z);
        fitCameraToCenteredObject(_camera, _object, 1.2, true, _helperObjects);
    },
    pickFaces (_id) {
        if (lastPickedFace.id == "" && _id !== "") lastPickedFace = {
            id: _id,
            color: _id.object.material.color.getHex(),
            object: _id.object.id
        };
        else if (_id == "" && lastPickedFace.id !== "") {
            scene.getObjectById(lastPickedFace.object).material.color.setHex(lastPickedFace.color);
            lastPickedFace = {
                id: "",
                color: "",
                object: ""
            };
        } else if (_id != lastPickedFace.id) {
            scene.getObjectById(lastPickedFace.object).material.color.setHex(lastPickedFace.color);
            lastPickedFace = {
                id: _id,
                color: _id.object.material.color.getHex(),
                object: _id.object.id
            };
        }
        if (_id !== "") _id.object.material.color.setHex(0xff0000);
    },
    buildRuler (_id) {
        rulerObject = new (0, _initJsDefault.default).Object3D();
        var sphere = new (0, _initJsDefault.default).Mesh(new (0, _initJsDefault.default).SphereGeometry(gridSize / 150, 7, 7), new (0, _initJsDefault.default).MeshNormalMaterial({
            transparent: true,
            opacity: 0.8,
            side: (0, _initJsDefault.default).DoubleSide,
            depthTest: false,
            depthWrite: false
        }));
        var newPoint = new (0, _initJsDefault.default).Vector3(_id.point.x, _id.point.y, _id.point.z);
        sphere.position.set(newPoint.x, newPoint.y, newPoint.z);
        rulerObject.add(sphere);
        linePoints.push(newPoint);
        const lineGeometry = new (0, _initJsDefault.default).BufferGeometry().setFromPoints(linePoints);
        const line = new (0, _initJsDefault.default).Line(lineGeometry, lineMaterial);
        rulerObject.add(line);
        var lineMtr = new (0, _initJsDefault.default).LineBasicMaterial({
            color: 0x0000ff,
            linewidth: 3,
            opacity: 1,
            side: (0, _initJsDefault.default).DoubleSide,
            depthTest: false,
            depthWrite: false
        });
        if (linePoints.length > 1) {
            var vectorPoints = (0, _utilsJs.vectorBetweenPoints)(linePoints[linePoints.length - 2], newPoint);
            var distancePoints = (0, _utilsJs.distanceBetweenPointsVector)(vectorPoints);
            //var distancePoints = distanceBetweenPoints(linePoints[linePoints.length-2], newPoint);
            var halfwayPoints = (0, _utilsJs.halfwayBetweenPoints)(linePoints[linePoints.length - 2], newPoint);
            addTextPoint(distancePoints.toFixed(2), gridSize / 200, halfwayPoints);
            var rulerI = 0;
            var measureSize = gridSize / 400;
            while(rulerI <= distancePoints * 100){
                const geoSegm = [];
                var interpolatePoints = (0, _utilsJs.interpolateDistanceBetweenPoints)(linePoints[linePoints.length - 2], vectorPoints, distancePoints, rulerI / 100);
                geoSegm.push(new (0, _initJsDefault.default).Vector3(interpolatePoints.x, interpolatePoints.y, interpolatePoints.z));
                geoSegm.push(new (0, _initJsDefault.default).Vector3(interpolatePoints.x + measureSize, interpolatePoints.y + measureSize, interpolatePoints.z + measureSize));
                const geometryLine = new (0, _initJsDefault.default).BufferGeometry().setFromPoints(geoSegm);
                var lineSegm = new (0, _initJsDefault.default).Line(geometryLine, lineMtr);
                rulerObject.add(lineSegm);
                rulerI += 10;
            }
        }
        rulerObject.renderOrder = 1;
        scene.add(rulerObject);
        ruler.push(rulerObject);
    },
    updateSize () {
        const isFullscreen = !!document.fullscreenElement;
        Viewer.FULLSCREEN = isFullscreen;
        let widthCSS, heightCSS; // CSS pixels (for layout)
        let widthDev, heightDev; // Device pixels (for Three.js)
        if (isFullscreen) {
            widthCSS = window.innerWidth;
            heightCSS = window.innerHeight;
            widthDev = widthCSS * devicePixelRatio;
            heightDev = heightCSS * devicePixelRatio;
            Viewer.mainCanvas.style.width = '100vw';
            Viewer.mainCanvas.style.height = '100vh';
            Viewer.metadataContainer.style.width = '10%';
            Viewer.metadataContainer.style.height = '10%';
            Viewer.downloadModel?.setAttribute("style", "visibility: hidden");
        } else {
            const rect = Viewer.container.getBoundingClientRect();
            widthCSS = rect.width * Number(Viewer.CONFIG.viewer.scaleContainer.x);
            heightCSS = rect.height * Number(Viewer.CONFIG.viewer.scaleContainer.y);
            Viewer.mainCanvas.style.width = widthCSS + 'px';
            Viewer.mainCanvas.style.height = heightCSS + 'px';
            // Convert to device pixels for Three.js
            widthDev = widthCSS * devicePixelRatio;
            heightDev = heightCSS * devicePixelRatio;
            Viewer.metadataContainer.style.width = '100%';
            Viewer.metadataContainer.style.height = '100%';
            Viewer.downloadModel?.setAttribute("style", "visibility: visible");
        }
        //CONFIG.viewer.canvasDimensions = { x: widthCSS, y: heightCSS };
        // Three.js renderer needs actual pixel size
        Viewer.renderer.setSize(widthCSS, heightDev);
        Viewer.renderer.setPixelRatio(devicePixelRatio);
        Viewer.camera.aspect = widthCSS / heightCSS;
        Viewer.camera.updateProjectionMatrix();
        Viewer.fullscreenMode.style.top = heightCSS - 60 + 'px';
        Viewer.fullscreenMode.style.left = widthCSS - 56 + 'px';
        if (Viewer.downloadModel && !isFullscreen) Viewer.downloadModel.style.top = heightCSS - 85 + 'px';
        if (Viewer.viewEntity) Viewer.viewEntity.style.right = isFullscreen ? '-95%' : '-75%';
        // GUI positioning
        const guiWidth = Viewer.lilGui[0]?.getBoundingClientRect().width || 0;
        Viewer.lilGui[0]?.style.setProperty('left', `${widthCSS - guiWidth - 10}px`);
        Viewer.controls?.update();
    },
    // Proper fullscreen toggle
    async toggleFullscreen () {
        if (!document.fullscreenElement) try {
            await Viewer.container.requestFullscreen();
        // fullscreenchange event will trigger updateSize()
        } catch (err) {
            console.error("Failed to enter fullscreen:", err);
        }
        else await document.exitFullscreen();
    },
    exitFullscreenHandler () {
        var fullscreenElement = document.fullscreenElement || document.mozFullScreenElement || document.webkitFullscreenElement;
        var fullscreenElement2 = document.webkitIsFullScreen && document.mozFullScreen && document.msFullscreenElement;
        if (!fullscreenElement && typeof (fullscreenElement2 === undefined) && Viewer.FULLSCREEN) fullscreen();
    },
    animate: (time)=>{
        requestAnimationFrame(Viewer.animate);
        const delta = Viewer.clock.getDelta();
        if (Viewer.mixer) Viewer.mixer.update(delta);
        Viewer.tween.update(time);
        Viewer.controls.update();
        if (Viewer.textMesh !== null) Viewer.textMesh.lookAt(Viewer.camera.position.clone());
        Viewer.renderer.clear();
        Viewer.renderer.render(Viewer.scene, Viewer.camera);
        Viewer.stats.update();
    },
    onPointerDown (e) {
        e.stopPropagation();
        if (e.button === 0) {
            Viewer.onDownPosition.x = (e.clientX - Viewer.mainCanvas.getBoundingClientRect().left) / Viewer.renderer.domElement.clientWidth * 2 - 1;
            Viewer.onDownPosition.y = -((e.clientY - Viewer.mainCanvas.getBoundingClientRect().top) / Viewer.renderer.domElement.clientHeight) * 2 + 1;
        }
    },
    onPointerUp (e) {
        if (e.button == 0) {
            Viewer.onUpPosition.x = (e.clientX - Viewer.mainCanvas.getBoundingClientRect().left) / Viewer.renderer.domElement.clientWidth * 2 - 1;
            Viewer.onUpPosition.y = -((e.clientY - Viewer.mainCanvas.getBoundingClientRect().top) / Viewer.renderer.domElement.clientHeight) * 2 + 1;
            if (Viewer.onUpPosition.x === Viewer.onDownPosition.x && Viewer.onUpPosition.y === Viewer.onDownPosition.y) {
                Viewer.raycaster.setFromCamera(Viewer.onUpPosition, Viewer.camera);
                var intersects;
                if (Viewer.EDITOR || Viewer.RULER_MODE) {
                    if (Viewer.mainObject.length > 1) {
                        for(let ii = 0; ii < Viewer.mainObject.length; ii++)intersects = Viewer.raycaster.intersectObjects(Viewer.mainObject[ii].children, true);
                        if (intersects.length <= 0) intersects = Viewer.raycaster.intersectObjects(Viewer.mainObject, true);
                    } else intersects = Viewer.raycaster.intersectObject(Viewer.mainObject[0], true);
                    if (intersects.length > 0) {
                        if (Viewer.RULER_MODE) buildRuler(intersects[0]);
                        else if (Viewer.EDITOR) pickFaces(intersects[0]);
                    }
                }
            }
        }
    },
    onPointerMove (e) {
        Viewer.pointer.x = (e.clientX - Viewer.mainCanvas.getBoundingClientRect().left) / Viewer.renderer.domElement.clientWidth * 2 - 1;
        Viewer.pointer.y = -((e.clientY - Viewer.mainCanvas.getBoundingClientRect().top) / Viewer.renderer.domElement.clientHeight) * 2 + 1;
        if (e.buttons == 1) {
            if (Viewer.pointer.x !== Viewer.onDownPosition.x && Viewer.pointer.y !== Viewer.onDownPosition.y) Viewer.cameraLight.position.set(Viewer.camera.position.x, Viewer.camera.position.y, Viewer.camera.position.z);
        } else if (this.EDITOR) {
            Viewer.raycaster.setFromCamera(Viewer.pointer, Viewer.camera);
            var intersects;
            if (Viewer.mainObject.length > 1) {
                for(let ii = 0; ii < Viewer.mainObject.length; ii++)intersects = Viewer.raycaster.intersectObjects(Viewer.mainObject[ii].children, true);
                if (intersects.length <= 0) intersects = Viewer.raycaster.intersectObjects(Viewer.mainObject, true);
            } else intersects = Viewer.raycaster.intersectObject(Viewer.mainObject[0], true);
            if (intersects.length > 0) pickFaces(intersects[0]);
            else pickFaces("");
        }
    },
    changeScale () {
        if (this.transformControl.getMode() === "scale") switch(transformControl.axis){
            case "X":
            case "XY":
                this.helperObjects[0].scale.set(this.helperObjects[0].scale.x, this.helperObjects[0].scale.x, this.helperObjects[0].scale.x);
                break;
            case "Y":
            case "YZ":
                this.helperObjects[0].scale.set(this.helperObjects[0].scale.y, this.helperObjects[0].scale.y, this.helperObjects[0].scale.y);
                break;
            case "Z":
            case "XZ":
                this.helperObjects[0].scale.set(this.helperObjects[0].scale.x, this.helperObjects[0].scale.x, this.helperObjects[0].scale.x);
                break;
        }
    },
    calculateObjectScale () {
        const boundingBox = new (0, _initJsDefault.default).Box3();
        if (Array.isArray(this.helperObjects[0])) for(let i = 0; i < this.helperObjects[0].length; i++)boundingBox.setFromObject(this.object[i]);
        else boundingBox.setFromObject(this.helperObjects[0]);
        var middle = new (0, _initJsDefault.default).Vector3();
        var size = new (0, _initJsDefault.default).Vector3();
        boundingBox.getSize(size);
        // ground
        var _distance = new (0, _initJsDefault.default).Vector3(Math.abs(boundingBox.max.x - boundingBox.min.x), Math.abs(boundingBox.max.y - boundingBox.min.y), Math.abs(boundingBox.max.z - boundingBox.min.z));
        this.distanceGeometry = _distance;
        (0, _coreJs.setCore)("distanceGeometry", this.distanceGeometry);
        planeParams.planeX.constantZ = clippingFolder.controllers[1]._max = clippingPlanes[0].constant = _distance.x;
        clippingFolder.controllers[1]._min = -clippingFolder.controllers[1]._max;
        planeParams.planeY.constantY = clippingFolder.controllers[3]._max = clippingPlanes[1].constant = _distance.y;
        clippingFolder.controllers[3]._min = -clippingFolder.controllers[3]._max;
        planeParams.planeZ.constantZ = clippingFolder.controllers[5]._max = clippingPlanes[2].constant = _distance.z;
        clippingFolder.controllers[5]._min = -clippingFolder.controllers[5]._max;
        clippingFolder.controllers[1].updateDisplay();
        clippingFolder.controllers[3].updateDisplay();
        clippingFolder.controllers[5].updateDisplay();
        var _maxDistance = Math.max(_distance.x, _distance.y, _distance.z);
        planeHelpers[0].size = planeHelpers[1].size = planeHelpers[2].size = _maxDistance;
    },
    changeLightRotation () {
        this.lightHelper.update();
    },
    takeScreenshot () {
        /*const messDiv = document.createElement('div');
    messDiv.classList.add('message');
    document.body.appendChild(messDiv);*/ this.camera.aspect = 1;
        this.camera.updateProjectionMatrix();
        this.renderer.setSize(256, 256);
        this.renderer.render(this.scene, this.camera);
        var prependName = "";
        if (this.archiveType !== "") prependName = this.basename + "_" + this.archiveType.toUpperCase() + "/";
        this.mainCanvas.toBlob((imgBlob)=>{
            const fileform = new FormData();
            fileform.append("domain", CONFIG.mainUrl);
            fileform.append("filename", basename);
            fileform.append("path", uri + prependName);
            fileform.append("data", imgBlob);
            fileform.append("wisski_individual", entityID);
            fetch(CONFIG.mainUrl + "/thumbnail_upload.php", {
                method: "POST",
                body: fileform
            }).then((response)=>{
                console.log(response);
                return response;
            }).then((data)=>{
                if (data.error) //Show server errors
                (0, _viewerUtilsJs.showToast)(data.error);
                else //Show success message
                (0, _viewerUtilsJs.showToast)("Rendering saved successfully");
            }).catch((err)=>{
                //Handle js errors
                (0, _viewerUtilsJs.showToast)(err.message);
            });
        }, "image/png");
        renderer.setPixelRatio(devicePixelRatio);
        camera.aspect = CONFIG.viewer.canvasDimensions.x / CONFIG.viewer.canvasDimensions.y;
        camera.updateProjectionMatrix();
        renderer.setSize(CONFIG.viewer.canvasDimensions.x, CONFIG.viewer.canvasDimensions.y);
    },
    async mainLoadModel () {
        console.log("Loading model with extension:", this._ext);
        if (this._ext === "glb" || this._ext === "gltf") await (0, _loadersJs.loadModel)({
            fileObject: this.fileObject,
            config: this.CONFIG,
            getProxyPath: (0, _utilsJs.getProxyPath),
            camera: this.camera,
            lightObjects: this.lightObjects,
            controls: this.controls,
            scene: this.scene,
            mainObject: this.mainObject,
            outlineClipping: this.outlineClipping,
            circle: this.circle,
            gui: this.gui,
            stats: this.stats,
            entityID: this.entityID,
            container: this.container,
            metadataContainer: this.metadataContainer,
            canvasText: this.canvasText,
            bottomLineGUI: this.bottomLineGUI,
            compressedFile: this.compressedFile,
            viewEntity: this.viewEntity,
            helperObjects: this.helperObjects
        });
        else if (this._ext === "zip" || this._ext === "rar" || this._ext === "tar" || this._ext === "xz" || this._ext === "gz") {
            this.compressedFile = "_" + this._ext.toUpperCase() + "/";
            this.fileObject.path = this.fileObject.path + this.fileObject.basename + this.compressedFile;
            this.fileObject.extension = "glb";
            this.fileObject.newExtension = this._ext;
            await (0, _loadersJs.loadModel)(this.fileObject, config, (0, _utilsJs.getProxyPath), this.camera, this.lightObjects, this.controls, this.scene, this.mainObject, this.outlineClipping, this.circle, this.gui, this.stats, this.entityID, this.container, this.metadataContainer, this.canvasText, this.bottomLineGUI, this.compressedFile, this.viewEntity, this.helperObjects);
        } else {
            this.fileObject.extension = "glb";
            if (this._ext === "glb") await (0, _loadersJs.loadModel)(this.fileObject, this.CONFIG, (0, _utilsJs.getProxyPath), this.camera, this.lightObjects, this.controls, this.scene, this.mainObject, this.outlineClipping, this.circle, this.gui, this.stats, this.entityID, this.container, this.metadataContainer, this.canvasText, this.bottomLineGUI, this.compressedFile, this.viewEntity, this.helperObjects);
            else await (0, _loadersJs.loadModel)(this.fileObject, this.CONFIG, (0, _utilsJs.getProxyPath), this.camera, this.lightObjects, this.controls, this.scene, this.mainObject, this.outlineClipping, this.circle, this.gui, this.stats, this.entityID, this.container, this.metadataContainer, this.canvasText, this.bottomLineGUI, this.compressedFile, this.viewEntity, this.helperObjects);
        }
    },
    createClippingPlaneAxis (_number) {
        var tempClippingControl = new (0, _transformControlsJs.TransformControls)(this.camera, this.renderer.domElement);
        tempClippingControl.space = "local";
        tempClippingControl.mode = "translate";
        tempClippingControl.addEventListener("change", this.render);
        tempClippingControl.addEventListener("objectChange", function(event) {
            switch(_number){
                case 0:
                    this.clippingPlanes[_number].constant = event.target.children[0].pointEnd.x + this.distanceGeometry.x;
                    break;
                case 1:
                    this.clippingPlanes[_number].constant = event.target.children[0].pointEnd.y + this.distanceGeometry.y;
                    break;
                case 2:
                    this.clippingPlanes[_number].constant = event.target.children[0].pointEnd.z + this.distanceGeometry.z;
                    break;
            }
        });
        tempClippingControl.addEventListener("dragging-changed", function(event) {
            this.controls.enabled = !event.value;
        });
        return tempClippingControl;
    },
    resetCamera () {
        var camPosition = this.camera.position;
        let _tween = new Tween(camPosition).to((0, _coreJs.core).cameraCoords, 1500).onUpdate(()=>{
            this.camera.position.set(camPosition.x, camPosition.y, camPosition.z);
            this.cameraLight.position.set(camPosition.x, camPosition.y, camPosition.z);
            this.camera.updateProjectionMatrix();
            this.controls.update();
        }).start();
    },
    prepareStats () {
        // stats
        Viewer.stats = new (0, _statsJsDefault.default)();
        Viewer.stats.domElement.style.cssText = "position:relative;top:0px;left:" + (Viewer.CONFIG.viewer.canvasDimensions.x - 90) + "px;max-height:120px;max-width:90px;z-index:2;visibility:hidden;";
        Viewer.windowHalfX = Viewer.CONFIG.viewer.canvasDimensions.x / 2;
        Viewer.windowHalfY = Viewer.CONFIG.viewer.canvasDimensions.y / 2;
        Viewer.editorFolder = Viewer.gui.addFolder("Editor").close();
        Viewer.editorFolder.add(Viewer.transformText, "Transform 3D Object", {
            None: "",
            Move: "translate",
            Rotate: "rotate",
            Scale: "scale"
        }).onChange(function(value) {
            if (value === "") Viewer.transformControl.detach();
            else {
                Viewer.renderer.localClippingEnabled = false;
                Viewer.transformControl.mode = value;
                Viewer.transformControl.attach(Viewer.helperObjects[0]);
            }
        });
        Viewer.editorFolder.add(Viewer.transformText, "Transform Mode", {
            Local: "local",
            Global: "global"
        }).onChange(function(value) {
            Viewer.transformControl.space = value;
        });
        const lightFolder = Viewer.editorFolder.addFolder("Directional Light").close();
        lightFolder.add(Viewer.transformText, "Transform Light", {
            None: "",
            Move: "translate",
            Target: "rotate"
        }).onChange(function(value) {
            if (value === "") {
                Viewer.transformControlLight.detach();
                Viewer.transformControlLightTarget.detach();
                Viewer.lightHelper.visible = false;
            } else if (value === "translate") {
                Viewer.transformControlLight.mode = "translate";
                Viewer.transformControlLight.attach(Viewer.dirLight);
                Viewer.lightHelper.visible = true;
                Viewer.transformControlLightTarget.detach();
            } else {
                Viewer.transformControlLightTarget.mode = "translate";
                Viewer.transformControlLightTarget.attach(Viewer.dirLightTarget);
                Viewer.lightHelper.visible = true;
                Viewer.transformControlLight.detach();
            }
        });
        lightFolder.addColor(Viewer.colors, "DirectionalLight").onChange(function(value) {
            Viewer.lightObjects[0].color = new (0, _initJsDefault.default).Color(value);
        }).listen();
        lightFolder.add(Viewer.intensity, "startIntensityDir", 0, 10).onChange(function(value) {
            Viewer.lightObjects[0].intensity = value;
        }).listen();
        const lightFolderAmbient = Viewer.editorFolder.addFolder("Ambient Light").close();
        lightFolderAmbient.addColor(Viewer.colors, "AmbientLight").onChange(function(value) {
            Viewer.ambientLight.color = new (0, _initJsDefault.default).Color(value);
        }).listen();
        lightFolderAmbient.add(Viewer.intensity, "startIntensityAmbient", 0, 10).onChange(function(value) {
            Viewer.ambientLight.intensity = value;
        }).listen();
        const lightFolderCamera = Viewer.editorFolder.addFolder("Camera Light").close();
        lightFolderCamera.addColor(Viewer.colors, "CameraLight").onChange(function(value) {
            Viewer.cameraLight.color = new (0, _initJsDefault.default).Color(value);
        }).listen();
        lightFolderCamera.add(Viewer.intensity, "startIntensityCamera", 0, 10).onChange(function(value) {
            Viewer.cameraLight.intensity = value;
        }).listen();
        const backgroundFolder = Viewer.editorFolder.addFolder("Background Color").close();
        backgroundFolder.addColor(Viewer.colors, "BackgroundColor").onChange(function(value) {
            Viewer.changeBackground(Viewer.backgroundType["Background Type"], value, Viewer.colors["BackgroundColorOuter"]);
        }).listen();
        Viewer.backgroundOuterFolder = backgroundFolder.addColor(Viewer.colors, "BackgroundColorOuter").onChange(function(value) {
            Viewer.changeBackground(Viewer.backgroundType["Background Type"], Viewer.colors["BackgroundColor"], value);
        }).listen();
        backgroundFolder.add(Viewer.backgroundType, "Background Type", {
            Linear: "linear",
            Gradient: "gradient"
        }).onChange(function(value) {
            if (value == "linear") Viewer.backgroundOuterFolder.hide();
            else Viewer.backgroundOuterFolder.show();
            changeBackground(value, Viewer.colors["BackgroundColor"], Viewer.colors["BackgroundColorOuter"]);
        });
        Viewer.clippingFolder = Viewer.editorFolder.addFolder("Clipping Planes").close();
        (0, _coreJs.setCore)("clippingFolder", Viewer.clippingFolder);
        Viewer.core.materialsFolder = Viewer.editorFolder.addFolder("Materials").close();
        (0, _coreJs.setCore)("materialsFolder", Viewer.core.materialsFolder);
        if (!Viewer.CONFIG.viewer.lightweight) {
            Viewer.propertiesFolder = Viewer.editorFolder.addFolder("Save properties").close();
            Viewer.propertiesFolder.add(Viewer.saveProperties, "Position");
            Viewer.propertiesFolder.add(Viewer.saveProperties, "Rotation");
            Viewer.propertiesFolder.add(Viewer.saveProperties, "Scale");
            Viewer.propertiesFolder.add(Viewer.saveProperties, "Camera");
            Viewer.propertiesFolder.add(Viewer.saveProperties, "DirectionalLight");
            Viewer.propertiesFolder.add(Viewer.saveProperties, "AmbientLight");
            Viewer.propertiesFolder.add(Viewer.saveProperties, "CameraLight");
            Viewer.propertiesFolder.add(Viewer.saveProperties, "BackgroundColor");
        }
        if (Viewer.editor && !Viewer.CONFIG.viewer.lightweight) {
            Viewer.editorFolder.add({
                ["Save"] () {
                    var xhr = new XMLHttpRequest(), jsonArr, method = "POST", jsonRequestURL = CONFIG.mainUrl + "/editor.php";
                    xhr.open(method, jsonRequestURL, true);
                    xhr.setRequestHeader("Content-Type", "application/x-www-form-urlencoded");
                    var params;
                    var rotateMetadata = new (0, _initJsDefault.default).Vector3((0, _initJsDefault.default).MathUtils.radToDeg(helperObjects[0].rotation.x), (0, _initJsDefault.default).MathUtils.radToDeg(helperObjects[0].rotation.y), (0, _initJsDefault.default).MathUtils.radToDeg(helperObjects[0].rotation.z));
                    var newMetadata = new Object();
                    //Fetch data from original metadata file anyway before saving any changes
                    //var originalMetadata = [];
                    //var metadataUrl = path.replace("gltf/", "") + "metadata/" + filename + "_viewer";
                    if (CONFIG.entity.proxyPath !== undefined) metadataUrl = (0, _utilsJs.getProxyPath)(metadataUrl);
                    fetch(metadataUrl, {
                        cache: "no-cache"
                    }).then((response)=>{
                        if (response["status"] !== 404) return response.json();
                        else return response = {};
                    }).then((_data)=>{
                        if (typeof _data !== "undefined") {
                            if (typeof _data[`objPosition`] !== "undefined") originalMetadata["objPosition"] = _data["objPosition"];
                            if (typeof _data["objRotation"] !== "undefined") originalMetadata["objRotation"] = _data["objRotation"];
                            if (typeof _data["objScale"] !== "undefined") originalMetadata["objScale"] = _data["objScale"];
                            if (typeof _data["cameraPosition"] !== "undefined") originalMetadata["cameraPosition"] = _data["cameraPosition"];
                            if (typeof _data["controlsTarget"] !== "undefined") originalMetadata["controlsTarget"] = _data["controlsTarget"];
                            if (typeof _data["lightPosition"] !== "undefined") originalMetadata["lightPosition"] = _data["lightPosition"];
                            if (typeof _data["lightTarget"] !== "undefined") originalMetadata["lightTarget"] = _data["lightTarget"];
                            if (typeof _data["lightColor"] !== "undefined") originalMetadata["lightColor"] = _data["lightColor"];
                            if (typeof _data["lightIntensity"] !== "undefined") originalMetadata["lightIntensity"] = _data["lightIntensity"];
                            if (typeof _data["lightAmbientColor"] !== "undefined") originalMetadata["lightAmbientColor"] = _data["lightAmbientColor"];
                            if (typeof _data["lightAmbientIntensity"] !== "undefined") originalMetadata["lightAmbientIntensity"] = _data["lightAmbientIntensity"];
                            if (typeof _data["lightCameraColor"] !== "undefined") originalMetadata["lightCameraColor"] = _data["lightCameraColor"];
                            if (typeof _data["lightCameraIntensity"] !== "undefined") originalMetadata["lightCameraIntensity"] = _data["lightCameraIntensity"];
                            if (typeof _data["background"] !== "undefined") originalMetadata["background"] = _data["background"];
                            if (saveProperties.Position) newMetadata = Object.assign(newMetadata, {
                                objPosition: [
                                    helperObjects[0].position.x,
                                    helperObjects[0].position.y,
                                    helperObjects[0].position.z
                                ]
                            });
                            else newMetadata = Object.assign(newMetadata, {
                                objPosition: [
                                    originalMetadata["objPosition"][0],
                                    originalMetadata["objPosition"][1],
                                    originalMetadata["objPosition"][2]
                                ]
                            });
                            if (saveProperties.Rotation) newMetadata = Object.assign(newMetadata, {
                                objRotation: [
                                    rotateMetadata.x,
                                    rotateMetadata.y,
                                    rotateMetadata.z
                                ]
                            });
                            else newMetadata = Object.assign(newMetadata, {
                                objRotation: [
                                    originalMetadata["objRotation"][0],
                                    originalMetadata["objRotation"][1],
                                    originalMetadata["objRotation"][2]
                                ]
                            });
                            if (saveProperties.Scale) newMetadata = Object.assign(newMetadata, {
                                objScale: [
                                    helperObjects[0].scale.x,
                                    helperObjects[0].scale.y,
                                    helperObjects[0].scale.z
                                ]
                            });
                            else newMetadata = Object.assign(newMetadata, {
                                objScale: [
                                    originalMetadata["objScale"][0],
                                    originalMetadata["objScale"][1],
                                    originalMetadata["objScale"][2]
                                ]
                            });
                            if (saveProperties.Camera) newMetadata = Object.assign(newMetadata, {
                                cameraPosition: [
                                    camera.position.x,
                                    camera.position.y,
                                    camera.position.z
                                ],
                                controlsTarget: [
                                    controls.target.x,
                                    controls.target.y,
                                    controls.target.z
                                ]
                            });
                            else newMetadata = Object.assign(newMetadata, {
                                cameraPosition: [
                                    originalMetadata["cameraPosition"][0],
                                    originalMetadata["cameraPosition"][1],
                                    originalMetadata["cameraPosition"][2]
                                ],
                                controlsTarget: [
                                    originalMetadata["controlsTarget"][0],
                                    originalMetadata["controlsTarget"][1],
                                    originalMetadata["controlsTarget"][2]
                                ]
                            });
                            if (saveProperties.DirectionalLight) newMetadata = Object.assign(newMetadata, {
                                lightPosition: [
                                    dirLight.position.x,
                                    dirLight.position.y,
                                    dirLight.position.z
                                ],
                                lightTarget: [
                                    dirLight.rotation._x,
                                    dirLight.rotation._y,
                                    dirLight.rotation._z
                                ],
                                lightColor: [
                                    "#" + dirLight.color.getHexString().toUpperCase()
                                ],
                                lightIntensity: [
                                    dirLight.intensity
                                ]
                            });
                            else newMetadata = Object.assign(newMetadata, {
                                lightPosition: [
                                    originalMetadata["lightPosition"][0],
                                    originalMetadata["lightPosition"][1],
                                    originalMetadata["lightPosition"][2]
                                ],
                                lightTarget: [
                                    originalMetadata["lightTarget"][0],
                                    originalMetadata["lightTarget"][1],
                                    originalMetadata["lightTarget"][2]
                                ],
                                lightColor: [
                                    originalMetadata["lightColor"][0]
                                ],
                                lightIntensity: [
                                    originalMetadata["lightIntensity"][0]
                                ]
                            });
                            if (saveProperties.AmbientLight) newMetadata = Object.assign(newMetadata, {
                                lightAmbientColor: [
                                    "#" + ambientLight.color.getHexString().toUpperCase()
                                ],
                                lightAmbientIntensity: [
                                    ambientLight.intensity
                                ]
                            });
                            else newMetadata = Object.assign(newMetadata, {
                                lightAmbientColor: [
                                    originalMetadata["lightAmbientColor"][0]
                                ],
                                lightAmbientIntensity: [
                                    originalMetadata["lightAmbientIntensity"][0]
                                ]
                            });
                            if (saveProperties.CameraLight) newMetadata = Object.assign(newMetadata, {
                                lightCameraColor: [
                                    "#" + cameraLight.color.getHexString().toUpperCase()
                                ],
                                lightCameraIntensity: [
                                    cameraLight.intensity
                                ]
                            });
                            else newMetadata = Object.assign(newMetadata, {
                                lightCameraColor: [
                                    originalMetadata["lightCameraColor"][0]
                                ],
                                lightCameraIntensity: [
                                    originalMetadata["lightCameraIntensity"][0]
                                ]
                            });
                            if (saveProperties.BackgroundColor) newMetadata = Object.assign(newMetadata, {
                                background: [
                                    window.getComputedStyle(mainCanvas).background
                                ]
                            });
                            if (archiveType !== "") {
                                if (!compressedFile.includes(archiveType.toUpperCase())) compressedFile += "_" + archiveType.toUpperCase();
                                params = CONFIG.viewer.salt + "=" + JSON.stringify(newMetadata, null, "\t") + "&path=" + fileObject.uri + fileObject.basename + compressedFile + "/" + "&filename=" + filename;
                            } else params = CONFIG.viewer.salt + "=" + JSON.stringify(newMetadata, null, "\t") + "&path=" + uri + "&filename=" + filename;
                            xhr.onreadystatechange = function() {
                                if (xhr.readyState === XMLHttpRequest.DONE) {
                                    var status = xhr.status;
                                    if (status === 0 || status >= 200 && status < 400) (0, _viewerUtilsJs.showToast)("Settings have been saved.");
                                }
                            };
                            xhr.send(params);
                        }
                    }).catch((error)=>console.log(error));
                }
            }, "Save");
            if (!Viewer.CONFIG.viewer.lightweight) Viewer.editorFolder.add({
                ["Picking mode"] () {
                    Viewer.EDITOR = !EDITOR;
                    var _str;
                    Viewer.EDITOR ? _str = "enabled" : _str = "disabled";
                    (0, _viewerUtilsJs.showToast)("Face picking is " + _str);
                    if (!Viewer.EDITOR) ;
                    else Viewer.RULER_MODE = false;
                }
            }, "Picking mode");
            Viewer.editorFolder.add({
                ["Distance Measurement"] () {
                    Viewer.RULER_MODE = !Viewer.RULER_MODE;
                    var _str;
                    Viewer.RULER_MODE ? _str = "enabled" : _str = "disabled";
                    (0, _viewerUtilsJs.showToast)("Distance measurement mode is " + _str);
                    if (!RULER_MODE) {
                        Viewer.ruler.forEach((r)=>{
                            Viewer.scene.remove(r);
                        });
                        Viewer.rulerObject = new (0, _initJsDefault.default).Object3D();
                        Viewer.ruler = [];
                        Viewer.linePoints = [];
                    } else Viewer.EDITOR = false;
                }
            }, "Distance Measurement");
            if (!Viewer.CONFIG.viewer.lightweight) Viewer.editorFolder.add({
                ["Render preview"] () {
                    takeScreenshot();
                }
            }, "Render preview");
            Viewer.editorFolder.add({
                ["Reset camera position"] () {
                    resetCamera();
                }
            }, "Reset camera position");
        }
    },
    async init () {
        if (!Viewer.renderer) {
            Viewer.camera = new (0, _initJsDefault.default).PerspectiveCamera(45, Viewer.CONFIG.viewer.canvasDimensions.x / Viewer.CONFIG.viewer.canvasDimensions.y, 0.001, 999000000);
            Viewer.camera.position.set(0, 0, 0);
            (0, _coreJs.setCore)('camera', Viewer.camera);
            Viewer.scene = new (0, _initJsDefault.default).Scene();
            (0, _coreJs.setCore)('scene', Viewer.scene);
            const hemiLight = new (0, _initJsDefault.default).HemisphereLight(0xffffff, 0x444444);
            hemiLight.position.set(0, 200, 0);
            Viewer.scene.add(hemiLight);
            Viewer.ambientLight = new (0, _initJsDefault.default).AmbientLight(0x404040); // soft white light
            Viewer.scene.add(Viewer.ambientLight);
            (0, _coreJs.setCore)('ambientLight', Viewer.ambientLight);
            Viewer.dirLight = new (0, _initJsDefault.default).DirectionalLight(0xffffff);
            Viewer.dirLight.position.set(0, 100, 50);
            Viewer.dirLight.castShadow = true;
            Viewer.dirLight.shadow.camera.top = 180;
            Viewer.dirLight.shadow.camera.bottom = -100;
            Viewer.dirLight.shadow.camera.left = -120;
            Viewer.dirLight.shadow.camera.right = 120;
            Viewer.dirLight.shadow.bias = -0.0001;
            Viewer.dirLight.shadow.mapSize.width = 4096;
            Viewer.dirLight.shadow.mapSize.height = 4096;
            Viewer.scene.add(Viewer.dirLight);
            Viewer.lightObjects.push(Viewer.dirLight);
            (0, _coreJs.setCore)('dirLight', Viewer.dirLight);
            Viewer.cameraLightTarget = new (0, _initJsDefault.default).Object3D();
            Viewer.cameraLightTarget.position.set(Viewer.camera.position.x, Viewer.camera.position.y, Viewer.camera.position.z);
            Viewer.scene.add(Viewer.cameraLightTarget);
            // Store in core
            (0, _coreJs.setCore)('cameraLightTarget', Viewer.cameraLightTarget);
            Viewer.cameraLight = new (0, _initJsDefault.default).DirectionalLight(0xffffff);
            Viewer.cameraLight.position.set(Viewer.camera.position);
            Viewer.cameraLight.castShadow = false;
            Viewer.cameraLight.intensity = 0.3;
            Viewer.scene.add(Viewer.cameraLight);
            Viewer.cameraLight.target = Viewer.cameraLightTarget;
            // Store in core
            (0, _coreJs.setCore)('cameraLight', Viewer.cameraLight);
            Viewer.cameraLight.target.updateMatrixWorld();
            Viewer.renderer = new (0, _initJsDefault.default).WebGLRenderer({
                antialias: true,
                logarithmicDepthBuffer: true,
                colorManagement: true,
                sortObjects: true,
                preserveDrawingBuffer: true,
                powerPreference: "high-performance",
                alpha: true
            });
            Viewer.renderer.shadowMap.enabled = true;
            Viewer.renderer.localClippingEnabled = true;
            Viewer.renderer.physicallyCorrectLights = true; //can be considered as better looking
            Viewer.renderer.autoClear = false;
            Viewer.renderer.setClearColor(0x000000, 0.0);
            Viewer.renderer.domElement.id = "MainCanvas";
            Viewer.mainCanvas = document.getElementById("MainCanvas") || Viewer.renderer.domElement;
            Viewer.renderer.domElement.addEventListener("pointerdown", Viewer.onPointerDown);
            Viewer.renderer.domElement.addEventListener("pointerup", Viewer.onPointerUp);
            Viewer.renderer.domElement.addEventListener("pointermove", Viewer.onPointerMove);
            const devicePixelRatio1 = window.devicePixelRatio || 1;
            Viewer.renderer.setSize(Viewer.CONFIG.viewer.canvasDimensions.x, Viewer.CONFIG.viewer.canvasDimensions.y);
            Viewer.renderer.setPixelRatio(devicePixelRatio1);
            Viewer.renderer.domElement.style.width = Viewer.CONFIG.viewer.canvasDimensions.x + "px";
            Viewer.renderer.domElement.style.height = Viewer.CONFIG.viewer.canvasDimensions.y + "px";
            Viewer.renderer.domElement.style.display = "block";
            Viewer.container.appendChild(Viewer.renderer.domElement);
            Viewer.mainCanvas.classList.add("mainCanvas");
            Viewer.canvasText = document.createElement("div");
            Viewer.canvasText.id = "TextCanvas";
            Viewer.canvasText.width = Viewer.CONFIG.viewer.canvasDimensions.x + "px";
            Viewer.canvasText.height = Viewer.CONFIG.viewer.canvasDimensions.y + "px";
            Viewer.container.parentElement.classList.add("viewer-wrapper");
            Viewer.camera.aspect = Viewer.CONFIG.viewer.canvasDimensions.x / Viewer.CONFIG.viewer.canvasDimensions.y;
            Viewer.camera.updateProjectionMatrix();
            (0, _coreJs.setCore)('mainCanvas', Viewer.mainCanvas);
            Viewer.guiContainer.style.width = Viewer.CONFIG.viewer.canvasDimensions.x;
            Viewer.guiContainer.style.left = Viewer.container.getBoundingClientRect().left + "px";
            Viewer.lilGui = document.getElementsByClassName("lil-gui root");
            Viewer.lilGui[0].style.left = Viewer.CONFIG.viewer.canvasDimensions.x - Viewer.lilGui[0].getBoundingClientRect().width - 10 + "px";
            Viewer.fileElement = document.getElementsByClassName("field--type-file");
            if (Viewer.fileElement.length > 0) Viewer.fileElement[0].style.height = Viewer.CONFIG.viewer.canvasDimensions.y * 1.1 + "px";
            if (Viewer.CONFIG.viewer.lightweight === 0 || Viewer.CONFIG.viewer.lightweight === false) buildGallery();
            Viewer.controls = new (0, _orbitControlsJs.OrbitControls)(Viewer.camera, Viewer.renderer.domElement);
            Viewer.controls.target.set(0, 100, 0);
            Viewer.controls.enableDamping = true;
            Viewer.controls.dampingFactor = 0.05;
            Viewer.controls.enableRotate = true;
            Viewer.controls.update();
            (0, _coreJs.setCore)('controls', Viewer.controls);
            Viewer.transformControl = new (0, _transformControlsJs.TransformControls)(Viewer.camera, Viewer.renderer.domElement);
            Viewer.transformControl.rotationSnap = (0, _initJsDefault.default).MathUtils.degToRad(5);
            Viewer.transformControl.space = "local";
            Viewer.transformControl.addEventListener("change", Viewer.render);
            Viewer.transformControl.addEventListener("objectChange", Viewer.changeScale);
            Viewer.transformControl.addEventListener("mouseUp", Viewer.calculateObjectScale);
            Viewer.transformControl.addEventListener("dragging-changed", function(event) {
                Viewer.controls.enabled = !event.value;
            });
            Viewer.scene.add(Viewer.transformControl.getHelper());
            Viewer.transformControlLight = new (0, _transformControlsJs.TransformControls)(Viewer.camera, Viewer.renderer.domElement);
            Viewer.transformControlLight.space = "local";
            Viewer.transformControlLight.addEventListener("change", Viewer.render);
            //Viewer.transformControlLight.addEventListener('objectChange', changeLightRotation);
            Viewer.transformControlLight.addEventListener("dragging-changed", function(event) {
                Viewer.controls.enabled = !event.value;
            });
            Viewer.scene.add(Viewer.transformControlLight.getHelper());
            Viewer.transformControlLightTarget = new (0, _transformControlsJs.TransformControls)(Viewer.camera, Viewer.renderer.domElement);
            Viewer.transformControlLightTarget.space = "global";
            Viewer.transformControlLightTarget.addEventListener("change", Viewer.render);
            Viewer.transformControlLightTarget.addEventListener("objectChange", Viewer.changeLightRotation);
            Viewer.transformControlLightTarget.addEventListener("dragging-changed", function(event) {
                Viewer.controls.enabled = !event.value;
            });
            Viewer.scene.add(Viewer.transformControlLightTarget.getHelper());
            Viewer.transformControlClippingPlaneX = Viewer.createClippingPlaneAxis(0, "x");
            Viewer.transformControlClippingPlaneY = Viewer.createClippingPlaneAxis(1, "y");
            Viewer.transformControlClippingPlaneZ = Viewer.createClippingPlaneAxis(2, "z");
            (0, _coreJs.setCore)('transformControlClippingPlaneX', Viewer.transformControlClippingPlaneX);
            (0, _coreJs.setCore)('transformControlClippingPlaneY', Viewer.transformControlClippingPlaneY);
            (0, _coreJs.setCore)('transformControlClippingPlaneZ', Viewer.transformControlClippingPlaneZ);
            (0, _coreJs.setCore)('clippingPlanes', Viewer.clippingPlanes);
            Viewer.transformControlClippingPlaneX.showX = Viewer.transformControlClippingPlaneX.showY = false;
            Viewer.transformControlClippingPlaneY.showX = Viewer.transformControlClippingPlaneY.showY = false;
            Viewer.transformControlClippingPlaneZ.showX = Viewer.transformControlClippingPlaneZ.showY = false;
            Viewer._ext = Viewer.fileObject.extension.toLowerCase();
            if (Viewer._ext === "zip" || Viewer._ext === "rar" || Viewer._ext === "tar" || Viewer._ext === "xz" || Viewer._ext === "gz") archiveType = Viewer._ext;
            var _autoPath = "";
            if (Viewer.CONFIG.entity.metadata.source === "" && (Viewer.CONFIG.viewer.lightweight === 0 || Viewer.CONFIG.viewer.lightweight === false)) {
                var req = new XMLHttpRequest();
                req.responseType = "";
                req.open("GET", Viewer.CONFIG.metadataUrl + Viewer.CONFIG.viewer.exportPath + entityID + "?page=0&amp;_format=xml", true);
                req.onreadystatechange = async function(aEvt) {
                    if (req.readyState == 4) {
                        if (req.status == 200) {
                            const parser = new DOMParser();
                            const doc = parser.parseFromString(req.responseText, "application/xml");
                            if (doc.documentElement.childNodes > 0) {
                                var data = doc.documentElement.childNodes[0].childNodes;
                                var _found = false;
                                for(var i = 0; i < data.length && !_found; i++)if (typeof data[i].tagName !== "undefined" && typeof data[i].textContent !== "undefined") {
                                    var _label = data[i].tagName.replace("wisski_path_3d_model__", "");
                                    if (typeof _label !== "undefined" && _label === "converted_file") {
                                        _found = true;
                                        _autoPath = data[i].textContent;
                                    }
                                }
                            }
                            //check wheter semo-automatic path found
                            if (_autoPath !== "") {
                                Viewer.fileObject.filename = _autoPath.split("/").pop();
                                Viewer.fileObject.basename = Viewer.fileObject.filename.substring(0, Viewer.fileObject.filename.lastIndexOf("."));
                                Viewer.fileObject.extension = Viewer.fileObject.filename.substring(Viewer.fileObject.filename.lastIndexOf(".") + 1);
                                Viewer._ext = fileObject.extension.toLowerCase();
                                Viewer.fileObject.path = _autoPath.substring(0, _autoPath.lastIndexOf(Viewer.fileObject.filename));
                            }
                            await mainLoadModel(Viewer._ext);
                        } else {
                            console.log("Error during loading metadata content\n");
                            await mainLoadModel(Viewer._ext);
                        }
                    }
                };
                req.send(null);
            } else if (Viewer.CONFIG.entity.metadata.source.toLowerCase().substring(0, 4) === "iiif") {
                const formContainer = document.createElement("div");
                formContainer.id = "form-IIIF";
                formContainer.innerHTML = `
            <div class="form-IIIF-group">
              <input type="text" id="manifest-url" name="manifest-url" value="">
              <button id="load-manifest-from-url">Load Manifest From URL</button>
            </div>
            <div class="form-IIIF-group">
              <textarea id="manifest-text" name="manifest-text" rows="10"></textarea>
              <p>
                <button id="load-manifest-from-text">Load Manifest From Text</button>
              </p>
            </div>
          `;
                document.body.appendChild(formContainer);
                async function setupIIIF(newUrlOrJson, type = "url") {
                    if (type === "text") Viewer.iiifConfigURL.url = "";
                    else Viewer.iiifConfigURL.url = newUrlOrJson;
                    const loadedIIIF = await (0, _iiifApiJs.loadIIIFManifest)(newUrlOrJson);
                    if (loadedIIIF.modelUrls.length === 0) {
                        loadedIIIF.modelUrls.push('https://raw.githubusercontent.com/IIIF/3d/main/assets/astronaut/astronaut.glb');
                        (0, _viewerUtilsJs.showToast)("No 3D model found in IIIF manifest, loading example model.");
                    }
                    let ind = 0;
                    // reset scene
                    Viewer.mainObject.forEach((obj)=>{
                        Viewer.scene.remove(obj);
                    });
                    Viewer.mainObject = [];
                    console.log("TOTAL Annotations: " + loadedIIIF.annotations.length);
                    if (loadedIIIF.annotations.length !== loadedIIIF.modelUrls.length) {
                        //console.warn("Number of annotations does not match number of model URLs, adding testing model...");
                        const diff = loadedIIIF.annotations.length - loadedIIIF.modelUrls.length;
                        if (diff > 0) // Need more model URLs → push empty strings (or null)
                        for(let i = 0; i < diff; i++){
                            loadedIIIF.modelUrls.push(Viewer.testModelURL);
                            (0, _objectSettingsJs.objectsConfig).models.push({
                                name: "Test Model",
                                url: Viewer.testModelURL
                            });
                        }
                    }
                    for (const [i, url] of loadedIIIF.modelUrls?.entries()){
                        (0, _objectSettingsJs.objectsConfig).index = i;
                        Viewer.fileObject.originalPath = loadedIIIF.modelUrl = url;
                        //fileObject.originalPath = loadedIIIF.modelUrl;
                        Viewer.setModelPaths(Viewer.fileObject);
                        await (0, _iiifApiJs.getAnnotations)(loadedIIIF, (0, _objectSettingsJs.objectsConfig));
                        if (loadedIIIF.scenes && loadedIIIF.scenes.length > 0) (0, _objectSettingsJs.objectsConfig).scenes = loadedIIIF.scenes;
                        Viewer._ext = Viewer.fileObject.extension.toLowerCase();
                        await Viewer.mainLoadModel(Viewer._ext);
                    }
                }
                function isUrlFlexible(string) {
                    try {
                        new URL(string);
                        return true;
                    } catch  {
                        return /^(https?:\/\/)?([\w-]+\.)+[\w-]{2,}(\/\S*)?$/i.test(string);
                    }
                }
                function isValidJsonObject(text) {
                    try {
                        const parsed = JSON.parse(text);
                        return typeof parsed === 'object' && parsed !== null;
                    } catch  {
                        return false;
                    }
                }
                async function loadIIIFURL() {
                    // create a small dropdown to switch iiif manifests at runtime
                    document.getElementById("iiif-dropdown").addEventListener("change", async (ev)=>{
                        try {
                            if (ev.target.value !== Viewer.iiifConfigURL.url) {
                                (0, _objectSettingsJs.objectsConfig).setupIndex = 0;
                                await setupIIIF(ev.target.value, "url");
                            }
                        } catch (err) {
                            console.error(err);
                            (0, _viewerUtilsJs.showToast)("Error loading IIIF manifest: " + (err.message || err));
                        }
                    });
                    document.getElementById("load-manifest-from-url").addEventListener("click", async (ev)=>{
                        try {
                            const inputElement = document.getElementById("manifest-url");
                            if (inputElement.value === "" || !isUrlFlexible(inputElement.value)) {
                                inputElement.style.border = "2px solid red";
                                (0, _viewerUtilsJs.showToast)("Please enter a valid IIIF manifest URL.");
                                return;
                            } else {
                                inputElement.style.border = "2px solid green";
                                (0, _objectSettingsJs.objectsConfig).setupIndex = 0;
                                console.log("Loading IIIF manifest from URL: " + inputElement.value);
                                await setupIIIF(inputElement.value, "url");
                            }
                        } catch (err) {
                            console.error(err);
                            (0, _viewerUtilsJs.showToast)("Error loading IIIF manifest: " + (err.message || err));
                        }
                    });
                    document.getElementById("load-manifest-from-text").addEventListener("click", async (ev)=>{
                        try {
                            const inputElement = document.getElementById("manifest-text");
                            if (inputElement.value === "" || !isValidJsonObject(inputElement.value)) {
                                inputElement.style.border = "2px solid red";
                                (0, _viewerUtilsJs.showToast)("Please enter a valid IIIF JSON text.");
                                return;
                            } else {
                                inputElement.style.border = "2px solid green";
                                (0, _objectSettingsJs.objectsConfig).setupIndex = 0;
                                console.log("Loading IIIF manifest from privided text");
                                await setupIIIF(inputElement.value, "text");
                            }
                        } catch (err) {
                            console.error(err);
                            (0, _viewerUtilsJs.showToast)("Error loading IIIF manifest: " + (err.message || err));
                        }
                    });
                }
                switch(Viewer.CONFIG.entity.metadata.source.substring(0, 4).toLowerCase()){
                    case "iiif":
                        if (Viewer.iiifConfigURL.url !== "") {
                            (0, _metadataJs.createIIIFDropdown)(Viewer.container, Viewer.iiifConfigURL, Viewer.CONFIG.viewer.canvasDimensions);
                            await loadIIIFURL();
                            Viewer.CONFIG.entity.metadata.source = "IIIF";
                            await setupIIIF(Viewer.iiifConfigURL.url);
                        }
                        break;
                    case "file":
                        break;
                }
            }
            Viewer.fullscreenMode = document.createElement("div");
            Viewer.fullscreenMode.setAttribute("id", "fullscreenMode");
            Viewer.fullscreenMode.innerHTML = "<img src='" + DFG_ASSETS + "img/fullscreen.png' alt='Fullscreen' width=20 height=20 title='Fullscreen mode'/>";
            Viewer.fullscreenMode.setAttribute("style", "top:" + (Viewer.bottomLineGUI + 20) + "px; left: " + (Viewer.CONFIG.viewer.canvasDimensions.x - 36) + "px");
            Viewer.renderer.setPixelRatio(devicePixelRatio1);
            window.addEventListener('resize', Viewer.updateSize);
            document.addEventListener('fullscreenchange', Viewer.updateSize);
            window.addEventListener('orientationchange', ()=>setTimeout(Viewer.updateSize, 100));
            //updateSize();
            Viewer.container.appendChild(Viewer.fullscreenMode);
            document.getElementById("fullscreenMode").addEventListener("click", Viewer.toggleFullscreen, false);
        }
    },
    render () {
        Viewer.controls?.update();
        Viewer.renderer?.render(Viewer.scene, Viewer.camera);
    }
};
window.DFG_ASSETS = (()=>{
    const script = document.currentScript?.src || '';
    if (script.includes('/modules/custom/dfg_3dviewer/dist/')) return script.replace(/dfg_3dviewer-module\.js.*$/, 'assets/');
    return 'assets/';
})();
(async function() {
    await Viewer.MainInit();
    Viewer.init();
    if (Viewer.CONFIG.entity?.metadata?.source == "") Viewer.mainLoadModel();
    Viewer.prepareStats();
    Viewer.animate();
})();

},{"./core.js":"1fEas","./utils.js":"jZczM","./viewer-utils.js":"aZ3yt","./loaders.js":"5MUYx","./metadata.js":"4eKqp","./js/external_libs/lil-gui.esm.min.js":"cWEJz","./object-settings.js":"kB65H","./spinner/main.js":"gUa3f","./IIIF/iiif-api.js":"yjLHd","@parcel/transformer-js/src/esmodule-helpers.js":"jnFvT","three/examples/jsm/controls/OrbitControls.js":"45ipX","three/examples/jsm/controls/TransformControls.js":"bVhjV","three/examples/jsm/loaders/FontLoader.js":"hX71W","three/examples/jsm/geometries/TextGeometry.js":"4gbT1","./init.js":"hyhZi","three/examples/jsm/libs/tween.module.js":"HI0Qj","stats.js":"81UMC","./viewer-settings.js":"fRwPd"}],"1fEas":[function(require,module,exports,__globalThis) {
var parcelHelpers = require("@parcel/transformer-js/src/esmodule-helpers.js");
parcelHelpers.defineInteropFlag(exports);
parcelHelpers.export(exports, "core", ()=>core);
parcelHelpers.export(exports, "setCore", ()=>setCore);
var _initJs = require("./init.js");
var _initJsDefault = parcelHelpers.interopDefault(_initJs);
var _tweenModuleJs = require("three/examples/jsm/libs/tween.module.js");
var _tweenModuleJsDefault = parcelHelpers.interopDefault(_tweenModuleJs);
const core = {
    clippingPlanes: null,
    materialsFolder: null,
    materialsPropertiesText: null,
    camera: null,
    colors: {},
    intensity: {},
    ambientLight: null,
    cameraLight: null,
    mainCanvas: null,
    gridSize: null,
    dirLightTarget: null,
    lightHelper: null,
    Scene: new (0, _initJsDefault.default).Scene(),
    basicGrid: new (0, _initJsDefault.default).Group(),
    cameraCoords: null,
    tween: new (0, _tweenModuleJsDefault.default).Tween(),
    controls: null,
    transformControlClippingPlaneY: null,
    transformControlClippingPlaneX: null,
    transformControlClippingPlaneZ: null,
    planeHelpers: null,
    outlineClipping: null,
    sceneBackgroundColor: null,
    distanceGeometry: null,
    planeParams: null,
    clippingFolder: null
};
const setCore = (key, value)=>{
    core[key] = value;
};

},{"@parcel/transformer-js/src/esmodule-helpers.js":"jnFvT","./init.js":"hyhZi","three/examples/jsm/libs/tween.module.js":"HI0Qj"}],"jnFvT":[function(require,module,exports,__globalThis) {
exports.interopDefault = function(a) {
    return a && a.__esModule ? a : {
        default: a
    };
};
exports.defineInteropFlag = function(a) {
    Object.defineProperty(a, '__esModule', {
        value: true
    });
};
exports.exportAll = function(source, dest) {
    Object.keys(source).forEach(function(key) {
        if (key === 'default' || key === '__esModule' || Object.prototype.hasOwnProperty.call(dest, key)) return;
        Object.defineProperty(dest, key, {
            enumerable: true,
            get: function() {
                return source[key];
            }
        });
    });
    return dest;
};
exports.export = function(dest, destName, get) {
    Object.defineProperty(dest, destName, {
        enumerable: true,
        get: get
    });
};

},{}],"hyhZi":[function(require,module,exports,__globalThis) {
var parcelHelpers = require("@parcel/transformer-js/src/esmodule-helpers.js");
parcelHelpers.defineInteropFlag(exports);
var _three = require("three");
window.THREE = _three;
exports.default = _three;

},{"three":"dsoTF","@parcel/transformer-js/src/esmodule-helpers.js":"jnFvT"}],"dsoTF":[function(require,module,exports,__globalThis) {
/**
 * @license
 * Copyright 2010-2025 Three.js Authors
 * SPDX-License-Identifier: MIT
 */ var parcelHelpers = require("@parcel/transformer-js/src/esmodule-helpers.js");
parcelHelpers.defineInteropFlag(exports);
parcelHelpers.export(exports, "AdditiveAnimationBlendMode", ()=>(0, _threeCoreJs.AdditiveAnimationBlendMode));
parcelHelpers.export(exports, "AlwaysStencilFunc", ()=>(0, _threeCoreJs.AlwaysStencilFunc));
parcelHelpers.export(exports, "AmbientLight", ()=>(0, _threeCoreJs.AmbientLight));
parcelHelpers.export(exports, "AnimationAction", ()=>(0, _threeCoreJs.AnimationAction));
parcelHelpers.export(exports, "AnimationClip", ()=>(0, _threeCoreJs.AnimationClip));
parcelHelpers.export(exports, "AnimationLoader", ()=>(0, _threeCoreJs.AnimationLoader));
parcelHelpers.export(exports, "AnimationMixer", ()=>(0, _threeCoreJs.AnimationMixer));
parcelHelpers.export(exports, "AnimationObjectGroup", ()=>(0, _threeCoreJs.AnimationObjectGroup));
parcelHelpers.export(exports, "AnimationUtils", ()=>(0, _threeCoreJs.AnimationUtils));
parcelHelpers.export(exports, "ArcCurve", ()=>(0, _threeCoreJs.ArcCurve));
parcelHelpers.export(exports, "ArrowHelper", ()=>(0, _threeCoreJs.ArrowHelper));
parcelHelpers.export(exports, "AttachedBindMode", ()=>(0, _threeCoreJs.AttachedBindMode));
parcelHelpers.export(exports, "Audio", ()=>(0, _threeCoreJs.Audio));
parcelHelpers.export(exports, "AudioAnalyser", ()=>(0, _threeCoreJs.AudioAnalyser));
parcelHelpers.export(exports, "AudioContext", ()=>(0, _threeCoreJs.AudioContext));
parcelHelpers.export(exports, "AudioListener", ()=>(0, _threeCoreJs.AudioListener));
parcelHelpers.export(exports, "AudioLoader", ()=>(0, _threeCoreJs.AudioLoader));
parcelHelpers.export(exports, "AxesHelper", ()=>(0, _threeCoreJs.AxesHelper));
parcelHelpers.export(exports, "BasicDepthPacking", ()=>(0, _threeCoreJs.BasicDepthPacking));
parcelHelpers.export(exports, "BasicShadowMap", ()=>(0, _threeCoreJs.BasicShadowMap));
parcelHelpers.export(exports, "BatchedMesh", ()=>(0, _threeCoreJs.BatchedMesh));
parcelHelpers.export(exports, "Bone", ()=>(0, _threeCoreJs.Bone));
parcelHelpers.export(exports, "BooleanKeyframeTrack", ()=>(0, _threeCoreJs.BooleanKeyframeTrack));
parcelHelpers.export(exports, "Box2", ()=>(0, _threeCoreJs.Box2));
parcelHelpers.export(exports, "Box3", ()=>(0, _threeCoreJs.Box3));
parcelHelpers.export(exports, "Box3Helper", ()=>(0, _threeCoreJs.Box3Helper));
parcelHelpers.export(exports, "BoxHelper", ()=>(0, _threeCoreJs.BoxHelper));
parcelHelpers.export(exports, "BufferGeometryLoader", ()=>(0, _threeCoreJs.BufferGeometryLoader));
parcelHelpers.export(exports, "Cache", ()=>(0, _threeCoreJs.Cache));
parcelHelpers.export(exports, "Camera", ()=>(0, _threeCoreJs.Camera));
parcelHelpers.export(exports, "CameraHelper", ()=>(0, _threeCoreJs.CameraHelper));
parcelHelpers.export(exports, "CanvasTexture", ()=>(0, _threeCoreJs.CanvasTexture));
parcelHelpers.export(exports, "CapsuleGeometry", ()=>(0, _threeCoreJs.CapsuleGeometry));
parcelHelpers.export(exports, "CatmullRomCurve3", ()=>(0, _threeCoreJs.CatmullRomCurve3));
parcelHelpers.export(exports, "CircleGeometry", ()=>(0, _threeCoreJs.CircleGeometry));
parcelHelpers.export(exports, "Clock", ()=>(0, _threeCoreJs.Clock));
parcelHelpers.export(exports, "ColorKeyframeTrack", ()=>(0, _threeCoreJs.ColorKeyframeTrack));
parcelHelpers.export(exports, "CompressedArrayTexture", ()=>(0, _threeCoreJs.CompressedArrayTexture));
parcelHelpers.export(exports, "CompressedCubeTexture", ()=>(0, _threeCoreJs.CompressedCubeTexture));
parcelHelpers.export(exports, "CompressedTexture", ()=>(0, _threeCoreJs.CompressedTexture));
parcelHelpers.export(exports, "CompressedTextureLoader", ()=>(0, _threeCoreJs.CompressedTextureLoader));
parcelHelpers.export(exports, "ConeGeometry", ()=>(0, _threeCoreJs.ConeGeometry));
parcelHelpers.export(exports, "Controls", ()=>(0, _threeCoreJs.Controls));
parcelHelpers.export(exports, "CubeCamera", ()=>(0, _threeCoreJs.CubeCamera));
parcelHelpers.export(exports, "CubeTextureLoader", ()=>(0, _threeCoreJs.CubeTextureLoader));
parcelHelpers.export(exports, "CubicBezierCurve", ()=>(0, _threeCoreJs.CubicBezierCurve));
parcelHelpers.export(exports, "CubicBezierCurve3", ()=>(0, _threeCoreJs.CubicBezierCurve3));
parcelHelpers.export(exports, "CubicInterpolant", ()=>(0, _threeCoreJs.CubicInterpolant));
parcelHelpers.export(exports, "CullFaceFrontBack", ()=>(0, _threeCoreJs.CullFaceFrontBack));
parcelHelpers.export(exports, "Curve", ()=>(0, _threeCoreJs.Curve));
parcelHelpers.export(exports, "CurvePath", ()=>(0, _threeCoreJs.CurvePath));
parcelHelpers.export(exports, "CylinderGeometry", ()=>(0, _threeCoreJs.CylinderGeometry));
parcelHelpers.export(exports, "Cylindrical", ()=>(0, _threeCoreJs.Cylindrical));
parcelHelpers.export(exports, "DataTextureLoader", ()=>(0, _threeCoreJs.DataTextureLoader));
parcelHelpers.export(exports, "DataUtils", ()=>(0, _threeCoreJs.DataUtils));
parcelHelpers.export(exports, "DecrementStencilOp", ()=>(0, _threeCoreJs.DecrementStencilOp));
parcelHelpers.export(exports, "DecrementWrapStencilOp", ()=>(0, _threeCoreJs.DecrementWrapStencilOp));
parcelHelpers.export(exports, "DefaultLoadingManager", ()=>(0, _threeCoreJs.DefaultLoadingManager));
parcelHelpers.export(exports, "DetachedBindMode", ()=>(0, _threeCoreJs.DetachedBindMode));
parcelHelpers.export(exports, "DirectionalLight", ()=>(0, _threeCoreJs.DirectionalLight));
parcelHelpers.export(exports, "DirectionalLightHelper", ()=>(0, _threeCoreJs.DirectionalLightHelper));
parcelHelpers.export(exports, "DiscreteInterpolant", ()=>(0, _threeCoreJs.DiscreteInterpolant));
parcelHelpers.export(exports, "DodecahedronGeometry", ()=>(0, _threeCoreJs.DodecahedronGeometry));
parcelHelpers.export(exports, "DynamicCopyUsage", ()=>(0, _threeCoreJs.DynamicCopyUsage));
parcelHelpers.export(exports, "DynamicDrawUsage", ()=>(0, _threeCoreJs.DynamicDrawUsage));
parcelHelpers.export(exports, "DynamicReadUsage", ()=>(0, _threeCoreJs.DynamicReadUsage));
parcelHelpers.export(exports, "EdgesGeometry", ()=>(0, _threeCoreJs.EdgesGeometry));
parcelHelpers.export(exports, "EllipseCurve", ()=>(0, _threeCoreJs.EllipseCurve));
parcelHelpers.export(exports, "EqualStencilFunc", ()=>(0, _threeCoreJs.EqualStencilFunc));
parcelHelpers.export(exports, "ExtrudeGeometry", ()=>(0, _threeCoreJs.ExtrudeGeometry));
parcelHelpers.export(exports, "FileLoader", ()=>(0, _threeCoreJs.FileLoader));
parcelHelpers.export(exports, "Float16BufferAttribute", ()=>(0, _threeCoreJs.Float16BufferAttribute));
parcelHelpers.export(exports, "Fog", ()=>(0, _threeCoreJs.Fog));
parcelHelpers.export(exports, "FogExp2", ()=>(0, _threeCoreJs.FogExp2));
parcelHelpers.export(exports, "FramebufferTexture", ()=>(0, _threeCoreJs.FramebufferTexture));
parcelHelpers.export(exports, "FrustumArray", ()=>(0, _threeCoreJs.FrustumArray));
parcelHelpers.export(exports, "GLBufferAttribute", ()=>(0, _threeCoreJs.GLBufferAttribute));
parcelHelpers.export(exports, "GLSL1", ()=>(0, _threeCoreJs.GLSL1));
parcelHelpers.export(exports, "GreaterEqualStencilFunc", ()=>(0, _threeCoreJs.GreaterEqualStencilFunc));
parcelHelpers.export(exports, "GreaterStencilFunc", ()=>(0, _threeCoreJs.GreaterStencilFunc));
parcelHelpers.export(exports, "GridHelper", ()=>(0, _threeCoreJs.GridHelper));
parcelHelpers.export(exports, "Group", ()=>(0, _threeCoreJs.Group));
parcelHelpers.export(exports, "HemisphereLight", ()=>(0, _threeCoreJs.HemisphereLight));
parcelHelpers.export(exports, "HemisphereLightHelper", ()=>(0, _threeCoreJs.HemisphereLightHelper));
parcelHelpers.export(exports, "IcosahedronGeometry", ()=>(0, _threeCoreJs.IcosahedronGeometry));
parcelHelpers.export(exports, "ImageBitmapLoader", ()=>(0, _threeCoreJs.ImageBitmapLoader));
parcelHelpers.export(exports, "ImageLoader", ()=>(0, _threeCoreJs.ImageLoader));
parcelHelpers.export(exports, "ImageUtils", ()=>(0, _threeCoreJs.ImageUtils));
parcelHelpers.export(exports, "IncrementStencilOp", ()=>(0, _threeCoreJs.IncrementStencilOp));
parcelHelpers.export(exports, "IncrementWrapStencilOp", ()=>(0, _threeCoreJs.IncrementWrapStencilOp));
parcelHelpers.export(exports, "InstancedBufferAttribute", ()=>(0, _threeCoreJs.InstancedBufferAttribute));
parcelHelpers.export(exports, "InstancedBufferGeometry", ()=>(0, _threeCoreJs.InstancedBufferGeometry));
parcelHelpers.export(exports, "InstancedInterleavedBuffer", ()=>(0, _threeCoreJs.InstancedInterleavedBuffer));
parcelHelpers.export(exports, "InstancedMesh", ()=>(0, _threeCoreJs.InstancedMesh));
parcelHelpers.export(exports, "Int16BufferAttribute", ()=>(0, _threeCoreJs.Int16BufferAttribute));
parcelHelpers.export(exports, "Int32BufferAttribute", ()=>(0, _threeCoreJs.Int32BufferAttribute));
parcelHelpers.export(exports, "Int8BufferAttribute", ()=>(0, _threeCoreJs.Int8BufferAttribute));
parcelHelpers.export(exports, "InterleavedBuffer", ()=>(0, _threeCoreJs.InterleavedBuffer));
parcelHelpers.export(exports, "InterleavedBufferAttribute", ()=>(0, _threeCoreJs.InterleavedBufferAttribute));
parcelHelpers.export(exports, "Interpolant", ()=>(0, _threeCoreJs.Interpolant));
parcelHelpers.export(exports, "InterpolateDiscrete", ()=>(0, _threeCoreJs.InterpolateDiscrete));
parcelHelpers.export(exports, "InterpolateLinear", ()=>(0, _threeCoreJs.InterpolateLinear));
parcelHelpers.export(exports, "InterpolateSmooth", ()=>(0, _threeCoreJs.InterpolateSmooth));
parcelHelpers.export(exports, "InterpolationSamplingMode", ()=>(0, _threeCoreJs.InterpolationSamplingMode));
parcelHelpers.export(exports, "InterpolationSamplingType", ()=>(0, _threeCoreJs.InterpolationSamplingType));
parcelHelpers.export(exports, "InvertStencilOp", ()=>(0, _threeCoreJs.InvertStencilOp));
parcelHelpers.export(exports, "KeepStencilOp", ()=>(0, _threeCoreJs.KeepStencilOp));
parcelHelpers.export(exports, "KeyframeTrack", ()=>(0, _threeCoreJs.KeyframeTrack));
parcelHelpers.export(exports, "LOD", ()=>(0, _threeCoreJs.LOD));
parcelHelpers.export(exports, "LatheGeometry", ()=>(0, _threeCoreJs.LatheGeometry));
parcelHelpers.export(exports, "LessEqualStencilFunc", ()=>(0, _threeCoreJs.LessEqualStencilFunc));
parcelHelpers.export(exports, "LessStencilFunc", ()=>(0, _threeCoreJs.LessStencilFunc));
parcelHelpers.export(exports, "Light", ()=>(0, _threeCoreJs.Light));
parcelHelpers.export(exports, "LightProbe", ()=>(0, _threeCoreJs.LightProbe));
parcelHelpers.export(exports, "Line", ()=>(0, _threeCoreJs.Line));
parcelHelpers.export(exports, "Line3", ()=>(0, _threeCoreJs.Line3));
parcelHelpers.export(exports, "LineBasicMaterial", ()=>(0, _threeCoreJs.LineBasicMaterial));
parcelHelpers.export(exports, "LineCurve", ()=>(0, _threeCoreJs.LineCurve));
parcelHelpers.export(exports, "LineCurve3", ()=>(0, _threeCoreJs.LineCurve3));
parcelHelpers.export(exports, "LineDashedMaterial", ()=>(0, _threeCoreJs.LineDashedMaterial));
parcelHelpers.export(exports, "LineLoop", ()=>(0, _threeCoreJs.LineLoop));
parcelHelpers.export(exports, "LineSegments", ()=>(0, _threeCoreJs.LineSegments));
parcelHelpers.export(exports, "LinearInterpolant", ()=>(0, _threeCoreJs.LinearInterpolant));
parcelHelpers.export(exports, "LinearMipMapLinearFilter", ()=>(0, _threeCoreJs.LinearMipMapLinearFilter));
parcelHelpers.export(exports, "LinearMipMapNearestFilter", ()=>(0, _threeCoreJs.LinearMipMapNearestFilter));
parcelHelpers.export(exports, "Loader", ()=>(0, _threeCoreJs.Loader));
parcelHelpers.export(exports, "LoaderUtils", ()=>(0, _threeCoreJs.LoaderUtils));
parcelHelpers.export(exports, "LoadingManager", ()=>(0, _threeCoreJs.LoadingManager));
parcelHelpers.export(exports, "LoopOnce", ()=>(0, _threeCoreJs.LoopOnce));
parcelHelpers.export(exports, "LoopPingPong", ()=>(0, _threeCoreJs.LoopPingPong));
parcelHelpers.export(exports, "LoopRepeat", ()=>(0, _threeCoreJs.LoopRepeat));
parcelHelpers.export(exports, "MOUSE", ()=>(0, _threeCoreJs.MOUSE));
parcelHelpers.export(exports, "Material", ()=>(0, _threeCoreJs.Material));
parcelHelpers.export(exports, "MaterialLoader", ()=>(0, _threeCoreJs.MaterialLoader));
parcelHelpers.export(exports, "MathUtils", ()=>(0, _threeCoreJs.MathUtils));
parcelHelpers.export(exports, "Matrix2", ()=>(0, _threeCoreJs.Matrix2));
parcelHelpers.export(exports, "MeshLambertMaterial", ()=>(0, _threeCoreJs.MeshLambertMaterial));
parcelHelpers.export(exports, "MeshMatcapMaterial", ()=>(0, _threeCoreJs.MeshMatcapMaterial));
parcelHelpers.export(exports, "MeshNormalMaterial", ()=>(0, _threeCoreJs.MeshNormalMaterial));
parcelHelpers.export(exports, "MeshPhongMaterial", ()=>(0, _threeCoreJs.MeshPhongMaterial));
parcelHelpers.export(exports, "MeshPhysicalMaterial", ()=>(0, _threeCoreJs.MeshPhysicalMaterial));
parcelHelpers.export(exports, "MeshStandardMaterial", ()=>(0, _threeCoreJs.MeshStandardMaterial));
parcelHelpers.export(exports, "MeshToonMaterial", ()=>(0, _threeCoreJs.MeshToonMaterial));
parcelHelpers.export(exports, "NearestMipMapLinearFilter", ()=>(0, _threeCoreJs.NearestMipMapLinearFilter));
parcelHelpers.export(exports, "NearestMipMapNearestFilter", ()=>(0, _threeCoreJs.NearestMipMapNearestFilter));
parcelHelpers.export(exports, "NeverStencilFunc", ()=>(0, _threeCoreJs.NeverStencilFunc));
parcelHelpers.export(exports, "NoNormalPacking", ()=>(0, _threeCoreJs.NoNormalPacking));
parcelHelpers.export(exports, "NormalAnimationBlendMode", ()=>(0, _threeCoreJs.NormalAnimationBlendMode));
parcelHelpers.export(exports, "NormalGAPacking", ()=>(0, _threeCoreJs.NormalGAPacking));
parcelHelpers.export(exports, "NormalRGPacking", ()=>(0, _threeCoreJs.NormalRGPacking));
parcelHelpers.export(exports, "NotEqualStencilFunc", ()=>(0, _threeCoreJs.NotEqualStencilFunc));
parcelHelpers.export(exports, "NumberKeyframeTrack", ()=>(0, _threeCoreJs.NumberKeyframeTrack));
parcelHelpers.export(exports, "Object3D", ()=>(0, _threeCoreJs.Object3D));
parcelHelpers.export(exports, "ObjectLoader", ()=>(0, _threeCoreJs.ObjectLoader));
parcelHelpers.export(exports, "OctahedronGeometry", ()=>(0, _threeCoreJs.OctahedronGeometry));
parcelHelpers.export(exports, "Path", ()=>(0, _threeCoreJs.Path));
parcelHelpers.export(exports, "PlaneHelper", ()=>(0, _threeCoreJs.PlaneHelper));
parcelHelpers.export(exports, "PointLight", ()=>(0, _threeCoreJs.PointLight));
parcelHelpers.export(exports, "PointLightHelper", ()=>(0, _threeCoreJs.PointLightHelper));
parcelHelpers.export(exports, "Points", ()=>(0, _threeCoreJs.Points));
parcelHelpers.export(exports, "PointsMaterial", ()=>(0, _threeCoreJs.PointsMaterial));
parcelHelpers.export(exports, "PolarGridHelper", ()=>(0, _threeCoreJs.PolarGridHelper));
parcelHelpers.export(exports, "PolyhedronGeometry", ()=>(0, _threeCoreJs.PolyhedronGeometry));
parcelHelpers.export(exports, "PositionalAudio", ()=>(0, _threeCoreJs.PositionalAudio));
parcelHelpers.export(exports, "PropertyBinding", ()=>(0, _threeCoreJs.PropertyBinding));
parcelHelpers.export(exports, "PropertyMixer", ()=>(0, _threeCoreJs.PropertyMixer));
parcelHelpers.export(exports, "QuadraticBezierCurve", ()=>(0, _threeCoreJs.QuadraticBezierCurve));
parcelHelpers.export(exports, "QuadraticBezierCurve3", ()=>(0, _threeCoreJs.QuadraticBezierCurve3));
parcelHelpers.export(exports, "Quaternion", ()=>(0, _threeCoreJs.Quaternion));
parcelHelpers.export(exports, "QuaternionKeyframeTrack", ()=>(0, _threeCoreJs.QuaternionKeyframeTrack));
parcelHelpers.export(exports, "QuaternionLinearInterpolant", ()=>(0, _threeCoreJs.QuaternionLinearInterpolant));
parcelHelpers.export(exports, "RGBADepthPacking", ()=>(0, _threeCoreJs.RGBADepthPacking));
parcelHelpers.export(exports, "RGBDepthPacking", ()=>(0, _threeCoreJs.RGBDepthPacking));
parcelHelpers.export(exports, "RGBIntegerFormat", ()=>(0, _threeCoreJs.RGBIntegerFormat));
parcelHelpers.export(exports, "RGDepthPacking", ()=>(0, _threeCoreJs.RGDepthPacking));
parcelHelpers.export(exports, "Ray", ()=>(0, _threeCoreJs.Ray));
parcelHelpers.export(exports, "Raycaster", ()=>(0, _threeCoreJs.Raycaster));
parcelHelpers.export(exports, "RectAreaLight", ()=>(0, _threeCoreJs.RectAreaLight));
parcelHelpers.export(exports, "RenderTarget", ()=>(0, _threeCoreJs.RenderTarget));
parcelHelpers.export(exports, "RenderTarget3D", ()=>(0, _threeCoreJs.RenderTarget3D));
parcelHelpers.export(exports, "ReplaceStencilOp", ()=>(0, _threeCoreJs.ReplaceStencilOp));
parcelHelpers.export(exports, "RingGeometry", ()=>(0, _threeCoreJs.RingGeometry));
parcelHelpers.export(exports, "Scene", ()=>(0, _threeCoreJs.Scene));
parcelHelpers.export(exports, "ShadowMaterial", ()=>(0, _threeCoreJs.ShadowMaterial));
parcelHelpers.export(exports, "Shape", ()=>(0, _threeCoreJs.Shape));
parcelHelpers.export(exports, "ShapeGeometry", ()=>(0, _threeCoreJs.ShapeGeometry));
parcelHelpers.export(exports, "ShapePath", ()=>(0, _threeCoreJs.ShapePath));
parcelHelpers.export(exports, "ShapeUtils", ()=>(0, _threeCoreJs.ShapeUtils));
parcelHelpers.export(exports, "Skeleton", ()=>(0, _threeCoreJs.Skeleton));
parcelHelpers.export(exports, "SkeletonHelper", ()=>(0, _threeCoreJs.SkeletonHelper));
parcelHelpers.export(exports, "SkinnedMesh", ()=>(0, _threeCoreJs.SkinnedMesh));
parcelHelpers.export(exports, "Source", ()=>(0, _threeCoreJs.Source));
parcelHelpers.export(exports, "Sphere", ()=>(0, _threeCoreJs.Sphere));
parcelHelpers.export(exports, "SphereGeometry", ()=>(0, _threeCoreJs.SphereGeometry));
parcelHelpers.export(exports, "Spherical", ()=>(0, _threeCoreJs.Spherical));
parcelHelpers.export(exports, "SphericalHarmonics3", ()=>(0, _threeCoreJs.SphericalHarmonics3));
parcelHelpers.export(exports, "SplineCurve", ()=>(0, _threeCoreJs.SplineCurve));
parcelHelpers.export(exports, "SpotLight", ()=>(0, _threeCoreJs.SpotLight));
parcelHelpers.export(exports, "SpotLightHelper", ()=>(0, _threeCoreJs.SpotLightHelper));
parcelHelpers.export(exports, "Sprite", ()=>(0, _threeCoreJs.Sprite));
parcelHelpers.export(exports, "SpriteMaterial", ()=>(0, _threeCoreJs.SpriteMaterial));
parcelHelpers.export(exports, "StaticCopyUsage", ()=>(0, _threeCoreJs.StaticCopyUsage));
parcelHelpers.export(exports, "StaticDrawUsage", ()=>(0, _threeCoreJs.StaticDrawUsage));
parcelHelpers.export(exports, "StaticReadUsage", ()=>(0, _threeCoreJs.StaticReadUsage));
parcelHelpers.export(exports, "StereoCamera", ()=>(0, _threeCoreJs.StereoCamera));
parcelHelpers.export(exports, "StreamCopyUsage", ()=>(0, _threeCoreJs.StreamCopyUsage));
parcelHelpers.export(exports, "StreamDrawUsage", ()=>(0, _threeCoreJs.StreamDrawUsage));
parcelHelpers.export(exports, "StreamReadUsage", ()=>(0, _threeCoreJs.StreamReadUsage));
parcelHelpers.export(exports, "StringKeyframeTrack", ()=>(0, _threeCoreJs.StringKeyframeTrack));
parcelHelpers.export(exports, "TOUCH", ()=>(0, _threeCoreJs.TOUCH));
parcelHelpers.export(exports, "TetrahedronGeometry", ()=>(0, _threeCoreJs.TetrahedronGeometry));
parcelHelpers.export(exports, "TextureLoader", ()=>(0, _threeCoreJs.TextureLoader));
parcelHelpers.export(exports, "TextureUtils", ()=>(0, _threeCoreJs.TextureUtils));
parcelHelpers.export(exports, "Timer", ()=>(0, _threeCoreJs.Timer));
parcelHelpers.export(exports, "TimestampQuery", ()=>(0, _threeCoreJs.TimestampQuery));
parcelHelpers.export(exports, "TorusGeometry", ()=>(0, _threeCoreJs.TorusGeometry));
parcelHelpers.export(exports, "TorusKnotGeometry", ()=>(0, _threeCoreJs.TorusKnotGeometry));
parcelHelpers.export(exports, "Triangle", ()=>(0, _threeCoreJs.Triangle));
parcelHelpers.export(exports, "TriangleFanDrawMode", ()=>(0, _threeCoreJs.TriangleFanDrawMode));
parcelHelpers.export(exports, "TriangleStripDrawMode", ()=>(0, _threeCoreJs.TriangleStripDrawMode));
parcelHelpers.export(exports, "TrianglesDrawMode", ()=>(0, _threeCoreJs.TrianglesDrawMode));
parcelHelpers.export(exports, "TubeGeometry", ()=>(0, _threeCoreJs.TubeGeometry));
parcelHelpers.export(exports, "UVMapping", ()=>(0, _threeCoreJs.UVMapping));
parcelHelpers.export(exports, "Uint8BufferAttribute", ()=>(0, _threeCoreJs.Uint8BufferAttribute));
parcelHelpers.export(exports, "Uint8ClampedBufferAttribute", ()=>(0, _threeCoreJs.Uint8ClampedBufferAttribute));
parcelHelpers.export(exports, "Uniform", ()=>(0, _threeCoreJs.Uniform));
parcelHelpers.export(exports, "UniformsGroup", ()=>(0, _threeCoreJs.UniformsGroup));
parcelHelpers.export(exports, "VectorKeyframeTrack", ()=>(0, _threeCoreJs.VectorKeyframeTrack));
parcelHelpers.export(exports, "VideoFrameTexture", ()=>(0, _threeCoreJs.VideoFrameTexture));
parcelHelpers.export(exports, "VideoTexture", ()=>(0, _threeCoreJs.VideoTexture));
parcelHelpers.export(exports, "WebGL3DRenderTarget", ()=>(0, _threeCoreJs.WebGL3DRenderTarget));
parcelHelpers.export(exports, "WebGLArrayRenderTarget", ()=>(0, _threeCoreJs.WebGLArrayRenderTarget));
parcelHelpers.export(exports, "WebGPUCoordinateSystem", ()=>(0, _threeCoreJs.WebGPUCoordinateSystem));
parcelHelpers.export(exports, "WireframeGeometry", ()=>(0, _threeCoreJs.WireframeGeometry));
parcelHelpers.export(exports, "WrapAroundEnding", ()=>(0, _threeCoreJs.WrapAroundEnding));
parcelHelpers.export(exports, "ZeroCurvatureEnding", ()=>(0, _threeCoreJs.ZeroCurvatureEnding));
parcelHelpers.export(exports, "ZeroSlopeEnding", ()=>(0, _threeCoreJs.ZeroSlopeEnding));
parcelHelpers.export(exports, "ZeroStencilOp", ()=>(0, _threeCoreJs.ZeroStencilOp));
parcelHelpers.export(exports, "getConsoleFunction", ()=>(0, _threeCoreJs.getConsoleFunction));
parcelHelpers.export(exports, "setConsoleFunction", ()=>(0, _threeCoreJs.setConsoleFunction));
parcelHelpers.export(exports, "ACESFilmicToneMapping", ()=>(0, _threeCoreJs.ACESFilmicToneMapping));
parcelHelpers.export(exports, "AddEquation", ()=>(0, _threeCoreJs.AddEquation));
parcelHelpers.export(exports, "AddOperation", ()=>(0, _threeCoreJs.AddOperation));
parcelHelpers.export(exports, "AdditiveBlending", ()=>(0, _threeCoreJs.AdditiveBlending));
parcelHelpers.export(exports, "AgXToneMapping", ()=>(0, _threeCoreJs.AgXToneMapping));
parcelHelpers.export(exports, "AlphaFormat", ()=>(0, _threeCoreJs.AlphaFormat));
parcelHelpers.export(exports, "AlwaysCompare", ()=>(0, _threeCoreJs.AlwaysCompare));
parcelHelpers.export(exports, "AlwaysDepth", ()=>(0, _threeCoreJs.AlwaysDepth));
parcelHelpers.export(exports, "ArrayCamera", ()=>(0, _threeCoreJs.ArrayCamera));
parcelHelpers.export(exports, "BackSide", ()=>(0, _threeCoreJs.BackSide));
parcelHelpers.export(exports, "BoxGeometry", ()=>(0, _threeCoreJs.BoxGeometry));
parcelHelpers.export(exports, "BufferAttribute", ()=>(0, _threeCoreJs.BufferAttribute));
parcelHelpers.export(exports, "BufferGeometry", ()=>(0, _threeCoreJs.BufferGeometry));
parcelHelpers.export(exports, "ByteType", ()=>(0, _threeCoreJs.ByteType));
parcelHelpers.export(exports, "CineonToneMapping", ()=>(0, _threeCoreJs.CineonToneMapping));
parcelHelpers.export(exports, "ClampToEdgeWrapping", ()=>(0, _threeCoreJs.ClampToEdgeWrapping));
parcelHelpers.export(exports, "Color", ()=>(0, _threeCoreJs.Color));
parcelHelpers.export(exports, "ColorManagement", ()=>(0, _threeCoreJs.ColorManagement));
parcelHelpers.export(exports, "ConstantAlphaFactor", ()=>(0, _threeCoreJs.ConstantAlphaFactor));
parcelHelpers.export(exports, "ConstantColorFactor", ()=>(0, _threeCoreJs.ConstantColorFactor));
parcelHelpers.export(exports, "CubeDepthTexture", ()=>(0, _threeCoreJs.CubeDepthTexture));
parcelHelpers.export(exports, "CubeReflectionMapping", ()=>(0, _threeCoreJs.CubeReflectionMapping));
parcelHelpers.export(exports, "CubeRefractionMapping", ()=>(0, _threeCoreJs.CubeRefractionMapping));
parcelHelpers.export(exports, "CubeTexture", ()=>(0, _threeCoreJs.CubeTexture));
parcelHelpers.export(exports, "CubeUVReflectionMapping", ()=>(0, _threeCoreJs.CubeUVReflectionMapping));
parcelHelpers.export(exports, "CullFaceBack", ()=>(0, _threeCoreJs.CullFaceBack));
parcelHelpers.export(exports, "CullFaceFront", ()=>(0, _threeCoreJs.CullFaceFront));
parcelHelpers.export(exports, "CullFaceNone", ()=>(0, _threeCoreJs.CullFaceNone));
parcelHelpers.export(exports, "CustomBlending", ()=>(0, _threeCoreJs.CustomBlending));
parcelHelpers.export(exports, "CustomToneMapping", ()=>(0, _threeCoreJs.CustomToneMapping));
parcelHelpers.export(exports, "Data3DTexture", ()=>(0, _threeCoreJs.Data3DTexture));
parcelHelpers.export(exports, "DataArrayTexture", ()=>(0, _threeCoreJs.DataArrayTexture));
parcelHelpers.export(exports, "DataTexture", ()=>(0, _threeCoreJs.DataTexture));
parcelHelpers.export(exports, "DepthFormat", ()=>(0, _threeCoreJs.DepthFormat));
parcelHelpers.export(exports, "DepthStencilFormat", ()=>(0, _threeCoreJs.DepthStencilFormat));
parcelHelpers.export(exports, "DepthTexture", ()=>(0, _threeCoreJs.DepthTexture));
parcelHelpers.export(exports, "DoubleSide", ()=>(0, _threeCoreJs.DoubleSide));
parcelHelpers.export(exports, "DstAlphaFactor", ()=>(0, _threeCoreJs.DstAlphaFactor));
parcelHelpers.export(exports, "DstColorFactor", ()=>(0, _threeCoreJs.DstColorFactor));
parcelHelpers.export(exports, "EqualCompare", ()=>(0, _threeCoreJs.EqualCompare));
parcelHelpers.export(exports, "EqualDepth", ()=>(0, _threeCoreJs.EqualDepth));
parcelHelpers.export(exports, "EquirectangularReflectionMapping", ()=>(0, _threeCoreJs.EquirectangularReflectionMapping));
parcelHelpers.export(exports, "EquirectangularRefractionMapping", ()=>(0, _threeCoreJs.EquirectangularRefractionMapping));
parcelHelpers.export(exports, "Euler", ()=>(0, _threeCoreJs.Euler));
parcelHelpers.export(exports, "EventDispatcher", ()=>(0, _threeCoreJs.EventDispatcher));
parcelHelpers.export(exports, "ExternalTexture", ()=>(0, _threeCoreJs.ExternalTexture));
parcelHelpers.export(exports, "Float32BufferAttribute", ()=>(0, _threeCoreJs.Float32BufferAttribute));
parcelHelpers.export(exports, "FloatType", ()=>(0, _threeCoreJs.FloatType));
parcelHelpers.export(exports, "FrontSide", ()=>(0, _threeCoreJs.FrontSide));
parcelHelpers.export(exports, "Frustum", ()=>(0, _threeCoreJs.Frustum));
parcelHelpers.export(exports, "GLSL3", ()=>(0, _threeCoreJs.GLSL3));
parcelHelpers.export(exports, "GreaterCompare", ()=>(0, _threeCoreJs.GreaterCompare));
parcelHelpers.export(exports, "GreaterDepth", ()=>(0, _threeCoreJs.GreaterDepth));
parcelHelpers.export(exports, "GreaterEqualCompare", ()=>(0, _threeCoreJs.GreaterEqualCompare));
parcelHelpers.export(exports, "GreaterEqualDepth", ()=>(0, _threeCoreJs.GreaterEqualDepth));
parcelHelpers.export(exports, "HalfFloatType", ()=>(0, _threeCoreJs.HalfFloatType));
parcelHelpers.export(exports, "IntType", ()=>(0, _threeCoreJs.IntType));
parcelHelpers.export(exports, "Layers", ()=>(0, _threeCoreJs.Layers));
parcelHelpers.export(exports, "LessCompare", ()=>(0, _threeCoreJs.LessCompare));
parcelHelpers.export(exports, "LessDepth", ()=>(0, _threeCoreJs.LessDepth));
parcelHelpers.export(exports, "LessEqualCompare", ()=>(0, _threeCoreJs.LessEqualCompare));
parcelHelpers.export(exports, "LessEqualDepth", ()=>(0, _threeCoreJs.LessEqualDepth));
parcelHelpers.export(exports, "LinearFilter", ()=>(0, _threeCoreJs.LinearFilter));
parcelHelpers.export(exports, "LinearMipmapLinearFilter", ()=>(0, _threeCoreJs.LinearMipmapLinearFilter));
parcelHelpers.export(exports, "LinearMipmapNearestFilter", ()=>(0, _threeCoreJs.LinearMipmapNearestFilter));
parcelHelpers.export(exports, "LinearSRGBColorSpace", ()=>(0, _threeCoreJs.LinearSRGBColorSpace));
parcelHelpers.export(exports, "LinearToneMapping", ()=>(0, _threeCoreJs.LinearToneMapping));
parcelHelpers.export(exports, "LinearTransfer", ()=>(0, _threeCoreJs.LinearTransfer));
parcelHelpers.export(exports, "Matrix3", ()=>(0, _threeCoreJs.Matrix3));
parcelHelpers.export(exports, "Matrix4", ()=>(0, _threeCoreJs.Matrix4));
parcelHelpers.export(exports, "MaxEquation", ()=>(0, _threeCoreJs.MaxEquation));
parcelHelpers.export(exports, "Mesh", ()=>(0, _threeCoreJs.Mesh));
parcelHelpers.export(exports, "MeshBasicMaterial", ()=>(0, _threeCoreJs.MeshBasicMaterial));
parcelHelpers.export(exports, "MeshDepthMaterial", ()=>(0, _threeCoreJs.MeshDepthMaterial));
parcelHelpers.export(exports, "MeshDistanceMaterial", ()=>(0, _threeCoreJs.MeshDistanceMaterial));
parcelHelpers.export(exports, "MinEquation", ()=>(0, _threeCoreJs.MinEquation));
parcelHelpers.export(exports, "MirroredRepeatWrapping", ()=>(0, _threeCoreJs.MirroredRepeatWrapping));
parcelHelpers.export(exports, "MixOperation", ()=>(0, _threeCoreJs.MixOperation));
parcelHelpers.export(exports, "MultiplyBlending", ()=>(0, _threeCoreJs.MultiplyBlending));
parcelHelpers.export(exports, "MultiplyOperation", ()=>(0, _threeCoreJs.MultiplyOperation));
parcelHelpers.export(exports, "NearestFilter", ()=>(0, _threeCoreJs.NearestFilter));
parcelHelpers.export(exports, "NearestMipmapLinearFilter", ()=>(0, _threeCoreJs.NearestMipmapLinearFilter));
parcelHelpers.export(exports, "NearestMipmapNearestFilter", ()=>(0, _threeCoreJs.NearestMipmapNearestFilter));
parcelHelpers.export(exports, "NeutralToneMapping", ()=>(0, _threeCoreJs.NeutralToneMapping));
parcelHelpers.export(exports, "NeverCompare", ()=>(0, _threeCoreJs.NeverCompare));
parcelHelpers.export(exports, "NeverDepth", ()=>(0, _threeCoreJs.NeverDepth));
parcelHelpers.export(exports, "NoBlending", ()=>(0, _threeCoreJs.NoBlending));
parcelHelpers.export(exports, "NoColorSpace", ()=>(0, _threeCoreJs.NoColorSpace));
parcelHelpers.export(exports, "NoToneMapping", ()=>(0, _threeCoreJs.NoToneMapping));
parcelHelpers.export(exports, "NormalBlending", ()=>(0, _threeCoreJs.NormalBlending));
parcelHelpers.export(exports, "NotEqualCompare", ()=>(0, _threeCoreJs.NotEqualCompare));
parcelHelpers.export(exports, "NotEqualDepth", ()=>(0, _threeCoreJs.NotEqualDepth));
parcelHelpers.export(exports, "ObjectSpaceNormalMap", ()=>(0, _threeCoreJs.ObjectSpaceNormalMap));
parcelHelpers.export(exports, "OneFactor", ()=>(0, _threeCoreJs.OneFactor));
parcelHelpers.export(exports, "OneMinusConstantAlphaFactor", ()=>(0, _threeCoreJs.OneMinusConstantAlphaFactor));
parcelHelpers.export(exports, "OneMinusConstantColorFactor", ()=>(0, _threeCoreJs.OneMinusConstantColorFactor));
parcelHelpers.export(exports, "OneMinusDstAlphaFactor", ()=>(0, _threeCoreJs.OneMinusDstAlphaFactor));
parcelHelpers.export(exports, "OneMinusDstColorFactor", ()=>(0, _threeCoreJs.OneMinusDstColorFactor));
parcelHelpers.export(exports, "OneMinusSrcAlphaFactor", ()=>(0, _threeCoreJs.OneMinusSrcAlphaFactor));
parcelHelpers.export(exports, "OneMinusSrcColorFactor", ()=>(0, _threeCoreJs.OneMinusSrcColorFactor));
parcelHelpers.export(exports, "OrthographicCamera", ()=>(0, _threeCoreJs.OrthographicCamera));
parcelHelpers.export(exports, "PCFShadowMap", ()=>(0, _threeCoreJs.PCFShadowMap));
parcelHelpers.export(exports, "PCFSoftShadowMap", ()=>(0, _threeCoreJs.PCFSoftShadowMap));
parcelHelpers.export(exports, "PMREMGenerator", ()=>PMREMGenerator);
parcelHelpers.export(exports, "PerspectiveCamera", ()=>(0, _threeCoreJs.PerspectiveCamera));
parcelHelpers.export(exports, "Plane", ()=>(0, _threeCoreJs.Plane));
parcelHelpers.export(exports, "PlaneGeometry", ()=>(0, _threeCoreJs.PlaneGeometry));
parcelHelpers.export(exports, "R11_EAC_Format", ()=>(0, _threeCoreJs.R11_EAC_Format));
parcelHelpers.export(exports, "RED_GREEN_RGTC2_Format", ()=>(0, _threeCoreJs.RED_GREEN_RGTC2_Format));
parcelHelpers.export(exports, "RED_RGTC1_Format", ()=>(0, _threeCoreJs.RED_RGTC1_Format));
parcelHelpers.export(exports, "REVISION", ()=>(0, _threeCoreJs.REVISION));
parcelHelpers.export(exports, "RG11_EAC_Format", ()=>(0, _threeCoreJs.RG11_EAC_Format));
parcelHelpers.export(exports, "RGBAFormat", ()=>(0, _threeCoreJs.RGBAFormat));
parcelHelpers.export(exports, "RGBAIntegerFormat", ()=>(0, _threeCoreJs.RGBAIntegerFormat));
parcelHelpers.export(exports, "RGBA_ASTC_10x10_Format", ()=>(0, _threeCoreJs.RGBA_ASTC_10x10_Format));
parcelHelpers.export(exports, "RGBA_ASTC_10x5_Format", ()=>(0, _threeCoreJs.RGBA_ASTC_10x5_Format));
parcelHelpers.export(exports, "RGBA_ASTC_10x6_Format", ()=>(0, _threeCoreJs.RGBA_ASTC_10x6_Format));
parcelHelpers.export(exports, "RGBA_ASTC_10x8_Format", ()=>(0, _threeCoreJs.RGBA_ASTC_10x8_Format));
parcelHelpers.export(exports, "RGBA_ASTC_12x10_Format", ()=>(0, _threeCoreJs.RGBA_ASTC_12x10_Format));
parcelHelpers.export(exports, "RGBA_ASTC_12x12_Format", ()=>(0, _threeCoreJs.RGBA_ASTC_12x12_Format));
parcelHelpers.export(exports, "RGBA_ASTC_4x4_Format", ()=>(0, _threeCoreJs.RGBA_ASTC_4x4_Format));
parcelHelpers.export(exports, "RGBA_ASTC_5x4_Format", ()=>(0, _threeCoreJs.RGBA_ASTC_5x4_Format));
parcelHelpers.export(exports, "RGBA_ASTC_5x5_Format", ()=>(0, _threeCoreJs.RGBA_ASTC_5x5_Format));
parcelHelpers.export(exports, "RGBA_ASTC_6x5_Format", ()=>(0, _threeCoreJs.RGBA_ASTC_6x5_Format));
parcelHelpers.export(exports, "RGBA_ASTC_6x6_Format", ()=>(0, _threeCoreJs.RGBA_ASTC_6x6_Format));
parcelHelpers.export(exports, "RGBA_ASTC_8x5_Format", ()=>(0, _threeCoreJs.RGBA_ASTC_8x5_Format));
parcelHelpers.export(exports, "RGBA_ASTC_8x6_Format", ()=>(0, _threeCoreJs.RGBA_ASTC_8x6_Format));
parcelHelpers.export(exports, "RGBA_ASTC_8x8_Format", ()=>(0, _threeCoreJs.RGBA_ASTC_8x8_Format));
parcelHelpers.export(exports, "RGBA_BPTC_Format", ()=>(0, _threeCoreJs.RGBA_BPTC_Format));
parcelHelpers.export(exports, "RGBA_ETC2_EAC_Format", ()=>(0, _threeCoreJs.RGBA_ETC2_EAC_Format));
parcelHelpers.export(exports, "RGBA_PVRTC_2BPPV1_Format", ()=>(0, _threeCoreJs.RGBA_PVRTC_2BPPV1_Format));
parcelHelpers.export(exports, "RGBA_PVRTC_4BPPV1_Format", ()=>(0, _threeCoreJs.RGBA_PVRTC_4BPPV1_Format));
parcelHelpers.export(exports, "RGBA_S3TC_DXT1_Format", ()=>(0, _threeCoreJs.RGBA_S3TC_DXT1_Format));
parcelHelpers.export(exports, "RGBA_S3TC_DXT3_Format", ()=>(0, _threeCoreJs.RGBA_S3TC_DXT3_Format));
parcelHelpers.export(exports, "RGBA_S3TC_DXT5_Format", ()=>(0, _threeCoreJs.RGBA_S3TC_DXT5_Format));
parcelHelpers.export(exports, "RGBFormat", ()=>(0, _threeCoreJs.RGBFormat));
parcelHelpers.export(exports, "RGB_BPTC_SIGNED_Format", ()=>(0, _threeCoreJs.RGB_BPTC_SIGNED_Format));
parcelHelpers.export(exports, "RGB_BPTC_UNSIGNED_Format", ()=>(0, _threeCoreJs.RGB_BPTC_UNSIGNED_Format));
parcelHelpers.export(exports, "RGB_ETC1_Format", ()=>(0, _threeCoreJs.RGB_ETC1_Format));
parcelHelpers.export(exports, "RGB_ETC2_Format", ()=>(0, _threeCoreJs.RGB_ETC2_Format));
parcelHelpers.export(exports, "RGB_PVRTC_2BPPV1_Format", ()=>(0, _threeCoreJs.RGB_PVRTC_2BPPV1_Format));
parcelHelpers.export(exports, "RGB_PVRTC_4BPPV1_Format", ()=>(0, _threeCoreJs.RGB_PVRTC_4BPPV1_Format));
parcelHelpers.export(exports, "RGB_S3TC_DXT1_Format", ()=>(0, _threeCoreJs.RGB_S3TC_DXT1_Format));
parcelHelpers.export(exports, "RGFormat", ()=>(0, _threeCoreJs.RGFormat));
parcelHelpers.export(exports, "RGIntegerFormat", ()=>(0, _threeCoreJs.RGIntegerFormat));
parcelHelpers.export(exports, "RawShaderMaterial", ()=>(0, _threeCoreJs.RawShaderMaterial));
parcelHelpers.export(exports, "RedFormat", ()=>(0, _threeCoreJs.RedFormat));
parcelHelpers.export(exports, "RedIntegerFormat", ()=>(0, _threeCoreJs.RedIntegerFormat));
parcelHelpers.export(exports, "ReinhardToneMapping", ()=>(0, _threeCoreJs.ReinhardToneMapping));
parcelHelpers.export(exports, "RepeatWrapping", ()=>(0, _threeCoreJs.RepeatWrapping));
parcelHelpers.export(exports, "ReverseSubtractEquation", ()=>(0, _threeCoreJs.ReverseSubtractEquation));
parcelHelpers.export(exports, "SIGNED_R11_EAC_Format", ()=>(0, _threeCoreJs.SIGNED_R11_EAC_Format));
parcelHelpers.export(exports, "SIGNED_RED_GREEN_RGTC2_Format", ()=>(0, _threeCoreJs.SIGNED_RED_GREEN_RGTC2_Format));
parcelHelpers.export(exports, "SIGNED_RED_RGTC1_Format", ()=>(0, _threeCoreJs.SIGNED_RED_RGTC1_Format));
parcelHelpers.export(exports, "SIGNED_RG11_EAC_Format", ()=>(0, _threeCoreJs.SIGNED_RG11_EAC_Format));
parcelHelpers.export(exports, "SRGBColorSpace", ()=>(0, _threeCoreJs.SRGBColorSpace));
parcelHelpers.export(exports, "SRGBTransfer", ()=>(0, _threeCoreJs.SRGBTransfer));
parcelHelpers.export(exports, "ShaderChunk", ()=>ShaderChunk);
parcelHelpers.export(exports, "ShaderLib", ()=>ShaderLib);
parcelHelpers.export(exports, "ShaderMaterial", ()=>(0, _threeCoreJs.ShaderMaterial));
parcelHelpers.export(exports, "ShortType", ()=>(0, _threeCoreJs.ShortType));
parcelHelpers.export(exports, "SrcAlphaFactor", ()=>(0, _threeCoreJs.SrcAlphaFactor));
parcelHelpers.export(exports, "SrcAlphaSaturateFactor", ()=>(0, _threeCoreJs.SrcAlphaSaturateFactor));
parcelHelpers.export(exports, "SrcColorFactor", ()=>(0, _threeCoreJs.SrcColorFactor));
parcelHelpers.export(exports, "SubtractEquation", ()=>(0, _threeCoreJs.SubtractEquation));
parcelHelpers.export(exports, "SubtractiveBlending", ()=>(0, _threeCoreJs.SubtractiveBlending));
parcelHelpers.export(exports, "TangentSpaceNormalMap", ()=>(0, _threeCoreJs.TangentSpaceNormalMap));
parcelHelpers.export(exports, "Texture", ()=>(0, _threeCoreJs.Texture));
parcelHelpers.export(exports, "Uint16BufferAttribute", ()=>(0, _threeCoreJs.Uint16BufferAttribute));
parcelHelpers.export(exports, "Uint32BufferAttribute", ()=>(0, _threeCoreJs.Uint32BufferAttribute));
parcelHelpers.export(exports, "UniformsLib", ()=>UniformsLib);
parcelHelpers.export(exports, "UniformsUtils", ()=>(0, _threeCoreJs.UniformsUtils));
parcelHelpers.export(exports, "UnsignedByteType", ()=>(0, _threeCoreJs.UnsignedByteType));
parcelHelpers.export(exports, "UnsignedInt101111Type", ()=>(0, _threeCoreJs.UnsignedInt101111Type));
parcelHelpers.export(exports, "UnsignedInt248Type", ()=>(0, _threeCoreJs.UnsignedInt248Type));
parcelHelpers.export(exports, "UnsignedInt5999Type", ()=>(0, _threeCoreJs.UnsignedInt5999Type));
parcelHelpers.export(exports, "UnsignedIntType", ()=>(0, _threeCoreJs.UnsignedIntType));
parcelHelpers.export(exports, "UnsignedShort4444Type", ()=>(0, _threeCoreJs.UnsignedShort4444Type));
parcelHelpers.export(exports, "UnsignedShort5551Type", ()=>(0, _threeCoreJs.UnsignedShort5551Type));
parcelHelpers.export(exports, "UnsignedShortType", ()=>(0, _threeCoreJs.UnsignedShortType));
parcelHelpers.export(exports, "VSMShadowMap", ()=>(0, _threeCoreJs.VSMShadowMap));
parcelHelpers.export(exports, "Vector2", ()=>(0, _threeCoreJs.Vector2));
parcelHelpers.export(exports, "Vector3", ()=>(0, _threeCoreJs.Vector3));
parcelHelpers.export(exports, "Vector4", ()=>(0, _threeCoreJs.Vector4));
parcelHelpers.export(exports, "WebGLCoordinateSystem", ()=>(0, _threeCoreJs.WebGLCoordinateSystem));
parcelHelpers.export(exports, "WebGLCubeRenderTarget", ()=>(0, _threeCoreJs.WebGLCubeRenderTarget));
parcelHelpers.export(exports, "WebGLRenderTarget", ()=>(0, _threeCoreJs.WebGLRenderTarget));
parcelHelpers.export(exports, "WebGLRenderer", ()=>WebGLRenderer);
parcelHelpers.export(exports, "WebGLUtils", ()=>WebGLUtils);
parcelHelpers.export(exports, "WebXRController", ()=>(0, _threeCoreJs.WebXRController));
parcelHelpers.export(exports, "ZeroFactor", ()=>(0, _threeCoreJs.ZeroFactor));
parcelHelpers.export(exports, "createCanvasElement", ()=>(0, _threeCoreJs.createCanvasElement));
parcelHelpers.export(exports, "error", ()=>(0, _threeCoreJs.error));
parcelHelpers.export(exports, "log", ()=>(0, _threeCoreJs.log));
parcelHelpers.export(exports, "warn", ()=>(0, _threeCoreJs.warn));
parcelHelpers.export(exports, "warnOnce", ()=>(0, _threeCoreJs.warnOnce));
var _threeCoreJs = require("./three.core.js");
function WebGLAnimation() {
    let context = null;
    let isAnimating = false;
    let animationLoop = null;
    let requestId = null;
    function onAnimationFrame(time, frame) {
        animationLoop(time, frame);
        requestId = context.requestAnimationFrame(onAnimationFrame);
    }
    return {
        start: function() {
            if (isAnimating === true) return;
            if (animationLoop === null) return;
            requestId = context.requestAnimationFrame(onAnimationFrame);
            isAnimating = true;
        },
        stop: function() {
            context.cancelAnimationFrame(requestId);
            isAnimating = false;
        },
        setAnimationLoop: function(callback) {
            animationLoop = callback;
        },
        setContext: function(value) {
            context = value;
        }
    };
}
function WebGLAttributes(gl) {
    const buffers = new WeakMap();
    function createBuffer(attribute, bufferType) {
        const array = attribute.array;
        const usage = attribute.usage;
        const size = array.byteLength;
        const buffer = gl.createBuffer();
        gl.bindBuffer(bufferType, buffer);
        gl.bufferData(bufferType, array, usage);
        attribute.onUploadCallback();
        let type;
        if (array instanceof Float32Array) type = gl.FLOAT;
        else if (typeof Float16Array !== 'undefined' && array instanceof Float16Array) type = gl.HALF_FLOAT;
        else if (array instanceof Uint16Array) {
            if (attribute.isFloat16BufferAttribute) type = gl.HALF_FLOAT;
            else type = gl.UNSIGNED_SHORT;
        } else if (array instanceof Int16Array) type = gl.SHORT;
        else if (array instanceof Uint32Array) type = gl.UNSIGNED_INT;
        else if (array instanceof Int32Array) type = gl.INT;
        else if (array instanceof Int8Array) type = gl.BYTE;
        else if (array instanceof Uint8Array) type = gl.UNSIGNED_BYTE;
        else if (array instanceof Uint8ClampedArray) type = gl.UNSIGNED_BYTE;
        else throw new Error('THREE.WebGLAttributes: Unsupported buffer data format: ' + array);
        return {
            buffer: buffer,
            type: type,
            bytesPerElement: array.BYTES_PER_ELEMENT,
            version: attribute.version,
            size: size
        };
    }
    function updateBuffer(buffer, attribute, bufferType) {
        const array = attribute.array;
        const updateRanges = attribute.updateRanges;
        gl.bindBuffer(bufferType, buffer);
        if (updateRanges.length === 0) // Not using update ranges
        gl.bufferSubData(bufferType, 0, array);
        else {
            // Before applying update ranges, we merge any adjacent / overlapping
            // ranges to reduce load on `gl.bufferSubData`. Empirically, this has led
            // to performance improvements for applications which make heavy use of
            // update ranges. Likely due to GPU command overhead.
            //
            // Note that to reduce garbage collection between frames, we merge the
            // update ranges in-place. This is safe because this method will clear the
            // update ranges once updated.
            updateRanges.sort((a, b)=>a.start - b.start);
            // To merge the update ranges in-place, we work from left to right in the
            // existing updateRanges array, merging ranges. This may result in a final
            // array which is smaller than the original. This index tracks the last
            // index representing a merged range, any data after this index can be
            // trimmed once the merge algorithm is completed.
            let mergeIndex = 0;
            for(let i = 1; i < updateRanges.length; i++){
                const previousRange = updateRanges[mergeIndex];
                const range = updateRanges[i];
                // We add one here to merge adjacent ranges. This is safe because ranges
                // operate over positive integers.
                if (range.start <= previousRange.start + previousRange.count + 1) previousRange.count = Math.max(previousRange.count, range.start + range.count - previousRange.start);
                else {
                    ++mergeIndex;
                    updateRanges[mergeIndex] = range;
                }
            }
            // Trim the array to only contain the merged ranges.
            updateRanges.length = mergeIndex + 1;
            for(let i = 0, l = updateRanges.length; i < l; i++){
                const range = updateRanges[i];
                gl.bufferSubData(bufferType, range.start * array.BYTES_PER_ELEMENT, array, range.start, range.count);
            }
            attribute.clearUpdateRanges();
        }
        attribute.onUploadCallback();
    }
    //
    function get(attribute) {
        if (attribute.isInterleavedBufferAttribute) attribute = attribute.data;
        return buffers.get(attribute);
    }
    function remove(attribute) {
        if (attribute.isInterleavedBufferAttribute) attribute = attribute.data;
        const data = buffers.get(attribute);
        if (data) {
            gl.deleteBuffer(data.buffer);
            buffers.delete(attribute);
        }
    }
    function update(attribute, bufferType) {
        if (attribute.isInterleavedBufferAttribute) attribute = attribute.data;
        if (attribute.isGLBufferAttribute) {
            const cached = buffers.get(attribute);
            if (!cached || cached.version < attribute.version) buffers.set(attribute, {
                buffer: attribute.buffer,
                type: attribute.type,
                bytesPerElement: attribute.elementSize,
                version: attribute.version
            });
            return;
        }
        const data = buffers.get(attribute);
        if (data === undefined) buffers.set(attribute, createBuffer(attribute, bufferType));
        else if (data.version < attribute.version) {
            if (data.size !== attribute.array.byteLength) throw new Error('THREE.WebGLAttributes: The size of the buffer attribute\'s array buffer does not match the original size. Resizing buffer attributes is not supported.');
            updateBuffer(data.buffer, attribute, bufferType);
            data.version = attribute.version;
        }
    }
    return {
        get: get,
        remove: remove,
        update: update
    };
}
var alphahash_fragment = "#ifdef USE_ALPHAHASH\n\tif ( diffuseColor.a < getAlphaHashThreshold( vPosition ) ) discard;\n#endif";
var alphahash_pars_fragment = "#ifdef USE_ALPHAHASH\n\tconst float ALPHA_HASH_SCALE = 0.05;\n\tfloat hash2D( vec2 value ) {\n\t\treturn fract( 1.0e4 * sin( 17.0 * value.x + 0.1 * value.y ) * ( 0.1 + abs( sin( 13.0 * value.y + value.x ) ) ) );\n\t}\n\tfloat hash3D( vec3 value ) {\n\t\treturn hash2D( vec2( hash2D( value.xy ), value.z ) );\n\t}\n\tfloat getAlphaHashThreshold( vec3 position ) {\n\t\tfloat maxDeriv = max(\n\t\t\tlength( dFdx( position.xyz ) ),\n\t\t\tlength( dFdy( position.xyz ) )\n\t\t);\n\t\tfloat pixScale = 1.0 / ( ALPHA_HASH_SCALE * maxDeriv );\n\t\tvec2 pixScales = vec2(\n\t\t\texp2( floor( log2( pixScale ) ) ),\n\t\t\texp2( ceil( log2( pixScale ) ) )\n\t\t);\n\t\tvec2 alpha = vec2(\n\t\t\thash3D( floor( pixScales.x * position.xyz ) ),\n\t\t\thash3D( floor( pixScales.y * position.xyz ) )\n\t\t);\n\t\tfloat lerpFactor = fract( log2( pixScale ) );\n\t\tfloat x = ( 1.0 - lerpFactor ) * alpha.x + lerpFactor * alpha.y;\n\t\tfloat a = min( lerpFactor, 1.0 - lerpFactor );\n\t\tvec3 cases = vec3(\n\t\t\tx * x / ( 2.0 * a * ( 1.0 - a ) ),\n\t\t\t( x - 0.5 * a ) / ( 1.0 - a ),\n\t\t\t1.0 - ( ( 1.0 - x ) * ( 1.0 - x ) / ( 2.0 * a * ( 1.0 - a ) ) )\n\t\t);\n\t\tfloat threshold = ( x < ( 1.0 - a ) )\n\t\t\t? ( ( x < a ) ? cases.x : cases.y )\n\t\t\t: cases.z;\n\t\treturn clamp( threshold , 1.0e-6, 1.0 );\n\t}\n#endif";
var alphamap_fragment = "#ifdef USE_ALPHAMAP\n\tdiffuseColor.a *= texture2D( alphaMap, vAlphaMapUv ).g;\n#endif";
var alphamap_pars_fragment = "#ifdef USE_ALPHAMAP\n\tuniform sampler2D alphaMap;\n#endif";
var alphatest_fragment = "#ifdef USE_ALPHATEST\n\t#ifdef ALPHA_TO_COVERAGE\n\tdiffuseColor.a = smoothstep( alphaTest, alphaTest + fwidth( diffuseColor.a ), diffuseColor.a );\n\tif ( diffuseColor.a == 0.0 ) discard;\n\t#else\n\tif ( diffuseColor.a < alphaTest ) discard;\n\t#endif\n#endif";
var alphatest_pars_fragment = "#ifdef USE_ALPHATEST\n\tuniform float alphaTest;\n#endif";
var aomap_fragment = "#ifdef USE_AOMAP\n\tfloat ambientOcclusion = ( texture2D( aoMap, vAoMapUv ).r - 1.0 ) * aoMapIntensity + 1.0;\n\treflectedLight.indirectDiffuse *= ambientOcclusion;\n\t#if defined( USE_CLEARCOAT ) \n\t\tclearcoatSpecularIndirect *= ambientOcclusion;\n\t#endif\n\t#if defined( USE_SHEEN ) \n\t\tsheenSpecularIndirect *= ambientOcclusion;\n\t#endif\n\t#if defined( USE_ENVMAP ) && defined( STANDARD )\n\t\tfloat dotNV = saturate( dot( geometryNormal, geometryViewDir ) );\n\t\treflectedLight.indirectSpecular *= computeSpecularOcclusion( dotNV, ambientOcclusion, material.roughness );\n\t#endif\n#endif";
var aomap_pars_fragment = "#ifdef USE_AOMAP\n\tuniform sampler2D aoMap;\n\tuniform float aoMapIntensity;\n#endif";
var batching_pars_vertex = "#ifdef USE_BATCHING\n\t#if ! defined( GL_ANGLE_multi_draw )\n\t#define gl_DrawID _gl_DrawID\n\tuniform int _gl_DrawID;\n\t#endif\n\tuniform highp sampler2D batchingTexture;\n\tuniform highp usampler2D batchingIdTexture;\n\tmat4 getBatchingMatrix( const in float i ) {\n\t\tint size = textureSize( batchingTexture, 0 ).x;\n\t\tint j = int( i ) * 4;\n\t\tint x = j % size;\n\t\tint y = j / size;\n\t\tvec4 v1 = texelFetch( batchingTexture, ivec2( x, y ), 0 );\n\t\tvec4 v2 = texelFetch( batchingTexture, ivec2( x + 1, y ), 0 );\n\t\tvec4 v3 = texelFetch( batchingTexture, ivec2( x + 2, y ), 0 );\n\t\tvec4 v4 = texelFetch( batchingTexture, ivec2( x + 3, y ), 0 );\n\t\treturn mat4( v1, v2, v3, v4 );\n\t}\n\tfloat getIndirectIndex( const in int i ) {\n\t\tint size = textureSize( batchingIdTexture, 0 ).x;\n\t\tint x = i % size;\n\t\tint y = i / size;\n\t\treturn float( texelFetch( batchingIdTexture, ivec2( x, y ), 0 ).r );\n\t}\n#endif\n#ifdef USE_BATCHING_COLOR\n\tuniform sampler2D batchingColorTexture;\n\tvec3 getBatchingColor( const in float i ) {\n\t\tint size = textureSize( batchingColorTexture, 0 ).x;\n\t\tint j = int( i );\n\t\tint x = j % size;\n\t\tint y = j / size;\n\t\treturn texelFetch( batchingColorTexture, ivec2( x, y ), 0 ).rgb;\n\t}\n#endif";
var batching_vertex = "#ifdef USE_BATCHING\n\tmat4 batchingMatrix = getBatchingMatrix( getIndirectIndex( gl_DrawID ) );\n#endif";
var begin_vertex = "vec3 transformed = vec3( position );\n#ifdef USE_ALPHAHASH\n\tvPosition = vec3( position );\n#endif";
var beginnormal_vertex = "vec3 objectNormal = vec3( normal );\n#ifdef USE_TANGENT\n\tvec3 objectTangent = vec3( tangent.xyz );\n#endif";
var bsdfs = "float G_BlinnPhong_Implicit( ) {\n\treturn 0.25;\n}\nfloat D_BlinnPhong( const in float shininess, const in float dotNH ) {\n\treturn RECIPROCAL_PI * ( shininess * 0.5 + 1.0 ) * pow( dotNH, shininess );\n}\nvec3 BRDF_BlinnPhong( const in vec3 lightDir, const in vec3 viewDir, const in vec3 normal, const in vec3 specularColor, const in float shininess ) {\n\tvec3 halfDir = normalize( lightDir + viewDir );\n\tfloat dotNH = saturate( dot( normal, halfDir ) );\n\tfloat dotVH = saturate( dot( viewDir, halfDir ) );\n\tvec3 F = F_Schlick( specularColor, 1.0, dotVH );\n\tfloat G = G_BlinnPhong_Implicit( );\n\tfloat D = D_BlinnPhong( shininess, dotNH );\n\treturn F * ( G * D );\n} // validated";
var iridescence_fragment = "#ifdef USE_IRIDESCENCE\n\tconst mat3 XYZ_TO_REC709 = mat3(\n\t\t 3.2404542, -0.9692660,  0.0556434,\n\t\t-1.5371385,  1.8760108, -0.2040259,\n\t\t-0.4985314,  0.0415560,  1.0572252\n\t);\n\tvec3 Fresnel0ToIor( vec3 fresnel0 ) {\n\t\tvec3 sqrtF0 = sqrt( fresnel0 );\n\t\treturn ( vec3( 1.0 ) + sqrtF0 ) / ( vec3( 1.0 ) - sqrtF0 );\n\t}\n\tvec3 IorToFresnel0( vec3 transmittedIor, float incidentIor ) {\n\t\treturn pow2( ( transmittedIor - vec3( incidentIor ) ) / ( transmittedIor + vec3( incidentIor ) ) );\n\t}\n\tfloat IorToFresnel0( float transmittedIor, float incidentIor ) {\n\t\treturn pow2( ( transmittedIor - incidentIor ) / ( transmittedIor + incidentIor ));\n\t}\n\tvec3 evalSensitivity( float OPD, vec3 shift ) {\n\t\tfloat phase = 2.0 * PI * OPD * 1.0e-9;\n\t\tvec3 val = vec3( 5.4856e-13, 4.4201e-13, 5.2481e-13 );\n\t\tvec3 pos = vec3( 1.6810e+06, 1.7953e+06, 2.2084e+06 );\n\t\tvec3 var = vec3( 4.3278e+09, 9.3046e+09, 6.6121e+09 );\n\t\tvec3 xyz = val * sqrt( 2.0 * PI * var ) * cos( pos * phase + shift ) * exp( - pow2( phase ) * var );\n\t\txyz.x += 9.7470e-14 * sqrt( 2.0 * PI * 4.5282e+09 ) * cos( 2.2399e+06 * phase + shift[ 0 ] ) * exp( - 4.5282e+09 * pow2( phase ) );\n\t\txyz /= 1.0685e-7;\n\t\tvec3 rgb = XYZ_TO_REC709 * xyz;\n\t\treturn rgb;\n\t}\n\tvec3 evalIridescence( float outsideIOR, float eta2, float cosTheta1, float thinFilmThickness, vec3 baseF0 ) {\n\t\tvec3 I;\n\t\tfloat iridescenceIOR = mix( outsideIOR, eta2, smoothstep( 0.0, 0.03, thinFilmThickness ) );\n\t\tfloat sinTheta2Sq = pow2( outsideIOR / iridescenceIOR ) * ( 1.0 - pow2( cosTheta1 ) );\n\t\tfloat cosTheta2Sq = 1.0 - sinTheta2Sq;\n\t\tif ( cosTheta2Sq < 0.0 ) {\n\t\t\treturn vec3( 1.0 );\n\t\t}\n\t\tfloat cosTheta2 = sqrt( cosTheta2Sq );\n\t\tfloat R0 = IorToFresnel0( iridescenceIOR, outsideIOR );\n\t\tfloat R12 = F_Schlick( R0, 1.0, cosTheta1 );\n\t\tfloat T121 = 1.0 - R12;\n\t\tfloat phi12 = 0.0;\n\t\tif ( iridescenceIOR < outsideIOR ) phi12 = PI;\n\t\tfloat phi21 = PI - phi12;\n\t\tvec3 baseIOR = Fresnel0ToIor( clamp( baseF0, 0.0, 0.9999 ) );\t\tvec3 R1 = IorToFresnel0( baseIOR, iridescenceIOR );\n\t\tvec3 R23 = F_Schlick( R1, 1.0, cosTheta2 );\n\t\tvec3 phi23 = vec3( 0.0 );\n\t\tif ( baseIOR[ 0 ] < iridescenceIOR ) phi23[ 0 ] = PI;\n\t\tif ( baseIOR[ 1 ] < iridescenceIOR ) phi23[ 1 ] = PI;\n\t\tif ( baseIOR[ 2 ] < iridescenceIOR ) phi23[ 2 ] = PI;\n\t\tfloat OPD = 2.0 * iridescenceIOR * thinFilmThickness * cosTheta2;\n\t\tvec3 phi = vec3( phi21 ) + phi23;\n\t\tvec3 R123 = clamp( R12 * R23, 1e-5, 0.9999 );\n\t\tvec3 r123 = sqrt( R123 );\n\t\tvec3 Rs = pow2( T121 ) * R23 / ( vec3( 1.0 ) - R123 );\n\t\tvec3 C0 = R12 + Rs;\n\t\tI = C0;\n\t\tvec3 Cm = Rs - T121;\n\t\tfor ( int m = 1; m <= 2; ++ m ) {\n\t\t\tCm *= r123;\n\t\t\tvec3 Sm = 2.0 * evalSensitivity( float( m ) * OPD, float( m ) * phi );\n\t\t\tI += Cm * Sm;\n\t\t}\n\t\treturn max( I, vec3( 0.0 ) );\n\t}\n#endif";
var bumpmap_pars_fragment = "#ifdef USE_BUMPMAP\n\tuniform sampler2D bumpMap;\n\tuniform float bumpScale;\n\tvec2 dHdxy_fwd() {\n\t\tvec2 dSTdx = dFdx( vBumpMapUv );\n\t\tvec2 dSTdy = dFdy( vBumpMapUv );\n\t\tfloat Hll = bumpScale * texture2D( bumpMap, vBumpMapUv ).x;\n\t\tfloat dBx = bumpScale * texture2D( bumpMap, vBumpMapUv + dSTdx ).x - Hll;\n\t\tfloat dBy = bumpScale * texture2D( bumpMap, vBumpMapUv + dSTdy ).x - Hll;\n\t\treturn vec2( dBx, dBy );\n\t}\n\tvec3 perturbNormalArb( vec3 surf_pos, vec3 surf_norm, vec2 dHdxy, float faceDirection ) {\n\t\tvec3 vSigmaX = normalize( dFdx( surf_pos.xyz ) );\n\t\tvec3 vSigmaY = normalize( dFdy( surf_pos.xyz ) );\n\t\tvec3 vN = surf_norm;\n\t\tvec3 R1 = cross( vSigmaY, vN );\n\t\tvec3 R2 = cross( vN, vSigmaX );\n\t\tfloat fDet = dot( vSigmaX, R1 ) * faceDirection;\n\t\tvec3 vGrad = sign( fDet ) * ( dHdxy.x * R1 + dHdxy.y * R2 );\n\t\treturn normalize( abs( fDet ) * surf_norm - vGrad );\n\t}\n#endif";
var clipping_planes_fragment = "#if NUM_CLIPPING_PLANES > 0\n\tvec4 plane;\n\t#ifdef ALPHA_TO_COVERAGE\n\t\tfloat distanceToPlane, distanceGradient;\n\t\tfloat clipOpacity = 1.0;\n\t\t#pragma unroll_loop_start\n\t\tfor ( int i = 0; i < UNION_CLIPPING_PLANES; i ++ ) {\n\t\t\tplane = clippingPlanes[ i ];\n\t\t\tdistanceToPlane = - dot( vClipPosition, plane.xyz ) + plane.w;\n\t\t\tdistanceGradient = fwidth( distanceToPlane ) / 2.0;\n\t\t\tclipOpacity *= smoothstep( - distanceGradient, distanceGradient, distanceToPlane );\n\t\t\tif ( clipOpacity == 0.0 ) discard;\n\t\t}\n\t\t#pragma unroll_loop_end\n\t\t#if UNION_CLIPPING_PLANES < NUM_CLIPPING_PLANES\n\t\t\tfloat unionClipOpacity = 1.0;\n\t\t\t#pragma unroll_loop_start\n\t\t\tfor ( int i = UNION_CLIPPING_PLANES; i < NUM_CLIPPING_PLANES; i ++ ) {\n\t\t\t\tplane = clippingPlanes[ i ];\n\t\t\t\tdistanceToPlane = - dot( vClipPosition, plane.xyz ) + plane.w;\n\t\t\t\tdistanceGradient = fwidth( distanceToPlane ) / 2.0;\n\t\t\t\tunionClipOpacity *= 1.0 - smoothstep( - distanceGradient, distanceGradient, distanceToPlane );\n\t\t\t}\n\t\t\t#pragma unroll_loop_end\n\t\t\tclipOpacity *= 1.0 - unionClipOpacity;\n\t\t#endif\n\t\tdiffuseColor.a *= clipOpacity;\n\t\tif ( diffuseColor.a == 0.0 ) discard;\n\t#else\n\t\t#pragma unroll_loop_start\n\t\tfor ( int i = 0; i < UNION_CLIPPING_PLANES; i ++ ) {\n\t\t\tplane = clippingPlanes[ i ];\n\t\t\tif ( dot( vClipPosition, plane.xyz ) > plane.w ) discard;\n\t\t}\n\t\t#pragma unroll_loop_end\n\t\t#if UNION_CLIPPING_PLANES < NUM_CLIPPING_PLANES\n\t\t\tbool clipped = true;\n\t\t\t#pragma unroll_loop_start\n\t\t\tfor ( int i = UNION_CLIPPING_PLANES; i < NUM_CLIPPING_PLANES; i ++ ) {\n\t\t\t\tplane = clippingPlanes[ i ];\n\t\t\t\tclipped = ( dot( vClipPosition, plane.xyz ) > plane.w ) && clipped;\n\t\t\t}\n\t\t\t#pragma unroll_loop_end\n\t\t\tif ( clipped ) discard;\n\t\t#endif\n\t#endif\n#endif";
var clipping_planes_pars_fragment = "#if NUM_CLIPPING_PLANES > 0\n\tvarying vec3 vClipPosition;\n\tuniform vec4 clippingPlanes[ NUM_CLIPPING_PLANES ];\n#endif";
var clipping_planes_pars_vertex = "#if NUM_CLIPPING_PLANES > 0\n\tvarying vec3 vClipPosition;\n#endif";
var clipping_planes_vertex = "#if NUM_CLIPPING_PLANES > 0\n\tvClipPosition = - mvPosition.xyz;\n#endif";
var color_fragment = "#if defined( USE_COLOR_ALPHA )\n\tdiffuseColor *= vColor;\n#elif defined( USE_COLOR )\n\tdiffuseColor.rgb *= vColor;\n#endif";
var color_pars_fragment = "#if defined( USE_COLOR_ALPHA )\n\tvarying vec4 vColor;\n#elif defined( USE_COLOR )\n\tvarying vec3 vColor;\n#endif";
var color_pars_vertex = "#if defined( USE_COLOR_ALPHA )\n\tvarying vec4 vColor;\n#elif defined( USE_COLOR ) || defined( USE_INSTANCING_COLOR ) || defined( USE_BATCHING_COLOR )\n\tvarying vec3 vColor;\n#endif";
var color_vertex = "#if defined( USE_COLOR_ALPHA )\n\tvColor = vec4( 1.0 );\n#elif defined( USE_COLOR ) || defined( USE_INSTANCING_COLOR ) || defined( USE_BATCHING_COLOR )\n\tvColor = vec3( 1.0 );\n#endif\n#ifdef USE_COLOR\n\tvColor *= color;\n#endif\n#ifdef USE_INSTANCING_COLOR\n\tvColor.xyz *= instanceColor.xyz;\n#endif\n#ifdef USE_BATCHING_COLOR\n\tvec3 batchingColor = getBatchingColor( getIndirectIndex( gl_DrawID ) );\n\tvColor.xyz *= batchingColor.xyz;\n#endif";
var common = "#define PI 3.141592653589793\n#define PI2 6.283185307179586\n#define PI_HALF 1.5707963267948966\n#define RECIPROCAL_PI 0.3183098861837907\n#define RECIPROCAL_PI2 0.15915494309189535\n#define EPSILON 1e-6\n#ifndef saturate\n#define saturate( a ) clamp( a, 0.0, 1.0 )\n#endif\n#define whiteComplement( a ) ( 1.0 - saturate( a ) )\nfloat pow2( const in float x ) { return x*x; }\nvec3 pow2( const in vec3 x ) { return x*x; }\nfloat pow3( const in float x ) { return x*x*x; }\nfloat pow4( const in float x ) { float x2 = x*x; return x2*x2; }\nfloat max3( const in vec3 v ) { return max( max( v.x, v.y ), v.z ); }\nfloat average( const in vec3 v ) { return dot( v, vec3( 0.3333333 ) ); }\nhighp float rand( const in vec2 uv ) {\n\tconst highp float a = 12.9898, b = 78.233, c = 43758.5453;\n\thighp float dt = dot( uv.xy, vec2( a,b ) ), sn = mod( dt, PI );\n\treturn fract( sin( sn ) * c );\n}\n#ifdef HIGH_PRECISION\n\tfloat precisionSafeLength( vec3 v ) { return length( v ); }\n#else\n\tfloat precisionSafeLength( vec3 v ) {\n\t\tfloat maxComponent = max3( abs( v ) );\n\t\treturn length( v / maxComponent ) * maxComponent;\n\t}\n#endif\nstruct IncidentLight {\n\tvec3 color;\n\tvec3 direction;\n\tbool visible;\n};\nstruct ReflectedLight {\n\tvec3 directDiffuse;\n\tvec3 directSpecular;\n\tvec3 indirectDiffuse;\n\tvec3 indirectSpecular;\n};\n#ifdef USE_ALPHAHASH\n\tvarying vec3 vPosition;\n#endif\nvec3 transformDirection( in vec3 dir, in mat4 matrix ) {\n\treturn normalize( ( matrix * vec4( dir, 0.0 ) ).xyz );\n}\nvec3 inverseTransformDirection( in vec3 dir, in mat4 matrix ) {\n\treturn normalize( ( vec4( dir, 0.0 ) * matrix ).xyz );\n}\nbool isPerspectiveMatrix( mat4 m ) {\n\treturn m[ 2 ][ 3 ] == - 1.0;\n}\nvec2 equirectUv( in vec3 dir ) {\n\tfloat u = atan( dir.z, dir.x ) * RECIPROCAL_PI2 + 0.5;\n\tfloat v = asin( clamp( dir.y, - 1.0, 1.0 ) ) * RECIPROCAL_PI + 0.5;\n\treturn vec2( u, v );\n}\nvec3 BRDF_Lambert( const in vec3 diffuseColor ) {\n\treturn RECIPROCAL_PI * diffuseColor;\n}\nvec3 F_Schlick( const in vec3 f0, const in float f90, const in float dotVH ) {\n\tfloat fresnel = exp2( ( - 5.55473 * dotVH - 6.98316 ) * dotVH );\n\treturn f0 * ( 1.0 - fresnel ) + ( f90 * fresnel );\n}\nfloat F_Schlick( const in float f0, const in float f90, const in float dotVH ) {\n\tfloat fresnel = exp2( ( - 5.55473 * dotVH - 6.98316 ) * dotVH );\n\treturn f0 * ( 1.0 - fresnel ) + ( f90 * fresnel );\n} // validated";
var cube_uv_reflection_fragment = "#ifdef ENVMAP_TYPE_CUBE_UV\n\t#define cubeUV_minMipLevel 4.0\n\t#define cubeUV_minTileSize 16.0\n\tfloat getFace( vec3 direction ) {\n\t\tvec3 absDirection = abs( direction );\n\t\tfloat face = - 1.0;\n\t\tif ( absDirection.x > absDirection.z ) {\n\t\t\tif ( absDirection.x > absDirection.y )\n\t\t\t\tface = direction.x > 0.0 ? 0.0 : 3.0;\n\t\t\telse\n\t\t\t\tface = direction.y > 0.0 ? 1.0 : 4.0;\n\t\t} else {\n\t\t\tif ( absDirection.z > absDirection.y )\n\t\t\t\tface = direction.z > 0.0 ? 2.0 : 5.0;\n\t\t\telse\n\t\t\t\tface = direction.y > 0.0 ? 1.0 : 4.0;\n\t\t}\n\t\treturn face;\n\t}\n\tvec2 getUV( vec3 direction, float face ) {\n\t\tvec2 uv;\n\t\tif ( face == 0.0 ) {\n\t\t\tuv = vec2( direction.z, direction.y ) / abs( direction.x );\n\t\t} else if ( face == 1.0 ) {\n\t\t\tuv = vec2( - direction.x, - direction.z ) / abs( direction.y );\n\t\t} else if ( face == 2.0 ) {\n\t\t\tuv = vec2( - direction.x, direction.y ) / abs( direction.z );\n\t\t} else if ( face == 3.0 ) {\n\t\t\tuv = vec2( - direction.z, direction.y ) / abs( direction.x );\n\t\t} else if ( face == 4.0 ) {\n\t\t\tuv = vec2( - direction.x, direction.z ) / abs( direction.y );\n\t\t} else {\n\t\t\tuv = vec2( direction.x, direction.y ) / abs( direction.z );\n\t\t}\n\t\treturn 0.5 * ( uv + 1.0 );\n\t}\n\tvec3 bilinearCubeUV( sampler2D envMap, vec3 direction, float mipInt ) {\n\t\tfloat face = getFace( direction );\n\t\tfloat filterInt = max( cubeUV_minMipLevel - mipInt, 0.0 );\n\t\tmipInt = max( mipInt, cubeUV_minMipLevel );\n\t\tfloat faceSize = exp2( mipInt );\n\t\thighp vec2 uv = getUV( direction, face ) * ( faceSize - 2.0 ) + 1.0;\n\t\tif ( face > 2.0 ) {\n\t\t\tuv.y += faceSize;\n\t\t\tface -= 3.0;\n\t\t}\n\t\tuv.x += face * faceSize;\n\t\tuv.x += filterInt * 3.0 * cubeUV_minTileSize;\n\t\tuv.y += 4.0 * ( exp2( CUBEUV_MAX_MIP ) - faceSize );\n\t\tuv.x *= CUBEUV_TEXEL_WIDTH;\n\t\tuv.y *= CUBEUV_TEXEL_HEIGHT;\n\t\t#ifdef texture2DGradEXT\n\t\t\treturn texture2DGradEXT( envMap, uv, vec2( 0.0 ), vec2( 0.0 ) ).rgb;\n\t\t#else\n\t\t\treturn texture2D( envMap, uv ).rgb;\n\t\t#endif\n\t}\n\t#define cubeUV_r0 1.0\n\t#define cubeUV_m0 - 2.0\n\t#define cubeUV_r1 0.8\n\t#define cubeUV_m1 - 1.0\n\t#define cubeUV_r4 0.4\n\t#define cubeUV_m4 2.0\n\t#define cubeUV_r5 0.305\n\t#define cubeUV_m5 3.0\n\t#define cubeUV_r6 0.21\n\t#define cubeUV_m6 4.0\n\tfloat roughnessToMip( float roughness ) {\n\t\tfloat mip = 0.0;\n\t\tif ( roughness >= cubeUV_r1 ) {\n\t\t\tmip = ( cubeUV_r0 - roughness ) * ( cubeUV_m1 - cubeUV_m0 ) / ( cubeUV_r0 - cubeUV_r1 ) + cubeUV_m0;\n\t\t} else if ( roughness >= cubeUV_r4 ) {\n\t\t\tmip = ( cubeUV_r1 - roughness ) * ( cubeUV_m4 - cubeUV_m1 ) / ( cubeUV_r1 - cubeUV_r4 ) + cubeUV_m1;\n\t\t} else if ( roughness >= cubeUV_r5 ) {\n\t\t\tmip = ( cubeUV_r4 - roughness ) * ( cubeUV_m5 - cubeUV_m4 ) / ( cubeUV_r4 - cubeUV_r5 ) + cubeUV_m4;\n\t\t} else if ( roughness >= cubeUV_r6 ) {\n\t\t\tmip = ( cubeUV_r5 - roughness ) * ( cubeUV_m6 - cubeUV_m5 ) / ( cubeUV_r5 - cubeUV_r6 ) + cubeUV_m5;\n\t\t} else {\n\t\t\tmip = - 2.0 * log2( 1.16 * roughness );\t\t}\n\t\treturn mip;\n\t}\n\tvec4 textureCubeUV( sampler2D envMap, vec3 sampleDir, float roughness ) {\n\t\tfloat mip = clamp( roughnessToMip( roughness ), cubeUV_m0, CUBEUV_MAX_MIP );\n\t\tfloat mipF = fract( mip );\n\t\tfloat mipInt = floor( mip );\n\t\tvec3 color0 = bilinearCubeUV( envMap, sampleDir, mipInt );\n\t\tif ( mipF == 0.0 ) {\n\t\t\treturn vec4( color0, 1.0 );\n\t\t} else {\n\t\t\tvec3 color1 = bilinearCubeUV( envMap, sampleDir, mipInt + 1.0 );\n\t\t\treturn vec4( mix( color0, color1, mipF ), 1.0 );\n\t\t}\n\t}\n#endif";
var defaultnormal_vertex = "vec3 transformedNormal = objectNormal;\n#ifdef USE_TANGENT\n\tvec3 transformedTangent = objectTangent;\n#endif\n#ifdef USE_BATCHING\n\tmat3 bm = mat3( batchingMatrix );\n\ttransformedNormal /= vec3( dot( bm[ 0 ], bm[ 0 ] ), dot( bm[ 1 ], bm[ 1 ] ), dot( bm[ 2 ], bm[ 2 ] ) );\n\ttransformedNormal = bm * transformedNormal;\n\t#ifdef USE_TANGENT\n\t\ttransformedTangent = bm * transformedTangent;\n\t#endif\n#endif\n#ifdef USE_INSTANCING\n\tmat3 im = mat3( instanceMatrix );\n\ttransformedNormal /= vec3( dot( im[ 0 ], im[ 0 ] ), dot( im[ 1 ], im[ 1 ] ), dot( im[ 2 ], im[ 2 ] ) );\n\ttransformedNormal = im * transformedNormal;\n\t#ifdef USE_TANGENT\n\t\ttransformedTangent = im * transformedTangent;\n\t#endif\n#endif\ntransformedNormal = normalMatrix * transformedNormal;\n#ifdef FLIP_SIDED\n\ttransformedNormal = - transformedNormal;\n#endif\n#ifdef USE_TANGENT\n\ttransformedTangent = ( modelViewMatrix * vec4( transformedTangent, 0.0 ) ).xyz;\n\t#ifdef FLIP_SIDED\n\t\ttransformedTangent = - transformedTangent;\n\t#endif\n#endif";
var displacementmap_pars_vertex = "#ifdef USE_DISPLACEMENTMAP\n\tuniform sampler2D displacementMap;\n\tuniform float displacementScale;\n\tuniform float displacementBias;\n#endif";
var displacementmap_vertex = "#ifdef USE_DISPLACEMENTMAP\n\ttransformed += normalize( objectNormal ) * ( texture2D( displacementMap, vDisplacementMapUv ).x * displacementScale + displacementBias );\n#endif";
var emissivemap_fragment = "#ifdef USE_EMISSIVEMAP\n\tvec4 emissiveColor = texture2D( emissiveMap, vEmissiveMapUv );\n\t#ifdef DECODE_VIDEO_TEXTURE_EMISSIVE\n\t\temissiveColor = sRGBTransferEOTF( emissiveColor );\n\t#endif\n\ttotalEmissiveRadiance *= emissiveColor.rgb;\n#endif";
var emissivemap_pars_fragment = "#ifdef USE_EMISSIVEMAP\n\tuniform sampler2D emissiveMap;\n#endif";
var colorspace_fragment = "gl_FragColor = linearToOutputTexel( gl_FragColor );";
var colorspace_pars_fragment = "vec4 LinearTransferOETF( in vec4 value ) {\n\treturn value;\n}\nvec4 sRGBTransferEOTF( in vec4 value ) {\n\treturn vec4( mix( pow( value.rgb * 0.9478672986 + vec3( 0.0521327014 ), vec3( 2.4 ) ), value.rgb * 0.0773993808, vec3( lessThanEqual( value.rgb, vec3( 0.04045 ) ) ) ), value.a );\n}\nvec4 sRGBTransferOETF( in vec4 value ) {\n\treturn vec4( mix( pow( value.rgb, vec3( 0.41666 ) ) * 1.055 - vec3( 0.055 ), value.rgb * 12.92, vec3( lessThanEqual( value.rgb, vec3( 0.0031308 ) ) ) ), value.a );\n}";
var envmap_fragment = "#ifdef USE_ENVMAP\n\t#ifdef ENV_WORLDPOS\n\t\tvec3 cameraToFrag;\n\t\tif ( isOrthographic ) {\n\t\t\tcameraToFrag = normalize( vec3( - viewMatrix[ 0 ][ 2 ], - viewMatrix[ 1 ][ 2 ], - viewMatrix[ 2 ][ 2 ] ) );\n\t\t} else {\n\t\t\tcameraToFrag = normalize( vWorldPosition - cameraPosition );\n\t\t}\n\t\tvec3 worldNormal = inverseTransformDirection( normal, viewMatrix );\n\t\t#ifdef ENVMAP_MODE_REFLECTION\n\t\t\tvec3 reflectVec = reflect( cameraToFrag, worldNormal );\n\t\t#else\n\t\t\tvec3 reflectVec = refract( cameraToFrag, worldNormal, refractionRatio );\n\t\t#endif\n\t#else\n\t\tvec3 reflectVec = vReflect;\n\t#endif\n\t#ifdef ENVMAP_TYPE_CUBE\n\t\tvec4 envColor = textureCube( envMap, envMapRotation * vec3( flipEnvMap * reflectVec.x, reflectVec.yz ) );\n\t#else\n\t\tvec4 envColor = vec4( 0.0 );\n\t#endif\n\t#ifdef ENVMAP_BLENDING_MULTIPLY\n\t\toutgoingLight = mix( outgoingLight, outgoingLight * envColor.xyz, specularStrength * reflectivity );\n\t#elif defined( ENVMAP_BLENDING_MIX )\n\t\toutgoingLight = mix( outgoingLight, envColor.xyz, specularStrength * reflectivity );\n\t#elif defined( ENVMAP_BLENDING_ADD )\n\t\toutgoingLight += envColor.xyz * specularStrength * reflectivity;\n\t#endif\n#endif";
var envmap_common_pars_fragment = "#ifdef USE_ENVMAP\n\tuniform float envMapIntensity;\n\tuniform float flipEnvMap;\n\tuniform mat3 envMapRotation;\n\t#ifdef ENVMAP_TYPE_CUBE\n\t\tuniform samplerCube envMap;\n\t#else\n\t\tuniform sampler2D envMap;\n\t#endif\n#endif";
var envmap_pars_fragment = "#ifdef USE_ENVMAP\n\tuniform float reflectivity;\n\t#if defined( USE_BUMPMAP ) || defined( USE_NORMALMAP ) || defined( PHONG ) || defined( LAMBERT )\n\t\t#define ENV_WORLDPOS\n\t#endif\n\t#ifdef ENV_WORLDPOS\n\t\tvarying vec3 vWorldPosition;\n\t\tuniform float refractionRatio;\n\t#else\n\t\tvarying vec3 vReflect;\n\t#endif\n#endif";
var envmap_pars_vertex = "#ifdef USE_ENVMAP\n\t#if defined( USE_BUMPMAP ) || defined( USE_NORMALMAP ) || defined( PHONG ) || defined( LAMBERT )\n\t\t#define ENV_WORLDPOS\n\t#endif\n\t#ifdef ENV_WORLDPOS\n\t\t\n\t\tvarying vec3 vWorldPosition;\n\t#else\n\t\tvarying vec3 vReflect;\n\t\tuniform float refractionRatio;\n\t#endif\n#endif";
var envmap_vertex = "#ifdef USE_ENVMAP\n\t#ifdef ENV_WORLDPOS\n\t\tvWorldPosition = worldPosition.xyz;\n\t#else\n\t\tvec3 cameraToVertex;\n\t\tif ( isOrthographic ) {\n\t\t\tcameraToVertex = normalize( vec3( - viewMatrix[ 0 ][ 2 ], - viewMatrix[ 1 ][ 2 ], - viewMatrix[ 2 ][ 2 ] ) );\n\t\t} else {\n\t\t\tcameraToVertex = normalize( worldPosition.xyz - cameraPosition );\n\t\t}\n\t\tvec3 worldNormal = inverseTransformDirection( transformedNormal, viewMatrix );\n\t\t#ifdef ENVMAP_MODE_REFLECTION\n\t\t\tvReflect = reflect( cameraToVertex, worldNormal );\n\t\t#else\n\t\t\tvReflect = refract( cameraToVertex, worldNormal, refractionRatio );\n\t\t#endif\n\t#endif\n#endif";
var fog_vertex = "#ifdef USE_FOG\n\tvFogDepth = - mvPosition.z;\n#endif";
var fog_pars_vertex = "#ifdef USE_FOG\n\tvarying float vFogDepth;\n#endif";
var fog_fragment = "#ifdef USE_FOG\n\t#ifdef FOG_EXP2\n\t\tfloat fogFactor = 1.0 - exp( - fogDensity * fogDensity * vFogDepth * vFogDepth );\n\t#else\n\t\tfloat fogFactor = smoothstep( fogNear, fogFar, vFogDepth );\n\t#endif\n\tgl_FragColor.rgb = mix( gl_FragColor.rgb, fogColor, fogFactor );\n#endif";
var fog_pars_fragment = "#ifdef USE_FOG\n\tuniform vec3 fogColor;\n\tvarying float vFogDepth;\n\t#ifdef FOG_EXP2\n\t\tuniform float fogDensity;\n\t#else\n\t\tuniform float fogNear;\n\t\tuniform float fogFar;\n\t#endif\n#endif";
var gradientmap_pars_fragment = "#ifdef USE_GRADIENTMAP\n\tuniform sampler2D gradientMap;\n#endif\nvec3 getGradientIrradiance( vec3 normal, vec3 lightDirection ) {\n\tfloat dotNL = dot( normal, lightDirection );\n\tvec2 coord = vec2( dotNL * 0.5 + 0.5, 0.0 );\n\t#ifdef USE_GRADIENTMAP\n\t\treturn vec3( texture2D( gradientMap, coord ).r );\n\t#else\n\t\tvec2 fw = fwidth( coord ) * 0.5;\n\t\treturn mix( vec3( 0.7 ), vec3( 1.0 ), smoothstep( 0.7 - fw.x, 0.7 + fw.x, coord.x ) );\n\t#endif\n}";
var lightmap_pars_fragment = "#ifdef USE_LIGHTMAP\n\tuniform sampler2D lightMap;\n\tuniform float lightMapIntensity;\n#endif";
var lights_lambert_fragment = "LambertMaterial material;\nmaterial.diffuseColor = diffuseColor.rgb;\nmaterial.specularStrength = specularStrength;";
var lights_lambert_pars_fragment = "varying vec3 vViewPosition;\nstruct LambertMaterial {\n\tvec3 diffuseColor;\n\tfloat specularStrength;\n};\nvoid RE_Direct_Lambert( const in IncidentLight directLight, const in vec3 geometryPosition, const in vec3 geometryNormal, const in vec3 geometryViewDir, const in vec3 geometryClearcoatNormal, const in LambertMaterial material, inout ReflectedLight reflectedLight ) {\n\tfloat dotNL = saturate( dot( geometryNormal, directLight.direction ) );\n\tvec3 irradiance = dotNL * directLight.color;\n\treflectedLight.directDiffuse += irradiance * BRDF_Lambert( material.diffuseColor );\n}\nvoid RE_IndirectDiffuse_Lambert( const in vec3 irradiance, const in vec3 geometryPosition, const in vec3 geometryNormal, const in vec3 geometryViewDir, const in vec3 geometryClearcoatNormal, const in LambertMaterial material, inout ReflectedLight reflectedLight ) {\n\treflectedLight.indirectDiffuse += irradiance * BRDF_Lambert( material.diffuseColor );\n}\n#define RE_Direct\t\t\t\tRE_Direct_Lambert\n#define RE_IndirectDiffuse\t\tRE_IndirectDiffuse_Lambert";
var lights_pars_begin = "uniform bool receiveShadow;\nuniform vec3 ambientLightColor;\n#if defined( USE_LIGHT_PROBES )\n\tuniform vec3 lightProbe[ 9 ];\n#endif\nvec3 shGetIrradianceAt( in vec3 normal, in vec3 shCoefficients[ 9 ] ) {\n\tfloat x = normal.x, y = normal.y, z = normal.z;\n\tvec3 result = shCoefficients[ 0 ] * 0.886227;\n\tresult += shCoefficients[ 1 ] * 2.0 * 0.511664 * y;\n\tresult += shCoefficients[ 2 ] * 2.0 * 0.511664 * z;\n\tresult += shCoefficients[ 3 ] * 2.0 * 0.511664 * x;\n\tresult += shCoefficients[ 4 ] * 2.0 * 0.429043 * x * y;\n\tresult += shCoefficients[ 5 ] * 2.0 * 0.429043 * y * z;\n\tresult += shCoefficients[ 6 ] * ( 0.743125 * z * z - 0.247708 );\n\tresult += shCoefficients[ 7 ] * 2.0 * 0.429043 * x * z;\n\tresult += shCoefficients[ 8 ] * 0.429043 * ( x * x - y * y );\n\treturn result;\n}\nvec3 getLightProbeIrradiance( const in vec3 lightProbe[ 9 ], const in vec3 normal ) {\n\tvec3 worldNormal = inverseTransformDirection( normal, viewMatrix );\n\tvec3 irradiance = shGetIrradianceAt( worldNormal, lightProbe );\n\treturn irradiance;\n}\nvec3 getAmbientLightIrradiance( const in vec3 ambientLightColor ) {\n\tvec3 irradiance = ambientLightColor;\n\treturn irradiance;\n}\nfloat getDistanceAttenuation( const in float lightDistance, const in float cutoffDistance, const in float decayExponent ) {\n\tfloat distanceFalloff = 1.0 / max( pow( lightDistance, decayExponent ), 0.01 );\n\tif ( cutoffDistance > 0.0 ) {\n\t\tdistanceFalloff *= pow2( saturate( 1.0 - pow4( lightDistance / cutoffDistance ) ) );\n\t}\n\treturn distanceFalloff;\n}\nfloat getSpotAttenuation( const in float coneCosine, const in float penumbraCosine, const in float angleCosine ) {\n\treturn smoothstep( coneCosine, penumbraCosine, angleCosine );\n}\n#if NUM_DIR_LIGHTS > 0\n\tstruct DirectionalLight {\n\t\tvec3 direction;\n\t\tvec3 color;\n\t};\n\tuniform DirectionalLight directionalLights[ NUM_DIR_LIGHTS ];\n\tvoid getDirectionalLightInfo( const in DirectionalLight directionalLight, out IncidentLight light ) {\n\t\tlight.color = directionalLight.color;\n\t\tlight.direction = directionalLight.direction;\n\t\tlight.visible = true;\n\t}\n#endif\n#if NUM_POINT_LIGHTS > 0\n\tstruct PointLight {\n\t\tvec3 position;\n\t\tvec3 color;\n\t\tfloat distance;\n\t\tfloat decay;\n\t};\n\tuniform PointLight pointLights[ NUM_POINT_LIGHTS ];\n\tvoid getPointLightInfo( const in PointLight pointLight, const in vec3 geometryPosition, out IncidentLight light ) {\n\t\tvec3 lVector = pointLight.position - geometryPosition;\n\t\tlight.direction = normalize( lVector );\n\t\tfloat lightDistance = length( lVector );\n\t\tlight.color = pointLight.color;\n\t\tlight.color *= getDistanceAttenuation( lightDistance, pointLight.distance, pointLight.decay );\n\t\tlight.visible = ( light.color != vec3( 0.0 ) );\n\t}\n#endif\n#if NUM_SPOT_LIGHTS > 0\n\tstruct SpotLight {\n\t\tvec3 position;\n\t\tvec3 direction;\n\t\tvec3 color;\n\t\tfloat distance;\n\t\tfloat decay;\n\t\tfloat coneCos;\n\t\tfloat penumbraCos;\n\t};\n\tuniform SpotLight spotLights[ NUM_SPOT_LIGHTS ];\n\tvoid getSpotLightInfo( const in SpotLight spotLight, const in vec3 geometryPosition, out IncidentLight light ) {\n\t\tvec3 lVector = spotLight.position - geometryPosition;\n\t\tlight.direction = normalize( lVector );\n\t\tfloat angleCos = dot( light.direction, spotLight.direction );\n\t\tfloat spotAttenuation = getSpotAttenuation( spotLight.coneCos, spotLight.penumbraCos, angleCos );\n\t\tif ( spotAttenuation > 0.0 ) {\n\t\t\tfloat lightDistance = length( lVector );\n\t\t\tlight.color = spotLight.color * spotAttenuation;\n\t\t\tlight.color *= getDistanceAttenuation( lightDistance, spotLight.distance, spotLight.decay );\n\t\t\tlight.visible = ( light.color != vec3( 0.0 ) );\n\t\t} else {\n\t\t\tlight.color = vec3( 0.0 );\n\t\t\tlight.visible = false;\n\t\t}\n\t}\n#endif\n#if NUM_RECT_AREA_LIGHTS > 0\n\tstruct RectAreaLight {\n\t\tvec3 color;\n\t\tvec3 position;\n\t\tvec3 halfWidth;\n\t\tvec3 halfHeight;\n\t};\n\tuniform sampler2D ltc_1;\tuniform sampler2D ltc_2;\n\tuniform RectAreaLight rectAreaLights[ NUM_RECT_AREA_LIGHTS ];\n#endif\n#if NUM_HEMI_LIGHTS > 0\n\tstruct HemisphereLight {\n\t\tvec3 direction;\n\t\tvec3 skyColor;\n\t\tvec3 groundColor;\n\t};\n\tuniform HemisphereLight hemisphereLights[ NUM_HEMI_LIGHTS ];\n\tvec3 getHemisphereLightIrradiance( const in HemisphereLight hemiLight, const in vec3 normal ) {\n\t\tfloat dotNL = dot( normal, hemiLight.direction );\n\t\tfloat hemiDiffuseWeight = 0.5 * dotNL + 0.5;\n\t\tvec3 irradiance = mix( hemiLight.groundColor, hemiLight.skyColor, hemiDiffuseWeight );\n\t\treturn irradiance;\n\t}\n#endif";
var envmap_physical_pars_fragment = "#ifdef USE_ENVMAP\n\tvec3 getIBLIrradiance( const in vec3 normal ) {\n\t\t#ifdef ENVMAP_TYPE_CUBE_UV\n\t\t\tvec3 worldNormal = inverseTransformDirection( normal, viewMatrix );\n\t\t\tvec4 envMapColor = textureCubeUV( envMap, envMapRotation * worldNormal, 1.0 );\n\t\t\treturn PI * envMapColor.rgb * envMapIntensity;\n\t\t#else\n\t\t\treturn vec3( 0.0 );\n\t\t#endif\n\t}\n\tvec3 getIBLRadiance( const in vec3 viewDir, const in vec3 normal, const in float roughness ) {\n\t\t#ifdef ENVMAP_TYPE_CUBE_UV\n\t\t\tvec3 reflectVec = reflect( - viewDir, normal );\n\t\t\treflectVec = normalize( mix( reflectVec, normal, pow4( roughness ) ) );\n\t\t\treflectVec = inverseTransformDirection( reflectVec, viewMatrix );\n\t\t\tvec4 envMapColor = textureCubeUV( envMap, envMapRotation * reflectVec, roughness );\n\t\t\treturn envMapColor.rgb * envMapIntensity;\n\t\t#else\n\t\t\treturn vec3( 0.0 );\n\t\t#endif\n\t}\n\t#ifdef USE_ANISOTROPY\n\t\tvec3 getIBLAnisotropyRadiance( const in vec3 viewDir, const in vec3 normal, const in float roughness, const in vec3 bitangent, const in float anisotropy ) {\n\t\t\t#ifdef ENVMAP_TYPE_CUBE_UV\n\t\t\t\tvec3 bentNormal = cross( bitangent, viewDir );\n\t\t\t\tbentNormal = normalize( cross( bentNormal, bitangent ) );\n\t\t\t\tbentNormal = normalize( mix( bentNormal, normal, pow2( pow2( 1.0 - anisotropy * ( 1.0 - roughness ) ) ) ) );\n\t\t\t\treturn getIBLRadiance( viewDir, bentNormal, roughness );\n\t\t\t#else\n\t\t\t\treturn vec3( 0.0 );\n\t\t\t#endif\n\t\t}\n\t#endif\n#endif";
var lights_toon_fragment = "ToonMaterial material;\nmaterial.diffuseColor = diffuseColor.rgb;";
var lights_toon_pars_fragment = "varying vec3 vViewPosition;\nstruct ToonMaterial {\n\tvec3 diffuseColor;\n};\nvoid RE_Direct_Toon( const in IncidentLight directLight, const in vec3 geometryPosition, const in vec3 geometryNormal, const in vec3 geometryViewDir, const in vec3 geometryClearcoatNormal, const in ToonMaterial material, inout ReflectedLight reflectedLight ) {\n\tvec3 irradiance = getGradientIrradiance( geometryNormal, directLight.direction ) * directLight.color;\n\treflectedLight.directDiffuse += irradiance * BRDF_Lambert( material.diffuseColor );\n}\nvoid RE_IndirectDiffuse_Toon( const in vec3 irradiance, const in vec3 geometryPosition, const in vec3 geometryNormal, const in vec3 geometryViewDir, const in vec3 geometryClearcoatNormal, const in ToonMaterial material, inout ReflectedLight reflectedLight ) {\n\treflectedLight.indirectDiffuse += irradiance * BRDF_Lambert( material.diffuseColor );\n}\n#define RE_Direct\t\t\t\tRE_Direct_Toon\n#define RE_IndirectDiffuse\t\tRE_IndirectDiffuse_Toon";
var lights_phong_fragment = "BlinnPhongMaterial material;\nmaterial.diffuseColor = diffuseColor.rgb;\nmaterial.specularColor = specular;\nmaterial.specularShininess = shininess;\nmaterial.specularStrength = specularStrength;";
var lights_phong_pars_fragment = "varying vec3 vViewPosition;\nstruct BlinnPhongMaterial {\n\tvec3 diffuseColor;\n\tvec3 specularColor;\n\tfloat specularShininess;\n\tfloat specularStrength;\n};\nvoid RE_Direct_BlinnPhong( const in IncidentLight directLight, const in vec3 geometryPosition, const in vec3 geometryNormal, const in vec3 geometryViewDir, const in vec3 geometryClearcoatNormal, const in BlinnPhongMaterial material, inout ReflectedLight reflectedLight ) {\n\tfloat dotNL = saturate( dot( geometryNormal, directLight.direction ) );\n\tvec3 irradiance = dotNL * directLight.color;\n\treflectedLight.directDiffuse += irradiance * BRDF_Lambert( material.diffuseColor );\n\treflectedLight.directSpecular += irradiance * BRDF_BlinnPhong( directLight.direction, geometryViewDir, geometryNormal, material.specularColor, material.specularShininess ) * material.specularStrength;\n}\nvoid RE_IndirectDiffuse_BlinnPhong( const in vec3 irradiance, const in vec3 geometryPosition, const in vec3 geometryNormal, const in vec3 geometryViewDir, const in vec3 geometryClearcoatNormal, const in BlinnPhongMaterial material, inout ReflectedLight reflectedLight ) {\n\treflectedLight.indirectDiffuse += irradiance * BRDF_Lambert( material.diffuseColor );\n}\n#define RE_Direct\t\t\t\tRE_Direct_BlinnPhong\n#define RE_IndirectDiffuse\t\tRE_IndirectDiffuse_BlinnPhong";
var lights_physical_fragment = "PhysicalMaterial material;\nmaterial.diffuseColor = diffuseColor.rgb;\nmaterial.diffuseContribution = diffuseColor.rgb * ( 1.0 - metalnessFactor );\nmaterial.metalness = metalnessFactor;\nvec3 dxy = max( abs( dFdx( nonPerturbedNormal ) ), abs( dFdy( nonPerturbedNormal ) ) );\nfloat geometryRoughness = max( max( dxy.x, dxy.y ), dxy.z );\nmaterial.roughness = max( roughnessFactor, 0.0525 );material.roughness += geometryRoughness;\nmaterial.roughness = min( material.roughness, 1.0 );\n#ifdef IOR\n\tmaterial.ior = ior;\n\t#ifdef USE_SPECULAR\n\t\tfloat specularIntensityFactor = specularIntensity;\n\t\tvec3 specularColorFactor = specularColor;\n\t\t#ifdef USE_SPECULAR_COLORMAP\n\t\t\tspecularColorFactor *= texture2D( specularColorMap, vSpecularColorMapUv ).rgb;\n\t\t#endif\n\t\t#ifdef USE_SPECULAR_INTENSITYMAP\n\t\t\tspecularIntensityFactor *= texture2D( specularIntensityMap, vSpecularIntensityMapUv ).a;\n\t\t#endif\n\t\tmaterial.specularF90 = mix( specularIntensityFactor, 1.0, metalnessFactor );\n\t#else\n\t\tfloat specularIntensityFactor = 1.0;\n\t\tvec3 specularColorFactor = vec3( 1.0 );\n\t\tmaterial.specularF90 = 1.0;\n\t#endif\n\tmaterial.specularColor = min( pow2( ( material.ior - 1.0 ) / ( material.ior + 1.0 ) ) * specularColorFactor, vec3( 1.0 ) ) * specularIntensityFactor;\n\tmaterial.specularColorBlended = mix( material.specularColor, diffuseColor.rgb, metalnessFactor );\n#else\n\tmaterial.specularColor = vec3( 0.04 );\n\tmaterial.specularColorBlended = mix( material.specularColor, diffuseColor.rgb, metalnessFactor );\n\tmaterial.specularF90 = 1.0;\n#endif\n#ifdef USE_CLEARCOAT\n\tmaterial.clearcoat = clearcoat;\n\tmaterial.clearcoatRoughness = clearcoatRoughness;\n\tmaterial.clearcoatF0 = vec3( 0.04 );\n\tmaterial.clearcoatF90 = 1.0;\n\t#ifdef USE_CLEARCOATMAP\n\t\tmaterial.clearcoat *= texture2D( clearcoatMap, vClearcoatMapUv ).x;\n\t#endif\n\t#ifdef USE_CLEARCOAT_ROUGHNESSMAP\n\t\tmaterial.clearcoatRoughness *= texture2D( clearcoatRoughnessMap, vClearcoatRoughnessMapUv ).y;\n\t#endif\n\tmaterial.clearcoat = saturate( material.clearcoat );\tmaterial.clearcoatRoughness = max( material.clearcoatRoughness, 0.0525 );\n\tmaterial.clearcoatRoughness += geometryRoughness;\n\tmaterial.clearcoatRoughness = min( material.clearcoatRoughness, 1.0 );\n#endif\n#ifdef USE_DISPERSION\n\tmaterial.dispersion = dispersion;\n#endif\n#ifdef USE_IRIDESCENCE\n\tmaterial.iridescence = iridescence;\n\tmaterial.iridescenceIOR = iridescenceIOR;\n\t#ifdef USE_IRIDESCENCEMAP\n\t\tmaterial.iridescence *= texture2D( iridescenceMap, vIridescenceMapUv ).r;\n\t#endif\n\t#ifdef USE_IRIDESCENCE_THICKNESSMAP\n\t\tmaterial.iridescenceThickness = (iridescenceThicknessMaximum - iridescenceThicknessMinimum) * texture2D( iridescenceThicknessMap, vIridescenceThicknessMapUv ).g + iridescenceThicknessMinimum;\n\t#else\n\t\tmaterial.iridescenceThickness = iridescenceThicknessMaximum;\n\t#endif\n#endif\n#ifdef USE_SHEEN\n\tmaterial.sheenColor = sheenColor;\n\t#ifdef USE_SHEEN_COLORMAP\n\t\tmaterial.sheenColor *= texture2D( sheenColorMap, vSheenColorMapUv ).rgb;\n\t#endif\n\tmaterial.sheenRoughness = clamp( sheenRoughness, 0.0001, 1.0 );\n\t#ifdef USE_SHEEN_ROUGHNESSMAP\n\t\tmaterial.sheenRoughness *= texture2D( sheenRoughnessMap, vSheenRoughnessMapUv ).a;\n\t#endif\n#endif\n#ifdef USE_ANISOTROPY\n\t#ifdef USE_ANISOTROPYMAP\n\t\tmat2 anisotropyMat = mat2( anisotropyVector.x, anisotropyVector.y, - anisotropyVector.y, anisotropyVector.x );\n\t\tvec3 anisotropyPolar = texture2D( anisotropyMap, vAnisotropyMapUv ).rgb;\n\t\tvec2 anisotropyV = anisotropyMat * normalize( 2.0 * anisotropyPolar.rg - vec2( 1.0 ) ) * anisotropyPolar.b;\n\t#else\n\t\tvec2 anisotropyV = anisotropyVector;\n\t#endif\n\tmaterial.anisotropy = length( anisotropyV );\n\tif( material.anisotropy == 0.0 ) {\n\t\tanisotropyV = vec2( 1.0, 0.0 );\n\t} else {\n\t\tanisotropyV /= material.anisotropy;\n\t\tmaterial.anisotropy = saturate( material.anisotropy );\n\t}\n\tmaterial.alphaT = mix( pow2( material.roughness ), 1.0, pow2( material.anisotropy ) );\n\tmaterial.anisotropyT = tbn[ 0 ] * anisotropyV.x + tbn[ 1 ] * anisotropyV.y;\n\tmaterial.anisotropyB = tbn[ 1 ] * anisotropyV.x - tbn[ 0 ] * anisotropyV.y;\n#endif";
var lights_physical_pars_fragment = "uniform sampler2D dfgLUT;\nstruct PhysicalMaterial {\n\tvec3 diffuseColor;\n\tvec3 diffuseContribution;\n\tvec3 specularColor;\n\tvec3 specularColorBlended;\n\tfloat roughness;\n\tfloat metalness;\n\tfloat specularF90;\n\tfloat dispersion;\n\t#ifdef USE_CLEARCOAT\n\t\tfloat clearcoat;\n\t\tfloat clearcoatRoughness;\n\t\tvec3 clearcoatF0;\n\t\tfloat clearcoatF90;\n\t#endif\n\t#ifdef USE_IRIDESCENCE\n\t\tfloat iridescence;\n\t\tfloat iridescenceIOR;\n\t\tfloat iridescenceThickness;\n\t\tvec3 iridescenceFresnel;\n\t\tvec3 iridescenceF0;\n\t\tvec3 iridescenceFresnelDielectric;\n\t\tvec3 iridescenceFresnelMetallic;\n\t#endif\n\t#ifdef USE_SHEEN\n\t\tvec3 sheenColor;\n\t\tfloat sheenRoughness;\n\t#endif\n\t#ifdef IOR\n\t\tfloat ior;\n\t#endif\n\t#ifdef USE_TRANSMISSION\n\t\tfloat transmission;\n\t\tfloat transmissionAlpha;\n\t\tfloat thickness;\n\t\tfloat attenuationDistance;\n\t\tvec3 attenuationColor;\n\t#endif\n\t#ifdef USE_ANISOTROPY\n\t\tfloat anisotropy;\n\t\tfloat alphaT;\n\t\tvec3 anisotropyT;\n\t\tvec3 anisotropyB;\n\t#endif\n};\nvec3 clearcoatSpecularDirect = vec3( 0.0 );\nvec3 clearcoatSpecularIndirect = vec3( 0.0 );\nvec3 sheenSpecularDirect = vec3( 0.0 );\nvec3 sheenSpecularIndirect = vec3(0.0 );\nvec3 Schlick_to_F0( const in vec3 f, const in float f90, const in float dotVH ) {\n    float x = clamp( 1.0 - dotVH, 0.0, 1.0 );\n    float x2 = x * x;\n    float x5 = clamp( x * x2 * x2, 0.0, 0.9999 );\n    return ( f - vec3( f90 ) * x5 ) / ( 1.0 - x5 );\n}\nfloat V_GGX_SmithCorrelated( const in float alpha, const in float dotNL, const in float dotNV ) {\n\tfloat a2 = pow2( alpha );\n\tfloat gv = dotNL * sqrt( a2 + ( 1.0 - a2 ) * pow2( dotNV ) );\n\tfloat gl = dotNV * sqrt( a2 + ( 1.0 - a2 ) * pow2( dotNL ) );\n\treturn 0.5 / max( gv + gl, EPSILON );\n}\nfloat D_GGX( const in float alpha, const in float dotNH ) {\n\tfloat a2 = pow2( alpha );\n\tfloat denom = pow2( dotNH ) * ( a2 - 1.0 ) + 1.0;\n\treturn RECIPROCAL_PI * a2 / pow2( denom );\n}\n#ifdef USE_ANISOTROPY\n\tfloat V_GGX_SmithCorrelated_Anisotropic( const in float alphaT, const in float alphaB, const in float dotTV, const in float dotBV, const in float dotTL, const in float dotBL, const in float dotNV, const in float dotNL ) {\n\t\tfloat gv = dotNL * length( vec3( alphaT * dotTV, alphaB * dotBV, dotNV ) );\n\t\tfloat gl = dotNV * length( vec3( alphaT * dotTL, alphaB * dotBL, dotNL ) );\n\t\tfloat v = 0.5 / ( gv + gl );\n\t\treturn v;\n\t}\n\tfloat D_GGX_Anisotropic( const in float alphaT, const in float alphaB, const in float dotNH, const in float dotTH, const in float dotBH ) {\n\t\tfloat a2 = alphaT * alphaB;\n\t\thighp vec3 v = vec3( alphaB * dotTH, alphaT * dotBH, a2 * dotNH );\n\t\thighp float v2 = dot( v, v );\n\t\tfloat w2 = a2 / v2;\n\t\treturn RECIPROCAL_PI * a2 * pow2 ( w2 );\n\t}\n#endif\n#ifdef USE_CLEARCOAT\n\tvec3 BRDF_GGX_Clearcoat( const in vec3 lightDir, const in vec3 viewDir, const in vec3 normal, const in PhysicalMaterial material) {\n\t\tvec3 f0 = material.clearcoatF0;\n\t\tfloat f90 = material.clearcoatF90;\n\t\tfloat roughness = material.clearcoatRoughness;\n\t\tfloat alpha = pow2( roughness );\n\t\tvec3 halfDir = normalize( lightDir + viewDir );\n\t\tfloat dotNL = saturate( dot( normal, lightDir ) );\n\t\tfloat dotNV = saturate( dot( normal, viewDir ) );\n\t\tfloat dotNH = saturate( dot( normal, halfDir ) );\n\t\tfloat dotVH = saturate( dot( viewDir, halfDir ) );\n\t\tvec3 F = F_Schlick( f0, f90, dotVH );\n\t\tfloat V = V_GGX_SmithCorrelated( alpha, dotNL, dotNV );\n\t\tfloat D = D_GGX( alpha, dotNH );\n\t\treturn F * ( V * D );\n\t}\n#endif\nvec3 BRDF_GGX( const in vec3 lightDir, const in vec3 viewDir, const in vec3 normal, const in PhysicalMaterial material ) {\n\tvec3 f0 = material.specularColorBlended;\n\tfloat f90 = material.specularF90;\n\tfloat roughness = material.roughness;\n\tfloat alpha = pow2( roughness );\n\tvec3 halfDir = normalize( lightDir + viewDir );\n\tfloat dotNL = saturate( dot( normal, lightDir ) );\n\tfloat dotNV = saturate( dot( normal, viewDir ) );\n\tfloat dotNH = saturate( dot( normal, halfDir ) );\n\tfloat dotVH = saturate( dot( viewDir, halfDir ) );\n\tvec3 F = F_Schlick( f0, f90, dotVH );\n\t#ifdef USE_IRIDESCENCE\n\t\tF = mix( F, material.iridescenceFresnel, material.iridescence );\n\t#endif\n\t#ifdef USE_ANISOTROPY\n\t\tfloat dotTL = dot( material.anisotropyT, lightDir );\n\t\tfloat dotTV = dot( material.anisotropyT, viewDir );\n\t\tfloat dotTH = dot( material.anisotropyT, halfDir );\n\t\tfloat dotBL = dot( material.anisotropyB, lightDir );\n\t\tfloat dotBV = dot( material.anisotropyB, viewDir );\n\t\tfloat dotBH = dot( material.anisotropyB, halfDir );\n\t\tfloat V = V_GGX_SmithCorrelated_Anisotropic( material.alphaT, alpha, dotTV, dotBV, dotTL, dotBL, dotNV, dotNL );\n\t\tfloat D = D_GGX_Anisotropic( material.alphaT, alpha, dotNH, dotTH, dotBH );\n\t#else\n\t\tfloat V = V_GGX_SmithCorrelated( alpha, dotNL, dotNV );\n\t\tfloat D = D_GGX( alpha, dotNH );\n\t#endif\n\treturn F * ( V * D );\n}\nvec2 LTC_Uv( const in vec3 N, const in vec3 V, const in float roughness ) {\n\tconst float LUT_SIZE = 64.0;\n\tconst float LUT_SCALE = ( LUT_SIZE - 1.0 ) / LUT_SIZE;\n\tconst float LUT_BIAS = 0.5 / LUT_SIZE;\n\tfloat dotNV = saturate( dot( N, V ) );\n\tvec2 uv = vec2( roughness, sqrt( 1.0 - dotNV ) );\n\tuv = uv * LUT_SCALE + LUT_BIAS;\n\treturn uv;\n}\nfloat LTC_ClippedSphereFormFactor( const in vec3 f ) {\n\tfloat l = length( f );\n\treturn max( ( l * l + f.z ) / ( l + 1.0 ), 0.0 );\n}\nvec3 LTC_EdgeVectorFormFactor( const in vec3 v1, const in vec3 v2 ) {\n\tfloat x = dot( v1, v2 );\n\tfloat y = abs( x );\n\tfloat a = 0.8543985 + ( 0.4965155 + 0.0145206 * y ) * y;\n\tfloat b = 3.4175940 + ( 4.1616724 + y ) * y;\n\tfloat v = a / b;\n\tfloat theta_sintheta = ( x > 0.0 ) ? v : 0.5 * inversesqrt( max( 1.0 - x * x, 1e-7 ) ) - v;\n\treturn cross( v1, v2 ) * theta_sintheta;\n}\nvec3 LTC_Evaluate( const in vec3 N, const in vec3 V, const in vec3 P, const in mat3 mInv, const in vec3 rectCoords[ 4 ] ) {\n\tvec3 v1 = rectCoords[ 1 ] - rectCoords[ 0 ];\n\tvec3 v2 = rectCoords[ 3 ] - rectCoords[ 0 ];\n\tvec3 lightNormal = cross( v1, v2 );\n\tif( dot( lightNormal, P - rectCoords[ 0 ] ) < 0.0 ) return vec3( 0.0 );\n\tvec3 T1, T2;\n\tT1 = normalize( V - N * dot( V, N ) );\n\tT2 = - cross( N, T1 );\n\tmat3 mat = mInv * transpose( mat3( T1, T2, N ) );\n\tvec3 coords[ 4 ];\n\tcoords[ 0 ] = mat * ( rectCoords[ 0 ] - P );\n\tcoords[ 1 ] = mat * ( rectCoords[ 1 ] - P );\n\tcoords[ 2 ] = mat * ( rectCoords[ 2 ] - P );\n\tcoords[ 3 ] = mat * ( rectCoords[ 3 ] - P );\n\tcoords[ 0 ] = normalize( coords[ 0 ] );\n\tcoords[ 1 ] = normalize( coords[ 1 ] );\n\tcoords[ 2 ] = normalize( coords[ 2 ] );\n\tcoords[ 3 ] = normalize( coords[ 3 ] );\n\tvec3 vectorFormFactor = vec3( 0.0 );\n\tvectorFormFactor += LTC_EdgeVectorFormFactor( coords[ 0 ], coords[ 1 ] );\n\tvectorFormFactor += LTC_EdgeVectorFormFactor( coords[ 1 ], coords[ 2 ] );\n\tvectorFormFactor += LTC_EdgeVectorFormFactor( coords[ 2 ], coords[ 3 ] );\n\tvectorFormFactor += LTC_EdgeVectorFormFactor( coords[ 3 ], coords[ 0 ] );\n\tfloat result = LTC_ClippedSphereFormFactor( vectorFormFactor );\n\treturn vec3( result );\n}\n#if defined( USE_SHEEN )\nfloat D_Charlie( float roughness, float dotNH ) {\n\tfloat alpha = pow2( roughness );\n\tfloat invAlpha = 1.0 / alpha;\n\tfloat cos2h = dotNH * dotNH;\n\tfloat sin2h = max( 1.0 - cos2h, 0.0078125 );\n\treturn ( 2.0 + invAlpha ) * pow( sin2h, invAlpha * 0.5 ) / ( 2.0 * PI );\n}\nfloat V_Neubelt( float dotNV, float dotNL ) {\n\treturn saturate( 1.0 / ( 4.0 * ( dotNL + dotNV - dotNL * dotNV ) ) );\n}\nvec3 BRDF_Sheen( const in vec3 lightDir, const in vec3 viewDir, const in vec3 normal, vec3 sheenColor, const in float sheenRoughness ) {\n\tvec3 halfDir = normalize( lightDir + viewDir );\n\tfloat dotNL = saturate( dot( normal, lightDir ) );\n\tfloat dotNV = saturate( dot( normal, viewDir ) );\n\tfloat dotNH = saturate( dot( normal, halfDir ) );\n\tfloat D = D_Charlie( sheenRoughness, dotNH );\n\tfloat V = V_Neubelt( dotNV, dotNL );\n\treturn sheenColor * ( D * V );\n}\n#endif\nfloat IBLSheenBRDF( const in vec3 normal, const in vec3 viewDir, const in float roughness ) {\n\tfloat dotNV = saturate( dot( normal, viewDir ) );\n\tfloat r2 = roughness * roughness;\n\tfloat rInv = 1.0 / ( roughness + 0.1 );\n\tfloat a = -1.9362 + 1.0678 * roughness + 0.4573 * r2 - 0.8469 * rInv;\n\tfloat b = -0.6014 + 0.5538 * roughness - 0.4670 * r2 - 0.1255 * rInv;\n\tfloat DG = exp( a * dotNV + b );\n\treturn saturate( DG );\n}\nvec3 EnvironmentBRDF( const in vec3 normal, const in vec3 viewDir, const in vec3 specularColor, const in float specularF90, const in float roughness ) {\n\tfloat dotNV = saturate( dot( normal, viewDir ) );\n\tvec2 fab = texture2D( dfgLUT, vec2( roughness, dotNV ) ).rg;\n\treturn specularColor * fab.x + specularF90 * fab.y;\n}\n#ifdef USE_IRIDESCENCE\nvoid computeMultiscatteringIridescence( const in vec3 normal, const in vec3 viewDir, const in vec3 specularColor, const in float specularF90, const in float iridescence, const in vec3 iridescenceF0, const in float roughness, inout vec3 singleScatter, inout vec3 multiScatter ) {\n#else\nvoid computeMultiscattering( const in vec3 normal, const in vec3 viewDir, const in vec3 specularColor, const in float specularF90, const in float roughness, inout vec3 singleScatter, inout vec3 multiScatter ) {\n#endif\n\tfloat dotNV = saturate( dot( normal, viewDir ) );\n\tvec2 fab = texture2D( dfgLUT, vec2( roughness, dotNV ) ).rg;\n\t#ifdef USE_IRIDESCENCE\n\t\tvec3 Fr = mix( specularColor, iridescenceF0, iridescence );\n\t#else\n\t\tvec3 Fr = specularColor;\n\t#endif\n\tvec3 FssEss = Fr * fab.x + specularF90 * fab.y;\n\tfloat Ess = fab.x + fab.y;\n\tfloat Ems = 1.0 - Ess;\n\tvec3 Favg = Fr + ( 1.0 - Fr ) * 0.047619;\tvec3 Fms = FssEss * Favg / ( 1.0 - Ems * Favg );\n\tsingleScatter += FssEss;\n\tmultiScatter += Fms * Ems;\n}\nvec3 BRDF_GGX_Multiscatter( const in vec3 lightDir, const in vec3 viewDir, const in vec3 normal, const in PhysicalMaterial material ) {\n\tvec3 singleScatter = BRDF_GGX( lightDir, viewDir, normal, material );\n\tfloat dotNL = saturate( dot( normal, lightDir ) );\n\tfloat dotNV = saturate( dot( normal, viewDir ) );\n\tvec2 dfgV = texture2D( dfgLUT, vec2( material.roughness, dotNV ) ).rg;\n\tvec2 dfgL = texture2D( dfgLUT, vec2( material.roughness, dotNL ) ).rg;\n\tvec3 FssEss_V = material.specularColorBlended * dfgV.x + material.specularF90 * dfgV.y;\n\tvec3 FssEss_L = material.specularColorBlended * dfgL.x + material.specularF90 * dfgL.y;\n\tfloat Ess_V = dfgV.x + dfgV.y;\n\tfloat Ess_L = dfgL.x + dfgL.y;\n\tfloat Ems_V = 1.0 - Ess_V;\n\tfloat Ems_L = 1.0 - Ess_L;\n\tvec3 Favg = material.specularColorBlended + ( 1.0 - material.specularColorBlended ) * 0.047619;\n\tvec3 Fms = FssEss_V * FssEss_L * Favg / ( 1.0 - Ems_V * Ems_L * Favg + EPSILON );\n\tfloat compensationFactor = Ems_V * Ems_L;\n\tvec3 multiScatter = Fms * compensationFactor;\n\treturn singleScatter + multiScatter;\n}\n#if NUM_RECT_AREA_LIGHTS > 0\n\tvoid RE_Direct_RectArea_Physical( const in RectAreaLight rectAreaLight, const in vec3 geometryPosition, const in vec3 geometryNormal, const in vec3 geometryViewDir, const in vec3 geometryClearcoatNormal, const in PhysicalMaterial material, inout ReflectedLight reflectedLight ) {\n\t\tvec3 normal = geometryNormal;\n\t\tvec3 viewDir = geometryViewDir;\n\t\tvec3 position = geometryPosition;\n\t\tvec3 lightPos = rectAreaLight.position;\n\t\tvec3 halfWidth = rectAreaLight.halfWidth;\n\t\tvec3 halfHeight = rectAreaLight.halfHeight;\n\t\tvec3 lightColor = rectAreaLight.color;\n\t\tfloat roughness = material.roughness;\n\t\tvec3 rectCoords[ 4 ];\n\t\trectCoords[ 0 ] = lightPos + halfWidth - halfHeight;\t\trectCoords[ 1 ] = lightPos - halfWidth - halfHeight;\n\t\trectCoords[ 2 ] = lightPos - halfWidth + halfHeight;\n\t\trectCoords[ 3 ] = lightPos + halfWidth + halfHeight;\n\t\tvec2 uv = LTC_Uv( normal, viewDir, roughness );\n\t\tvec4 t1 = texture2D( ltc_1, uv );\n\t\tvec4 t2 = texture2D( ltc_2, uv );\n\t\tmat3 mInv = mat3(\n\t\t\tvec3( t1.x, 0, t1.y ),\n\t\t\tvec3(    0, 1,    0 ),\n\t\t\tvec3( t1.z, 0, t1.w )\n\t\t);\n\t\tvec3 fresnel = ( material.specularColorBlended * t2.x + ( vec3( 1.0 ) - material.specularColorBlended ) * t2.y );\n\t\treflectedLight.directSpecular += lightColor * fresnel * LTC_Evaluate( normal, viewDir, position, mInv, rectCoords );\n\t\treflectedLight.directDiffuse += lightColor * material.diffuseContribution * LTC_Evaluate( normal, viewDir, position, mat3( 1.0 ), rectCoords );\n\t}\n#endif\nvoid RE_Direct_Physical( const in IncidentLight directLight, const in vec3 geometryPosition, const in vec3 geometryNormal, const in vec3 geometryViewDir, const in vec3 geometryClearcoatNormal, const in PhysicalMaterial material, inout ReflectedLight reflectedLight ) {\n\tfloat dotNL = saturate( dot( geometryNormal, directLight.direction ) );\n\tvec3 irradiance = dotNL * directLight.color;\n\t#ifdef USE_CLEARCOAT\n\t\tfloat dotNLcc = saturate( dot( geometryClearcoatNormal, directLight.direction ) );\n\t\tvec3 ccIrradiance = dotNLcc * directLight.color;\n\t\tclearcoatSpecularDirect += ccIrradiance * BRDF_GGX_Clearcoat( directLight.direction, geometryViewDir, geometryClearcoatNormal, material );\n\t#endif\n\t#ifdef USE_SHEEN\n \n \t\tsheenSpecularDirect += irradiance * BRDF_Sheen( directLight.direction, geometryViewDir, geometryNormal, material.sheenColor, material.sheenRoughness );\n \n \t\tfloat sheenAlbedoV = IBLSheenBRDF( geometryNormal, geometryViewDir, material.sheenRoughness );\n \t\tfloat sheenAlbedoL = IBLSheenBRDF( geometryNormal, directLight.direction, material.sheenRoughness );\n \n \t\tfloat sheenEnergyComp = 1.0 - max3( material.sheenColor ) * max( sheenAlbedoV, sheenAlbedoL );\n \n \t\tirradiance *= sheenEnergyComp;\n \n \t#endif\n\treflectedLight.directSpecular += irradiance * BRDF_GGX_Multiscatter( directLight.direction, geometryViewDir, geometryNormal, material );\n\treflectedLight.directDiffuse += irradiance * BRDF_Lambert( material.diffuseContribution );\n}\nvoid RE_IndirectDiffuse_Physical( const in vec3 irradiance, const in vec3 geometryPosition, const in vec3 geometryNormal, const in vec3 geometryViewDir, const in vec3 geometryClearcoatNormal, const in PhysicalMaterial material, inout ReflectedLight reflectedLight ) {\n\tvec3 diffuse = irradiance * BRDF_Lambert( material.diffuseContribution );\n\t#ifdef USE_SHEEN\n\t\tfloat sheenAlbedo = IBLSheenBRDF( geometryNormal, geometryViewDir, material.sheenRoughness );\n\t\tfloat sheenEnergyComp = 1.0 - max3( material.sheenColor ) * sheenAlbedo;\n\t\tdiffuse *= sheenEnergyComp;\n\t#endif\n\treflectedLight.indirectDiffuse += diffuse;\n}\nvoid RE_IndirectSpecular_Physical( const in vec3 radiance, const in vec3 irradiance, const in vec3 clearcoatRadiance, const in vec3 geometryPosition, const in vec3 geometryNormal, const in vec3 geometryViewDir, const in vec3 geometryClearcoatNormal, const in PhysicalMaterial material, inout ReflectedLight reflectedLight) {\n\t#ifdef USE_CLEARCOAT\n\t\tclearcoatSpecularIndirect += clearcoatRadiance * EnvironmentBRDF( geometryClearcoatNormal, geometryViewDir, material.clearcoatF0, material.clearcoatF90, material.clearcoatRoughness );\n\t#endif\n\t#ifdef USE_SHEEN\n\t\tsheenSpecularIndirect += irradiance * material.sheenColor * IBLSheenBRDF( geometryNormal, geometryViewDir, material.sheenRoughness ) * RECIPROCAL_PI;\n \t#endif\n\tvec3 singleScatteringDielectric = vec3( 0.0 );\n\tvec3 multiScatteringDielectric = vec3( 0.0 );\n\tvec3 singleScatteringMetallic = vec3( 0.0 );\n\tvec3 multiScatteringMetallic = vec3( 0.0 );\n\t#ifdef USE_IRIDESCENCE\n\t\tcomputeMultiscatteringIridescence( geometryNormal, geometryViewDir, material.specularColor, material.specularF90, material.iridescence, material.iridescenceFresnelDielectric, material.roughness, singleScatteringDielectric, multiScatteringDielectric );\n\t\tcomputeMultiscatteringIridescence( geometryNormal, geometryViewDir, material.diffuseColor, material.specularF90, material.iridescence, material.iridescenceFresnelMetallic, material.roughness, singleScatteringMetallic, multiScatteringMetallic );\n\t#else\n\t\tcomputeMultiscattering( geometryNormal, geometryViewDir, material.specularColor, material.specularF90, material.roughness, singleScatteringDielectric, multiScatteringDielectric );\n\t\tcomputeMultiscattering( geometryNormal, geometryViewDir, material.diffuseColor, material.specularF90, material.roughness, singleScatteringMetallic, multiScatteringMetallic );\n\t#endif\n\tvec3 singleScattering = mix( singleScatteringDielectric, singleScatteringMetallic, material.metalness );\n\tvec3 multiScattering = mix( multiScatteringDielectric, multiScatteringMetallic, material.metalness );\n\tvec3 totalScatteringDielectric = singleScatteringDielectric + multiScatteringDielectric;\n\tvec3 diffuse = material.diffuseContribution * ( 1.0 - totalScatteringDielectric );\n\tvec3 cosineWeightedIrradiance = irradiance * RECIPROCAL_PI;\n\tvec3 indirectSpecular = radiance * singleScattering;\n\tindirectSpecular += multiScattering * cosineWeightedIrradiance;\n\tvec3 indirectDiffuse = diffuse * cosineWeightedIrradiance;\n\t#ifdef USE_SHEEN\n\t\tfloat sheenAlbedo = IBLSheenBRDF( geometryNormal, geometryViewDir, material.sheenRoughness );\n\t\tfloat sheenEnergyComp = 1.0 - max3( material.sheenColor ) * sheenAlbedo;\n\t\tindirectSpecular *= sheenEnergyComp;\n\t\tindirectDiffuse *= sheenEnergyComp;\n\t#endif\n\treflectedLight.indirectSpecular += indirectSpecular;\n\treflectedLight.indirectDiffuse += indirectDiffuse;\n}\n#define RE_Direct\t\t\t\tRE_Direct_Physical\n#define RE_Direct_RectArea\t\tRE_Direct_RectArea_Physical\n#define RE_IndirectDiffuse\t\tRE_IndirectDiffuse_Physical\n#define RE_IndirectSpecular\t\tRE_IndirectSpecular_Physical\nfloat computeSpecularOcclusion( const in float dotNV, const in float ambientOcclusion, const in float roughness ) {\n\treturn saturate( pow( dotNV + ambientOcclusion, exp2( - 16.0 * roughness - 1.0 ) ) - 1.0 + ambientOcclusion );\n}";
var lights_fragment_begin = "\nvec3 geometryPosition = - vViewPosition;\nvec3 geometryNormal = normal;\nvec3 geometryViewDir = ( isOrthographic ) ? vec3( 0, 0, 1 ) : normalize( vViewPosition );\nvec3 geometryClearcoatNormal = vec3( 0.0 );\n#ifdef USE_CLEARCOAT\n\tgeometryClearcoatNormal = clearcoatNormal;\n#endif\n#ifdef USE_IRIDESCENCE\n\tfloat dotNVi = saturate( dot( normal, geometryViewDir ) );\n\tif ( material.iridescenceThickness == 0.0 ) {\n\t\tmaterial.iridescence = 0.0;\n\t} else {\n\t\tmaterial.iridescence = saturate( material.iridescence );\n\t}\n\tif ( material.iridescence > 0.0 ) {\n\t\tmaterial.iridescenceFresnelDielectric = evalIridescence( 1.0, material.iridescenceIOR, dotNVi, material.iridescenceThickness, material.specularColor );\n\t\tmaterial.iridescenceFresnelMetallic = evalIridescence( 1.0, material.iridescenceIOR, dotNVi, material.iridescenceThickness, material.diffuseColor );\n\t\tmaterial.iridescenceFresnel = mix( material.iridescenceFresnelDielectric, material.iridescenceFresnelMetallic, material.metalness );\n\t\tmaterial.iridescenceF0 = Schlick_to_F0( material.iridescenceFresnel, 1.0, dotNVi );\n\t}\n#endif\nIncidentLight directLight;\n#if ( NUM_POINT_LIGHTS > 0 ) && defined( RE_Direct )\n\tPointLight pointLight;\n\t#if defined( USE_SHADOWMAP ) && NUM_POINT_LIGHT_SHADOWS > 0\n\tPointLightShadow pointLightShadow;\n\t#endif\n\t#pragma unroll_loop_start\n\tfor ( int i = 0; i < NUM_POINT_LIGHTS; i ++ ) {\n\t\tpointLight = pointLights[ i ];\n\t\tgetPointLightInfo( pointLight, geometryPosition, directLight );\n\t\t#if defined( USE_SHADOWMAP ) && ( UNROLLED_LOOP_INDEX < NUM_POINT_LIGHT_SHADOWS ) && ( defined( SHADOWMAP_TYPE_PCF ) || defined( SHADOWMAP_TYPE_BASIC ) )\n\t\tpointLightShadow = pointLightShadows[ i ];\n\t\tdirectLight.color *= ( directLight.visible && receiveShadow ) ? getPointShadow( pointShadowMap[ i ], pointLightShadow.shadowMapSize, pointLightShadow.shadowIntensity, pointLightShadow.shadowBias, pointLightShadow.shadowRadius, vPointShadowCoord[ i ], pointLightShadow.shadowCameraNear, pointLightShadow.shadowCameraFar ) : 1.0;\n\t\t#endif\n\t\tRE_Direct( directLight, geometryPosition, geometryNormal, geometryViewDir, geometryClearcoatNormal, material, reflectedLight );\n\t}\n\t#pragma unroll_loop_end\n#endif\n#if ( NUM_SPOT_LIGHTS > 0 ) && defined( RE_Direct )\n\tSpotLight spotLight;\n\tvec4 spotColor;\n\tvec3 spotLightCoord;\n\tbool inSpotLightMap;\n\t#if defined( USE_SHADOWMAP ) && NUM_SPOT_LIGHT_SHADOWS > 0\n\tSpotLightShadow spotLightShadow;\n\t#endif\n\t#pragma unroll_loop_start\n\tfor ( int i = 0; i < NUM_SPOT_LIGHTS; i ++ ) {\n\t\tspotLight = spotLights[ i ];\n\t\tgetSpotLightInfo( spotLight, geometryPosition, directLight );\n\t\t#if ( UNROLLED_LOOP_INDEX < NUM_SPOT_LIGHT_SHADOWS_WITH_MAPS )\n\t\t#define SPOT_LIGHT_MAP_INDEX UNROLLED_LOOP_INDEX\n\t\t#elif ( UNROLLED_LOOP_INDEX < NUM_SPOT_LIGHT_SHADOWS )\n\t\t#define SPOT_LIGHT_MAP_INDEX NUM_SPOT_LIGHT_MAPS\n\t\t#else\n\t\t#define SPOT_LIGHT_MAP_INDEX ( UNROLLED_LOOP_INDEX - NUM_SPOT_LIGHT_SHADOWS + NUM_SPOT_LIGHT_SHADOWS_WITH_MAPS )\n\t\t#endif\n\t\t#if ( SPOT_LIGHT_MAP_INDEX < NUM_SPOT_LIGHT_MAPS )\n\t\t\tspotLightCoord = vSpotLightCoord[ i ].xyz / vSpotLightCoord[ i ].w;\n\t\t\tinSpotLightMap = all( lessThan( abs( spotLightCoord * 2. - 1. ), vec3( 1.0 ) ) );\n\t\t\tspotColor = texture2D( spotLightMap[ SPOT_LIGHT_MAP_INDEX ], spotLightCoord.xy );\n\t\t\tdirectLight.color = inSpotLightMap ? directLight.color * spotColor.rgb : directLight.color;\n\t\t#endif\n\t\t#undef SPOT_LIGHT_MAP_INDEX\n\t\t#if defined( USE_SHADOWMAP ) && ( UNROLLED_LOOP_INDEX < NUM_SPOT_LIGHT_SHADOWS )\n\t\tspotLightShadow = spotLightShadows[ i ];\n\t\tdirectLight.color *= ( directLight.visible && receiveShadow ) ? getShadow( spotShadowMap[ i ], spotLightShadow.shadowMapSize, spotLightShadow.shadowIntensity, spotLightShadow.shadowBias, spotLightShadow.shadowRadius, vSpotLightCoord[ i ] ) : 1.0;\n\t\t#endif\n\t\tRE_Direct( directLight, geometryPosition, geometryNormal, geometryViewDir, geometryClearcoatNormal, material, reflectedLight );\n\t}\n\t#pragma unroll_loop_end\n#endif\n#if ( NUM_DIR_LIGHTS > 0 ) && defined( RE_Direct )\n\tDirectionalLight directionalLight;\n\t#if defined( USE_SHADOWMAP ) && NUM_DIR_LIGHT_SHADOWS > 0\n\tDirectionalLightShadow directionalLightShadow;\n\t#endif\n\t#pragma unroll_loop_start\n\tfor ( int i = 0; i < NUM_DIR_LIGHTS; i ++ ) {\n\t\tdirectionalLight = directionalLights[ i ];\n\t\tgetDirectionalLightInfo( directionalLight, directLight );\n\t\t#if defined( USE_SHADOWMAP ) && ( UNROLLED_LOOP_INDEX < NUM_DIR_LIGHT_SHADOWS )\n\t\tdirectionalLightShadow = directionalLightShadows[ i ];\n\t\tdirectLight.color *= ( directLight.visible && receiveShadow ) ? getShadow( directionalShadowMap[ i ], directionalLightShadow.shadowMapSize, directionalLightShadow.shadowIntensity, directionalLightShadow.shadowBias, directionalLightShadow.shadowRadius, vDirectionalShadowCoord[ i ] ) : 1.0;\n\t\t#endif\n\t\tRE_Direct( directLight, geometryPosition, geometryNormal, geometryViewDir, geometryClearcoatNormal, material, reflectedLight );\n\t}\n\t#pragma unroll_loop_end\n#endif\n#if ( NUM_RECT_AREA_LIGHTS > 0 ) && defined( RE_Direct_RectArea )\n\tRectAreaLight rectAreaLight;\n\t#pragma unroll_loop_start\n\tfor ( int i = 0; i < NUM_RECT_AREA_LIGHTS; i ++ ) {\n\t\trectAreaLight = rectAreaLights[ i ];\n\t\tRE_Direct_RectArea( rectAreaLight, geometryPosition, geometryNormal, geometryViewDir, geometryClearcoatNormal, material, reflectedLight );\n\t}\n\t#pragma unroll_loop_end\n#endif\n#if defined( RE_IndirectDiffuse )\n\tvec3 iblIrradiance = vec3( 0.0 );\n\tvec3 irradiance = getAmbientLightIrradiance( ambientLightColor );\n\t#if defined( USE_LIGHT_PROBES )\n\t\tirradiance += getLightProbeIrradiance( lightProbe, geometryNormal );\n\t#endif\n\t#if ( NUM_HEMI_LIGHTS > 0 )\n\t\t#pragma unroll_loop_start\n\t\tfor ( int i = 0; i < NUM_HEMI_LIGHTS; i ++ ) {\n\t\t\tirradiance += getHemisphereLightIrradiance( hemisphereLights[ i ], geometryNormal );\n\t\t}\n\t\t#pragma unroll_loop_end\n\t#endif\n#endif\n#if defined( RE_IndirectSpecular )\n\tvec3 radiance = vec3( 0.0 );\n\tvec3 clearcoatRadiance = vec3( 0.0 );\n#endif";
var lights_fragment_maps = "#if defined( RE_IndirectDiffuse )\n\t#ifdef USE_LIGHTMAP\n\t\tvec4 lightMapTexel = texture2D( lightMap, vLightMapUv );\n\t\tvec3 lightMapIrradiance = lightMapTexel.rgb * lightMapIntensity;\n\t\tirradiance += lightMapIrradiance;\n\t#endif\n\t#if defined( USE_ENVMAP ) && defined( STANDARD ) && defined( ENVMAP_TYPE_CUBE_UV )\n\t\tiblIrradiance += getIBLIrradiance( geometryNormal );\n\t#endif\n#endif\n#if defined( USE_ENVMAP ) && defined( RE_IndirectSpecular )\n\t#ifdef USE_ANISOTROPY\n\t\tradiance += getIBLAnisotropyRadiance( geometryViewDir, geometryNormal, material.roughness, material.anisotropyB, material.anisotropy );\n\t#else\n\t\tradiance += getIBLRadiance( geometryViewDir, geometryNormal, material.roughness );\n\t#endif\n\t#ifdef USE_CLEARCOAT\n\t\tclearcoatRadiance += getIBLRadiance( geometryViewDir, geometryClearcoatNormal, material.clearcoatRoughness );\n\t#endif\n#endif";
var lights_fragment_end = "#if defined( RE_IndirectDiffuse )\n\tRE_IndirectDiffuse( irradiance, geometryPosition, geometryNormal, geometryViewDir, geometryClearcoatNormal, material, reflectedLight );\n#endif\n#if defined( RE_IndirectSpecular )\n\tRE_IndirectSpecular( radiance, iblIrradiance, clearcoatRadiance, geometryPosition, geometryNormal, geometryViewDir, geometryClearcoatNormal, material, reflectedLight );\n#endif";
var logdepthbuf_fragment = "#if defined( USE_LOGARITHMIC_DEPTH_BUFFER )\n\tgl_FragDepth = vIsPerspective == 0.0 ? gl_FragCoord.z : log2( vFragDepth ) * logDepthBufFC * 0.5;\n#endif";
var logdepthbuf_pars_fragment = "#if defined( USE_LOGARITHMIC_DEPTH_BUFFER )\n\tuniform float logDepthBufFC;\n\tvarying float vFragDepth;\n\tvarying float vIsPerspective;\n#endif";
var logdepthbuf_pars_vertex = "#ifdef USE_LOGARITHMIC_DEPTH_BUFFER\n\tvarying float vFragDepth;\n\tvarying float vIsPerspective;\n#endif";
var logdepthbuf_vertex = "#ifdef USE_LOGARITHMIC_DEPTH_BUFFER\n\tvFragDepth = 1.0 + gl_Position.w;\n\tvIsPerspective = float( isPerspectiveMatrix( projectionMatrix ) );\n#endif";
var map_fragment = "#ifdef USE_MAP\n\tvec4 sampledDiffuseColor = texture2D( map, vMapUv );\n\t#ifdef DECODE_VIDEO_TEXTURE\n\t\tsampledDiffuseColor = sRGBTransferEOTF( sampledDiffuseColor );\n\t#endif\n\tdiffuseColor *= sampledDiffuseColor;\n#endif";
var map_pars_fragment = "#ifdef USE_MAP\n\tuniform sampler2D map;\n#endif";
var map_particle_fragment = "#if defined( USE_MAP ) || defined( USE_ALPHAMAP )\n\t#if defined( USE_POINTS_UV )\n\t\tvec2 uv = vUv;\n\t#else\n\t\tvec2 uv = ( uvTransform * vec3( gl_PointCoord.x, 1.0 - gl_PointCoord.y, 1 ) ).xy;\n\t#endif\n#endif\n#ifdef USE_MAP\n\tdiffuseColor *= texture2D( map, uv );\n#endif\n#ifdef USE_ALPHAMAP\n\tdiffuseColor.a *= texture2D( alphaMap, uv ).g;\n#endif";
var map_particle_pars_fragment = "#if defined( USE_POINTS_UV )\n\tvarying vec2 vUv;\n#else\n\t#if defined( USE_MAP ) || defined( USE_ALPHAMAP )\n\t\tuniform mat3 uvTransform;\n\t#endif\n#endif\n#ifdef USE_MAP\n\tuniform sampler2D map;\n#endif\n#ifdef USE_ALPHAMAP\n\tuniform sampler2D alphaMap;\n#endif";
var metalnessmap_fragment = "float metalnessFactor = metalness;\n#ifdef USE_METALNESSMAP\n\tvec4 texelMetalness = texture2D( metalnessMap, vMetalnessMapUv );\n\tmetalnessFactor *= texelMetalness.b;\n#endif";
var metalnessmap_pars_fragment = "#ifdef USE_METALNESSMAP\n\tuniform sampler2D metalnessMap;\n#endif";
var morphinstance_vertex = "#ifdef USE_INSTANCING_MORPH\n\tfloat morphTargetInfluences[ MORPHTARGETS_COUNT ];\n\tfloat morphTargetBaseInfluence = texelFetch( morphTexture, ivec2( 0, gl_InstanceID ), 0 ).r;\n\tfor ( int i = 0; i < MORPHTARGETS_COUNT; i ++ ) {\n\t\tmorphTargetInfluences[i] =  texelFetch( morphTexture, ivec2( i + 1, gl_InstanceID ), 0 ).r;\n\t}\n#endif";
var morphcolor_vertex = "#if defined( USE_MORPHCOLORS )\n\tvColor *= morphTargetBaseInfluence;\n\tfor ( int i = 0; i < MORPHTARGETS_COUNT; i ++ ) {\n\t\t#if defined( USE_COLOR_ALPHA )\n\t\t\tif ( morphTargetInfluences[ i ] != 0.0 ) vColor += getMorph( gl_VertexID, i, 2 ) * morphTargetInfluences[ i ];\n\t\t#elif defined( USE_COLOR )\n\t\t\tif ( morphTargetInfluences[ i ] != 0.0 ) vColor += getMorph( gl_VertexID, i, 2 ).rgb * morphTargetInfluences[ i ];\n\t\t#endif\n\t}\n#endif";
var morphnormal_vertex = "#ifdef USE_MORPHNORMALS\n\tobjectNormal *= morphTargetBaseInfluence;\n\tfor ( int i = 0; i < MORPHTARGETS_COUNT; i ++ ) {\n\t\tif ( morphTargetInfluences[ i ] != 0.0 ) objectNormal += getMorph( gl_VertexID, i, 1 ).xyz * morphTargetInfluences[ i ];\n\t}\n#endif";
var morphtarget_pars_vertex = "#ifdef USE_MORPHTARGETS\n\t#ifndef USE_INSTANCING_MORPH\n\t\tuniform float morphTargetBaseInfluence;\n\t\tuniform float morphTargetInfluences[ MORPHTARGETS_COUNT ];\n\t#endif\n\tuniform sampler2DArray morphTargetsTexture;\n\tuniform ivec2 morphTargetsTextureSize;\n\tvec4 getMorph( const in int vertexIndex, const in int morphTargetIndex, const in int offset ) {\n\t\tint texelIndex = vertexIndex * MORPHTARGETS_TEXTURE_STRIDE + offset;\n\t\tint y = texelIndex / morphTargetsTextureSize.x;\n\t\tint x = texelIndex - y * morphTargetsTextureSize.x;\n\t\tivec3 morphUV = ivec3( x, y, morphTargetIndex );\n\t\treturn texelFetch( morphTargetsTexture, morphUV, 0 );\n\t}\n#endif";
var morphtarget_vertex = "#ifdef USE_MORPHTARGETS\n\ttransformed *= morphTargetBaseInfluence;\n\tfor ( int i = 0; i < MORPHTARGETS_COUNT; i ++ ) {\n\t\tif ( morphTargetInfluences[ i ] != 0.0 ) transformed += getMorph( gl_VertexID, i, 0 ).xyz * morphTargetInfluences[ i ];\n\t}\n#endif";
var normal_fragment_begin = "float faceDirection = gl_FrontFacing ? 1.0 : - 1.0;\n#ifdef FLAT_SHADED\n\tvec3 fdx = dFdx( vViewPosition );\n\tvec3 fdy = dFdy( vViewPosition );\n\tvec3 normal = normalize( cross( fdx, fdy ) );\n#else\n\tvec3 normal = normalize( vNormal );\n\t#ifdef DOUBLE_SIDED\n\t\tnormal *= faceDirection;\n\t#endif\n#endif\n#if defined( USE_NORMALMAP_TANGENTSPACE ) || defined( USE_CLEARCOAT_NORMALMAP ) || defined( USE_ANISOTROPY )\n\t#ifdef USE_TANGENT\n\t\tmat3 tbn = mat3( normalize( vTangent ), normalize( vBitangent ), normal );\n\t#else\n\t\tmat3 tbn = getTangentFrame( - vViewPosition, normal,\n\t\t#if defined( USE_NORMALMAP )\n\t\t\tvNormalMapUv\n\t\t#elif defined( USE_CLEARCOAT_NORMALMAP )\n\t\t\tvClearcoatNormalMapUv\n\t\t#else\n\t\t\tvUv\n\t\t#endif\n\t\t);\n\t#endif\n\t#if defined( DOUBLE_SIDED ) && ! defined( FLAT_SHADED )\n\t\ttbn[0] *= faceDirection;\n\t\ttbn[1] *= faceDirection;\n\t#endif\n#endif\n#ifdef USE_CLEARCOAT_NORMALMAP\n\t#ifdef USE_TANGENT\n\t\tmat3 tbn2 = mat3( normalize( vTangent ), normalize( vBitangent ), normal );\n\t#else\n\t\tmat3 tbn2 = getTangentFrame( - vViewPosition, normal, vClearcoatNormalMapUv );\n\t#endif\n\t#if defined( DOUBLE_SIDED ) && ! defined( FLAT_SHADED )\n\t\ttbn2[0] *= faceDirection;\n\t\ttbn2[1] *= faceDirection;\n\t#endif\n#endif\nvec3 nonPerturbedNormal = normal;";
var normal_fragment_maps = "#ifdef USE_NORMALMAP_OBJECTSPACE\n\tnormal = texture2D( normalMap, vNormalMapUv ).xyz * 2.0 - 1.0;\n\t#ifdef FLIP_SIDED\n\t\tnormal = - normal;\n\t#endif\n\t#ifdef DOUBLE_SIDED\n\t\tnormal = normal * faceDirection;\n\t#endif\n\tnormal = normalize( normalMatrix * normal );\n#elif defined( USE_NORMALMAP_TANGENTSPACE )\n\tvec3 mapN = texture2D( normalMap, vNormalMapUv ).xyz * 2.0 - 1.0;\n\tmapN.xy *= normalScale;\n\tnormal = normalize( tbn * mapN );\n#elif defined( USE_BUMPMAP )\n\tnormal = perturbNormalArb( - vViewPosition, normal, dHdxy_fwd(), faceDirection );\n#endif";
var normal_pars_fragment = "#ifndef FLAT_SHADED\n\tvarying vec3 vNormal;\n\t#ifdef USE_TANGENT\n\t\tvarying vec3 vTangent;\n\t\tvarying vec3 vBitangent;\n\t#endif\n#endif";
var normal_pars_vertex = "#ifndef FLAT_SHADED\n\tvarying vec3 vNormal;\n\t#ifdef USE_TANGENT\n\t\tvarying vec3 vTangent;\n\t\tvarying vec3 vBitangent;\n\t#endif\n#endif";
var normal_vertex = "#ifndef FLAT_SHADED\n\tvNormal = normalize( transformedNormal );\n\t#ifdef USE_TANGENT\n\t\tvTangent = normalize( transformedTangent );\n\t\tvBitangent = normalize( cross( vNormal, vTangent ) * tangent.w );\n\t#endif\n#endif";
var normalmap_pars_fragment = "#ifdef USE_NORMALMAP\n\tuniform sampler2D normalMap;\n\tuniform vec2 normalScale;\n#endif\n#ifdef USE_NORMALMAP_OBJECTSPACE\n\tuniform mat3 normalMatrix;\n#endif\n#if ! defined ( USE_TANGENT ) && ( defined ( USE_NORMALMAP_TANGENTSPACE ) || defined ( USE_CLEARCOAT_NORMALMAP ) || defined( USE_ANISOTROPY ) )\n\tmat3 getTangentFrame( vec3 eye_pos, vec3 surf_norm, vec2 uv ) {\n\t\tvec3 q0 = dFdx( eye_pos.xyz );\n\t\tvec3 q1 = dFdy( eye_pos.xyz );\n\t\tvec2 st0 = dFdx( uv.st );\n\t\tvec2 st1 = dFdy( uv.st );\n\t\tvec3 N = surf_norm;\n\t\tvec3 q1perp = cross( q1, N );\n\t\tvec3 q0perp = cross( N, q0 );\n\t\tvec3 T = q1perp * st0.x + q0perp * st1.x;\n\t\tvec3 B = q1perp * st0.y + q0perp * st1.y;\n\t\tfloat det = max( dot( T, T ), dot( B, B ) );\n\t\tfloat scale = ( det == 0.0 ) ? 0.0 : inversesqrt( det );\n\t\treturn mat3( T * scale, B * scale, N );\n\t}\n#endif";
var clearcoat_normal_fragment_begin = "#ifdef USE_CLEARCOAT\n\tvec3 clearcoatNormal = nonPerturbedNormal;\n#endif";
var clearcoat_normal_fragment_maps = "#ifdef USE_CLEARCOAT_NORMALMAP\n\tvec3 clearcoatMapN = texture2D( clearcoatNormalMap, vClearcoatNormalMapUv ).xyz * 2.0 - 1.0;\n\tclearcoatMapN.xy *= clearcoatNormalScale;\n\tclearcoatNormal = normalize( tbn2 * clearcoatMapN );\n#endif";
var clearcoat_pars_fragment = "#ifdef USE_CLEARCOATMAP\n\tuniform sampler2D clearcoatMap;\n#endif\n#ifdef USE_CLEARCOAT_NORMALMAP\n\tuniform sampler2D clearcoatNormalMap;\n\tuniform vec2 clearcoatNormalScale;\n#endif\n#ifdef USE_CLEARCOAT_ROUGHNESSMAP\n\tuniform sampler2D clearcoatRoughnessMap;\n#endif";
var iridescence_pars_fragment = "#ifdef USE_IRIDESCENCEMAP\n\tuniform sampler2D iridescenceMap;\n#endif\n#ifdef USE_IRIDESCENCE_THICKNESSMAP\n\tuniform sampler2D iridescenceThicknessMap;\n#endif";
var opaque_fragment = "#ifdef OPAQUE\ndiffuseColor.a = 1.0;\n#endif\n#ifdef USE_TRANSMISSION\ndiffuseColor.a *= material.transmissionAlpha;\n#endif\ngl_FragColor = vec4( outgoingLight, diffuseColor.a );";
var packing = "vec3 packNormalToRGB( const in vec3 normal ) {\n\treturn normalize( normal ) * 0.5 + 0.5;\n}\nvec3 unpackRGBToNormal( const in vec3 rgb ) {\n\treturn 2.0 * rgb.xyz - 1.0;\n}\nconst float PackUpscale = 256. / 255.;const float UnpackDownscale = 255. / 256.;const float ShiftRight8 = 1. / 256.;\nconst float Inv255 = 1. / 255.;\nconst vec4 PackFactors = vec4( 1.0, 256.0, 256.0 * 256.0, 256.0 * 256.0 * 256.0 );\nconst vec2 UnpackFactors2 = vec2( UnpackDownscale, 1.0 / PackFactors.g );\nconst vec3 UnpackFactors3 = vec3( UnpackDownscale / PackFactors.rg, 1.0 / PackFactors.b );\nconst vec4 UnpackFactors4 = vec4( UnpackDownscale / PackFactors.rgb, 1.0 / PackFactors.a );\nvec4 packDepthToRGBA( const in float v ) {\n\tif( v <= 0.0 )\n\t\treturn vec4( 0., 0., 0., 0. );\n\tif( v >= 1.0 )\n\t\treturn vec4( 1., 1., 1., 1. );\n\tfloat vuf;\n\tfloat af = modf( v * PackFactors.a, vuf );\n\tfloat bf = modf( vuf * ShiftRight8, vuf );\n\tfloat gf = modf( vuf * ShiftRight8, vuf );\n\treturn vec4( vuf * Inv255, gf * PackUpscale, bf * PackUpscale, af );\n}\nvec3 packDepthToRGB( const in float v ) {\n\tif( v <= 0.0 )\n\t\treturn vec3( 0., 0., 0. );\n\tif( v >= 1.0 )\n\t\treturn vec3( 1., 1., 1. );\n\tfloat vuf;\n\tfloat bf = modf( v * PackFactors.b, vuf );\n\tfloat gf = modf( vuf * ShiftRight8, vuf );\n\treturn vec3( vuf * Inv255, gf * PackUpscale, bf );\n}\nvec2 packDepthToRG( const in float v ) {\n\tif( v <= 0.0 )\n\t\treturn vec2( 0., 0. );\n\tif( v >= 1.0 )\n\t\treturn vec2( 1., 1. );\n\tfloat vuf;\n\tfloat gf = modf( v * 256., vuf );\n\treturn vec2( vuf * Inv255, gf );\n}\nfloat unpackRGBAToDepth( const in vec4 v ) {\n\treturn dot( v, UnpackFactors4 );\n}\nfloat unpackRGBToDepth( const in vec3 v ) {\n\treturn dot( v, UnpackFactors3 );\n}\nfloat unpackRGToDepth( const in vec2 v ) {\n\treturn v.r * UnpackFactors2.r + v.g * UnpackFactors2.g;\n}\nvec4 pack2HalfToRGBA( const in vec2 v ) {\n\tvec4 r = vec4( v.x, fract( v.x * 255.0 ), v.y, fract( v.y * 255.0 ) );\n\treturn vec4( r.x - r.y / 255.0, r.y, r.z - r.w / 255.0, r.w );\n}\nvec2 unpackRGBATo2Half( const in vec4 v ) {\n\treturn vec2( v.x + ( v.y / 255.0 ), v.z + ( v.w / 255.0 ) );\n}\nfloat viewZToOrthographicDepth( const in float viewZ, const in float near, const in float far ) {\n\treturn ( viewZ + near ) / ( near - far );\n}\nfloat orthographicDepthToViewZ( const in float depth, const in float near, const in float far ) {\n\treturn depth * ( near - far ) - near;\n}\nfloat viewZToPerspectiveDepth( const in float viewZ, const in float near, const in float far ) {\n\treturn ( ( near + viewZ ) * far ) / ( ( far - near ) * viewZ );\n}\nfloat perspectiveDepthToViewZ( const in float depth, const in float near, const in float far ) {\n\treturn ( near * far ) / ( ( far - near ) * depth - far );\n}";
var premultiplied_alpha_fragment = "#ifdef PREMULTIPLIED_ALPHA\n\tgl_FragColor.rgb *= gl_FragColor.a;\n#endif";
var project_vertex = "vec4 mvPosition = vec4( transformed, 1.0 );\n#ifdef USE_BATCHING\n\tmvPosition = batchingMatrix * mvPosition;\n#endif\n#ifdef USE_INSTANCING\n\tmvPosition = instanceMatrix * mvPosition;\n#endif\nmvPosition = modelViewMatrix * mvPosition;\ngl_Position = projectionMatrix * mvPosition;";
var dithering_fragment = "#ifdef DITHERING\n\tgl_FragColor.rgb = dithering( gl_FragColor.rgb );\n#endif";
var dithering_pars_fragment = "#ifdef DITHERING\n\tvec3 dithering( vec3 color ) {\n\t\tfloat grid_position = rand( gl_FragCoord.xy );\n\t\tvec3 dither_shift_RGB = vec3( 0.25 / 255.0, -0.25 / 255.0, 0.25 / 255.0 );\n\t\tdither_shift_RGB = mix( 2.0 * dither_shift_RGB, -2.0 * dither_shift_RGB, grid_position );\n\t\treturn color + dither_shift_RGB;\n\t}\n#endif";
var roughnessmap_fragment = "float roughnessFactor = roughness;\n#ifdef USE_ROUGHNESSMAP\n\tvec4 texelRoughness = texture2D( roughnessMap, vRoughnessMapUv );\n\troughnessFactor *= texelRoughness.g;\n#endif";
var roughnessmap_pars_fragment = "#ifdef USE_ROUGHNESSMAP\n\tuniform sampler2D roughnessMap;\n#endif";
var shadowmap_pars_fragment = "#if NUM_SPOT_LIGHT_COORDS > 0\n\tvarying vec4 vSpotLightCoord[ NUM_SPOT_LIGHT_COORDS ];\n#endif\n#if NUM_SPOT_LIGHT_MAPS > 0\n\tuniform sampler2D spotLightMap[ NUM_SPOT_LIGHT_MAPS ];\n#endif\n#ifdef USE_SHADOWMAP\n\t#if NUM_DIR_LIGHT_SHADOWS > 0\n\t\t#if defined( SHADOWMAP_TYPE_PCF )\n\t\t\tuniform sampler2DShadow directionalShadowMap[ NUM_DIR_LIGHT_SHADOWS ];\n\t\t#else\n\t\t\tuniform sampler2D directionalShadowMap[ NUM_DIR_LIGHT_SHADOWS ];\n\t\t#endif\n\t\tvarying vec4 vDirectionalShadowCoord[ NUM_DIR_LIGHT_SHADOWS ];\n\t\tstruct DirectionalLightShadow {\n\t\t\tfloat shadowIntensity;\n\t\t\tfloat shadowBias;\n\t\t\tfloat shadowNormalBias;\n\t\t\tfloat shadowRadius;\n\t\t\tvec2 shadowMapSize;\n\t\t};\n\t\tuniform DirectionalLightShadow directionalLightShadows[ NUM_DIR_LIGHT_SHADOWS ];\n\t#endif\n\t#if NUM_SPOT_LIGHT_SHADOWS > 0\n\t\t#if defined( SHADOWMAP_TYPE_PCF )\n\t\t\tuniform sampler2DShadow spotShadowMap[ NUM_SPOT_LIGHT_SHADOWS ];\n\t\t#else\n\t\t\tuniform sampler2D spotShadowMap[ NUM_SPOT_LIGHT_SHADOWS ];\n\t\t#endif\n\t\tstruct SpotLightShadow {\n\t\t\tfloat shadowIntensity;\n\t\t\tfloat shadowBias;\n\t\t\tfloat shadowNormalBias;\n\t\t\tfloat shadowRadius;\n\t\t\tvec2 shadowMapSize;\n\t\t};\n\t\tuniform SpotLightShadow spotLightShadows[ NUM_SPOT_LIGHT_SHADOWS ];\n\t#endif\n\t#if NUM_POINT_LIGHT_SHADOWS > 0\n\t\t#if defined( SHADOWMAP_TYPE_PCF )\n\t\t\tuniform samplerCubeShadow pointShadowMap[ NUM_POINT_LIGHT_SHADOWS ];\n\t\t#elif defined( SHADOWMAP_TYPE_BASIC )\n\t\t\tuniform samplerCube pointShadowMap[ NUM_POINT_LIGHT_SHADOWS ];\n\t\t#endif\n\t\tvarying vec4 vPointShadowCoord[ NUM_POINT_LIGHT_SHADOWS ];\n\t\tstruct PointLightShadow {\n\t\t\tfloat shadowIntensity;\n\t\t\tfloat shadowBias;\n\t\t\tfloat shadowNormalBias;\n\t\t\tfloat shadowRadius;\n\t\t\tvec2 shadowMapSize;\n\t\t\tfloat shadowCameraNear;\n\t\t\tfloat shadowCameraFar;\n\t\t};\n\t\tuniform PointLightShadow pointLightShadows[ NUM_POINT_LIGHT_SHADOWS ];\n\t#endif\n\t#if defined( SHADOWMAP_TYPE_PCF )\n\t\tfloat interleavedGradientNoise( vec2 position ) {\n\t\t\treturn fract( 52.9829189 * fract( dot( position, vec2( 0.06711056, 0.00583715 ) ) ) );\n\t\t}\n\t\tvec2 vogelDiskSample( int sampleIndex, int samplesCount, float phi ) {\n\t\t\tconst float goldenAngle = 2.399963229728653;\n\t\t\tfloat r = sqrt( ( float( sampleIndex ) + 0.5 ) / float( samplesCount ) );\n\t\t\tfloat theta = float( sampleIndex ) * goldenAngle + phi;\n\t\t\treturn vec2( cos( theta ), sin( theta ) ) * r;\n\t\t}\n\t#endif\n\t#if defined( SHADOWMAP_TYPE_PCF )\n\t\tfloat getShadow( sampler2DShadow shadowMap, vec2 shadowMapSize, float shadowIntensity, float shadowBias, float shadowRadius, vec4 shadowCoord ) {\n\t\t\tfloat shadow = 1.0;\n\t\t\tshadowCoord.xyz /= shadowCoord.w;\n\t\t\tshadowCoord.z += shadowBias;\n\t\t\tbool inFrustum = shadowCoord.x >= 0.0 && shadowCoord.x <= 1.0 && shadowCoord.y >= 0.0 && shadowCoord.y <= 1.0;\n\t\t\tbool frustumTest = inFrustum && shadowCoord.z <= 1.0;\n\t\t\tif ( frustumTest ) {\n\t\t\t\tvec2 texelSize = vec2( 1.0 ) / shadowMapSize;\n\t\t\t\tfloat radius = shadowRadius * texelSize.x;\n\t\t\t\tfloat phi = interleavedGradientNoise( gl_FragCoord.xy ) * 6.28318530718;\n\t\t\t\tshadow = (\n\t\t\t\t\ttexture( shadowMap, vec3( shadowCoord.xy + vogelDiskSample( 0, 5, phi ) * radius, shadowCoord.z ) ) +\n\t\t\t\t\ttexture( shadowMap, vec3( shadowCoord.xy + vogelDiskSample( 1, 5, phi ) * radius, shadowCoord.z ) ) +\n\t\t\t\t\ttexture( shadowMap, vec3( shadowCoord.xy + vogelDiskSample( 2, 5, phi ) * radius, shadowCoord.z ) ) +\n\t\t\t\t\ttexture( shadowMap, vec3( shadowCoord.xy + vogelDiskSample( 3, 5, phi ) * radius, shadowCoord.z ) ) +\n\t\t\t\t\ttexture( shadowMap, vec3( shadowCoord.xy + vogelDiskSample( 4, 5, phi ) * radius, shadowCoord.z ) )\n\t\t\t\t) * 0.2;\n\t\t\t}\n\t\t\treturn mix( 1.0, shadow, shadowIntensity );\n\t\t}\n\t#elif defined( SHADOWMAP_TYPE_VSM )\n\t\tfloat getShadow( sampler2D shadowMap, vec2 shadowMapSize, float shadowIntensity, float shadowBias, float shadowRadius, vec4 shadowCoord ) {\n\t\t\tfloat shadow = 1.0;\n\t\t\tshadowCoord.xyz /= shadowCoord.w;\n\t\t\tshadowCoord.z += shadowBias;\n\t\t\tbool inFrustum = shadowCoord.x >= 0.0 && shadowCoord.x <= 1.0 && shadowCoord.y >= 0.0 && shadowCoord.y <= 1.0;\n\t\t\tbool frustumTest = inFrustum && shadowCoord.z <= 1.0;\n\t\t\tif ( frustumTest ) {\n\t\t\t\tvec2 distribution = texture2D( shadowMap, shadowCoord.xy ).rg;\n\t\t\t\tfloat mean = distribution.x;\n\t\t\t\tfloat variance = distribution.y * distribution.y;\n\t\t\t\t#ifdef USE_REVERSED_DEPTH_BUFFER\n\t\t\t\t\tfloat hard_shadow = step( mean, shadowCoord.z );\n\t\t\t\t#else\n\t\t\t\t\tfloat hard_shadow = step( shadowCoord.z, mean );\n\t\t\t\t#endif\n\t\t\t\tif ( hard_shadow == 1.0 ) {\n\t\t\t\t\tshadow = 1.0;\n\t\t\t\t} else {\n\t\t\t\t\tvariance = max( variance, 0.0000001 );\n\t\t\t\t\tfloat d = shadowCoord.z - mean;\n\t\t\t\t\tfloat p_max = variance / ( variance + d * d );\n\t\t\t\t\tp_max = clamp( ( p_max - 0.3 ) / 0.65, 0.0, 1.0 );\n\t\t\t\t\tshadow = max( hard_shadow, p_max );\n\t\t\t\t}\n\t\t\t}\n\t\t\treturn mix( 1.0, shadow, shadowIntensity );\n\t\t}\n\t#else\n\t\tfloat getShadow( sampler2D shadowMap, vec2 shadowMapSize, float shadowIntensity, float shadowBias, float shadowRadius, vec4 shadowCoord ) {\n\t\t\tfloat shadow = 1.0;\n\t\t\tshadowCoord.xyz /= shadowCoord.w;\n\t\t\tshadowCoord.z += shadowBias;\n\t\t\tbool inFrustum = shadowCoord.x >= 0.0 && shadowCoord.x <= 1.0 && shadowCoord.y >= 0.0 && shadowCoord.y <= 1.0;\n\t\t\tbool frustumTest = inFrustum && shadowCoord.z <= 1.0;\n\t\t\tif ( frustumTest ) {\n\t\t\t\tfloat depth = texture2D( shadowMap, shadowCoord.xy ).r;\n\t\t\t\t#ifdef USE_REVERSED_DEPTH_BUFFER\n\t\t\t\t\tshadow = step( depth, shadowCoord.z );\n\t\t\t\t#else\n\t\t\t\t\tshadow = step( shadowCoord.z, depth );\n\t\t\t\t#endif\n\t\t\t}\n\t\t\treturn mix( 1.0, shadow, shadowIntensity );\n\t\t}\n\t#endif\n\t#if NUM_POINT_LIGHT_SHADOWS > 0\n\t#if defined( SHADOWMAP_TYPE_PCF )\n\tfloat getPointShadow( samplerCubeShadow shadowMap, vec2 shadowMapSize, float shadowIntensity, float shadowBias, float shadowRadius, vec4 shadowCoord, float shadowCameraNear, float shadowCameraFar ) {\n\t\tfloat shadow = 1.0;\n\t\tvec3 lightToPosition = shadowCoord.xyz;\n\t\tvec3 bd3D = normalize( lightToPosition );\n\t\tvec3 absVec = abs( lightToPosition );\n\t\tfloat viewSpaceZ = max( max( absVec.x, absVec.y ), absVec.z );\n\t\tif ( viewSpaceZ - shadowCameraFar <= 0.0 && viewSpaceZ - shadowCameraNear >= 0.0 ) {\n\t\t\tfloat dp = ( shadowCameraFar * ( viewSpaceZ - shadowCameraNear ) ) / ( viewSpaceZ * ( shadowCameraFar - shadowCameraNear ) );\n\t\t\tdp += shadowBias;\n\t\t\tfloat texelSize = shadowRadius / shadowMapSize.x;\n\t\t\tvec3 absDir = abs( bd3D );\n\t\t\tvec3 tangent = absDir.x > absDir.z ? vec3( 0.0, 1.0, 0.0 ) : vec3( 1.0, 0.0, 0.0 );\n\t\t\ttangent = normalize( cross( bd3D, tangent ) );\n\t\t\tvec3 bitangent = cross( bd3D, tangent );\n\t\t\tfloat phi = interleavedGradientNoise( gl_FragCoord.xy ) * 6.28318530718;\n\t\t\tshadow = (\n\t\t\t\ttexture( shadowMap, vec4( bd3D + ( tangent * vogelDiskSample( 0, 5, phi ).x + bitangent * vogelDiskSample( 0, 5, phi ).y ) * texelSize, dp ) ) +\n\t\t\t\ttexture( shadowMap, vec4( bd3D + ( tangent * vogelDiskSample( 1, 5, phi ).x + bitangent * vogelDiskSample( 1, 5, phi ).y ) * texelSize, dp ) ) +\n\t\t\t\ttexture( shadowMap, vec4( bd3D + ( tangent * vogelDiskSample( 2, 5, phi ).x + bitangent * vogelDiskSample( 2, 5, phi ).y ) * texelSize, dp ) ) +\n\t\t\t\ttexture( shadowMap, vec4( bd3D + ( tangent * vogelDiskSample( 3, 5, phi ).x + bitangent * vogelDiskSample( 3, 5, phi ).y ) * texelSize, dp ) ) +\n\t\t\t\ttexture( shadowMap, vec4( bd3D + ( tangent * vogelDiskSample( 4, 5, phi ).x + bitangent * vogelDiskSample( 4, 5, phi ).y ) * texelSize, dp ) )\n\t\t\t) * 0.2;\n\t\t}\n\t\treturn mix( 1.0, shadow, shadowIntensity );\n\t}\n\t#elif defined( SHADOWMAP_TYPE_BASIC )\n\tfloat getPointShadow( samplerCube shadowMap, vec2 shadowMapSize, float shadowIntensity, float shadowBias, float shadowRadius, vec4 shadowCoord, float shadowCameraNear, float shadowCameraFar ) {\n\t\tfloat shadow = 1.0;\n\t\tvec3 lightToPosition = shadowCoord.xyz;\n\t\tvec3 bd3D = normalize( lightToPosition );\n\t\tvec3 absVec = abs( lightToPosition );\n\t\tfloat viewSpaceZ = max( max( absVec.x, absVec.y ), absVec.z );\n\t\tif ( viewSpaceZ - shadowCameraFar <= 0.0 && viewSpaceZ - shadowCameraNear >= 0.0 ) {\n\t\t\tfloat dp = ( shadowCameraFar * ( viewSpaceZ - shadowCameraNear ) ) / ( viewSpaceZ * ( shadowCameraFar - shadowCameraNear ) );\n\t\t\tdp += shadowBias;\n\t\t\tfloat depth = textureCube( shadowMap, bd3D ).r;\n\t\t\t#ifdef USE_REVERSED_DEPTH_BUFFER\n\t\t\t\tshadow = step( depth, dp );\n\t\t\t#else\n\t\t\t\tshadow = step( dp, depth );\n\t\t\t#endif\n\t\t}\n\t\treturn mix( 1.0, shadow, shadowIntensity );\n\t}\n\t#endif\n\t#endif\n#endif";
var shadowmap_pars_vertex = "#if NUM_SPOT_LIGHT_COORDS > 0\n\tuniform mat4 spotLightMatrix[ NUM_SPOT_LIGHT_COORDS ];\n\tvarying vec4 vSpotLightCoord[ NUM_SPOT_LIGHT_COORDS ];\n#endif\n#ifdef USE_SHADOWMAP\n\t#if NUM_DIR_LIGHT_SHADOWS > 0\n\t\tuniform mat4 directionalShadowMatrix[ NUM_DIR_LIGHT_SHADOWS ];\n\t\tvarying vec4 vDirectionalShadowCoord[ NUM_DIR_LIGHT_SHADOWS ];\n\t\tstruct DirectionalLightShadow {\n\t\t\tfloat shadowIntensity;\n\t\t\tfloat shadowBias;\n\t\t\tfloat shadowNormalBias;\n\t\t\tfloat shadowRadius;\n\t\t\tvec2 shadowMapSize;\n\t\t};\n\t\tuniform DirectionalLightShadow directionalLightShadows[ NUM_DIR_LIGHT_SHADOWS ];\n\t#endif\n\t#if NUM_SPOT_LIGHT_SHADOWS > 0\n\t\tstruct SpotLightShadow {\n\t\t\tfloat shadowIntensity;\n\t\t\tfloat shadowBias;\n\t\t\tfloat shadowNormalBias;\n\t\t\tfloat shadowRadius;\n\t\t\tvec2 shadowMapSize;\n\t\t};\n\t\tuniform SpotLightShadow spotLightShadows[ NUM_SPOT_LIGHT_SHADOWS ];\n\t#endif\n\t#if NUM_POINT_LIGHT_SHADOWS > 0\n\t\tuniform mat4 pointShadowMatrix[ NUM_POINT_LIGHT_SHADOWS ];\n\t\tvarying vec4 vPointShadowCoord[ NUM_POINT_LIGHT_SHADOWS ];\n\t\tstruct PointLightShadow {\n\t\t\tfloat shadowIntensity;\n\t\t\tfloat shadowBias;\n\t\t\tfloat shadowNormalBias;\n\t\t\tfloat shadowRadius;\n\t\t\tvec2 shadowMapSize;\n\t\t\tfloat shadowCameraNear;\n\t\t\tfloat shadowCameraFar;\n\t\t};\n\t\tuniform PointLightShadow pointLightShadows[ NUM_POINT_LIGHT_SHADOWS ];\n\t#endif\n#endif";
var shadowmap_vertex = "#if ( defined( USE_SHADOWMAP ) && ( NUM_DIR_LIGHT_SHADOWS > 0 || NUM_POINT_LIGHT_SHADOWS > 0 ) ) || ( NUM_SPOT_LIGHT_COORDS > 0 )\n\tvec3 shadowWorldNormal = inverseTransformDirection( transformedNormal, viewMatrix );\n\tvec4 shadowWorldPosition;\n#endif\n#if defined( USE_SHADOWMAP )\n\t#if NUM_DIR_LIGHT_SHADOWS > 0\n\t\t#pragma unroll_loop_start\n\t\tfor ( int i = 0; i < NUM_DIR_LIGHT_SHADOWS; i ++ ) {\n\t\t\tshadowWorldPosition = worldPosition + vec4( shadowWorldNormal * directionalLightShadows[ i ].shadowNormalBias, 0 );\n\t\t\tvDirectionalShadowCoord[ i ] = directionalShadowMatrix[ i ] * shadowWorldPosition;\n\t\t}\n\t\t#pragma unroll_loop_end\n\t#endif\n\t#if NUM_POINT_LIGHT_SHADOWS > 0\n\t\t#pragma unroll_loop_start\n\t\tfor ( int i = 0; i < NUM_POINT_LIGHT_SHADOWS; i ++ ) {\n\t\t\tshadowWorldPosition = worldPosition + vec4( shadowWorldNormal * pointLightShadows[ i ].shadowNormalBias, 0 );\n\t\t\tvPointShadowCoord[ i ] = pointShadowMatrix[ i ] * shadowWorldPosition;\n\t\t}\n\t\t#pragma unroll_loop_end\n\t#endif\n#endif\n#if NUM_SPOT_LIGHT_COORDS > 0\n\t#pragma unroll_loop_start\n\tfor ( int i = 0; i < NUM_SPOT_LIGHT_COORDS; i ++ ) {\n\t\tshadowWorldPosition = worldPosition;\n\t\t#if ( defined( USE_SHADOWMAP ) && UNROLLED_LOOP_INDEX < NUM_SPOT_LIGHT_SHADOWS )\n\t\t\tshadowWorldPosition.xyz += shadowWorldNormal * spotLightShadows[ i ].shadowNormalBias;\n\t\t#endif\n\t\tvSpotLightCoord[ i ] = spotLightMatrix[ i ] * shadowWorldPosition;\n\t}\n\t#pragma unroll_loop_end\n#endif";
var shadowmask_pars_fragment = "float getShadowMask() {\n\tfloat shadow = 1.0;\n\t#ifdef USE_SHADOWMAP\n\t#if NUM_DIR_LIGHT_SHADOWS > 0\n\tDirectionalLightShadow directionalLight;\n\t#pragma unroll_loop_start\n\tfor ( int i = 0; i < NUM_DIR_LIGHT_SHADOWS; i ++ ) {\n\t\tdirectionalLight = directionalLightShadows[ i ];\n\t\tshadow *= receiveShadow ? getShadow( directionalShadowMap[ i ], directionalLight.shadowMapSize, directionalLight.shadowIntensity, directionalLight.shadowBias, directionalLight.shadowRadius, vDirectionalShadowCoord[ i ] ) : 1.0;\n\t}\n\t#pragma unroll_loop_end\n\t#endif\n\t#if NUM_SPOT_LIGHT_SHADOWS > 0\n\tSpotLightShadow spotLight;\n\t#pragma unroll_loop_start\n\tfor ( int i = 0; i < NUM_SPOT_LIGHT_SHADOWS; i ++ ) {\n\t\tspotLight = spotLightShadows[ i ];\n\t\tshadow *= receiveShadow ? getShadow( spotShadowMap[ i ], spotLight.shadowMapSize, spotLight.shadowIntensity, spotLight.shadowBias, spotLight.shadowRadius, vSpotLightCoord[ i ] ) : 1.0;\n\t}\n\t#pragma unroll_loop_end\n\t#endif\n\t#if NUM_POINT_LIGHT_SHADOWS > 0 && ( defined( SHADOWMAP_TYPE_PCF ) || defined( SHADOWMAP_TYPE_BASIC ) )\n\tPointLightShadow pointLight;\n\t#pragma unroll_loop_start\n\tfor ( int i = 0; i < NUM_POINT_LIGHT_SHADOWS; i ++ ) {\n\t\tpointLight = pointLightShadows[ i ];\n\t\tshadow *= receiveShadow ? getPointShadow( pointShadowMap[ i ], pointLight.shadowMapSize, pointLight.shadowIntensity, pointLight.shadowBias, pointLight.shadowRadius, vPointShadowCoord[ i ], pointLight.shadowCameraNear, pointLight.shadowCameraFar ) : 1.0;\n\t}\n\t#pragma unroll_loop_end\n\t#endif\n\t#endif\n\treturn shadow;\n}";
var skinbase_vertex = "#ifdef USE_SKINNING\n\tmat4 boneMatX = getBoneMatrix( skinIndex.x );\n\tmat4 boneMatY = getBoneMatrix( skinIndex.y );\n\tmat4 boneMatZ = getBoneMatrix( skinIndex.z );\n\tmat4 boneMatW = getBoneMatrix( skinIndex.w );\n#endif";
var skinning_pars_vertex = "#ifdef USE_SKINNING\n\tuniform mat4 bindMatrix;\n\tuniform mat4 bindMatrixInverse;\n\tuniform highp sampler2D boneTexture;\n\tmat4 getBoneMatrix( const in float i ) {\n\t\tint size = textureSize( boneTexture, 0 ).x;\n\t\tint j = int( i ) * 4;\n\t\tint x = j % size;\n\t\tint y = j / size;\n\t\tvec4 v1 = texelFetch( boneTexture, ivec2( x, y ), 0 );\n\t\tvec4 v2 = texelFetch( boneTexture, ivec2( x + 1, y ), 0 );\n\t\tvec4 v3 = texelFetch( boneTexture, ivec2( x + 2, y ), 0 );\n\t\tvec4 v4 = texelFetch( boneTexture, ivec2( x + 3, y ), 0 );\n\t\treturn mat4( v1, v2, v3, v4 );\n\t}\n#endif";
var skinning_vertex = "#ifdef USE_SKINNING\n\tvec4 skinVertex = bindMatrix * vec4( transformed, 1.0 );\n\tvec4 skinned = vec4( 0.0 );\n\tskinned += boneMatX * skinVertex * skinWeight.x;\n\tskinned += boneMatY * skinVertex * skinWeight.y;\n\tskinned += boneMatZ * skinVertex * skinWeight.z;\n\tskinned += boneMatW * skinVertex * skinWeight.w;\n\ttransformed = ( bindMatrixInverse * skinned ).xyz;\n#endif";
var skinnormal_vertex = "#ifdef USE_SKINNING\n\tmat4 skinMatrix = mat4( 0.0 );\n\tskinMatrix += skinWeight.x * boneMatX;\n\tskinMatrix += skinWeight.y * boneMatY;\n\tskinMatrix += skinWeight.z * boneMatZ;\n\tskinMatrix += skinWeight.w * boneMatW;\n\tskinMatrix = bindMatrixInverse * skinMatrix * bindMatrix;\n\tobjectNormal = vec4( skinMatrix * vec4( objectNormal, 0.0 ) ).xyz;\n\t#ifdef USE_TANGENT\n\t\tobjectTangent = vec4( skinMatrix * vec4( objectTangent, 0.0 ) ).xyz;\n\t#endif\n#endif";
var specularmap_fragment = "float specularStrength;\n#ifdef USE_SPECULARMAP\n\tvec4 texelSpecular = texture2D( specularMap, vSpecularMapUv );\n\tspecularStrength = texelSpecular.r;\n#else\n\tspecularStrength = 1.0;\n#endif";
var specularmap_pars_fragment = "#ifdef USE_SPECULARMAP\n\tuniform sampler2D specularMap;\n#endif";
var tonemapping_fragment = "#if defined( TONE_MAPPING )\n\tgl_FragColor.rgb = toneMapping( gl_FragColor.rgb );\n#endif";
var tonemapping_pars_fragment = "#ifndef saturate\n#define saturate( a ) clamp( a, 0.0, 1.0 )\n#endif\nuniform float toneMappingExposure;\nvec3 LinearToneMapping( vec3 color ) {\n\treturn saturate( toneMappingExposure * color );\n}\nvec3 ReinhardToneMapping( vec3 color ) {\n\tcolor *= toneMappingExposure;\n\treturn saturate( color / ( vec3( 1.0 ) + color ) );\n}\nvec3 CineonToneMapping( vec3 color ) {\n\tcolor *= toneMappingExposure;\n\tcolor = max( vec3( 0.0 ), color - 0.004 );\n\treturn pow( ( color * ( 6.2 * color + 0.5 ) ) / ( color * ( 6.2 * color + 1.7 ) + 0.06 ), vec3( 2.2 ) );\n}\nvec3 RRTAndODTFit( vec3 v ) {\n\tvec3 a = v * ( v + 0.0245786 ) - 0.000090537;\n\tvec3 b = v * ( 0.983729 * v + 0.4329510 ) + 0.238081;\n\treturn a / b;\n}\nvec3 ACESFilmicToneMapping( vec3 color ) {\n\tconst mat3 ACESInputMat = mat3(\n\t\tvec3( 0.59719, 0.07600, 0.02840 ),\t\tvec3( 0.35458, 0.90834, 0.13383 ),\n\t\tvec3( 0.04823, 0.01566, 0.83777 )\n\t);\n\tconst mat3 ACESOutputMat = mat3(\n\t\tvec3(  1.60475, -0.10208, -0.00327 ),\t\tvec3( -0.53108,  1.10813, -0.07276 ),\n\t\tvec3( -0.07367, -0.00605,  1.07602 )\n\t);\n\tcolor *= toneMappingExposure / 0.6;\n\tcolor = ACESInputMat * color;\n\tcolor = RRTAndODTFit( color );\n\tcolor = ACESOutputMat * color;\n\treturn saturate( color );\n}\nconst mat3 LINEAR_REC2020_TO_LINEAR_SRGB = mat3(\n\tvec3( 1.6605, - 0.1246, - 0.0182 ),\n\tvec3( - 0.5876, 1.1329, - 0.1006 ),\n\tvec3( - 0.0728, - 0.0083, 1.1187 )\n);\nconst mat3 LINEAR_SRGB_TO_LINEAR_REC2020 = mat3(\n\tvec3( 0.6274, 0.0691, 0.0164 ),\n\tvec3( 0.3293, 0.9195, 0.0880 ),\n\tvec3( 0.0433, 0.0113, 0.8956 )\n);\nvec3 agxDefaultContrastApprox( vec3 x ) {\n\tvec3 x2 = x * x;\n\tvec3 x4 = x2 * x2;\n\treturn + 15.5 * x4 * x2\n\t\t- 40.14 * x4 * x\n\t\t+ 31.96 * x4\n\t\t- 6.868 * x2 * x\n\t\t+ 0.4298 * x2\n\t\t+ 0.1191 * x\n\t\t- 0.00232;\n}\nvec3 AgXToneMapping( vec3 color ) {\n\tconst mat3 AgXInsetMatrix = mat3(\n\t\tvec3( 0.856627153315983, 0.137318972929847, 0.11189821299995 ),\n\t\tvec3( 0.0951212405381588, 0.761241990602591, 0.0767994186031903 ),\n\t\tvec3( 0.0482516061458583, 0.101439036467562, 0.811302368396859 )\n\t);\n\tconst mat3 AgXOutsetMatrix = mat3(\n\t\tvec3( 1.1271005818144368, - 0.1413297634984383, - 0.14132976349843826 ),\n\t\tvec3( - 0.11060664309660323, 1.157823702216272, - 0.11060664309660294 ),\n\t\tvec3( - 0.016493938717834573, - 0.016493938717834257, 1.2519364065950405 )\n\t);\n\tconst float AgxMinEv = - 12.47393;\tconst float AgxMaxEv = 4.026069;\n\tcolor *= toneMappingExposure;\n\tcolor = LINEAR_SRGB_TO_LINEAR_REC2020 * color;\n\tcolor = AgXInsetMatrix * color;\n\tcolor = max( color, 1e-10 );\tcolor = log2( color );\n\tcolor = ( color - AgxMinEv ) / ( AgxMaxEv - AgxMinEv );\n\tcolor = clamp( color, 0.0, 1.0 );\n\tcolor = agxDefaultContrastApprox( color );\n\tcolor = AgXOutsetMatrix * color;\n\tcolor = pow( max( vec3( 0.0 ), color ), vec3( 2.2 ) );\n\tcolor = LINEAR_REC2020_TO_LINEAR_SRGB * color;\n\tcolor = clamp( color, 0.0, 1.0 );\n\treturn color;\n}\nvec3 NeutralToneMapping( vec3 color ) {\n\tconst float StartCompression = 0.8 - 0.04;\n\tconst float Desaturation = 0.15;\n\tcolor *= toneMappingExposure;\n\tfloat x = min( color.r, min( color.g, color.b ) );\n\tfloat offset = x < 0.08 ? x - 6.25 * x * x : 0.04;\n\tcolor -= offset;\n\tfloat peak = max( color.r, max( color.g, color.b ) );\n\tif ( peak < StartCompression ) return color;\n\tfloat d = 1. - StartCompression;\n\tfloat newPeak = 1. - d * d / ( peak + d - StartCompression );\n\tcolor *= newPeak / peak;\n\tfloat g = 1. - 1. / ( Desaturation * ( peak - newPeak ) + 1. );\n\treturn mix( color, vec3( newPeak ), g );\n}\nvec3 CustomToneMapping( vec3 color ) { return color; }";
var transmission_fragment = "#ifdef USE_TRANSMISSION\n\tmaterial.transmission = transmission;\n\tmaterial.transmissionAlpha = 1.0;\n\tmaterial.thickness = thickness;\n\tmaterial.attenuationDistance = attenuationDistance;\n\tmaterial.attenuationColor = attenuationColor;\n\t#ifdef USE_TRANSMISSIONMAP\n\t\tmaterial.transmission *= texture2D( transmissionMap, vTransmissionMapUv ).r;\n\t#endif\n\t#ifdef USE_THICKNESSMAP\n\t\tmaterial.thickness *= texture2D( thicknessMap, vThicknessMapUv ).g;\n\t#endif\n\tvec3 pos = vWorldPosition;\n\tvec3 v = normalize( cameraPosition - pos );\n\tvec3 n = inverseTransformDirection( normal, viewMatrix );\n\tvec4 transmitted = getIBLVolumeRefraction(\n\t\tn, v, material.roughness, material.diffuseContribution, material.specularColorBlended, material.specularF90,\n\t\tpos, modelMatrix, viewMatrix, projectionMatrix, material.dispersion, material.ior, material.thickness,\n\t\tmaterial.attenuationColor, material.attenuationDistance );\n\tmaterial.transmissionAlpha = mix( material.transmissionAlpha, transmitted.a, material.transmission );\n\ttotalDiffuse = mix( totalDiffuse, transmitted.rgb, material.transmission );\n#endif";
var transmission_pars_fragment = "#ifdef USE_TRANSMISSION\n\tuniform float transmission;\n\tuniform float thickness;\n\tuniform float attenuationDistance;\n\tuniform vec3 attenuationColor;\n\t#ifdef USE_TRANSMISSIONMAP\n\t\tuniform sampler2D transmissionMap;\n\t#endif\n\t#ifdef USE_THICKNESSMAP\n\t\tuniform sampler2D thicknessMap;\n\t#endif\n\tuniform vec2 transmissionSamplerSize;\n\tuniform sampler2D transmissionSamplerMap;\n\tuniform mat4 modelMatrix;\n\tuniform mat4 projectionMatrix;\n\tvarying vec3 vWorldPosition;\n\tfloat w0( float a ) {\n\t\treturn ( 1.0 / 6.0 ) * ( a * ( a * ( - a + 3.0 ) - 3.0 ) + 1.0 );\n\t}\n\tfloat w1( float a ) {\n\t\treturn ( 1.0 / 6.0 ) * ( a *  a * ( 3.0 * a - 6.0 ) + 4.0 );\n\t}\n\tfloat w2( float a ){\n\t\treturn ( 1.0 / 6.0 ) * ( a * ( a * ( - 3.0 * a + 3.0 ) + 3.0 ) + 1.0 );\n\t}\n\tfloat w3( float a ) {\n\t\treturn ( 1.0 / 6.0 ) * ( a * a * a );\n\t}\n\tfloat g0( float a ) {\n\t\treturn w0( a ) + w1( a );\n\t}\n\tfloat g1( float a ) {\n\t\treturn w2( a ) + w3( a );\n\t}\n\tfloat h0( float a ) {\n\t\treturn - 1.0 + w1( a ) / ( w0( a ) + w1( a ) );\n\t}\n\tfloat h1( float a ) {\n\t\treturn 1.0 + w3( a ) / ( w2( a ) + w3( a ) );\n\t}\n\tvec4 bicubic( sampler2D tex, vec2 uv, vec4 texelSize, float lod ) {\n\t\tuv = uv * texelSize.zw + 0.5;\n\t\tvec2 iuv = floor( uv );\n\t\tvec2 fuv = fract( uv );\n\t\tfloat g0x = g0( fuv.x );\n\t\tfloat g1x = g1( fuv.x );\n\t\tfloat h0x = h0( fuv.x );\n\t\tfloat h1x = h1( fuv.x );\n\t\tfloat h0y = h0( fuv.y );\n\t\tfloat h1y = h1( fuv.y );\n\t\tvec2 p0 = ( vec2( iuv.x + h0x, iuv.y + h0y ) - 0.5 ) * texelSize.xy;\n\t\tvec2 p1 = ( vec2( iuv.x + h1x, iuv.y + h0y ) - 0.5 ) * texelSize.xy;\n\t\tvec2 p2 = ( vec2( iuv.x + h0x, iuv.y + h1y ) - 0.5 ) * texelSize.xy;\n\t\tvec2 p3 = ( vec2( iuv.x + h1x, iuv.y + h1y ) - 0.5 ) * texelSize.xy;\n\t\treturn g0( fuv.y ) * ( g0x * textureLod( tex, p0, lod ) + g1x * textureLod( tex, p1, lod ) ) +\n\t\t\tg1( fuv.y ) * ( g0x * textureLod( tex, p2, lod ) + g1x * textureLod( tex, p3, lod ) );\n\t}\n\tvec4 textureBicubic( sampler2D sampler, vec2 uv, float lod ) {\n\t\tvec2 fLodSize = vec2( textureSize( sampler, int( lod ) ) );\n\t\tvec2 cLodSize = vec2( textureSize( sampler, int( lod + 1.0 ) ) );\n\t\tvec2 fLodSizeInv = 1.0 / fLodSize;\n\t\tvec2 cLodSizeInv = 1.0 / cLodSize;\n\t\tvec4 fSample = bicubic( sampler, uv, vec4( fLodSizeInv, fLodSize ), floor( lod ) );\n\t\tvec4 cSample = bicubic( sampler, uv, vec4( cLodSizeInv, cLodSize ), ceil( lod ) );\n\t\treturn mix( fSample, cSample, fract( lod ) );\n\t}\n\tvec3 getVolumeTransmissionRay( const in vec3 n, const in vec3 v, const in float thickness, const in float ior, const in mat4 modelMatrix ) {\n\t\tvec3 refractionVector = refract( - v, normalize( n ), 1.0 / ior );\n\t\tvec3 modelScale;\n\t\tmodelScale.x = length( vec3( modelMatrix[ 0 ].xyz ) );\n\t\tmodelScale.y = length( vec3( modelMatrix[ 1 ].xyz ) );\n\t\tmodelScale.z = length( vec3( modelMatrix[ 2 ].xyz ) );\n\t\treturn normalize( refractionVector ) * thickness * modelScale;\n\t}\n\tfloat applyIorToRoughness( const in float roughness, const in float ior ) {\n\t\treturn roughness * clamp( ior * 2.0 - 2.0, 0.0, 1.0 );\n\t}\n\tvec4 getTransmissionSample( const in vec2 fragCoord, const in float roughness, const in float ior ) {\n\t\tfloat lod = log2( transmissionSamplerSize.x ) * applyIorToRoughness( roughness, ior );\n\t\treturn textureBicubic( transmissionSamplerMap, fragCoord.xy, lod );\n\t}\n\tvec3 volumeAttenuation( const in float transmissionDistance, const in vec3 attenuationColor, const in float attenuationDistance ) {\n\t\tif ( isinf( attenuationDistance ) ) {\n\t\t\treturn vec3( 1.0 );\n\t\t} else {\n\t\t\tvec3 attenuationCoefficient = -log( attenuationColor ) / attenuationDistance;\n\t\t\tvec3 transmittance = exp( - attenuationCoefficient * transmissionDistance );\t\t\treturn transmittance;\n\t\t}\n\t}\n\tvec4 getIBLVolumeRefraction( const in vec3 n, const in vec3 v, const in float roughness, const in vec3 diffuseColor,\n\t\tconst in vec3 specularColor, const in float specularF90, const in vec3 position, const in mat4 modelMatrix,\n\t\tconst in mat4 viewMatrix, const in mat4 projMatrix, const in float dispersion, const in float ior, const in float thickness,\n\t\tconst in vec3 attenuationColor, const in float attenuationDistance ) {\n\t\tvec4 transmittedLight;\n\t\tvec3 transmittance;\n\t\t#ifdef USE_DISPERSION\n\t\t\tfloat halfSpread = ( ior - 1.0 ) * 0.025 * dispersion;\n\t\t\tvec3 iors = vec3( ior - halfSpread, ior, ior + halfSpread );\n\t\t\tfor ( int i = 0; i < 3; i ++ ) {\n\t\t\t\tvec3 transmissionRay = getVolumeTransmissionRay( n, v, thickness, iors[ i ], modelMatrix );\n\t\t\t\tvec3 refractedRayExit = position + transmissionRay;\n\t\t\t\tvec4 ndcPos = projMatrix * viewMatrix * vec4( refractedRayExit, 1.0 );\n\t\t\t\tvec2 refractionCoords = ndcPos.xy / ndcPos.w;\n\t\t\t\trefractionCoords += 1.0;\n\t\t\t\trefractionCoords /= 2.0;\n\t\t\t\tvec4 transmissionSample = getTransmissionSample( refractionCoords, roughness, iors[ i ] );\n\t\t\t\ttransmittedLight[ i ] = transmissionSample[ i ];\n\t\t\t\ttransmittedLight.a += transmissionSample.a;\n\t\t\t\ttransmittance[ i ] = diffuseColor[ i ] * volumeAttenuation( length( transmissionRay ), attenuationColor, attenuationDistance )[ i ];\n\t\t\t}\n\t\t\ttransmittedLight.a /= 3.0;\n\t\t#else\n\t\t\tvec3 transmissionRay = getVolumeTransmissionRay( n, v, thickness, ior, modelMatrix );\n\t\t\tvec3 refractedRayExit = position + transmissionRay;\n\t\t\tvec4 ndcPos = projMatrix * viewMatrix * vec4( refractedRayExit, 1.0 );\n\t\t\tvec2 refractionCoords = ndcPos.xy / ndcPos.w;\n\t\t\trefractionCoords += 1.0;\n\t\t\trefractionCoords /= 2.0;\n\t\t\ttransmittedLight = getTransmissionSample( refractionCoords, roughness, ior );\n\t\t\ttransmittance = diffuseColor * volumeAttenuation( length( transmissionRay ), attenuationColor, attenuationDistance );\n\t\t#endif\n\t\tvec3 attenuatedColor = transmittance * transmittedLight.rgb;\n\t\tvec3 F = EnvironmentBRDF( n, v, specularColor, specularF90, roughness );\n\t\tfloat transmittanceFactor = ( transmittance.r + transmittance.g + transmittance.b ) / 3.0;\n\t\treturn vec4( ( 1.0 - F ) * attenuatedColor, 1.0 - ( 1.0 - transmittedLight.a ) * transmittanceFactor );\n\t}\n#endif";
var uv_pars_fragment = "#if defined( USE_UV ) || defined( USE_ANISOTROPY )\n\tvarying vec2 vUv;\n#endif\n#ifdef USE_MAP\n\tvarying vec2 vMapUv;\n#endif\n#ifdef USE_ALPHAMAP\n\tvarying vec2 vAlphaMapUv;\n#endif\n#ifdef USE_LIGHTMAP\n\tvarying vec2 vLightMapUv;\n#endif\n#ifdef USE_AOMAP\n\tvarying vec2 vAoMapUv;\n#endif\n#ifdef USE_BUMPMAP\n\tvarying vec2 vBumpMapUv;\n#endif\n#ifdef USE_NORMALMAP\n\tvarying vec2 vNormalMapUv;\n#endif\n#ifdef USE_EMISSIVEMAP\n\tvarying vec2 vEmissiveMapUv;\n#endif\n#ifdef USE_METALNESSMAP\n\tvarying vec2 vMetalnessMapUv;\n#endif\n#ifdef USE_ROUGHNESSMAP\n\tvarying vec2 vRoughnessMapUv;\n#endif\n#ifdef USE_ANISOTROPYMAP\n\tvarying vec2 vAnisotropyMapUv;\n#endif\n#ifdef USE_CLEARCOATMAP\n\tvarying vec2 vClearcoatMapUv;\n#endif\n#ifdef USE_CLEARCOAT_NORMALMAP\n\tvarying vec2 vClearcoatNormalMapUv;\n#endif\n#ifdef USE_CLEARCOAT_ROUGHNESSMAP\n\tvarying vec2 vClearcoatRoughnessMapUv;\n#endif\n#ifdef USE_IRIDESCENCEMAP\n\tvarying vec2 vIridescenceMapUv;\n#endif\n#ifdef USE_IRIDESCENCE_THICKNESSMAP\n\tvarying vec2 vIridescenceThicknessMapUv;\n#endif\n#ifdef USE_SHEEN_COLORMAP\n\tvarying vec2 vSheenColorMapUv;\n#endif\n#ifdef USE_SHEEN_ROUGHNESSMAP\n\tvarying vec2 vSheenRoughnessMapUv;\n#endif\n#ifdef USE_SPECULARMAP\n\tvarying vec2 vSpecularMapUv;\n#endif\n#ifdef USE_SPECULAR_COLORMAP\n\tvarying vec2 vSpecularColorMapUv;\n#endif\n#ifdef USE_SPECULAR_INTENSITYMAP\n\tvarying vec2 vSpecularIntensityMapUv;\n#endif\n#ifdef USE_TRANSMISSIONMAP\n\tuniform mat3 transmissionMapTransform;\n\tvarying vec2 vTransmissionMapUv;\n#endif\n#ifdef USE_THICKNESSMAP\n\tuniform mat3 thicknessMapTransform;\n\tvarying vec2 vThicknessMapUv;\n#endif";
var uv_pars_vertex = "#if defined( USE_UV ) || defined( USE_ANISOTROPY )\n\tvarying vec2 vUv;\n#endif\n#ifdef USE_MAP\n\tuniform mat3 mapTransform;\n\tvarying vec2 vMapUv;\n#endif\n#ifdef USE_ALPHAMAP\n\tuniform mat3 alphaMapTransform;\n\tvarying vec2 vAlphaMapUv;\n#endif\n#ifdef USE_LIGHTMAP\n\tuniform mat3 lightMapTransform;\n\tvarying vec2 vLightMapUv;\n#endif\n#ifdef USE_AOMAP\n\tuniform mat3 aoMapTransform;\n\tvarying vec2 vAoMapUv;\n#endif\n#ifdef USE_BUMPMAP\n\tuniform mat3 bumpMapTransform;\n\tvarying vec2 vBumpMapUv;\n#endif\n#ifdef USE_NORMALMAP\n\tuniform mat3 normalMapTransform;\n\tvarying vec2 vNormalMapUv;\n#endif\n#ifdef USE_DISPLACEMENTMAP\n\tuniform mat3 displacementMapTransform;\n\tvarying vec2 vDisplacementMapUv;\n#endif\n#ifdef USE_EMISSIVEMAP\n\tuniform mat3 emissiveMapTransform;\n\tvarying vec2 vEmissiveMapUv;\n#endif\n#ifdef USE_METALNESSMAP\n\tuniform mat3 metalnessMapTransform;\n\tvarying vec2 vMetalnessMapUv;\n#endif\n#ifdef USE_ROUGHNESSMAP\n\tuniform mat3 roughnessMapTransform;\n\tvarying vec2 vRoughnessMapUv;\n#endif\n#ifdef USE_ANISOTROPYMAP\n\tuniform mat3 anisotropyMapTransform;\n\tvarying vec2 vAnisotropyMapUv;\n#endif\n#ifdef USE_CLEARCOATMAP\n\tuniform mat3 clearcoatMapTransform;\n\tvarying vec2 vClearcoatMapUv;\n#endif\n#ifdef USE_CLEARCOAT_NORMALMAP\n\tuniform mat3 clearcoatNormalMapTransform;\n\tvarying vec2 vClearcoatNormalMapUv;\n#endif\n#ifdef USE_CLEARCOAT_ROUGHNESSMAP\n\tuniform mat3 clearcoatRoughnessMapTransform;\n\tvarying vec2 vClearcoatRoughnessMapUv;\n#endif\n#ifdef USE_SHEEN_COLORMAP\n\tuniform mat3 sheenColorMapTransform;\n\tvarying vec2 vSheenColorMapUv;\n#endif\n#ifdef USE_SHEEN_ROUGHNESSMAP\n\tuniform mat3 sheenRoughnessMapTransform;\n\tvarying vec2 vSheenRoughnessMapUv;\n#endif\n#ifdef USE_IRIDESCENCEMAP\n\tuniform mat3 iridescenceMapTransform;\n\tvarying vec2 vIridescenceMapUv;\n#endif\n#ifdef USE_IRIDESCENCE_THICKNESSMAP\n\tuniform mat3 iridescenceThicknessMapTransform;\n\tvarying vec2 vIridescenceThicknessMapUv;\n#endif\n#ifdef USE_SPECULARMAP\n\tuniform mat3 specularMapTransform;\n\tvarying vec2 vSpecularMapUv;\n#endif\n#ifdef USE_SPECULAR_COLORMAP\n\tuniform mat3 specularColorMapTransform;\n\tvarying vec2 vSpecularColorMapUv;\n#endif\n#ifdef USE_SPECULAR_INTENSITYMAP\n\tuniform mat3 specularIntensityMapTransform;\n\tvarying vec2 vSpecularIntensityMapUv;\n#endif\n#ifdef USE_TRANSMISSIONMAP\n\tuniform mat3 transmissionMapTransform;\n\tvarying vec2 vTransmissionMapUv;\n#endif\n#ifdef USE_THICKNESSMAP\n\tuniform mat3 thicknessMapTransform;\n\tvarying vec2 vThicknessMapUv;\n#endif";
var uv_vertex = "#if defined( USE_UV ) || defined( USE_ANISOTROPY )\n\tvUv = vec3( uv, 1 ).xy;\n#endif\n#ifdef USE_MAP\n\tvMapUv = ( mapTransform * vec3( MAP_UV, 1 ) ).xy;\n#endif\n#ifdef USE_ALPHAMAP\n\tvAlphaMapUv = ( alphaMapTransform * vec3( ALPHAMAP_UV, 1 ) ).xy;\n#endif\n#ifdef USE_LIGHTMAP\n\tvLightMapUv = ( lightMapTransform * vec3( LIGHTMAP_UV, 1 ) ).xy;\n#endif\n#ifdef USE_AOMAP\n\tvAoMapUv = ( aoMapTransform * vec3( AOMAP_UV, 1 ) ).xy;\n#endif\n#ifdef USE_BUMPMAP\n\tvBumpMapUv = ( bumpMapTransform * vec3( BUMPMAP_UV, 1 ) ).xy;\n#endif\n#ifdef USE_NORMALMAP\n\tvNormalMapUv = ( normalMapTransform * vec3( NORMALMAP_UV, 1 ) ).xy;\n#endif\n#ifdef USE_DISPLACEMENTMAP\n\tvDisplacementMapUv = ( displacementMapTransform * vec3( DISPLACEMENTMAP_UV, 1 ) ).xy;\n#endif\n#ifdef USE_EMISSIVEMAP\n\tvEmissiveMapUv = ( emissiveMapTransform * vec3( EMISSIVEMAP_UV, 1 ) ).xy;\n#endif\n#ifdef USE_METALNESSMAP\n\tvMetalnessMapUv = ( metalnessMapTransform * vec3( METALNESSMAP_UV, 1 ) ).xy;\n#endif\n#ifdef USE_ROUGHNESSMAP\n\tvRoughnessMapUv = ( roughnessMapTransform * vec3( ROUGHNESSMAP_UV, 1 ) ).xy;\n#endif\n#ifdef USE_ANISOTROPYMAP\n\tvAnisotropyMapUv = ( anisotropyMapTransform * vec3( ANISOTROPYMAP_UV, 1 ) ).xy;\n#endif\n#ifdef USE_CLEARCOATMAP\n\tvClearcoatMapUv = ( clearcoatMapTransform * vec3( CLEARCOATMAP_UV, 1 ) ).xy;\n#endif\n#ifdef USE_CLEARCOAT_NORMALMAP\n\tvClearcoatNormalMapUv = ( clearcoatNormalMapTransform * vec3( CLEARCOAT_NORMALMAP_UV, 1 ) ).xy;\n#endif\n#ifdef USE_CLEARCOAT_ROUGHNESSMAP\n\tvClearcoatRoughnessMapUv = ( clearcoatRoughnessMapTransform * vec3( CLEARCOAT_ROUGHNESSMAP_UV, 1 ) ).xy;\n#endif\n#ifdef USE_IRIDESCENCEMAP\n\tvIridescenceMapUv = ( iridescenceMapTransform * vec3( IRIDESCENCEMAP_UV, 1 ) ).xy;\n#endif\n#ifdef USE_IRIDESCENCE_THICKNESSMAP\n\tvIridescenceThicknessMapUv = ( iridescenceThicknessMapTransform * vec3( IRIDESCENCE_THICKNESSMAP_UV, 1 ) ).xy;\n#endif\n#ifdef USE_SHEEN_COLORMAP\n\tvSheenColorMapUv = ( sheenColorMapTransform * vec3( SHEEN_COLORMAP_UV, 1 ) ).xy;\n#endif\n#ifdef USE_SHEEN_ROUGHNESSMAP\n\tvSheenRoughnessMapUv = ( sheenRoughnessMapTransform * vec3( SHEEN_ROUGHNESSMAP_UV, 1 ) ).xy;\n#endif\n#ifdef USE_SPECULARMAP\n\tvSpecularMapUv = ( specularMapTransform * vec3( SPECULARMAP_UV, 1 ) ).xy;\n#endif\n#ifdef USE_SPECULAR_COLORMAP\n\tvSpecularColorMapUv = ( specularColorMapTransform * vec3( SPECULAR_COLORMAP_UV, 1 ) ).xy;\n#endif\n#ifdef USE_SPECULAR_INTENSITYMAP\n\tvSpecularIntensityMapUv = ( specularIntensityMapTransform * vec3( SPECULAR_INTENSITYMAP_UV, 1 ) ).xy;\n#endif\n#ifdef USE_TRANSMISSIONMAP\n\tvTransmissionMapUv = ( transmissionMapTransform * vec3( TRANSMISSIONMAP_UV, 1 ) ).xy;\n#endif\n#ifdef USE_THICKNESSMAP\n\tvThicknessMapUv = ( thicknessMapTransform * vec3( THICKNESSMAP_UV, 1 ) ).xy;\n#endif";
var worldpos_vertex = "#if defined( USE_ENVMAP ) || defined( DISTANCE ) || defined ( USE_SHADOWMAP ) || defined ( USE_TRANSMISSION ) || NUM_SPOT_LIGHT_COORDS > 0\n\tvec4 worldPosition = vec4( transformed, 1.0 );\n\t#ifdef USE_BATCHING\n\t\tworldPosition = batchingMatrix * worldPosition;\n\t#endif\n\t#ifdef USE_INSTANCING\n\t\tworldPosition = instanceMatrix * worldPosition;\n\t#endif\n\tworldPosition = modelMatrix * worldPosition;\n#endif";
const vertex$h = "varying vec2 vUv;\nuniform mat3 uvTransform;\nvoid main() {\n\tvUv = ( uvTransform * vec3( uv, 1 ) ).xy;\n\tgl_Position = vec4( position.xy, 1.0, 1.0 );\n}";
const fragment$h = "uniform sampler2D t2D;\nuniform float backgroundIntensity;\nvarying vec2 vUv;\nvoid main() {\n\tvec4 texColor = texture2D( t2D, vUv );\n\t#ifdef DECODE_VIDEO_TEXTURE\n\t\ttexColor = vec4( mix( pow( texColor.rgb * 0.9478672986 + vec3( 0.0521327014 ), vec3( 2.4 ) ), texColor.rgb * 0.0773993808, vec3( lessThanEqual( texColor.rgb, vec3( 0.04045 ) ) ) ), texColor.w );\n\t#endif\n\ttexColor.rgb *= backgroundIntensity;\n\tgl_FragColor = texColor;\n\t#include <tonemapping_fragment>\n\t#include <colorspace_fragment>\n}";
const vertex$g = "varying vec3 vWorldDirection;\n#include <common>\nvoid main() {\n\tvWorldDirection = transformDirection( position, modelMatrix );\n\t#include <begin_vertex>\n\t#include <project_vertex>\n\tgl_Position.z = gl_Position.w;\n}";
const fragment$g = "#ifdef ENVMAP_TYPE_CUBE\n\tuniform samplerCube envMap;\n#elif defined( ENVMAP_TYPE_CUBE_UV )\n\tuniform sampler2D envMap;\n#endif\nuniform float flipEnvMap;\nuniform float backgroundBlurriness;\nuniform float backgroundIntensity;\nuniform mat3 backgroundRotation;\nvarying vec3 vWorldDirection;\n#include <cube_uv_reflection_fragment>\nvoid main() {\n\t#ifdef ENVMAP_TYPE_CUBE\n\t\tvec4 texColor = textureCube( envMap, backgroundRotation * vec3( flipEnvMap * vWorldDirection.x, vWorldDirection.yz ) );\n\t#elif defined( ENVMAP_TYPE_CUBE_UV )\n\t\tvec4 texColor = textureCubeUV( envMap, backgroundRotation * vWorldDirection, backgroundBlurriness );\n\t#else\n\t\tvec4 texColor = vec4( 0.0, 0.0, 0.0, 1.0 );\n\t#endif\n\ttexColor.rgb *= backgroundIntensity;\n\tgl_FragColor = texColor;\n\t#include <tonemapping_fragment>\n\t#include <colorspace_fragment>\n}";
const vertex$f = "varying vec3 vWorldDirection;\n#include <common>\nvoid main() {\n\tvWorldDirection = transformDirection( position, modelMatrix );\n\t#include <begin_vertex>\n\t#include <project_vertex>\n\tgl_Position.z = gl_Position.w;\n}";
const fragment$f = "uniform samplerCube tCube;\nuniform float tFlip;\nuniform float opacity;\nvarying vec3 vWorldDirection;\nvoid main() {\n\tvec4 texColor = textureCube( tCube, vec3( tFlip * vWorldDirection.x, vWorldDirection.yz ) );\n\tgl_FragColor = texColor;\n\tgl_FragColor.a *= opacity;\n\t#include <tonemapping_fragment>\n\t#include <colorspace_fragment>\n}";
const vertex$e = "#include <common>\n#include <batching_pars_vertex>\n#include <uv_pars_vertex>\n#include <displacementmap_pars_vertex>\n#include <morphtarget_pars_vertex>\n#include <skinning_pars_vertex>\n#include <logdepthbuf_pars_vertex>\n#include <clipping_planes_pars_vertex>\nvarying vec2 vHighPrecisionZW;\nvoid main() {\n\t#include <uv_vertex>\n\t#include <batching_vertex>\n\t#include <skinbase_vertex>\n\t#include <morphinstance_vertex>\n\t#ifdef USE_DISPLACEMENTMAP\n\t\t#include <beginnormal_vertex>\n\t\t#include <morphnormal_vertex>\n\t\t#include <skinnormal_vertex>\n\t#endif\n\t#include <begin_vertex>\n\t#include <morphtarget_vertex>\n\t#include <skinning_vertex>\n\t#include <displacementmap_vertex>\n\t#include <project_vertex>\n\t#include <logdepthbuf_vertex>\n\t#include <clipping_planes_vertex>\n\tvHighPrecisionZW = gl_Position.zw;\n}";
const fragment$e = "#if DEPTH_PACKING == 3200\n\tuniform float opacity;\n#endif\n#include <common>\n#include <packing>\n#include <uv_pars_fragment>\n#include <map_pars_fragment>\n#include <alphamap_pars_fragment>\n#include <alphatest_pars_fragment>\n#include <alphahash_pars_fragment>\n#include <logdepthbuf_pars_fragment>\n#include <clipping_planes_pars_fragment>\nvarying vec2 vHighPrecisionZW;\nvoid main() {\n\tvec4 diffuseColor = vec4( 1.0 );\n\t#include <clipping_planes_fragment>\n\t#if DEPTH_PACKING == 3200\n\t\tdiffuseColor.a = opacity;\n\t#endif\n\t#include <map_fragment>\n\t#include <alphamap_fragment>\n\t#include <alphatest_fragment>\n\t#include <alphahash_fragment>\n\t#include <logdepthbuf_fragment>\n\t#ifdef USE_REVERSED_DEPTH_BUFFER\n\t\tfloat fragCoordZ = vHighPrecisionZW[ 0 ] / vHighPrecisionZW[ 1 ];\n\t#else\n\t\tfloat fragCoordZ = 0.5 * vHighPrecisionZW[ 0 ] / vHighPrecisionZW[ 1 ] + 0.5;\n\t#endif\n\t#if DEPTH_PACKING == 3200\n\t\tgl_FragColor = vec4( vec3( 1.0 - fragCoordZ ), opacity );\n\t#elif DEPTH_PACKING == 3201\n\t\tgl_FragColor = packDepthToRGBA( fragCoordZ );\n\t#elif DEPTH_PACKING == 3202\n\t\tgl_FragColor = vec4( packDepthToRGB( fragCoordZ ), 1.0 );\n\t#elif DEPTH_PACKING == 3203\n\t\tgl_FragColor = vec4( packDepthToRG( fragCoordZ ), 0.0, 1.0 );\n\t#endif\n}";
const vertex$d = "#define DISTANCE\nvarying vec3 vWorldPosition;\n#include <common>\n#include <batching_pars_vertex>\n#include <uv_pars_vertex>\n#include <displacementmap_pars_vertex>\n#include <morphtarget_pars_vertex>\n#include <skinning_pars_vertex>\n#include <clipping_planes_pars_vertex>\nvoid main() {\n\t#include <uv_vertex>\n\t#include <batching_vertex>\n\t#include <skinbase_vertex>\n\t#include <morphinstance_vertex>\n\t#ifdef USE_DISPLACEMENTMAP\n\t\t#include <beginnormal_vertex>\n\t\t#include <morphnormal_vertex>\n\t\t#include <skinnormal_vertex>\n\t#endif\n\t#include <begin_vertex>\n\t#include <morphtarget_vertex>\n\t#include <skinning_vertex>\n\t#include <displacementmap_vertex>\n\t#include <project_vertex>\n\t#include <worldpos_vertex>\n\t#include <clipping_planes_vertex>\n\tvWorldPosition = worldPosition.xyz;\n}";
const fragment$d = "#define DISTANCE\nuniform vec3 referencePosition;\nuniform float nearDistance;\nuniform float farDistance;\nvarying vec3 vWorldPosition;\n#include <common>\n#include <uv_pars_fragment>\n#include <map_pars_fragment>\n#include <alphamap_pars_fragment>\n#include <alphatest_pars_fragment>\n#include <alphahash_pars_fragment>\n#include <clipping_planes_pars_fragment>\nvoid main () {\n\tvec4 diffuseColor = vec4( 1.0 );\n\t#include <clipping_planes_fragment>\n\t#include <map_fragment>\n\t#include <alphamap_fragment>\n\t#include <alphatest_fragment>\n\t#include <alphahash_fragment>\n\tfloat dist = length( vWorldPosition - referencePosition );\n\tdist = ( dist - nearDistance ) / ( farDistance - nearDistance );\n\tdist = saturate( dist );\n\tgl_FragColor = vec4( dist, 0.0, 0.0, 1.0 );\n}";
const vertex$c = "varying vec3 vWorldDirection;\n#include <common>\nvoid main() {\n\tvWorldDirection = transformDirection( position, modelMatrix );\n\t#include <begin_vertex>\n\t#include <project_vertex>\n}";
const fragment$c = "uniform sampler2D tEquirect;\nvarying vec3 vWorldDirection;\n#include <common>\nvoid main() {\n\tvec3 direction = normalize( vWorldDirection );\n\tvec2 sampleUV = equirectUv( direction );\n\tgl_FragColor = texture2D( tEquirect, sampleUV );\n\t#include <tonemapping_fragment>\n\t#include <colorspace_fragment>\n}";
const vertex$b = "uniform float scale;\nattribute float lineDistance;\nvarying float vLineDistance;\n#include <common>\n#include <uv_pars_vertex>\n#include <color_pars_vertex>\n#include <fog_pars_vertex>\n#include <morphtarget_pars_vertex>\n#include <logdepthbuf_pars_vertex>\n#include <clipping_planes_pars_vertex>\nvoid main() {\n\tvLineDistance = scale * lineDistance;\n\t#include <uv_vertex>\n\t#include <color_vertex>\n\t#include <morphinstance_vertex>\n\t#include <morphcolor_vertex>\n\t#include <begin_vertex>\n\t#include <morphtarget_vertex>\n\t#include <project_vertex>\n\t#include <logdepthbuf_vertex>\n\t#include <clipping_planes_vertex>\n\t#include <fog_vertex>\n}";
const fragment$b = "uniform vec3 diffuse;\nuniform float opacity;\nuniform float dashSize;\nuniform float totalSize;\nvarying float vLineDistance;\n#include <common>\n#include <color_pars_fragment>\n#include <uv_pars_fragment>\n#include <map_pars_fragment>\n#include <fog_pars_fragment>\n#include <logdepthbuf_pars_fragment>\n#include <clipping_planes_pars_fragment>\nvoid main() {\n\tvec4 diffuseColor = vec4( diffuse, opacity );\n\t#include <clipping_planes_fragment>\n\tif ( mod( vLineDistance, totalSize ) > dashSize ) {\n\t\tdiscard;\n\t}\n\tvec3 outgoingLight = vec3( 0.0 );\n\t#include <logdepthbuf_fragment>\n\t#include <map_fragment>\n\t#include <color_fragment>\n\toutgoingLight = diffuseColor.rgb;\n\t#include <opaque_fragment>\n\t#include <tonemapping_fragment>\n\t#include <colorspace_fragment>\n\t#include <fog_fragment>\n\t#include <premultiplied_alpha_fragment>\n}";
const vertex$a = "#include <common>\n#include <batching_pars_vertex>\n#include <uv_pars_vertex>\n#include <envmap_pars_vertex>\n#include <color_pars_vertex>\n#include <fog_pars_vertex>\n#include <morphtarget_pars_vertex>\n#include <skinning_pars_vertex>\n#include <logdepthbuf_pars_vertex>\n#include <clipping_planes_pars_vertex>\nvoid main() {\n\t#include <uv_vertex>\n\t#include <color_vertex>\n\t#include <morphinstance_vertex>\n\t#include <morphcolor_vertex>\n\t#include <batching_vertex>\n\t#if defined ( USE_ENVMAP ) || defined ( USE_SKINNING )\n\t\t#include <beginnormal_vertex>\n\t\t#include <morphnormal_vertex>\n\t\t#include <skinbase_vertex>\n\t\t#include <skinnormal_vertex>\n\t\t#include <defaultnormal_vertex>\n\t#endif\n\t#include <begin_vertex>\n\t#include <morphtarget_vertex>\n\t#include <skinning_vertex>\n\t#include <project_vertex>\n\t#include <logdepthbuf_vertex>\n\t#include <clipping_planes_vertex>\n\t#include <worldpos_vertex>\n\t#include <envmap_vertex>\n\t#include <fog_vertex>\n}";
const fragment$a = "uniform vec3 diffuse;\nuniform float opacity;\n#ifndef FLAT_SHADED\n\tvarying vec3 vNormal;\n#endif\n#include <common>\n#include <dithering_pars_fragment>\n#include <color_pars_fragment>\n#include <uv_pars_fragment>\n#include <map_pars_fragment>\n#include <alphamap_pars_fragment>\n#include <alphatest_pars_fragment>\n#include <alphahash_pars_fragment>\n#include <aomap_pars_fragment>\n#include <lightmap_pars_fragment>\n#include <envmap_common_pars_fragment>\n#include <envmap_pars_fragment>\n#include <fog_pars_fragment>\n#include <specularmap_pars_fragment>\n#include <logdepthbuf_pars_fragment>\n#include <clipping_planes_pars_fragment>\nvoid main() {\n\tvec4 diffuseColor = vec4( diffuse, opacity );\n\t#include <clipping_planes_fragment>\n\t#include <logdepthbuf_fragment>\n\t#include <map_fragment>\n\t#include <color_fragment>\n\t#include <alphamap_fragment>\n\t#include <alphatest_fragment>\n\t#include <alphahash_fragment>\n\t#include <specularmap_fragment>\n\tReflectedLight reflectedLight = ReflectedLight( vec3( 0.0 ), vec3( 0.0 ), vec3( 0.0 ), vec3( 0.0 ) );\n\t#ifdef USE_LIGHTMAP\n\t\tvec4 lightMapTexel = texture2D( lightMap, vLightMapUv );\n\t\treflectedLight.indirectDiffuse += lightMapTexel.rgb * lightMapIntensity * RECIPROCAL_PI;\n\t#else\n\t\treflectedLight.indirectDiffuse += vec3( 1.0 );\n\t#endif\n\t#include <aomap_fragment>\n\treflectedLight.indirectDiffuse *= diffuseColor.rgb;\n\tvec3 outgoingLight = reflectedLight.indirectDiffuse;\n\t#include <envmap_fragment>\n\t#include <opaque_fragment>\n\t#include <tonemapping_fragment>\n\t#include <colorspace_fragment>\n\t#include <fog_fragment>\n\t#include <premultiplied_alpha_fragment>\n\t#include <dithering_fragment>\n}";
const vertex$9 = "#define LAMBERT\nvarying vec3 vViewPosition;\n#include <common>\n#include <batching_pars_vertex>\n#include <uv_pars_vertex>\n#include <displacementmap_pars_vertex>\n#include <envmap_pars_vertex>\n#include <color_pars_vertex>\n#include <fog_pars_vertex>\n#include <normal_pars_vertex>\n#include <morphtarget_pars_vertex>\n#include <skinning_pars_vertex>\n#include <shadowmap_pars_vertex>\n#include <logdepthbuf_pars_vertex>\n#include <clipping_planes_pars_vertex>\nvoid main() {\n\t#include <uv_vertex>\n\t#include <color_vertex>\n\t#include <morphinstance_vertex>\n\t#include <morphcolor_vertex>\n\t#include <batching_vertex>\n\t#include <beginnormal_vertex>\n\t#include <morphnormal_vertex>\n\t#include <skinbase_vertex>\n\t#include <skinnormal_vertex>\n\t#include <defaultnormal_vertex>\n\t#include <normal_vertex>\n\t#include <begin_vertex>\n\t#include <morphtarget_vertex>\n\t#include <skinning_vertex>\n\t#include <displacementmap_vertex>\n\t#include <project_vertex>\n\t#include <logdepthbuf_vertex>\n\t#include <clipping_planes_vertex>\n\tvViewPosition = - mvPosition.xyz;\n\t#include <worldpos_vertex>\n\t#include <envmap_vertex>\n\t#include <shadowmap_vertex>\n\t#include <fog_vertex>\n}";
const fragment$9 = "#define LAMBERT\nuniform vec3 diffuse;\nuniform vec3 emissive;\nuniform float opacity;\n#include <common>\n#include <dithering_pars_fragment>\n#include <color_pars_fragment>\n#include <uv_pars_fragment>\n#include <map_pars_fragment>\n#include <alphamap_pars_fragment>\n#include <alphatest_pars_fragment>\n#include <alphahash_pars_fragment>\n#include <aomap_pars_fragment>\n#include <lightmap_pars_fragment>\n#include <emissivemap_pars_fragment>\n#include <envmap_common_pars_fragment>\n#include <envmap_pars_fragment>\n#include <fog_pars_fragment>\n#include <bsdfs>\n#include <lights_pars_begin>\n#include <normal_pars_fragment>\n#include <lights_lambert_pars_fragment>\n#include <shadowmap_pars_fragment>\n#include <bumpmap_pars_fragment>\n#include <normalmap_pars_fragment>\n#include <specularmap_pars_fragment>\n#include <logdepthbuf_pars_fragment>\n#include <clipping_planes_pars_fragment>\nvoid main() {\n\tvec4 diffuseColor = vec4( diffuse, opacity );\n\t#include <clipping_planes_fragment>\n\tReflectedLight reflectedLight = ReflectedLight( vec3( 0.0 ), vec3( 0.0 ), vec3( 0.0 ), vec3( 0.0 ) );\n\tvec3 totalEmissiveRadiance = emissive;\n\t#include <logdepthbuf_fragment>\n\t#include <map_fragment>\n\t#include <color_fragment>\n\t#include <alphamap_fragment>\n\t#include <alphatest_fragment>\n\t#include <alphahash_fragment>\n\t#include <specularmap_fragment>\n\t#include <normal_fragment_begin>\n\t#include <normal_fragment_maps>\n\t#include <emissivemap_fragment>\n\t#include <lights_lambert_fragment>\n\t#include <lights_fragment_begin>\n\t#include <lights_fragment_maps>\n\t#include <lights_fragment_end>\n\t#include <aomap_fragment>\n\tvec3 outgoingLight = reflectedLight.directDiffuse + reflectedLight.indirectDiffuse + totalEmissiveRadiance;\n\t#include <envmap_fragment>\n\t#include <opaque_fragment>\n\t#include <tonemapping_fragment>\n\t#include <colorspace_fragment>\n\t#include <fog_fragment>\n\t#include <premultiplied_alpha_fragment>\n\t#include <dithering_fragment>\n}";
const vertex$8 = "#define MATCAP\nvarying vec3 vViewPosition;\n#include <common>\n#include <batching_pars_vertex>\n#include <uv_pars_vertex>\n#include <color_pars_vertex>\n#include <displacementmap_pars_vertex>\n#include <fog_pars_vertex>\n#include <normal_pars_vertex>\n#include <morphtarget_pars_vertex>\n#include <skinning_pars_vertex>\n#include <logdepthbuf_pars_vertex>\n#include <clipping_planes_pars_vertex>\nvoid main() {\n\t#include <uv_vertex>\n\t#include <color_vertex>\n\t#include <morphinstance_vertex>\n\t#include <morphcolor_vertex>\n\t#include <batching_vertex>\n\t#include <beginnormal_vertex>\n\t#include <morphnormal_vertex>\n\t#include <skinbase_vertex>\n\t#include <skinnormal_vertex>\n\t#include <defaultnormal_vertex>\n\t#include <normal_vertex>\n\t#include <begin_vertex>\n\t#include <morphtarget_vertex>\n\t#include <skinning_vertex>\n\t#include <displacementmap_vertex>\n\t#include <project_vertex>\n\t#include <logdepthbuf_vertex>\n\t#include <clipping_planes_vertex>\n\t#include <fog_vertex>\n\tvViewPosition = - mvPosition.xyz;\n}";
const fragment$8 = "#define MATCAP\nuniform vec3 diffuse;\nuniform float opacity;\nuniform sampler2D matcap;\nvarying vec3 vViewPosition;\n#include <common>\n#include <dithering_pars_fragment>\n#include <color_pars_fragment>\n#include <uv_pars_fragment>\n#include <map_pars_fragment>\n#include <alphamap_pars_fragment>\n#include <alphatest_pars_fragment>\n#include <alphahash_pars_fragment>\n#include <fog_pars_fragment>\n#include <normal_pars_fragment>\n#include <bumpmap_pars_fragment>\n#include <normalmap_pars_fragment>\n#include <logdepthbuf_pars_fragment>\n#include <clipping_planes_pars_fragment>\nvoid main() {\n\tvec4 diffuseColor = vec4( diffuse, opacity );\n\t#include <clipping_planes_fragment>\n\t#include <logdepthbuf_fragment>\n\t#include <map_fragment>\n\t#include <color_fragment>\n\t#include <alphamap_fragment>\n\t#include <alphatest_fragment>\n\t#include <alphahash_fragment>\n\t#include <normal_fragment_begin>\n\t#include <normal_fragment_maps>\n\tvec3 viewDir = normalize( vViewPosition );\n\tvec3 x = normalize( vec3( viewDir.z, 0.0, - viewDir.x ) );\n\tvec3 y = cross( viewDir, x );\n\tvec2 uv = vec2( dot( x, normal ), dot( y, normal ) ) * 0.495 + 0.5;\n\t#ifdef USE_MATCAP\n\t\tvec4 matcapColor = texture2D( matcap, uv );\n\t#else\n\t\tvec4 matcapColor = vec4( vec3( mix( 0.2, 0.8, uv.y ) ), 1.0 );\n\t#endif\n\tvec3 outgoingLight = diffuseColor.rgb * matcapColor.rgb;\n\t#include <opaque_fragment>\n\t#include <tonemapping_fragment>\n\t#include <colorspace_fragment>\n\t#include <fog_fragment>\n\t#include <premultiplied_alpha_fragment>\n\t#include <dithering_fragment>\n}";
const vertex$7 = "#define NORMAL\n#if defined( FLAT_SHADED ) || defined( USE_BUMPMAP ) || defined( USE_NORMALMAP_TANGENTSPACE )\n\tvarying vec3 vViewPosition;\n#endif\n#include <common>\n#include <batching_pars_vertex>\n#include <uv_pars_vertex>\n#include <displacementmap_pars_vertex>\n#include <normal_pars_vertex>\n#include <morphtarget_pars_vertex>\n#include <skinning_pars_vertex>\n#include <logdepthbuf_pars_vertex>\n#include <clipping_planes_pars_vertex>\nvoid main() {\n\t#include <uv_vertex>\n\t#include <batching_vertex>\n\t#include <beginnormal_vertex>\n\t#include <morphinstance_vertex>\n\t#include <morphnormal_vertex>\n\t#include <skinbase_vertex>\n\t#include <skinnormal_vertex>\n\t#include <defaultnormal_vertex>\n\t#include <normal_vertex>\n\t#include <begin_vertex>\n\t#include <morphtarget_vertex>\n\t#include <skinning_vertex>\n\t#include <displacementmap_vertex>\n\t#include <project_vertex>\n\t#include <logdepthbuf_vertex>\n\t#include <clipping_planes_vertex>\n#if defined( FLAT_SHADED ) || defined( USE_BUMPMAP ) || defined( USE_NORMALMAP_TANGENTSPACE )\n\tvViewPosition = - mvPosition.xyz;\n#endif\n}";
const fragment$7 = "#define NORMAL\nuniform float opacity;\n#if defined( FLAT_SHADED ) || defined( USE_BUMPMAP ) || defined( USE_NORMALMAP_TANGENTSPACE )\n\tvarying vec3 vViewPosition;\n#endif\n#include <uv_pars_fragment>\n#include <normal_pars_fragment>\n#include <bumpmap_pars_fragment>\n#include <normalmap_pars_fragment>\n#include <logdepthbuf_pars_fragment>\n#include <clipping_planes_pars_fragment>\nvoid main() {\n\tvec4 diffuseColor = vec4( 0.0, 0.0, 0.0, opacity );\n\t#include <clipping_planes_fragment>\n\t#include <logdepthbuf_fragment>\n\t#include <normal_fragment_begin>\n\t#include <normal_fragment_maps>\n\tgl_FragColor = vec4( normalize( normal ) * 0.5 + 0.5, diffuseColor.a );\n\t#ifdef OPAQUE\n\t\tgl_FragColor.a = 1.0;\n\t#endif\n}";
const vertex$6 = "#define PHONG\nvarying vec3 vViewPosition;\n#include <common>\n#include <batching_pars_vertex>\n#include <uv_pars_vertex>\n#include <displacementmap_pars_vertex>\n#include <envmap_pars_vertex>\n#include <color_pars_vertex>\n#include <fog_pars_vertex>\n#include <normal_pars_vertex>\n#include <morphtarget_pars_vertex>\n#include <skinning_pars_vertex>\n#include <shadowmap_pars_vertex>\n#include <logdepthbuf_pars_vertex>\n#include <clipping_planes_pars_vertex>\nvoid main() {\n\t#include <uv_vertex>\n\t#include <color_vertex>\n\t#include <morphcolor_vertex>\n\t#include <batching_vertex>\n\t#include <beginnormal_vertex>\n\t#include <morphinstance_vertex>\n\t#include <morphnormal_vertex>\n\t#include <skinbase_vertex>\n\t#include <skinnormal_vertex>\n\t#include <defaultnormal_vertex>\n\t#include <normal_vertex>\n\t#include <begin_vertex>\n\t#include <morphtarget_vertex>\n\t#include <skinning_vertex>\n\t#include <displacementmap_vertex>\n\t#include <project_vertex>\n\t#include <logdepthbuf_vertex>\n\t#include <clipping_planes_vertex>\n\tvViewPosition = - mvPosition.xyz;\n\t#include <worldpos_vertex>\n\t#include <envmap_vertex>\n\t#include <shadowmap_vertex>\n\t#include <fog_vertex>\n}";
const fragment$6 = "#define PHONG\nuniform vec3 diffuse;\nuniform vec3 emissive;\nuniform vec3 specular;\nuniform float shininess;\nuniform float opacity;\n#include <common>\n#include <dithering_pars_fragment>\n#include <color_pars_fragment>\n#include <uv_pars_fragment>\n#include <map_pars_fragment>\n#include <alphamap_pars_fragment>\n#include <alphatest_pars_fragment>\n#include <alphahash_pars_fragment>\n#include <aomap_pars_fragment>\n#include <lightmap_pars_fragment>\n#include <emissivemap_pars_fragment>\n#include <envmap_common_pars_fragment>\n#include <envmap_pars_fragment>\n#include <fog_pars_fragment>\n#include <bsdfs>\n#include <lights_pars_begin>\n#include <normal_pars_fragment>\n#include <lights_phong_pars_fragment>\n#include <shadowmap_pars_fragment>\n#include <bumpmap_pars_fragment>\n#include <normalmap_pars_fragment>\n#include <specularmap_pars_fragment>\n#include <logdepthbuf_pars_fragment>\n#include <clipping_planes_pars_fragment>\nvoid main() {\n\tvec4 diffuseColor = vec4( diffuse, opacity );\n\t#include <clipping_planes_fragment>\n\tReflectedLight reflectedLight = ReflectedLight( vec3( 0.0 ), vec3( 0.0 ), vec3( 0.0 ), vec3( 0.0 ) );\n\tvec3 totalEmissiveRadiance = emissive;\n\t#include <logdepthbuf_fragment>\n\t#include <map_fragment>\n\t#include <color_fragment>\n\t#include <alphamap_fragment>\n\t#include <alphatest_fragment>\n\t#include <alphahash_fragment>\n\t#include <specularmap_fragment>\n\t#include <normal_fragment_begin>\n\t#include <normal_fragment_maps>\n\t#include <emissivemap_fragment>\n\t#include <lights_phong_fragment>\n\t#include <lights_fragment_begin>\n\t#include <lights_fragment_maps>\n\t#include <lights_fragment_end>\n\t#include <aomap_fragment>\n\tvec3 outgoingLight = reflectedLight.directDiffuse + reflectedLight.indirectDiffuse + reflectedLight.directSpecular + reflectedLight.indirectSpecular + totalEmissiveRadiance;\n\t#include <envmap_fragment>\n\t#include <opaque_fragment>\n\t#include <tonemapping_fragment>\n\t#include <colorspace_fragment>\n\t#include <fog_fragment>\n\t#include <premultiplied_alpha_fragment>\n\t#include <dithering_fragment>\n}";
const vertex$5 = "#define STANDARD\nvarying vec3 vViewPosition;\n#ifdef USE_TRANSMISSION\n\tvarying vec3 vWorldPosition;\n#endif\n#include <common>\n#include <batching_pars_vertex>\n#include <uv_pars_vertex>\n#include <displacementmap_pars_vertex>\n#include <color_pars_vertex>\n#include <fog_pars_vertex>\n#include <normal_pars_vertex>\n#include <morphtarget_pars_vertex>\n#include <skinning_pars_vertex>\n#include <shadowmap_pars_vertex>\n#include <logdepthbuf_pars_vertex>\n#include <clipping_planes_pars_vertex>\nvoid main() {\n\t#include <uv_vertex>\n\t#include <color_vertex>\n\t#include <morphinstance_vertex>\n\t#include <morphcolor_vertex>\n\t#include <batching_vertex>\n\t#include <beginnormal_vertex>\n\t#include <morphnormal_vertex>\n\t#include <skinbase_vertex>\n\t#include <skinnormal_vertex>\n\t#include <defaultnormal_vertex>\n\t#include <normal_vertex>\n\t#include <begin_vertex>\n\t#include <morphtarget_vertex>\n\t#include <skinning_vertex>\n\t#include <displacementmap_vertex>\n\t#include <project_vertex>\n\t#include <logdepthbuf_vertex>\n\t#include <clipping_planes_vertex>\n\tvViewPosition = - mvPosition.xyz;\n\t#include <worldpos_vertex>\n\t#include <shadowmap_vertex>\n\t#include <fog_vertex>\n#ifdef USE_TRANSMISSION\n\tvWorldPosition = worldPosition.xyz;\n#endif\n}";
const fragment$5 = "#define STANDARD\n#ifdef PHYSICAL\n\t#define IOR\n\t#define USE_SPECULAR\n#endif\nuniform vec3 diffuse;\nuniform vec3 emissive;\nuniform float roughness;\nuniform float metalness;\nuniform float opacity;\n#ifdef IOR\n\tuniform float ior;\n#endif\n#ifdef USE_SPECULAR\n\tuniform float specularIntensity;\n\tuniform vec3 specularColor;\n\t#ifdef USE_SPECULAR_COLORMAP\n\t\tuniform sampler2D specularColorMap;\n\t#endif\n\t#ifdef USE_SPECULAR_INTENSITYMAP\n\t\tuniform sampler2D specularIntensityMap;\n\t#endif\n#endif\n#ifdef USE_CLEARCOAT\n\tuniform float clearcoat;\n\tuniform float clearcoatRoughness;\n#endif\n#ifdef USE_DISPERSION\n\tuniform float dispersion;\n#endif\n#ifdef USE_IRIDESCENCE\n\tuniform float iridescence;\n\tuniform float iridescenceIOR;\n\tuniform float iridescenceThicknessMinimum;\n\tuniform float iridescenceThicknessMaximum;\n#endif\n#ifdef USE_SHEEN\n\tuniform vec3 sheenColor;\n\tuniform float sheenRoughness;\n\t#ifdef USE_SHEEN_COLORMAP\n\t\tuniform sampler2D sheenColorMap;\n\t#endif\n\t#ifdef USE_SHEEN_ROUGHNESSMAP\n\t\tuniform sampler2D sheenRoughnessMap;\n\t#endif\n#endif\n#ifdef USE_ANISOTROPY\n\tuniform vec2 anisotropyVector;\n\t#ifdef USE_ANISOTROPYMAP\n\t\tuniform sampler2D anisotropyMap;\n\t#endif\n#endif\nvarying vec3 vViewPosition;\n#include <common>\n#include <dithering_pars_fragment>\n#include <color_pars_fragment>\n#include <uv_pars_fragment>\n#include <map_pars_fragment>\n#include <alphamap_pars_fragment>\n#include <alphatest_pars_fragment>\n#include <alphahash_pars_fragment>\n#include <aomap_pars_fragment>\n#include <lightmap_pars_fragment>\n#include <emissivemap_pars_fragment>\n#include <iridescence_fragment>\n#include <cube_uv_reflection_fragment>\n#include <envmap_common_pars_fragment>\n#include <envmap_physical_pars_fragment>\n#include <fog_pars_fragment>\n#include <lights_pars_begin>\n#include <normal_pars_fragment>\n#include <lights_physical_pars_fragment>\n#include <transmission_pars_fragment>\n#include <shadowmap_pars_fragment>\n#include <bumpmap_pars_fragment>\n#include <normalmap_pars_fragment>\n#include <clearcoat_pars_fragment>\n#include <iridescence_pars_fragment>\n#include <roughnessmap_pars_fragment>\n#include <metalnessmap_pars_fragment>\n#include <logdepthbuf_pars_fragment>\n#include <clipping_planes_pars_fragment>\nvoid main() {\n\tvec4 diffuseColor = vec4( diffuse, opacity );\n\t#include <clipping_planes_fragment>\n\tReflectedLight reflectedLight = ReflectedLight( vec3( 0.0 ), vec3( 0.0 ), vec3( 0.0 ), vec3( 0.0 ) );\n\tvec3 totalEmissiveRadiance = emissive;\n\t#include <logdepthbuf_fragment>\n\t#include <map_fragment>\n\t#include <color_fragment>\n\t#include <alphamap_fragment>\n\t#include <alphatest_fragment>\n\t#include <alphahash_fragment>\n\t#include <roughnessmap_fragment>\n\t#include <metalnessmap_fragment>\n\t#include <normal_fragment_begin>\n\t#include <normal_fragment_maps>\n\t#include <clearcoat_normal_fragment_begin>\n\t#include <clearcoat_normal_fragment_maps>\n\t#include <emissivemap_fragment>\n\t#include <lights_physical_fragment>\n\t#include <lights_fragment_begin>\n\t#include <lights_fragment_maps>\n\t#include <lights_fragment_end>\n\t#include <aomap_fragment>\n\tvec3 totalDiffuse = reflectedLight.directDiffuse + reflectedLight.indirectDiffuse;\n\tvec3 totalSpecular = reflectedLight.directSpecular + reflectedLight.indirectSpecular;\n\t#include <transmission_fragment>\n\tvec3 outgoingLight = totalDiffuse + totalSpecular + totalEmissiveRadiance;\n\t#ifdef USE_SHEEN\n \n\t\toutgoingLight = outgoingLight + sheenSpecularDirect + sheenSpecularIndirect;\n \n \t#endif\n\t#ifdef USE_CLEARCOAT\n\t\tfloat dotNVcc = saturate( dot( geometryClearcoatNormal, geometryViewDir ) );\n\t\tvec3 Fcc = F_Schlick( material.clearcoatF0, material.clearcoatF90, dotNVcc );\n\t\toutgoingLight = outgoingLight * ( 1.0 - material.clearcoat * Fcc ) + ( clearcoatSpecularDirect + clearcoatSpecularIndirect ) * material.clearcoat;\n\t#endif\n\t#include <opaque_fragment>\n\t#include <tonemapping_fragment>\n\t#include <colorspace_fragment>\n\t#include <fog_fragment>\n\t#include <premultiplied_alpha_fragment>\n\t#include <dithering_fragment>\n}";
const vertex$4 = "#define TOON\nvarying vec3 vViewPosition;\n#include <common>\n#include <batching_pars_vertex>\n#include <uv_pars_vertex>\n#include <displacementmap_pars_vertex>\n#include <color_pars_vertex>\n#include <fog_pars_vertex>\n#include <normal_pars_vertex>\n#include <morphtarget_pars_vertex>\n#include <skinning_pars_vertex>\n#include <shadowmap_pars_vertex>\n#include <logdepthbuf_pars_vertex>\n#include <clipping_planes_pars_vertex>\nvoid main() {\n\t#include <uv_vertex>\n\t#include <color_vertex>\n\t#include <morphinstance_vertex>\n\t#include <morphcolor_vertex>\n\t#include <batching_vertex>\n\t#include <beginnormal_vertex>\n\t#include <morphnormal_vertex>\n\t#include <skinbase_vertex>\n\t#include <skinnormal_vertex>\n\t#include <defaultnormal_vertex>\n\t#include <normal_vertex>\n\t#include <begin_vertex>\n\t#include <morphtarget_vertex>\n\t#include <skinning_vertex>\n\t#include <displacementmap_vertex>\n\t#include <project_vertex>\n\t#include <logdepthbuf_vertex>\n\t#include <clipping_planes_vertex>\n\tvViewPosition = - mvPosition.xyz;\n\t#include <worldpos_vertex>\n\t#include <shadowmap_vertex>\n\t#include <fog_vertex>\n}";
const fragment$4 = "#define TOON\nuniform vec3 diffuse;\nuniform vec3 emissive;\nuniform float opacity;\n#include <common>\n#include <dithering_pars_fragment>\n#include <color_pars_fragment>\n#include <uv_pars_fragment>\n#include <map_pars_fragment>\n#include <alphamap_pars_fragment>\n#include <alphatest_pars_fragment>\n#include <alphahash_pars_fragment>\n#include <aomap_pars_fragment>\n#include <lightmap_pars_fragment>\n#include <emissivemap_pars_fragment>\n#include <gradientmap_pars_fragment>\n#include <fog_pars_fragment>\n#include <bsdfs>\n#include <lights_pars_begin>\n#include <normal_pars_fragment>\n#include <lights_toon_pars_fragment>\n#include <shadowmap_pars_fragment>\n#include <bumpmap_pars_fragment>\n#include <normalmap_pars_fragment>\n#include <logdepthbuf_pars_fragment>\n#include <clipping_planes_pars_fragment>\nvoid main() {\n\tvec4 diffuseColor = vec4( diffuse, opacity );\n\t#include <clipping_planes_fragment>\n\tReflectedLight reflectedLight = ReflectedLight( vec3( 0.0 ), vec3( 0.0 ), vec3( 0.0 ), vec3( 0.0 ) );\n\tvec3 totalEmissiveRadiance = emissive;\n\t#include <logdepthbuf_fragment>\n\t#include <map_fragment>\n\t#include <color_fragment>\n\t#include <alphamap_fragment>\n\t#include <alphatest_fragment>\n\t#include <alphahash_fragment>\n\t#include <normal_fragment_begin>\n\t#include <normal_fragment_maps>\n\t#include <emissivemap_fragment>\n\t#include <lights_toon_fragment>\n\t#include <lights_fragment_begin>\n\t#include <lights_fragment_maps>\n\t#include <lights_fragment_end>\n\t#include <aomap_fragment>\n\tvec3 outgoingLight = reflectedLight.directDiffuse + reflectedLight.indirectDiffuse + totalEmissiveRadiance;\n\t#include <opaque_fragment>\n\t#include <tonemapping_fragment>\n\t#include <colorspace_fragment>\n\t#include <fog_fragment>\n\t#include <premultiplied_alpha_fragment>\n\t#include <dithering_fragment>\n}";
const vertex$3 = "uniform float size;\nuniform float scale;\n#include <common>\n#include <color_pars_vertex>\n#include <fog_pars_vertex>\n#include <morphtarget_pars_vertex>\n#include <logdepthbuf_pars_vertex>\n#include <clipping_planes_pars_vertex>\n#ifdef USE_POINTS_UV\n\tvarying vec2 vUv;\n\tuniform mat3 uvTransform;\n#endif\nvoid main() {\n\t#ifdef USE_POINTS_UV\n\t\tvUv = ( uvTransform * vec3( uv, 1 ) ).xy;\n\t#endif\n\t#include <color_vertex>\n\t#include <morphinstance_vertex>\n\t#include <morphcolor_vertex>\n\t#include <begin_vertex>\n\t#include <morphtarget_vertex>\n\t#include <project_vertex>\n\tgl_PointSize = size;\n\t#ifdef USE_SIZEATTENUATION\n\t\tbool isPerspective = isPerspectiveMatrix( projectionMatrix );\n\t\tif ( isPerspective ) gl_PointSize *= ( scale / - mvPosition.z );\n\t#endif\n\t#include <logdepthbuf_vertex>\n\t#include <clipping_planes_vertex>\n\t#include <worldpos_vertex>\n\t#include <fog_vertex>\n}";
const fragment$3 = "uniform vec3 diffuse;\nuniform float opacity;\n#include <common>\n#include <color_pars_fragment>\n#include <map_particle_pars_fragment>\n#include <alphatest_pars_fragment>\n#include <alphahash_pars_fragment>\n#include <fog_pars_fragment>\n#include <logdepthbuf_pars_fragment>\n#include <clipping_planes_pars_fragment>\nvoid main() {\n\tvec4 diffuseColor = vec4( diffuse, opacity );\n\t#include <clipping_planes_fragment>\n\tvec3 outgoingLight = vec3( 0.0 );\n\t#include <logdepthbuf_fragment>\n\t#include <map_particle_fragment>\n\t#include <color_fragment>\n\t#include <alphatest_fragment>\n\t#include <alphahash_fragment>\n\toutgoingLight = diffuseColor.rgb;\n\t#include <opaque_fragment>\n\t#include <tonemapping_fragment>\n\t#include <colorspace_fragment>\n\t#include <fog_fragment>\n\t#include <premultiplied_alpha_fragment>\n}";
const vertex$2 = "#include <common>\n#include <batching_pars_vertex>\n#include <fog_pars_vertex>\n#include <morphtarget_pars_vertex>\n#include <skinning_pars_vertex>\n#include <logdepthbuf_pars_vertex>\n#include <shadowmap_pars_vertex>\nvoid main() {\n\t#include <batching_vertex>\n\t#include <beginnormal_vertex>\n\t#include <morphinstance_vertex>\n\t#include <morphnormal_vertex>\n\t#include <skinbase_vertex>\n\t#include <skinnormal_vertex>\n\t#include <defaultnormal_vertex>\n\t#include <begin_vertex>\n\t#include <morphtarget_vertex>\n\t#include <skinning_vertex>\n\t#include <project_vertex>\n\t#include <logdepthbuf_vertex>\n\t#include <worldpos_vertex>\n\t#include <shadowmap_vertex>\n\t#include <fog_vertex>\n}";
const fragment$2 = "uniform vec3 color;\nuniform float opacity;\n#include <common>\n#include <fog_pars_fragment>\n#include <bsdfs>\n#include <lights_pars_begin>\n#include <logdepthbuf_pars_fragment>\n#include <shadowmap_pars_fragment>\n#include <shadowmask_pars_fragment>\nvoid main() {\n\t#include <logdepthbuf_fragment>\n\tgl_FragColor = vec4( color, opacity * ( 1.0 - getShadowMask() ) );\n\t#include <tonemapping_fragment>\n\t#include <colorspace_fragment>\n\t#include <fog_fragment>\n}";
const vertex$1 = "uniform float rotation;\nuniform vec2 center;\n#include <common>\n#include <uv_pars_vertex>\n#include <fog_pars_vertex>\n#include <logdepthbuf_pars_vertex>\n#include <clipping_planes_pars_vertex>\nvoid main() {\n\t#include <uv_vertex>\n\tvec4 mvPosition = modelViewMatrix[ 3 ];\n\tvec2 scale = vec2( length( modelMatrix[ 0 ].xyz ), length( modelMatrix[ 1 ].xyz ) );\n\t#ifndef USE_SIZEATTENUATION\n\t\tbool isPerspective = isPerspectiveMatrix( projectionMatrix );\n\t\tif ( isPerspective ) scale *= - mvPosition.z;\n\t#endif\n\tvec2 alignedPosition = ( position.xy - ( center - vec2( 0.5 ) ) ) * scale;\n\tvec2 rotatedPosition;\n\trotatedPosition.x = cos( rotation ) * alignedPosition.x - sin( rotation ) * alignedPosition.y;\n\trotatedPosition.y = sin( rotation ) * alignedPosition.x + cos( rotation ) * alignedPosition.y;\n\tmvPosition.xy += rotatedPosition;\n\tgl_Position = projectionMatrix * mvPosition;\n\t#include <logdepthbuf_vertex>\n\t#include <clipping_planes_vertex>\n\t#include <fog_vertex>\n}";
const fragment$1 = "uniform vec3 diffuse;\nuniform float opacity;\n#include <common>\n#include <uv_pars_fragment>\n#include <map_pars_fragment>\n#include <alphamap_pars_fragment>\n#include <alphatest_pars_fragment>\n#include <alphahash_pars_fragment>\n#include <fog_pars_fragment>\n#include <logdepthbuf_pars_fragment>\n#include <clipping_planes_pars_fragment>\nvoid main() {\n\tvec4 diffuseColor = vec4( diffuse, opacity );\n\t#include <clipping_planes_fragment>\n\tvec3 outgoingLight = vec3( 0.0 );\n\t#include <logdepthbuf_fragment>\n\t#include <map_fragment>\n\t#include <alphamap_fragment>\n\t#include <alphatest_fragment>\n\t#include <alphahash_fragment>\n\toutgoingLight = diffuseColor.rgb;\n\t#include <opaque_fragment>\n\t#include <tonemapping_fragment>\n\t#include <colorspace_fragment>\n\t#include <fog_fragment>\n}";
const ShaderChunk = {
    alphahash_fragment: alphahash_fragment,
    alphahash_pars_fragment: alphahash_pars_fragment,
    alphamap_fragment: alphamap_fragment,
    alphamap_pars_fragment: alphamap_pars_fragment,
    alphatest_fragment: alphatest_fragment,
    alphatest_pars_fragment: alphatest_pars_fragment,
    aomap_fragment: aomap_fragment,
    aomap_pars_fragment: aomap_pars_fragment,
    batching_pars_vertex: batching_pars_vertex,
    batching_vertex: batching_vertex,
    begin_vertex: begin_vertex,
    beginnormal_vertex: beginnormal_vertex,
    bsdfs: bsdfs,
    iridescence_fragment: iridescence_fragment,
    bumpmap_pars_fragment: bumpmap_pars_fragment,
    clipping_planes_fragment: clipping_planes_fragment,
    clipping_planes_pars_fragment: clipping_planes_pars_fragment,
    clipping_planes_pars_vertex: clipping_planes_pars_vertex,
    clipping_planes_vertex: clipping_planes_vertex,
    color_fragment: color_fragment,
    color_pars_fragment: color_pars_fragment,
    color_pars_vertex: color_pars_vertex,
    color_vertex: color_vertex,
    common: common,
    cube_uv_reflection_fragment: cube_uv_reflection_fragment,
    defaultnormal_vertex: defaultnormal_vertex,
    displacementmap_pars_vertex: displacementmap_pars_vertex,
    displacementmap_vertex: displacementmap_vertex,
    emissivemap_fragment: emissivemap_fragment,
    emissivemap_pars_fragment: emissivemap_pars_fragment,
    colorspace_fragment: colorspace_fragment,
    colorspace_pars_fragment: colorspace_pars_fragment,
    envmap_fragment: envmap_fragment,
    envmap_common_pars_fragment: envmap_common_pars_fragment,
    envmap_pars_fragment: envmap_pars_fragment,
    envmap_pars_vertex: envmap_pars_vertex,
    envmap_physical_pars_fragment: envmap_physical_pars_fragment,
    envmap_vertex: envmap_vertex,
    fog_vertex: fog_vertex,
    fog_pars_vertex: fog_pars_vertex,
    fog_fragment: fog_fragment,
    fog_pars_fragment: fog_pars_fragment,
    gradientmap_pars_fragment: gradientmap_pars_fragment,
    lightmap_pars_fragment: lightmap_pars_fragment,
    lights_lambert_fragment: lights_lambert_fragment,
    lights_lambert_pars_fragment: lights_lambert_pars_fragment,
    lights_pars_begin: lights_pars_begin,
    lights_toon_fragment: lights_toon_fragment,
    lights_toon_pars_fragment: lights_toon_pars_fragment,
    lights_phong_fragment: lights_phong_fragment,
    lights_phong_pars_fragment: lights_phong_pars_fragment,
    lights_physical_fragment: lights_physical_fragment,
    lights_physical_pars_fragment: lights_physical_pars_fragment,
    lights_fragment_begin: lights_fragment_begin,
    lights_fragment_maps: lights_fragment_maps,
    lights_fragment_end: lights_fragment_end,
    logdepthbuf_fragment: logdepthbuf_fragment,
    logdepthbuf_pars_fragment: logdepthbuf_pars_fragment,
    logdepthbuf_pars_vertex: logdepthbuf_pars_vertex,
    logdepthbuf_vertex: logdepthbuf_vertex,
    map_fragment: map_fragment,
    map_pars_fragment: map_pars_fragment,
    map_particle_fragment: map_particle_fragment,
    map_particle_pars_fragment: map_particle_pars_fragment,
    metalnessmap_fragment: metalnessmap_fragment,
    metalnessmap_pars_fragment: metalnessmap_pars_fragment,
    morphinstance_vertex: morphinstance_vertex,
    morphcolor_vertex: morphcolor_vertex,
    morphnormal_vertex: morphnormal_vertex,
    morphtarget_pars_vertex: morphtarget_pars_vertex,
    morphtarget_vertex: morphtarget_vertex,
    normal_fragment_begin: normal_fragment_begin,
    normal_fragment_maps: normal_fragment_maps,
    normal_pars_fragment: normal_pars_fragment,
    normal_pars_vertex: normal_pars_vertex,
    normal_vertex: normal_vertex,
    normalmap_pars_fragment: normalmap_pars_fragment,
    clearcoat_normal_fragment_begin: clearcoat_normal_fragment_begin,
    clearcoat_normal_fragment_maps: clearcoat_normal_fragment_maps,
    clearcoat_pars_fragment: clearcoat_pars_fragment,
    iridescence_pars_fragment: iridescence_pars_fragment,
    opaque_fragment: opaque_fragment,
    packing: packing,
    premultiplied_alpha_fragment: premultiplied_alpha_fragment,
    project_vertex: project_vertex,
    dithering_fragment: dithering_fragment,
    dithering_pars_fragment: dithering_pars_fragment,
    roughnessmap_fragment: roughnessmap_fragment,
    roughnessmap_pars_fragment: roughnessmap_pars_fragment,
    shadowmap_pars_fragment: shadowmap_pars_fragment,
    shadowmap_pars_vertex: shadowmap_pars_vertex,
    shadowmap_vertex: shadowmap_vertex,
    shadowmask_pars_fragment: shadowmask_pars_fragment,
    skinbase_vertex: skinbase_vertex,
    skinning_pars_vertex: skinning_pars_vertex,
    skinning_vertex: skinning_vertex,
    skinnormal_vertex: skinnormal_vertex,
    specularmap_fragment: specularmap_fragment,
    specularmap_pars_fragment: specularmap_pars_fragment,
    tonemapping_fragment: tonemapping_fragment,
    tonemapping_pars_fragment: tonemapping_pars_fragment,
    transmission_fragment: transmission_fragment,
    transmission_pars_fragment: transmission_pars_fragment,
    uv_pars_fragment: uv_pars_fragment,
    uv_pars_vertex: uv_pars_vertex,
    uv_vertex: uv_vertex,
    worldpos_vertex: worldpos_vertex,
    background_vert: vertex$h,
    background_frag: fragment$h,
    backgroundCube_vert: vertex$g,
    backgroundCube_frag: fragment$g,
    cube_vert: vertex$f,
    cube_frag: fragment$f,
    depth_vert: vertex$e,
    depth_frag: fragment$e,
    distance_vert: vertex$d,
    distance_frag: fragment$d,
    equirect_vert: vertex$c,
    equirect_frag: fragment$c,
    linedashed_vert: vertex$b,
    linedashed_frag: fragment$b,
    meshbasic_vert: vertex$a,
    meshbasic_frag: fragment$a,
    meshlambert_vert: vertex$9,
    meshlambert_frag: fragment$9,
    meshmatcap_vert: vertex$8,
    meshmatcap_frag: fragment$8,
    meshnormal_vert: vertex$7,
    meshnormal_frag: fragment$7,
    meshphong_vert: vertex$6,
    meshphong_frag: fragment$6,
    meshphysical_vert: vertex$5,
    meshphysical_frag: fragment$5,
    meshtoon_vert: vertex$4,
    meshtoon_frag: fragment$4,
    points_vert: vertex$3,
    points_frag: fragment$3,
    shadow_vert: vertex$2,
    shadow_frag: fragment$2,
    sprite_vert: vertex$1,
    sprite_frag: fragment$1
};
// Uniforms library for shared webgl shaders
const UniformsLib = {
    common: {
        diffuse: {
            value: /*@__PURE__*/ new (0, _threeCoreJs.Color)(0xffffff)
        },
        opacity: {
            value: 1.0
        },
        map: {
            value: null
        },
        mapTransform: {
            value: /*@__PURE__*/ new (0, _threeCoreJs.Matrix3)()
        },
        alphaMap: {
            value: null
        },
        alphaMapTransform: {
            value: /*@__PURE__*/ new (0, _threeCoreJs.Matrix3)()
        },
        alphaTest: {
            value: 0
        }
    },
    specularmap: {
        specularMap: {
            value: null
        },
        specularMapTransform: {
            value: /*@__PURE__*/ new (0, _threeCoreJs.Matrix3)()
        }
    },
    envmap: {
        envMap: {
            value: null
        },
        envMapRotation: {
            value: /*@__PURE__*/ new (0, _threeCoreJs.Matrix3)()
        },
        flipEnvMap: {
            value: -1
        },
        reflectivity: {
            value: 1.0
        },
        ior: {
            value: 1.5
        },
        refractionRatio: {
            value: 0.98
        },
        dfgLUT: {
            value: null
        } // DFG LUT for physically-based rendering
    },
    aomap: {
        aoMap: {
            value: null
        },
        aoMapIntensity: {
            value: 1
        },
        aoMapTransform: {
            value: /*@__PURE__*/ new (0, _threeCoreJs.Matrix3)()
        }
    },
    lightmap: {
        lightMap: {
            value: null
        },
        lightMapIntensity: {
            value: 1
        },
        lightMapTransform: {
            value: /*@__PURE__*/ new (0, _threeCoreJs.Matrix3)()
        }
    },
    bumpmap: {
        bumpMap: {
            value: null
        },
        bumpMapTransform: {
            value: /*@__PURE__*/ new (0, _threeCoreJs.Matrix3)()
        },
        bumpScale: {
            value: 1
        }
    },
    normalmap: {
        normalMap: {
            value: null
        },
        normalMapTransform: {
            value: /*@__PURE__*/ new (0, _threeCoreJs.Matrix3)()
        },
        normalScale: {
            value: /*@__PURE__*/ new (0, _threeCoreJs.Vector2)(1, 1)
        }
    },
    displacementmap: {
        displacementMap: {
            value: null
        },
        displacementMapTransform: {
            value: /*@__PURE__*/ new (0, _threeCoreJs.Matrix3)()
        },
        displacementScale: {
            value: 1
        },
        displacementBias: {
            value: 0
        }
    },
    emissivemap: {
        emissiveMap: {
            value: null
        },
        emissiveMapTransform: {
            value: /*@__PURE__*/ new (0, _threeCoreJs.Matrix3)()
        }
    },
    metalnessmap: {
        metalnessMap: {
            value: null
        },
        metalnessMapTransform: {
            value: /*@__PURE__*/ new (0, _threeCoreJs.Matrix3)()
        }
    },
    roughnessmap: {
        roughnessMap: {
            value: null
        },
        roughnessMapTransform: {
            value: /*@__PURE__*/ new (0, _threeCoreJs.Matrix3)()
        }
    },
    gradientmap: {
        gradientMap: {
            value: null
        }
    },
    fog: {
        fogDensity: {
            value: 0.00025
        },
        fogNear: {
            value: 1
        },
        fogFar: {
            value: 2000
        },
        fogColor: {
            value: /*@__PURE__*/ new (0, _threeCoreJs.Color)(0xffffff)
        }
    },
    lights: {
        ambientLightColor: {
            value: []
        },
        lightProbe: {
            value: []
        },
        directionalLights: {
            value: [],
            properties: {
                direction: {},
                color: {}
            }
        },
        directionalLightShadows: {
            value: [],
            properties: {
                shadowIntensity: 1,
                shadowBias: {},
                shadowNormalBias: {},
                shadowRadius: {},
                shadowMapSize: {}
            }
        },
        directionalShadowMap: {
            value: []
        },
        directionalShadowMatrix: {
            value: []
        },
        spotLights: {
            value: [],
            properties: {
                color: {},
                position: {},
                direction: {},
                distance: {},
                coneCos: {},
                penumbraCos: {},
                decay: {}
            }
        },
        spotLightShadows: {
            value: [],
            properties: {
                shadowIntensity: 1,
                shadowBias: {},
                shadowNormalBias: {},
                shadowRadius: {},
                shadowMapSize: {}
            }
        },
        spotLightMap: {
            value: []
        },
        spotShadowMap: {
            value: []
        },
        spotLightMatrix: {
            value: []
        },
        pointLights: {
            value: [],
            properties: {
                color: {},
                position: {},
                decay: {},
                distance: {}
            }
        },
        pointLightShadows: {
            value: [],
            properties: {
                shadowIntensity: 1,
                shadowBias: {},
                shadowNormalBias: {},
                shadowRadius: {},
                shadowMapSize: {},
                shadowCameraNear: {},
                shadowCameraFar: {}
            }
        },
        pointShadowMap: {
            value: []
        },
        pointShadowMatrix: {
            value: []
        },
        hemisphereLights: {
            value: [],
            properties: {
                direction: {},
                skyColor: {},
                groundColor: {}
            }
        },
        // TODO (abelnation): RectAreaLight BRDF data needs to be moved from example to main src
        rectAreaLights: {
            value: [],
            properties: {
                color: {},
                position: {},
                width: {},
                height: {}
            }
        },
        ltc_1: {
            value: null
        },
        ltc_2: {
            value: null
        }
    },
    points: {
        diffuse: {
            value: /*@__PURE__*/ new (0, _threeCoreJs.Color)(0xffffff)
        },
        opacity: {
            value: 1.0
        },
        size: {
            value: 1.0
        },
        scale: {
            value: 1.0
        },
        map: {
            value: null
        },
        alphaMap: {
            value: null
        },
        alphaMapTransform: {
            value: /*@__PURE__*/ new (0, _threeCoreJs.Matrix3)()
        },
        alphaTest: {
            value: 0
        },
        uvTransform: {
            value: /*@__PURE__*/ new (0, _threeCoreJs.Matrix3)()
        }
    },
    sprite: {
        diffuse: {
            value: /*@__PURE__*/ new (0, _threeCoreJs.Color)(0xffffff)
        },
        opacity: {
            value: 1.0
        },
        center: {
            value: /*@__PURE__*/ new (0, _threeCoreJs.Vector2)(0.5, 0.5)
        },
        rotation: {
            value: 0.0
        },
        map: {
            value: null
        },
        mapTransform: {
            value: /*@__PURE__*/ new (0, _threeCoreJs.Matrix3)()
        },
        alphaMap: {
            value: null
        },
        alphaMapTransform: {
            value: /*@__PURE__*/ new (0, _threeCoreJs.Matrix3)()
        },
        alphaTest: {
            value: 0
        }
    }
};
const ShaderLib = {
    basic: {
        uniforms: /*@__PURE__*/ (0, _threeCoreJs.mergeUniforms)([
            UniformsLib.common,
            UniformsLib.specularmap,
            UniformsLib.envmap,
            UniformsLib.aomap,
            UniformsLib.lightmap,
            UniformsLib.fog
        ]),
        vertexShader: ShaderChunk.meshbasic_vert,
        fragmentShader: ShaderChunk.meshbasic_frag
    },
    lambert: {
        uniforms: /*@__PURE__*/ (0, _threeCoreJs.mergeUniforms)([
            UniformsLib.common,
            UniformsLib.specularmap,
            UniformsLib.envmap,
            UniformsLib.aomap,
            UniformsLib.lightmap,
            UniformsLib.emissivemap,
            UniformsLib.bumpmap,
            UniformsLib.normalmap,
            UniformsLib.displacementmap,
            UniformsLib.fog,
            UniformsLib.lights,
            {
                emissive: {
                    value: /*@__PURE__*/ new (0, _threeCoreJs.Color)(0x000000)
                }
            }
        ]),
        vertexShader: ShaderChunk.meshlambert_vert,
        fragmentShader: ShaderChunk.meshlambert_frag
    },
    phong: {
        uniforms: /*@__PURE__*/ (0, _threeCoreJs.mergeUniforms)([
            UniformsLib.common,
            UniformsLib.specularmap,
            UniformsLib.envmap,
            UniformsLib.aomap,
            UniformsLib.lightmap,
            UniformsLib.emissivemap,
            UniformsLib.bumpmap,
            UniformsLib.normalmap,
            UniformsLib.displacementmap,
            UniformsLib.fog,
            UniformsLib.lights,
            {
                emissive: {
                    value: /*@__PURE__*/ new (0, _threeCoreJs.Color)(0x000000)
                },
                specular: {
                    value: /*@__PURE__*/ new (0, _threeCoreJs.Color)(0x111111)
                },
                shininess: {
                    value: 30
                }
            }
        ]),
        vertexShader: ShaderChunk.meshphong_vert,
        fragmentShader: ShaderChunk.meshphong_frag
    },
    standard: {
        uniforms: /*@__PURE__*/ (0, _threeCoreJs.mergeUniforms)([
            UniformsLib.common,
            UniformsLib.envmap,
            UniformsLib.aomap,
            UniformsLib.lightmap,
            UniformsLib.emissivemap,
            UniformsLib.bumpmap,
            UniformsLib.normalmap,
            UniformsLib.displacementmap,
            UniformsLib.roughnessmap,
            UniformsLib.metalnessmap,
            UniformsLib.fog,
            UniformsLib.lights,
            {
                emissive: {
                    value: /*@__PURE__*/ new (0, _threeCoreJs.Color)(0x000000)
                },
                roughness: {
                    value: 1.0
                },
                metalness: {
                    value: 0.0
                },
                envMapIntensity: {
                    value: 1
                }
            }
        ]),
        vertexShader: ShaderChunk.meshphysical_vert,
        fragmentShader: ShaderChunk.meshphysical_frag
    },
    toon: {
        uniforms: /*@__PURE__*/ (0, _threeCoreJs.mergeUniforms)([
            UniformsLib.common,
            UniformsLib.aomap,
            UniformsLib.lightmap,
            UniformsLib.emissivemap,
            UniformsLib.bumpmap,
            UniformsLib.normalmap,
            UniformsLib.displacementmap,
            UniformsLib.gradientmap,
            UniformsLib.fog,
            UniformsLib.lights,
            {
                emissive: {
                    value: /*@__PURE__*/ new (0, _threeCoreJs.Color)(0x000000)
                }
            }
        ]),
        vertexShader: ShaderChunk.meshtoon_vert,
        fragmentShader: ShaderChunk.meshtoon_frag
    },
    matcap: {
        uniforms: /*@__PURE__*/ (0, _threeCoreJs.mergeUniforms)([
            UniformsLib.common,
            UniformsLib.bumpmap,
            UniformsLib.normalmap,
            UniformsLib.displacementmap,
            UniformsLib.fog,
            {
                matcap: {
                    value: null
                }
            }
        ]),
        vertexShader: ShaderChunk.meshmatcap_vert,
        fragmentShader: ShaderChunk.meshmatcap_frag
    },
    points: {
        uniforms: /*@__PURE__*/ (0, _threeCoreJs.mergeUniforms)([
            UniformsLib.points,
            UniformsLib.fog
        ]),
        vertexShader: ShaderChunk.points_vert,
        fragmentShader: ShaderChunk.points_frag
    },
    dashed: {
        uniforms: /*@__PURE__*/ (0, _threeCoreJs.mergeUniforms)([
            UniformsLib.common,
            UniformsLib.fog,
            {
                scale: {
                    value: 1
                },
                dashSize: {
                    value: 1
                },
                totalSize: {
                    value: 2
                }
            }
        ]),
        vertexShader: ShaderChunk.linedashed_vert,
        fragmentShader: ShaderChunk.linedashed_frag
    },
    depth: {
        uniforms: /*@__PURE__*/ (0, _threeCoreJs.mergeUniforms)([
            UniformsLib.common,
            UniformsLib.displacementmap
        ]),
        vertexShader: ShaderChunk.depth_vert,
        fragmentShader: ShaderChunk.depth_frag
    },
    normal: {
        uniforms: /*@__PURE__*/ (0, _threeCoreJs.mergeUniforms)([
            UniformsLib.common,
            UniformsLib.bumpmap,
            UniformsLib.normalmap,
            UniformsLib.displacementmap,
            {
                opacity: {
                    value: 1.0
                }
            }
        ]),
        vertexShader: ShaderChunk.meshnormal_vert,
        fragmentShader: ShaderChunk.meshnormal_frag
    },
    sprite: {
        uniforms: /*@__PURE__*/ (0, _threeCoreJs.mergeUniforms)([
            UniformsLib.sprite,
            UniformsLib.fog
        ]),
        vertexShader: ShaderChunk.sprite_vert,
        fragmentShader: ShaderChunk.sprite_frag
    },
    background: {
        uniforms: {
            uvTransform: {
                value: /*@__PURE__*/ new (0, _threeCoreJs.Matrix3)()
            },
            t2D: {
                value: null
            },
            backgroundIntensity: {
                value: 1
            }
        },
        vertexShader: ShaderChunk.background_vert,
        fragmentShader: ShaderChunk.background_frag
    },
    backgroundCube: {
        uniforms: {
            envMap: {
                value: null
            },
            flipEnvMap: {
                value: -1
            },
            backgroundBlurriness: {
                value: 0
            },
            backgroundIntensity: {
                value: 1
            },
            backgroundRotation: {
                value: /*@__PURE__*/ new (0, _threeCoreJs.Matrix3)()
            }
        },
        vertexShader: ShaderChunk.backgroundCube_vert,
        fragmentShader: ShaderChunk.backgroundCube_frag
    },
    cube: {
        uniforms: {
            tCube: {
                value: null
            },
            tFlip: {
                value: -1
            },
            opacity: {
                value: 1.0
            }
        },
        vertexShader: ShaderChunk.cube_vert,
        fragmentShader: ShaderChunk.cube_frag
    },
    equirect: {
        uniforms: {
            tEquirect: {
                value: null
            }
        },
        vertexShader: ShaderChunk.equirect_vert,
        fragmentShader: ShaderChunk.equirect_frag
    },
    distance: {
        uniforms: /*@__PURE__*/ (0, _threeCoreJs.mergeUniforms)([
            UniformsLib.common,
            UniformsLib.displacementmap,
            {
                referencePosition: {
                    value: /*@__PURE__*/ new (0, _threeCoreJs.Vector3)()
                },
                nearDistance: {
                    value: 1
                },
                farDistance: {
                    value: 1000
                }
            }
        ]),
        vertexShader: ShaderChunk.distance_vert,
        fragmentShader: ShaderChunk.distance_frag
    },
    shadow: {
        uniforms: /*@__PURE__*/ (0, _threeCoreJs.mergeUniforms)([
            UniformsLib.lights,
            UniformsLib.fog,
            {
                color: {
                    value: /*@__PURE__*/ new (0, _threeCoreJs.Color)(0x00000)
                },
                opacity: {
                    value: 1.0
                }
            }
        ]),
        vertexShader: ShaderChunk.shadow_vert,
        fragmentShader: ShaderChunk.shadow_frag
    }
};
ShaderLib.physical = {
    uniforms: /*@__PURE__*/ (0, _threeCoreJs.mergeUniforms)([
        ShaderLib.standard.uniforms,
        {
            clearcoat: {
                value: 0
            },
            clearcoatMap: {
                value: null
            },
            clearcoatMapTransform: {
                value: /*@__PURE__*/ new (0, _threeCoreJs.Matrix3)()
            },
            clearcoatNormalMap: {
                value: null
            },
            clearcoatNormalMapTransform: {
                value: /*@__PURE__*/ new (0, _threeCoreJs.Matrix3)()
            },
            clearcoatNormalScale: {
                value: /*@__PURE__*/ new (0, _threeCoreJs.Vector2)(1, 1)
            },
            clearcoatRoughness: {
                value: 0
            },
            clearcoatRoughnessMap: {
                value: null
            },
            clearcoatRoughnessMapTransform: {
                value: /*@__PURE__*/ new (0, _threeCoreJs.Matrix3)()
            },
            dispersion: {
                value: 0
            },
            iridescence: {
                value: 0
            },
            iridescenceMap: {
                value: null
            },
            iridescenceMapTransform: {
                value: /*@__PURE__*/ new (0, _threeCoreJs.Matrix3)()
            },
            iridescenceIOR: {
                value: 1.3
            },
            iridescenceThicknessMinimum: {
                value: 100
            },
            iridescenceThicknessMaximum: {
                value: 400
            },
            iridescenceThicknessMap: {
                value: null
            },
            iridescenceThicknessMapTransform: {
                value: /*@__PURE__*/ new (0, _threeCoreJs.Matrix3)()
            },
            sheen: {
                value: 0
            },
            sheenColor: {
                value: /*@__PURE__*/ new (0, _threeCoreJs.Color)(0x000000)
            },
            sheenColorMap: {
                value: null
            },
            sheenColorMapTransform: {
                value: /*@__PURE__*/ new (0, _threeCoreJs.Matrix3)()
            },
            sheenRoughness: {
                value: 1
            },
            sheenRoughnessMap: {
                value: null
            },
            sheenRoughnessMapTransform: {
                value: /*@__PURE__*/ new (0, _threeCoreJs.Matrix3)()
            },
            transmission: {
                value: 0
            },
            transmissionMap: {
                value: null
            },
            transmissionMapTransform: {
                value: /*@__PURE__*/ new (0, _threeCoreJs.Matrix3)()
            },
            transmissionSamplerSize: {
                value: /*@__PURE__*/ new (0, _threeCoreJs.Vector2)()
            },
            transmissionSamplerMap: {
                value: null
            },
            thickness: {
                value: 0
            },
            thicknessMap: {
                value: null
            },
            thicknessMapTransform: {
                value: /*@__PURE__*/ new (0, _threeCoreJs.Matrix3)()
            },
            attenuationDistance: {
                value: 0
            },
            attenuationColor: {
                value: /*@__PURE__*/ new (0, _threeCoreJs.Color)(0x000000)
            },
            specularColor: {
                value: /*@__PURE__*/ new (0, _threeCoreJs.Color)(1, 1, 1)
            },
            specularColorMap: {
                value: null
            },
            specularColorMapTransform: {
                value: /*@__PURE__*/ new (0, _threeCoreJs.Matrix3)()
            },
            specularIntensity: {
                value: 1
            },
            specularIntensityMap: {
                value: null
            },
            specularIntensityMapTransform: {
                value: /*@__PURE__*/ new (0, _threeCoreJs.Matrix3)()
            },
            anisotropyVector: {
                value: /*@__PURE__*/ new (0, _threeCoreJs.Vector2)()
            },
            anisotropyMap: {
                value: null
            },
            anisotropyMapTransform: {
                value: /*@__PURE__*/ new (0, _threeCoreJs.Matrix3)()
            }
        }
    ]),
    vertexShader: ShaderChunk.meshphysical_vert,
    fragmentShader: ShaderChunk.meshphysical_frag
};
const _rgb = {
    r: 0,
    b: 0,
    g: 0
};
const _e1$1 = /*@__PURE__*/ new (0, _threeCoreJs.Euler)();
const _m1$1 = /*@__PURE__*/ new (0, _threeCoreJs.Matrix4)();
function WebGLBackground(renderer, cubemaps, cubeuvmaps, state, objects, alpha, premultipliedAlpha) {
    const clearColor = new (0, _threeCoreJs.Color)(0x000000);
    let clearAlpha = alpha === true ? 0 : 1;
    let planeMesh;
    let boxMesh;
    let currentBackground = null;
    let currentBackgroundVersion = 0;
    let currentTonemapping = null;
    function getBackground(scene) {
        let background = scene.isScene === true ? scene.background : null;
        if (background && background.isTexture) {
            const usePMREM = scene.backgroundBlurriness > 0; // use PMREM if the user wants to blur the background
            background = (usePMREM ? cubeuvmaps : cubemaps).get(background);
        }
        return background;
    }
    function render(scene) {
        let forceClear = false;
        const background = getBackground(scene);
        if (background === null) setClear(clearColor, clearAlpha);
        else if (background && background.isColor) {
            setClear(background, 1);
            forceClear = true;
        }
        const environmentBlendMode = renderer.xr.getEnvironmentBlendMode();
        if (environmentBlendMode === 'additive') state.buffers.color.setClear(0, 0, 0, 1, premultipliedAlpha);
        else if (environmentBlendMode === 'alpha-blend') state.buffers.color.setClear(0, 0, 0, 0, premultipliedAlpha);
        if (renderer.autoClear || forceClear) {
            // buffers might not be writable which is required to ensure a correct clear
            state.buffers.depth.setTest(true);
            state.buffers.depth.setMask(true);
            state.buffers.color.setMask(true);
            renderer.clear(renderer.autoClearColor, renderer.autoClearDepth, renderer.autoClearStencil);
        }
    }
    function addToRenderList(renderList, scene) {
        const background = getBackground(scene);
        if (background && (background.isCubeTexture || background.mapping === (0, _threeCoreJs.CubeUVReflectionMapping))) {
            if (boxMesh === undefined) {
                boxMesh = new (0, _threeCoreJs.Mesh)(new (0, _threeCoreJs.BoxGeometry)(1, 1, 1), new (0, _threeCoreJs.ShaderMaterial)({
                    name: 'BackgroundCubeMaterial',
                    uniforms: (0, _threeCoreJs.cloneUniforms)(ShaderLib.backgroundCube.uniforms),
                    vertexShader: ShaderLib.backgroundCube.vertexShader,
                    fragmentShader: ShaderLib.backgroundCube.fragmentShader,
                    side: (0, _threeCoreJs.BackSide),
                    depthTest: false,
                    depthWrite: false,
                    fog: false,
                    allowOverride: false
                }));
                boxMesh.geometry.deleteAttribute('normal');
                boxMesh.geometry.deleteAttribute('uv');
                boxMesh.onBeforeRender = function(renderer, scene, camera) {
                    this.matrixWorld.copyPosition(camera.matrixWorld);
                };
                // add "envMap" material property so the renderer can evaluate it like for built-in materials
                Object.defineProperty(boxMesh.material, 'envMap', {
                    get: function() {
                        return this.uniforms.envMap.value;
                    }
                });
                objects.update(boxMesh);
            }
            _e1$1.copy(scene.backgroundRotation);
            // accommodate left-handed frame
            _e1$1.x *= -1;
            _e1$1.y *= -1;
            _e1$1.z *= -1;
            if (background.isCubeTexture && background.isRenderTargetTexture === false) {
                // environment maps which are not cube render targets or PMREMs follow a different convention
                _e1$1.y *= -1;
                _e1$1.z *= -1;
            }
            boxMesh.material.uniforms.envMap.value = background;
            boxMesh.material.uniforms.flipEnvMap.value = background.isCubeTexture && background.isRenderTargetTexture === false ? -1 : 1;
            boxMesh.material.uniforms.backgroundBlurriness.value = scene.backgroundBlurriness;
            boxMesh.material.uniforms.backgroundIntensity.value = scene.backgroundIntensity;
            boxMesh.material.uniforms.backgroundRotation.value.setFromMatrix4(_m1$1.makeRotationFromEuler(_e1$1));
            boxMesh.material.toneMapped = (0, _threeCoreJs.ColorManagement).getTransfer(background.colorSpace) !== (0, _threeCoreJs.SRGBTransfer);
            if (currentBackground !== background || currentBackgroundVersion !== background.version || currentTonemapping !== renderer.toneMapping) {
                boxMesh.material.needsUpdate = true;
                currentBackground = background;
                currentBackgroundVersion = background.version;
                currentTonemapping = renderer.toneMapping;
            }
            boxMesh.layers.enableAll();
            // push to the pre-sorted opaque render list
            renderList.unshift(boxMesh, boxMesh.geometry, boxMesh.material, 0, 0, null);
        } else if (background && background.isTexture) {
            if (planeMesh === undefined) {
                planeMesh = new (0, _threeCoreJs.Mesh)(new (0, _threeCoreJs.PlaneGeometry)(2, 2), new (0, _threeCoreJs.ShaderMaterial)({
                    name: 'BackgroundMaterial',
                    uniforms: (0, _threeCoreJs.cloneUniforms)(ShaderLib.background.uniforms),
                    vertexShader: ShaderLib.background.vertexShader,
                    fragmentShader: ShaderLib.background.fragmentShader,
                    side: (0, _threeCoreJs.FrontSide),
                    depthTest: false,
                    depthWrite: false,
                    fog: false,
                    allowOverride: false
                }));
                planeMesh.geometry.deleteAttribute('normal');
                // add "map" material property so the renderer can evaluate it like for built-in materials
                Object.defineProperty(planeMesh.material, 'map', {
                    get: function() {
                        return this.uniforms.t2D.value;
                    }
                });
                objects.update(planeMesh);
            }
            planeMesh.material.uniforms.t2D.value = background;
            planeMesh.material.uniforms.backgroundIntensity.value = scene.backgroundIntensity;
            planeMesh.material.toneMapped = (0, _threeCoreJs.ColorManagement).getTransfer(background.colorSpace) !== (0, _threeCoreJs.SRGBTransfer);
            if (background.matrixAutoUpdate === true) background.updateMatrix();
            planeMesh.material.uniforms.uvTransform.value.copy(background.matrix);
            if (currentBackground !== background || currentBackgroundVersion !== background.version || currentTonemapping !== renderer.toneMapping) {
                planeMesh.material.needsUpdate = true;
                currentBackground = background;
                currentBackgroundVersion = background.version;
                currentTonemapping = renderer.toneMapping;
            }
            planeMesh.layers.enableAll();
            // push to the pre-sorted opaque render list
            renderList.unshift(planeMesh, planeMesh.geometry, planeMesh.material, 0, 0, null);
        }
    }
    function setClear(color, alpha) {
        color.getRGB(_rgb, (0, _threeCoreJs.getUnlitUniformColorSpace)(renderer));
        state.buffers.color.setClear(_rgb.r, _rgb.g, _rgb.b, alpha, premultipliedAlpha);
    }
    function dispose() {
        if (boxMesh !== undefined) {
            boxMesh.geometry.dispose();
            boxMesh.material.dispose();
            boxMesh = undefined;
        }
        if (planeMesh !== undefined) {
            planeMesh.geometry.dispose();
            planeMesh.material.dispose();
            planeMesh = undefined;
        }
    }
    return {
        getClearColor: function() {
            return clearColor;
        },
        setClearColor: function(color, alpha = 1) {
            clearColor.set(color);
            clearAlpha = alpha;
            setClear(clearColor, clearAlpha);
        },
        getClearAlpha: function() {
            return clearAlpha;
        },
        setClearAlpha: function(alpha) {
            clearAlpha = alpha;
            setClear(clearColor, clearAlpha);
        },
        render: render,
        addToRenderList: addToRenderList,
        dispose: dispose
    };
}
function WebGLBindingStates(gl, attributes) {
    const maxVertexAttributes = gl.getParameter(gl.MAX_VERTEX_ATTRIBS);
    const bindingStates = {};
    const defaultState = createBindingState(null);
    let currentState = defaultState;
    let forceUpdate = false;
    function setup(object, material, program, geometry, index) {
        let updateBuffers = false;
        const state = getBindingState(geometry, program, material);
        if (currentState !== state) {
            currentState = state;
            bindVertexArrayObject(currentState.object);
        }
        updateBuffers = needsUpdate(object, geometry, program, index);
        if (updateBuffers) saveCache(object, geometry, program, index);
        if (index !== null) attributes.update(index, gl.ELEMENT_ARRAY_BUFFER);
        if (updateBuffers || forceUpdate) {
            forceUpdate = false;
            setupVertexAttributes(object, material, program, geometry);
            if (index !== null) gl.bindBuffer(gl.ELEMENT_ARRAY_BUFFER, attributes.get(index).buffer);
        }
    }
    function createVertexArrayObject() {
        return gl.createVertexArray();
    }
    function bindVertexArrayObject(vao) {
        return gl.bindVertexArray(vao);
    }
    function deleteVertexArrayObject(vao) {
        return gl.deleteVertexArray(vao);
    }
    function getBindingState(geometry, program, material) {
        const wireframe = material.wireframe === true;
        let programMap = bindingStates[geometry.id];
        if (programMap === undefined) {
            programMap = {};
            bindingStates[geometry.id] = programMap;
        }
        let stateMap = programMap[program.id];
        if (stateMap === undefined) {
            stateMap = {};
            programMap[program.id] = stateMap;
        }
        let state = stateMap[wireframe];
        if (state === undefined) {
            state = createBindingState(createVertexArrayObject());
            stateMap[wireframe] = state;
        }
        return state;
    }
    function createBindingState(vao) {
        const newAttributes = [];
        const enabledAttributes = [];
        const attributeDivisors = [];
        for(let i = 0; i < maxVertexAttributes; i++){
            newAttributes[i] = 0;
            enabledAttributes[i] = 0;
            attributeDivisors[i] = 0;
        }
        return {
            // for backward compatibility on non-VAO support browser
            geometry: null,
            program: null,
            wireframe: false,
            newAttributes: newAttributes,
            enabledAttributes: enabledAttributes,
            attributeDivisors: attributeDivisors,
            object: vao,
            attributes: {},
            index: null
        };
    }
    function needsUpdate(object, geometry, program, index) {
        const cachedAttributes = currentState.attributes;
        const geometryAttributes = geometry.attributes;
        let attributesNum = 0;
        const programAttributes = program.getAttributes();
        for(const name in programAttributes){
            const programAttribute = programAttributes[name];
            if (programAttribute.location >= 0) {
                const cachedAttribute = cachedAttributes[name];
                let geometryAttribute = geometryAttributes[name];
                if (geometryAttribute === undefined) {
                    if (name === 'instanceMatrix' && object.instanceMatrix) geometryAttribute = object.instanceMatrix;
                    if (name === 'instanceColor' && object.instanceColor) geometryAttribute = object.instanceColor;
                }
                if (cachedAttribute === undefined) return true;
                if (cachedAttribute.attribute !== geometryAttribute) return true;
                if (geometryAttribute && cachedAttribute.data !== geometryAttribute.data) return true;
                attributesNum++;
            }
        }
        if (currentState.attributesNum !== attributesNum) return true;
        if (currentState.index !== index) return true;
        return false;
    }
    function saveCache(object, geometry, program, index) {
        const cache = {};
        const attributes = geometry.attributes;
        let attributesNum = 0;
        const programAttributes = program.getAttributes();
        for(const name in programAttributes){
            const programAttribute = programAttributes[name];
            if (programAttribute.location >= 0) {
                let attribute = attributes[name];
                if (attribute === undefined) {
                    if (name === 'instanceMatrix' && object.instanceMatrix) attribute = object.instanceMatrix;
                    if (name === 'instanceColor' && object.instanceColor) attribute = object.instanceColor;
                }
                const data = {};
                data.attribute = attribute;
                if (attribute && attribute.data) data.data = attribute.data;
                cache[name] = data;
                attributesNum++;
            }
        }
        currentState.attributes = cache;
        currentState.attributesNum = attributesNum;
        currentState.index = index;
    }
    function initAttributes() {
        const newAttributes = currentState.newAttributes;
        for(let i = 0, il = newAttributes.length; i < il; i++)newAttributes[i] = 0;
    }
    function enableAttribute(attribute) {
        enableAttributeAndDivisor(attribute, 0);
    }
    function enableAttributeAndDivisor(attribute, meshPerAttribute) {
        const newAttributes = currentState.newAttributes;
        const enabledAttributes = currentState.enabledAttributes;
        const attributeDivisors = currentState.attributeDivisors;
        newAttributes[attribute] = 1;
        if (enabledAttributes[attribute] === 0) {
            gl.enableVertexAttribArray(attribute);
            enabledAttributes[attribute] = 1;
        }
        if (attributeDivisors[attribute] !== meshPerAttribute) {
            gl.vertexAttribDivisor(attribute, meshPerAttribute);
            attributeDivisors[attribute] = meshPerAttribute;
        }
    }
    function disableUnusedAttributes() {
        const newAttributes = currentState.newAttributes;
        const enabledAttributes = currentState.enabledAttributes;
        for(let i = 0, il = enabledAttributes.length; i < il; i++)if (enabledAttributes[i] !== newAttributes[i]) {
            gl.disableVertexAttribArray(i);
            enabledAttributes[i] = 0;
        }
    }
    function vertexAttribPointer(index, size, type, normalized, stride, offset, integer) {
        if (integer === true) gl.vertexAttribIPointer(index, size, type, stride, offset);
        else gl.vertexAttribPointer(index, size, type, normalized, stride, offset);
    }
    function setupVertexAttributes(object, material, program, geometry) {
        initAttributes();
        const geometryAttributes = geometry.attributes;
        const programAttributes = program.getAttributes();
        const materialDefaultAttributeValues = material.defaultAttributeValues;
        for(const name in programAttributes){
            const programAttribute = programAttributes[name];
            if (programAttribute.location >= 0) {
                let geometryAttribute = geometryAttributes[name];
                if (geometryAttribute === undefined) {
                    if (name === 'instanceMatrix' && object.instanceMatrix) geometryAttribute = object.instanceMatrix;
                    if (name === 'instanceColor' && object.instanceColor) geometryAttribute = object.instanceColor;
                }
                if (geometryAttribute !== undefined) {
                    const normalized = geometryAttribute.normalized;
                    const size = geometryAttribute.itemSize;
                    const attribute = attributes.get(geometryAttribute);
                    // TODO Attribute may not be available on context restore
                    if (attribute === undefined) continue;
                    const buffer = attribute.buffer;
                    const type = attribute.type;
                    const bytesPerElement = attribute.bytesPerElement;
                    // check for integer attributes
                    const integer = type === gl.INT || type === gl.UNSIGNED_INT || geometryAttribute.gpuType === (0, _threeCoreJs.IntType);
                    if (geometryAttribute.isInterleavedBufferAttribute) {
                        const data = geometryAttribute.data;
                        const stride = data.stride;
                        const offset = geometryAttribute.offset;
                        if (data.isInstancedInterleavedBuffer) {
                            for(let i = 0; i < programAttribute.locationSize; i++)enableAttributeAndDivisor(programAttribute.location + i, data.meshPerAttribute);
                            if (object.isInstancedMesh !== true && geometry._maxInstanceCount === undefined) geometry._maxInstanceCount = data.meshPerAttribute * data.count;
                        } else for(let i = 0; i < programAttribute.locationSize; i++)enableAttribute(programAttribute.location + i);
                        gl.bindBuffer(gl.ARRAY_BUFFER, buffer);
                        for(let i = 0; i < programAttribute.locationSize; i++)vertexAttribPointer(programAttribute.location + i, size / programAttribute.locationSize, type, normalized, stride * bytesPerElement, (offset + size / programAttribute.locationSize * i) * bytesPerElement, integer);
                    } else {
                        if (geometryAttribute.isInstancedBufferAttribute) {
                            for(let i = 0; i < programAttribute.locationSize; i++)enableAttributeAndDivisor(programAttribute.location + i, geometryAttribute.meshPerAttribute);
                            if (object.isInstancedMesh !== true && geometry._maxInstanceCount === undefined) geometry._maxInstanceCount = geometryAttribute.meshPerAttribute * geometryAttribute.count;
                        } else for(let i = 0; i < programAttribute.locationSize; i++)enableAttribute(programAttribute.location + i);
                        gl.bindBuffer(gl.ARRAY_BUFFER, buffer);
                        for(let i = 0; i < programAttribute.locationSize; i++)vertexAttribPointer(programAttribute.location + i, size / programAttribute.locationSize, type, normalized, size * bytesPerElement, size / programAttribute.locationSize * i * bytesPerElement, integer);
                    }
                } else if (materialDefaultAttributeValues !== undefined) {
                    const value = materialDefaultAttributeValues[name];
                    if (value !== undefined) switch(value.length){
                        case 2:
                            gl.vertexAttrib2fv(programAttribute.location, value);
                            break;
                        case 3:
                            gl.vertexAttrib3fv(programAttribute.location, value);
                            break;
                        case 4:
                            gl.vertexAttrib4fv(programAttribute.location, value);
                            break;
                        default:
                            gl.vertexAttrib1fv(programAttribute.location, value);
                    }
                }
            }
        }
        disableUnusedAttributes();
    }
    function dispose() {
        reset();
        for(const geometryId in bindingStates){
            const programMap = bindingStates[geometryId];
            for(const programId in programMap){
                const stateMap = programMap[programId];
                for(const wireframe in stateMap){
                    deleteVertexArrayObject(stateMap[wireframe].object);
                    delete stateMap[wireframe];
                }
                delete programMap[programId];
            }
            delete bindingStates[geometryId];
        }
    }
    function releaseStatesOfGeometry(geometry) {
        if (bindingStates[geometry.id] === undefined) return;
        const programMap = bindingStates[geometry.id];
        for(const programId in programMap){
            const stateMap = programMap[programId];
            for(const wireframe in stateMap){
                deleteVertexArrayObject(stateMap[wireframe].object);
                delete stateMap[wireframe];
            }
            delete programMap[programId];
        }
        delete bindingStates[geometry.id];
    }
    function releaseStatesOfProgram(program) {
        for(const geometryId in bindingStates){
            const programMap = bindingStates[geometryId];
            if (programMap[program.id] === undefined) continue;
            const stateMap = programMap[program.id];
            for(const wireframe in stateMap){
                deleteVertexArrayObject(stateMap[wireframe].object);
                delete stateMap[wireframe];
            }
            delete programMap[program.id];
        }
    }
    function reset() {
        resetDefaultState();
        forceUpdate = true;
        if (currentState === defaultState) return;
        currentState = defaultState;
        bindVertexArrayObject(currentState.object);
    }
    // for backward-compatibility
    function resetDefaultState() {
        defaultState.geometry = null;
        defaultState.program = null;
        defaultState.wireframe = false;
    }
    return {
        setup: setup,
        reset: reset,
        resetDefaultState: resetDefaultState,
        dispose: dispose,
        releaseStatesOfGeometry: releaseStatesOfGeometry,
        releaseStatesOfProgram: releaseStatesOfProgram,
        initAttributes: initAttributes,
        enableAttribute: enableAttribute,
        disableUnusedAttributes: disableUnusedAttributes
    };
}
function WebGLBufferRenderer(gl, extensions, info) {
    let mode;
    function setMode(value) {
        mode = value;
    }
    function render(start, count) {
        gl.drawArrays(mode, start, count);
        info.update(count, mode, 1);
    }
    function renderInstances(start, count, primcount) {
        if (primcount === 0) return;
        gl.drawArraysInstanced(mode, start, count, primcount);
        info.update(count, mode, primcount);
    }
    function renderMultiDraw(starts, counts, drawCount) {
        if (drawCount === 0) return;
        const extension = extensions.get('WEBGL_multi_draw');
        extension.multiDrawArraysWEBGL(mode, starts, 0, counts, 0, drawCount);
        let elementCount = 0;
        for(let i = 0; i < drawCount; i++)elementCount += counts[i];
        info.update(elementCount, mode, 1);
    }
    function renderMultiDrawInstances(starts, counts, drawCount, primcount) {
        if (drawCount === 0) return;
        const extension = extensions.get('WEBGL_multi_draw');
        if (extension === null) for(let i = 0; i < starts.length; i++)renderInstances(starts[i], counts[i], primcount[i]);
        else {
            extension.multiDrawArraysInstancedWEBGL(mode, starts, 0, counts, 0, primcount, 0, drawCount);
            let elementCount = 0;
            for(let i = 0; i < drawCount; i++)elementCount += counts[i] * primcount[i];
            info.update(elementCount, mode, 1);
        }
    }
    //
    this.setMode = setMode;
    this.render = render;
    this.renderInstances = renderInstances;
    this.renderMultiDraw = renderMultiDraw;
    this.renderMultiDrawInstances = renderMultiDrawInstances;
}
function WebGLCapabilities(gl, extensions, parameters, utils) {
    let maxAnisotropy;
    function getMaxAnisotropy() {
        if (maxAnisotropy !== undefined) return maxAnisotropy;
        if (extensions.has('EXT_texture_filter_anisotropic') === true) {
            const extension = extensions.get('EXT_texture_filter_anisotropic');
            maxAnisotropy = gl.getParameter(extension.MAX_TEXTURE_MAX_ANISOTROPY_EXT);
        } else maxAnisotropy = 0;
        return maxAnisotropy;
    }
    function textureFormatReadable(textureFormat) {
        if (textureFormat !== (0, _threeCoreJs.RGBAFormat) && utils.convert(textureFormat) !== gl.getParameter(gl.IMPLEMENTATION_COLOR_READ_FORMAT)) return false;
        return true;
    }
    function textureTypeReadable(textureType) {
        const halfFloatSupportedByExt = textureType === (0, _threeCoreJs.HalfFloatType) && (extensions.has('EXT_color_buffer_half_float') || extensions.has('EXT_color_buffer_float'));
        if (textureType !== (0, _threeCoreJs.UnsignedByteType) && utils.convert(textureType) !== gl.getParameter(gl.IMPLEMENTATION_COLOR_READ_TYPE) && // Edge and Chrome Mac < 52 (#9513)
        textureType !== (0, _threeCoreJs.FloatType) && !halfFloatSupportedByExt) return false;
        return true;
    }
    function getMaxPrecision(precision) {
        if (precision === 'highp') {
            if (gl.getShaderPrecisionFormat(gl.VERTEX_SHADER, gl.HIGH_FLOAT).precision > 0 && gl.getShaderPrecisionFormat(gl.FRAGMENT_SHADER, gl.HIGH_FLOAT).precision > 0) return 'highp';
            precision = 'mediump';
        }
        if (precision === 'mediump') {
            if (gl.getShaderPrecisionFormat(gl.VERTEX_SHADER, gl.MEDIUM_FLOAT).precision > 0 && gl.getShaderPrecisionFormat(gl.FRAGMENT_SHADER, gl.MEDIUM_FLOAT).precision > 0) return 'mediump';
        }
        return 'lowp';
    }
    let precision = parameters.precision !== undefined ? parameters.precision : 'highp';
    const maxPrecision = getMaxPrecision(precision);
    if (maxPrecision !== precision) {
        (0, _threeCoreJs.warn)('WebGLRenderer:', precision, 'not supported, using', maxPrecision, 'instead.');
        precision = maxPrecision;
    }
    const logarithmicDepthBuffer = parameters.logarithmicDepthBuffer === true;
    const reversedDepthBuffer = parameters.reversedDepthBuffer === true && extensions.has('EXT_clip_control');
    const maxTextures = gl.getParameter(gl.MAX_TEXTURE_IMAGE_UNITS);
    const maxVertexTextures = gl.getParameter(gl.MAX_VERTEX_TEXTURE_IMAGE_UNITS);
    const maxTextureSize = gl.getParameter(gl.MAX_TEXTURE_SIZE);
    const maxCubemapSize = gl.getParameter(gl.MAX_CUBE_MAP_TEXTURE_SIZE);
    const maxAttributes = gl.getParameter(gl.MAX_VERTEX_ATTRIBS);
    const maxVertexUniforms = gl.getParameter(gl.MAX_VERTEX_UNIFORM_VECTORS);
    const maxVaryings = gl.getParameter(gl.MAX_VARYING_VECTORS);
    const maxFragmentUniforms = gl.getParameter(gl.MAX_FRAGMENT_UNIFORM_VECTORS);
    const maxSamples = gl.getParameter(gl.MAX_SAMPLES);
    const samples = gl.getParameter(gl.SAMPLES);
    return {
        isWebGL2: true,
        getMaxAnisotropy: getMaxAnisotropy,
        getMaxPrecision: getMaxPrecision,
        textureFormatReadable: textureFormatReadable,
        textureTypeReadable: textureTypeReadable,
        precision: precision,
        logarithmicDepthBuffer: logarithmicDepthBuffer,
        reversedDepthBuffer: reversedDepthBuffer,
        maxTextures: maxTextures,
        maxVertexTextures: maxVertexTextures,
        maxTextureSize: maxTextureSize,
        maxCubemapSize: maxCubemapSize,
        maxAttributes: maxAttributes,
        maxVertexUniforms: maxVertexUniforms,
        maxVaryings: maxVaryings,
        maxFragmentUniforms: maxFragmentUniforms,
        maxSamples: maxSamples,
        samples: samples
    };
}
function WebGLClipping(properties) {
    const scope = this;
    let globalState = null, numGlobalPlanes = 0, localClippingEnabled = false, renderingShadows = false;
    const plane = new (0, _threeCoreJs.Plane)(), viewNormalMatrix = new (0, _threeCoreJs.Matrix3)(), uniform = {
        value: null,
        needsUpdate: false
    };
    this.uniform = uniform;
    this.numPlanes = 0;
    this.numIntersection = 0;
    this.init = function(planes, enableLocalClipping) {
        const enabled = planes.length !== 0 || enableLocalClipping || // enable state of previous frame - the clipping code has to
        // run another frame in order to reset the state:
        numGlobalPlanes !== 0 || localClippingEnabled;
        localClippingEnabled = enableLocalClipping;
        numGlobalPlanes = planes.length;
        return enabled;
    };
    this.beginShadows = function() {
        renderingShadows = true;
        projectPlanes(null);
    };
    this.endShadows = function() {
        renderingShadows = false;
    };
    this.setGlobalState = function(planes, camera) {
        globalState = projectPlanes(planes, camera, 0);
    };
    this.setState = function(material, camera, useCache) {
        const planes = material.clippingPlanes, clipIntersection = material.clipIntersection, clipShadows = material.clipShadows;
        const materialProperties = properties.get(material);
        if (!localClippingEnabled || planes === null || planes.length === 0 || renderingShadows && !clipShadows) {
            // there's no local clipping
            if (renderingShadows) // there's no global clipping
            projectPlanes(null);
            else resetGlobalState();
        } else {
            const nGlobal = renderingShadows ? 0 : numGlobalPlanes, lGlobal = nGlobal * 4;
            let dstArray = materialProperties.clippingState || null;
            uniform.value = dstArray; // ensure unique state
            dstArray = projectPlanes(planes, camera, lGlobal, useCache);
            for(let i = 0; i !== lGlobal; ++i)dstArray[i] = globalState[i];
            materialProperties.clippingState = dstArray;
            this.numIntersection = clipIntersection ? this.numPlanes : 0;
            this.numPlanes += nGlobal;
        }
    };
    function resetGlobalState() {
        if (uniform.value !== globalState) {
            uniform.value = globalState;
            uniform.needsUpdate = numGlobalPlanes > 0;
        }
        scope.numPlanes = numGlobalPlanes;
        scope.numIntersection = 0;
    }
    function projectPlanes(planes, camera, dstOffset, skipTransform) {
        const nPlanes = planes !== null ? planes.length : 0;
        let dstArray = null;
        if (nPlanes !== 0) {
            dstArray = uniform.value;
            if (skipTransform !== true || dstArray === null) {
                const flatSize = dstOffset + nPlanes * 4, viewMatrix = camera.matrixWorldInverse;
                viewNormalMatrix.getNormalMatrix(viewMatrix);
                if (dstArray === null || dstArray.length < flatSize) dstArray = new Float32Array(flatSize);
                for(let i = 0, i4 = dstOffset; i !== nPlanes; ++i, i4 += 4){
                    plane.copy(planes[i]).applyMatrix4(viewMatrix, viewNormalMatrix);
                    plane.normal.toArray(dstArray, i4);
                    dstArray[i4 + 3] = plane.constant;
                }
            }
            uniform.value = dstArray;
            uniform.needsUpdate = true;
        }
        scope.numPlanes = nPlanes;
        scope.numIntersection = 0;
        return dstArray;
    }
}
function WebGLCubeMaps(renderer) {
    let cubemaps = new WeakMap();
    function mapTextureMapping(texture, mapping) {
        if (mapping === (0, _threeCoreJs.EquirectangularReflectionMapping)) texture.mapping = (0, _threeCoreJs.CubeReflectionMapping);
        else if (mapping === (0, _threeCoreJs.EquirectangularRefractionMapping)) texture.mapping = (0, _threeCoreJs.CubeRefractionMapping);
        return texture;
    }
    function get(texture) {
        if (texture && texture.isTexture) {
            const mapping = texture.mapping;
            if (mapping === (0, _threeCoreJs.EquirectangularReflectionMapping) || mapping === (0, _threeCoreJs.EquirectangularRefractionMapping)) {
                if (cubemaps.has(texture)) {
                    const cubemap = cubemaps.get(texture).texture;
                    return mapTextureMapping(cubemap, texture.mapping);
                } else {
                    const image = texture.image;
                    if (image && image.height > 0) {
                        const renderTarget = new (0, _threeCoreJs.WebGLCubeRenderTarget)(image.height);
                        renderTarget.fromEquirectangularTexture(renderer, texture);
                        cubemaps.set(texture, renderTarget);
                        texture.addEventListener('dispose', onTextureDispose);
                        return mapTextureMapping(renderTarget.texture, texture.mapping);
                    } else // image not yet ready. try the conversion next frame
                    return null;
                }
            }
        }
        return texture;
    }
    function onTextureDispose(event) {
        const texture = event.target;
        texture.removeEventListener('dispose', onTextureDispose);
        const cubemap = cubemaps.get(texture);
        if (cubemap !== undefined) {
            cubemaps.delete(texture);
            cubemap.dispose();
        }
    }
    function dispose() {
        cubemaps = new WeakMap();
    }
    return {
        get: get,
        dispose: dispose
    };
}
const LOD_MIN = 4;
// The standard deviations (radians) associated with the extra mips.
// Used for scene blur in fromScene() method.
const EXTRA_LOD_SIGMA = [
    0.125,
    0.215,
    0.35,
    0.446,
    0.526,
    0.582
];
// The maximum length of the blur for loop. Smaller sigmas will use fewer
// samples and exit early, but not recompile the shader.
// Used for scene blur in fromScene() method.
const MAX_SAMPLES = 20;
// GGX VNDF importance sampling configuration
const GGX_SAMPLES = 256;
const _flatCamera = /*@__PURE__*/ new (0, _threeCoreJs.OrthographicCamera)();
const _clearColor = /*@__PURE__*/ new (0, _threeCoreJs.Color)();
let _oldTarget = null;
let _oldActiveCubeFace = 0;
let _oldActiveMipmapLevel = 0;
let _oldXrEnabled = false;
const _origin = /*@__PURE__*/ new (0, _threeCoreJs.Vector3)();
/**
 * This class generates a Prefiltered, Mipmapped Radiance Environment Map
 * (PMREM) from a cubeMap environment texture. This allows different levels of
 * blur to be quickly accessed based on material roughness. It is packed into a
 * special CubeUV format that allows us to perform custom interpolation so that
 * we can support nonlinear formats such as RGBE. Unlike a traditional mipmap
 * chain, it only goes down to the LOD_MIN level (above), and then creates extra
 * even more filtered 'mips' at the same LOD_MIN resolution, associated with
 * higher roughness levels. In this way we maintain resolution to smoothly
 * interpolate diffuse lighting while limiting sampling computation.
 *
 * The prefiltering uses GGX VNDF (Visible Normal Distribution Function)
 * importance sampling based on "Sampling the GGX Distribution of Visible Normals"
 * (Heitz, 2018) to generate environment maps that accurately match the GGX BRDF
 * used in material rendering for physically-based image-based lighting.
 */ class PMREMGenerator {
    /**
	 * Constructs a new PMREM generator.
	 *
	 * @param {WebGLRenderer} renderer - The renderer.
	 */ constructor(renderer){
        this._renderer = renderer;
        this._pingPongRenderTarget = null;
        this._lodMax = 0;
        this._cubeSize = 0;
        this._sizeLods = [];
        this._sigmas = [];
        this._lodMeshes = [];
        this._backgroundBox = null;
        this._cubemapMaterial = null;
        this._equirectMaterial = null;
        this._blurMaterial = null;
        this._ggxMaterial = null;
    }
    /**
	 * Generates a PMREM from a supplied Scene, which can be faster than using an
	 * image if networking bandwidth is low. Optional sigma specifies a blur radius
	 * in radians to be applied to the scene before PMREM generation. Optional near
	 * and far planes ensure the scene is rendered in its entirety.
	 *
	 * @param {Scene} scene - The scene to be captured.
	 * @param {number} [sigma=0] - The blur radius in radians.
	 * @param {number} [near=0.1] - The near plane distance.
	 * @param {number} [far=100] - The far plane distance.
	 * @param {Object} [options={}] - The configuration options.
	 * @param {number} [options.size=256] - The texture size of the PMREM.
	 * @param {Vector3} [options.position=origin] - The position of the internal cube camera that renders the scene.
	 * @return {WebGLRenderTarget} The resulting PMREM.
	 */ fromScene(scene, sigma = 0, near = 0.1, far = 100, options = {}) {
        const { size = 256, position = _origin } = options;
        _oldTarget = this._renderer.getRenderTarget();
        _oldActiveCubeFace = this._renderer.getActiveCubeFace();
        _oldActiveMipmapLevel = this._renderer.getActiveMipmapLevel();
        _oldXrEnabled = this._renderer.xr.enabled;
        this._renderer.xr.enabled = false;
        this._setSize(size);
        const cubeUVRenderTarget = this._allocateTargets();
        cubeUVRenderTarget.depthBuffer = true;
        this._sceneToCubeUV(scene, near, far, cubeUVRenderTarget, position);
        if (sigma > 0) this._blur(cubeUVRenderTarget, 0, 0, sigma);
        this._applyPMREM(cubeUVRenderTarget);
        this._cleanup(cubeUVRenderTarget);
        return cubeUVRenderTarget;
    }
    /**
	 * Generates a PMREM from an equirectangular texture, which can be either LDR
	 * or HDR. The ideal input image size is 1k (1024 x 512),
	 * as this matches best with the 256 x 256 cubemap output.
	 *
	 * @param {Texture} equirectangular - The equirectangular texture to be converted.
	 * @param {?WebGLRenderTarget} [renderTarget=null] - The render target to use.
	 * @return {WebGLRenderTarget} The resulting PMREM.
	 */ fromEquirectangular(equirectangular, renderTarget = null) {
        return this._fromTexture(equirectangular, renderTarget);
    }
    /**
	 * Generates a PMREM from an cubemap texture, which can be either LDR
	 * or HDR. The ideal input cube size is 256 x 256,
	 * as this matches best with the 256 x 256 cubemap output.
	 *
	 * @param {Texture} cubemap - The cubemap texture to be converted.
	 * @param {?WebGLRenderTarget} [renderTarget=null] - The render target to use.
	 * @return {WebGLRenderTarget} The resulting PMREM.
	 */ fromCubemap(cubemap, renderTarget = null) {
        return this._fromTexture(cubemap, renderTarget);
    }
    /**
	 * Pre-compiles the cubemap shader. You can get faster start-up by invoking this method during
	 * your texture's network fetch for increased concurrency.
	 */ compileCubemapShader() {
        if (this._cubemapMaterial === null) {
            this._cubemapMaterial = _getCubemapMaterial();
            this._compileMaterial(this._cubemapMaterial);
        }
    }
    /**
	 * Pre-compiles the equirectangular shader. You can get faster start-up by invoking this method during
	 * your texture's network fetch for increased concurrency.
	 */ compileEquirectangularShader() {
        if (this._equirectMaterial === null) {
            this._equirectMaterial = _getEquirectMaterial();
            this._compileMaterial(this._equirectMaterial);
        }
    }
    /**
	 * Disposes of the PMREMGenerator's internal memory. Note that PMREMGenerator is a static class,
	 * so you should not need more than one PMREMGenerator object. If you do, calling dispose() on
	 * one of them will cause any others to also become unusable.
	 */ dispose() {
        this._dispose();
        if (this._cubemapMaterial !== null) this._cubemapMaterial.dispose();
        if (this._equirectMaterial !== null) this._equirectMaterial.dispose();
        if (this._backgroundBox !== null) {
            this._backgroundBox.geometry.dispose();
            this._backgroundBox.material.dispose();
        }
    }
    // private interface
    _setSize(cubeSize) {
        this._lodMax = Math.floor(Math.log2(cubeSize));
        this._cubeSize = Math.pow(2, this._lodMax);
    }
    _dispose() {
        if (this._blurMaterial !== null) this._blurMaterial.dispose();
        if (this._ggxMaterial !== null) this._ggxMaterial.dispose();
        if (this._pingPongRenderTarget !== null) this._pingPongRenderTarget.dispose();
        for(let i = 0; i < this._lodMeshes.length; i++)this._lodMeshes[i].geometry.dispose();
    }
    _cleanup(outputTarget) {
        this._renderer.setRenderTarget(_oldTarget, _oldActiveCubeFace, _oldActiveMipmapLevel);
        this._renderer.xr.enabled = _oldXrEnabled;
        outputTarget.scissorTest = false;
        _setViewport(outputTarget, 0, 0, outputTarget.width, outputTarget.height);
    }
    _fromTexture(texture, renderTarget) {
        if (texture.mapping === (0, _threeCoreJs.CubeReflectionMapping) || texture.mapping === (0, _threeCoreJs.CubeRefractionMapping)) this._setSize(texture.image.length === 0 ? 16 : texture.image[0].width || texture.image[0].image.width);
        else this._setSize(texture.image.width / 4);
        _oldTarget = this._renderer.getRenderTarget();
        _oldActiveCubeFace = this._renderer.getActiveCubeFace();
        _oldActiveMipmapLevel = this._renderer.getActiveMipmapLevel();
        _oldXrEnabled = this._renderer.xr.enabled;
        this._renderer.xr.enabled = false;
        const cubeUVRenderTarget = renderTarget || this._allocateTargets();
        this._textureToCubeUV(texture, cubeUVRenderTarget);
        this._applyPMREM(cubeUVRenderTarget);
        this._cleanup(cubeUVRenderTarget);
        return cubeUVRenderTarget;
    }
    _allocateTargets() {
        const width = 3 * Math.max(this._cubeSize, 112);
        const height = 4 * this._cubeSize;
        const params = {
            magFilter: (0, _threeCoreJs.LinearFilter),
            minFilter: (0, _threeCoreJs.LinearFilter),
            generateMipmaps: false,
            type: (0, _threeCoreJs.HalfFloatType),
            format: (0, _threeCoreJs.RGBAFormat),
            colorSpace: (0, _threeCoreJs.LinearSRGBColorSpace),
            depthBuffer: false
        };
        const cubeUVRenderTarget = _createRenderTarget(width, height, params);
        if (this._pingPongRenderTarget === null || this._pingPongRenderTarget.width !== width || this._pingPongRenderTarget.height !== height) {
            if (this._pingPongRenderTarget !== null) this._dispose();
            this._pingPongRenderTarget = _createRenderTarget(width, height, params);
            const { _lodMax } = this;
            ({ lodMeshes: this._lodMeshes, sizeLods: this._sizeLods, sigmas: this._sigmas } = _createPlanes(_lodMax));
            this._blurMaterial = _getBlurShader(_lodMax, width, height);
            this._ggxMaterial = _getGGXShader(_lodMax, width, height);
        }
        return cubeUVRenderTarget;
    }
    _compileMaterial(material) {
        const mesh = new (0, _threeCoreJs.Mesh)(new (0, _threeCoreJs.BufferGeometry)(), material);
        this._renderer.compile(mesh, _flatCamera);
    }
    _sceneToCubeUV(scene, near, far, cubeUVRenderTarget, position) {
        const fov = 90;
        const aspect = 1;
        const cubeCamera = new (0, _threeCoreJs.PerspectiveCamera)(fov, aspect, near, far);
        const upSign = [
            1,
            -1,
            1,
            1,
            1,
            1
        ];
        const forwardSign = [
            1,
            1,
            1,
            -1,
            -1,
            -1
        ];
        const renderer = this._renderer;
        const originalAutoClear = renderer.autoClear;
        const toneMapping = renderer.toneMapping;
        renderer.getClearColor(_clearColor);
        renderer.toneMapping = (0, _threeCoreJs.NoToneMapping);
        renderer.autoClear = false;
        // https://github.com/mrdoob/three.js/issues/31413#issuecomment-3095966812
        const reversedDepthBuffer = renderer.state.buffers.depth.getReversed();
        if (reversedDepthBuffer) {
            renderer.setRenderTarget(cubeUVRenderTarget);
            renderer.clearDepth();
            renderer.setRenderTarget(null);
        }
        if (this._backgroundBox === null) this._backgroundBox = new (0, _threeCoreJs.Mesh)(new (0, _threeCoreJs.BoxGeometry)(), new (0, _threeCoreJs.MeshBasicMaterial)({
            name: 'PMREM.Background',
            side: (0, _threeCoreJs.BackSide),
            depthWrite: false,
            depthTest: false
        }));
        const backgroundBox = this._backgroundBox;
        const backgroundMaterial = backgroundBox.material;
        let useSolidColor = false;
        const background = scene.background;
        if (background) {
            if (background.isColor) {
                backgroundMaterial.color.copy(background);
                scene.background = null;
                useSolidColor = true;
            }
        } else {
            backgroundMaterial.color.copy(_clearColor);
            useSolidColor = true;
        }
        for(let i = 0; i < 6; i++){
            const col = i % 3;
            if (col === 0) {
                cubeCamera.up.set(0, upSign[i], 0);
                cubeCamera.position.set(position.x, position.y, position.z);
                cubeCamera.lookAt(position.x + forwardSign[i], position.y, position.z);
            } else if (col === 1) {
                cubeCamera.up.set(0, 0, upSign[i]);
                cubeCamera.position.set(position.x, position.y, position.z);
                cubeCamera.lookAt(position.x, position.y + forwardSign[i], position.z);
            } else {
                cubeCamera.up.set(0, upSign[i], 0);
                cubeCamera.position.set(position.x, position.y, position.z);
                cubeCamera.lookAt(position.x, position.y, position.z + forwardSign[i]);
            }
            const size = this._cubeSize;
            _setViewport(cubeUVRenderTarget, col * size, i > 2 ? size : 0, size, size);
            renderer.setRenderTarget(cubeUVRenderTarget);
            if (useSolidColor) renderer.render(backgroundBox, cubeCamera);
            renderer.render(scene, cubeCamera);
        }
        renderer.toneMapping = toneMapping;
        renderer.autoClear = originalAutoClear;
        scene.background = background;
    }
    _textureToCubeUV(texture, cubeUVRenderTarget) {
        const renderer = this._renderer;
        const isCubeTexture = texture.mapping === (0, _threeCoreJs.CubeReflectionMapping) || texture.mapping === (0, _threeCoreJs.CubeRefractionMapping);
        if (isCubeTexture) {
            if (this._cubemapMaterial === null) this._cubemapMaterial = _getCubemapMaterial();
            this._cubemapMaterial.uniforms.flipEnvMap.value = texture.isRenderTargetTexture === false ? -1 : 1;
        } else if (this._equirectMaterial === null) this._equirectMaterial = _getEquirectMaterial();
        const material = isCubeTexture ? this._cubemapMaterial : this._equirectMaterial;
        const mesh = this._lodMeshes[0];
        mesh.material = material;
        const uniforms = material.uniforms;
        uniforms['envMap'].value = texture;
        const size = this._cubeSize;
        _setViewport(cubeUVRenderTarget, 0, 0, 3 * size, 2 * size);
        renderer.setRenderTarget(cubeUVRenderTarget);
        renderer.render(mesh, _flatCamera);
    }
    _applyPMREM(cubeUVRenderTarget) {
        const renderer = this._renderer;
        const autoClear = renderer.autoClear;
        renderer.autoClear = false;
        const n = this._lodMeshes.length;
        // Use GGX VNDF importance sampling
        for(let i = 1; i < n; i++)this._applyGGXFilter(cubeUVRenderTarget, i - 1, i);
        renderer.autoClear = autoClear;
    }
    /**
	 * Applies GGX VNDF importance sampling filter to generate a prefiltered environment map.
	 * Uses Monte Carlo integration with VNDF importance sampling to accurately represent the
	 * GGX BRDF for physically-based rendering. Reads from the previous LOD level and
	 * applies incremental roughness filtering to avoid over-blurring.
	 *
	 * @private
	 * @param {WebGLRenderTarget} cubeUVRenderTarget
	 * @param {number} lodIn - Source LOD level to read from
	 * @param {number} lodOut - Target LOD level to write to
	 */ _applyGGXFilter(cubeUVRenderTarget, lodIn, lodOut) {
        const renderer = this._renderer;
        const pingPongRenderTarget = this._pingPongRenderTarget;
        const ggxMaterial = this._ggxMaterial;
        const ggxMesh = this._lodMeshes[lodOut];
        ggxMesh.material = ggxMaterial;
        const ggxUniforms = ggxMaterial.uniforms;
        // Calculate incremental roughness between LOD levels
        const targetRoughness = lodOut / (this._lodMeshes.length - 1);
        const sourceRoughness = lodIn / (this._lodMeshes.length - 1);
        const incrementalRoughness = Math.sqrt(targetRoughness * targetRoughness - sourceRoughness * sourceRoughness);
        // Apply blur strength mapping for better quality across the roughness range
        const blurStrength = 0.0 + targetRoughness * 1.25;
        const adjustedRoughness = incrementalRoughness * blurStrength;
        // Calculate viewport position based on output LOD level
        const { _lodMax } = this;
        const outputSize = this._sizeLods[lodOut];
        const x = 3 * outputSize * (lodOut > _lodMax - LOD_MIN ? lodOut - _lodMax + LOD_MIN : 0);
        const y = 4 * (this._cubeSize - outputSize);
        // Read from previous LOD with incremental roughness
        ggxUniforms['envMap'].value = cubeUVRenderTarget.texture;
        ggxUniforms['roughness'].value = adjustedRoughness;
        ggxUniforms['mipInt'].value = _lodMax - lodIn; // Sample from input LOD
        _setViewport(pingPongRenderTarget, x, y, 3 * outputSize, 2 * outputSize);
        renderer.setRenderTarget(pingPongRenderTarget);
        renderer.render(ggxMesh, _flatCamera);
        // Copy from pingPong back to cubeUV (simple direct copy)
        ggxUniforms['envMap'].value = pingPongRenderTarget.texture;
        ggxUniforms['roughness'].value = 0.0; // Direct copy
        ggxUniforms['mipInt'].value = _lodMax - lodOut; // Read from the level we just wrote
        _setViewport(cubeUVRenderTarget, x, y, 3 * outputSize, 2 * outputSize);
        renderer.setRenderTarget(cubeUVRenderTarget);
        renderer.render(ggxMesh, _flatCamera);
    }
    /**
	 * This is a two-pass Gaussian blur for a cubemap. Normally this is done
	 * vertically and horizontally, but this breaks down on a cube. Here we apply
	 * the blur latitudinally (around the poles), and then longitudinally (towards
	 * the poles) to approximate the orthogonally-separable blur. It is least
	 * accurate at the poles, but still does a decent job.
	 *
	 * Used for initial scene blur in fromScene() method when sigma > 0.
	 *
	 * @private
	 * @param {WebGLRenderTarget} cubeUVRenderTarget
	 * @param {number} lodIn
	 * @param {number} lodOut
	 * @param {number} sigma
	 * @param {Vector3} [poleAxis]
	 */ _blur(cubeUVRenderTarget, lodIn, lodOut, sigma, poleAxis) {
        const pingPongRenderTarget = this._pingPongRenderTarget;
        this._halfBlur(cubeUVRenderTarget, pingPongRenderTarget, lodIn, lodOut, sigma, 'latitudinal', poleAxis);
        this._halfBlur(pingPongRenderTarget, cubeUVRenderTarget, lodOut, lodOut, sigma, 'longitudinal', poleAxis);
    }
    _halfBlur(targetIn, targetOut, lodIn, lodOut, sigmaRadians, direction, poleAxis) {
        const renderer = this._renderer;
        const blurMaterial = this._blurMaterial;
        if (direction !== 'latitudinal' && direction !== 'longitudinal') (0, _threeCoreJs.error)('blur direction must be either latitudinal or longitudinal!');
        // Number of standard deviations at which to cut off the discrete approximation.
        const STANDARD_DEVIATIONS = 3;
        const blurMesh = this._lodMeshes[lodOut];
        blurMesh.material = blurMaterial;
        const blurUniforms = blurMaterial.uniforms;
        const pixels = this._sizeLods[lodIn] - 1;
        const radiansPerPixel = isFinite(sigmaRadians) ? Math.PI / (2 * pixels) : 2 * Math.PI / (2 * MAX_SAMPLES - 1);
        const sigmaPixels = sigmaRadians / radiansPerPixel;
        const samples = isFinite(sigmaRadians) ? 1 + Math.floor(STANDARD_DEVIATIONS * sigmaPixels) : MAX_SAMPLES;
        if (samples > MAX_SAMPLES) (0, _threeCoreJs.warn)(`sigmaRadians, ${sigmaRadians}, is too large and will clip, as it requested ${samples} samples when the maximum is set to ${MAX_SAMPLES}`);
        const weights = [];
        let sum = 0;
        for(let i = 0; i < MAX_SAMPLES; ++i){
            const x = i / sigmaPixels;
            const weight = Math.exp(-x * x / 2);
            weights.push(weight);
            if (i === 0) sum += weight;
            else if (i < samples) sum += 2 * weight;
        }
        for(let i = 0; i < weights.length; i++)weights[i] = weights[i] / sum;
        blurUniforms['envMap'].value = targetIn.texture;
        blurUniforms['samples'].value = samples;
        blurUniforms['weights'].value = weights;
        blurUniforms['latitudinal'].value = direction === 'latitudinal';
        if (poleAxis) blurUniforms['poleAxis'].value = poleAxis;
        const { _lodMax } = this;
        blurUniforms['dTheta'].value = radiansPerPixel;
        blurUniforms['mipInt'].value = _lodMax - lodIn;
        const outputSize = this._sizeLods[lodOut];
        const x = 3 * outputSize * (lodOut > _lodMax - LOD_MIN ? lodOut - _lodMax + LOD_MIN : 0);
        const y = 4 * (this._cubeSize - outputSize);
        _setViewport(targetOut, x, y, 3 * outputSize, 2 * outputSize);
        renderer.setRenderTarget(targetOut);
        renderer.render(blurMesh, _flatCamera);
    }
}
function _createPlanes(lodMax) {
    const sizeLods = [];
    const sigmas = [];
    const lodMeshes = [];
    let lod = lodMax;
    const totalLods = lodMax - LOD_MIN + 1 + EXTRA_LOD_SIGMA.length;
    for(let i = 0; i < totalLods; i++){
        const sizeLod = Math.pow(2, lod);
        sizeLods.push(sizeLod);
        let sigma = 1.0 / sizeLod;
        if (i > lodMax - LOD_MIN) sigma = EXTRA_LOD_SIGMA[i - lodMax + LOD_MIN - 1];
        else if (i === 0) sigma = 0;
        sigmas.push(sigma);
        const texelSize = 1.0 / (sizeLod - 2);
        const min = -texelSize;
        const max = 1 + texelSize;
        const uv1 = [
            min,
            min,
            max,
            min,
            max,
            max,
            min,
            min,
            max,
            max,
            min,
            max
        ];
        const cubeFaces = 6;
        const vertices = 6;
        const positionSize = 3;
        const uvSize = 2;
        const faceIndexSize = 1;
        const position = new Float32Array(positionSize * vertices * cubeFaces);
        const uv = new Float32Array(uvSize * vertices * cubeFaces);
        const faceIndex = new Float32Array(faceIndexSize * vertices * cubeFaces);
        for(let face = 0; face < cubeFaces; face++){
            const x = face % 3 * 2 / 3 - 1;
            const y = face > 2 ? 0 : -1;
            const coordinates = [
                x,
                y,
                0,
                x + 2 / 3,
                y,
                0,
                x + 2 / 3,
                y + 1,
                0,
                x,
                y,
                0,
                x + 2 / 3,
                y + 1,
                0,
                x,
                y + 1,
                0
            ];
            position.set(coordinates, positionSize * vertices * face);
            uv.set(uv1, uvSize * vertices * face);
            const fill = [
                face,
                face,
                face,
                face,
                face,
                face
            ];
            faceIndex.set(fill, faceIndexSize * vertices * face);
        }
        const planes = new (0, _threeCoreJs.BufferGeometry)();
        planes.setAttribute('position', new (0, _threeCoreJs.BufferAttribute)(position, positionSize));
        planes.setAttribute('uv', new (0, _threeCoreJs.BufferAttribute)(uv, uvSize));
        planes.setAttribute('faceIndex', new (0, _threeCoreJs.BufferAttribute)(faceIndex, faceIndexSize));
        lodMeshes.push(new (0, _threeCoreJs.Mesh)(planes, null));
        if (lod > LOD_MIN) lod--;
    }
    return {
        lodMeshes,
        sizeLods,
        sigmas
    };
}
function _createRenderTarget(width, height, params) {
    const cubeUVRenderTarget = new (0, _threeCoreJs.WebGLRenderTarget)(width, height, params);
    cubeUVRenderTarget.texture.mapping = (0, _threeCoreJs.CubeUVReflectionMapping);
    cubeUVRenderTarget.texture.name = 'PMREM.cubeUv';
    cubeUVRenderTarget.scissorTest = true;
    return cubeUVRenderTarget;
}
function _setViewport(target, x, y, width, height) {
    target.viewport.set(x, y, width, height);
    target.scissor.set(x, y, width, height);
}
function _getGGXShader(lodMax, width, height) {
    const shaderMaterial = new (0, _threeCoreJs.ShaderMaterial)({
        name: 'PMREMGGXConvolution',
        defines: {
            'GGX_SAMPLES': GGX_SAMPLES,
            'CUBEUV_TEXEL_WIDTH': 1.0 / width,
            'CUBEUV_TEXEL_HEIGHT': 1.0 / height,
            'CUBEUV_MAX_MIP': `${lodMax}.0`
        },
        uniforms: {
            'envMap': {
                value: null
            },
            'roughness': {
                value: 0.0
            },
            'mipInt': {
                value: 0
            }
        },
        vertexShader: _getCommonVertexShader(),
        fragmentShader: /* glsl */ `

			precision highp float;
			precision highp int;

			varying vec3 vOutputDirection;

			uniform sampler2D envMap;
			uniform float roughness;
			uniform float mipInt;

			#define ENVMAP_TYPE_CUBE_UV
			#include <cube_uv_reflection_fragment>

			#define PI 3.14159265359

			// Van der Corput radical inverse
			float radicalInverse_VdC(uint bits) {
				bits = (bits << 16u) | (bits >> 16u);
				bits = ((bits & 0x55555555u) << 1u) | ((bits & 0xAAAAAAAAu) >> 1u);
				bits = ((bits & 0x33333333u) << 2u) | ((bits & 0xCCCCCCCCu) >> 2u);
				bits = ((bits & 0x0F0F0F0Fu) << 4u) | ((bits & 0xF0F0F0F0u) >> 4u);
				bits = ((bits & 0x00FF00FFu) << 8u) | ((bits & 0xFF00FF00u) >> 8u);
				return float(bits) * 2.3283064365386963e-10; // / 0x100000000
			}

			// Hammersley sequence
			vec2 hammersley(uint i, uint N) {
				return vec2(float(i) / float(N), radicalInverse_VdC(i));
			}

			// GGX VNDF importance sampling (Eric Heitz 2018)
			// "Sampling the GGX Distribution of Visible Normals"
			// https://jcgt.org/published/0007/04/01/
			vec3 importanceSampleGGX_VNDF(vec2 Xi, vec3 V, float roughness) {
				float alpha = roughness * roughness;

				// Section 3.2: Transform view direction to hemisphere configuration
				vec3 Vh = normalize(vec3(alpha * V.x, alpha * V.y, V.z));

				// Section 4.1: Orthonormal basis
				float lensq = Vh.x * Vh.x + Vh.y * Vh.y;
				vec3 T1 = lensq > 0.0 ? vec3(-Vh.y, Vh.x, 0.0) / sqrt(lensq) : vec3(1.0, 0.0, 0.0);
				vec3 T2 = cross(Vh, T1);

				// Section 4.2: Parameterization of projected area
				float r = sqrt(Xi.x);
				float phi = 2.0 * PI * Xi.y;
				float t1 = r * cos(phi);
				float t2 = r * sin(phi);
				float s = 0.5 * (1.0 + Vh.z);
				t2 = (1.0 - s) * sqrt(1.0 - t1 * t1) + s * t2;

				// Section 4.3: Reprojection onto hemisphere
				vec3 Nh = t1 * T1 + t2 * T2 + sqrt(max(0.0, 1.0 - t1 * t1 - t2 * t2)) * Vh;

				// Section 3.4: Transform back to ellipsoid configuration
				return normalize(vec3(alpha * Nh.x, alpha * Nh.y, max(0.0, Nh.z)));
			}

			void main() {
				vec3 N = normalize(vOutputDirection);
				vec3 V = N; // Assume view direction equals normal for pre-filtering

				vec3 prefilteredColor = vec3(0.0);
				float totalWeight = 0.0;

				// For very low roughness, just sample the environment directly
				if (roughness < 0.001) {
					gl_FragColor = vec4(bilinearCubeUV(envMap, N, mipInt), 1.0);
					return;
				}

				// Tangent space basis for VNDF sampling
				vec3 up = abs(N.z) < 0.999 ? vec3(0.0, 0.0, 1.0) : vec3(1.0, 0.0, 0.0);
				vec3 tangent = normalize(cross(up, N));
				vec3 bitangent = cross(N, tangent);

				for(uint i = 0u; i < uint(GGX_SAMPLES); i++) {
					vec2 Xi = hammersley(i, uint(GGX_SAMPLES));

					// For PMREM, V = N, so in tangent space V is always (0, 0, 1)
					vec3 H_tangent = importanceSampleGGX_VNDF(Xi, vec3(0.0, 0.0, 1.0), roughness);

					// Transform H back to world space
					vec3 H = normalize(tangent * H_tangent.x + bitangent * H_tangent.y + N * H_tangent.z);
					vec3 L = normalize(2.0 * dot(V, H) * H - V);

					float NdotL = max(dot(N, L), 0.0);

					if(NdotL > 0.0) {
						// Sample environment at fixed mip level
						// VNDF importance sampling handles the distribution filtering
						vec3 sampleColor = bilinearCubeUV(envMap, L, mipInt);

						// Weight by NdotL for the split-sum approximation
						// VNDF PDF naturally accounts for the visible microfacet distribution
						prefilteredColor += sampleColor * NdotL;
						totalWeight += NdotL;
					}
				}

				if (totalWeight > 0.0) {
					prefilteredColor = prefilteredColor / totalWeight;
				}

				gl_FragColor = vec4(prefilteredColor, 1.0);
			}
		`,
        blending: (0, _threeCoreJs.NoBlending),
        depthTest: false,
        depthWrite: false
    });
    return shaderMaterial;
}
function _getBlurShader(lodMax, width, height) {
    const weights = new Float32Array(MAX_SAMPLES);
    const poleAxis = new (0, _threeCoreJs.Vector3)(0, 1, 0);
    const shaderMaterial = new (0, _threeCoreJs.ShaderMaterial)({
        name: 'SphericalGaussianBlur',
        defines: {
            'n': MAX_SAMPLES,
            'CUBEUV_TEXEL_WIDTH': 1.0 / width,
            'CUBEUV_TEXEL_HEIGHT': 1.0 / height,
            'CUBEUV_MAX_MIP': `${lodMax}.0`
        },
        uniforms: {
            'envMap': {
                value: null
            },
            'samples': {
                value: 1
            },
            'weights': {
                value: weights
            },
            'latitudinal': {
                value: false
            },
            'dTheta': {
                value: 0
            },
            'mipInt': {
                value: 0
            },
            'poleAxis': {
                value: poleAxis
            }
        },
        vertexShader: _getCommonVertexShader(),
        fragmentShader: /* glsl */ `

			precision mediump float;
			precision mediump int;

			varying vec3 vOutputDirection;

			uniform sampler2D envMap;
			uniform int samples;
			uniform float weights[ n ];
			uniform bool latitudinal;
			uniform float dTheta;
			uniform float mipInt;
			uniform vec3 poleAxis;

			#define ENVMAP_TYPE_CUBE_UV
			#include <cube_uv_reflection_fragment>

			vec3 getSample( float theta, vec3 axis ) {

				float cosTheta = cos( theta );
				// Rodrigues' axis-angle rotation
				vec3 sampleDirection = vOutputDirection * cosTheta
					+ cross( axis, vOutputDirection ) * sin( theta )
					+ axis * dot( axis, vOutputDirection ) * ( 1.0 - cosTheta );

				return bilinearCubeUV( envMap, sampleDirection, mipInt );

			}

			void main() {

				vec3 axis = latitudinal ? poleAxis : cross( poleAxis, vOutputDirection );

				if ( all( equal( axis, vec3( 0.0 ) ) ) ) {

					axis = vec3( vOutputDirection.z, 0.0, - vOutputDirection.x );

				}

				axis = normalize( axis );

				gl_FragColor = vec4( 0.0, 0.0, 0.0, 1.0 );
				gl_FragColor.rgb += weights[ 0 ] * getSample( 0.0, axis );

				for ( int i = 1; i < n; i++ ) {

					if ( i >= samples ) {

						break;

					}

					float theta = dTheta * float( i );
					gl_FragColor.rgb += weights[ i ] * getSample( -1.0 * theta, axis );
					gl_FragColor.rgb += weights[ i ] * getSample( theta, axis );

				}

			}
		`,
        blending: (0, _threeCoreJs.NoBlending),
        depthTest: false,
        depthWrite: false
    });
    return shaderMaterial;
}
function _getEquirectMaterial() {
    return new (0, _threeCoreJs.ShaderMaterial)({
        name: 'EquirectangularToCubeUV',
        uniforms: {
            'envMap': {
                value: null
            }
        },
        vertexShader: _getCommonVertexShader(),
        fragmentShader: /* glsl */ `

			precision mediump float;
			precision mediump int;

			varying vec3 vOutputDirection;

			uniform sampler2D envMap;

			#include <common>

			void main() {

				vec3 outputDirection = normalize( vOutputDirection );
				vec2 uv = equirectUv( outputDirection );

				gl_FragColor = vec4( texture2D ( envMap, uv ).rgb, 1.0 );

			}
		`,
        blending: (0, _threeCoreJs.NoBlending),
        depthTest: false,
        depthWrite: false
    });
}
function _getCubemapMaterial() {
    return new (0, _threeCoreJs.ShaderMaterial)({
        name: 'CubemapToCubeUV',
        uniforms: {
            'envMap': {
                value: null
            },
            'flipEnvMap': {
                value: -1
            }
        },
        vertexShader: _getCommonVertexShader(),
        fragmentShader: /* glsl */ `

			precision mediump float;
			precision mediump int;

			uniform float flipEnvMap;

			varying vec3 vOutputDirection;

			uniform samplerCube envMap;

			void main() {

				gl_FragColor = textureCube( envMap, vec3( flipEnvMap * vOutputDirection.x, vOutputDirection.yz ) );

			}
		`,
        blending: (0, _threeCoreJs.NoBlending),
        depthTest: false,
        depthWrite: false
    });
}
function _getCommonVertexShader() {
    return /* glsl */ `

		precision mediump float;
		precision mediump int;

		attribute float faceIndex;

		varying vec3 vOutputDirection;

		// RH coordinate system; PMREM face-indexing convention
		vec3 getDirection( vec2 uv, float face ) {

			uv = 2.0 * uv - 1.0;

			vec3 direction = vec3( uv, 1.0 );

			if ( face == 0.0 ) {

				direction = direction.zyx; // ( 1, v, u ) pos x

			} else if ( face == 1.0 ) {

				direction = direction.xzy;
				direction.xz *= -1.0; // ( -u, 1, -v ) pos y

			} else if ( face == 2.0 ) {

				direction.x *= -1.0; // ( -u, v, 1 ) pos z

			} else if ( face == 3.0 ) {

				direction = direction.zyx;
				direction.xz *= -1.0; // ( -1, v, -u ) neg x

			} else if ( face == 4.0 ) {

				direction = direction.xzy;
				direction.xy *= -1.0; // ( -u, -1, v ) neg y

			} else if ( face == 5.0 ) {

				direction.z *= -1.0; // ( u, v, -1 ) neg z

			}

			return direction;

		}

		void main() {

			vOutputDirection = getDirection( uv, faceIndex );
			gl_Position = vec4( position, 1.0 );

		}
	`;
}
function WebGLCubeUVMaps(renderer) {
    let cubeUVmaps = new WeakMap();
    let pmremGenerator = null;
    function get(texture) {
        if (texture && texture.isTexture) {
            const mapping = texture.mapping;
            const isEquirectMap = mapping === (0, _threeCoreJs.EquirectangularReflectionMapping) || mapping === (0, _threeCoreJs.EquirectangularRefractionMapping);
            const isCubeMap = mapping === (0, _threeCoreJs.CubeReflectionMapping) || mapping === (0, _threeCoreJs.CubeRefractionMapping);
            // equirect/cube map to cubeUV conversion
            if (isEquirectMap || isCubeMap) {
                let renderTarget = cubeUVmaps.get(texture);
                const currentPMREMVersion = renderTarget !== undefined ? renderTarget.texture.pmremVersion : 0;
                if (texture.isRenderTargetTexture && texture.pmremVersion !== currentPMREMVersion) {
                    if (pmremGenerator === null) pmremGenerator = new PMREMGenerator(renderer);
                    renderTarget = isEquirectMap ? pmremGenerator.fromEquirectangular(texture, renderTarget) : pmremGenerator.fromCubemap(texture, renderTarget);
                    renderTarget.texture.pmremVersion = texture.pmremVersion;
                    cubeUVmaps.set(texture, renderTarget);
                    return renderTarget.texture;
                } else {
                    if (renderTarget !== undefined) return renderTarget.texture;
                    else {
                        const image = texture.image;
                        if (isEquirectMap && image && image.height > 0 || isCubeMap && image && isCubeTextureComplete(image)) {
                            if (pmremGenerator === null) pmremGenerator = new PMREMGenerator(renderer);
                            renderTarget = isEquirectMap ? pmremGenerator.fromEquirectangular(texture) : pmremGenerator.fromCubemap(texture);
                            renderTarget.texture.pmremVersion = texture.pmremVersion;
                            cubeUVmaps.set(texture, renderTarget);
                            texture.addEventListener('dispose', onTextureDispose);
                            return renderTarget.texture;
                        } else // image not yet ready. try the conversion next frame
                        return null;
                    }
                }
            }
        }
        return texture;
    }
    function isCubeTextureComplete(image) {
        let count = 0;
        const length = 6;
        for(let i = 0; i < length; i++)if (image[i] !== undefined) count++;
        return count === length;
    }
    function onTextureDispose(event) {
        const texture = event.target;
        texture.removeEventListener('dispose', onTextureDispose);
        const cubemapUV = cubeUVmaps.get(texture);
        if (cubemapUV !== undefined) {
            cubeUVmaps.delete(texture);
            cubemapUV.dispose();
        }
    }
    function dispose() {
        cubeUVmaps = new WeakMap();
        if (pmremGenerator !== null) {
            pmremGenerator.dispose();
            pmremGenerator = null;
        }
    }
    return {
        get: get,
        dispose: dispose
    };
}
function WebGLExtensions(gl) {
    const extensions = {};
    function getExtension(name) {
        if (extensions[name] !== undefined) return extensions[name];
        const extension = gl.getExtension(name);
        extensions[name] = extension;
        return extension;
    }
    return {
        has: function(name) {
            return getExtension(name) !== null;
        },
        init: function() {
            getExtension('EXT_color_buffer_float');
            getExtension('WEBGL_clip_cull_distance');
            getExtension('OES_texture_float_linear');
            getExtension('EXT_color_buffer_half_float');
            getExtension('WEBGL_multisampled_render_to_texture');
            getExtension('WEBGL_render_shared_exponent');
        },
        get: function(name) {
            const extension = getExtension(name);
            if (extension === null) (0, _threeCoreJs.warnOnce)('WebGLRenderer: ' + name + ' extension not supported.');
            return extension;
        }
    };
}
function WebGLGeometries(gl, attributes, info, bindingStates) {
    const geometries = {};
    const wireframeAttributes = new WeakMap();
    function onGeometryDispose(event) {
        const geometry = event.target;
        if (geometry.index !== null) attributes.remove(geometry.index);
        for(const name in geometry.attributes)attributes.remove(geometry.attributes[name]);
        geometry.removeEventListener('dispose', onGeometryDispose);
        delete geometries[geometry.id];
        const attribute = wireframeAttributes.get(geometry);
        if (attribute) {
            attributes.remove(attribute);
            wireframeAttributes.delete(geometry);
        }
        bindingStates.releaseStatesOfGeometry(geometry);
        if (geometry.isInstancedBufferGeometry === true) delete geometry._maxInstanceCount;
        //
        info.memory.geometries--;
    }
    function get(object, geometry) {
        if (geometries[geometry.id] === true) return geometry;
        geometry.addEventListener('dispose', onGeometryDispose);
        geometries[geometry.id] = true;
        info.memory.geometries++;
        return geometry;
    }
    function update(geometry) {
        const geometryAttributes = geometry.attributes;
        // Updating index buffer in VAO now. See WebGLBindingStates.
        for(const name in geometryAttributes)attributes.update(geometryAttributes[name], gl.ARRAY_BUFFER);
    }
    function updateWireframeAttribute(geometry) {
        const indices = [];
        const geometryIndex = geometry.index;
        const geometryPosition = geometry.attributes.position;
        let version = 0;
        if (geometryIndex !== null) {
            const array = geometryIndex.array;
            version = geometryIndex.version;
            for(let i = 0, l = array.length; i < l; i += 3){
                const a = array[i + 0];
                const b = array[i + 1];
                const c = array[i + 2];
                indices.push(a, b, b, c, c, a);
            }
        } else if (geometryPosition !== undefined) {
            const array = geometryPosition.array;
            version = geometryPosition.version;
            for(let i = 0, l = array.length / 3 - 1; i < l; i += 3){
                const a = i + 0;
                const b = i + 1;
                const c = i + 2;
                indices.push(a, b, b, c, c, a);
            }
        } else return;
        const attribute = new ((0, _threeCoreJs.arrayNeedsUint32)(indices) ? (0, _threeCoreJs.Uint32BufferAttribute) : (0, _threeCoreJs.Uint16BufferAttribute))(indices, 1);
        attribute.version = version;
        // Updating index buffer in VAO now. See WebGLBindingStates
        //
        const previousAttribute = wireframeAttributes.get(geometry);
        if (previousAttribute) attributes.remove(previousAttribute);
        //
        wireframeAttributes.set(geometry, attribute);
    }
    function getWireframeAttribute(geometry) {
        const currentAttribute = wireframeAttributes.get(geometry);
        if (currentAttribute) {
            const geometryIndex = geometry.index;
            if (geometryIndex !== null) // if the attribute is obsolete, create a new one
            {
                if (currentAttribute.version < geometryIndex.version) updateWireframeAttribute(geometry);
            }
        } else updateWireframeAttribute(geometry);
        return wireframeAttributes.get(geometry);
    }
    return {
        get: get,
        update: update,
        getWireframeAttribute: getWireframeAttribute
    };
}
function WebGLIndexedBufferRenderer(gl, extensions, info) {
    let mode;
    function setMode(value) {
        mode = value;
    }
    let type, bytesPerElement;
    function setIndex(value) {
        type = value.type;
        bytesPerElement = value.bytesPerElement;
    }
    function render(start, count) {
        gl.drawElements(mode, count, type, start * bytesPerElement);
        info.update(count, mode, 1);
    }
    function renderInstances(start, count, primcount) {
        if (primcount === 0) return;
        gl.drawElementsInstanced(mode, count, type, start * bytesPerElement, primcount);
        info.update(count, mode, primcount);
    }
    function renderMultiDraw(starts, counts, drawCount) {
        if (drawCount === 0) return;
        const extension = extensions.get('WEBGL_multi_draw');
        extension.multiDrawElementsWEBGL(mode, counts, 0, type, starts, 0, drawCount);
        let elementCount = 0;
        for(let i = 0; i < drawCount; i++)elementCount += counts[i];
        info.update(elementCount, mode, 1);
    }
    function renderMultiDrawInstances(starts, counts, drawCount, primcount) {
        if (drawCount === 0) return;
        const extension = extensions.get('WEBGL_multi_draw');
        if (extension === null) for(let i = 0; i < starts.length; i++)renderInstances(starts[i] / bytesPerElement, counts[i], primcount[i]);
        else {
            extension.multiDrawElementsInstancedWEBGL(mode, counts, 0, type, starts, 0, primcount, 0, drawCount);
            let elementCount = 0;
            for(let i = 0; i < drawCount; i++)elementCount += counts[i] * primcount[i];
            info.update(elementCount, mode, 1);
        }
    }
    //
    this.setMode = setMode;
    this.setIndex = setIndex;
    this.render = render;
    this.renderInstances = renderInstances;
    this.renderMultiDraw = renderMultiDraw;
    this.renderMultiDrawInstances = renderMultiDrawInstances;
}
function WebGLInfo(gl) {
    const memory = {
        geometries: 0,
        textures: 0
    };
    const render = {
        frame: 0,
        calls: 0,
        triangles: 0,
        points: 0,
        lines: 0
    };
    function update(count, mode, instanceCount) {
        render.calls++;
        switch(mode){
            case gl.TRIANGLES:
                render.triangles += instanceCount * (count / 3);
                break;
            case gl.LINES:
                render.lines += instanceCount * (count / 2);
                break;
            case gl.LINE_STRIP:
                render.lines += instanceCount * (count - 1);
                break;
            case gl.LINE_LOOP:
                render.lines += instanceCount * count;
                break;
            case gl.POINTS:
                render.points += instanceCount * count;
                break;
            default:
                (0, _threeCoreJs.error)('WebGLInfo: Unknown draw mode:', mode);
                break;
        }
    }
    function reset() {
        render.calls = 0;
        render.triangles = 0;
        render.points = 0;
        render.lines = 0;
    }
    return {
        memory: memory,
        render: render,
        programs: null,
        autoReset: true,
        reset: reset,
        update: update
    };
}
function WebGLMorphtargets(gl, capabilities, textures) {
    const morphTextures = new WeakMap();
    const morph = new (0, _threeCoreJs.Vector4)();
    function update(object, geometry, program) {
        const objectInfluences = object.morphTargetInfluences;
        // the following encodes morph targets into an array of data textures. Each layer represents a single morph target.
        const morphAttribute = geometry.morphAttributes.position || geometry.morphAttributes.normal || geometry.morphAttributes.color;
        const morphTargetsCount = morphAttribute !== undefined ? morphAttribute.length : 0;
        let entry = morphTextures.get(geometry);
        if (entry === undefined || entry.count !== morphTargetsCount) {
            if (entry !== undefined) entry.texture.dispose();
            const hasMorphPosition = geometry.morphAttributes.position !== undefined;
            const hasMorphNormals = geometry.morphAttributes.normal !== undefined;
            const hasMorphColors = geometry.morphAttributes.color !== undefined;
            const morphTargets = geometry.morphAttributes.position || [];
            const morphNormals = geometry.morphAttributes.normal || [];
            const morphColors = geometry.morphAttributes.color || [];
            let vertexDataCount = 0;
            if (hasMorphPosition === true) vertexDataCount = 1;
            if (hasMorphNormals === true) vertexDataCount = 2;
            if (hasMorphColors === true) vertexDataCount = 3;
            let width = geometry.attributes.position.count * vertexDataCount;
            let height = 1;
            if (width > capabilities.maxTextureSize) {
                height = Math.ceil(width / capabilities.maxTextureSize);
                width = capabilities.maxTextureSize;
            }
            const buffer = new Float32Array(width * height * 4 * morphTargetsCount);
            const texture = new (0, _threeCoreJs.DataArrayTexture)(buffer, width, height, morphTargetsCount);
            texture.type = (0, _threeCoreJs.FloatType);
            texture.needsUpdate = true;
            // fill buffer
            const vertexDataStride = vertexDataCount * 4;
            for(let i = 0; i < morphTargetsCount; i++){
                const morphTarget = morphTargets[i];
                const morphNormal = morphNormals[i];
                const morphColor = morphColors[i];
                const offset = width * height * 4 * i;
                for(let j = 0; j < morphTarget.count; j++){
                    const stride = j * vertexDataStride;
                    if (hasMorphPosition === true) {
                        morph.fromBufferAttribute(morphTarget, j);
                        buffer[offset + stride + 0] = morph.x;
                        buffer[offset + stride + 1] = morph.y;
                        buffer[offset + stride + 2] = morph.z;
                        buffer[offset + stride + 3] = 0;
                    }
                    if (hasMorphNormals === true) {
                        morph.fromBufferAttribute(morphNormal, j);
                        buffer[offset + stride + 4] = morph.x;
                        buffer[offset + stride + 5] = morph.y;
                        buffer[offset + stride + 6] = morph.z;
                        buffer[offset + stride + 7] = 0;
                    }
                    if (hasMorphColors === true) {
                        morph.fromBufferAttribute(morphColor, j);
                        buffer[offset + stride + 8] = morph.x;
                        buffer[offset + stride + 9] = morph.y;
                        buffer[offset + stride + 10] = morph.z;
                        buffer[offset + stride + 11] = morphColor.itemSize === 4 ? morph.w : 1;
                    }
                }
            }
            entry = {
                count: morphTargetsCount,
                texture: texture,
                size: new (0, _threeCoreJs.Vector2)(width, height)
            };
            morphTextures.set(geometry, entry);
            function disposeTexture() {
                texture.dispose();
                morphTextures.delete(geometry);
                geometry.removeEventListener('dispose', disposeTexture);
            }
            geometry.addEventListener('dispose', disposeTexture);
        }
        //
        if (object.isInstancedMesh === true && object.morphTexture !== null) program.getUniforms().setValue(gl, 'morphTexture', object.morphTexture, textures);
        else {
            let morphInfluencesSum = 0;
            for(let i = 0; i < objectInfluences.length; i++)morphInfluencesSum += objectInfluences[i];
            const morphBaseInfluence = geometry.morphTargetsRelative ? 1 : 1 - morphInfluencesSum;
            program.getUniforms().setValue(gl, 'morphTargetBaseInfluence', morphBaseInfluence);
            program.getUniforms().setValue(gl, 'morphTargetInfluences', objectInfluences);
        }
        program.getUniforms().setValue(gl, 'morphTargetsTexture', entry.texture, textures);
        program.getUniforms().setValue(gl, 'morphTargetsTextureSize', entry.size);
    }
    return {
        update: update
    };
}
function WebGLObjects(gl, geometries, attributes, info) {
    let updateMap = new WeakMap();
    function update(object) {
        const frame = info.render.frame;
        const geometry = object.geometry;
        const buffergeometry = geometries.get(object, geometry);
        // Update once per frame
        if (updateMap.get(buffergeometry) !== frame) {
            geometries.update(buffergeometry);
            updateMap.set(buffergeometry, frame);
        }
        if (object.isInstancedMesh) {
            if (object.hasEventListener('dispose', onInstancedMeshDispose) === false) object.addEventListener('dispose', onInstancedMeshDispose);
            if (updateMap.get(object) !== frame) {
                attributes.update(object.instanceMatrix, gl.ARRAY_BUFFER);
                if (object.instanceColor !== null) attributes.update(object.instanceColor, gl.ARRAY_BUFFER);
                updateMap.set(object, frame);
            }
        }
        if (object.isSkinnedMesh) {
            const skeleton = object.skeleton;
            if (updateMap.get(skeleton) !== frame) {
                skeleton.update();
                updateMap.set(skeleton, frame);
            }
        }
        return buffergeometry;
    }
    function dispose() {
        updateMap = new WeakMap();
    }
    function onInstancedMeshDispose(event) {
        const instancedMesh = event.target;
        instancedMesh.removeEventListener('dispose', onInstancedMeshDispose);
        attributes.remove(instancedMesh.instanceMatrix);
        if (instancedMesh.instanceColor !== null) attributes.remove(instancedMesh.instanceColor);
    }
    return {
        update: update,
        dispose: dispose
    };
}
const toneMappingMap = {
    [(0, _threeCoreJs.LinearToneMapping)]: 'LINEAR_TONE_MAPPING',
    [(0, _threeCoreJs.ReinhardToneMapping)]: 'REINHARD_TONE_MAPPING',
    [(0, _threeCoreJs.CineonToneMapping)]: 'CINEON_TONE_MAPPING',
    [(0, _threeCoreJs.ACESFilmicToneMapping)]: 'ACES_FILMIC_TONE_MAPPING',
    [(0, _threeCoreJs.AgXToneMapping)]: 'AGX_TONE_MAPPING',
    [(0, _threeCoreJs.NeutralToneMapping)]: 'NEUTRAL_TONE_MAPPING',
    [(0, _threeCoreJs.CustomToneMapping)]: 'CUSTOM_TONE_MAPPING'
};
function WebGLOutput(type, width, height, depth, stencil) {
    // render targets for scene and post-processing
    const targetA = new (0, _threeCoreJs.WebGLRenderTarget)(width, height, {
        type: type,
        depthBuffer: depth,
        stencilBuffer: stencil
    });
    const targetB = new (0, _threeCoreJs.WebGLRenderTarget)(width, height, {
        type: (0, _threeCoreJs.HalfFloatType),
        depthBuffer: false,
        stencilBuffer: false
    });
    // create fullscreen triangle geometry
    const geometry = new (0, _threeCoreJs.BufferGeometry)();
    geometry.setAttribute('position', new (0, _threeCoreJs.Float32BufferAttribute)([
        -1,
        3,
        0,
        -1,
        -1,
        0,
        3,
        -1,
        0
    ], 3));
    geometry.setAttribute('uv', new (0, _threeCoreJs.Float32BufferAttribute)([
        0,
        2,
        0,
        0,
        2,
        0
    ], 2));
    // create output material with tone mapping support
    const material = new (0, _threeCoreJs.RawShaderMaterial)({
        uniforms: {
            tDiffuse: {
                value: null
            }
        },
        vertexShader: /* glsl */ `
			precision highp float;

			uniform mat4 modelViewMatrix;
			uniform mat4 projectionMatrix;

			attribute vec3 position;
			attribute vec2 uv;

			varying vec2 vUv;

			void main() {
				vUv = uv;
				gl_Position = projectionMatrix * modelViewMatrix * vec4( position, 1.0 );
			}`,
        fragmentShader: /* glsl */ `
			precision highp float;

			uniform sampler2D tDiffuse;

			varying vec2 vUv;

			#include <tonemapping_pars_fragment>
			#include <colorspace_pars_fragment>

			void main() {
				gl_FragColor = texture2D( tDiffuse, vUv );

				#ifdef LINEAR_TONE_MAPPING
					gl_FragColor.rgb = LinearToneMapping( gl_FragColor.rgb );
				#elif defined( REINHARD_TONE_MAPPING )
					gl_FragColor.rgb = ReinhardToneMapping( gl_FragColor.rgb );
				#elif defined( CINEON_TONE_MAPPING )
					gl_FragColor.rgb = CineonToneMapping( gl_FragColor.rgb );
				#elif defined( ACES_FILMIC_TONE_MAPPING )
					gl_FragColor.rgb = ACESFilmicToneMapping( gl_FragColor.rgb );
				#elif defined( AGX_TONE_MAPPING )
					gl_FragColor.rgb = AgXToneMapping( gl_FragColor.rgb );
				#elif defined( NEUTRAL_TONE_MAPPING )
					gl_FragColor.rgb = NeutralToneMapping( gl_FragColor.rgb );
				#elif defined( CUSTOM_TONE_MAPPING )
					gl_FragColor.rgb = CustomToneMapping( gl_FragColor.rgb );
				#endif

				#ifdef SRGB_TRANSFER
					gl_FragColor = sRGBTransferOETF( gl_FragColor );
				#endif
			}`,
        depthTest: false,
        depthWrite: false
    });
    const mesh = new (0, _threeCoreJs.Mesh)(geometry, material);
    const camera = new (0, _threeCoreJs.OrthographicCamera)(-1, 1, 1, -1, 0, 1);
    let _outputColorSpace = null;
    let _outputToneMapping = null;
    let _isCompositing = false;
    let _savedToneMapping;
    let _savedRenderTarget = null;
    let _effects = [];
    let _hasRenderPass = false;
    this.setSize = function(width, height) {
        targetA.setSize(width, height);
        targetB.setSize(width, height);
        for(let i = 0; i < _effects.length; i++){
            const effect = _effects[i];
            if (effect.setSize) effect.setSize(width, height);
        }
    };
    this.setEffects = function(effects) {
        _effects = effects;
        _hasRenderPass = _effects.length > 0 && _effects[0].isRenderPass === true;
        const width = targetA.width;
        const height = targetA.height;
        for(let i = 0; i < _effects.length; i++){
            const effect = _effects[i];
            if (effect.setSize) effect.setSize(width, height);
        }
    };
    this.begin = function(renderer, renderTarget) {
        // Don't begin during compositing phase (post-processing effects call render())
        if (_isCompositing) return false;
        if (renderer.toneMapping === (0, _threeCoreJs.NoToneMapping) && _effects.length === 0) return false;
        _savedRenderTarget = renderTarget;
        // resize internal buffers to match render target (e.g. XR resolution)
        if (renderTarget !== null) {
            const width = renderTarget.width;
            const height = renderTarget.height;
            if (targetA.width !== width || targetA.height !== height) this.setSize(width, height);
        }
        // if first effect is a RenderPass, it will set its own render target
        if (_hasRenderPass === false) renderer.setRenderTarget(targetA);
        // disable tone mapping during render - it will be applied in end()
        _savedToneMapping = renderer.toneMapping;
        renderer.toneMapping = (0, _threeCoreJs.NoToneMapping);
        return true;
    };
    this.hasRenderPass = function() {
        return _hasRenderPass;
    };
    this.end = function(renderer, deltaTime) {
        // restore tone mapping
        renderer.toneMapping = _savedToneMapping;
        _isCompositing = true;
        // run post-processing effects
        let readBuffer = targetA;
        let writeBuffer = targetB;
        for(let i = 0; i < _effects.length; i++){
            const effect = _effects[i];
            if (effect.enabled === false) continue;
            effect.render(renderer, writeBuffer, readBuffer, deltaTime);
            if (effect.needsSwap !== false) {
                const temp = readBuffer;
                readBuffer = writeBuffer;
                writeBuffer = temp;
            }
        }
        // update output material defines if settings changed
        if (_outputColorSpace !== renderer.outputColorSpace || _outputToneMapping !== renderer.toneMapping) {
            _outputColorSpace = renderer.outputColorSpace;
            _outputToneMapping = renderer.toneMapping;
            material.defines = {};
            if ((0, _threeCoreJs.ColorManagement).getTransfer(_outputColorSpace) === (0, _threeCoreJs.SRGBTransfer)) material.defines.SRGB_TRANSFER = '';
            const toneMapping = toneMappingMap[_outputToneMapping];
            if (toneMapping) material.defines[toneMapping] = '';
            material.needsUpdate = true;
        }
        // final output to canvas (or XR render target)
        material.uniforms.tDiffuse.value = readBuffer.texture;
        renderer.setRenderTarget(_savedRenderTarget);
        renderer.render(mesh, camera);
        _savedRenderTarget = null;
        _isCompositing = false;
    };
    this.isCompositing = function() {
        return _isCompositing;
    };
    this.dispose = function() {
        targetA.dispose();
        targetB.dispose();
        geometry.dispose();
        material.dispose();
    };
}
/**
 * Uniforms of a program.
 * Those form a tree structure with a special top-level container for the root,
 * which you get by calling 'new WebGLUniforms( gl, program )'.
 *
 *
 * Properties of inner nodes including the top-level container:
 *
 * .seq - array of nested uniforms
 * .map - nested uniforms by name
 *
 *
 * Methods of all nodes except the top-level container:
 *
 * .setValue( gl, value, [textures] )
 *
 * 		uploads a uniform value(s)
 *  	the 'textures' parameter is needed for sampler uniforms
 *
 *
 * Static methods of the top-level container (textures factorizations):
 *
 * .upload( gl, seq, values, textures )
 *
 * 		sets uniforms in 'seq' to 'values[id].value'
 *
 * .seqWithValue( seq, values ) : filteredSeq
 *
 * 		filters 'seq' entries with corresponding entry in values
 *
 *
 * Methods of the top-level container (textures factorizations):
 *
 * .setValue( gl, name, value, textures )
 *
 * 		sets uniform with  name 'name' to 'value'
 *
 * .setOptional( gl, obj, prop )
 *
 * 		like .set for an optional property of the object
 *
 */ const emptyTexture = /*@__PURE__*/ new (0, _threeCoreJs.Texture)();
const emptyShadowTexture = /*@__PURE__*/ new (0, _threeCoreJs.DepthTexture)(1, 1);
const emptyArrayTexture = /*@__PURE__*/ new (0, _threeCoreJs.DataArrayTexture)();
const empty3dTexture = /*@__PURE__*/ new (0, _threeCoreJs.Data3DTexture)();
const emptyCubeTexture = /*@__PURE__*/ new (0, _threeCoreJs.CubeTexture)();
// --- Utilities ---
// Array Caches (provide typed arrays for temporary by size)
const arrayCacheF32 = [];
const arrayCacheI32 = [];
// Float32Array caches used for uploading Matrix uniforms
const mat4array = new Float32Array(16);
const mat3array = new Float32Array(9);
const mat2array = new Float32Array(4);
// Flattening for arrays of vectors and matrices
function flatten(array, nBlocks, blockSize) {
    const firstElem = array[0];
    if (firstElem <= 0 || firstElem > 0) return array;
    // unoptimized: ! isNaN( firstElem )
    // see http://jacksondunstan.com/articles/983
    const n = nBlocks * blockSize;
    let r = arrayCacheF32[n];
    if (r === undefined) {
        r = new Float32Array(n);
        arrayCacheF32[n] = r;
    }
    if (nBlocks !== 0) {
        firstElem.toArray(r, 0);
        for(let i = 1, offset = 0; i !== nBlocks; ++i){
            offset += blockSize;
            array[i].toArray(r, offset);
        }
    }
    return r;
}
function arraysEqual(a, b) {
    if (a.length !== b.length) return false;
    for(let i = 0, l = a.length; i < l; i++){
        if (a[i] !== b[i]) return false;
    }
    return true;
}
function copyArray(a, b) {
    for(let i = 0, l = b.length; i < l; i++)a[i] = b[i];
}
// Texture unit allocation
function allocTexUnits(textures, n) {
    let r = arrayCacheI32[n];
    if (r === undefined) {
        r = new Int32Array(n);
        arrayCacheI32[n] = r;
    }
    for(let i = 0; i !== n; ++i)r[i] = textures.allocateTextureUnit();
    return r;
}
// --- Setters ---
// Note: Defining these methods externally, because they come in a bunch
// and this way their names minify.
// Single scalar
function setValueV1f(gl, v) {
    const cache = this.cache;
    if (cache[0] === v) return;
    gl.uniform1f(this.addr, v);
    cache[0] = v;
}
// Single float vector (from flat array or THREE.VectorN)
function setValueV2f(gl, v) {
    const cache = this.cache;
    if (v.x !== undefined) {
        if (cache[0] !== v.x || cache[1] !== v.y) {
            gl.uniform2f(this.addr, v.x, v.y);
            cache[0] = v.x;
            cache[1] = v.y;
        }
    } else {
        if (arraysEqual(cache, v)) return;
        gl.uniform2fv(this.addr, v);
        copyArray(cache, v);
    }
}
function setValueV3f(gl, v) {
    const cache = this.cache;
    if (v.x !== undefined) {
        if (cache[0] !== v.x || cache[1] !== v.y || cache[2] !== v.z) {
            gl.uniform3f(this.addr, v.x, v.y, v.z);
            cache[0] = v.x;
            cache[1] = v.y;
            cache[2] = v.z;
        }
    } else if (v.r !== undefined) {
        if (cache[0] !== v.r || cache[1] !== v.g || cache[2] !== v.b) {
            gl.uniform3f(this.addr, v.r, v.g, v.b);
            cache[0] = v.r;
            cache[1] = v.g;
            cache[2] = v.b;
        }
    } else {
        if (arraysEqual(cache, v)) return;
        gl.uniform3fv(this.addr, v);
        copyArray(cache, v);
    }
}
function setValueV4f(gl, v) {
    const cache = this.cache;
    if (v.x !== undefined) {
        if (cache[0] !== v.x || cache[1] !== v.y || cache[2] !== v.z || cache[3] !== v.w) {
            gl.uniform4f(this.addr, v.x, v.y, v.z, v.w);
            cache[0] = v.x;
            cache[1] = v.y;
            cache[2] = v.z;
            cache[3] = v.w;
        }
    } else {
        if (arraysEqual(cache, v)) return;
        gl.uniform4fv(this.addr, v);
        copyArray(cache, v);
    }
}
// Single matrix (from flat array or THREE.MatrixN)
function setValueM2(gl, v) {
    const cache = this.cache;
    const elements = v.elements;
    if (elements === undefined) {
        if (arraysEqual(cache, v)) return;
        gl.uniformMatrix2fv(this.addr, false, v);
        copyArray(cache, v);
    } else {
        if (arraysEqual(cache, elements)) return;
        mat2array.set(elements);
        gl.uniformMatrix2fv(this.addr, false, mat2array);
        copyArray(cache, elements);
    }
}
function setValueM3(gl, v) {
    const cache = this.cache;
    const elements = v.elements;
    if (elements === undefined) {
        if (arraysEqual(cache, v)) return;
        gl.uniformMatrix3fv(this.addr, false, v);
        copyArray(cache, v);
    } else {
        if (arraysEqual(cache, elements)) return;
        mat3array.set(elements);
        gl.uniformMatrix3fv(this.addr, false, mat3array);
        copyArray(cache, elements);
    }
}
function setValueM4(gl, v) {
    const cache = this.cache;
    const elements = v.elements;
    if (elements === undefined) {
        if (arraysEqual(cache, v)) return;
        gl.uniformMatrix4fv(this.addr, false, v);
        copyArray(cache, v);
    } else {
        if (arraysEqual(cache, elements)) return;
        mat4array.set(elements);
        gl.uniformMatrix4fv(this.addr, false, mat4array);
        copyArray(cache, elements);
    }
}
// Single integer / boolean
function setValueV1i(gl, v) {
    const cache = this.cache;
    if (cache[0] === v) return;
    gl.uniform1i(this.addr, v);
    cache[0] = v;
}
// Single integer / boolean vector (from flat array or THREE.VectorN)
function setValueV2i(gl, v) {
    const cache = this.cache;
    if (v.x !== undefined) {
        if (cache[0] !== v.x || cache[1] !== v.y) {
            gl.uniform2i(this.addr, v.x, v.y);
            cache[0] = v.x;
            cache[1] = v.y;
        }
    } else {
        if (arraysEqual(cache, v)) return;
        gl.uniform2iv(this.addr, v);
        copyArray(cache, v);
    }
}
function setValueV3i(gl, v) {
    const cache = this.cache;
    if (v.x !== undefined) {
        if (cache[0] !== v.x || cache[1] !== v.y || cache[2] !== v.z) {
            gl.uniform3i(this.addr, v.x, v.y, v.z);
            cache[0] = v.x;
            cache[1] = v.y;
            cache[2] = v.z;
        }
    } else {
        if (arraysEqual(cache, v)) return;
        gl.uniform3iv(this.addr, v);
        copyArray(cache, v);
    }
}
function setValueV4i(gl, v) {
    const cache = this.cache;
    if (v.x !== undefined) {
        if (cache[0] !== v.x || cache[1] !== v.y || cache[2] !== v.z || cache[3] !== v.w) {
            gl.uniform4i(this.addr, v.x, v.y, v.z, v.w);
            cache[0] = v.x;
            cache[1] = v.y;
            cache[2] = v.z;
            cache[3] = v.w;
        }
    } else {
        if (arraysEqual(cache, v)) return;
        gl.uniform4iv(this.addr, v);
        copyArray(cache, v);
    }
}
// Single unsigned integer
function setValueV1ui(gl, v) {
    const cache = this.cache;
    if (cache[0] === v) return;
    gl.uniform1ui(this.addr, v);
    cache[0] = v;
}
// Single unsigned integer vector (from flat array or THREE.VectorN)
function setValueV2ui(gl, v) {
    const cache = this.cache;
    if (v.x !== undefined) {
        if (cache[0] !== v.x || cache[1] !== v.y) {
            gl.uniform2ui(this.addr, v.x, v.y);
            cache[0] = v.x;
            cache[1] = v.y;
        }
    } else {
        if (arraysEqual(cache, v)) return;
        gl.uniform2uiv(this.addr, v);
        copyArray(cache, v);
    }
}
function setValueV3ui(gl, v) {
    const cache = this.cache;
    if (v.x !== undefined) {
        if (cache[0] !== v.x || cache[1] !== v.y || cache[2] !== v.z) {
            gl.uniform3ui(this.addr, v.x, v.y, v.z);
            cache[0] = v.x;
            cache[1] = v.y;
            cache[2] = v.z;
        }
    } else {
        if (arraysEqual(cache, v)) return;
        gl.uniform3uiv(this.addr, v);
        copyArray(cache, v);
    }
}
function setValueV4ui(gl, v) {
    const cache = this.cache;
    if (v.x !== undefined) {
        if (cache[0] !== v.x || cache[1] !== v.y || cache[2] !== v.z || cache[3] !== v.w) {
            gl.uniform4ui(this.addr, v.x, v.y, v.z, v.w);
            cache[0] = v.x;
            cache[1] = v.y;
            cache[2] = v.z;
            cache[3] = v.w;
        }
    } else {
        if (arraysEqual(cache, v)) return;
        gl.uniform4uiv(this.addr, v);
        copyArray(cache, v);
    }
}
// Single texture (2D / Cube)
function setValueT1(gl, v, textures) {
    const cache = this.cache;
    const unit = textures.allocateTextureUnit();
    if (cache[0] !== unit) {
        gl.uniform1i(this.addr, unit);
        cache[0] = unit;
    }
    let emptyTexture2D;
    if (this.type === gl.SAMPLER_2D_SHADOW) {
        emptyShadowTexture.compareFunction = textures.isReversedDepthBuffer() ? (0, _threeCoreJs.GreaterEqualCompare) : (0, _threeCoreJs.LessEqualCompare);
        emptyTexture2D = emptyShadowTexture;
    } else emptyTexture2D = emptyTexture;
    textures.setTexture2D(v || emptyTexture2D, unit);
}
function setValueT3D1(gl, v, textures) {
    const cache = this.cache;
    const unit = textures.allocateTextureUnit();
    if (cache[0] !== unit) {
        gl.uniform1i(this.addr, unit);
        cache[0] = unit;
    }
    textures.setTexture3D(v || empty3dTexture, unit);
}
function setValueT6(gl, v, textures) {
    const cache = this.cache;
    const unit = textures.allocateTextureUnit();
    if (cache[0] !== unit) {
        gl.uniform1i(this.addr, unit);
        cache[0] = unit;
    }
    textures.setTextureCube(v || emptyCubeTexture, unit);
}
function setValueT2DArray1(gl, v, textures) {
    const cache = this.cache;
    const unit = textures.allocateTextureUnit();
    if (cache[0] !== unit) {
        gl.uniform1i(this.addr, unit);
        cache[0] = unit;
    }
    textures.setTexture2DArray(v || emptyArrayTexture, unit);
}
// Helper to pick the right setter for the singular case
function getSingularSetter(type) {
    switch(type){
        case 0x1406:
            return setValueV1f; // FLOAT
        case 0x8b50:
            return setValueV2f; // _VEC2
        case 0x8b51:
            return setValueV3f; // _VEC3
        case 0x8b52:
            return setValueV4f; // _VEC4
        case 0x8b5a:
            return setValueM2; // _MAT2
        case 0x8b5b:
            return setValueM3; // _MAT3
        case 0x8b5c:
            return setValueM4; // _MAT4
        case 0x1404:
        case 0x8b56:
            return setValueV1i; // INT, BOOL
        case 0x8b53:
        case 0x8b57:
            return setValueV2i; // _VEC2
        case 0x8b54:
        case 0x8b58:
            return setValueV3i; // _VEC3
        case 0x8b55:
        case 0x8b59:
            return setValueV4i; // _VEC4
        case 0x1405:
            return setValueV1ui; // UINT
        case 0x8dc6:
            return setValueV2ui; // _VEC2
        case 0x8dc7:
            return setValueV3ui; // _VEC3
        case 0x8dc8:
            return setValueV4ui; // _VEC4
        case 0x8b5e:
        case 0x8d66:
        case 0x8dca:
        case 0x8dd2:
        case 0x8b62:
            return setValueT1;
        case 0x8b5f:
        case 0x8dcb:
        case 0x8dd3:
            return setValueT3D1;
        case 0x8b60:
        case 0x8dcc:
        case 0x8dd4:
        case 0x8dc5:
            return setValueT6;
        case 0x8dc1:
        case 0x8dcf:
        case 0x8dd7:
        case 0x8dc4:
            return setValueT2DArray1;
    }
}
// Array of scalars
function setValueV1fArray(gl, v) {
    gl.uniform1fv(this.addr, v);
}
// Array of vectors (from flat array or array of THREE.VectorN)
function setValueV2fArray(gl, v) {
    const data = flatten(v, this.size, 2);
    gl.uniform2fv(this.addr, data);
}
function setValueV3fArray(gl, v) {
    const data = flatten(v, this.size, 3);
    gl.uniform3fv(this.addr, data);
}
function setValueV4fArray(gl, v) {
    const data = flatten(v, this.size, 4);
    gl.uniform4fv(this.addr, data);
}
// Array of matrices (from flat array or array of THREE.MatrixN)
function setValueM2Array(gl, v) {
    const data = flatten(v, this.size, 4);
    gl.uniformMatrix2fv(this.addr, false, data);
}
function setValueM3Array(gl, v) {
    const data = flatten(v, this.size, 9);
    gl.uniformMatrix3fv(this.addr, false, data);
}
function setValueM4Array(gl, v) {
    const data = flatten(v, this.size, 16);
    gl.uniformMatrix4fv(this.addr, false, data);
}
// Array of integer / boolean
function setValueV1iArray(gl, v) {
    gl.uniform1iv(this.addr, v);
}
// Array of integer / boolean vectors (from flat array)
function setValueV2iArray(gl, v) {
    gl.uniform2iv(this.addr, v);
}
function setValueV3iArray(gl, v) {
    gl.uniform3iv(this.addr, v);
}
function setValueV4iArray(gl, v) {
    gl.uniform4iv(this.addr, v);
}
// Array of unsigned integer
function setValueV1uiArray(gl, v) {
    gl.uniform1uiv(this.addr, v);
}
// Array of unsigned integer vectors (from flat array)
function setValueV2uiArray(gl, v) {
    gl.uniform2uiv(this.addr, v);
}
function setValueV3uiArray(gl, v) {
    gl.uniform3uiv(this.addr, v);
}
function setValueV4uiArray(gl, v) {
    gl.uniform4uiv(this.addr, v);
}
// Array of textures (2D / 3D / Cube / 2DArray)
function setValueT1Array(gl, v, textures) {
    const cache = this.cache;
    const n = v.length;
    const units = allocTexUnits(textures, n);
    if (!arraysEqual(cache, units)) {
        gl.uniform1iv(this.addr, units);
        copyArray(cache, units);
    }
    let emptyTexture2D;
    if (this.type === gl.SAMPLER_2D_SHADOW) emptyTexture2D = emptyShadowTexture;
    else emptyTexture2D = emptyTexture;
    for(let i = 0; i !== n; ++i)textures.setTexture2D(v[i] || emptyTexture2D, units[i]);
}
function setValueT3DArray(gl, v, textures) {
    const cache = this.cache;
    const n = v.length;
    const units = allocTexUnits(textures, n);
    if (!arraysEqual(cache, units)) {
        gl.uniform1iv(this.addr, units);
        copyArray(cache, units);
    }
    for(let i = 0; i !== n; ++i)textures.setTexture3D(v[i] || empty3dTexture, units[i]);
}
function setValueT6Array(gl, v, textures) {
    const cache = this.cache;
    const n = v.length;
    const units = allocTexUnits(textures, n);
    if (!arraysEqual(cache, units)) {
        gl.uniform1iv(this.addr, units);
        copyArray(cache, units);
    }
    for(let i = 0; i !== n; ++i)textures.setTextureCube(v[i] || emptyCubeTexture, units[i]);
}
function setValueT2DArrayArray(gl, v, textures) {
    const cache = this.cache;
    const n = v.length;
    const units = allocTexUnits(textures, n);
    if (!arraysEqual(cache, units)) {
        gl.uniform1iv(this.addr, units);
        copyArray(cache, units);
    }
    for(let i = 0; i !== n; ++i)textures.setTexture2DArray(v[i] || emptyArrayTexture, units[i]);
}
// Helper to pick the right setter for a pure (bottom-level) array
function getPureArraySetter(type) {
    switch(type){
        case 0x1406:
            return setValueV1fArray; // FLOAT
        case 0x8b50:
            return setValueV2fArray; // _VEC2
        case 0x8b51:
            return setValueV3fArray; // _VEC3
        case 0x8b52:
            return setValueV4fArray; // _VEC4
        case 0x8b5a:
            return setValueM2Array; // _MAT2
        case 0x8b5b:
            return setValueM3Array; // _MAT3
        case 0x8b5c:
            return setValueM4Array; // _MAT4
        case 0x1404:
        case 0x8b56:
            return setValueV1iArray; // INT, BOOL
        case 0x8b53:
        case 0x8b57:
            return setValueV2iArray; // _VEC2
        case 0x8b54:
        case 0x8b58:
            return setValueV3iArray; // _VEC3
        case 0x8b55:
        case 0x8b59:
            return setValueV4iArray; // _VEC4
        case 0x1405:
            return setValueV1uiArray; // UINT
        case 0x8dc6:
            return setValueV2uiArray; // _VEC2
        case 0x8dc7:
            return setValueV3uiArray; // _VEC3
        case 0x8dc8:
            return setValueV4uiArray; // _VEC4
        case 0x8b5e:
        case 0x8d66:
        case 0x8dca:
        case 0x8dd2:
        case 0x8b62:
            return setValueT1Array;
        case 0x8b5f:
        case 0x8dcb:
        case 0x8dd3:
            return setValueT3DArray;
        case 0x8b60:
        case 0x8dcc:
        case 0x8dd4:
        case 0x8dc5:
            return setValueT6Array;
        case 0x8dc1:
        case 0x8dcf:
        case 0x8dd7:
        case 0x8dc4:
            return setValueT2DArrayArray;
    }
}
// --- Uniform Classes ---
class SingleUniform {
    constructor(id, activeInfo, addr){
        this.id = id;
        this.addr = addr;
        this.cache = [];
        this.type = activeInfo.type;
        this.setValue = getSingularSetter(activeInfo.type);
    // this.path = activeInfo.name; // DEBUG
    }
}
class PureArrayUniform {
    constructor(id, activeInfo, addr){
        this.id = id;
        this.addr = addr;
        this.cache = [];
        this.type = activeInfo.type;
        this.size = activeInfo.size;
        this.setValue = getPureArraySetter(activeInfo.type);
    // this.path = activeInfo.name; // DEBUG
    }
}
class StructuredUniform {
    constructor(id){
        this.id = id;
        this.seq = [];
        this.map = {};
    }
    setValue(gl, value, textures) {
        const seq = this.seq;
        for(let i = 0, n = seq.length; i !== n; ++i){
            const u = seq[i];
            u.setValue(gl, value[u.id], textures);
        }
    }
}
// --- Top-level ---
// Parser - builds up the property tree from the path strings
const RePathPart = /(\w+)(\])?(\[|\.)?/g;
// extracts
// 	- the identifier (member name or array index)
//  - followed by an optional right bracket (found when array index)
//  - followed by an optional left bracket or dot (type of subscript)
//
// Note: These portions can be read in a non-overlapping fashion and
// allow straightforward parsing of the hierarchy that WebGL encodes
// in the uniform names.
function addUniform(container, uniformObject) {
    container.seq.push(uniformObject);
    container.map[uniformObject.id] = uniformObject;
}
function parseUniform(activeInfo, addr, container) {
    const path = activeInfo.name, pathLength = path.length;
    // reset RegExp object, because of the early exit of a previous run
    RePathPart.lastIndex = 0;
    while(true){
        const match = RePathPart.exec(path), matchEnd = RePathPart.lastIndex;
        let id = match[1];
        const idIsIndex = match[2] === ']', subscript = match[3];
        if (idIsIndex) id = id | 0; // convert to integer
        if (subscript === undefined || subscript === '[' && matchEnd + 2 === pathLength) {
            // bare name or "pure" bottom-level array "[0]" suffix
            addUniform(container, subscript === undefined ? new SingleUniform(id, activeInfo, addr) : new PureArrayUniform(id, activeInfo, addr));
            break;
        } else {
            // step into inner node / create it in case it doesn't exist
            const map = container.map;
            let next = map[id];
            if (next === undefined) {
                next = new StructuredUniform(id);
                addUniform(container, next);
            }
            container = next;
        }
    }
}
// Root Container
class WebGLUniforms {
    constructor(gl, program){
        this.seq = [];
        this.map = {};
        const n = gl.getProgramParameter(program, gl.ACTIVE_UNIFORMS);
        for(let i = 0; i < n; ++i){
            const info = gl.getActiveUniform(program, i), addr = gl.getUniformLocation(program, info.name);
            parseUniform(info, addr, this);
        }
        // Sort uniforms to prioritize shadow samplers first (for optimal texture unit allocation)
        const shadowSamplers = [];
        const otherUniforms = [];
        for (const u of this.seq)if (u.type === gl.SAMPLER_2D_SHADOW || u.type === gl.SAMPLER_CUBE_SHADOW || u.type === gl.SAMPLER_2D_ARRAY_SHADOW) shadowSamplers.push(u);
        else otherUniforms.push(u);
        if (shadowSamplers.length > 0) this.seq = shadowSamplers.concat(otherUniforms);
    }
    setValue(gl, name, value, textures) {
        const u = this.map[name];
        if (u !== undefined) u.setValue(gl, value, textures);
    }
    setOptional(gl, object, name) {
        const v = object[name];
        if (v !== undefined) this.setValue(gl, name, v);
    }
    static upload(gl, seq, values, textures) {
        for(let i = 0, n = seq.length; i !== n; ++i){
            const u = seq[i], v = values[u.id];
            if (v.needsUpdate !== false) // note: always updating when .needsUpdate is undefined
            u.setValue(gl, v.value, textures);
        }
    }
    static seqWithValue(seq, values) {
        const r = [];
        for(let i = 0, n = seq.length; i !== n; ++i){
            const u = seq[i];
            if (u.id in values) r.push(u);
        }
        return r;
    }
}
function WebGLShader(gl, type, string) {
    const shader = gl.createShader(type);
    gl.shaderSource(shader, string);
    gl.compileShader(shader);
    return shader;
}
// From https://www.khronos.org/registry/webgl/extensions/KHR_parallel_shader_compile/
const COMPLETION_STATUS_KHR = 0x91B1;
let programIdCount = 0;
function handleSource(string, errorLine) {
    const lines = string.split('\n');
    const lines2 = [];
    const from = Math.max(errorLine - 6, 0);
    const to = Math.min(errorLine + 6, lines.length);
    for(let i = from; i < to; i++){
        const line = i + 1;
        lines2.push(`${line === errorLine ? '>' : ' '} ${line}: ${lines[i]}`);
    }
    return lines2.join('\n');
}
const _m0 = /*@__PURE__*/ new (0, _threeCoreJs.Matrix3)();
function getEncodingComponents(colorSpace) {
    (0, _threeCoreJs.ColorManagement)._getMatrix(_m0, (0, _threeCoreJs.ColorManagement).workingColorSpace, colorSpace);
    const encodingMatrix = `mat3( ${_m0.elements.map((v)=>v.toFixed(4))} )`;
    switch((0, _threeCoreJs.ColorManagement).getTransfer(colorSpace)){
        case 0, _threeCoreJs.LinearTransfer:
            return [
                encodingMatrix,
                'LinearTransferOETF'
            ];
        case 0, _threeCoreJs.SRGBTransfer:
            return [
                encodingMatrix,
                'sRGBTransferOETF'
            ];
        default:
            (0, _threeCoreJs.warn)('WebGLProgram: Unsupported color space: ', colorSpace);
            return [
                encodingMatrix,
                'LinearTransferOETF'
            ];
    }
}
function getShaderErrors(gl, shader, type) {
    const status = gl.getShaderParameter(shader, gl.COMPILE_STATUS);
    const shaderInfoLog = gl.getShaderInfoLog(shader) || '';
    const errors = shaderInfoLog.trim();
    if (status && errors === '') return '';
    const errorMatches = /ERROR: 0:(\d+)/.exec(errors);
    if (errorMatches) {
        // --enable-privileged-webgl-extension
        // log( '**' + type + '**', gl.getExtension( 'WEBGL_debug_shaders' ).getTranslatedShaderSource( shader ) );
        const errorLine = parseInt(errorMatches[1]);
        return type.toUpperCase() + '\n\n' + errors + '\n\n' + handleSource(gl.getShaderSource(shader), errorLine);
    } else return errors;
}
function getTexelEncodingFunction(functionName, colorSpace) {
    const components = getEncodingComponents(colorSpace);
    return [
        `vec4 ${functionName}( vec4 value ) {`,
        `	return ${components[1]}( vec4( value.rgb * ${components[0]}, value.a ) );`,
        '}'
    ].join('\n');
}
const toneMappingFunctions = {
    [(0, _threeCoreJs.LinearToneMapping)]: 'Linear',
    [(0, _threeCoreJs.ReinhardToneMapping)]: 'Reinhard',
    [(0, _threeCoreJs.CineonToneMapping)]: 'Cineon',
    [(0, _threeCoreJs.ACESFilmicToneMapping)]: 'ACESFilmic',
    [(0, _threeCoreJs.AgXToneMapping)]: 'AgX',
    [(0, _threeCoreJs.NeutralToneMapping)]: 'Neutral',
    [(0, _threeCoreJs.CustomToneMapping)]: 'Custom'
};
function getToneMappingFunction(functionName, toneMapping) {
    const toneMappingName = toneMappingFunctions[toneMapping];
    if (toneMappingName === undefined) {
        (0, _threeCoreJs.warn)('WebGLProgram: Unsupported toneMapping:', toneMapping);
        return 'vec3 ' + functionName + '( vec3 color ) { return LinearToneMapping( color ); }';
    }
    return 'vec3 ' + functionName + '( vec3 color ) { return ' + toneMappingName + 'ToneMapping( color ); }';
}
const _v0 = /*@__PURE__*/ new (0, _threeCoreJs.Vector3)();
function getLuminanceFunction() {
    (0, _threeCoreJs.ColorManagement).getLuminanceCoefficients(_v0);
    const r = _v0.x.toFixed(4);
    const g = _v0.y.toFixed(4);
    const b = _v0.z.toFixed(4);
    return [
        'float luminance( const in vec3 rgb ) {',
        `	const vec3 weights = vec3( ${r}, ${g}, ${b} );`,
        '	return dot( weights, rgb );',
        '}'
    ].join('\n');
}
function generateVertexExtensions(parameters) {
    const chunks = [
        parameters.extensionClipCullDistance ? '#extension GL_ANGLE_clip_cull_distance : require' : '',
        parameters.extensionMultiDraw ? '#extension GL_ANGLE_multi_draw : require' : ''
    ];
    return chunks.filter(filterEmptyLine).join('\n');
}
function generateDefines(defines) {
    const chunks = [];
    for(const name in defines){
        const value = defines[name];
        if (value === false) continue;
        chunks.push('#define ' + name + ' ' + value);
    }
    return chunks.join('\n');
}
function fetchAttributeLocations(gl, program) {
    const attributes = {};
    const n = gl.getProgramParameter(program, gl.ACTIVE_ATTRIBUTES);
    for(let i = 0; i < n; i++){
        const info = gl.getActiveAttrib(program, i);
        const name = info.name;
        let locationSize = 1;
        if (info.type === gl.FLOAT_MAT2) locationSize = 2;
        if (info.type === gl.FLOAT_MAT3) locationSize = 3;
        if (info.type === gl.FLOAT_MAT4) locationSize = 4;
        // log( 'WebGLProgram: ACTIVE VERTEX ATTRIBUTE:', name, i );
        attributes[name] = {
            type: info.type,
            location: gl.getAttribLocation(program, name),
            locationSize: locationSize
        };
    }
    return attributes;
}
function filterEmptyLine(string) {
    return string !== '';
}
function replaceLightNums(string, parameters) {
    const numSpotLightCoords = parameters.numSpotLightShadows + parameters.numSpotLightMaps - parameters.numSpotLightShadowsWithMaps;
    return string.replace(/NUM_DIR_LIGHTS/g, parameters.numDirLights).replace(/NUM_SPOT_LIGHTS/g, parameters.numSpotLights).replace(/NUM_SPOT_LIGHT_MAPS/g, parameters.numSpotLightMaps).replace(/NUM_SPOT_LIGHT_COORDS/g, numSpotLightCoords).replace(/NUM_RECT_AREA_LIGHTS/g, parameters.numRectAreaLights).replace(/NUM_POINT_LIGHTS/g, parameters.numPointLights).replace(/NUM_HEMI_LIGHTS/g, parameters.numHemiLights).replace(/NUM_DIR_LIGHT_SHADOWS/g, parameters.numDirLightShadows).replace(/NUM_SPOT_LIGHT_SHADOWS_WITH_MAPS/g, parameters.numSpotLightShadowsWithMaps).replace(/NUM_SPOT_LIGHT_SHADOWS/g, parameters.numSpotLightShadows).replace(/NUM_POINT_LIGHT_SHADOWS/g, parameters.numPointLightShadows);
}
function replaceClippingPlaneNums(string, parameters) {
    return string.replace(/NUM_CLIPPING_PLANES/g, parameters.numClippingPlanes).replace(/UNION_CLIPPING_PLANES/g, parameters.numClippingPlanes - parameters.numClipIntersection);
}
// Resolve Includes
const includePattern = /^[ \t]*#include +<([\w\d./]+)>/gm;
function resolveIncludes(string) {
    return string.replace(includePattern, includeReplacer);
}
const shaderChunkMap = new Map();
function includeReplacer(match, include) {
    let string = ShaderChunk[include];
    if (string === undefined) {
        const newInclude = shaderChunkMap.get(include);
        if (newInclude !== undefined) {
            string = ShaderChunk[newInclude];
            (0, _threeCoreJs.warn)('WebGLRenderer: Shader chunk "%s" has been deprecated. Use "%s" instead.', include, newInclude);
        } else throw new Error('Can not resolve #include <' + include + '>');
    }
    return resolveIncludes(string);
}
// Unroll Loops
const unrollLoopPattern = /#pragma unroll_loop_start\s+for\s*\(\s*int\s+i\s*=\s*(\d+)\s*;\s*i\s*<\s*(\d+)\s*;\s*i\s*\+\+\s*\)\s*{([\s\S]+?)}\s+#pragma unroll_loop_end/g;
function unrollLoops(string) {
    return string.replace(unrollLoopPattern, loopReplacer);
}
function loopReplacer(match, start, end, snippet) {
    let string = '';
    for(let i = parseInt(start); i < parseInt(end); i++)string += snippet.replace(/\[\s*i\s*\]/g, '[ ' + i + ' ]').replace(/UNROLLED_LOOP_INDEX/g, i);
    return string;
}
//
function generatePrecision(parameters) {
    let precisionstring = `precision ${parameters.precision} float;
	precision ${parameters.precision} int;
	precision ${parameters.precision} sampler2D;
	precision ${parameters.precision} samplerCube;
	precision ${parameters.precision} sampler3D;
	precision ${parameters.precision} sampler2DArray;
	precision ${parameters.precision} sampler2DShadow;
	precision ${parameters.precision} samplerCubeShadow;
	precision ${parameters.precision} sampler2DArrayShadow;
	precision ${parameters.precision} isampler2D;
	precision ${parameters.precision} isampler3D;
	precision ${parameters.precision} isamplerCube;
	precision ${parameters.precision} isampler2DArray;
	precision ${parameters.precision} usampler2D;
	precision ${parameters.precision} usampler3D;
	precision ${parameters.precision} usamplerCube;
	precision ${parameters.precision} usampler2DArray;
	`;
    if (parameters.precision === 'highp') precisionstring += '\n#define HIGH_PRECISION';
    else if (parameters.precision === 'mediump') precisionstring += '\n#define MEDIUM_PRECISION';
    else if (parameters.precision === 'lowp') precisionstring += '\n#define LOW_PRECISION';
    return precisionstring;
}
const shadowMapTypeDefines = {
    [(0, _threeCoreJs.PCFShadowMap)]: 'SHADOWMAP_TYPE_PCF',
    [(0, _threeCoreJs.VSMShadowMap)]: 'SHADOWMAP_TYPE_VSM'
};
function generateShadowMapTypeDefine(parameters) {
    return shadowMapTypeDefines[parameters.shadowMapType] || 'SHADOWMAP_TYPE_BASIC';
}
const envMapTypeDefines = {
    [(0, _threeCoreJs.CubeReflectionMapping)]: 'ENVMAP_TYPE_CUBE',
    [(0, _threeCoreJs.CubeRefractionMapping)]: 'ENVMAP_TYPE_CUBE',
    [(0, _threeCoreJs.CubeUVReflectionMapping)]: 'ENVMAP_TYPE_CUBE_UV'
};
function generateEnvMapTypeDefine(parameters) {
    if (parameters.envMap === false) return 'ENVMAP_TYPE_CUBE';
    return envMapTypeDefines[parameters.envMapMode] || 'ENVMAP_TYPE_CUBE';
}
const envMapModeDefines = {
    [(0, _threeCoreJs.CubeRefractionMapping)]: 'ENVMAP_MODE_REFRACTION'
};
function generateEnvMapModeDefine(parameters) {
    if (parameters.envMap === false) return 'ENVMAP_MODE_REFLECTION';
    return envMapModeDefines[parameters.envMapMode] || 'ENVMAP_MODE_REFLECTION';
}
const envMapBlendingDefines = {
    [(0, _threeCoreJs.MultiplyOperation)]: 'ENVMAP_BLENDING_MULTIPLY',
    [(0, _threeCoreJs.MixOperation)]: 'ENVMAP_BLENDING_MIX',
    [(0, _threeCoreJs.AddOperation)]: 'ENVMAP_BLENDING_ADD'
};
function generateEnvMapBlendingDefine(parameters) {
    if (parameters.envMap === false) return 'ENVMAP_BLENDING_NONE';
    return envMapBlendingDefines[parameters.combine] || 'ENVMAP_BLENDING_NONE';
}
function generateCubeUVSize(parameters) {
    const imageHeight = parameters.envMapCubeUVHeight;
    if (imageHeight === null) return null;
    const maxMip = Math.log2(imageHeight) - 2;
    const texelHeight = 1.0 / imageHeight;
    const texelWidth = 1.0 / (3 * Math.max(Math.pow(2, maxMip), 112));
    return {
        texelWidth,
        texelHeight,
        maxMip
    };
}
function WebGLProgram(renderer, cacheKey, parameters, bindingStates) {
    // TODO Send this event to Three.js DevTools
    // log( 'WebGLProgram', cacheKey );
    const gl = renderer.getContext();
    const defines = parameters.defines;
    let vertexShader = parameters.vertexShader;
    let fragmentShader = parameters.fragmentShader;
    const shadowMapTypeDefine = generateShadowMapTypeDefine(parameters);
    const envMapTypeDefine = generateEnvMapTypeDefine(parameters);
    const envMapModeDefine = generateEnvMapModeDefine(parameters);
    const envMapBlendingDefine = generateEnvMapBlendingDefine(parameters);
    const envMapCubeUVSize = generateCubeUVSize(parameters);
    const customVertexExtensions = generateVertexExtensions(parameters);
    const customDefines = generateDefines(defines);
    const program = gl.createProgram();
    let prefixVertex, prefixFragment;
    let versionString = parameters.glslVersion ? '#version ' + parameters.glslVersion + '\n' : '';
    if (parameters.isRawShaderMaterial) {
        prefixVertex = [
            '#define SHADER_TYPE ' + parameters.shaderType,
            '#define SHADER_NAME ' + parameters.shaderName,
            customDefines
        ].filter(filterEmptyLine).join('\n');
        if (prefixVertex.length > 0) prefixVertex += '\n';
        prefixFragment = [
            '#define SHADER_TYPE ' + parameters.shaderType,
            '#define SHADER_NAME ' + parameters.shaderName,
            customDefines
        ].filter(filterEmptyLine).join('\n');
        if (prefixFragment.length > 0) prefixFragment += '\n';
    } else {
        prefixVertex = [
            generatePrecision(parameters),
            '#define SHADER_TYPE ' + parameters.shaderType,
            '#define SHADER_NAME ' + parameters.shaderName,
            customDefines,
            parameters.extensionClipCullDistance ? '#define USE_CLIP_DISTANCE' : '',
            parameters.batching ? '#define USE_BATCHING' : '',
            parameters.batchingColor ? '#define USE_BATCHING_COLOR' : '',
            parameters.instancing ? '#define USE_INSTANCING' : '',
            parameters.instancingColor ? '#define USE_INSTANCING_COLOR' : '',
            parameters.instancingMorph ? '#define USE_INSTANCING_MORPH' : '',
            parameters.useFog && parameters.fog ? '#define USE_FOG' : '',
            parameters.useFog && parameters.fogExp2 ? '#define FOG_EXP2' : '',
            parameters.map ? '#define USE_MAP' : '',
            parameters.envMap ? '#define USE_ENVMAP' : '',
            parameters.envMap ? '#define ' + envMapModeDefine : '',
            parameters.lightMap ? '#define USE_LIGHTMAP' : '',
            parameters.aoMap ? '#define USE_AOMAP' : '',
            parameters.bumpMap ? '#define USE_BUMPMAP' : '',
            parameters.normalMap ? '#define USE_NORMALMAP' : '',
            parameters.normalMapObjectSpace ? '#define USE_NORMALMAP_OBJECTSPACE' : '',
            parameters.normalMapTangentSpace ? '#define USE_NORMALMAP_TANGENTSPACE' : '',
            parameters.displacementMap ? '#define USE_DISPLACEMENTMAP' : '',
            parameters.emissiveMap ? '#define USE_EMISSIVEMAP' : '',
            parameters.anisotropy ? '#define USE_ANISOTROPY' : '',
            parameters.anisotropyMap ? '#define USE_ANISOTROPYMAP' : '',
            parameters.clearcoatMap ? '#define USE_CLEARCOATMAP' : '',
            parameters.clearcoatRoughnessMap ? '#define USE_CLEARCOAT_ROUGHNESSMAP' : '',
            parameters.clearcoatNormalMap ? '#define USE_CLEARCOAT_NORMALMAP' : '',
            parameters.iridescenceMap ? '#define USE_IRIDESCENCEMAP' : '',
            parameters.iridescenceThicknessMap ? '#define USE_IRIDESCENCE_THICKNESSMAP' : '',
            parameters.specularMap ? '#define USE_SPECULARMAP' : '',
            parameters.specularColorMap ? '#define USE_SPECULAR_COLORMAP' : '',
            parameters.specularIntensityMap ? '#define USE_SPECULAR_INTENSITYMAP' : '',
            parameters.roughnessMap ? '#define USE_ROUGHNESSMAP' : '',
            parameters.metalnessMap ? '#define USE_METALNESSMAP' : '',
            parameters.alphaMap ? '#define USE_ALPHAMAP' : '',
            parameters.alphaHash ? '#define USE_ALPHAHASH' : '',
            parameters.transmission ? '#define USE_TRANSMISSION' : '',
            parameters.transmissionMap ? '#define USE_TRANSMISSIONMAP' : '',
            parameters.thicknessMap ? '#define USE_THICKNESSMAP' : '',
            parameters.sheenColorMap ? '#define USE_SHEEN_COLORMAP' : '',
            parameters.sheenRoughnessMap ? '#define USE_SHEEN_ROUGHNESSMAP' : '',
            //
            parameters.mapUv ? '#define MAP_UV ' + parameters.mapUv : '',
            parameters.alphaMapUv ? '#define ALPHAMAP_UV ' + parameters.alphaMapUv : '',
            parameters.lightMapUv ? '#define LIGHTMAP_UV ' + parameters.lightMapUv : '',
            parameters.aoMapUv ? '#define AOMAP_UV ' + parameters.aoMapUv : '',
            parameters.emissiveMapUv ? '#define EMISSIVEMAP_UV ' + parameters.emissiveMapUv : '',
            parameters.bumpMapUv ? '#define BUMPMAP_UV ' + parameters.bumpMapUv : '',
            parameters.normalMapUv ? '#define NORMALMAP_UV ' + parameters.normalMapUv : '',
            parameters.displacementMapUv ? '#define DISPLACEMENTMAP_UV ' + parameters.displacementMapUv : '',
            parameters.metalnessMapUv ? '#define METALNESSMAP_UV ' + parameters.metalnessMapUv : '',
            parameters.roughnessMapUv ? '#define ROUGHNESSMAP_UV ' + parameters.roughnessMapUv : '',
            parameters.anisotropyMapUv ? '#define ANISOTROPYMAP_UV ' + parameters.anisotropyMapUv : '',
            parameters.clearcoatMapUv ? '#define CLEARCOATMAP_UV ' + parameters.clearcoatMapUv : '',
            parameters.clearcoatNormalMapUv ? '#define CLEARCOAT_NORMALMAP_UV ' + parameters.clearcoatNormalMapUv : '',
            parameters.clearcoatRoughnessMapUv ? '#define CLEARCOAT_ROUGHNESSMAP_UV ' + parameters.clearcoatRoughnessMapUv : '',
            parameters.iridescenceMapUv ? '#define IRIDESCENCEMAP_UV ' + parameters.iridescenceMapUv : '',
            parameters.iridescenceThicknessMapUv ? '#define IRIDESCENCE_THICKNESSMAP_UV ' + parameters.iridescenceThicknessMapUv : '',
            parameters.sheenColorMapUv ? '#define SHEEN_COLORMAP_UV ' + parameters.sheenColorMapUv : '',
            parameters.sheenRoughnessMapUv ? '#define SHEEN_ROUGHNESSMAP_UV ' + parameters.sheenRoughnessMapUv : '',
            parameters.specularMapUv ? '#define SPECULARMAP_UV ' + parameters.specularMapUv : '',
            parameters.specularColorMapUv ? '#define SPECULAR_COLORMAP_UV ' + parameters.specularColorMapUv : '',
            parameters.specularIntensityMapUv ? '#define SPECULAR_INTENSITYMAP_UV ' + parameters.specularIntensityMapUv : '',
            parameters.transmissionMapUv ? '#define TRANSMISSIONMAP_UV ' + parameters.transmissionMapUv : '',
            parameters.thicknessMapUv ? '#define THICKNESSMAP_UV ' + parameters.thicknessMapUv : '',
            //
            parameters.vertexTangents && parameters.flatShading === false ? '#define USE_TANGENT' : '',
            parameters.vertexColors ? '#define USE_COLOR' : '',
            parameters.vertexAlphas ? '#define USE_COLOR_ALPHA' : '',
            parameters.vertexUv1s ? '#define USE_UV1' : '',
            parameters.vertexUv2s ? '#define USE_UV2' : '',
            parameters.vertexUv3s ? '#define USE_UV3' : '',
            parameters.pointsUvs ? '#define USE_POINTS_UV' : '',
            parameters.flatShading ? '#define FLAT_SHADED' : '',
            parameters.skinning ? '#define USE_SKINNING' : '',
            parameters.morphTargets ? '#define USE_MORPHTARGETS' : '',
            parameters.morphNormals && parameters.flatShading === false ? '#define USE_MORPHNORMALS' : '',
            parameters.morphColors ? '#define USE_MORPHCOLORS' : '',
            parameters.morphTargetsCount > 0 ? '#define MORPHTARGETS_TEXTURE_STRIDE ' + parameters.morphTextureStride : '',
            parameters.morphTargetsCount > 0 ? '#define MORPHTARGETS_COUNT ' + parameters.morphTargetsCount : '',
            parameters.doubleSided ? '#define DOUBLE_SIDED' : '',
            parameters.flipSided ? '#define FLIP_SIDED' : '',
            parameters.shadowMapEnabled ? '#define USE_SHADOWMAP' : '',
            parameters.shadowMapEnabled ? '#define ' + shadowMapTypeDefine : '',
            parameters.sizeAttenuation ? '#define USE_SIZEATTENUATION' : '',
            parameters.numLightProbes > 0 ? '#define USE_LIGHT_PROBES' : '',
            parameters.logarithmicDepthBuffer ? '#define USE_LOGARITHMIC_DEPTH_BUFFER' : '',
            parameters.reversedDepthBuffer ? '#define USE_REVERSED_DEPTH_BUFFER' : '',
            'uniform mat4 modelMatrix;',
            'uniform mat4 modelViewMatrix;',
            'uniform mat4 projectionMatrix;',
            'uniform mat4 viewMatrix;',
            'uniform mat3 normalMatrix;',
            'uniform vec3 cameraPosition;',
            'uniform bool isOrthographic;',
            '#ifdef USE_INSTANCING',
            '	attribute mat4 instanceMatrix;',
            '#endif',
            '#ifdef USE_INSTANCING_COLOR',
            '	attribute vec3 instanceColor;',
            '#endif',
            '#ifdef USE_INSTANCING_MORPH',
            '	uniform sampler2D morphTexture;',
            '#endif',
            'attribute vec3 position;',
            'attribute vec3 normal;',
            'attribute vec2 uv;',
            '#ifdef USE_UV1',
            '	attribute vec2 uv1;',
            '#endif',
            '#ifdef USE_UV2',
            '	attribute vec2 uv2;',
            '#endif',
            '#ifdef USE_UV3',
            '	attribute vec2 uv3;',
            '#endif',
            '#ifdef USE_TANGENT',
            '	attribute vec4 tangent;',
            '#endif',
            '#if defined( USE_COLOR_ALPHA )',
            '	attribute vec4 color;',
            '#elif defined( USE_COLOR )',
            '	attribute vec3 color;',
            '#endif',
            '#ifdef USE_SKINNING',
            '	attribute vec4 skinIndex;',
            '	attribute vec4 skinWeight;',
            '#endif',
            '\n'
        ].filter(filterEmptyLine).join('\n');
        prefixFragment = [
            generatePrecision(parameters),
            '#define SHADER_TYPE ' + parameters.shaderType,
            '#define SHADER_NAME ' + parameters.shaderName,
            customDefines,
            parameters.useFog && parameters.fog ? '#define USE_FOG' : '',
            parameters.useFog && parameters.fogExp2 ? '#define FOG_EXP2' : '',
            parameters.alphaToCoverage ? '#define ALPHA_TO_COVERAGE' : '',
            parameters.map ? '#define USE_MAP' : '',
            parameters.matcap ? '#define USE_MATCAP' : '',
            parameters.envMap ? '#define USE_ENVMAP' : '',
            parameters.envMap ? '#define ' + envMapTypeDefine : '',
            parameters.envMap ? '#define ' + envMapModeDefine : '',
            parameters.envMap ? '#define ' + envMapBlendingDefine : '',
            envMapCubeUVSize ? '#define CUBEUV_TEXEL_WIDTH ' + envMapCubeUVSize.texelWidth : '',
            envMapCubeUVSize ? '#define CUBEUV_TEXEL_HEIGHT ' + envMapCubeUVSize.texelHeight : '',
            envMapCubeUVSize ? '#define CUBEUV_MAX_MIP ' + envMapCubeUVSize.maxMip + '.0' : '',
            parameters.lightMap ? '#define USE_LIGHTMAP' : '',
            parameters.aoMap ? '#define USE_AOMAP' : '',
            parameters.bumpMap ? '#define USE_BUMPMAP' : '',
            parameters.normalMap ? '#define USE_NORMALMAP' : '',
            parameters.normalMapObjectSpace ? '#define USE_NORMALMAP_OBJECTSPACE' : '',
            parameters.normalMapTangentSpace ? '#define USE_NORMALMAP_TANGENTSPACE' : '',
            parameters.emissiveMap ? '#define USE_EMISSIVEMAP' : '',
            parameters.anisotropy ? '#define USE_ANISOTROPY' : '',
            parameters.anisotropyMap ? '#define USE_ANISOTROPYMAP' : '',
            parameters.clearcoat ? '#define USE_CLEARCOAT' : '',
            parameters.clearcoatMap ? '#define USE_CLEARCOATMAP' : '',
            parameters.clearcoatRoughnessMap ? '#define USE_CLEARCOAT_ROUGHNESSMAP' : '',
            parameters.clearcoatNormalMap ? '#define USE_CLEARCOAT_NORMALMAP' : '',
            parameters.dispersion ? '#define USE_DISPERSION' : '',
            parameters.iridescence ? '#define USE_IRIDESCENCE' : '',
            parameters.iridescenceMap ? '#define USE_IRIDESCENCEMAP' : '',
            parameters.iridescenceThicknessMap ? '#define USE_IRIDESCENCE_THICKNESSMAP' : '',
            parameters.specularMap ? '#define USE_SPECULARMAP' : '',
            parameters.specularColorMap ? '#define USE_SPECULAR_COLORMAP' : '',
            parameters.specularIntensityMap ? '#define USE_SPECULAR_INTENSITYMAP' : '',
            parameters.roughnessMap ? '#define USE_ROUGHNESSMAP' : '',
            parameters.metalnessMap ? '#define USE_METALNESSMAP' : '',
            parameters.alphaMap ? '#define USE_ALPHAMAP' : '',
            parameters.alphaTest ? '#define USE_ALPHATEST' : '',
            parameters.alphaHash ? '#define USE_ALPHAHASH' : '',
            parameters.sheen ? '#define USE_SHEEN' : '',
            parameters.sheenColorMap ? '#define USE_SHEEN_COLORMAP' : '',
            parameters.sheenRoughnessMap ? '#define USE_SHEEN_ROUGHNESSMAP' : '',
            parameters.transmission ? '#define USE_TRANSMISSION' : '',
            parameters.transmissionMap ? '#define USE_TRANSMISSIONMAP' : '',
            parameters.thicknessMap ? '#define USE_THICKNESSMAP' : '',
            parameters.vertexTangents && parameters.flatShading === false ? '#define USE_TANGENT' : '',
            parameters.vertexColors || parameters.instancingColor || parameters.batchingColor ? '#define USE_COLOR' : '',
            parameters.vertexAlphas ? '#define USE_COLOR_ALPHA' : '',
            parameters.vertexUv1s ? '#define USE_UV1' : '',
            parameters.vertexUv2s ? '#define USE_UV2' : '',
            parameters.vertexUv3s ? '#define USE_UV3' : '',
            parameters.pointsUvs ? '#define USE_POINTS_UV' : '',
            parameters.gradientMap ? '#define USE_GRADIENTMAP' : '',
            parameters.flatShading ? '#define FLAT_SHADED' : '',
            parameters.doubleSided ? '#define DOUBLE_SIDED' : '',
            parameters.flipSided ? '#define FLIP_SIDED' : '',
            parameters.shadowMapEnabled ? '#define USE_SHADOWMAP' : '',
            parameters.shadowMapEnabled ? '#define ' + shadowMapTypeDefine : '',
            parameters.premultipliedAlpha ? '#define PREMULTIPLIED_ALPHA' : '',
            parameters.numLightProbes > 0 ? '#define USE_LIGHT_PROBES' : '',
            parameters.decodeVideoTexture ? '#define DECODE_VIDEO_TEXTURE' : '',
            parameters.decodeVideoTextureEmissive ? '#define DECODE_VIDEO_TEXTURE_EMISSIVE' : '',
            parameters.logarithmicDepthBuffer ? '#define USE_LOGARITHMIC_DEPTH_BUFFER' : '',
            parameters.reversedDepthBuffer ? '#define USE_REVERSED_DEPTH_BUFFER' : '',
            'uniform mat4 viewMatrix;',
            'uniform vec3 cameraPosition;',
            'uniform bool isOrthographic;',
            parameters.toneMapping !== (0, _threeCoreJs.NoToneMapping) ? '#define TONE_MAPPING' : '',
            parameters.toneMapping !== (0, _threeCoreJs.NoToneMapping) ? ShaderChunk['tonemapping_pars_fragment'] : '',
            parameters.toneMapping !== (0, _threeCoreJs.NoToneMapping) ? getToneMappingFunction('toneMapping', parameters.toneMapping) : '',
            parameters.dithering ? '#define DITHERING' : '',
            parameters.opaque ? '#define OPAQUE' : '',
            ShaderChunk['colorspace_pars_fragment'],
            getTexelEncodingFunction('linearToOutputTexel', parameters.outputColorSpace),
            getLuminanceFunction(),
            parameters.useDepthPacking ? '#define DEPTH_PACKING ' + parameters.depthPacking : '',
            '\n'
        ].filter(filterEmptyLine).join('\n');
    }
    vertexShader = resolveIncludes(vertexShader);
    vertexShader = replaceLightNums(vertexShader, parameters);
    vertexShader = replaceClippingPlaneNums(vertexShader, parameters);
    fragmentShader = resolveIncludes(fragmentShader);
    fragmentShader = replaceLightNums(fragmentShader, parameters);
    fragmentShader = replaceClippingPlaneNums(fragmentShader, parameters);
    vertexShader = unrollLoops(vertexShader);
    fragmentShader = unrollLoops(fragmentShader);
    if (parameters.isRawShaderMaterial !== true) {
        // GLSL 3.0 conversion for built-in materials and ShaderMaterial
        versionString = '#version 300 es\n';
        prefixVertex = [
            customVertexExtensions,
            '#define attribute in',
            '#define varying out',
            '#define texture2D texture'
        ].join('\n') + '\n' + prefixVertex;
        prefixFragment = [
            '#define varying in',
            parameters.glslVersion === (0, _threeCoreJs.GLSL3) ? '' : 'layout(location = 0) out highp vec4 pc_fragColor;',
            parameters.glslVersion === (0, _threeCoreJs.GLSL3) ? '' : '#define gl_FragColor pc_fragColor',
            '#define gl_FragDepthEXT gl_FragDepth',
            '#define texture2D texture',
            '#define textureCube texture',
            '#define texture2DProj textureProj',
            '#define texture2DLodEXT textureLod',
            '#define texture2DProjLodEXT textureProjLod',
            '#define textureCubeLodEXT textureLod',
            '#define texture2DGradEXT textureGrad',
            '#define texture2DProjGradEXT textureProjGrad',
            '#define textureCubeGradEXT textureGrad'
        ].join('\n') + '\n' + prefixFragment;
    }
    const vertexGlsl = versionString + prefixVertex + vertexShader;
    const fragmentGlsl = versionString + prefixFragment + fragmentShader;
    // log( '*VERTEX*', vertexGlsl );
    // log( '*FRAGMENT*', fragmentGlsl );
    const glVertexShader = WebGLShader(gl, gl.VERTEX_SHADER, vertexGlsl);
    const glFragmentShader = WebGLShader(gl, gl.FRAGMENT_SHADER, fragmentGlsl);
    gl.attachShader(program, glVertexShader);
    gl.attachShader(program, glFragmentShader);
    // Force a particular attribute to index 0.
    if (parameters.index0AttributeName !== undefined) gl.bindAttribLocation(program, 0, parameters.index0AttributeName);
    else if (parameters.morphTargets === true) // programs with morphTargets displace position out of attribute 0
    gl.bindAttribLocation(program, 0, 'position');
    gl.linkProgram(program);
    function onFirstUse(self1) {
        // check for link errors
        if (renderer.debug.checkShaderErrors) {
            const programInfoLog = gl.getProgramInfoLog(program) || '';
            const vertexShaderInfoLog = gl.getShaderInfoLog(glVertexShader) || '';
            const fragmentShaderInfoLog = gl.getShaderInfoLog(glFragmentShader) || '';
            const programLog = programInfoLog.trim();
            const vertexLog = vertexShaderInfoLog.trim();
            const fragmentLog = fragmentShaderInfoLog.trim();
            let runnable = true;
            let haveDiagnostics = true;
            if (gl.getProgramParameter(program, gl.LINK_STATUS) === false) {
                runnable = false;
                if (typeof renderer.debug.onShaderError === 'function') renderer.debug.onShaderError(gl, program, glVertexShader, glFragmentShader);
                else {
                    // default error reporting
                    const vertexErrors = getShaderErrors(gl, glVertexShader, 'vertex');
                    const fragmentErrors = getShaderErrors(gl, glFragmentShader, 'fragment');
                    (0, _threeCoreJs.error)('THREE.WebGLProgram: Shader Error ' + gl.getError() + ' - ' + 'VALIDATE_STATUS ' + gl.getProgramParameter(program, gl.VALIDATE_STATUS) + '\n\n' + 'Material Name: ' + self1.name + '\n' + 'Material Type: ' + self1.type + '\n\n' + 'Program Info Log: ' + programLog + '\n' + vertexErrors + '\n' + fragmentErrors);
                }
            } else if (programLog !== '') (0, _threeCoreJs.warn)('WebGLProgram: Program Info Log:', programLog);
            else if (vertexLog === '' || fragmentLog === '') haveDiagnostics = false;
            if (haveDiagnostics) self1.diagnostics = {
                runnable: runnable,
                programLog: programLog,
                vertexShader: {
                    log: vertexLog,
                    prefix: prefixVertex
                },
                fragmentShader: {
                    log: fragmentLog,
                    prefix: prefixFragment
                }
            };
        }
        // Clean up
        // Crashes in iOS9 and iOS10. #18402
        // gl.detachShader( program, glVertexShader );
        // gl.detachShader( program, glFragmentShader );
        gl.deleteShader(glVertexShader);
        gl.deleteShader(glFragmentShader);
        cachedUniforms = new WebGLUniforms(gl, program);
        cachedAttributes = fetchAttributeLocations(gl, program);
    }
    // set up caching for uniform locations
    let cachedUniforms;
    this.getUniforms = function() {
        if (cachedUniforms === undefined) // Populates cachedUniforms and cachedAttributes
        onFirstUse(this);
        return cachedUniforms;
    };
    // set up caching for attribute locations
    let cachedAttributes;
    this.getAttributes = function() {
        if (cachedAttributes === undefined) // Populates cachedAttributes and cachedUniforms
        onFirstUse(this);
        return cachedAttributes;
    };
    // indicate when the program is ready to be used. if the KHR_parallel_shader_compile extension isn't supported,
    // flag the program as ready immediately. It may cause a stall when it's first used.
    let programReady = parameters.rendererExtensionParallelShaderCompile === false;
    this.isReady = function() {
        if (programReady === false) programReady = gl.getProgramParameter(program, COMPLETION_STATUS_KHR);
        return programReady;
    };
    // free resource
    this.destroy = function() {
        bindingStates.releaseStatesOfProgram(this);
        gl.deleteProgram(program);
        this.program = undefined;
    };
    //
    this.type = parameters.shaderType;
    this.name = parameters.shaderName;
    this.id = programIdCount++;
    this.cacheKey = cacheKey;
    this.usedTimes = 1;
    this.program = program;
    this.vertexShader = glVertexShader;
    this.fragmentShader = glFragmentShader;
    return this;
}
let _id = 0;
class WebGLShaderCache {
    constructor(){
        this.shaderCache = new Map();
        this.materialCache = new Map();
    }
    update(material) {
        const vertexShader = material.vertexShader;
        const fragmentShader = material.fragmentShader;
        const vertexShaderStage = this._getShaderStage(vertexShader);
        const fragmentShaderStage = this._getShaderStage(fragmentShader);
        const materialShaders = this._getShaderCacheForMaterial(material);
        if (materialShaders.has(vertexShaderStage) === false) {
            materialShaders.add(vertexShaderStage);
            vertexShaderStage.usedTimes++;
        }
        if (materialShaders.has(fragmentShaderStage) === false) {
            materialShaders.add(fragmentShaderStage);
            fragmentShaderStage.usedTimes++;
        }
        return this;
    }
    remove(material) {
        const materialShaders = this.materialCache.get(material);
        for (const shaderStage of materialShaders){
            shaderStage.usedTimes--;
            if (shaderStage.usedTimes === 0) this.shaderCache.delete(shaderStage.code);
        }
        this.materialCache.delete(material);
        return this;
    }
    getVertexShaderID(material) {
        return this._getShaderStage(material.vertexShader).id;
    }
    getFragmentShaderID(material) {
        return this._getShaderStage(material.fragmentShader).id;
    }
    dispose() {
        this.shaderCache.clear();
        this.materialCache.clear();
    }
    _getShaderCacheForMaterial(material) {
        const cache = this.materialCache;
        let set = cache.get(material);
        if (set === undefined) {
            set = new Set();
            cache.set(material, set);
        }
        return set;
    }
    _getShaderStage(code) {
        const cache = this.shaderCache;
        let stage = cache.get(code);
        if (stage === undefined) {
            stage = new WebGLShaderStage(code);
            cache.set(code, stage);
        }
        return stage;
    }
}
class WebGLShaderStage {
    constructor(code){
        this.id = _id++;
        this.code = code;
        this.usedTimes = 0;
    }
}
function WebGLPrograms(renderer, cubemaps, cubeuvmaps, extensions, capabilities, bindingStates, clipping) {
    const _programLayers = new (0, _threeCoreJs.Layers)();
    const _customShaders = new WebGLShaderCache();
    const _activeChannels = new Set();
    const programs = [];
    const programsMap = new Map();
    const logarithmicDepthBuffer = capabilities.logarithmicDepthBuffer;
    let precision = capabilities.precision;
    const shaderIDs = {
        MeshDepthMaterial: 'depth',
        MeshDistanceMaterial: 'distance',
        MeshNormalMaterial: 'normal',
        MeshBasicMaterial: 'basic',
        MeshLambertMaterial: 'lambert',
        MeshPhongMaterial: 'phong',
        MeshToonMaterial: 'toon',
        MeshStandardMaterial: 'physical',
        MeshPhysicalMaterial: 'physical',
        MeshMatcapMaterial: 'matcap',
        LineBasicMaterial: 'basic',
        LineDashedMaterial: 'dashed',
        PointsMaterial: 'points',
        ShadowMaterial: 'shadow',
        SpriteMaterial: 'sprite'
    };
    function getChannel(value) {
        _activeChannels.add(value);
        if (value === 0) return 'uv';
        return `uv${value}`;
    }
    function getParameters(material, lights, shadows, scene, object) {
        const fog = scene.fog;
        const geometry = object.geometry;
        const environment = material.isMeshStandardMaterial ? scene.environment : null;
        const envMap = (material.isMeshStandardMaterial ? cubeuvmaps : cubemaps).get(material.envMap || environment);
        const envMapCubeUVHeight = !!envMap && envMap.mapping === (0, _threeCoreJs.CubeUVReflectionMapping) ? envMap.image.height : null;
        const shaderID = shaderIDs[material.type];
        // heuristics to create shader parameters according to lights in the scene
        // (not to blow over maxLights budget)
        if (material.precision !== null) {
            precision = capabilities.getMaxPrecision(material.precision);
            if (precision !== material.precision) (0, _threeCoreJs.warn)('WebGLProgram.getParameters:', material.precision, 'not supported, using', precision, 'instead.');
        }
        //
        const morphAttribute = geometry.morphAttributes.position || geometry.morphAttributes.normal || geometry.morphAttributes.color;
        const morphTargetsCount = morphAttribute !== undefined ? morphAttribute.length : 0;
        let morphTextureStride = 0;
        if (geometry.morphAttributes.position !== undefined) morphTextureStride = 1;
        if (geometry.morphAttributes.normal !== undefined) morphTextureStride = 2;
        if (geometry.morphAttributes.color !== undefined) morphTextureStride = 3;
        //
        let vertexShader, fragmentShader;
        let customVertexShaderID, customFragmentShaderID;
        if (shaderID) {
            const shader = ShaderLib[shaderID];
            vertexShader = shader.vertexShader;
            fragmentShader = shader.fragmentShader;
        } else {
            vertexShader = material.vertexShader;
            fragmentShader = material.fragmentShader;
            _customShaders.update(material);
            customVertexShaderID = _customShaders.getVertexShaderID(material);
            customFragmentShaderID = _customShaders.getFragmentShaderID(material);
        }
        const currentRenderTarget = renderer.getRenderTarget();
        const reversedDepthBuffer = renderer.state.buffers.depth.getReversed();
        const IS_INSTANCEDMESH = object.isInstancedMesh === true;
        const IS_BATCHEDMESH = object.isBatchedMesh === true;
        const HAS_MAP = !!material.map;
        const HAS_MATCAP = !!material.matcap;
        const HAS_ENVMAP = !!envMap;
        const HAS_AOMAP = !!material.aoMap;
        const HAS_LIGHTMAP = !!material.lightMap;
        const HAS_BUMPMAP = !!material.bumpMap;
        const HAS_NORMALMAP = !!material.normalMap;
        const HAS_DISPLACEMENTMAP = !!material.displacementMap;
        const HAS_EMISSIVEMAP = !!material.emissiveMap;
        const HAS_METALNESSMAP = !!material.metalnessMap;
        const HAS_ROUGHNESSMAP = !!material.roughnessMap;
        const HAS_ANISOTROPY = material.anisotropy > 0;
        const HAS_CLEARCOAT = material.clearcoat > 0;
        const HAS_DISPERSION = material.dispersion > 0;
        const HAS_IRIDESCENCE = material.iridescence > 0;
        const HAS_SHEEN = material.sheen > 0;
        const HAS_TRANSMISSION = material.transmission > 0;
        const HAS_ANISOTROPYMAP = HAS_ANISOTROPY && !!material.anisotropyMap;
        const HAS_CLEARCOATMAP = HAS_CLEARCOAT && !!material.clearcoatMap;
        const HAS_CLEARCOAT_NORMALMAP = HAS_CLEARCOAT && !!material.clearcoatNormalMap;
        const HAS_CLEARCOAT_ROUGHNESSMAP = HAS_CLEARCOAT && !!material.clearcoatRoughnessMap;
        const HAS_IRIDESCENCEMAP = HAS_IRIDESCENCE && !!material.iridescenceMap;
        const HAS_IRIDESCENCE_THICKNESSMAP = HAS_IRIDESCENCE && !!material.iridescenceThicknessMap;
        const HAS_SHEEN_COLORMAP = HAS_SHEEN && !!material.sheenColorMap;
        const HAS_SHEEN_ROUGHNESSMAP = HAS_SHEEN && !!material.sheenRoughnessMap;
        const HAS_SPECULARMAP = !!material.specularMap;
        const HAS_SPECULAR_COLORMAP = !!material.specularColorMap;
        const HAS_SPECULAR_INTENSITYMAP = !!material.specularIntensityMap;
        const HAS_TRANSMISSIONMAP = HAS_TRANSMISSION && !!material.transmissionMap;
        const HAS_THICKNESSMAP = HAS_TRANSMISSION && !!material.thicknessMap;
        const HAS_GRADIENTMAP = !!material.gradientMap;
        const HAS_ALPHAMAP = !!material.alphaMap;
        const HAS_ALPHATEST = material.alphaTest > 0;
        const HAS_ALPHAHASH = !!material.alphaHash;
        const HAS_EXTENSIONS = !!material.extensions;
        let toneMapping = (0, _threeCoreJs.NoToneMapping);
        if (material.toneMapped) {
            if (currentRenderTarget === null || currentRenderTarget.isXRRenderTarget === true) toneMapping = renderer.toneMapping;
        }
        const parameters = {
            shaderID: shaderID,
            shaderType: material.type,
            shaderName: material.name,
            vertexShader: vertexShader,
            fragmentShader: fragmentShader,
            defines: material.defines,
            customVertexShaderID: customVertexShaderID,
            customFragmentShaderID: customFragmentShaderID,
            isRawShaderMaterial: material.isRawShaderMaterial === true,
            glslVersion: material.glslVersion,
            precision: precision,
            batching: IS_BATCHEDMESH,
            batchingColor: IS_BATCHEDMESH && object._colorsTexture !== null,
            instancing: IS_INSTANCEDMESH,
            instancingColor: IS_INSTANCEDMESH && object.instanceColor !== null,
            instancingMorph: IS_INSTANCEDMESH && object.morphTexture !== null,
            outputColorSpace: currentRenderTarget === null ? renderer.outputColorSpace : currentRenderTarget.isXRRenderTarget === true ? currentRenderTarget.texture.colorSpace : (0, _threeCoreJs.LinearSRGBColorSpace),
            alphaToCoverage: !!material.alphaToCoverage,
            map: HAS_MAP,
            matcap: HAS_MATCAP,
            envMap: HAS_ENVMAP,
            envMapMode: HAS_ENVMAP && envMap.mapping,
            envMapCubeUVHeight: envMapCubeUVHeight,
            aoMap: HAS_AOMAP,
            lightMap: HAS_LIGHTMAP,
            bumpMap: HAS_BUMPMAP,
            normalMap: HAS_NORMALMAP,
            displacementMap: HAS_DISPLACEMENTMAP,
            emissiveMap: HAS_EMISSIVEMAP,
            normalMapObjectSpace: HAS_NORMALMAP && material.normalMapType === (0, _threeCoreJs.ObjectSpaceNormalMap),
            normalMapTangentSpace: HAS_NORMALMAP && material.normalMapType === (0, _threeCoreJs.TangentSpaceNormalMap),
            metalnessMap: HAS_METALNESSMAP,
            roughnessMap: HAS_ROUGHNESSMAP,
            anisotropy: HAS_ANISOTROPY,
            anisotropyMap: HAS_ANISOTROPYMAP,
            clearcoat: HAS_CLEARCOAT,
            clearcoatMap: HAS_CLEARCOATMAP,
            clearcoatNormalMap: HAS_CLEARCOAT_NORMALMAP,
            clearcoatRoughnessMap: HAS_CLEARCOAT_ROUGHNESSMAP,
            dispersion: HAS_DISPERSION,
            iridescence: HAS_IRIDESCENCE,
            iridescenceMap: HAS_IRIDESCENCEMAP,
            iridescenceThicknessMap: HAS_IRIDESCENCE_THICKNESSMAP,
            sheen: HAS_SHEEN,
            sheenColorMap: HAS_SHEEN_COLORMAP,
            sheenRoughnessMap: HAS_SHEEN_ROUGHNESSMAP,
            specularMap: HAS_SPECULARMAP,
            specularColorMap: HAS_SPECULAR_COLORMAP,
            specularIntensityMap: HAS_SPECULAR_INTENSITYMAP,
            transmission: HAS_TRANSMISSION,
            transmissionMap: HAS_TRANSMISSIONMAP,
            thicknessMap: HAS_THICKNESSMAP,
            gradientMap: HAS_GRADIENTMAP,
            opaque: material.transparent === false && material.blending === (0, _threeCoreJs.NormalBlending) && material.alphaToCoverage === false,
            alphaMap: HAS_ALPHAMAP,
            alphaTest: HAS_ALPHATEST,
            alphaHash: HAS_ALPHAHASH,
            combine: material.combine,
            //
            mapUv: HAS_MAP && getChannel(material.map.channel),
            aoMapUv: HAS_AOMAP && getChannel(material.aoMap.channel),
            lightMapUv: HAS_LIGHTMAP && getChannel(material.lightMap.channel),
            bumpMapUv: HAS_BUMPMAP && getChannel(material.bumpMap.channel),
            normalMapUv: HAS_NORMALMAP && getChannel(material.normalMap.channel),
            displacementMapUv: HAS_DISPLACEMENTMAP && getChannel(material.displacementMap.channel),
            emissiveMapUv: HAS_EMISSIVEMAP && getChannel(material.emissiveMap.channel),
            metalnessMapUv: HAS_METALNESSMAP && getChannel(material.metalnessMap.channel),
            roughnessMapUv: HAS_ROUGHNESSMAP && getChannel(material.roughnessMap.channel),
            anisotropyMapUv: HAS_ANISOTROPYMAP && getChannel(material.anisotropyMap.channel),
            clearcoatMapUv: HAS_CLEARCOATMAP && getChannel(material.clearcoatMap.channel),
            clearcoatNormalMapUv: HAS_CLEARCOAT_NORMALMAP && getChannel(material.clearcoatNormalMap.channel),
            clearcoatRoughnessMapUv: HAS_CLEARCOAT_ROUGHNESSMAP && getChannel(material.clearcoatRoughnessMap.channel),
            iridescenceMapUv: HAS_IRIDESCENCEMAP && getChannel(material.iridescenceMap.channel),
            iridescenceThicknessMapUv: HAS_IRIDESCENCE_THICKNESSMAP && getChannel(material.iridescenceThicknessMap.channel),
            sheenColorMapUv: HAS_SHEEN_COLORMAP && getChannel(material.sheenColorMap.channel),
            sheenRoughnessMapUv: HAS_SHEEN_ROUGHNESSMAP && getChannel(material.sheenRoughnessMap.channel),
            specularMapUv: HAS_SPECULARMAP && getChannel(material.specularMap.channel),
            specularColorMapUv: HAS_SPECULAR_COLORMAP && getChannel(material.specularColorMap.channel),
            specularIntensityMapUv: HAS_SPECULAR_INTENSITYMAP && getChannel(material.specularIntensityMap.channel),
            transmissionMapUv: HAS_TRANSMISSIONMAP && getChannel(material.transmissionMap.channel),
            thicknessMapUv: HAS_THICKNESSMAP && getChannel(material.thicknessMap.channel),
            alphaMapUv: HAS_ALPHAMAP && getChannel(material.alphaMap.channel),
            //
            vertexTangents: !!geometry.attributes.tangent && (HAS_NORMALMAP || HAS_ANISOTROPY),
            vertexColors: material.vertexColors,
            vertexAlphas: material.vertexColors === true && !!geometry.attributes.color && geometry.attributes.color.itemSize === 4,
            pointsUvs: object.isPoints === true && !!geometry.attributes.uv && (HAS_MAP || HAS_ALPHAMAP),
            fog: !!fog,
            useFog: material.fog === true,
            fogExp2: !!fog && fog.isFogExp2,
            flatShading: material.flatShading === true && material.wireframe === false,
            sizeAttenuation: material.sizeAttenuation === true,
            logarithmicDepthBuffer: logarithmicDepthBuffer,
            reversedDepthBuffer: reversedDepthBuffer,
            skinning: object.isSkinnedMesh === true,
            morphTargets: geometry.morphAttributes.position !== undefined,
            morphNormals: geometry.morphAttributes.normal !== undefined,
            morphColors: geometry.morphAttributes.color !== undefined,
            morphTargetsCount: morphTargetsCount,
            morphTextureStride: morphTextureStride,
            numDirLights: lights.directional.length,
            numPointLights: lights.point.length,
            numSpotLights: lights.spot.length,
            numSpotLightMaps: lights.spotLightMap.length,
            numRectAreaLights: lights.rectArea.length,
            numHemiLights: lights.hemi.length,
            numDirLightShadows: lights.directionalShadowMap.length,
            numPointLightShadows: lights.pointShadowMap.length,
            numSpotLightShadows: lights.spotShadowMap.length,
            numSpotLightShadowsWithMaps: lights.numSpotLightShadowsWithMaps,
            numLightProbes: lights.numLightProbes,
            numClippingPlanes: clipping.numPlanes,
            numClipIntersection: clipping.numIntersection,
            dithering: material.dithering,
            shadowMapEnabled: renderer.shadowMap.enabled && shadows.length > 0,
            shadowMapType: renderer.shadowMap.type,
            toneMapping: toneMapping,
            decodeVideoTexture: HAS_MAP && material.map.isVideoTexture === true && (0, _threeCoreJs.ColorManagement).getTransfer(material.map.colorSpace) === (0, _threeCoreJs.SRGBTransfer),
            decodeVideoTextureEmissive: HAS_EMISSIVEMAP && material.emissiveMap.isVideoTexture === true && (0, _threeCoreJs.ColorManagement).getTransfer(material.emissiveMap.colorSpace) === (0, _threeCoreJs.SRGBTransfer),
            premultipliedAlpha: material.premultipliedAlpha,
            doubleSided: material.side === (0, _threeCoreJs.DoubleSide),
            flipSided: material.side === (0, _threeCoreJs.BackSide),
            useDepthPacking: material.depthPacking >= 0,
            depthPacking: material.depthPacking || 0,
            index0AttributeName: material.index0AttributeName,
            extensionClipCullDistance: HAS_EXTENSIONS && material.extensions.clipCullDistance === true && extensions.has('WEBGL_clip_cull_distance'),
            extensionMultiDraw: (HAS_EXTENSIONS && material.extensions.multiDraw === true || IS_BATCHEDMESH) && extensions.has('WEBGL_multi_draw'),
            rendererExtensionParallelShaderCompile: extensions.has('KHR_parallel_shader_compile'),
            customProgramCacheKey: material.customProgramCacheKey()
        };
        // the usage of getChannel() determines the active texture channels for this shader
        parameters.vertexUv1s = _activeChannels.has(1);
        parameters.vertexUv2s = _activeChannels.has(2);
        parameters.vertexUv3s = _activeChannels.has(3);
        _activeChannels.clear();
        return parameters;
    }
    function getProgramCacheKey(parameters) {
        const array = [];
        if (parameters.shaderID) array.push(parameters.shaderID);
        else {
            array.push(parameters.customVertexShaderID);
            array.push(parameters.customFragmentShaderID);
        }
        if (parameters.defines !== undefined) for(const name in parameters.defines){
            array.push(name);
            array.push(parameters.defines[name]);
        }
        if (parameters.isRawShaderMaterial === false) {
            getProgramCacheKeyParameters(array, parameters);
            getProgramCacheKeyBooleans(array, parameters);
            array.push(renderer.outputColorSpace);
        }
        array.push(parameters.customProgramCacheKey);
        return array.join();
    }
    function getProgramCacheKeyParameters(array, parameters) {
        array.push(parameters.precision);
        array.push(parameters.outputColorSpace);
        array.push(parameters.envMapMode);
        array.push(parameters.envMapCubeUVHeight);
        array.push(parameters.mapUv);
        array.push(parameters.alphaMapUv);
        array.push(parameters.lightMapUv);
        array.push(parameters.aoMapUv);
        array.push(parameters.bumpMapUv);
        array.push(parameters.normalMapUv);
        array.push(parameters.displacementMapUv);
        array.push(parameters.emissiveMapUv);
        array.push(parameters.metalnessMapUv);
        array.push(parameters.roughnessMapUv);
        array.push(parameters.anisotropyMapUv);
        array.push(parameters.clearcoatMapUv);
        array.push(parameters.clearcoatNormalMapUv);
        array.push(parameters.clearcoatRoughnessMapUv);
        array.push(parameters.iridescenceMapUv);
        array.push(parameters.iridescenceThicknessMapUv);
        array.push(parameters.sheenColorMapUv);
        array.push(parameters.sheenRoughnessMapUv);
        array.push(parameters.specularMapUv);
        array.push(parameters.specularColorMapUv);
        array.push(parameters.specularIntensityMapUv);
        array.push(parameters.transmissionMapUv);
        array.push(parameters.thicknessMapUv);
        array.push(parameters.combine);
        array.push(parameters.fogExp2);
        array.push(parameters.sizeAttenuation);
        array.push(parameters.morphTargetsCount);
        array.push(parameters.morphAttributeCount);
        array.push(parameters.numDirLights);
        array.push(parameters.numPointLights);
        array.push(parameters.numSpotLights);
        array.push(parameters.numSpotLightMaps);
        array.push(parameters.numHemiLights);
        array.push(parameters.numRectAreaLights);
        array.push(parameters.numDirLightShadows);
        array.push(parameters.numPointLightShadows);
        array.push(parameters.numSpotLightShadows);
        array.push(parameters.numSpotLightShadowsWithMaps);
        array.push(parameters.numLightProbes);
        array.push(parameters.shadowMapType);
        array.push(parameters.toneMapping);
        array.push(parameters.numClippingPlanes);
        array.push(parameters.numClipIntersection);
        array.push(parameters.depthPacking);
    }
    function getProgramCacheKeyBooleans(array, parameters) {
        _programLayers.disableAll();
        if (parameters.instancing) _programLayers.enable(0);
        if (parameters.instancingColor) _programLayers.enable(1);
        if (parameters.instancingMorph) _programLayers.enable(2);
        if (parameters.matcap) _programLayers.enable(3);
        if (parameters.envMap) _programLayers.enable(4);
        if (parameters.normalMapObjectSpace) _programLayers.enable(5);
        if (parameters.normalMapTangentSpace) _programLayers.enable(6);
        if (parameters.clearcoat) _programLayers.enable(7);
        if (parameters.iridescence) _programLayers.enable(8);
        if (parameters.alphaTest) _programLayers.enable(9);
        if (parameters.vertexColors) _programLayers.enable(10);
        if (parameters.vertexAlphas) _programLayers.enable(11);
        if (parameters.vertexUv1s) _programLayers.enable(12);
        if (parameters.vertexUv2s) _programLayers.enable(13);
        if (parameters.vertexUv3s) _programLayers.enable(14);
        if (parameters.vertexTangents) _programLayers.enable(15);
        if (parameters.anisotropy) _programLayers.enable(16);
        if (parameters.alphaHash) _programLayers.enable(17);
        if (parameters.batching) _programLayers.enable(18);
        if (parameters.dispersion) _programLayers.enable(19);
        if (parameters.batchingColor) _programLayers.enable(20);
        if (parameters.gradientMap) _programLayers.enable(21);
        array.push(_programLayers.mask);
        _programLayers.disableAll();
        if (parameters.fog) _programLayers.enable(0);
        if (parameters.useFog) _programLayers.enable(1);
        if (parameters.flatShading) _programLayers.enable(2);
        if (parameters.logarithmicDepthBuffer) _programLayers.enable(3);
        if (parameters.reversedDepthBuffer) _programLayers.enable(4);
        if (parameters.skinning) _programLayers.enable(5);
        if (parameters.morphTargets) _programLayers.enable(6);
        if (parameters.morphNormals) _programLayers.enable(7);
        if (parameters.morphColors) _programLayers.enable(8);
        if (parameters.premultipliedAlpha) _programLayers.enable(9);
        if (parameters.shadowMapEnabled) _programLayers.enable(10);
        if (parameters.doubleSided) _programLayers.enable(11);
        if (parameters.flipSided) _programLayers.enable(12);
        if (parameters.useDepthPacking) _programLayers.enable(13);
        if (parameters.dithering) _programLayers.enable(14);
        if (parameters.transmission) _programLayers.enable(15);
        if (parameters.sheen) _programLayers.enable(16);
        if (parameters.opaque) _programLayers.enable(17);
        if (parameters.pointsUvs) _programLayers.enable(18);
        if (parameters.decodeVideoTexture) _programLayers.enable(19);
        if (parameters.decodeVideoTextureEmissive) _programLayers.enable(20);
        if (parameters.alphaToCoverage) _programLayers.enable(21);
        array.push(_programLayers.mask);
    }
    function getUniforms(material) {
        const shaderID = shaderIDs[material.type];
        let uniforms;
        if (shaderID) {
            const shader = ShaderLib[shaderID];
            uniforms = (0, _threeCoreJs.UniformsUtils).clone(shader.uniforms);
        } else uniforms = material.uniforms;
        return uniforms;
    }
    function acquireProgram(parameters, cacheKey) {
        let program = programsMap.get(cacheKey);
        if (program !== undefined) ++program.usedTimes;
        else {
            program = new WebGLProgram(renderer, cacheKey, parameters, bindingStates);
            programs.push(program);
            programsMap.set(cacheKey, program);
        }
        return program;
    }
    function releaseProgram(program) {
        if (--program.usedTimes === 0) {
            // Remove from unordered set
            const i = programs.indexOf(program);
            programs[i] = programs[programs.length - 1];
            programs.pop();
            // Remove from map
            programsMap.delete(program.cacheKey);
            // Free WebGL resources
            program.destroy();
        }
    }
    function releaseShaderCache(material) {
        _customShaders.remove(material);
    }
    function dispose() {
        _customShaders.dispose();
    }
    return {
        getParameters: getParameters,
        getProgramCacheKey: getProgramCacheKey,
        getUniforms: getUniforms,
        acquireProgram: acquireProgram,
        releaseProgram: releaseProgram,
        releaseShaderCache: releaseShaderCache,
        // Exposed for resource monitoring & error feedback via renderer.info:
        programs: programs,
        dispose: dispose
    };
}
function WebGLProperties() {
    let properties = new WeakMap();
    function has(object) {
        return properties.has(object);
    }
    function get(object) {
        let map = properties.get(object);
        if (map === undefined) {
            map = {};
            properties.set(object, map);
        }
        return map;
    }
    function remove(object) {
        properties.delete(object);
    }
    function update(object, key, value) {
        properties.get(object)[key] = value;
    }
    function dispose() {
        properties = new WeakMap();
    }
    return {
        has: has,
        get: get,
        remove: remove,
        update: update,
        dispose: dispose
    };
}
function painterSortStable(a, b) {
    if (a.groupOrder !== b.groupOrder) return a.groupOrder - b.groupOrder;
    else if (a.renderOrder !== b.renderOrder) return a.renderOrder - b.renderOrder;
    else if (a.material.id !== b.material.id) return a.material.id - b.material.id;
    else if (a.z !== b.z) return a.z - b.z;
    else return a.id - b.id;
}
function reversePainterSortStable(a, b) {
    if (a.groupOrder !== b.groupOrder) return a.groupOrder - b.groupOrder;
    else if (a.renderOrder !== b.renderOrder) return a.renderOrder - b.renderOrder;
    else if (a.z !== b.z) return b.z - a.z;
    else return a.id - b.id;
}
function WebGLRenderList() {
    const renderItems = [];
    let renderItemsIndex = 0;
    const opaque = [];
    const transmissive = [];
    const transparent = [];
    function init() {
        renderItemsIndex = 0;
        opaque.length = 0;
        transmissive.length = 0;
        transparent.length = 0;
    }
    function getNextRenderItem(object, geometry, material, groupOrder, z, group) {
        let renderItem = renderItems[renderItemsIndex];
        if (renderItem === undefined) {
            renderItem = {
                id: object.id,
                object: object,
                geometry: geometry,
                material: material,
                groupOrder: groupOrder,
                renderOrder: object.renderOrder,
                z: z,
                group: group
            };
            renderItems[renderItemsIndex] = renderItem;
        } else {
            renderItem.id = object.id;
            renderItem.object = object;
            renderItem.geometry = geometry;
            renderItem.material = material;
            renderItem.groupOrder = groupOrder;
            renderItem.renderOrder = object.renderOrder;
            renderItem.z = z;
            renderItem.group = group;
        }
        renderItemsIndex++;
        return renderItem;
    }
    function push(object, geometry, material, groupOrder, z, group) {
        const renderItem = getNextRenderItem(object, geometry, material, groupOrder, z, group);
        if (material.transmission > 0.0) transmissive.push(renderItem);
        else if (material.transparent === true) transparent.push(renderItem);
        else opaque.push(renderItem);
    }
    function unshift(object, geometry, material, groupOrder, z, group) {
        const renderItem = getNextRenderItem(object, geometry, material, groupOrder, z, group);
        if (material.transmission > 0.0) transmissive.unshift(renderItem);
        else if (material.transparent === true) transparent.unshift(renderItem);
        else opaque.unshift(renderItem);
    }
    function sort(customOpaqueSort, customTransparentSort) {
        if (opaque.length > 1) opaque.sort(customOpaqueSort || painterSortStable);
        if (transmissive.length > 1) transmissive.sort(customTransparentSort || reversePainterSortStable);
        if (transparent.length > 1) transparent.sort(customTransparentSort || reversePainterSortStable);
    }
    function finish() {
        // Clear references from inactive renderItems in the list
        for(let i = renderItemsIndex, il = renderItems.length; i < il; i++){
            const renderItem = renderItems[i];
            if (renderItem.id === null) break;
            renderItem.id = null;
            renderItem.object = null;
            renderItem.geometry = null;
            renderItem.material = null;
            renderItem.group = null;
        }
    }
    return {
        opaque: opaque,
        transmissive: transmissive,
        transparent: transparent,
        init: init,
        push: push,
        unshift: unshift,
        finish: finish,
        sort: sort
    };
}
function WebGLRenderLists() {
    let lists = new WeakMap();
    function get(scene, renderCallDepth) {
        const listArray = lists.get(scene);
        let list;
        if (listArray === undefined) {
            list = new WebGLRenderList();
            lists.set(scene, [
                list
            ]);
        } else if (renderCallDepth >= listArray.length) {
            list = new WebGLRenderList();
            listArray.push(list);
        } else list = listArray[renderCallDepth];
        return list;
    }
    function dispose() {
        lists = new WeakMap();
    }
    return {
        get: get,
        dispose: dispose
    };
}
function UniformsCache() {
    const lights = {};
    return {
        get: function(light) {
            if (lights[light.id] !== undefined) return lights[light.id];
            let uniforms;
            switch(light.type){
                case 'DirectionalLight':
                    uniforms = {
                        direction: new (0, _threeCoreJs.Vector3)(),
                        color: new (0, _threeCoreJs.Color)()
                    };
                    break;
                case 'SpotLight':
                    uniforms = {
                        position: new (0, _threeCoreJs.Vector3)(),
                        direction: new (0, _threeCoreJs.Vector3)(),
                        color: new (0, _threeCoreJs.Color)(),
                        distance: 0,
                        coneCos: 0,
                        penumbraCos: 0,
                        decay: 0
                    };
                    break;
                case 'PointLight':
                    uniforms = {
                        position: new (0, _threeCoreJs.Vector3)(),
                        color: new (0, _threeCoreJs.Color)(),
                        distance: 0,
                        decay: 0
                    };
                    break;
                case 'HemisphereLight':
                    uniforms = {
                        direction: new (0, _threeCoreJs.Vector3)(),
                        skyColor: new (0, _threeCoreJs.Color)(),
                        groundColor: new (0, _threeCoreJs.Color)()
                    };
                    break;
                case 'RectAreaLight':
                    uniforms = {
                        color: new (0, _threeCoreJs.Color)(),
                        position: new (0, _threeCoreJs.Vector3)(),
                        halfWidth: new (0, _threeCoreJs.Vector3)(),
                        halfHeight: new (0, _threeCoreJs.Vector3)()
                    };
                    break;
            }
            lights[light.id] = uniforms;
            return uniforms;
        }
    };
}
function ShadowUniformsCache() {
    const lights = {};
    return {
        get: function(light) {
            if (lights[light.id] !== undefined) return lights[light.id];
            let uniforms;
            switch(light.type){
                case 'DirectionalLight':
                    uniforms = {
                        shadowIntensity: 1,
                        shadowBias: 0,
                        shadowNormalBias: 0,
                        shadowRadius: 1,
                        shadowMapSize: new (0, _threeCoreJs.Vector2)()
                    };
                    break;
                case 'SpotLight':
                    uniforms = {
                        shadowIntensity: 1,
                        shadowBias: 0,
                        shadowNormalBias: 0,
                        shadowRadius: 1,
                        shadowMapSize: new (0, _threeCoreJs.Vector2)()
                    };
                    break;
                case 'PointLight':
                    uniforms = {
                        shadowIntensity: 1,
                        shadowBias: 0,
                        shadowNormalBias: 0,
                        shadowRadius: 1,
                        shadowMapSize: new (0, _threeCoreJs.Vector2)(),
                        shadowCameraNear: 1,
                        shadowCameraFar: 1000
                    };
                    break;
            }
            lights[light.id] = uniforms;
            return uniforms;
        }
    };
}
let nextVersion = 0;
function shadowCastingAndTexturingLightsFirst(lightA, lightB) {
    return (lightB.castShadow ? 2 : 0) - (lightA.castShadow ? 2 : 0) + (lightB.map ? 1 : 0) - (lightA.map ? 1 : 0);
}
function WebGLLights(extensions) {
    const cache = new UniformsCache();
    const shadowCache = ShadowUniformsCache();
    const state = {
        version: 0,
        hash: {
            directionalLength: -1,
            pointLength: -1,
            spotLength: -1,
            rectAreaLength: -1,
            hemiLength: -1,
            numDirectionalShadows: -1,
            numPointShadows: -1,
            numSpotShadows: -1,
            numSpotMaps: -1,
            numLightProbes: -1
        },
        ambient: [
            0,
            0,
            0
        ],
        probe: [],
        directional: [],
        directionalShadow: [],
        directionalShadowMap: [],
        directionalShadowMatrix: [],
        spot: [],
        spotLightMap: [],
        spotShadow: [],
        spotShadowMap: [],
        spotLightMatrix: [],
        rectArea: [],
        rectAreaLTC1: null,
        rectAreaLTC2: null,
        point: [],
        pointShadow: [],
        pointShadowMap: [],
        pointShadowMatrix: [],
        hemi: [],
        numSpotLightShadowsWithMaps: 0,
        numLightProbes: 0
    };
    for(let i = 0; i < 9; i++)state.probe.push(new (0, _threeCoreJs.Vector3)());
    const vector3 = new (0, _threeCoreJs.Vector3)();
    const matrix4 = new (0, _threeCoreJs.Matrix4)();
    const matrix42 = new (0, _threeCoreJs.Matrix4)();
    function setup(lights) {
        let r = 0, g = 0, b = 0;
        for(let i = 0; i < 9; i++)state.probe[i].set(0, 0, 0);
        let directionalLength = 0;
        let pointLength = 0;
        let spotLength = 0;
        let rectAreaLength = 0;
        let hemiLength = 0;
        let numDirectionalShadows = 0;
        let numPointShadows = 0;
        let numSpotShadows = 0;
        let numSpotMaps = 0;
        let numSpotShadowsWithMaps = 0;
        let numLightProbes = 0;
        // ordering : [shadow casting + map texturing, map texturing, shadow casting, none ]
        lights.sort(shadowCastingAndTexturingLightsFirst);
        for(let i = 0, l = lights.length; i < l; i++){
            const light = lights[i];
            const color = light.color;
            const intensity = light.intensity;
            const distance = light.distance;
            let shadowMap = null;
            if (light.shadow && light.shadow.map) {
                if (light.shadow.map.texture.format === (0, _threeCoreJs.RGFormat)) // VSM uses color texture with blurred mean/std_dev
                shadowMap = light.shadow.map.texture;
                else // Other types use depth texture
                shadowMap = light.shadow.map.depthTexture || light.shadow.map.texture;
            }
            if (light.isAmbientLight) {
                r += color.r * intensity;
                g += color.g * intensity;
                b += color.b * intensity;
            } else if (light.isLightProbe) {
                for(let j = 0; j < 9; j++)state.probe[j].addScaledVector(light.sh.coefficients[j], intensity);
                numLightProbes++;
            } else if (light.isDirectionalLight) {
                const uniforms = cache.get(light);
                uniforms.color.copy(light.color).multiplyScalar(light.intensity);
                if (light.castShadow) {
                    const shadow = light.shadow;
                    const shadowUniforms = shadowCache.get(light);
                    shadowUniforms.shadowIntensity = shadow.intensity;
                    shadowUniforms.shadowBias = shadow.bias;
                    shadowUniforms.shadowNormalBias = shadow.normalBias;
                    shadowUniforms.shadowRadius = shadow.radius;
                    shadowUniforms.shadowMapSize = shadow.mapSize;
                    state.directionalShadow[directionalLength] = shadowUniforms;
                    state.directionalShadowMap[directionalLength] = shadowMap;
                    state.directionalShadowMatrix[directionalLength] = light.shadow.matrix;
                    numDirectionalShadows++;
                }
                state.directional[directionalLength] = uniforms;
                directionalLength++;
            } else if (light.isSpotLight) {
                const uniforms = cache.get(light);
                uniforms.position.setFromMatrixPosition(light.matrixWorld);
                uniforms.color.copy(color).multiplyScalar(intensity);
                uniforms.distance = distance;
                uniforms.coneCos = Math.cos(light.angle);
                uniforms.penumbraCos = Math.cos(light.angle * (1 - light.penumbra));
                uniforms.decay = light.decay;
                state.spot[spotLength] = uniforms;
                const shadow = light.shadow;
                if (light.map) {
                    state.spotLightMap[numSpotMaps] = light.map;
                    numSpotMaps++;
                    // make sure the lightMatrix is up to date
                    // TODO : do it if required only
                    shadow.updateMatrices(light);
                    if (light.castShadow) numSpotShadowsWithMaps++;
                }
                state.spotLightMatrix[spotLength] = shadow.matrix;
                if (light.castShadow) {
                    const shadowUniforms = shadowCache.get(light);
                    shadowUniforms.shadowIntensity = shadow.intensity;
                    shadowUniforms.shadowBias = shadow.bias;
                    shadowUniforms.shadowNormalBias = shadow.normalBias;
                    shadowUniforms.shadowRadius = shadow.radius;
                    shadowUniforms.shadowMapSize = shadow.mapSize;
                    state.spotShadow[spotLength] = shadowUniforms;
                    state.spotShadowMap[spotLength] = shadowMap;
                    numSpotShadows++;
                }
                spotLength++;
            } else if (light.isRectAreaLight) {
                const uniforms = cache.get(light);
                uniforms.color.copy(color).multiplyScalar(intensity);
                uniforms.halfWidth.set(light.width * 0.5, 0.0, 0.0);
                uniforms.halfHeight.set(0.0, light.height * 0.5, 0.0);
                state.rectArea[rectAreaLength] = uniforms;
                rectAreaLength++;
            } else if (light.isPointLight) {
                const uniforms = cache.get(light);
                uniforms.color.copy(light.color).multiplyScalar(light.intensity);
                uniforms.distance = light.distance;
                uniforms.decay = light.decay;
                if (light.castShadow) {
                    const shadow = light.shadow;
                    const shadowUniforms = shadowCache.get(light);
                    shadowUniforms.shadowIntensity = shadow.intensity;
                    shadowUniforms.shadowBias = shadow.bias;
                    shadowUniforms.shadowNormalBias = shadow.normalBias;
                    shadowUniforms.shadowRadius = shadow.radius;
                    shadowUniforms.shadowMapSize = shadow.mapSize;
                    shadowUniforms.shadowCameraNear = shadow.camera.near;
                    shadowUniforms.shadowCameraFar = shadow.camera.far;
                    state.pointShadow[pointLength] = shadowUniforms;
                    state.pointShadowMap[pointLength] = shadowMap;
                    state.pointShadowMatrix[pointLength] = light.shadow.matrix;
                    numPointShadows++;
                }
                state.point[pointLength] = uniforms;
                pointLength++;
            } else if (light.isHemisphereLight) {
                const uniforms = cache.get(light);
                uniforms.skyColor.copy(light.color).multiplyScalar(intensity);
                uniforms.groundColor.copy(light.groundColor).multiplyScalar(intensity);
                state.hemi[hemiLength] = uniforms;
                hemiLength++;
            }
        }
        if (rectAreaLength > 0) {
            if (extensions.has('OES_texture_float_linear') === true) {
                state.rectAreaLTC1 = UniformsLib.LTC_FLOAT_1;
                state.rectAreaLTC2 = UniformsLib.LTC_FLOAT_2;
            } else {
                state.rectAreaLTC1 = UniformsLib.LTC_HALF_1;
                state.rectAreaLTC2 = UniformsLib.LTC_HALF_2;
            }
        }
        state.ambient[0] = r;
        state.ambient[1] = g;
        state.ambient[2] = b;
        const hash = state.hash;
        if (hash.directionalLength !== directionalLength || hash.pointLength !== pointLength || hash.spotLength !== spotLength || hash.rectAreaLength !== rectAreaLength || hash.hemiLength !== hemiLength || hash.numDirectionalShadows !== numDirectionalShadows || hash.numPointShadows !== numPointShadows || hash.numSpotShadows !== numSpotShadows || hash.numSpotMaps !== numSpotMaps || hash.numLightProbes !== numLightProbes) {
            state.directional.length = directionalLength;
            state.spot.length = spotLength;
            state.rectArea.length = rectAreaLength;
            state.point.length = pointLength;
            state.hemi.length = hemiLength;
            state.directionalShadow.length = numDirectionalShadows;
            state.directionalShadowMap.length = numDirectionalShadows;
            state.pointShadow.length = numPointShadows;
            state.pointShadowMap.length = numPointShadows;
            state.spotShadow.length = numSpotShadows;
            state.spotShadowMap.length = numSpotShadows;
            state.directionalShadowMatrix.length = numDirectionalShadows;
            state.pointShadowMatrix.length = numPointShadows;
            state.spotLightMatrix.length = numSpotShadows + numSpotMaps - numSpotShadowsWithMaps;
            state.spotLightMap.length = numSpotMaps;
            state.numSpotLightShadowsWithMaps = numSpotShadowsWithMaps;
            state.numLightProbes = numLightProbes;
            hash.directionalLength = directionalLength;
            hash.pointLength = pointLength;
            hash.spotLength = spotLength;
            hash.rectAreaLength = rectAreaLength;
            hash.hemiLength = hemiLength;
            hash.numDirectionalShadows = numDirectionalShadows;
            hash.numPointShadows = numPointShadows;
            hash.numSpotShadows = numSpotShadows;
            hash.numSpotMaps = numSpotMaps;
            hash.numLightProbes = numLightProbes;
            state.version = nextVersion++;
        }
    }
    function setupView(lights, camera) {
        let directionalLength = 0;
        let pointLength = 0;
        let spotLength = 0;
        let rectAreaLength = 0;
        let hemiLength = 0;
        const viewMatrix = camera.matrixWorldInverse;
        for(let i = 0, l = lights.length; i < l; i++){
            const light = lights[i];
            if (light.isDirectionalLight) {
                const uniforms = state.directional[directionalLength];
                uniforms.direction.setFromMatrixPosition(light.matrixWorld);
                vector3.setFromMatrixPosition(light.target.matrixWorld);
                uniforms.direction.sub(vector3);
                uniforms.direction.transformDirection(viewMatrix);
                directionalLength++;
            } else if (light.isSpotLight) {
                const uniforms = state.spot[spotLength];
                uniforms.position.setFromMatrixPosition(light.matrixWorld);
                uniforms.position.applyMatrix4(viewMatrix);
                uniforms.direction.setFromMatrixPosition(light.matrixWorld);
                vector3.setFromMatrixPosition(light.target.matrixWorld);
                uniforms.direction.sub(vector3);
                uniforms.direction.transformDirection(viewMatrix);
                spotLength++;
            } else if (light.isRectAreaLight) {
                const uniforms = state.rectArea[rectAreaLength];
                uniforms.position.setFromMatrixPosition(light.matrixWorld);
                uniforms.position.applyMatrix4(viewMatrix);
                // extract local rotation of light to derive width/height half vectors
                matrix42.identity();
                matrix4.copy(light.matrixWorld);
                matrix4.premultiply(viewMatrix);
                matrix42.extractRotation(matrix4);
                uniforms.halfWidth.set(light.width * 0.5, 0.0, 0.0);
                uniforms.halfHeight.set(0.0, light.height * 0.5, 0.0);
                uniforms.halfWidth.applyMatrix4(matrix42);
                uniforms.halfHeight.applyMatrix4(matrix42);
                rectAreaLength++;
            } else if (light.isPointLight) {
                const uniforms = state.point[pointLength];
                uniforms.position.setFromMatrixPosition(light.matrixWorld);
                uniforms.position.applyMatrix4(viewMatrix);
                pointLength++;
            } else if (light.isHemisphereLight) {
                const uniforms = state.hemi[hemiLength];
                uniforms.direction.setFromMatrixPosition(light.matrixWorld);
                uniforms.direction.transformDirection(viewMatrix);
                hemiLength++;
            }
        }
    }
    return {
        setup: setup,
        setupView: setupView,
        state: state
    };
}
function WebGLRenderState(extensions) {
    const lights = new WebGLLights(extensions);
    const lightsArray = [];
    const shadowsArray = [];
    function init(camera) {
        state.camera = camera;
        lightsArray.length = 0;
        shadowsArray.length = 0;
    }
    function pushLight(light) {
        lightsArray.push(light);
    }
    function pushShadow(shadowLight) {
        shadowsArray.push(shadowLight);
    }
    function setupLights() {
        lights.setup(lightsArray);
    }
    function setupLightsView(camera) {
        lights.setupView(lightsArray, camera);
    }
    const state = {
        lightsArray: lightsArray,
        shadowsArray: shadowsArray,
        camera: null,
        lights: lights,
        transmissionRenderTarget: {}
    };
    return {
        init: init,
        state: state,
        setupLights: setupLights,
        setupLightsView: setupLightsView,
        pushLight: pushLight,
        pushShadow: pushShadow
    };
}
function WebGLRenderStates(extensions) {
    let renderStates = new WeakMap();
    function get(scene, renderCallDepth = 0) {
        const renderStateArray = renderStates.get(scene);
        let renderState;
        if (renderStateArray === undefined) {
            renderState = new WebGLRenderState(extensions);
            renderStates.set(scene, [
                renderState
            ]);
        } else if (renderCallDepth >= renderStateArray.length) {
            renderState = new WebGLRenderState(extensions);
            renderStateArray.push(renderState);
        } else renderState = renderStateArray[renderCallDepth];
        return renderState;
    }
    function dispose() {
        renderStates = new WeakMap();
    }
    return {
        get: get,
        dispose: dispose
    };
}
const vertex = "void main() {\n\tgl_Position = vec4( position, 1.0 );\n}";
const fragment = "uniform sampler2D shadow_pass;\nuniform vec2 resolution;\nuniform float radius;\nvoid main() {\n\tconst float samples = float( VSM_SAMPLES );\n\tfloat mean = 0.0;\n\tfloat squared_mean = 0.0;\n\tfloat uvStride = samples <= 1.0 ? 0.0 : 2.0 / ( samples - 1.0 );\n\tfloat uvStart = samples <= 1.0 ? 0.0 : - 1.0;\n\tfor ( float i = 0.0; i < samples; i ++ ) {\n\t\tfloat uvOffset = uvStart + i * uvStride;\n\t\t#ifdef HORIZONTAL_PASS\n\t\t\tvec2 distribution = texture2D( shadow_pass, ( gl_FragCoord.xy + vec2( uvOffset, 0.0 ) * radius ) / resolution ).rg;\n\t\t\tmean += distribution.x;\n\t\t\tsquared_mean += distribution.y * distribution.y + distribution.x * distribution.x;\n\t\t#else\n\t\t\tfloat depth = texture2D( shadow_pass, ( gl_FragCoord.xy + vec2( 0.0, uvOffset ) * radius ) / resolution ).r;\n\t\t\tmean += depth;\n\t\t\tsquared_mean += depth * depth;\n\t\t#endif\n\t}\n\tmean = mean / samples;\n\tsquared_mean = squared_mean / samples;\n\tfloat std_dev = sqrt( max( 0.0, squared_mean - mean * mean ) );\n\tgl_FragColor = vec4( mean, std_dev, 0.0, 1.0 );\n}";
const _cubeDirections = [
    /*@__PURE__*/ new (0, _threeCoreJs.Vector3)(1, 0, 0),
    /*@__PURE__*/ new (0, _threeCoreJs.Vector3)(-1, 0, 0),
    /*@__PURE__*/ new (0, _threeCoreJs.Vector3)(0, 1, 0),
    /*@__PURE__*/ new (0, _threeCoreJs.Vector3)(0, -1, 0),
    /*@__PURE__*/ new (0, _threeCoreJs.Vector3)(0, 0, 1),
    /*@__PURE__*/ new (0, _threeCoreJs.Vector3)(0, 0, -1)
];
const _cubeUps = [
    /*@__PURE__*/ new (0, _threeCoreJs.Vector3)(0, -1, 0),
    /*@__PURE__*/ new (0, _threeCoreJs.Vector3)(0, -1, 0),
    /*@__PURE__*/ new (0, _threeCoreJs.Vector3)(0, 0, 1),
    /*@__PURE__*/ new (0, _threeCoreJs.Vector3)(0, 0, -1),
    /*@__PURE__*/ new (0, _threeCoreJs.Vector3)(0, -1, 0),
    /*@__PURE__*/ new (0, _threeCoreJs.Vector3)(0, -1, 0)
];
const _projScreenMatrix = /*@__PURE__*/ new (0, _threeCoreJs.Matrix4)();
const _lightPositionWorld = /*@__PURE__*/ new (0, _threeCoreJs.Vector3)();
const _lookTarget = /*@__PURE__*/ new (0, _threeCoreJs.Vector3)();
function WebGLShadowMap(renderer, objects, capabilities) {
    let _frustum = new (0, _threeCoreJs.Frustum)();
    const _shadowMapSize = new (0, _threeCoreJs.Vector2)(), _viewportSize = new (0, _threeCoreJs.Vector2)(), _viewport = new (0, _threeCoreJs.Vector4)(), _depthMaterial = new (0, _threeCoreJs.MeshDepthMaterial)(), _distanceMaterial = new (0, _threeCoreJs.MeshDistanceMaterial)(), _materialCache = {}, _maxTextureSize = capabilities.maxTextureSize;
    const shadowSide = {
        [(0, _threeCoreJs.FrontSide)]: (0, _threeCoreJs.BackSide),
        [(0, _threeCoreJs.BackSide)]: (0, _threeCoreJs.FrontSide),
        [(0, _threeCoreJs.DoubleSide)]: (0, _threeCoreJs.DoubleSide)
    };
    const shadowMaterialVertical = new (0, _threeCoreJs.ShaderMaterial)({
        defines: {
            VSM_SAMPLES: 8
        },
        uniforms: {
            shadow_pass: {
                value: null
            },
            resolution: {
                value: new (0, _threeCoreJs.Vector2)()
            },
            radius: {
                value: 4.0
            }
        },
        vertexShader: vertex,
        fragmentShader: fragment
    });
    const shadowMaterialHorizontal = shadowMaterialVertical.clone();
    shadowMaterialHorizontal.defines.HORIZONTAL_PASS = 1;
    const fullScreenTri = new (0, _threeCoreJs.BufferGeometry)();
    fullScreenTri.setAttribute('position', new (0, _threeCoreJs.BufferAttribute)(new Float32Array([
        -1,
        -1,
        0.5,
        3,
        -1,
        0.5,
        -1,
        3,
        0.5
    ]), 3));
    const fullScreenMesh = new (0, _threeCoreJs.Mesh)(fullScreenTri, shadowMaterialVertical);
    const scope = this;
    this.enabled = false;
    this.autoUpdate = true;
    this.needsUpdate = false;
    this.type = (0, _threeCoreJs.PCFShadowMap);
    let _previousType = this.type;
    this.render = function(lights, scene, camera) {
        if (scope.enabled === false) return;
        if (scope.autoUpdate === false && scope.needsUpdate === false) return;
        if (lights.length === 0) return;
        if (lights.type === (0, _threeCoreJs.PCFSoftShadowMap)) {
            (0, _threeCoreJs.warn)('WebGLShadowMap: PCFSoftShadowMap has been deprecated. Using PCFShadowMap instead.');
            lights.type = (0, _threeCoreJs.PCFShadowMap);
        }
        const currentRenderTarget = renderer.getRenderTarget();
        const activeCubeFace = renderer.getActiveCubeFace();
        const activeMipmapLevel = renderer.getActiveMipmapLevel();
        const _state = renderer.state;
        // Set GL state for depth map.
        _state.setBlending((0, _threeCoreJs.NoBlending));
        if (_state.buffers.depth.getReversed() === true) _state.buffers.color.setClear(0, 0, 0, 0);
        else _state.buffers.color.setClear(1, 1, 1, 1);
        _state.buffers.depth.setTest(true);
        _state.setScissorTest(false);
        // check for shadow map type changes
        const typeChanged = _previousType !== this.type;
        // When shadow map type changes, materials need recompilation because sampler types change
        // (sampler2DShadow for PCF vs sampler2D for Basic)
        if (typeChanged) scene.traverse(function(object) {
            if (object.material) {
                if (Array.isArray(object.material)) object.material.forEach((mat)=>mat.needsUpdate = true);
                else object.material.needsUpdate = true;
            }
        });
        // render depth map
        for(let i = 0, il = lights.length; i < il; i++){
            const light = lights[i];
            const shadow = light.shadow;
            if (shadow === undefined) {
                (0, _threeCoreJs.warn)('WebGLShadowMap:', light, 'has no shadow.');
                continue;
            }
            if (shadow.autoUpdate === false && shadow.needsUpdate === false) continue;
            _shadowMapSize.copy(shadow.mapSize);
            const shadowFrameExtents = shadow.getFrameExtents();
            _shadowMapSize.multiply(shadowFrameExtents);
            _viewportSize.copy(shadow.mapSize);
            if (_shadowMapSize.x > _maxTextureSize || _shadowMapSize.y > _maxTextureSize) {
                if (_shadowMapSize.x > _maxTextureSize) {
                    _viewportSize.x = Math.floor(_maxTextureSize / shadowFrameExtents.x);
                    _shadowMapSize.x = _viewportSize.x * shadowFrameExtents.x;
                    shadow.mapSize.x = _viewportSize.x;
                }
                if (_shadowMapSize.y > _maxTextureSize) {
                    _viewportSize.y = Math.floor(_maxTextureSize / shadowFrameExtents.y);
                    _shadowMapSize.y = _viewportSize.y * shadowFrameExtents.y;
                    shadow.mapSize.y = _viewportSize.y;
                }
            }
            if (shadow.map === null || typeChanged === true) {
                if (shadow.map !== null) {
                    if (shadow.map.depthTexture !== null) {
                        shadow.map.depthTexture.dispose();
                        shadow.map.depthTexture = null;
                    }
                    shadow.map.dispose();
                }
                if (this.type === (0, _threeCoreJs.VSMShadowMap)) {
                    if (light.isPointLight) {
                        (0, _threeCoreJs.warn)('WebGLShadowMap: VSM shadow maps are not supported for PointLights. Use PCF or BasicShadowMap instead.');
                        continue;
                    }
                    shadow.map = new (0, _threeCoreJs.WebGLRenderTarget)(_shadowMapSize.x, _shadowMapSize.y, {
                        format: (0, _threeCoreJs.RGFormat),
                        type: (0, _threeCoreJs.HalfFloatType),
                        minFilter: (0, _threeCoreJs.LinearFilter),
                        magFilter: (0, _threeCoreJs.LinearFilter),
                        generateMipmaps: false
                    });
                    shadow.map.texture.name = light.name + '.shadowMap';
                    // Native depth texture for VSM - depth is captured here, then blurred into the color texture
                    shadow.map.depthTexture = new (0, _threeCoreJs.DepthTexture)(_shadowMapSize.x, _shadowMapSize.y, (0, _threeCoreJs.FloatType));
                    shadow.map.depthTexture.name = light.name + '.shadowMapDepth';
                    shadow.map.depthTexture.format = (0, _threeCoreJs.DepthFormat);
                    shadow.map.depthTexture.compareFunction = null; // For regular sampling (not shadow comparison)
                    shadow.map.depthTexture.minFilter = (0, _threeCoreJs.NearestFilter);
                    shadow.map.depthTexture.magFilter = (0, _threeCoreJs.NearestFilter);
                } else {
                    if (light.isPointLight) {
                        shadow.map = new (0, _threeCoreJs.WebGLCubeRenderTarget)(_shadowMapSize.x);
                        shadow.map.depthTexture = new (0, _threeCoreJs.CubeDepthTexture)(_shadowMapSize.x, (0, _threeCoreJs.UnsignedIntType));
                    } else {
                        shadow.map = new (0, _threeCoreJs.WebGLRenderTarget)(_shadowMapSize.x, _shadowMapSize.y);
                        shadow.map.depthTexture = new (0, _threeCoreJs.DepthTexture)(_shadowMapSize.x, _shadowMapSize.y, (0, _threeCoreJs.UnsignedIntType));
                    }
                    shadow.map.depthTexture.name = light.name + '.shadowMap';
                    shadow.map.depthTexture.format = (0, _threeCoreJs.DepthFormat);
                    const reversedDepthBuffer = renderer.state.buffers.depth.getReversed();
                    if (this.type === (0, _threeCoreJs.PCFShadowMap)) {
                        shadow.map.depthTexture.compareFunction = reversedDepthBuffer ? (0, _threeCoreJs.GreaterEqualCompare) : (0, _threeCoreJs.LessEqualCompare);
                        shadow.map.depthTexture.minFilter = (0, _threeCoreJs.LinearFilter);
                        shadow.map.depthTexture.magFilter = (0, _threeCoreJs.LinearFilter);
                    } else {
                        shadow.map.depthTexture.compareFunction = null;
                        shadow.map.depthTexture.minFilter = (0, _threeCoreJs.NearestFilter);
                        shadow.map.depthTexture.magFilter = (0, _threeCoreJs.NearestFilter);
                    }
                }
                shadow.camera.updateProjectionMatrix();
            }
            // For cube render targets (PointLights), render all 6 faces. Otherwise, render once.
            const faceCount = shadow.map.isWebGLCubeRenderTarget ? 6 : 1;
            for(let face = 0; face < faceCount; face++){
                // For cube render targets, render to each face separately
                if (shadow.map.isWebGLCubeRenderTarget) {
                    renderer.setRenderTarget(shadow.map, face);
                    renderer.clear();
                } else {
                    // For 2D render targets, use viewports
                    if (face === 0) {
                        renderer.setRenderTarget(shadow.map);
                        renderer.clear();
                    }
                    const viewport = shadow.getViewport(face);
                    _viewport.set(_viewportSize.x * viewport.x, _viewportSize.y * viewport.y, _viewportSize.x * viewport.z, _viewportSize.y * viewport.w);
                    _state.viewport(_viewport);
                }
                if (light.isPointLight) {
                    const camera = shadow.camera;
                    const shadowMatrix = shadow.matrix;
                    const far = light.distance || camera.far;
                    if (far !== camera.far) {
                        camera.far = far;
                        camera.updateProjectionMatrix();
                    }
                    _lightPositionWorld.setFromMatrixPosition(light.matrixWorld);
                    camera.position.copy(_lightPositionWorld);
                    _lookTarget.copy(camera.position);
                    _lookTarget.add(_cubeDirections[face]);
                    camera.up.copy(_cubeUps[face]);
                    camera.lookAt(_lookTarget);
                    camera.updateMatrixWorld();
                    shadowMatrix.makeTranslation(-_lightPositionWorld.x, -_lightPositionWorld.y, -_lightPositionWorld.z);
                    _projScreenMatrix.multiplyMatrices(camera.projectionMatrix, camera.matrixWorldInverse);
                    shadow._frustum.setFromProjectionMatrix(_projScreenMatrix, camera.coordinateSystem, camera.reversedDepth);
                } else shadow.updateMatrices(light);
                _frustum = shadow.getFrustum();
                renderObject(scene, camera, shadow.camera, light, this.type);
            }
            // do blur pass for VSM
            if (shadow.isPointLightShadow !== true && this.type === (0, _threeCoreJs.VSMShadowMap)) VSMPass(shadow, camera);
            shadow.needsUpdate = false;
        }
        _previousType = this.type;
        scope.needsUpdate = false;
        renderer.setRenderTarget(currentRenderTarget, activeCubeFace, activeMipmapLevel);
    };
    function VSMPass(shadow, camera) {
        const geometry = objects.update(fullScreenMesh);
        if (shadowMaterialVertical.defines.VSM_SAMPLES !== shadow.blurSamples) {
            shadowMaterialVertical.defines.VSM_SAMPLES = shadow.blurSamples;
            shadowMaterialHorizontal.defines.VSM_SAMPLES = shadow.blurSamples;
            shadowMaterialVertical.needsUpdate = true;
            shadowMaterialHorizontal.needsUpdate = true;
        }
        if (shadow.mapPass === null) shadow.mapPass = new (0, _threeCoreJs.WebGLRenderTarget)(_shadowMapSize.x, _shadowMapSize.y, {
            format: (0, _threeCoreJs.RGFormat),
            type: (0, _threeCoreJs.HalfFloatType)
        });
        // vertical pass - read from native depth texture
        shadowMaterialVertical.uniforms.shadow_pass.value = shadow.map.depthTexture;
        shadowMaterialVertical.uniforms.resolution.value = shadow.mapSize;
        shadowMaterialVertical.uniforms.radius.value = shadow.radius;
        renderer.setRenderTarget(shadow.mapPass);
        renderer.clear();
        renderer.renderBufferDirect(camera, null, geometry, shadowMaterialVertical, fullScreenMesh, null);
        // horizontal pass
        shadowMaterialHorizontal.uniforms.shadow_pass.value = shadow.mapPass.texture;
        shadowMaterialHorizontal.uniforms.resolution.value = shadow.mapSize;
        shadowMaterialHorizontal.uniforms.radius.value = shadow.radius;
        renderer.setRenderTarget(shadow.map);
        renderer.clear();
        renderer.renderBufferDirect(camera, null, geometry, shadowMaterialHorizontal, fullScreenMesh, null);
    }
    function getDepthMaterial(object, material, light, type) {
        let result = null;
        const customMaterial = light.isPointLight === true ? object.customDistanceMaterial : object.customDepthMaterial;
        if (customMaterial !== undefined) result = customMaterial;
        else {
            result = light.isPointLight === true ? _distanceMaterial : _depthMaterial;
            if (renderer.localClippingEnabled && material.clipShadows === true && Array.isArray(material.clippingPlanes) && material.clippingPlanes.length !== 0 || material.displacementMap && material.displacementScale !== 0 || material.alphaMap && material.alphaTest > 0 || material.map && material.alphaTest > 0 || material.alphaToCoverage === true) {
                // in this case we need a unique material instance reflecting the
                // appropriate state
                const keyA = result.uuid, keyB = material.uuid;
                let materialsForVariant = _materialCache[keyA];
                if (materialsForVariant === undefined) {
                    materialsForVariant = {};
                    _materialCache[keyA] = materialsForVariant;
                }
                let cachedMaterial = materialsForVariant[keyB];
                if (cachedMaterial === undefined) {
                    cachedMaterial = result.clone();
                    materialsForVariant[keyB] = cachedMaterial;
                    material.addEventListener('dispose', onMaterialDispose);
                }
                result = cachedMaterial;
            }
        }
        result.visible = material.visible;
        result.wireframe = material.wireframe;
        if (type === (0, _threeCoreJs.VSMShadowMap)) result.side = material.shadowSide !== null ? material.shadowSide : material.side;
        else result.side = material.shadowSide !== null ? material.shadowSide : shadowSide[material.side];
        result.alphaMap = material.alphaMap;
        result.alphaTest = material.alphaToCoverage === true ? 0.5 : material.alphaTest; // approximate alphaToCoverage by using a fixed alphaTest value
        result.map = material.map;
        result.clipShadows = material.clipShadows;
        result.clippingPlanes = material.clippingPlanes;
        result.clipIntersection = material.clipIntersection;
        result.displacementMap = material.displacementMap;
        result.displacementScale = material.displacementScale;
        result.displacementBias = material.displacementBias;
        result.wireframeLinewidth = material.wireframeLinewidth;
        result.linewidth = material.linewidth;
        if (light.isPointLight === true && result.isMeshDistanceMaterial === true) {
            const materialProperties = renderer.properties.get(result);
            materialProperties.light = light;
        }
        return result;
    }
    function renderObject(object, camera, shadowCamera, light, type) {
        if (object.visible === false) return;
        const visible = object.layers.test(camera.layers);
        if (visible && (object.isMesh || object.isLine || object.isPoints)) {
            if ((object.castShadow || object.receiveShadow && type === (0, _threeCoreJs.VSMShadowMap)) && (!object.frustumCulled || _frustum.intersectsObject(object))) {
                object.modelViewMatrix.multiplyMatrices(shadowCamera.matrixWorldInverse, object.matrixWorld);
                const geometry = objects.update(object);
                const material = object.material;
                if (Array.isArray(material)) {
                    const groups = geometry.groups;
                    for(let k = 0, kl = groups.length; k < kl; k++){
                        const group = groups[k];
                        const groupMaterial = material[group.materialIndex];
                        if (groupMaterial && groupMaterial.visible) {
                            const depthMaterial = getDepthMaterial(object, groupMaterial, light, type);
                            object.onBeforeShadow(renderer, object, camera, shadowCamera, geometry, depthMaterial, group);
                            renderer.renderBufferDirect(shadowCamera, null, geometry, depthMaterial, object, group);
                            object.onAfterShadow(renderer, object, camera, shadowCamera, geometry, depthMaterial, group);
                        }
                    }
                } else if (material.visible) {
                    const depthMaterial = getDepthMaterial(object, material, light, type);
                    object.onBeforeShadow(renderer, object, camera, shadowCamera, geometry, depthMaterial, null);
                    renderer.renderBufferDirect(shadowCamera, null, geometry, depthMaterial, object, null);
                    object.onAfterShadow(renderer, object, camera, shadowCamera, geometry, depthMaterial, null);
                }
            }
        }
        const children = object.children;
        for(let i = 0, l = children.length; i < l; i++)renderObject(children[i], camera, shadowCamera, light, type);
    }
    function onMaterialDispose(event) {
        const material = event.target;
        material.removeEventListener('dispose', onMaterialDispose);
        // make sure to remove the unique distance/depth materials used for shadow map rendering
        for(const id in _materialCache){
            const cache = _materialCache[id];
            const uuid = event.target.uuid;
            if (uuid in cache) {
                const shadowMaterial = cache[uuid];
                shadowMaterial.dispose();
                delete cache[uuid];
            }
        }
    }
}
const reversedFuncs = {
    [(0, _threeCoreJs.NeverDepth)]: (0, _threeCoreJs.AlwaysDepth),
    [(0, _threeCoreJs.LessDepth)]: (0, _threeCoreJs.GreaterDepth),
    [(0, _threeCoreJs.EqualDepth)]: (0, _threeCoreJs.NotEqualDepth),
    [(0, _threeCoreJs.LessEqualDepth)]: (0, _threeCoreJs.GreaterEqualDepth),
    [(0, _threeCoreJs.AlwaysDepth)]: (0, _threeCoreJs.NeverDepth),
    [(0, _threeCoreJs.GreaterDepth)]: (0, _threeCoreJs.LessDepth),
    [(0, _threeCoreJs.NotEqualDepth)]: (0, _threeCoreJs.EqualDepth),
    [(0, _threeCoreJs.GreaterEqualDepth)]: (0, _threeCoreJs.LessEqualDepth)
};
function WebGLState(gl, extensions) {
    function ColorBuffer() {
        let locked = false;
        const color = new (0, _threeCoreJs.Vector4)();
        let currentColorMask = null;
        const currentColorClear = new (0, _threeCoreJs.Vector4)(0, 0, 0, 0);
        return {
            setMask: function(colorMask) {
                if (currentColorMask !== colorMask && !locked) {
                    gl.colorMask(colorMask, colorMask, colorMask, colorMask);
                    currentColorMask = colorMask;
                }
            },
            setLocked: function(lock) {
                locked = lock;
            },
            setClear: function(r, g, b, a, premultipliedAlpha) {
                if (premultipliedAlpha === true) {
                    r *= a;
                    g *= a;
                    b *= a;
                }
                color.set(r, g, b, a);
                if (currentColorClear.equals(color) === false) {
                    gl.clearColor(r, g, b, a);
                    currentColorClear.copy(color);
                }
            },
            reset: function() {
                locked = false;
                currentColorMask = null;
                currentColorClear.set(-1, 0, 0, 0); // set to invalid state
            }
        };
    }
    function DepthBuffer() {
        let locked = false;
        let currentReversed = false;
        let currentDepthMask = null;
        let currentDepthFunc = null;
        let currentDepthClear = null;
        return {
            setReversed: function(reversed) {
                if (currentReversed !== reversed) {
                    const ext = extensions.get('EXT_clip_control');
                    if (reversed) ext.clipControlEXT(ext.LOWER_LEFT_EXT, ext.ZERO_TO_ONE_EXT);
                    else ext.clipControlEXT(ext.LOWER_LEFT_EXT, ext.NEGATIVE_ONE_TO_ONE_EXT);
                    currentReversed = reversed;
                    const oldDepth = currentDepthClear;
                    currentDepthClear = null;
                    this.setClear(oldDepth);
                }
            },
            getReversed: function() {
                return currentReversed;
            },
            setTest: function(depthTest) {
                if (depthTest) enable(gl.DEPTH_TEST);
                else disable(gl.DEPTH_TEST);
            },
            setMask: function(depthMask) {
                if (currentDepthMask !== depthMask && !locked) {
                    gl.depthMask(depthMask);
                    currentDepthMask = depthMask;
                }
            },
            setFunc: function(depthFunc) {
                if (currentReversed) depthFunc = reversedFuncs[depthFunc];
                if (currentDepthFunc !== depthFunc) {
                    switch(depthFunc){
                        case 0, _threeCoreJs.NeverDepth:
                            gl.depthFunc(gl.NEVER);
                            break;
                        case 0, _threeCoreJs.AlwaysDepth:
                            gl.depthFunc(gl.ALWAYS);
                            break;
                        case 0, _threeCoreJs.LessDepth:
                            gl.depthFunc(gl.LESS);
                            break;
                        case 0, _threeCoreJs.LessEqualDepth:
                            gl.depthFunc(gl.LEQUAL);
                            break;
                        case 0, _threeCoreJs.EqualDepth:
                            gl.depthFunc(gl.EQUAL);
                            break;
                        case 0, _threeCoreJs.GreaterEqualDepth:
                            gl.depthFunc(gl.GEQUAL);
                            break;
                        case 0, _threeCoreJs.GreaterDepth:
                            gl.depthFunc(gl.GREATER);
                            break;
                        case 0, _threeCoreJs.NotEqualDepth:
                            gl.depthFunc(gl.NOTEQUAL);
                            break;
                        default:
                            gl.depthFunc(gl.LEQUAL);
                    }
                    currentDepthFunc = depthFunc;
                }
            },
            setLocked: function(lock) {
                locked = lock;
            },
            setClear: function(depth) {
                if (currentDepthClear !== depth) {
                    if (currentReversed) depth = 1 - depth;
                    gl.clearDepth(depth);
                    currentDepthClear = depth;
                }
            },
            reset: function() {
                locked = false;
                currentDepthMask = null;
                currentDepthFunc = null;
                currentDepthClear = null;
                currentReversed = false;
            }
        };
    }
    function StencilBuffer() {
        let locked = false;
        let currentStencilMask = null;
        let currentStencilFunc = null;
        let currentStencilRef = null;
        let currentStencilFuncMask = null;
        let currentStencilFail = null;
        let currentStencilZFail = null;
        let currentStencilZPass = null;
        let currentStencilClear = null;
        return {
            setTest: function(stencilTest) {
                if (!locked) {
                    if (stencilTest) enable(gl.STENCIL_TEST);
                    else disable(gl.STENCIL_TEST);
                }
            },
            setMask: function(stencilMask) {
                if (currentStencilMask !== stencilMask && !locked) {
                    gl.stencilMask(stencilMask);
                    currentStencilMask = stencilMask;
                }
            },
            setFunc: function(stencilFunc, stencilRef, stencilMask) {
                if (currentStencilFunc !== stencilFunc || currentStencilRef !== stencilRef || currentStencilFuncMask !== stencilMask) {
                    gl.stencilFunc(stencilFunc, stencilRef, stencilMask);
                    currentStencilFunc = stencilFunc;
                    currentStencilRef = stencilRef;
                    currentStencilFuncMask = stencilMask;
                }
            },
            setOp: function(stencilFail, stencilZFail, stencilZPass) {
                if (currentStencilFail !== stencilFail || currentStencilZFail !== stencilZFail || currentStencilZPass !== stencilZPass) {
                    gl.stencilOp(stencilFail, stencilZFail, stencilZPass);
                    currentStencilFail = stencilFail;
                    currentStencilZFail = stencilZFail;
                    currentStencilZPass = stencilZPass;
                }
            },
            setLocked: function(lock) {
                locked = lock;
            },
            setClear: function(stencil) {
                if (currentStencilClear !== stencil) {
                    gl.clearStencil(stencil);
                    currentStencilClear = stencil;
                }
            },
            reset: function() {
                locked = false;
                currentStencilMask = null;
                currentStencilFunc = null;
                currentStencilRef = null;
                currentStencilFuncMask = null;
                currentStencilFail = null;
                currentStencilZFail = null;
                currentStencilZPass = null;
                currentStencilClear = null;
            }
        };
    }
    //
    const colorBuffer = new ColorBuffer();
    const depthBuffer = new DepthBuffer();
    const stencilBuffer = new StencilBuffer();
    const uboBindings = new WeakMap();
    const uboProgramMap = new WeakMap();
    let enabledCapabilities = {};
    let currentBoundFramebuffers = {};
    let currentDrawbuffers = new WeakMap();
    let defaultDrawbuffers = [];
    let currentProgram = null;
    let currentBlendingEnabled = false;
    let currentBlending = null;
    let currentBlendEquation = null;
    let currentBlendSrc = null;
    let currentBlendDst = null;
    let currentBlendEquationAlpha = null;
    let currentBlendSrcAlpha = null;
    let currentBlendDstAlpha = null;
    let currentBlendColor = new (0, _threeCoreJs.Color)(0, 0, 0);
    let currentBlendAlpha = 0;
    let currentPremultipledAlpha = false;
    let currentFlipSided = null;
    let currentCullFace = null;
    let currentLineWidth = null;
    let currentPolygonOffsetFactor = null;
    let currentPolygonOffsetUnits = null;
    const maxTextures = gl.getParameter(gl.MAX_COMBINED_TEXTURE_IMAGE_UNITS);
    let lineWidthAvailable = false;
    let version = 0;
    const glVersion = gl.getParameter(gl.VERSION);
    if (glVersion.indexOf('WebGL') !== -1) {
        version = parseFloat(/^WebGL (\d)/.exec(glVersion)[1]);
        lineWidthAvailable = version >= 1.0;
    } else if (glVersion.indexOf('OpenGL ES') !== -1) {
        version = parseFloat(/^OpenGL ES (\d)/.exec(glVersion)[1]);
        lineWidthAvailable = version >= 2.0;
    }
    let currentTextureSlot = null;
    let currentBoundTextures = {};
    const scissorParam = gl.getParameter(gl.SCISSOR_BOX);
    const viewportParam = gl.getParameter(gl.VIEWPORT);
    const currentScissor = new (0, _threeCoreJs.Vector4)().fromArray(scissorParam);
    const currentViewport = new (0, _threeCoreJs.Vector4)().fromArray(viewportParam);
    function createTexture(type, target, count, dimensions) {
        const data = new Uint8Array(4); // 4 is required to match default unpack alignment of 4.
        const texture = gl.createTexture();
        gl.bindTexture(type, texture);
        gl.texParameteri(type, gl.TEXTURE_MIN_FILTER, gl.NEAREST);
        gl.texParameteri(type, gl.TEXTURE_MAG_FILTER, gl.NEAREST);
        for(let i = 0; i < count; i++)if (type === gl.TEXTURE_3D || type === gl.TEXTURE_2D_ARRAY) gl.texImage3D(target, 0, gl.RGBA, 1, 1, dimensions, 0, gl.RGBA, gl.UNSIGNED_BYTE, data);
        else gl.texImage2D(target + i, 0, gl.RGBA, 1, 1, 0, gl.RGBA, gl.UNSIGNED_BYTE, data);
        return texture;
    }
    const emptyTextures = {};
    emptyTextures[gl.TEXTURE_2D] = createTexture(gl.TEXTURE_2D, gl.TEXTURE_2D, 1);
    emptyTextures[gl.TEXTURE_CUBE_MAP] = createTexture(gl.TEXTURE_CUBE_MAP, gl.TEXTURE_CUBE_MAP_POSITIVE_X, 6);
    emptyTextures[gl.TEXTURE_2D_ARRAY] = createTexture(gl.TEXTURE_2D_ARRAY, gl.TEXTURE_2D_ARRAY, 1, 1);
    emptyTextures[gl.TEXTURE_3D] = createTexture(gl.TEXTURE_3D, gl.TEXTURE_3D, 1, 1);
    // init
    colorBuffer.setClear(0, 0, 0, 1);
    depthBuffer.setClear(1);
    stencilBuffer.setClear(0);
    enable(gl.DEPTH_TEST);
    depthBuffer.setFunc((0, _threeCoreJs.LessEqualDepth));
    setFlipSided(false);
    setCullFace((0, _threeCoreJs.CullFaceBack));
    enable(gl.CULL_FACE);
    setBlending((0, _threeCoreJs.NoBlending));
    //
    function enable(id) {
        if (enabledCapabilities[id] !== true) {
            gl.enable(id);
            enabledCapabilities[id] = true;
        }
    }
    function disable(id) {
        if (enabledCapabilities[id] !== false) {
            gl.disable(id);
            enabledCapabilities[id] = false;
        }
    }
    function bindFramebuffer(target, framebuffer) {
        if (currentBoundFramebuffers[target] !== framebuffer) {
            gl.bindFramebuffer(target, framebuffer);
            currentBoundFramebuffers[target] = framebuffer;
            // gl.DRAW_FRAMEBUFFER is equivalent to gl.FRAMEBUFFER
            if (target === gl.DRAW_FRAMEBUFFER) currentBoundFramebuffers[gl.FRAMEBUFFER] = framebuffer;
            if (target === gl.FRAMEBUFFER) currentBoundFramebuffers[gl.DRAW_FRAMEBUFFER] = framebuffer;
            return true;
        }
        return false;
    }
    function drawBuffers(renderTarget, framebuffer) {
        let drawBuffers = defaultDrawbuffers;
        let needsUpdate = false;
        if (renderTarget) {
            drawBuffers = currentDrawbuffers.get(framebuffer);
            if (drawBuffers === undefined) {
                drawBuffers = [];
                currentDrawbuffers.set(framebuffer, drawBuffers);
            }
            const textures = renderTarget.textures;
            if (drawBuffers.length !== textures.length || drawBuffers[0] !== gl.COLOR_ATTACHMENT0) {
                for(let i = 0, il = textures.length; i < il; i++)drawBuffers[i] = gl.COLOR_ATTACHMENT0 + i;
                drawBuffers.length = textures.length;
                needsUpdate = true;
            }
        } else if (drawBuffers[0] !== gl.BACK) {
            drawBuffers[0] = gl.BACK;
            needsUpdate = true;
        }
        if (needsUpdate) gl.drawBuffers(drawBuffers);
    }
    function useProgram(program) {
        if (currentProgram !== program) {
            gl.useProgram(program);
            currentProgram = program;
            return true;
        }
        return false;
    }
    const equationToGL = {
        [(0, _threeCoreJs.AddEquation)]: gl.FUNC_ADD,
        [(0, _threeCoreJs.SubtractEquation)]: gl.FUNC_SUBTRACT,
        [(0, _threeCoreJs.ReverseSubtractEquation)]: gl.FUNC_REVERSE_SUBTRACT
    };
    equationToGL[0, _threeCoreJs.MinEquation] = gl.MIN;
    equationToGL[0, _threeCoreJs.MaxEquation] = gl.MAX;
    const factorToGL = {
        [(0, _threeCoreJs.ZeroFactor)]: gl.ZERO,
        [(0, _threeCoreJs.OneFactor)]: gl.ONE,
        [(0, _threeCoreJs.SrcColorFactor)]: gl.SRC_COLOR,
        [(0, _threeCoreJs.SrcAlphaFactor)]: gl.SRC_ALPHA,
        [(0, _threeCoreJs.SrcAlphaSaturateFactor)]: gl.SRC_ALPHA_SATURATE,
        [(0, _threeCoreJs.DstColorFactor)]: gl.DST_COLOR,
        [(0, _threeCoreJs.DstAlphaFactor)]: gl.DST_ALPHA,
        [(0, _threeCoreJs.OneMinusSrcColorFactor)]: gl.ONE_MINUS_SRC_COLOR,
        [(0, _threeCoreJs.OneMinusSrcAlphaFactor)]: gl.ONE_MINUS_SRC_ALPHA,
        [(0, _threeCoreJs.OneMinusDstColorFactor)]: gl.ONE_MINUS_DST_COLOR,
        [(0, _threeCoreJs.OneMinusDstAlphaFactor)]: gl.ONE_MINUS_DST_ALPHA,
        [(0, _threeCoreJs.ConstantColorFactor)]: gl.CONSTANT_COLOR,
        [(0, _threeCoreJs.OneMinusConstantColorFactor)]: gl.ONE_MINUS_CONSTANT_COLOR,
        [(0, _threeCoreJs.ConstantAlphaFactor)]: gl.CONSTANT_ALPHA,
        [(0, _threeCoreJs.OneMinusConstantAlphaFactor)]: gl.ONE_MINUS_CONSTANT_ALPHA
    };
    function setBlending(blending, blendEquation, blendSrc, blendDst, blendEquationAlpha, blendSrcAlpha, blendDstAlpha, blendColor, blendAlpha, premultipliedAlpha) {
        if (blending === (0, _threeCoreJs.NoBlending)) {
            if (currentBlendingEnabled === true) {
                disable(gl.BLEND);
                currentBlendingEnabled = false;
            }
            return;
        }
        if (currentBlendingEnabled === false) {
            enable(gl.BLEND);
            currentBlendingEnabled = true;
        }
        if (blending !== (0, _threeCoreJs.CustomBlending)) {
            if (blending !== currentBlending || premultipliedAlpha !== currentPremultipledAlpha) {
                if (currentBlendEquation !== (0, _threeCoreJs.AddEquation) || currentBlendEquationAlpha !== (0, _threeCoreJs.AddEquation)) {
                    gl.blendEquation(gl.FUNC_ADD);
                    currentBlendEquation = (0, _threeCoreJs.AddEquation);
                    currentBlendEquationAlpha = (0, _threeCoreJs.AddEquation);
                }
                if (premultipliedAlpha) switch(blending){
                    case 0, _threeCoreJs.NormalBlending:
                        gl.blendFuncSeparate(gl.ONE, gl.ONE_MINUS_SRC_ALPHA, gl.ONE, gl.ONE_MINUS_SRC_ALPHA);
                        break;
                    case 0, _threeCoreJs.AdditiveBlending:
                        gl.blendFunc(gl.ONE, gl.ONE);
                        break;
                    case 0, _threeCoreJs.SubtractiveBlending:
                        gl.blendFuncSeparate(gl.ZERO, gl.ONE_MINUS_SRC_COLOR, gl.ZERO, gl.ONE);
                        break;
                    case 0, _threeCoreJs.MultiplyBlending:
                        gl.blendFuncSeparate(gl.DST_COLOR, gl.ONE_MINUS_SRC_ALPHA, gl.ZERO, gl.ONE);
                        break;
                    default:
                        (0, _threeCoreJs.error)('WebGLState: Invalid blending: ', blending);
                        break;
                }
                else switch(blending){
                    case 0, _threeCoreJs.NormalBlending:
                        gl.blendFuncSeparate(gl.SRC_ALPHA, gl.ONE_MINUS_SRC_ALPHA, gl.ONE, gl.ONE_MINUS_SRC_ALPHA);
                        break;
                    case 0, _threeCoreJs.AdditiveBlending:
                        gl.blendFuncSeparate(gl.SRC_ALPHA, gl.ONE, gl.ONE, gl.ONE);
                        break;
                    case 0, _threeCoreJs.SubtractiveBlending:
                        (0, _threeCoreJs.error)('WebGLState: SubtractiveBlending requires material.premultipliedAlpha = true');
                        break;
                    case 0, _threeCoreJs.MultiplyBlending:
                        (0, _threeCoreJs.error)('WebGLState: MultiplyBlending requires material.premultipliedAlpha = true');
                        break;
                    default:
                        (0, _threeCoreJs.error)('WebGLState: Invalid blending: ', blending);
                        break;
                }
                currentBlendSrc = null;
                currentBlendDst = null;
                currentBlendSrcAlpha = null;
                currentBlendDstAlpha = null;
                currentBlendColor.set(0, 0, 0);
                currentBlendAlpha = 0;
                currentBlending = blending;
                currentPremultipledAlpha = premultipliedAlpha;
            }
            return;
        }
        // custom blending
        blendEquationAlpha = blendEquationAlpha || blendEquation;
        blendSrcAlpha = blendSrcAlpha || blendSrc;
        blendDstAlpha = blendDstAlpha || blendDst;
        if (blendEquation !== currentBlendEquation || blendEquationAlpha !== currentBlendEquationAlpha) {
            gl.blendEquationSeparate(equationToGL[blendEquation], equationToGL[blendEquationAlpha]);
            currentBlendEquation = blendEquation;
            currentBlendEquationAlpha = blendEquationAlpha;
        }
        if (blendSrc !== currentBlendSrc || blendDst !== currentBlendDst || blendSrcAlpha !== currentBlendSrcAlpha || blendDstAlpha !== currentBlendDstAlpha) {
            gl.blendFuncSeparate(factorToGL[blendSrc], factorToGL[blendDst], factorToGL[blendSrcAlpha], factorToGL[blendDstAlpha]);
            currentBlendSrc = blendSrc;
            currentBlendDst = blendDst;
            currentBlendSrcAlpha = blendSrcAlpha;
            currentBlendDstAlpha = blendDstAlpha;
        }
        if (blendColor.equals(currentBlendColor) === false || blendAlpha !== currentBlendAlpha) {
            gl.blendColor(blendColor.r, blendColor.g, blendColor.b, blendAlpha);
            currentBlendColor.copy(blendColor);
            currentBlendAlpha = blendAlpha;
        }
        currentBlending = blending;
        currentPremultipledAlpha = false;
    }
    function setMaterial(material, frontFaceCW) {
        material.side === (0, _threeCoreJs.DoubleSide) ? disable(gl.CULL_FACE) : enable(gl.CULL_FACE);
        let flipSided = material.side === (0, _threeCoreJs.BackSide);
        if (frontFaceCW) flipSided = !flipSided;
        setFlipSided(flipSided);
        material.blending === (0, _threeCoreJs.NormalBlending) && material.transparent === false ? setBlending((0, _threeCoreJs.NoBlending)) : setBlending(material.blending, material.blendEquation, material.blendSrc, material.blendDst, material.blendEquationAlpha, material.blendSrcAlpha, material.blendDstAlpha, material.blendColor, material.blendAlpha, material.premultipliedAlpha);
        depthBuffer.setFunc(material.depthFunc);
        depthBuffer.setTest(material.depthTest);
        depthBuffer.setMask(material.depthWrite);
        colorBuffer.setMask(material.colorWrite);
        const stencilWrite = material.stencilWrite;
        stencilBuffer.setTest(stencilWrite);
        if (stencilWrite) {
            stencilBuffer.setMask(material.stencilWriteMask);
            stencilBuffer.setFunc(material.stencilFunc, material.stencilRef, material.stencilFuncMask);
            stencilBuffer.setOp(material.stencilFail, material.stencilZFail, material.stencilZPass);
        }
        setPolygonOffset(material.polygonOffset, material.polygonOffsetFactor, material.polygonOffsetUnits);
        material.alphaToCoverage === true ? enable(gl.SAMPLE_ALPHA_TO_COVERAGE) : disable(gl.SAMPLE_ALPHA_TO_COVERAGE);
    }
    //
    function setFlipSided(flipSided) {
        if (currentFlipSided !== flipSided) {
            if (flipSided) gl.frontFace(gl.CW);
            else gl.frontFace(gl.CCW);
            currentFlipSided = flipSided;
        }
    }
    function setCullFace(cullFace) {
        if (cullFace !== (0, _threeCoreJs.CullFaceNone)) {
            enable(gl.CULL_FACE);
            if (cullFace !== currentCullFace) {
                if (cullFace === (0, _threeCoreJs.CullFaceBack)) gl.cullFace(gl.BACK);
                else if (cullFace === (0, _threeCoreJs.CullFaceFront)) gl.cullFace(gl.FRONT);
                else gl.cullFace(gl.FRONT_AND_BACK);
            }
        } else disable(gl.CULL_FACE);
        currentCullFace = cullFace;
    }
    function setLineWidth(width) {
        if (width !== currentLineWidth) {
            if (lineWidthAvailable) gl.lineWidth(width);
            currentLineWidth = width;
        }
    }
    function setPolygonOffset(polygonOffset, factor, units) {
        if (polygonOffset) {
            enable(gl.POLYGON_OFFSET_FILL);
            if (currentPolygonOffsetFactor !== factor || currentPolygonOffsetUnits !== units) {
                gl.polygonOffset(factor, units);
                currentPolygonOffsetFactor = factor;
                currentPolygonOffsetUnits = units;
            }
        } else disable(gl.POLYGON_OFFSET_FILL);
    }
    function setScissorTest(scissorTest) {
        if (scissorTest) enable(gl.SCISSOR_TEST);
        else disable(gl.SCISSOR_TEST);
    }
    // texture
    function activeTexture(webglSlot) {
        if (webglSlot === undefined) webglSlot = gl.TEXTURE0 + maxTextures - 1;
        if (currentTextureSlot !== webglSlot) {
            gl.activeTexture(webglSlot);
            currentTextureSlot = webglSlot;
        }
    }
    function bindTexture(webglType, webglTexture, webglSlot) {
        if (webglSlot === undefined) {
            if (currentTextureSlot === null) webglSlot = gl.TEXTURE0 + maxTextures - 1;
            else webglSlot = currentTextureSlot;
        }
        let boundTexture = currentBoundTextures[webglSlot];
        if (boundTexture === undefined) {
            boundTexture = {
                type: undefined,
                texture: undefined
            };
            currentBoundTextures[webglSlot] = boundTexture;
        }
        if (boundTexture.type !== webglType || boundTexture.texture !== webglTexture) {
            if (currentTextureSlot !== webglSlot) {
                gl.activeTexture(webglSlot);
                currentTextureSlot = webglSlot;
            }
            gl.bindTexture(webglType, webglTexture || emptyTextures[webglType]);
            boundTexture.type = webglType;
            boundTexture.texture = webglTexture;
        }
    }
    function unbindTexture() {
        const boundTexture = currentBoundTextures[currentTextureSlot];
        if (boundTexture !== undefined && boundTexture.type !== undefined) {
            gl.bindTexture(boundTexture.type, null);
            boundTexture.type = undefined;
            boundTexture.texture = undefined;
        }
    }
    function compressedTexImage2D() {
        try {
            gl.compressedTexImage2D(...arguments);
        } catch (e) {
            (0, _threeCoreJs.error)('WebGLState:', e);
        }
    }
    function compressedTexImage3D() {
        try {
            gl.compressedTexImage3D(...arguments);
        } catch (e) {
            (0, _threeCoreJs.error)('WebGLState:', e);
        }
    }
    function texSubImage2D() {
        try {
            gl.texSubImage2D(...arguments);
        } catch (e) {
            (0, _threeCoreJs.error)('WebGLState:', e);
        }
    }
    function texSubImage3D() {
        try {
            gl.texSubImage3D(...arguments);
        } catch (e) {
            (0, _threeCoreJs.error)('WebGLState:', e);
        }
    }
    function compressedTexSubImage2D() {
        try {
            gl.compressedTexSubImage2D(...arguments);
        } catch (e) {
            (0, _threeCoreJs.error)('WebGLState:', e);
        }
    }
    function compressedTexSubImage3D() {
        try {
            gl.compressedTexSubImage3D(...arguments);
        } catch (e) {
            (0, _threeCoreJs.error)('WebGLState:', e);
        }
    }
    function texStorage2D() {
        try {
            gl.texStorage2D(...arguments);
        } catch (e) {
            (0, _threeCoreJs.error)('WebGLState:', e);
        }
    }
    function texStorage3D() {
        try {
            gl.texStorage3D(...arguments);
        } catch (e) {
            (0, _threeCoreJs.error)('WebGLState:', e);
        }
    }
    function texImage2D() {
        try {
            gl.texImage2D(...arguments);
        } catch (e) {
            (0, _threeCoreJs.error)('WebGLState:', e);
        }
    }
    function texImage3D() {
        try {
            gl.texImage3D(...arguments);
        } catch (e) {
            (0, _threeCoreJs.error)('WebGLState:', e);
        }
    }
    //
    function scissor(scissor) {
        if (currentScissor.equals(scissor) === false) {
            gl.scissor(scissor.x, scissor.y, scissor.z, scissor.w);
            currentScissor.copy(scissor);
        }
    }
    function viewport(viewport) {
        if (currentViewport.equals(viewport) === false) {
            gl.viewport(viewport.x, viewport.y, viewport.z, viewport.w);
            currentViewport.copy(viewport);
        }
    }
    function updateUBOMapping(uniformsGroup, program) {
        let mapping = uboProgramMap.get(program);
        if (mapping === undefined) {
            mapping = new WeakMap();
            uboProgramMap.set(program, mapping);
        }
        let blockIndex = mapping.get(uniformsGroup);
        if (blockIndex === undefined) {
            blockIndex = gl.getUniformBlockIndex(program, uniformsGroup.name);
            mapping.set(uniformsGroup, blockIndex);
        }
    }
    function uniformBlockBinding(uniformsGroup, program) {
        const mapping = uboProgramMap.get(program);
        const blockIndex = mapping.get(uniformsGroup);
        if (uboBindings.get(program) !== blockIndex) {
            // bind shader specific block index to global block point
            gl.uniformBlockBinding(program, blockIndex, uniformsGroup.__bindingPointIndex);
            uboBindings.set(program, blockIndex);
        }
    }
    //
    function reset() {
        // reset state
        gl.disable(gl.BLEND);
        gl.disable(gl.CULL_FACE);
        gl.disable(gl.DEPTH_TEST);
        gl.disable(gl.POLYGON_OFFSET_FILL);
        gl.disable(gl.SCISSOR_TEST);
        gl.disable(gl.STENCIL_TEST);
        gl.disable(gl.SAMPLE_ALPHA_TO_COVERAGE);
        gl.blendEquation(gl.FUNC_ADD);
        gl.blendFunc(gl.ONE, gl.ZERO);
        gl.blendFuncSeparate(gl.ONE, gl.ZERO, gl.ONE, gl.ZERO);
        gl.blendColor(0, 0, 0, 0);
        gl.colorMask(true, true, true, true);
        gl.clearColor(0, 0, 0, 0);
        gl.depthMask(true);
        gl.depthFunc(gl.LESS);
        depthBuffer.setReversed(false);
        gl.clearDepth(1);
        gl.stencilMask(0xffffffff);
        gl.stencilFunc(gl.ALWAYS, 0, 0xffffffff);
        gl.stencilOp(gl.KEEP, gl.KEEP, gl.KEEP);
        gl.clearStencil(0);
        gl.cullFace(gl.BACK);
        gl.frontFace(gl.CCW);
        gl.polygonOffset(0, 0);
        gl.activeTexture(gl.TEXTURE0);
        gl.bindFramebuffer(gl.FRAMEBUFFER, null);
        gl.bindFramebuffer(gl.DRAW_FRAMEBUFFER, null);
        gl.bindFramebuffer(gl.READ_FRAMEBUFFER, null);
        gl.useProgram(null);
        gl.lineWidth(1);
        gl.scissor(0, 0, gl.canvas.width, gl.canvas.height);
        gl.viewport(0, 0, gl.canvas.width, gl.canvas.height);
        // reset internals
        enabledCapabilities = {};
        currentTextureSlot = null;
        currentBoundTextures = {};
        currentBoundFramebuffers = {};
        currentDrawbuffers = new WeakMap();
        defaultDrawbuffers = [];
        currentProgram = null;
        currentBlendingEnabled = false;
        currentBlending = null;
        currentBlendEquation = null;
        currentBlendSrc = null;
        currentBlendDst = null;
        currentBlendEquationAlpha = null;
        currentBlendSrcAlpha = null;
        currentBlendDstAlpha = null;
        currentBlendColor = new (0, _threeCoreJs.Color)(0, 0, 0);
        currentBlendAlpha = 0;
        currentPremultipledAlpha = false;
        currentFlipSided = null;
        currentCullFace = null;
        currentLineWidth = null;
        currentPolygonOffsetFactor = null;
        currentPolygonOffsetUnits = null;
        currentScissor.set(0, 0, gl.canvas.width, gl.canvas.height);
        currentViewport.set(0, 0, gl.canvas.width, gl.canvas.height);
        colorBuffer.reset();
        depthBuffer.reset();
        stencilBuffer.reset();
    }
    return {
        buffers: {
            color: colorBuffer,
            depth: depthBuffer,
            stencil: stencilBuffer
        },
        enable: enable,
        disable: disable,
        bindFramebuffer: bindFramebuffer,
        drawBuffers: drawBuffers,
        useProgram: useProgram,
        setBlending: setBlending,
        setMaterial: setMaterial,
        setFlipSided: setFlipSided,
        setCullFace: setCullFace,
        setLineWidth: setLineWidth,
        setPolygonOffset: setPolygonOffset,
        setScissorTest: setScissorTest,
        activeTexture: activeTexture,
        bindTexture: bindTexture,
        unbindTexture: unbindTexture,
        compressedTexImage2D: compressedTexImage2D,
        compressedTexImage3D: compressedTexImage3D,
        texImage2D: texImage2D,
        texImage3D: texImage3D,
        updateUBOMapping: updateUBOMapping,
        uniformBlockBinding: uniformBlockBinding,
        texStorage2D: texStorage2D,
        texStorage3D: texStorage3D,
        texSubImage2D: texSubImage2D,
        texSubImage3D: texSubImage3D,
        compressedTexSubImage2D: compressedTexSubImage2D,
        compressedTexSubImage3D: compressedTexSubImage3D,
        scissor: scissor,
        viewport: viewport,
        reset: reset
    };
}
function WebGLTextures(_gl, extensions, state, properties, capabilities, utils, info) {
    const multisampledRTTExt = extensions.has('WEBGL_multisampled_render_to_texture') ? extensions.get('WEBGL_multisampled_render_to_texture') : null;
    const supportsInvalidateFramebuffer = typeof navigator === 'undefined' ? false : /OculusBrowser/g.test(navigator.userAgent);
    const _imageDimensions = new (0, _threeCoreJs.Vector2)();
    const _videoTextures = new WeakMap();
    let _canvas;
    const _sources = new WeakMap(); // maps WebglTexture objects to instances of Source
    // cordova iOS (as of 5.0) still uses UIWebView, which provides OffscreenCanvas,
    // also OffscreenCanvas.getContext("webgl"), but not OffscreenCanvas.getContext("2d")!
    // Some implementations may only implement OffscreenCanvas partially (e.g. lacking 2d).
    let useOffscreenCanvas = false;
    try {
        useOffscreenCanvas = typeof OffscreenCanvas !== 'undefined' && new OffscreenCanvas(1, 1).getContext('2d') !== null;
    } catch (err) {
    // Ignore any errors
    }
    function createCanvas(width, height) {
        // Use OffscreenCanvas when available. Specially needed in web workers
        return useOffscreenCanvas ? new OffscreenCanvas(width, height) : (0, _threeCoreJs.createElementNS)('canvas');
    }
    function resizeImage(image, needsNewCanvas, maxSize) {
        let scale = 1;
        const dimensions = getDimensions(image);
        // handle case if texture exceeds max size
        if (dimensions.width > maxSize || dimensions.height > maxSize) scale = maxSize / Math.max(dimensions.width, dimensions.height);
        // only perform resize if necessary
        if (scale < 1) {
            // only perform resize for certain image types
            if (typeof HTMLImageElement !== 'undefined' && image instanceof HTMLImageElement || typeof HTMLCanvasElement !== 'undefined' && image instanceof HTMLCanvasElement || typeof ImageBitmap !== 'undefined' && image instanceof ImageBitmap || typeof VideoFrame !== 'undefined' && image instanceof VideoFrame) {
                const width = Math.floor(scale * dimensions.width);
                const height = Math.floor(scale * dimensions.height);
                if (_canvas === undefined) _canvas = createCanvas(width, height);
                // cube textures can't reuse the same canvas
                const canvas = needsNewCanvas ? createCanvas(width, height) : _canvas;
                canvas.width = width;
                canvas.height = height;
                const context = canvas.getContext('2d');
                context.drawImage(image, 0, 0, width, height);
                (0, _threeCoreJs.warn)('WebGLRenderer: Texture has been resized from (' + dimensions.width + 'x' + dimensions.height + ') to (' + width + 'x' + height + ').');
                return canvas;
            } else {
                if ('data' in image) (0, _threeCoreJs.warn)('WebGLRenderer: Image in DataTexture is too big (' + dimensions.width + 'x' + dimensions.height + ').');
                return image;
            }
        }
        return image;
    }
    function textureNeedsGenerateMipmaps(texture) {
        return texture.generateMipmaps;
    }
    function generateMipmap(target) {
        _gl.generateMipmap(target);
    }
    function getTargetType(texture) {
        if (texture.isWebGLCubeRenderTarget) return _gl.TEXTURE_CUBE_MAP;
        if (texture.isWebGL3DRenderTarget) return _gl.TEXTURE_3D;
        if (texture.isWebGLArrayRenderTarget || texture.isCompressedArrayTexture) return _gl.TEXTURE_2D_ARRAY;
        return _gl.TEXTURE_2D;
    }
    function getInternalFormat(internalFormatName, glFormat, glType, colorSpace, forceLinearTransfer = false) {
        if (internalFormatName !== null) {
            if (_gl[internalFormatName] !== undefined) return _gl[internalFormatName];
            (0, _threeCoreJs.warn)('WebGLRenderer: Attempt to use non-existing WebGL internal format \'' + internalFormatName + '\'');
        }
        let internalFormat = glFormat;
        if (glFormat === _gl.RED) {
            if (glType === _gl.FLOAT) internalFormat = _gl.R32F;
            if (glType === _gl.HALF_FLOAT) internalFormat = _gl.R16F;
            if (glType === _gl.UNSIGNED_BYTE) internalFormat = _gl.R8;
        }
        if (glFormat === _gl.RED_INTEGER) {
            if (glType === _gl.UNSIGNED_BYTE) internalFormat = _gl.R8UI;
            if (glType === _gl.UNSIGNED_SHORT) internalFormat = _gl.R16UI;
            if (glType === _gl.UNSIGNED_INT) internalFormat = _gl.R32UI;
            if (glType === _gl.BYTE) internalFormat = _gl.R8I;
            if (glType === _gl.SHORT) internalFormat = _gl.R16I;
            if (glType === _gl.INT) internalFormat = _gl.R32I;
        }
        if (glFormat === _gl.RG) {
            if (glType === _gl.FLOAT) internalFormat = _gl.RG32F;
            if (glType === _gl.HALF_FLOAT) internalFormat = _gl.RG16F;
            if (glType === _gl.UNSIGNED_BYTE) internalFormat = _gl.RG8;
        }
        if (glFormat === _gl.RG_INTEGER) {
            if (glType === _gl.UNSIGNED_BYTE) internalFormat = _gl.RG8UI;
            if (glType === _gl.UNSIGNED_SHORT) internalFormat = _gl.RG16UI;
            if (glType === _gl.UNSIGNED_INT) internalFormat = _gl.RG32UI;
            if (glType === _gl.BYTE) internalFormat = _gl.RG8I;
            if (glType === _gl.SHORT) internalFormat = _gl.RG16I;
            if (glType === _gl.INT) internalFormat = _gl.RG32I;
        }
        if (glFormat === _gl.RGB_INTEGER) {
            if (glType === _gl.UNSIGNED_BYTE) internalFormat = _gl.RGB8UI;
            if (glType === _gl.UNSIGNED_SHORT) internalFormat = _gl.RGB16UI;
            if (glType === _gl.UNSIGNED_INT) internalFormat = _gl.RGB32UI;
            if (glType === _gl.BYTE) internalFormat = _gl.RGB8I;
            if (glType === _gl.SHORT) internalFormat = _gl.RGB16I;
            if (glType === _gl.INT) internalFormat = _gl.RGB32I;
        }
        if (glFormat === _gl.RGBA_INTEGER) {
            if (glType === _gl.UNSIGNED_BYTE) internalFormat = _gl.RGBA8UI;
            if (glType === _gl.UNSIGNED_SHORT) internalFormat = _gl.RGBA16UI;
            if (glType === _gl.UNSIGNED_INT) internalFormat = _gl.RGBA32UI;
            if (glType === _gl.BYTE) internalFormat = _gl.RGBA8I;
            if (glType === _gl.SHORT) internalFormat = _gl.RGBA16I;
            if (glType === _gl.INT) internalFormat = _gl.RGBA32I;
        }
        if (glFormat === _gl.RGB) {
            if (glType === _gl.UNSIGNED_INT_5_9_9_9_REV) internalFormat = _gl.RGB9_E5;
            if (glType === _gl.UNSIGNED_INT_10F_11F_11F_REV) internalFormat = _gl.R11F_G11F_B10F;
        }
        if (glFormat === _gl.RGBA) {
            const transfer = forceLinearTransfer ? (0, _threeCoreJs.LinearTransfer) : (0, _threeCoreJs.ColorManagement).getTransfer(colorSpace);
            if (glType === _gl.FLOAT) internalFormat = _gl.RGBA32F;
            if (glType === _gl.HALF_FLOAT) internalFormat = _gl.RGBA16F;
            if (glType === _gl.UNSIGNED_BYTE) internalFormat = transfer === (0, _threeCoreJs.SRGBTransfer) ? _gl.SRGB8_ALPHA8 : _gl.RGBA8;
            if (glType === _gl.UNSIGNED_SHORT_4_4_4_4) internalFormat = _gl.RGBA4;
            if (glType === _gl.UNSIGNED_SHORT_5_5_5_1) internalFormat = _gl.RGB5_A1;
        }
        if (internalFormat === _gl.R16F || internalFormat === _gl.R32F || internalFormat === _gl.RG16F || internalFormat === _gl.RG32F || internalFormat === _gl.RGBA16F || internalFormat === _gl.RGBA32F) extensions.get('EXT_color_buffer_float');
        return internalFormat;
    }
    function getInternalDepthFormat(useStencil, depthType) {
        let glInternalFormat;
        if (useStencil) {
            if (depthType === null || depthType === (0, _threeCoreJs.UnsignedIntType) || depthType === (0, _threeCoreJs.UnsignedInt248Type)) glInternalFormat = _gl.DEPTH24_STENCIL8;
            else if (depthType === (0, _threeCoreJs.FloatType)) glInternalFormat = _gl.DEPTH32F_STENCIL8;
            else if (depthType === (0, _threeCoreJs.UnsignedShortType)) {
                glInternalFormat = _gl.DEPTH24_STENCIL8;
                (0, _threeCoreJs.warn)('DepthTexture: 16 bit depth attachment is not supported with stencil. Using 24-bit attachment.');
            }
        } else {
            if (depthType === null || depthType === (0, _threeCoreJs.UnsignedIntType) || depthType === (0, _threeCoreJs.UnsignedInt248Type)) glInternalFormat = _gl.DEPTH_COMPONENT24;
            else if (depthType === (0, _threeCoreJs.FloatType)) glInternalFormat = _gl.DEPTH_COMPONENT32F;
            else if (depthType === (0, _threeCoreJs.UnsignedShortType)) glInternalFormat = _gl.DEPTH_COMPONENT16;
        }
        return glInternalFormat;
    }
    function getMipLevels(texture, image) {
        if (textureNeedsGenerateMipmaps(texture) === true || texture.isFramebufferTexture && texture.minFilter !== (0, _threeCoreJs.NearestFilter) && texture.minFilter !== (0, _threeCoreJs.LinearFilter)) return Math.log2(Math.max(image.width, image.height)) + 1;
        else if (texture.mipmaps !== undefined && texture.mipmaps.length > 0) // user-defined mipmaps
        return texture.mipmaps.length;
        else if (texture.isCompressedTexture && Array.isArray(texture.image)) return image.mipmaps.length;
        else // texture without mipmaps (only base level)
        return 1;
    }
    //
    function onTextureDispose(event) {
        const texture = event.target;
        texture.removeEventListener('dispose', onTextureDispose);
        deallocateTexture(texture);
        if (texture.isVideoTexture) _videoTextures.delete(texture);
    }
    function onRenderTargetDispose(event) {
        const renderTarget = event.target;
        renderTarget.removeEventListener('dispose', onRenderTargetDispose);
        deallocateRenderTarget(renderTarget);
    }
    //
    function deallocateTexture(texture) {
        const textureProperties = properties.get(texture);
        if (textureProperties.__webglInit === undefined) return;
        // check if it's necessary to remove the WebGLTexture object
        const source = texture.source;
        const webglTextures = _sources.get(source);
        if (webglTextures) {
            const webglTexture = webglTextures[textureProperties.__cacheKey];
            webglTexture.usedTimes--;
            // the WebGLTexture object is not used anymore, remove it
            if (webglTexture.usedTimes === 0) deleteTexture(texture);
            // remove the weak map entry if no WebGLTexture uses the source anymore
            if (Object.keys(webglTextures).length === 0) _sources.delete(source);
        }
        properties.remove(texture);
    }
    function deleteTexture(texture) {
        const textureProperties = properties.get(texture);
        _gl.deleteTexture(textureProperties.__webglTexture);
        const source = texture.source;
        const webglTextures = _sources.get(source);
        delete webglTextures[textureProperties.__cacheKey];
        info.memory.textures--;
    }
    function deallocateRenderTarget(renderTarget) {
        const renderTargetProperties = properties.get(renderTarget);
        if (renderTarget.depthTexture) {
            renderTarget.depthTexture.dispose();
            properties.remove(renderTarget.depthTexture);
        }
        if (renderTarget.isWebGLCubeRenderTarget) for(let i = 0; i < 6; i++){
            if (Array.isArray(renderTargetProperties.__webglFramebuffer[i])) for(let level = 0; level < renderTargetProperties.__webglFramebuffer[i].length; level++)_gl.deleteFramebuffer(renderTargetProperties.__webglFramebuffer[i][level]);
            else _gl.deleteFramebuffer(renderTargetProperties.__webglFramebuffer[i]);
            if (renderTargetProperties.__webglDepthbuffer) _gl.deleteRenderbuffer(renderTargetProperties.__webglDepthbuffer[i]);
        }
        else {
            if (Array.isArray(renderTargetProperties.__webglFramebuffer)) for(let level = 0; level < renderTargetProperties.__webglFramebuffer.length; level++)_gl.deleteFramebuffer(renderTargetProperties.__webglFramebuffer[level]);
            else _gl.deleteFramebuffer(renderTargetProperties.__webglFramebuffer);
            if (renderTargetProperties.__webglDepthbuffer) _gl.deleteRenderbuffer(renderTargetProperties.__webglDepthbuffer);
            if (renderTargetProperties.__webglMultisampledFramebuffer) _gl.deleteFramebuffer(renderTargetProperties.__webglMultisampledFramebuffer);
            if (renderTargetProperties.__webglColorRenderbuffer) {
                for(let i = 0; i < renderTargetProperties.__webglColorRenderbuffer.length; i++)if (renderTargetProperties.__webglColorRenderbuffer[i]) _gl.deleteRenderbuffer(renderTargetProperties.__webglColorRenderbuffer[i]);
            }
            if (renderTargetProperties.__webglDepthRenderbuffer) _gl.deleteRenderbuffer(renderTargetProperties.__webglDepthRenderbuffer);
        }
        const textures = renderTarget.textures;
        for(let i = 0, il = textures.length; i < il; i++){
            const attachmentProperties = properties.get(textures[i]);
            if (attachmentProperties.__webglTexture) {
                _gl.deleteTexture(attachmentProperties.__webglTexture);
                info.memory.textures--;
            }
            properties.remove(textures[i]);
        }
        properties.remove(renderTarget);
    }
    //
    let textureUnits = 0;
    function resetTextureUnits() {
        textureUnits = 0;
    }
    function allocateTextureUnit() {
        const textureUnit = textureUnits;
        if (textureUnit >= capabilities.maxTextures) (0, _threeCoreJs.warn)('WebGLTextures: Trying to use ' + textureUnit + ' texture units while this GPU supports only ' + capabilities.maxTextures);
        textureUnits += 1;
        return textureUnit;
    }
    function getTextureCacheKey(texture) {
        const array = [];
        array.push(texture.wrapS);
        array.push(texture.wrapT);
        array.push(texture.wrapR || 0);
        array.push(texture.magFilter);
        array.push(texture.minFilter);
        array.push(texture.anisotropy);
        array.push(texture.internalFormat);
        array.push(texture.format);
        array.push(texture.type);
        array.push(texture.generateMipmaps);
        array.push(texture.premultiplyAlpha);
        array.push(texture.flipY);
        array.push(texture.unpackAlignment);
        array.push(texture.colorSpace);
        return array.join();
    }
    //
    function setTexture2D(texture, slot) {
        const textureProperties = properties.get(texture);
        if (texture.isVideoTexture) updateVideoTexture(texture);
        if (texture.isRenderTargetTexture === false && texture.isExternalTexture !== true && texture.version > 0 && textureProperties.__version !== texture.version) {
            const image = texture.image;
            if (image === null) (0, _threeCoreJs.warn)('WebGLRenderer: Texture marked for update but no image data found.');
            else if (image.complete === false) (0, _threeCoreJs.warn)('WebGLRenderer: Texture marked for update but image is incomplete');
            else {
                uploadTexture(textureProperties, texture, slot);
                return;
            }
        } else if (texture.isExternalTexture) textureProperties.__webglTexture = texture.sourceTexture ? texture.sourceTexture : null;
        state.bindTexture(_gl.TEXTURE_2D, textureProperties.__webglTexture, _gl.TEXTURE0 + slot);
    }
    function setTexture2DArray(texture, slot) {
        const textureProperties = properties.get(texture);
        if (texture.isRenderTargetTexture === false && texture.version > 0 && textureProperties.__version !== texture.version) {
            uploadTexture(textureProperties, texture, slot);
            return;
        } else if (texture.isExternalTexture) textureProperties.__webglTexture = texture.sourceTexture ? texture.sourceTexture : null;
        state.bindTexture(_gl.TEXTURE_2D_ARRAY, textureProperties.__webglTexture, _gl.TEXTURE0 + slot);
    }
    function setTexture3D(texture, slot) {
        const textureProperties = properties.get(texture);
        if (texture.isRenderTargetTexture === false && texture.version > 0 && textureProperties.__version !== texture.version) {
            uploadTexture(textureProperties, texture, slot);
            return;
        }
        state.bindTexture(_gl.TEXTURE_3D, textureProperties.__webglTexture, _gl.TEXTURE0 + slot);
    }
    function setTextureCube(texture, slot) {
        const textureProperties = properties.get(texture);
        if (texture.isCubeDepthTexture !== true && texture.version > 0 && textureProperties.__version !== texture.version) {
            uploadCubeTexture(textureProperties, texture, slot);
            return;
        }
        state.bindTexture(_gl.TEXTURE_CUBE_MAP, textureProperties.__webglTexture, _gl.TEXTURE0 + slot);
    }
    const wrappingToGL = {
        [(0, _threeCoreJs.RepeatWrapping)]: _gl.REPEAT,
        [(0, _threeCoreJs.ClampToEdgeWrapping)]: _gl.CLAMP_TO_EDGE,
        [(0, _threeCoreJs.MirroredRepeatWrapping)]: _gl.MIRRORED_REPEAT
    };
    const filterToGL = {
        [(0, _threeCoreJs.NearestFilter)]: _gl.NEAREST,
        [(0, _threeCoreJs.NearestMipmapNearestFilter)]: _gl.NEAREST_MIPMAP_NEAREST,
        [(0, _threeCoreJs.NearestMipmapLinearFilter)]: _gl.NEAREST_MIPMAP_LINEAR,
        [(0, _threeCoreJs.LinearFilter)]: _gl.LINEAR,
        [(0, _threeCoreJs.LinearMipmapNearestFilter)]: _gl.LINEAR_MIPMAP_NEAREST,
        [(0, _threeCoreJs.LinearMipmapLinearFilter)]: _gl.LINEAR_MIPMAP_LINEAR
    };
    const compareToGL = {
        [(0, _threeCoreJs.NeverCompare)]: _gl.NEVER,
        [(0, _threeCoreJs.AlwaysCompare)]: _gl.ALWAYS,
        [(0, _threeCoreJs.LessCompare)]: _gl.LESS,
        [(0, _threeCoreJs.LessEqualCompare)]: _gl.LEQUAL,
        [(0, _threeCoreJs.EqualCompare)]: _gl.EQUAL,
        [(0, _threeCoreJs.GreaterEqualCompare)]: _gl.GEQUAL,
        [(0, _threeCoreJs.GreaterCompare)]: _gl.GREATER,
        [(0, _threeCoreJs.NotEqualCompare)]: _gl.NOTEQUAL
    };
    function setTextureParameters(textureType, texture) {
        if (texture.type === (0, _threeCoreJs.FloatType) && extensions.has('OES_texture_float_linear') === false && (texture.magFilter === (0, _threeCoreJs.LinearFilter) || texture.magFilter === (0, _threeCoreJs.LinearMipmapNearestFilter) || texture.magFilter === (0, _threeCoreJs.NearestMipmapLinearFilter) || texture.magFilter === (0, _threeCoreJs.LinearMipmapLinearFilter) || texture.minFilter === (0, _threeCoreJs.LinearFilter) || texture.minFilter === (0, _threeCoreJs.LinearMipmapNearestFilter) || texture.minFilter === (0, _threeCoreJs.NearestMipmapLinearFilter) || texture.minFilter === (0, _threeCoreJs.LinearMipmapLinearFilter))) (0, _threeCoreJs.warn)('WebGLRenderer: Unable to use linear filtering with floating point textures. OES_texture_float_linear not supported on this device.');
        _gl.texParameteri(textureType, _gl.TEXTURE_WRAP_S, wrappingToGL[texture.wrapS]);
        _gl.texParameteri(textureType, _gl.TEXTURE_WRAP_T, wrappingToGL[texture.wrapT]);
        if (textureType === _gl.TEXTURE_3D || textureType === _gl.TEXTURE_2D_ARRAY) _gl.texParameteri(textureType, _gl.TEXTURE_WRAP_R, wrappingToGL[texture.wrapR]);
        _gl.texParameteri(textureType, _gl.TEXTURE_MAG_FILTER, filterToGL[texture.magFilter]);
        _gl.texParameteri(textureType, _gl.TEXTURE_MIN_FILTER, filterToGL[texture.minFilter]);
        if (texture.compareFunction) {
            _gl.texParameteri(textureType, _gl.TEXTURE_COMPARE_MODE, _gl.COMPARE_REF_TO_TEXTURE);
            _gl.texParameteri(textureType, _gl.TEXTURE_COMPARE_FUNC, compareToGL[texture.compareFunction]);
        }
        if (extensions.has('EXT_texture_filter_anisotropic') === true) {
            if (texture.magFilter === (0, _threeCoreJs.NearestFilter)) return;
            if (texture.minFilter !== (0, _threeCoreJs.NearestMipmapLinearFilter) && texture.minFilter !== (0, _threeCoreJs.LinearMipmapLinearFilter)) return;
            if (texture.type === (0, _threeCoreJs.FloatType) && extensions.has('OES_texture_float_linear') === false) return; // verify extension
            if (texture.anisotropy > 1 || properties.get(texture).__currentAnisotropy) {
                const extension = extensions.get('EXT_texture_filter_anisotropic');
                _gl.texParameterf(textureType, extension.TEXTURE_MAX_ANISOTROPY_EXT, Math.min(texture.anisotropy, capabilities.getMaxAnisotropy()));
                properties.get(texture).__currentAnisotropy = texture.anisotropy;
            }
        }
    }
    function initTexture(textureProperties, texture) {
        let forceUpload = false;
        if (textureProperties.__webglInit === undefined) {
            textureProperties.__webglInit = true;
            texture.addEventListener('dispose', onTextureDispose);
        }
        // create Source <-> WebGLTextures mapping if necessary
        const source = texture.source;
        let webglTextures = _sources.get(source);
        if (webglTextures === undefined) {
            webglTextures = {};
            _sources.set(source, webglTextures);
        }
        // check if there is already a WebGLTexture object for the given texture parameters
        const textureCacheKey = getTextureCacheKey(texture);
        if (textureCacheKey !== textureProperties.__cacheKey) {
            // if not, create a new instance of WebGLTexture
            if (webglTextures[textureCacheKey] === undefined) {
                // create new entry
                webglTextures[textureCacheKey] = {
                    texture: _gl.createTexture(),
                    usedTimes: 0
                };
                info.memory.textures++;
                // when a new instance of WebGLTexture was created, a texture upload is required
                // even if the image contents are identical
                forceUpload = true;
            }
            webglTextures[textureCacheKey].usedTimes++;
            // every time the texture cache key changes, it's necessary to check if an instance of
            // WebGLTexture can be deleted in order to avoid a memory leak.
            const webglTexture = webglTextures[textureProperties.__cacheKey];
            if (webglTexture !== undefined) {
                webglTextures[textureProperties.__cacheKey].usedTimes--;
                if (webglTexture.usedTimes === 0) deleteTexture(texture);
            }
            // store references to cache key and WebGLTexture object
            textureProperties.__cacheKey = textureCacheKey;
            textureProperties.__webglTexture = webglTextures[textureCacheKey].texture;
        }
        return forceUpload;
    }
    function getRow(index, rowLength, componentStride) {
        return Math.floor(Math.floor(index / componentStride) / rowLength);
    }
    function updateTexture(texture, image, glFormat, glType) {
        const componentStride = 4; // only RGBA supported
        const updateRanges = texture.updateRanges;
        if (updateRanges.length === 0) state.texSubImage2D(_gl.TEXTURE_2D, 0, 0, 0, image.width, image.height, glFormat, glType, image.data);
        else {
            // Before applying update ranges, we merge any adjacent / overlapping
            // ranges to reduce load on `gl.texSubImage2D`. Empirically, this has led
            // to performance improvements for applications which make heavy use of
            // update ranges. Likely due to GPU command overhead.
            //
            // Note that to reduce garbage collection between frames, we merge the
            // update ranges in-place. This is safe because this method will clear the
            // update ranges once updated.
            updateRanges.sort((a, b)=>a.start - b.start);
            // To merge the update ranges in-place, we work from left to right in the
            // existing updateRanges array, merging ranges. This may result in a final
            // array which is smaller than the original. This index tracks the last
            // index representing a merged range, any data after this index can be
            // trimmed once the merge algorithm is completed.
            let mergeIndex = 0;
            for(let i = 1; i < updateRanges.length; i++){
                const previousRange = updateRanges[mergeIndex];
                const range = updateRanges[i];
                // Only merge if in the same row and overlapping/adjacent
                const previousEnd = previousRange.start + previousRange.count;
                const currentRow = getRow(range.start, image.width, componentStride);
                const previousRow = getRow(previousRange.start, image.width, componentStride);
                // We add one here to merge adjacent ranges. This is safe because ranges
                // operate over positive integers.
                if (range.start <= previousEnd + 1 && currentRow === previousRow && getRow(range.start + range.count - 1, image.width, componentStride) === currentRow // ensure range doesn't spill
                ) previousRange.count = Math.max(previousRange.count, range.start + range.count - previousRange.start);
                else {
                    ++mergeIndex;
                    updateRanges[mergeIndex] = range;
                }
            }
            // Trim the array to only contain the merged ranges.
            updateRanges.length = mergeIndex + 1;
            const currentUnpackRowLen = _gl.getParameter(_gl.UNPACK_ROW_LENGTH);
            const currentUnpackSkipPixels = _gl.getParameter(_gl.UNPACK_SKIP_PIXELS);
            const currentUnpackSkipRows = _gl.getParameter(_gl.UNPACK_SKIP_ROWS);
            _gl.pixelStorei(_gl.UNPACK_ROW_LENGTH, image.width);
            for(let i = 0, l = updateRanges.length; i < l; i++){
                const range = updateRanges[i];
                const pixelStart = Math.floor(range.start / componentStride);
                const pixelCount = Math.ceil(range.count / componentStride);
                const x = pixelStart % image.width;
                const y = Math.floor(pixelStart / image.width);
                // Assumes update ranges refer to contiguous memory
                const width = pixelCount;
                const height = 1;
                _gl.pixelStorei(_gl.UNPACK_SKIP_PIXELS, x);
                _gl.pixelStorei(_gl.UNPACK_SKIP_ROWS, y);
                state.texSubImage2D(_gl.TEXTURE_2D, 0, x, y, width, height, glFormat, glType, image.data);
            }
            texture.clearUpdateRanges();
            _gl.pixelStorei(_gl.UNPACK_ROW_LENGTH, currentUnpackRowLen);
            _gl.pixelStorei(_gl.UNPACK_SKIP_PIXELS, currentUnpackSkipPixels);
            _gl.pixelStorei(_gl.UNPACK_SKIP_ROWS, currentUnpackSkipRows);
        }
    }
    function uploadTexture(textureProperties, texture, slot) {
        let textureType = _gl.TEXTURE_2D;
        if (texture.isDataArrayTexture || texture.isCompressedArrayTexture) textureType = _gl.TEXTURE_2D_ARRAY;
        if (texture.isData3DTexture) textureType = _gl.TEXTURE_3D;
        const forceUpload = initTexture(textureProperties, texture);
        const source = texture.source;
        state.bindTexture(textureType, textureProperties.__webglTexture, _gl.TEXTURE0 + slot);
        const sourceProperties = properties.get(source);
        if (source.version !== sourceProperties.__version || forceUpload === true) {
            state.activeTexture(_gl.TEXTURE0 + slot);
            const workingPrimaries = (0, _threeCoreJs.ColorManagement).getPrimaries((0, _threeCoreJs.ColorManagement).workingColorSpace);
            const texturePrimaries = texture.colorSpace === (0, _threeCoreJs.NoColorSpace) ? null : (0, _threeCoreJs.ColorManagement).getPrimaries(texture.colorSpace);
            const unpackConversion = texture.colorSpace === (0, _threeCoreJs.NoColorSpace) || workingPrimaries === texturePrimaries ? _gl.NONE : _gl.BROWSER_DEFAULT_WEBGL;
            _gl.pixelStorei(_gl.UNPACK_FLIP_Y_WEBGL, texture.flipY);
            _gl.pixelStorei(_gl.UNPACK_PREMULTIPLY_ALPHA_WEBGL, texture.premultiplyAlpha);
            _gl.pixelStorei(_gl.UNPACK_ALIGNMENT, texture.unpackAlignment);
            _gl.pixelStorei(_gl.UNPACK_COLORSPACE_CONVERSION_WEBGL, unpackConversion);
            let image = resizeImage(texture.image, false, capabilities.maxTextureSize);
            image = verifyColorSpace(texture, image);
            const glFormat = utils.convert(texture.format, texture.colorSpace);
            const glType = utils.convert(texture.type);
            let glInternalFormat = getInternalFormat(texture.internalFormat, glFormat, glType, texture.colorSpace, texture.isVideoTexture);
            setTextureParameters(textureType, texture);
            let mipmap;
            const mipmaps = texture.mipmaps;
            const useTexStorage = texture.isVideoTexture !== true;
            const allocateMemory = sourceProperties.__version === undefined || forceUpload === true;
            const dataReady = source.dataReady;
            const levels = getMipLevels(texture, image);
            if (texture.isDepthTexture) {
                glInternalFormat = getInternalDepthFormat(texture.format === (0, _threeCoreJs.DepthStencilFormat), texture.type);
                //
                if (allocateMemory) {
                    if (useTexStorage) state.texStorage2D(_gl.TEXTURE_2D, 1, glInternalFormat, image.width, image.height);
                    else state.texImage2D(_gl.TEXTURE_2D, 0, glInternalFormat, image.width, image.height, 0, glFormat, glType, null);
                }
            } else if (texture.isDataTexture) {
                // use manually created mipmaps if available
                // if there are no manual mipmaps
                // set 0 level mipmap and then use GL to generate other mipmap levels
                if (mipmaps.length > 0) {
                    if (useTexStorage && allocateMemory) state.texStorage2D(_gl.TEXTURE_2D, levels, glInternalFormat, mipmaps[0].width, mipmaps[0].height);
                    for(let i = 0, il = mipmaps.length; i < il; i++){
                        mipmap = mipmaps[i];
                        if (useTexStorage) {
                            if (dataReady) state.texSubImage2D(_gl.TEXTURE_2D, i, 0, 0, mipmap.width, mipmap.height, glFormat, glType, mipmap.data);
                        } else state.texImage2D(_gl.TEXTURE_2D, i, glInternalFormat, mipmap.width, mipmap.height, 0, glFormat, glType, mipmap.data);
                    }
                    texture.generateMipmaps = false;
                } else if (useTexStorage) {
                    if (allocateMemory) state.texStorage2D(_gl.TEXTURE_2D, levels, glInternalFormat, image.width, image.height);
                    if (dataReady) updateTexture(texture, image, glFormat, glType);
                } else state.texImage2D(_gl.TEXTURE_2D, 0, glInternalFormat, image.width, image.height, 0, glFormat, glType, image.data);
            } else if (texture.isCompressedTexture) {
                if (texture.isCompressedArrayTexture) {
                    if (useTexStorage && allocateMemory) state.texStorage3D(_gl.TEXTURE_2D_ARRAY, levels, glInternalFormat, mipmaps[0].width, mipmaps[0].height, image.depth);
                    for(let i = 0, il = mipmaps.length; i < il; i++){
                        mipmap = mipmaps[i];
                        if (texture.format !== (0, _threeCoreJs.RGBAFormat)) {
                            if (glFormat !== null) {
                                if (useTexStorage) {
                                    if (dataReady) {
                                        if (texture.layerUpdates.size > 0) {
                                            const layerByteLength = (0, _threeCoreJs.getByteLength)(mipmap.width, mipmap.height, texture.format, texture.type);
                                            for (const layerIndex of texture.layerUpdates){
                                                const layerData = mipmap.data.subarray(layerIndex * layerByteLength / mipmap.data.BYTES_PER_ELEMENT, (layerIndex + 1) * layerByteLength / mipmap.data.BYTES_PER_ELEMENT);
                                                state.compressedTexSubImage3D(_gl.TEXTURE_2D_ARRAY, i, 0, 0, layerIndex, mipmap.width, mipmap.height, 1, glFormat, layerData);
                                            }
                                            texture.clearLayerUpdates();
                                        } else state.compressedTexSubImage3D(_gl.TEXTURE_2D_ARRAY, i, 0, 0, 0, mipmap.width, mipmap.height, image.depth, glFormat, mipmap.data);
                                    }
                                } else state.compressedTexImage3D(_gl.TEXTURE_2D_ARRAY, i, glInternalFormat, mipmap.width, mipmap.height, image.depth, 0, mipmap.data, 0, 0);
                            } else (0, _threeCoreJs.warn)('WebGLRenderer: Attempt to load unsupported compressed texture format in .uploadTexture()');
                        } else {
                            if (useTexStorage) {
                                if (dataReady) state.texSubImage3D(_gl.TEXTURE_2D_ARRAY, i, 0, 0, 0, mipmap.width, mipmap.height, image.depth, glFormat, glType, mipmap.data);
                            } else state.texImage3D(_gl.TEXTURE_2D_ARRAY, i, glInternalFormat, mipmap.width, mipmap.height, image.depth, 0, glFormat, glType, mipmap.data);
                        }
                    }
                } else {
                    if (useTexStorage && allocateMemory) state.texStorage2D(_gl.TEXTURE_2D, levels, glInternalFormat, mipmaps[0].width, mipmaps[0].height);
                    for(let i = 0, il = mipmaps.length; i < il; i++){
                        mipmap = mipmaps[i];
                        if (texture.format !== (0, _threeCoreJs.RGBAFormat)) {
                            if (glFormat !== null) {
                                if (useTexStorage) {
                                    if (dataReady) state.compressedTexSubImage2D(_gl.TEXTURE_2D, i, 0, 0, mipmap.width, mipmap.height, glFormat, mipmap.data);
                                } else state.compressedTexImage2D(_gl.TEXTURE_2D, i, glInternalFormat, mipmap.width, mipmap.height, 0, mipmap.data);
                            } else (0, _threeCoreJs.warn)('WebGLRenderer: Attempt to load unsupported compressed texture format in .uploadTexture()');
                        } else {
                            if (useTexStorage) {
                                if (dataReady) state.texSubImage2D(_gl.TEXTURE_2D, i, 0, 0, mipmap.width, mipmap.height, glFormat, glType, mipmap.data);
                            } else state.texImage2D(_gl.TEXTURE_2D, i, glInternalFormat, mipmap.width, mipmap.height, 0, glFormat, glType, mipmap.data);
                        }
                    }
                }
            } else if (texture.isDataArrayTexture) {
                if (useTexStorage) {
                    if (allocateMemory) state.texStorage3D(_gl.TEXTURE_2D_ARRAY, levels, glInternalFormat, image.width, image.height, image.depth);
                    if (dataReady) {
                        if (texture.layerUpdates.size > 0) {
                            const layerByteLength = (0, _threeCoreJs.getByteLength)(image.width, image.height, texture.format, texture.type);
                            for (const layerIndex of texture.layerUpdates){
                                const layerData = image.data.subarray(layerIndex * layerByteLength / image.data.BYTES_PER_ELEMENT, (layerIndex + 1) * layerByteLength / image.data.BYTES_PER_ELEMENT);
                                state.texSubImage3D(_gl.TEXTURE_2D_ARRAY, 0, 0, 0, layerIndex, image.width, image.height, 1, glFormat, glType, layerData);
                            }
                            texture.clearLayerUpdates();
                        } else state.texSubImage3D(_gl.TEXTURE_2D_ARRAY, 0, 0, 0, 0, image.width, image.height, image.depth, glFormat, glType, image.data);
                    }
                } else state.texImage3D(_gl.TEXTURE_2D_ARRAY, 0, glInternalFormat, image.width, image.height, image.depth, 0, glFormat, glType, image.data);
            } else if (texture.isData3DTexture) {
                if (useTexStorage) {
                    if (allocateMemory) state.texStorage3D(_gl.TEXTURE_3D, levels, glInternalFormat, image.width, image.height, image.depth);
                    if (dataReady) state.texSubImage3D(_gl.TEXTURE_3D, 0, 0, 0, 0, image.width, image.height, image.depth, glFormat, glType, image.data);
                } else state.texImage3D(_gl.TEXTURE_3D, 0, glInternalFormat, image.width, image.height, image.depth, 0, glFormat, glType, image.data);
            } else if (texture.isFramebufferTexture) {
                if (allocateMemory) {
                    if (useTexStorage) state.texStorage2D(_gl.TEXTURE_2D, levels, glInternalFormat, image.width, image.height);
                    else {
                        let width = image.width, height = image.height;
                        for(let i = 0; i < levels; i++){
                            state.texImage2D(_gl.TEXTURE_2D, i, glInternalFormat, width, height, 0, glFormat, glType, null);
                            width >>= 1;
                            height >>= 1;
                        }
                    }
                }
            } else {
                // regular Texture (image, video, canvas)
                // use manually created mipmaps if available
                // if there are no manual mipmaps
                // set 0 level mipmap and then use GL to generate other mipmap levels
                if (mipmaps.length > 0) {
                    if (useTexStorage && allocateMemory) {
                        const dimensions = getDimensions(mipmaps[0]);
                        state.texStorage2D(_gl.TEXTURE_2D, levels, glInternalFormat, dimensions.width, dimensions.height);
                    }
                    for(let i = 0, il = mipmaps.length; i < il; i++){
                        mipmap = mipmaps[i];
                        if (useTexStorage) {
                            if (dataReady) state.texSubImage2D(_gl.TEXTURE_2D, i, 0, 0, glFormat, glType, mipmap);
                        } else state.texImage2D(_gl.TEXTURE_2D, i, glInternalFormat, glFormat, glType, mipmap);
                    }
                    texture.generateMipmaps = false;
                } else if (useTexStorage) {
                    if (allocateMemory) {
                        const dimensions = getDimensions(image);
                        state.texStorage2D(_gl.TEXTURE_2D, levels, glInternalFormat, dimensions.width, dimensions.height);
                    }
                    if (dataReady) state.texSubImage2D(_gl.TEXTURE_2D, 0, 0, 0, glFormat, glType, image);
                } else state.texImage2D(_gl.TEXTURE_2D, 0, glInternalFormat, glFormat, glType, image);
            }
            if (textureNeedsGenerateMipmaps(texture)) generateMipmap(textureType);
            sourceProperties.__version = source.version;
            if (texture.onUpdate) texture.onUpdate(texture);
        }
        textureProperties.__version = texture.version;
    }
    function uploadCubeTexture(textureProperties, texture, slot) {
        if (texture.image.length !== 6) return;
        const forceUpload = initTexture(textureProperties, texture);
        const source = texture.source;
        state.bindTexture(_gl.TEXTURE_CUBE_MAP, textureProperties.__webglTexture, _gl.TEXTURE0 + slot);
        const sourceProperties = properties.get(source);
        if (source.version !== sourceProperties.__version || forceUpload === true) {
            state.activeTexture(_gl.TEXTURE0 + slot);
            const workingPrimaries = (0, _threeCoreJs.ColorManagement).getPrimaries((0, _threeCoreJs.ColorManagement).workingColorSpace);
            const texturePrimaries = texture.colorSpace === (0, _threeCoreJs.NoColorSpace) ? null : (0, _threeCoreJs.ColorManagement).getPrimaries(texture.colorSpace);
            const unpackConversion = texture.colorSpace === (0, _threeCoreJs.NoColorSpace) || workingPrimaries === texturePrimaries ? _gl.NONE : _gl.BROWSER_DEFAULT_WEBGL;
            _gl.pixelStorei(_gl.UNPACK_FLIP_Y_WEBGL, texture.flipY);
            _gl.pixelStorei(_gl.UNPACK_PREMULTIPLY_ALPHA_WEBGL, texture.premultiplyAlpha);
            _gl.pixelStorei(_gl.UNPACK_ALIGNMENT, texture.unpackAlignment);
            _gl.pixelStorei(_gl.UNPACK_COLORSPACE_CONVERSION_WEBGL, unpackConversion);
            const isCompressed = texture.isCompressedTexture || texture.image[0].isCompressedTexture;
            const isDataTexture = texture.image[0] && texture.image[0].isDataTexture;
            const cubeImage = [];
            for(let i = 0; i < 6; i++){
                if (!isCompressed && !isDataTexture) cubeImage[i] = resizeImage(texture.image[i], true, capabilities.maxCubemapSize);
                else cubeImage[i] = isDataTexture ? texture.image[i].image : texture.image[i];
                cubeImage[i] = verifyColorSpace(texture, cubeImage[i]);
            }
            const image = cubeImage[0], glFormat = utils.convert(texture.format, texture.colorSpace), glType = utils.convert(texture.type), glInternalFormat = getInternalFormat(texture.internalFormat, glFormat, glType, texture.colorSpace);
            const useTexStorage = texture.isVideoTexture !== true;
            const allocateMemory = sourceProperties.__version === undefined || forceUpload === true;
            const dataReady = source.dataReady;
            let levels = getMipLevels(texture, image);
            setTextureParameters(_gl.TEXTURE_CUBE_MAP, texture);
            let mipmaps;
            if (isCompressed) {
                if (useTexStorage && allocateMemory) state.texStorage2D(_gl.TEXTURE_CUBE_MAP, levels, glInternalFormat, image.width, image.height);
                for(let i = 0; i < 6; i++){
                    mipmaps = cubeImage[i].mipmaps;
                    for(let j = 0; j < mipmaps.length; j++){
                        const mipmap = mipmaps[j];
                        if (texture.format !== (0, _threeCoreJs.RGBAFormat)) {
                            if (glFormat !== null) {
                                if (useTexStorage) {
                                    if (dataReady) state.compressedTexSubImage2D(_gl.TEXTURE_CUBE_MAP_POSITIVE_X + i, j, 0, 0, mipmap.width, mipmap.height, glFormat, mipmap.data);
                                } else state.compressedTexImage2D(_gl.TEXTURE_CUBE_MAP_POSITIVE_X + i, j, glInternalFormat, mipmap.width, mipmap.height, 0, mipmap.data);
                            } else (0, _threeCoreJs.warn)('WebGLRenderer: Attempt to load unsupported compressed texture format in .setTextureCube()');
                        } else {
                            if (useTexStorage) {
                                if (dataReady) state.texSubImage2D(_gl.TEXTURE_CUBE_MAP_POSITIVE_X + i, j, 0, 0, mipmap.width, mipmap.height, glFormat, glType, mipmap.data);
                            } else state.texImage2D(_gl.TEXTURE_CUBE_MAP_POSITIVE_X + i, j, glInternalFormat, mipmap.width, mipmap.height, 0, glFormat, glType, mipmap.data);
                        }
                    }
                }
            } else {
                mipmaps = texture.mipmaps;
                if (useTexStorage && allocateMemory) {
                    // TODO: Uniformly handle mipmap definitions
                    // Normal textures and compressed cube textures define base level + mips with their mipmap array
                    // Uncompressed cube textures use their mipmap array only for mips (no base level)
                    if (mipmaps.length > 0) levels++;
                    const dimensions = getDimensions(cubeImage[0]);
                    state.texStorage2D(_gl.TEXTURE_CUBE_MAP, levels, glInternalFormat, dimensions.width, dimensions.height);
                }
                for(let i = 0; i < 6; i++)if (isDataTexture) {
                    if (useTexStorage) {
                        if (dataReady) state.texSubImage2D(_gl.TEXTURE_CUBE_MAP_POSITIVE_X + i, 0, 0, 0, cubeImage[i].width, cubeImage[i].height, glFormat, glType, cubeImage[i].data);
                    } else state.texImage2D(_gl.TEXTURE_CUBE_MAP_POSITIVE_X + i, 0, glInternalFormat, cubeImage[i].width, cubeImage[i].height, 0, glFormat, glType, cubeImage[i].data);
                    for(let j = 0; j < mipmaps.length; j++){
                        const mipmap = mipmaps[j];
                        const mipmapImage = mipmap.image[i].image;
                        if (useTexStorage) {
                            if (dataReady) state.texSubImage2D(_gl.TEXTURE_CUBE_MAP_POSITIVE_X + i, j + 1, 0, 0, mipmapImage.width, mipmapImage.height, glFormat, glType, mipmapImage.data);
                        } else state.texImage2D(_gl.TEXTURE_CUBE_MAP_POSITIVE_X + i, j + 1, glInternalFormat, mipmapImage.width, mipmapImage.height, 0, glFormat, glType, mipmapImage.data);
                    }
                } else {
                    if (useTexStorage) {
                        if (dataReady) state.texSubImage2D(_gl.TEXTURE_CUBE_MAP_POSITIVE_X + i, 0, 0, 0, glFormat, glType, cubeImage[i]);
                    } else state.texImage2D(_gl.TEXTURE_CUBE_MAP_POSITIVE_X + i, 0, glInternalFormat, glFormat, glType, cubeImage[i]);
                    for(let j = 0; j < mipmaps.length; j++){
                        const mipmap = mipmaps[j];
                        if (useTexStorage) {
                            if (dataReady) state.texSubImage2D(_gl.TEXTURE_CUBE_MAP_POSITIVE_X + i, j + 1, 0, 0, glFormat, glType, mipmap.image[i]);
                        } else state.texImage2D(_gl.TEXTURE_CUBE_MAP_POSITIVE_X + i, j + 1, glInternalFormat, glFormat, glType, mipmap.image[i]);
                    }
                }
            }
            if (textureNeedsGenerateMipmaps(texture)) // We assume images for cube map have the same size.
            generateMipmap(_gl.TEXTURE_CUBE_MAP);
            sourceProperties.__version = source.version;
            if (texture.onUpdate) texture.onUpdate(texture);
        }
        textureProperties.__version = texture.version;
    }
    // Render targets
    // Setup storage for target texture and bind it to correct framebuffer
    function setupFrameBufferTexture(framebuffer, renderTarget, texture, attachment, textureTarget, level) {
        const glFormat = utils.convert(texture.format, texture.colorSpace);
        const glType = utils.convert(texture.type);
        const glInternalFormat = getInternalFormat(texture.internalFormat, glFormat, glType, texture.colorSpace);
        const renderTargetProperties = properties.get(renderTarget);
        const textureProperties = properties.get(texture);
        textureProperties.__renderTarget = renderTarget;
        if (!renderTargetProperties.__hasExternalTextures) {
            const width = Math.max(1, renderTarget.width >> level);
            const height = Math.max(1, renderTarget.height >> level);
            if (textureTarget === _gl.TEXTURE_3D || textureTarget === _gl.TEXTURE_2D_ARRAY) state.texImage3D(textureTarget, level, glInternalFormat, width, height, renderTarget.depth, 0, glFormat, glType, null);
            else state.texImage2D(textureTarget, level, glInternalFormat, width, height, 0, glFormat, glType, null);
        }
        state.bindFramebuffer(_gl.FRAMEBUFFER, framebuffer);
        if (useMultisampledRTT(renderTarget)) multisampledRTTExt.framebufferTexture2DMultisampleEXT(_gl.FRAMEBUFFER, attachment, textureTarget, textureProperties.__webglTexture, 0, getRenderTargetSamples(renderTarget));
        else if (textureTarget === _gl.TEXTURE_2D || textureTarget >= _gl.TEXTURE_CUBE_MAP_POSITIVE_X && textureTarget <= _gl.TEXTURE_CUBE_MAP_NEGATIVE_Z) _gl.framebufferTexture2D(_gl.FRAMEBUFFER, attachment, textureTarget, textureProperties.__webglTexture, level);
        state.bindFramebuffer(_gl.FRAMEBUFFER, null);
    }
    // Setup storage for internal depth/stencil buffers and bind to correct framebuffer
    function setupRenderBufferStorage(renderbuffer, renderTarget, useMultisample) {
        _gl.bindRenderbuffer(_gl.RENDERBUFFER, renderbuffer);
        if (renderTarget.depthBuffer) {
            // retrieve the depth attachment types
            const depthTexture = renderTarget.depthTexture;
            const depthType = depthTexture && depthTexture.isDepthTexture ? depthTexture.type : null;
            const glInternalFormat = getInternalDepthFormat(renderTarget.stencilBuffer, depthType);
            const glAttachmentType = renderTarget.stencilBuffer ? _gl.DEPTH_STENCIL_ATTACHMENT : _gl.DEPTH_ATTACHMENT;
            // set up the attachment
            if (useMultisampledRTT(renderTarget)) multisampledRTTExt.renderbufferStorageMultisampleEXT(_gl.RENDERBUFFER, getRenderTargetSamples(renderTarget), glInternalFormat, renderTarget.width, renderTarget.height);
            else if (useMultisample) _gl.renderbufferStorageMultisample(_gl.RENDERBUFFER, getRenderTargetSamples(renderTarget), glInternalFormat, renderTarget.width, renderTarget.height);
            else _gl.renderbufferStorage(_gl.RENDERBUFFER, glInternalFormat, renderTarget.width, renderTarget.height);
            _gl.framebufferRenderbuffer(_gl.FRAMEBUFFER, glAttachmentType, _gl.RENDERBUFFER, renderbuffer);
        } else {
            const textures = renderTarget.textures;
            for(let i = 0; i < textures.length; i++){
                const texture = textures[i];
                const glFormat = utils.convert(texture.format, texture.colorSpace);
                const glType = utils.convert(texture.type);
                const glInternalFormat = getInternalFormat(texture.internalFormat, glFormat, glType, texture.colorSpace);
                if (useMultisampledRTT(renderTarget)) multisampledRTTExt.renderbufferStorageMultisampleEXT(_gl.RENDERBUFFER, getRenderTargetSamples(renderTarget), glInternalFormat, renderTarget.width, renderTarget.height);
                else if (useMultisample) _gl.renderbufferStorageMultisample(_gl.RENDERBUFFER, getRenderTargetSamples(renderTarget), glInternalFormat, renderTarget.width, renderTarget.height);
                else _gl.renderbufferStorage(_gl.RENDERBUFFER, glInternalFormat, renderTarget.width, renderTarget.height);
            }
        }
        _gl.bindRenderbuffer(_gl.RENDERBUFFER, null);
    }
    // Setup resources for a Depth Texture for a FBO (needs an extension)
    function setupDepthTexture(framebuffer, renderTarget, cubeFace) {
        const isCube = renderTarget.isWebGLCubeRenderTarget === true;
        state.bindFramebuffer(_gl.FRAMEBUFFER, framebuffer);
        if (!(renderTarget.depthTexture && renderTarget.depthTexture.isDepthTexture)) throw new Error('renderTarget.depthTexture must be an instance of THREE.DepthTexture');
        const textureProperties = properties.get(renderTarget.depthTexture);
        textureProperties.__renderTarget = renderTarget;
        // upload an empty depth texture with framebuffer size
        if (!textureProperties.__webglTexture || renderTarget.depthTexture.image.width !== renderTarget.width || renderTarget.depthTexture.image.height !== renderTarget.height) {
            renderTarget.depthTexture.image.width = renderTarget.width;
            renderTarget.depthTexture.image.height = renderTarget.height;
            renderTarget.depthTexture.needsUpdate = true;
        }
        if (isCube) {
            // For cube depth textures, initialize and bind without uploading image data
            if (textureProperties.__webglInit === undefined) {
                textureProperties.__webglInit = true;
                renderTarget.depthTexture.addEventListener('dispose', onTextureDispose);
            }
            // Only create and allocate storage once
            if (textureProperties.__webglTexture === undefined) {
                textureProperties.__webglTexture = _gl.createTexture();
                state.bindTexture(_gl.TEXTURE_CUBE_MAP, textureProperties.__webglTexture);
                setTextureParameters(_gl.TEXTURE_CUBE_MAP, renderTarget.depthTexture);
                // Allocate storage for all 6 faces with correct depth texture format
                const glFormat = utils.convert(renderTarget.depthTexture.format);
                const glType = utils.convert(renderTarget.depthTexture.type);
                // Use proper internal format for depth textures
                let glInternalFormat;
                if (renderTarget.depthTexture.format === (0, _threeCoreJs.DepthFormat)) glInternalFormat = _gl.DEPTH_COMPONENT24;
                else if (renderTarget.depthTexture.format === (0, _threeCoreJs.DepthStencilFormat)) glInternalFormat = _gl.DEPTH24_STENCIL8;
                for(let i = 0; i < 6; i++)_gl.texImage2D(_gl.TEXTURE_CUBE_MAP_POSITIVE_X + i, 0, glInternalFormat, renderTarget.width, renderTarget.height, 0, glFormat, glType, null);
            }
        } else setTexture2D(renderTarget.depthTexture, 0);
        const webglDepthTexture = textureProperties.__webglTexture;
        const samples = getRenderTargetSamples(renderTarget);
        const glTextureType = isCube ? _gl.TEXTURE_CUBE_MAP_POSITIVE_X + cubeFace : _gl.TEXTURE_2D;
        const glAttachmentType = renderTarget.depthTexture.format === (0, _threeCoreJs.DepthStencilFormat) ? _gl.DEPTH_STENCIL_ATTACHMENT : _gl.DEPTH_ATTACHMENT;
        if (renderTarget.depthTexture.format === (0, _threeCoreJs.DepthFormat)) {
            if (useMultisampledRTT(renderTarget)) multisampledRTTExt.framebufferTexture2DMultisampleEXT(_gl.FRAMEBUFFER, glAttachmentType, glTextureType, webglDepthTexture, 0, samples);
            else _gl.framebufferTexture2D(_gl.FRAMEBUFFER, glAttachmentType, glTextureType, webglDepthTexture, 0);
        } else if (renderTarget.depthTexture.format === (0, _threeCoreJs.DepthStencilFormat)) {
            if (useMultisampledRTT(renderTarget)) multisampledRTTExt.framebufferTexture2DMultisampleEXT(_gl.FRAMEBUFFER, glAttachmentType, glTextureType, webglDepthTexture, 0, samples);
            else _gl.framebufferTexture2D(_gl.FRAMEBUFFER, glAttachmentType, glTextureType, webglDepthTexture, 0);
        } else throw new Error('Unknown depthTexture format');
    }
    // Setup GL resources for a non-texture depth buffer
    function setupDepthRenderbuffer(renderTarget) {
        const renderTargetProperties = properties.get(renderTarget);
        const isCube = renderTarget.isWebGLCubeRenderTarget === true;
        // if the bound depth texture has changed
        if (renderTargetProperties.__boundDepthTexture !== renderTarget.depthTexture) {
            // fire the dispose event to get rid of stored state associated with the previously bound depth buffer
            const depthTexture = renderTarget.depthTexture;
            if (renderTargetProperties.__depthDisposeCallback) renderTargetProperties.__depthDisposeCallback();
            // set up dispose listeners to track when the currently attached buffer is implicitly unbound
            if (depthTexture) {
                const disposeEvent = ()=>{
                    delete renderTargetProperties.__boundDepthTexture;
                    delete renderTargetProperties.__depthDisposeCallback;
                    depthTexture.removeEventListener('dispose', disposeEvent);
                };
                depthTexture.addEventListener('dispose', disposeEvent);
                renderTargetProperties.__depthDisposeCallback = disposeEvent;
            }
            renderTargetProperties.__boundDepthTexture = depthTexture;
        }
        if (renderTarget.depthTexture && !renderTargetProperties.__autoAllocateDepthBuffer) {
            if (isCube) // For cube render targets with depth texture, setup each face
            for(let i = 0; i < 6; i++)setupDepthTexture(renderTargetProperties.__webglFramebuffer[i], renderTarget, i);
            else {
                const mipmaps = renderTarget.texture.mipmaps;
                if (mipmaps && mipmaps.length > 0) setupDepthTexture(renderTargetProperties.__webglFramebuffer[0], renderTarget, 0);
                else setupDepthTexture(renderTargetProperties.__webglFramebuffer, renderTarget, 0);
            }
        } else if (isCube) {
            renderTargetProperties.__webglDepthbuffer = [];
            for(let i = 0; i < 6; i++){
                state.bindFramebuffer(_gl.FRAMEBUFFER, renderTargetProperties.__webglFramebuffer[i]);
                if (renderTargetProperties.__webglDepthbuffer[i] === undefined) {
                    renderTargetProperties.__webglDepthbuffer[i] = _gl.createRenderbuffer();
                    setupRenderBufferStorage(renderTargetProperties.__webglDepthbuffer[i], renderTarget, false);
                } else {
                    // attach buffer if it's been created already
                    const glAttachmentType = renderTarget.stencilBuffer ? _gl.DEPTH_STENCIL_ATTACHMENT : _gl.DEPTH_ATTACHMENT;
                    const renderbuffer = renderTargetProperties.__webglDepthbuffer[i];
                    _gl.bindRenderbuffer(_gl.RENDERBUFFER, renderbuffer);
                    _gl.framebufferRenderbuffer(_gl.FRAMEBUFFER, glAttachmentType, _gl.RENDERBUFFER, renderbuffer);
                }
            }
        } else {
            const mipmaps = renderTarget.texture.mipmaps;
            if (mipmaps && mipmaps.length > 0) state.bindFramebuffer(_gl.FRAMEBUFFER, renderTargetProperties.__webglFramebuffer[0]);
            else state.bindFramebuffer(_gl.FRAMEBUFFER, renderTargetProperties.__webglFramebuffer);
            if (renderTargetProperties.__webglDepthbuffer === undefined) {
                renderTargetProperties.__webglDepthbuffer = _gl.createRenderbuffer();
                setupRenderBufferStorage(renderTargetProperties.__webglDepthbuffer, renderTarget, false);
            } else {
                // attach buffer if it's been created already
                const glAttachmentType = renderTarget.stencilBuffer ? _gl.DEPTH_STENCIL_ATTACHMENT : _gl.DEPTH_ATTACHMENT;
                const renderbuffer = renderTargetProperties.__webglDepthbuffer;
                _gl.bindRenderbuffer(_gl.RENDERBUFFER, renderbuffer);
                _gl.framebufferRenderbuffer(_gl.FRAMEBUFFER, glAttachmentType, _gl.RENDERBUFFER, renderbuffer);
            }
        }
        state.bindFramebuffer(_gl.FRAMEBUFFER, null);
    }
    // rebind framebuffer with external textures
    function rebindTextures(renderTarget, colorTexture, depthTexture) {
        const renderTargetProperties = properties.get(renderTarget);
        if (colorTexture !== undefined) setupFrameBufferTexture(renderTargetProperties.__webglFramebuffer, renderTarget, renderTarget.texture, _gl.COLOR_ATTACHMENT0, _gl.TEXTURE_2D, 0);
        if (depthTexture !== undefined) setupDepthRenderbuffer(renderTarget);
    }
    // Set up GL resources for the render target
    function setupRenderTarget(renderTarget) {
        const texture = renderTarget.texture;
        const renderTargetProperties = properties.get(renderTarget);
        const textureProperties = properties.get(texture);
        renderTarget.addEventListener('dispose', onRenderTargetDispose);
        const textures = renderTarget.textures;
        const isCube = renderTarget.isWebGLCubeRenderTarget === true;
        const isMultipleRenderTargets = textures.length > 1;
        if (!isMultipleRenderTargets) {
            if (textureProperties.__webglTexture === undefined) textureProperties.__webglTexture = _gl.createTexture();
            textureProperties.__version = texture.version;
            info.memory.textures++;
        }
        // Setup framebuffer
        if (isCube) {
            renderTargetProperties.__webglFramebuffer = [];
            for(let i = 0; i < 6; i++)if (texture.mipmaps && texture.mipmaps.length > 0) {
                renderTargetProperties.__webglFramebuffer[i] = [];
                for(let level = 0; level < texture.mipmaps.length; level++)renderTargetProperties.__webglFramebuffer[i][level] = _gl.createFramebuffer();
            } else renderTargetProperties.__webglFramebuffer[i] = _gl.createFramebuffer();
        } else {
            if (texture.mipmaps && texture.mipmaps.length > 0) {
                renderTargetProperties.__webglFramebuffer = [];
                for(let level = 0; level < texture.mipmaps.length; level++)renderTargetProperties.__webglFramebuffer[level] = _gl.createFramebuffer();
            } else renderTargetProperties.__webglFramebuffer = _gl.createFramebuffer();
            if (isMultipleRenderTargets) for(let i = 0, il = textures.length; i < il; i++){
                const attachmentProperties = properties.get(textures[i]);
                if (attachmentProperties.__webglTexture === undefined) {
                    attachmentProperties.__webglTexture = _gl.createTexture();
                    info.memory.textures++;
                }
            }
            if (renderTarget.samples > 0 && useMultisampledRTT(renderTarget) === false) {
                renderTargetProperties.__webglMultisampledFramebuffer = _gl.createFramebuffer();
                renderTargetProperties.__webglColorRenderbuffer = [];
                state.bindFramebuffer(_gl.FRAMEBUFFER, renderTargetProperties.__webglMultisampledFramebuffer);
                for(let i = 0; i < textures.length; i++){
                    const texture = textures[i];
                    renderTargetProperties.__webglColorRenderbuffer[i] = _gl.createRenderbuffer();
                    _gl.bindRenderbuffer(_gl.RENDERBUFFER, renderTargetProperties.__webglColorRenderbuffer[i]);
                    const glFormat = utils.convert(texture.format, texture.colorSpace);
                    const glType = utils.convert(texture.type);
                    const glInternalFormat = getInternalFormat(texture.internalFormat, glFormat, glType, texture.colorSpace, renderTarget.isXRRenderTarget === true);
                    const samples = getRenderTargetSamples(renderTarget);
                    _gl.renderbufferStorageMultisample(_gl.RENDERBUFFER, samples, glInternalFormat, renderTarget.width, renderTarget.height);
                    _gl.framebufferRenderbuffer(_gl.FRAMEBUFFER, _gl.COLOR_ATTACHMENT0 + i, _gl.RENDERBUFFER, renderTargetProperties.__webglColorRenderbuffer[i]);
                }
                _gl.bindRenderbuffer(_gl.RENDERBUFFER, null);
                if (renderTarget.depthBuffer) {
                    renderTargetProperties.__webglDepthRenderbuffer = _gl.createRenderbuffer();
                    setupRenderBufferStorage(renderTargetProperties.__webglDepthRenderbuffer, renderTarget, true);
                }
                state.bindFramebuffer(_gl.FRAMEBUFFER, null);
            }
        }
        // Setup color buffer
        if (isCube) {
            state.bindTexture(_gl.TEXTURE_CUBE_MAP, textureProperties.__webglTexture);
            setTextureParameters(_gl.TEXTURE_CUBE_MAP, texture);
            for(let i = 0; i < 6; i++){
                if (texture.mipmaps && texture.mipmaps.length > 0) for(let level = 0; level < texture.mipmaps.length; level++)setupFrameBufferTexture(renderTargetProperties.__webglFramebuffer[i][level], renderTarget, texture, _gl.COLOR_ATTACHMENT0, _gl.TEXTURE_CUBE_MAP_POSITIVE_X + i, level);
                else setupFrameBufferTexture(renderTargetProperties.__webglFramebuffer[i], renderTarget, texture, _gl.COLOR_ATTACHMENT0, _gl.TEXTURE_CUBE_MAP_POSITIVE_X + i, 0);
            }
            if (textureNeedsGenerateMipmaps(texture)) generateMipmap(_gl.TEXTURE_CUBE_MAP);
            state.unbindTexture();
        } else if (isMultipleRenderTargets) {
            for(let i = 0, il = textures.length; i < il; i++){
                const attachment = textures[i];
                const attachmentProperties = properties.get(attachment);
                let glTextureType = _gl.TEXTURE_2D;
                if (renderTarget.isWebGL3DRenderTarget || renderTarget.isWebGLArrayRenderTarget) glTextureType = renderTarget.isWebGL3DRenderTarget ? _gl.TEXTURE_3D : _gl.TEXTURE_2D_ARRAY;
                state.bindTexture(glTextureType, attachmentProperties.__webglTexture);
                setTextureParameters(glTextureType, attachment);
                setupFrameBufferTexture(renderTargetProperties.__webglFramebuffer, renderTarget, attachment, _gl.COLOR_ATTACHMENT0 + i, glTextureType, 0);
                if (textureNeedsGenerateMipmaps(attachment)) generateMipmap(glTextureType);
            }
            state.unbindTexture();
        } else {
            let glTextureType = _gl.TEXTURE_2D;
            if (renderTarget.isWebGL3DRenderTarget || renderTarget.isWebGLArrayRenderTarget) glTextureType = renderTarget.isWebGL3DRenderTarget ? _gl.TEXTURE_3D : _gl.TEXTURE_2D_ARRAY;
            state.bindTexture(glTextureType, textureProperties.__webglTexture);
            setTextureParameters(glTextureType, texture);
            if (texture.mipmaps && texture.mipmaps.length > 0) for(let level = 0; level < texture.mipmaps.length; level++)setupFrameBufferTexture(renderTargetProperties.__webglFramebuffer[level], renderTarget, texture, _gl.COLOR_ATTACHMENT0, glTextureType, level);
            else setupFrameBufferTexture(renderTargetProperties.__webglFramebuffer, renderTarget, texture, _gl.COLOR_ATTACHMENT0, glTextureType, 0);
            if (textureNeedsGenerateMipmaps(texture)) generateMipmap(glTextureType);
            state.unbindTexture();
        }
        // Setup depth and stencil buffers
        if (renderTarget.depthBuffer) setupDepthRenderbuffer(renderTarget);
    }
    function updateRenderTargetMipmap(renderTarget) {
        const textures = renderTarget.textures;
        for(let i = 0, il = textures.length; i < il; i++){
            const texture = textures[i];
            if (textureNeedsGenerateMipmaps(texture)) {
                const targetType = getTargetType(renderTarget);
                const webglTexture = properties.get(texture).__webglTexture;
                state.bindTexture(targetType, webglTexture);
                generateMipmap(targetType);
                state.unbindTexture();
            }
        }
    }
    const invalidationArrayRead = [];
    const invalidationArrayDraw = [];
    function updateMultisampleRenderTarget(renderTarget) {
        if (renderTarget.samples > 0) {
            if (useMultisampledRTT(renderTarget) === false) {
                const textures = renderTarget.textures;
                const width = renderTarget.width;
                const height = renderTarget.height;
                let mask = _gl.COLOR_BUFFER_BIT;
                const depthStyle = renderTarget.stencilBuffer ? _gl.DEPTH_STENCIL_ATTACHMENT : _gl.DEPTH_ATTACHMENT;
                const renderTargetProperties = properties.get(renderTarget);
                const isMultipleRenderTargets = textures.length > 1;
                // If MRT we need to remove FBO attachments
                if (isMultipleRenderTargets) for(let i = 0; i < textures.length; i++){
                    state.bindFramebuffer(_gl.FRAMEBUFFER, renderTargetProperties.__webglMultisampledFramebuffer);
                    _gl.framebufferRenderbuffer(_gl.FRAMEBUFFER, _gl.COLOR_ATTACHMENT0 + i, _gl.RENDERBUFFER, null);
                    state.bindFramebuffer(_gl.FRAMEBUFFER, renderTargetProperties.__webglFramebuffer);
                    _gl.framebufferTexture2D(_gl.DRAW_FRAMEBUFFER, _gl.COLOR_ATTACHMENT0 + i, _gl.TEXTURE_2D, null, 0);
                }
                state.bindFramebuffer(_gl.READ_FRAMEBUFFER, renderTargetProperties.__webglMultisampledFramebuffer);
                const mipmaps = renderTarget.texture.mipmaps;
                if (mipmaps && mipmaps.length > 0) state.bindFramebuffer(_gl.DRAW_FRAMEBUFFER, renderTargetProperties.__webglFramebuffer[0]);
                else state.bindFramebuffer(_gl.DRAW_FRAMEBUFFER, renderTargetProperties.__webglFramebuffer);
                for(let i = 0; i < textures.length; i++){
                    if (renderTarget.resolveDepthBuffer) {
                        if (renderTarget.depthBuffer) mask |= _gl.DEPTH_BUFFER_BIT;
                        // resolving stencil is slow with a D3D backend. disable it for all transmission render targets (see #27799)
                        if (renderTarget.stencilBuffer && renderTarget.resolveStencilBuffer) mask |= _gl.STENCIL_BUFFER_BIT;
                    }
                    if (isMultipleRenderTargets) {
                        _gl.framebufferRenderbuffer(_gl.READ_FRAMEBUFFER, _gl.COLOR_ATTACHMENT0, _gl.RENDERBUFFER, renderTargetProperties.__webglColorRenderbuffer[i]);
                        const webglTexture = properties.get(textures[i]).__webglTexture;
                        _gl.framebufferTexture2D(_gl.DRAW_FRAMEBUFFER, _gl.COLOR_ATTACHMENT0, _gl.TEXTURE_2D, webglTexture, 0);
                    }
                    _gl.blitFramebuffer(0, 0, width, height, 0, 0, width, height, mask, _gl.NEAREST);
                    if (supportsInvalidateFramebuffer === true) {
                        invalidationArrayRead.length = 0;
                        invalidationArrayDraw.length = 0;
                        invalidationArrayRead.push(_gl.COLOR_ATTACHMENT0 + i);
                        if (renderTarget.depthBuffer && renderTarget.resolveDepthBuffer === false) {
                            invalidationArrayRead.push(depthStyle);
                            invalidationArrayDraw.push(depthStyle);
                            _gl.invalidateFramebuffer(_gl.DRAW_FRAMEBUFFER, invalidationArrayDraw);
                        }
                        _gl.invalidateFramebuffer(_gl.READ_FRAMEBUFFER, invalidationArrayRead);
                    }
                }
                state.bindFramebuffer(_gl.READ_FRAMEBUFFER, null);
                state.bindFramebuffer(_gl.DRAW_FRAMEBUFFER, null);
                // If MRT since pre-blit we removed the FBO we need to reconstruct the attachments
                if (isMultipleRenderTargets) for(let i = 0; i < textures.length; i++){
                    state.bindFramebuffer(_gl.FRAMEBUFFER, renderTargetProperties.__webglMultisampledFramebuffer);
                    _gl.framebufferRenderbuffer(_gl.FRAMEBUFFER, _gl.COLOR_ATTACHMENT0 + i, _gl.RENDERBUFFER, renderTargetProperties.__webglColorRenderbuffer[i]);
                    const webglTexture = properties.get(textures[i]).__webglTexture;
                    state.bindFramebuffer(_gl.FRAMEBUFFER, renderTargetProperties.__webglFramebuffer);
                    _gl.framebufferTexture2D(_gl.DRAW_FRAMEBUFFER, _gl.COLOR_ATTACHMENT0 + i, _gl.TEXTURE_2D, webglTexture, 0);
                }
                state.bindFramebuffer(_gl.DRAW_FRAMEBUFFER, renderTargetProperties.__webglMultisampledFramebuffer);
            } else if (renderTarget.depthBuffer && renderTarget.resolveDepthBuffer === false && supportsInvalidateFramebuffer) {
                const depthStyle = renderTarget.stencilBuffer ? _gl.DEPTH_STENCIL_ATTACHMENT : _gl.DEPTH_ATTACHMENT;
                _gl.invalidateFramebuffer(_gl.DRAW_FRAMEBUFFER, [
                    depthStyle
                ]);
            }
        }
    }
    function getRenderTargetSamples(renderTarget) {
        return Math.min(capabilities.maxSamples, renderTarget.samples);
    }
    function useMultisampledRTT(renderTarget) {
        const renderTargetProperties = properties.get(renderTarget);
        return renderTarget.samples > 0 && extensions.has('WEBGL_multisampled_render_to_texture') === true && renderTargetProperties.__useRenderToTexture !== false;
    }
    function updateVideoTexture(texture) {
        const frame = info.render.frame;
        // Check the last frame we updated the VideoTexture
        if (_videoTextures.get(texture) !== frame) {
            _videoTextures.set(texture, frame);
            texture.update();
        }
    }
    function verifyColorSpace(texture, image) {
        const colorSpace = texture.colorSpace;
        const format = texture.format;
        const type = texture.type;
        if (texture.isCompressedTexture === true || texture.isVideoTexture === true) return image;
        if (colorSpace !== (0, _threeCoreJs.LinearSRGBColorSpace) && colorSpace !== (0, _threeCoreJs.NoColorSpace)) {
            // sRGB
            if ((0, _threeCoreJs.ColorManagement).getTransfer(colorSpace) === (0, _threeCoreJs.SRGBTransfer)) // in WebGL 2 uncompressed textures can only be sRGB encoded if they have the RGBA8 format
            {
                if (format !== (0, _threeCoreJs.RGBAFormat) || type !== (0, _threeCoreJs.UnsignedByteType)) (0, _threeCoreJs.warn)('WebGLTextures: sRGB encoded textures have to use RGBAFormat and UnsignedByteType.');
            } else (0, _threeCoreJs.error)('WebGLTextures: Unsupported texture color space:', colorSpace);
        }
        return image;
    }
    function getDimensions(image) {
        if (typeof HTMLImageElement !== 'undefined' && image instanceof HTMLImageElement) {
            // if intrinsic data are not available, fallback to width/height
            _imageDimensions.width = image.naturalWidth || image.width;
            _imageDimensions.height = image.naturalHeight || image.height;
        } else if (typeof VideoFrame !== 'undefined' && image instanceof VideoFrame) {
            _imageDimensions.width = image.displayWidth;
            _imageDimensions.height = image.displayHeight;
        } else {
            _imageDimensions.width = image.width;
            _imageDimensions.height = image.height;
        }
        return _imageDimensions;
    }
    //
    this.allocateTextureUnit = allocateTextureUnit;
    this.resetTextureUnits = resetTextureUnits;
    this.setTexture2D = setTexture2D;
    this.setTexture2DArray = setTexture2DArray;
    this.setTexture3D = setTexture3D;
    this.setTextureCube = setTextureCube;
    this.rebindTextures = rebindTextures;
    this.setupRenderTarget = setupRenderTarget;
    this.updateRenderTargetMipmap = updateRenderTargetMipmap;
    this.updateMultisampleRenderTarget = updateMultisampleRenderTarget;
    this.setupDepthRenderbuffer = setupDepthRenderbuffer;
    this.setupFrameBufferTexture = setupFrameBufferTexture;
    this.useMultisampledRTT = useMultisampledRTT;
    this.isReversedDepthBuffer = function() {
        return state.buffers.depth.getReversed();
    };
}
function WebGLUtils(gl, extensions) {
    function convert(p, colorSpace = (0, _threeCoreJs.NoColorSpace)) {
        let extension;
        const transfer = (0, _threeCoreJs.ColorManagement).getTransfer(colorSpace);
        if (p === (0, _threeCoreJs.UnsignedByteType)) return gl.UNSIGNED_BYTE;
        if (p === (0, _threeCoreJs.UnsignedShort4444Type)) return gl.UNSIGNED_SHORT_4_4_4_4;
        if (p === (0, _threeCoreJs.UnsignedShort5551Type)) return gl.UNSIGNED_SHORT_5_5_5_1;
        if (p === (0, _threeCoreJs.UnsignedInt5999Type)) return gl.UNSIGNED_INT_5_9_9_9_REV;
        if (p === (0, _threeCoreJs.UnsignedInt101111Type)) return gl.UNSIGNED_INT_10F_11F_11F_REV;
        if (p === (0, _threeCoreJs.ByteType)) return gl.BYTE;
        if (p === (0, _threeCoreJs.ShortType)) return gl.SHORT;
        if (p === (0, _threeCoreJs.UnsignedShortType)) return gl.UNSIGNED_SHORT;
        if (p === (0, _threeCoreJs.IntType)) return gl.INT;
        if (p === (0, _threeCoreJs.UnsignedIntType)) return gl.UNSIGNED_INT;
        if (p === (0, _threeCoreJs.FloatType)) return gl.FLOAT;
        if (p === (0, _threeCoreJs.HalfFloatType)) return gl.HALF_FLOAT;
        if (p === (0, _threeCoreJs.AlphaFormat)) return gl.ALPHA;
        if (p === (0, _threeCoreJs.RGBFormat)) return gl.RGB;
        if (p === (0, _threeCoreJs.RGBAFormat)) return gl.RGBA;
        if (p === (0, _threeCoreJs.DepthFormat)) return gl.DEPTH_COMPONENT;
        if (p === (0, _threeCoreJs.DepthStencilFormat)) return gl.DEPTH_STENCIL;
        // WebGL2 formats.
        if (p === (0, _threeCoreJs.RedFormat)) return gl.RED;
        if (p === (0, _threeCoreJs.RedIntegerFormat)) return gl.RED_INTEGER;
        if (p === (0, _threeCoreJs.RGFormat)) return gl.RG;
        if (p === (0, _threeCoreJs.RGIntegerFormat)) return gl.RG_INTEGER;
        if (p === (0, _threeCoreJs.RGBAIntegerFormat)) return gl.RGBA_INTEGER;
        // S3TC
        if (p === (0, _threeCoreJs.RGB_S3TC_DXT1_Format) || p === (0, _threeCoreJs.RGBA_S3TC_DXT1_Format) || p === (0, _threeCoreJs.RGBA_S3TC_DXT3_Format) || p === (0, _threeCoreJs.RGBA_S3TC_DXT5_Format)) {
            if (transfer === (0, _threeCoreJs.SRGBTransfer)) {
                extension = extensions.get('WEBGL_compressed_texture_s3tc_srgb');
                if (extension !== null) {
                    if (p === (0, _threeCoreJs.RGB_S3TC_DXT1_Format)) return extension.COMPRESSED_SRGB_S3TC_DXT1_EXT;
                    if (p === (0, _threeCoreJs.RGBA_S3TC_DXT1_Format)) return extension.COMPRESSED_SRGB_ALPHA_S3TC_DXT1_EXT;
                    if (p === (0, _threeCoreJs.RGBA_S3TC_DXT3_Format)) return extension.COMPRESSED_SRGB_ALPHA_S3TC_DXT3_EXT;
                    if (p === (0, _threeCoreJs.RGBA_S3TC_DXT5_Format)) return extension.COMPRESSED_SRGB_ALPHA_S3TC_DXT5_EXT;
                } else return null;
            } else {
                extension = extensions.get('WEBGL_compressed_texture_s3tc');
                if (extension !== null) {
                    if (p === (0, _threeCoreJs.RGB_S3TC_DXT1_Format)) return extension.COMPRESSED_RGB_S3TC_DXT1_EXT;
                    if (p === (0, _threeCoreJs.RGBA_S3TC_DXT1_Format)) return extension.COMPRESSED_RGBA_S3TC_DXT1_EXT;
                    if (p === (0, _threeCoreJs.RGBA_S3TC_DXT3_Format)) return extension.COMPRESSED_RGBA_S3TC_DXT3_EXT;
                    if (p === (0, _threeCoreJs.RGBA_S3TC_DXT5_Format)) return extension.COMPRESSED_RGBA_S3TC_DXT5_EXT;
                } else return null;
            }
        }
        // PVRTC
        if (p === (0, _threeCoreJs.RGB_PVRTC_4BPPV1_Format) || p === (0, _threeCoreJs.RGB_PVRTC_2BPPV1_Format) || p === (0, _threeCoreJs.RGBA_PVRTC_4BPPV1_Format) || p === (0, _threeCoreJs.RGBA_PVRTC_2BPPV1_Format)) {
            extension = extensions.get('WEBGL_compressed_texture_pvrtc');
            if (extension !== null) {
                if (p === (0, _threeCoreJs.RGB_PVRTC_4BPPV1_Format)) return extension.COMPRESSED_RGB_PVRTC_4BPPV1_IMG;
                if (p === (0, _threeCoreJs.RGB_PVRTC_2BPPV1_Format)) return extension.COMPRESSED_RGB_PVRTC_2BPPV1_IMG;
                if (p === (0, _threeCoreJs.RGBA_PVRTC_4BPPV1_Format)) return extension.COMPRESSED_RGBA_PVRTC_4BPPV1_IMG;
                if (p === (0, _threeCoreJs.RGBA_PVRTC_2BPPV1_Format)) return extension.COMPRESSED_RGBA_PVRTC_2BPPV1_IMG;
            } else return null;
        }
        // ETC
        if (p === (0, _threeCoreJs.RGB_ETC1_Format) || p === (0, _threeCoreJs.RGB_ETC2_Format) || p === (0, _threeCoreJs.RGBA_ETC2_EAC_Format) || p === (0, _threeCoreJs.R11_EAC_Format) || p === (0, _threeCoreJs.SIGNED_R11_EAC_Format) || p === (0, _threeCoreJs.RG11_EAC_Format) || p === (0, _threeCoreJs.SIGNED_RG11_EAC_Format)) {
            extension = extensions.get('WEBGL_compressed_texture_etc');
            if (extension !== null) {
                if (p === (0, _threeCoreJs.RGB_ETC1_Format) || p === (0, _threeCoreJs.RGB_ETC2_Format)) return transfer === (0, _threeCoreJs.SRGBTransfer) ? extension.COMPRESSED_SRGB8_ETC2 : extension.COMPRESSED_RGB8_ETC2;
                if (p === (0, _threeCoreJs.RGBA_ETC2_EAC_Format)) return transfer === (0, _threeCoreJs.SRGBTransfer) ? extension.COMPRESSED_SRGB8_ALPHA8_ETC2_EAC : extension.COMPRESSED_RGBA8_ETC2_EAC;
                if (p === (0, _threeCoreJs.R11_EAC_Format)) return extension.COMPRESSED_R11_EAC;
                if (p === (0, _threeCoreJs.SIGNED_R11_EAC_Format)) return extension.COMPRESSED_SIGNED_R11_EAC;
                if (p === (0, _threeCoreJs.RG11_EAC_Format)) return extension.COMPRESSED_RG11_EAC;
                if (p === (0, _threeCoreJs.SIGNED_RG11_EAC_Format)) return extension.COMPRESSED_SIGNED_RG11_EAC;
            } else return null;
        }
        // ASTC
        if (p === (0, _threeCoreJs.RGBA_ASTC_4x4_Format) || p === (0, _threeCoreJs.RGBA_ASTC_5x4_Format) || p === (0, _threeCoreJs.RGBA_ASTC_5x5_Format) || p === (0, _threeCoreJs.RGBA_ASTC_6x5_Format) || p === (0, _threeCoreJs.RGBA_ASTC_6x6_Format) || p === (0, _threeCoreJs.RGBA_ASTC_8x5_Format) || p === (0, _threeCoreJs.RGBA_ASTC_8x6_Format) || p === (0, _threeCoreJs.RGBA_ASTC_8x8_Format) || p === (0, _threeCoreJs.RGBA_ASTC_10x5_Format) || p === (0, _threeCoreJs.RGBA_ASTC_10x6_Format) || p === (0, _threeCoreJs.RGBA_ASTC_10x8_Format) || p === (0, _threeCoreJs.RGBA_ASTC_10x10_Format) || p === (0, _threeCoreJs.RGBA_ASTC_12x10_Format) || p === (0, _threeCoreJs.RGBA_ASTC_12x12_Format)) {
            extension = extensions.get('WEBGL_compressed_texture_astc');
            if (extension !== null) {
                if (p === (0, _threeCoreJs.RGBA_ASTC_4x4_Format)) return transfer === (0, _threeCoreJs.SRGBTransfer) ? extension.COMPRESSED_SRGB8_ALPHA8_ASTC_4x4_KHR : extension.COMPRESSED_RGBA_ASTC_4x4_KHR;
                if (p === (0, _threeCoreJs.RGBA_ASTC_5x4_Format)) return transfer === (0, _threeCoreJs.SRGBTransfer) ? extension.COMPRESSED_SRGB8_ALPHA8_ASTC_5x4_KHR : extension.COMPRESSED_RGBA_ASTC_5x4_KHR;
                if (p === (0, _threeCoreJs.RGBA_ASTC_5x5_Format)) return transfer === (0, _threeCoreJs.SRGBTransfer) ? extension.COMPRESSED_SRGB8_ALPHA8_ASTC_5x5_KHR : extension.COMPRESSED_RGBA_ASTC_5x5_KHR;
                if (p === (0, _threeCoreJs.RGBA_ASTC_6x5_Format)) return transfer === (0, _threeCoreJs.SRGBTransfer) ? extension.COMPRESSED_SRGB8_ALPHA8_ASTC_6x5_KHR : extension.COMPRESSED_RGBA_ASTC_6x5_KHR;
                if (p === (0, _threeCoreJs.RGBA_ASTC_6x6_Format)) return transfer === (0, _threeCoreJs.SRGBTransfer) ? extension.COMPRESSED_SRGB8_ALPHA8_ASTC_6x6_KHR : extension.COMPRESSED_RGBA_ASTC_6x6_KHR;
                if (p === (0, _threeCoreJs.RGBA_ASTC_8x5_Format)) return transfer === (0, _threeCoreJs.SRGBTransfer) ? extension.COMPRESSED_SRGB8_ALPHA8_ASTC_8x5_KHR : extension.COMPRESSED_RGBA_ASTC_8x5_KHR;
                if (p === (0, _threeCoreJs.RGBA_ASTC_8x6_Format)) return transfer === (0, _threeCoreJs.SRGBTransfer) ? extension.COMPRESSED_SRGB8_ALPHA8_ASTC_8x6_KHR : extension.COMPRESSED_RGBA_ASTC_8x6_KHR;
                if (p === (0, _threeCoreJs.RGBA_ASTC_8x8_Format)) return transfer === (0, _threeCoreJs.SRGBTransfer) ? extension.COMPRESSED_SRGB8_ALPHA8_ASTC_8x8_KHR : extension.COMPRESSED_RGBA_ASTC_8x8_KHR;
                if (p === (0, _threeCoreJs.RGBA_ASTC_10x5_Format)) return transfer === (0, _threeCoreJs.SRGBTransfer) ? extension.COMPRESSED_SRGB8_ALPHA8_ASTC_10x5_KHR : extension.COMPRESSED_RGBA_ASTC_10x5_KHR;
                if (p === (0, _threeCoreJs.RGBA_ASTC_10x6_Format)) return transfer === (0, _threeCoreJs.SRGBTransfer) ? extension.COMPRESSED_SRGB8_ALPHA8_ASTC_10x6_KHR : extension.COMPRESSED_RGBA_ASTC_10x6_KHR;
                if (p === (0, _threeCoreJs.RGBA_ASTC_10x8_Format)) return transfer === (0, _threeCoreJs.SRGBTransfer) ? extension.COMPRESSED_SRGB8_ALPHA8_ASTC_10x8_KHR : extension.COMPRESSED_RGBA_ASTC_10x8_KHR;
                if (p === (0, _threeCoreJs.RGBA_ASTC_10x10_Format)) return transfer === (0, _threeCoreJs.SRGBTransfer) ? extension.COMPRESSED_SRGB8_ALPHA8_ASTC_10x10_KHR : extension.COMPRESSED_RGBA_ASTC_10x10_KHR;
                if (p === (0, _threeCoreJs.RGBA_ASTC_12x10_Format)) return transfer === (0, _threeCoreJs.SRGBTransfer) ? extension.COMPRESSED_SRGB8_ALPHA8_ASTC_12x10_KHR : extension.COMPRESSED_RGBA_ASTC_12x10_KHR;
                if (p === (0, _threeCoreJs.RGBA_ASTC_12x12_Format)) return transfer === (0, _threeCoreJs.SRGBTransfer) ? extension.COMPRESSED_SRGB8_ALPHA8_ASTC_12x12_KHR : extension.COMPRESSED_RGBA_ASTC_12x12_KHR;
            } else return null;
        }
        // BPTC
        if (p === (0, _threeCoreJs.RGBA_BPTC_Format) || p === (0, _threeCoreJs.RGB_BPTC_SIGNED_Format) || p === (0, _threeCoreJs.RGB_BPTC_UNSIGNED_Format)) {
            extension = extensions.get('EXT_texture_compression_bptc');
            if (extension !== null) {
                if (p === (0, _threeCoreJs.RGBA_BPTC_Format)) return transfer === (0, _threeCoreJs.SRGBTransfer) ? extension.COMPRESSED_SRGB_ALPHA_BPTC_UNORM_EXT : extension.COMPRESSED_RGBA_BPTC_UNORM_EXT;
                if (p === (0, _threeCoreJs.RGB_BPTC_SIGNED_Format)) return extension.COMPRESSED_RGB_BPTC_SIGNED_FLOAT_EXT;
                if (p === (0, _threeCoreJs.RGB_BPTC_UNSIGNED_Format)) return extension.COMPRESSED_RGB_BPTC_UNSIGNED_FLOAT_EXT;
            } else return null;
        }
        // RGTC
        if (p === (0, _threeCoreJs.RED_RGTC1_Format) || p === (0, _threeCoreJs.SIGNED_RED_RGTC1_Format) || p === (0, _threeCoreJs.RED_GREEN_RGTC2_Format) || p === (0, _threeCoreJs.SIGNED_RED_GREEN_RGTC2_Format)) {
            extension = extensions.get('EXT_texture_compression_rgtc');
            if (extension !== null) {
                if (p === (0, _threeCoreJs.RED_RGTC1_Format)) return extension.COMPRESSED_RED_RGTC1_EXT;
                if (p === (0, _threeCoreJs.SIGNED_RED_RGTC1_Format)) return extension.COMPRESSED_SIGNED_RED_RGTC1_EXT;
                if (p === (0, _threeCoreJs.RED_GREEN_RGTC2_Format)) return extension.COMPRESSED_RED_GREEN_RGTC2_EXT;
                if (p === (0, _threeCoreJs.SIGNED_RED_GREEN_RGTC2_Format)) return extension.COMPRESSED_SIGNED_RED_GREEN_RGTC2_EXT;
            } else return null;
        }
        //
        if (p === (0, _threeCoreJs.UnsignedInt248Type)) return gl.UNSIGNED_INT_24_8;
        // if "p" can't be resolved, assume the user defines a WebGL constant as a string (fallback/workaround for packed RGB formats)
        return gl[p] !== undefined ? gl[p] : null;
    }
    return {
        convert: convert
    };
}
const _occlusion_vertex = `
void main() {

	gl_Position = vec4( position, 1.0 );

}`;
const _occlusion_fragment = `
uniform sampler2DArray depthColor;
uniform float depthWidth;
uniform float depthHeight;

void main() {

	vec2 coord = vec2( gl_FragCoord.x / depthWidth, gl_FragCoord.y / depthHeight );

	if ( coord.x >= 1.0 ) {

		gl_FragDepth = texture( depthColor, vec3( coord.x - 1.0, coord.y, 1 ) ).r;

	} else {

		gl_FragDepth = texture( depthColor, vec3( coord.x, coord.y, 0 ) ).r;

	}

}`;
/**
 * A XR module that manages the access to the Depth Sensing API.
 */ class WebXRDepthSensing {
    /**
	 * Constructs a new depth sensing module.
	 */ constructor(){
        /**
		 * An opaque texture representing the depth of the user's environment.
		 *
		 * @type {?ExternalTexture}
		 */ this.texture = null;
        /**
		 * A plane mesh for visualizing the depth texture.
		 *
		 * @type {?Mesh}
		 */ this.mesh = null;
        /**
		 * The depth near value.
		 *
		 * @type {number}
		 */ this.depthNear = 0;
        /**
		 * The depth near far.
		 *
		 * @type {number}
		 */ this.depthFar = 0;
    }
    /**
	 * Inits the depth sensing module
	 *
	 * @param {XRWebGLDepthInformation} depthData - The XR depth data.
	 * @param {XRRenderState} renderState - The XR render state.
	 */ init(depthData, renderState) {
        if (this.texture === null) {
            const texture = new (0, _threeCoreJs.ExternalTexture)(depthData.texture);
            if (depthData.depthNear !== renderState.depthNear || depthData.depthFar !== renderState.depthFar) {
                this.depthNear = depthData.depthNear;
                this.depthFar = depthData.depthFar;
            }
            this.texture = texture;
        }
    }
    /**
	 * Returns a plane mesh that visualizes the depth texture.
	 *
	 * @param {ArrayCamera} cameraXR - The XR camera.
	 * @return {?Mesh} The plane mesh.
	 */ getMesh(cameraXR) {
        if (this.texture !== null) {
            if (this.mesh === null) {
                const viewport = cameraXR.cameras[0].viewport;
                const material = new (0, _threeCoreJs.ShaderMaterial)({
                    vertexShader: _occlusion_vertex,
                    fragmentShader: _occlusion_fragment,
                    uniforms: {
                        depthColor: {
                            value: this.texture
                        },
                        depthWidth: {
                            value: viewport.z
                        },
                        depthHeight: {
                            value: viewport.w
                        }
                    }
                });
                this.mesh = new (0, _threeCoreJs.Mesh)(new (0, _threeCoreJs.PlaneGeometry)(20, 20), material);
            }
        }
        return this.mesh;
    }
    /**
	 * Resets the module
	 */ reset() {
        this.texture = null;
        this.mesh = null;
    }
    /**
	 * Returns a texture representing the depth of the user's environment.
	 *
	 * @return {?ExternalTexture} The depth texture.
	 */ getDepthTexture() {
        return this.texture;
    }
}
/**
 * This class represents an abstraction of the WebXR Device API and is
 * internally used by {@link WebGLRenderer}. `WebXRManager` also provides a public
 * interface that allows users to enable/disable XR and perform XR related
 * tasks like for instance retrieving controllers.
 *
 * @augments EventDispatcher
 * @hideconstructor
 */ class WebXRManager extends (0, _threeCoreJs.EventDispatcher) {
    /**
	 * Constructs a new WebGL renderer.
	 *
	 * @param {WebGLRenderer} renderer - The renderer.
	 * @param {WebGL2RenderingContext} gl - The rendering context.
	 */ constructor(renderer, gl){
        super();
        const scope = this;
        let session = null;
        let framebufferScaleFactor = 1.0;
        let referenceSpace = null;
        let referenceSpaceType = 'local-floor';
        // Set default foveation to maximum.
        let foveation = 1.0;
        let customReferenceSpace = null;
        let pose = null;
        let glBinding = null;
        let glProjLayer = null;
        let glBaseLayer = null;
        let xrFrame = null;
        const supportsGlBinding = typeof XRWebGLBinding !== 'undefined';
        const depthSensing = new WebXRDepthSensing();
        const cameraAccessTextures = {};
        const attributes = gl.getContextAttributes();
        let initialRenderTarget = null;
        let newRenderTarget = null;
        const controllers = [];
        const controllerInputSources = [];
        const currentSize = new (0, _threeCoreJs.Vector2)();
        let currentPixelRatio = null;
        //
        const cameraL = new (0, _threeCoreJs.PerspectiveCamera)();
        cameraL.viewport = new (0, _threeCoreJs.Vector4)();
        const cameraR = new (0, _threeCoreJs.PerspectiveCamera)();
        cameraR.viewport = new (0, _threeCoreJs.Vector4)();
        const cameras = [
            cameraL,
            cameraR
        ];
        const cameraXR = new (0, _threeCoreJs.ArrayCamera)();
        let _currentDepthNear = null;
        let _currentDepthFar = null;
        //
        /**
		 * Whether the manager's XR camera should be automatically updated or not.
		 *
		 * @type {boolean}
		 * @default true
		 */ this.cameraAutoUpdate = true;
        /**
		 * This flag notifies the renderer to be ready for XR rendering. Set it to `true`
		 * if you are going to use XR in your app.
		 *
		 * @type {boolean}
		 * @default false
		 */ this.enabled = false;
        /**
		 * Whether XR presentation is active or not.
		 *
		 * @type {boolean}
		 * @readonly
		 * @default false
		 */ this.isPresenting = false;
        /**
		 * Returns a group representing the `target ray` space of the XR controller.
		 * Use this space for visualizing 3D objects that support the user in pointing
		 * tasks like UI interaction.
		 *
		 * @param {number} index - The index of the controller.
		 * @return {Group} A group representing the `target ray` space.
		 */ this.getController = function(index) {
            let controller = controllers[index];
            if (controller === undefined) {
                controller = new (0, _threeCoreJs.WebXRController)();
                controllers[index] = controller;
            }
            return controller.getTargetRaySpace();
        };
        /**
		 * Returns a group representing the `grip` space of the XR controller.
		 * Use this space for visualizing 3D objects that support the user in pointing
		 * tasks like UI interaction.
		 *
		 * Note: If you want to show something in the user's hand AND offer a
		 * pointing ray at the same time, you'll want to attached the handheld object
		 * to the group returned by `getControllerGrip()` and the ray to the
		 * group returned by `getController()`. The idea is to have two
		 * different groups in two different coordinate spaces for the same WebXR
		 * controller.
		 *
		 * @param {number} index - The index of the controller.
		 * @return {Group} A group representing the `grip` space.
		 */ this.getControllerGrip = function(index) {
            let controller = controllers[index];
            if (controller === undefined) {
                controller = new (0, _threeCoreJs.WebXRController)();
                controllers[index] = controller;
            }
            return controller.getGripSpace();
        };
        /**
		 * Returns a group representing the `hand` space of the XR controller.
		 * Use this space for visualizing 3D objects that support the user in pointing
		 * tasks like UI interaction.
		 *
		 * @param {number} index - The index of the controller.
		 * @return {Group} A group representing the `hand` space.
		 */ this.getHand = function(index) {
            let controller = controllers[index];
            if (controller === undefined) {
                controller = new (0, _threeCoreJs.WebXRController)();
                controllers[index] = controller;
            }
            return controller.getHandSpace();
        };
        //
        function onSessionEvent(event) {
            const controllerIndex = controllerInputSources.indexOf(event.inputSource);
            if (controllerIndex === -1) return;
            const controller = controllers[controllerIndex];
            if (controller !== undefined) {
                controller.update(event.inputSource, event.frame, customReferenceSpace || referenceSpace);
                controller.dispatchEvent({
                    type: event.type,
                    data: event.inputSource
                });
            }
        }
        function onSessionEnd() {
            session.removeEventListener('select', onSessionEvent);
            session.removeEventListener('selectstart', onSessionEvent);
            session.removeEventListener('selectend', onSessionEvent);
            session.removeEventListener('squeeze', onSessionEvent);
            session.removeEventListener('squeezestart', onSessionEvent);
            session.removeEventListener('squeezeend', onSessionEvent);
            session.removeEventListener('end', onSessionEnd);
            session.removeEventListener('inputsourceschange', onInputSourcesChange);
            for(let i = 0; i < controllers.length; i++){
                const inputSource = controllerInputSources[i];
                if (inputSource === null) continue;
                controllerInputSources[i] = null;
                controllers[i].disconnect(inputSource);
            }
            _currentDepthNear = null;
            _currentDepthFar = null;
            depthSensing.reset();
            for(const key in cameraAccessTextures)delete cameraAccessTextures[key];
            // restore framebuffer/rendering state
            renderer.setRenderTarget(initialRenderTarget);
            glBaseLayer = null;
            glProjLayer = null;
            glBinding = null;
            session = null;
            newRenderTarget = null;
            //
            animation.stop();
            scope.isPresenting = false;
            renderer.setPixelRatio(currentPixelRatio);
            renderer.setSize(currentSize.width, currentSize.height, false);
            scope.dispatchEvent({
                type: 'sessionend'
            });
        }
        /**
		 * Sets the framebuffer scale factor.
		 *
		 * This method can not be used during a XR session.
		 *
		 * @param {number} value - The framebuffer scale factor.
		 */ this.setFramebufferScaleFactor = function(value) {
            framebufferScaleFactor = value;
            if (scope.isPresenting === true) (0, _threeCoreJs.warn)('WebXRManager: Cannot change framebuffer scale while presenting.');
        };
        /**
		 * Sets the reference space type. Can be used to configure a spatial relationship with the user's physical
		 * environment. Depending on how the user moves in 3D space, setting an appropriate reference space can
		 * improve tracking. Default is `local-floor`. Valid values can be found here
		 * https://developer.mozilla.org/en-US/docs/Web/API/XRReferenceSpace#reference_space_types.
		 *
		 * This method can not be used during a XR session.
		 *
		 * @param {string} value - The reference space type.
		 */ this.setReferenceSpaceType = function(value) {
            referenceSpaceType = value;
            if (scope.isPresenting === true) (0, _threeCoreJs.warn)('WebXRManager: Cannot change reference space type while presenting.');
        };
        /**
		 * Returns the XR reference space.
		 *
		 * @return {XRReferenceSpace} The XR reference space.
		 */ this.getReferenceSpace = function() {
            return customReferenceSpace || referenceSpace;
        };
        /**
		 * Sets a custom XR reference space.
		 *
		 * @param {XRReferenceSpace} space - The XR reference space.
		 */ this.setReferenceSpace = function(space) {
            customReferenceSpace = space;
        };
        /**
		 * Returns the current base layer.
		 *
		 * This is an `XRProjectionLayer` when the targeted XR device supports the
		 * WebXR Layers API, or an `XRWebGLLayer` otherwise.
		 *
		 * @return {?(XRWebGLLayer|XRProjectionLayer)} The XR base layer.
		 */ this.getBaseLayer = function() {
            return glProjLayer !== null ? glProjLayer : glBaseLayer;
        };
        /**
		 * Returns the current XR binding.
		 *
		 * Creates a new binding if needed and the browser is
		 * capable of doing so.
		 *
		 * @return {?XRWebGLBinding} The XR binding. Returns `null` if one cannot be created.
		 */ this.getBinding = function() {
            if (glBinding === null && supportsGlBinding) glBinding = new XRWebGLBinding(session, gl);
            return glBinding;
        };
        /**
		 * Returns the current XR frame.
		 *
		 * @return {?XRFrame} The XR frame. Returns `null` when used outside a XR session.
		 */ this.getFrame = function() {
            return xrFrame;
        };
        /**
		 * Returns the current XR session.
		 *
		 * @return {?XRSession} The XR session. Returns `null` when used outside a XR session.
		 */ this.getSession = function() {
            return session;
        };
        /**
		 * After a XR session has been requested usually with one of the `*Button` modules, it
		 * is injected into the renderer with this method. This method triggers the start of
		 * the actual XR rendering.
		 *
		 * @async
		 * @param {XRSession} value - The XR session to set.
		 * @return {Promise} A Promise that resolves when the session has been set.
		 */ this.setSession = async function(value) {
            session = value;
            if (session !== null) {
                initialRenderTarget = renderer.getRenderTarget();
                session.addEventListener('select', onSessionEvent);
                session.addEventListener('selectstart', onSessionEvent);
                session.addEventListener('selectend', onSessionEvent);
                session.addEventListener('squeeze', onSessionEvent);
                session.addEventListener('squeezestart', onSessionEvent);
                session.addEventListener('squeezeend', onSessionEvent);
                session.addEventListener('end', onSessionEnd);
                session.addEventListener('inputsourceschange', onInputSourcesChange);
                if (attributes.xrCompatible !== true) await gl.makeXRCompatible();
                currentPixelRatio = renderer.getPixelRatio();
                renderer.getSize(currentSize);
                // Check that the browser implements the necessary APIs to use an
                // XRProjectionLayer rather than an XRWebGLLayer
                const supportsLayers = supportsGlBinding && 'createProjectionLayer' in XRWebGLBinding.prototype;
                if (!supportsLayers) {
                    const layerInit = {
                        antialias: attributes.antialias,
                        alpha: true,
                        depth: attributes.depth,
                        stencil: attributes.stencil,
                        framebufferScaleFactor: framebufferScaleFactor
                    };
                    glBaseLayer = new XRWebGLLayer(session, gl, layerInit);
                    session.updateRenderState({
                        baseLayer: glBaseLayer
                    });
                    renderer.setPixelRatio(1);
                    renderer.setSize(glBaseLayer.framebufferWidth, glBaseLayer.framebufferHeight, false);
                    newRenderTarget = new (0, _threeCoreJs.WebGLRenderTarget)(glBaseLayer.framebufferWidth, glBaseLayer.framebufferHeight, {
                        format: (0, _threeCoreJs.RGBAFormat),
                        type: (0, _threeCoreJs.UnsignedByteType),
                        colorSpace: renderer.outputColorSpace,
                        stencilBuffer: attributes.stencil,
                        resolveDepthBuffer: glBaseLayer.ignoreDepthValues === false,
                        resolveStencilBuffer: glBaseLayer.ignoreDepthValues === false
                    });
                } else {
                    let depthFormat = null;
                    let depthType = null;
                    let glDepthFormat = null;
                    if (attributes.depth) {
                        glDepthFormat = attributes.stencil ? gl.DEPTH24_STENCIL8 : gl.DEPTH_COMPONENT24;
                        depthFormat = attributes.stencil ? (0, _threeCoreJs.DepthStencilFormat) : (0, _threeCoreJs.DepthFormat);
                        depthType = attributes.stencil ? (0, _threeCoreJs.UnsignedInt248Type) : (0, _threeCoreJs.UnsignedIntType);
                    }
                    const projectionlayerInit = {
                        colorFormat: gl.RGBA8,
                        depthFormat: glDepthFormat,
                        scaleFactor: framebufferScaleFactor
                    };
                    glBinding = this.getBinding();
                    glProjLayer = glBinding.createProjectionLayer(projectionlayerInit);
                    session.updateRenderState({
                        layers: [
                            glProjLayer
                        ]
                    });
                    renderer.setPixelRatio(1);
                    renderer.setSize(glProjLayer.textureWidth, glProjLayer.textureHeight, false);
                    newRenderTarget = new (0, _threeCoreJs.WebGLRenderTarget)(glProjLayer.textureWidth, glProjLayer.textureHeight, {
                        format: (0, _threeCoreJs.RGBAFormat),
                        type: (0, _threeCoreJs.UnsignedByteType),
                        depthTexture: new (0, _threeCoreJs.DepthTexture)(glProjLayer.textureWidth, glProjLayer.textureHeight, depthType, undefined, undefined, undefined, undefined, undefined, undefined, depthFormat),
                        stencilBuffer: attributes.stencil,
                        colorSpace: renderer.outputColorSpace,
                        samples: attributes.antialias ? 4 : 0,
                        resolveDepthBuffer: glProjLayer.ignoreDepthValues === false,
                        resolveStencilBuffer: glProjLayer.ignoreDepthValues === false
                    });
                }
                newRenderTarget.isXRRenderTarget = true; // TODO Remove this when possible, see #23278
                this.setFoveation(foveation);
                customReferenceSpace = null;
                referenceSpace = await session.requestReferenceSpace(referenceSpaceType);
                animation.setContext(session);
                animation.start();
                scope.isPresenting = true;
                scope.dispatchEvent({
                    type: 'sessionstart'
                });
            }
        };
        /**
		 * Returns the environment blend mode from the current XR session.
		 *
		 * @return {'opaque'|'additive'|'alpha-blend'|undefined} The environment blend mode. Returns `undefined` when used outside of a XR session.
		 */ this.getEnvironmentBlendMode = function() {
            if (session !== null) return session.environmentBlendMode;
        };
        /**
		 * Returns the current depth texture computed via depth sensing.
		 *
		 * See {@link WebXRDepthSensing#getDepthTexture}.
		 *
		 * @return {?Texture} The depth texture.
		 */ this.getDepthTexture = function() {
            return depthSensing.getDepthTexture();
        };
        function onInputSourcesChange(event) {
            // Notify disconnected
            for(let i = 0; i < event.removed.length; i++){
                const inputSource = event.removed[i];
                const index = controllerInputSources.indexOf(inputSource);
                if (index >= 0) {
                    controllerInputSources[index] = null;
                    controllers[index].disconnect(inputSource);
                }
            }
            // Notify connected
            for(let i = 0; i < event.added.length; i++){
                const inputSource = event.added[i];
                let controllerIndex = controllerInputSources.indexOf(inputSource);
                if (controllerIndex === -1) {
                    // Assign input source a controller that currently has no input source
                    for(let i = 0; i < controllers.length; i++){
                        if (i >= controllerInputSources.length) {
                            controllerInputSources.push(inputSource);
                            controllerIndex = i;
                            break;
                        } else if (controllerInputSources[i] === null) {
                            controllerInputSources[i] = inputSource;
                            controllerIndex = i;
                            break;
                        }
                    }
                    // If all controllers do currently receive input we ignore new ones
                    if (controllerIndex === -1) break;
                }
                const controller = controllers[controllerIndex];
                if (controller) controller.connect(inputSource);
            }
        }
        //
        const cameraLPos = new (0, _threeCoreJs.Vector3)();
        const cameraRPos = new (0, _threeCoreJs.Vector3)();
        /**
		 * Assumes 2 cameras that are parallel and share an X-axis, and that
		 * the cameras' projection and world matrices have already been set.
		 * And that near and far planes are identical for both cameras.
		 * Visualization of this technique: https://computergraphics.stackexchange.com/a/4765
		 *
		 * @param {ArrayCamera} camera - The camera to update.
		 * @param {PerspectiveCamera} cameraL - The left camera.
		 * @param {PerspectiveCamera} cameraR - The right camera.
		 */ function setProjectionFromUnion(camera, cameraL, cameraR) {
            cameraLPos.setFromMatrixPosition(cameraL.matrixWorld);
            cameraRPos.setFromMatrixPosition(cameraR.matrixWorld);
            const ipd = cameraLPos.distanceTo(cameraRPos);
            const projL = cameraL.projectionMatrix.elements;
            const projR = cameraR.projectionMatrix.elements;
            // VR systems will have identical far and near planes, and
            // most likely identical top and bottom frustum extents.
            // Use the left camera for these values.
            const near = projL[14] / (projL[10] - 1);
            const far = projL[14] / (projL[10] + 1);
            const topFov = (projL[9] + 1) / projL[5];
            const bottomFov = (projL[9] - 1) / projL[5];
            const leftFov = (projL[8] - 1) / projL[0];
            const rightFov = (projR[8] + 1) / projR[0];
            const left = near * leftFov;
            const right = near * rightFov;
            // Calculate the new camera's position offset from the
            // left camera. xOffset should be roughly half `ipd`.
            const zOffset = ipd / (-leftFov + rightFov);
            const xOffset = zOffset * -leftFov;
            // TODO: Better way to apply this offset?
            cameraL.matrixWorld.decompose(camera.position, camera.quaternion, camera.scale);
            camera.translateX(xOffset);
            camera.translateZ(zOffset);
            camera.matrixWorld.compose(camera.position, camera.quaternion, camera.scale);
            camera.matrixWorldInverse.copy(camera.matrixWorld).invert();
            // Check if the projection uses an infinite far plane.
            if (projL[10] === -1) {
                // Use the projection matrix from the left eye.
                // The camera offset is sufficient to include the view volumes
                // of both eyes (assuming symmetric projections).
                camera.projectionMatrix.copy(cameraL.projectionMatrix);
                camera.projectionMatrixInverse.copy(cameraL.projectionMatrixInverse);
            } else {
                // Find the union of the frustum values of the cameras and scale
                // the values so that the near plane's position does not change in world space,
                // although must now be relative to the new union camera.
                const near2 = near + zOffset;
                const far2 = far + zOffset;
                const left2 = left - xOffset;
                const right2 = right + (ipd - xOffset);
                const top2 = topFov * far / far2 * near2;
                const bottom2 = bottomFov * far / far2 * near2;
                camera.projectionMatrix.makePerspective(left2, right2, top2, bottom2, near2, far2);
                camera.projectionMatrixInverse.copy(camera.projectionMatrix).invert();
            }
        }
        function updateCamera(camera, parent) {
            if (parent === null) camera.matrixWorld.copy(camera.matrix);
            else camera.matrixWorld.multiplyMatrices(parent.matrixWorld, camera.matrix);
            camera.matrixWorldInverse.copy(camera.matrixWorld).invert();
        }
        /**
		 * Updates the state of the XR camera. Use this method on app level if you
		 * set `cameraAutoUpdate` to `false`. The method requires the non-XR
		 * camera of the scene as a parameter. The passed in camera's transformation
		 * is automatically adjusted to the position of the XR camera when calling
		 * this method.
		 *
		 * @param {Camera} camera - The camera.
		 */ this.updateCamera = function(camera) {
            if (session === null) return;
            let depthNear = camera.near;
            let depthFar = camera.far;
            if (depthSensing.texture !== null) {
                if (depthSensing.depthNear > 0) depthNear = depthSensing.depthNear;
                if (depthSensing.depthFar > 0) depthFar = depthSensing.depthFar;
            }
            cameraXR.near = cameraR.near = cameraL.near = depthNear;
            cameraXR.far = cameraR.far = cameraL.far = depthFar;
            if (_currentDepthNear !== cameraXR.near || _currentDepthFar !== cameraXR.far) {
                // Note that the new renderState won't apply until the next frame. See #18320
                session.updateRenderState({
                    depthNear: cameraXR.near,
                    depthFar: cameraXR.far
                });
                _currentDepthNear = cameraXR.near;
                _currentDepthFar = cameraXR.far;
            }
            // inherit camera layers and enable eye layers (1 = left, 2 = right)
            cameraXR.layers.mask = camera.layers.mask | 6;
            cameraL.layers.mask = cameraXR.layers.mask & 3;
            cameraR.layers.mask = cameraXR.layers.mask & 5;
            const parent = camera.parent;
            const cameras = cameraXR.cameras;
            updateCamera(cameraXR, parent);
            for(let i = 0; i < cameras.length; i++)updateCamera(cameras[i], parent);
            // update projection matrix for proper view frustum culling
            if (cameras.length === 2) setProjectionFromUnion(cameraXR, cameraL, cameraR);
            else // assume single camera setup (AR)
            cameraXR.projectionMatrix.copy(cameraL.projectionMatrix);
            // update user camera and its children
            updateUserCamera(camera, cameraXR, parent);
        };
        function updateUserCamera(camera, cameraXR, parent) {
            if (parent === null) camera.matrix.copy(cameraXR.matrixWorld);
            else {
                camera.matrix.copy(parent.matrixWorld);
                camera.matrix.invert();
                camera.matrix.multiply(cameraXR.matrixWorld);
            }
            camera.matrix.decompose(camera.position, camera.quaternion, camera.scale);
            camera.updateMatrixWorld(true);
            camera.projectionMatrix.copy(cameraXR.projectionMatrix);
            camera.projectionMatrixInverse.copy(cameraXR.projectionMatrixInverse);
            if (camera.isPerspectiveCamera) {
                camera.fov = (0, _threeCoreJs.RAD2DEG) * 2 * Math.atan(1 / camera.projectionMatrix.elements[5]);
                camera.zoom = 1;
            }
        }
        /**
		 * Returns an instance of {@link ArrayCamera} which represents the XR camera
		 * of the active XR session. For each view it holds a separate camera object.
		 *
		 * The camera's `fov` is currently not used and does not reflect the fov of
		 * the XR camera. If you need the fov on app level, you have to compute in
		 * manually from the XR camera's projection matrices.
		 *
		 * @return {ArrayCamera} The XR camera.
		 */ this.getCamera = function() {
            return cameraXR;
        };
        /**
		 * Returns the amount of foveation used by the XR compositor for the projection layer.
		 *
		 * @return {number|undefined} The amount of foveation.
		 */ this.getFoveation = function() {
            if (glProjLayer === null && glBaseLayer === null) return undefined;
            return foveation;
        };
        /**
		 * Sets the foveation value.
		 *
		 * @param {number} value - A number in the range `[0,1]` where `0` means no foveation (full resolution)
		 * and `1` means maximum foveation (the edges render at lower resolution).
		 */ this.setFoveation = function(value) {
            // 0 = no foveation = full resolution
            // 1 = maximum foveation = the edges render at lower resolution
            foveation = value;
            if (glProjLayer !== null) glProjLayer.fixedFoveation = value;
            if (glBaseLayer !== null && glBaseLayer.fixedFoveation !== undefined) glBaseLayer.fixedFoveation = value;
        };
        /**
		 * Returns `true` if depth sensing is supported.
		 *
		 * @return {boolean} Whether depth sensing is supported or not.
		 */ this.hasDepthSensing = function() {
            return depthSensing.texture !== null;
        };
        /**
		 * Returns the depth sensing mesh.
		 *
		 * See {@link WebXRDepthSensing#getMesh}.
		 *
		 * @return {Mesh} The depth sensing mesh.
		 */ this.getDepthSensingMesh = function() {
            return depthSensing.getMesh(cameraXR);
        };
        /**
		 * Retrieves an opaque texture from the view-aligned {@link XRCamera}.
		 * Only available during the current animation loop.
		 *
		 * @param {XRCamera} xrCamera - The camera to query.
		 * @return {?Texture} An opaque texture representing the current raw camera frame.
		 */ this.getCameraTexture = function(xrCamera) {
            return cameraAccessTextures[xrCamera];
        };
        // Animation Loop
        let onAnimationFrameCallback = null;
        function onAnimationFrame(time, frame) {
            pose = frame.getViewerPose(customReferenceSpace || referenceSpace);
            xrFrame = frame;
            if (pose !== null) {
                const views = pose.views;
                if (glBaseLayer !== null) {
                    renderer.setRenderTargetFramebuffer(newRenderTarget, glBaseLayer.framebuffer);
                    renderer.setRenderTarget(newRenderTarget);
                }
                let cameraXRNeedsUpdate = false;
                // check if it's necessary to rebuild cameraXR's camera list
                if (views.length !== cameraXR.cameras.length) {
                    cameraXR.cameras.length = 0;
                    cameraXRNeedsUpdate = true;
                }
                for(let i = 0; i < views.length; i++){
                    const view = views[i];
                    let viewport = null;
                    if (glBaseLayer !== null) viewport = glBaseLayer.getViewport(view);
                    else {
                        const glSubImage = glBinding.getViewSubImage(glProjLayer, view);
                        viewport = glSubImage.viewport;
                        // For side-by-side projection, we only produce a single texture for both eyes.
                        if (i === 0) {
                            renderer.setRenderTargetTextures(newRenderTarget, glSubImage.colorTexture, glSubImage.depthStencilTexture);
                            renderer.setRenderTarget(newRenderTarget);
                        }
                    }
                    let camera = cameras[i];
                    if (camera === undefined) {
                        camera = new (0, _threeCoreJs.PerspectiveCamera)();
                        camera.layers.enable(i);
                        camera.viewport = new (0, _threeCoreJs.Vector4)();
                        cameras[i] = camera;
                    }
                    camera.matrix.fromArray(view.transform.matrix);
                    camera.matrix.decompose(camera.position, camera.quaternion, camera.scale);
                    camera.projectionMatrix.fromArray(view.projectionMatrix);
                    camera.projectionMatrixInverse.copy(camera.projectionMatrix).invert();
                    camera.viewport.set(viewport.x, viewport.y, viewport.width, viewport.height);
                    if (i === 0) {
                        cameraXR.matrix.copy(camera.matrix);
                        cameraXR.matrix.decompose(cameraXR.position, cameraXR.quaternion, cameraXR.scale);
                    }
                    if (cameraXRNeedsUpdate === true) cameraXR.cameras.push(camera);
                }
                //
                const enabledFeatures = session.enabledFeatures;
                const gpuDepthSensingEnabled = enabledFeatures && enabledFeatures.includes('depth-sensing') && session.depthUsage == 'gpu-optimized';
                if (gpuDepthSensingEnabled && supportsGlBinding) {
                    glBinding = scope.getBinding();
                    const depthData = glBinding.getDepthInformation(views[0]);
                    if (depthData && depthData.isValid && depthData.texture) depthSensing.init(depthData, session.renderState);
                }
                const cameraAccessEnabled = enabledFeatures && enabledFeatures.includes('camera-access');
                if (cameraAccessEnabled && supportsGlBinding) {
                    renderer.state.unbindTexture();
                    glBinding = scope.getBinding();
                    for(let i = 0; i < views.length; i++){
                        const camera = views[i].camera;
                        if (camera) {
                            let cameraTex = cameraAccessTextures[camera];
                            if (!cameraTex) {
                                cameraTex = new (0, _threeCoreJs.ExternalTexture)();
                                cameraAccessTextures[camera] = cameraTex;
                            }
                            const glTexture = glBinding.getCameraImage(camera);
                            cameraTex.sourceTexture = glTexture;
                        }
                    }
                }
            }
            //
            for(let i = 0; i < controllers.length; i++){
                const inputSource = controllerInputSources[i];
                const controller = controllers[i];
                if (inputSource !== null && controller !== undefined) controller.update(inputSource, frame, customReferenceSpace || referenceSpace);
            }
            if (onAnimationFrameCallback) onAnimationFrameCallback(time, frame);
            if (frame.detectedPlanes) scope.dispatchEvent({
                type: 'planesdetected',
                data: frame
            });
            xrFrame = null;
        }
        const animation = new WebGLAnimation();
        animation.setAnimationLoop(onAnimationFrame);
        this.setAnimationLoop = function(callback) {
            onAnimationFrameCallback = callback;
        };
        this.dispose = function() {};
    }
}
const _e1 = /*@__PURE__*/ new (0, _threeCoreJs.Euler)();
const _m1 = /*@__PURE__*/ new (0, _threeCoreJs.Matrix4)();
function WebGLMaterials(renderer, properties) {
    function refreshTransformUniform(map, uniform) {
        if (map.matrixAutoUpdate === true) map.updateMatrix();
        uniform.value.copy(map.matrix);
    }
    function refreshFogUniforms(uniforms, fog) {
        fog.color.getRGB(uniforms.fogColor.value, (0, _threeCoreJs.getUnlitUniformColorSpace)(renderer));
        if (fog.isFog) {
            uniforms.fogNear.value = fog.near;
            uniforms.fogFar.value = fog.far;
        } else if (fog.isFogExp2) uniforms.fogDensity.value = fog.density;
    }
    function refreshMaterialUniforms(uniforms, material, pixelRatio, height, transmissionRenderTarget) {
        if (material.isMeshBasicMaterial) refreshUniformsCommon(uniforms, material);
        else if (material.isMeshLambertMaterial) refreshUniformsCommon(uniforms, material);
        else if (material.isMeshToonMaterial) {
            refreshUniformsCommon(uniforms, material);
            refreshUniformsToon(uniforms, material);
        } else if (material.isMeshPhongMaterial) {
            refreshUniformsCommon(uniforms, material);
            refreshUniformsPhong(uniforms, material);
        } else if (material.isMeshStandardMaterial) {
            refreshUniformsCommon(uniforms, material);
            refreshUniformsStandard(uniforms, material);
            if (material.isMeshPhysicalMaterial) refreshUniformsPhysical(uniforms, material, transmissionRenderTarget);
        } else if (material.isMeshMatcapMaterial) {
            refreshUniformsCommon(uniforms, material);
            refreshUniformsMatcap(uniforms, material);
        } else if (material.isMeshDepthMaterial) refreshUniformsCommon(uniforms, material);
        else if (material.isMeshDistanceMaterial) {
            refreshUniformsCommon(uniforms, material);
            refreshUniformsDistance(uniforms, material);
        } else if (material.isMeshNormalMaterial) refreshUniformsCommon(uniforms, material);
        else if (material.isLineBasicMaterial) {
            refreshUniformsLine(uniforms, material);
            if (material.isLineDashedMaterial) refreshUniformsDash(uniforms, material);
        } else if (material.isPointsMaterial) refreshUniformsPoints(uniforms, material, pixelRatio, height);
        else if (material.isSpriteMaterial) refreshUniformsSprites(uniforms, material);
        else if (material.isShadowMaterial) {
            uniforms.color.value.copy(material.color);
            uniforms.opacity.value = material.opacity;
        } else if (material.isShaderMaterial) material.uniformsNeedUpdate = false; // #15581
    }
    function refreshUniformsCommon(uniforms, material) {
        uniforms.opacity.value = material.opacity;
        if (material.color) uniforms.diffuse.value.copy(material.color);
        if (material.emissive) uniforms.emissive.value.copy(material.emissive).multiplyScalar(material.emissiveIntensity);
        if (material.map) {
            uniforms.map.value = material.map;
            refreshTransformUniform(material.map, uniforms.mapTransform);
        }
        if (material.alphaMap) {
            uniforms.alphaMap.value = material.alphaMap;
            refreshTransformUniform(material.alphaMap, uniforms.alphaMapTransform);
        }
        if (material.bumpMap) {
            uniforms.bumpMap.value = material.bumpMap;
            refreshTransformUniform(material.bumpMap, uniforms.bumpMapTransform);
            uniforms.bumpScale.value = material.bumpScale;
            if (material.side === (0, _threeCoreJs.BackSide)) uniforms.bumpScale.value *= -1;
        }
        if (material.normalMap) {
            uniforms.normalMap.value = material.normalMap;
            refreshTransformUniform(material.normalMap, uniforms.normalMapTransform);
            uniforms.normalScale.value.copy(material.normalScale);
            if (material.side === (0, _threeCoreJs.BackSide)) uniforms.normalScale.value.negate();
        }
        if (material.displacementMap) {
            uniforms.displacementMap.value = material.displacementMap;
            refreshTransformUniform(material.displacementMap, uniforms.displacementMapTransform);
            uniforms.displacementScale.value = material.displacementScale;
            uniforms.displacementBias.value = material.displacementBias;
        }
        if (material.emissiveMap) {
            uniforms.emissiveMap.value = material.emissiveMap;
            refreshTransformUniform(material.emissiveMap, uniforms.emissiveMapTransform);
        }
        if (material.specularMap) {
            uniforms.specularMap.value = material.specularMap;
            refreshTransformUniform(material.specularMap, uniforms.specularMapTransform);
        }
        if (material.alphaTest > 0) uniforms.alphaTest.value = material.alphaTest;
        const materialProperties = properties.get(material);
        const envMap = materialProperties.envMap;
        const envMapRotation = materialProperties.envMapRotation;
        if (envMap) {
            uniforms.envMap.value = envMap;
            _e1.copy(envMapRotation);
            // accommodate left-handed frame
            _e1.x *= -1;
            _e1.y *= -1;
            _e1.z *= -1;
            if (envMap.isCubeTexture && envMap.isRenderTargetTexture === false) {
                // environment maps which are not cube render targets or PMREMs follow a different convention
                _e1.y *= -1;
                _e1.z *= -1;
            }
            uniforms.envMapRotation.value.setFromMatrix4(_m1.makeRotationFromEuler(_e1));
            uniforms.flipEnvMap.value = envMap.isCubeTexture && envMap.isRenderTargetTexture === false ? -1 : 1;
            uniforms.reflectivity.value = material.reflectivity;
            uniforms.ior.value = material.ior;
            uniforms.refractionRatio.value = material.refractionRatio;
        }
        if (material.lightMap) {
            uniforms.lightMap.value = material.lightMap;
            uniforms.lightMapIntensity.value = material.lightMapIntensity;
            refreshTransformUniform(material.lightMap, uniforms.lightMapTransform);
        }
        if (material.aoMap) {
            uniforms.aoMap.value = material.aoMap;
            uniforms.aoMapIntensity.value = material.aoMapIntensity;
            refreshTransformUniform(material.aoMap, uniforms.aoMapTransform);
        }
    }
    function refreshUniformsLine(uniforms, material) {
        uniforms.diffuse.value.copy(material.color);
        uniforms.opacity.value = material.opacity;
        if (material.map) {
            uniforms.map.value = material.map;
            refreshTransformUniform(material.map, uniforms.mapTransform);
        }
    }
    function refreshUniformsDash(uniforms, material) {
        uniforms.dashSize.value = material.dashSize;
        uniforms.totalSize.value = material.dashSize + material.gapSize;
        uniforms.scale.value = material.scale;
    }
    function refreshUniformsPoints(uniforms, material, pixelRatio, height) {
        uniforms.diffuse.value.copy(material.color);
        uniforms.opacity.value = material.opacity;
        uniforms.size.value = material.size * pixelRatio;
        uniforms.scale.value = height * 0.5;
        if (material.map) {
            uniforms.map.value = material.map;
            refreshTransformUniform(material.map, uniforms.uvTransform);
        }
        if (material.alphaMap) {
            uniforms.alphaMap.value = material.alphaMap;
            refreshTransformUniform(material.alphaMap, uniforms.alphaMapTransform);
        }
        if (material.alphaTest > 0) uniforms.alphaTest.value = material.alphaTest;
    }
    function refreshUniformsSprites(uniforms, material) {
        uniforms.diffuse.value.copy(material.color);
        uniforms.opacity.value = material.opacity;
        uniforms.rotation.value = material.rotation;
        if (material.map) {
            uniforms.map.value = material.map;
            refreshTransformUniform(material.map, uniforms.mapTransform);
        }
        if (material.alphaMap) {
            uniforms.alphaMap.value = material.alphaMap;
            refreshTransformUniform(material.alphaMap, uniforms.alphaMapTransform);
        }
        if (material.alphaTest > 0) uniforms.alphaTest.value = material.alphaTest;
    }
    function refreshUniformsPhong(uniforms, material) {
        uniforms.specular.value.copy(material.specular);
        uniforms.shininess.value = Math.max(material.shininess, 1e-4); // to prevent pow( 0.0, 0.0 )
    }
    function refreshUniformsToon(uniforms, material) {
        if (material.gradientMap) uniforms.gradientMap.value = material.gradientMap;
    }
    function refreshUniformsStandard(uniforms, material) {
        uniforms.metalness.value = material.metalness;
        if (material.metalnessMap) {
            uniforms.metalnessMap.value = material.metalnessMap;
            refreshTransformUniform(material.metalnessMap, uniforms.metalnessMapTransform);
        }
        uniforms.roughness.value = material.roughness;
        if (material.roughnessMap) {
            uniforms.roughnessMap.value = material.roughnessMap;
            refreshTransformUniform(material.roughnessMap, uniforms.roughnessMapTransform);
        }
        if (material.envMap) //uniforms.envMap.value = material.envMap; // part of uniforms common
        uniforms.envMapIntensity.value = material.envMapIntensity;
    }
    function refreshUniformsPhysical(uniforms, material, transmissionRenderTarget) {
        uniforms.ior.value = material.ior; // also part of uniforms common
        if (material.sheen > 0) {
            uniforms.sheenColor.value.copy(material.sheenColor).multiplyScalar(material.sheen);
            uniforms.sheenRoughness.value = material.sheenRoughness;
            if (material.sheenColorMap) {
                uniforms.sheenColorMap.value = material.sheenColorMap;
                refreshTransformUniform(material.sheenColorMap, uniforms.sheenColorMapTransform);
            }
            if (material.sheenRoughnessMap) {
                uniforms.sheenRoughnessMap.value = material.sheenRoughnessMap;
                refreshTransformUniform(material.sheenRoughnessMap, uniforms.sheenRoughnessMapTransform);
            }
        }
        if (material.clearcoat > 0) {
            uniforms.clearcoat.value = material.clearcoat;
            uniforms.clearcoatRoughness.value = material.clearcoatRoughness;
            if (material.clearcoatMap) {
                uniforms.clearcoatMap.value = material.clearcoatMap;
                refreshTransformUniform(material.clearcoatMap, uniforms.clearcoatMapTransform);
            }
            if (material.clearcoatRoughnessMap) {
                uniforms.clearcoatRoughnessMap.value = material.clearcoatRoughnessMap;
                refreshTransformUniform(material.clearcoatRoughnessMap, uniforms.clearcoatRoughnessMapTransform);
            }
            if (material.clearcoatNormalMap) {
                uniforms.clearcoatNormalMap.value = material.clearcoatNormalMap;
                refreshTransformUniform(material.clearcoatNormalMap, uniforms.clearcoatNormalMapTransform);
                uniforms.clearcoatNormalScale.value.copy(material.clearcoatNormalScale);
                if (material.side === (0, _threeCoreJs.BackSide)) uniforms.clearcoatNormalScale.value.negate();
            }
        }
        if (material.dispersion > 0) uniforms.dispersion.value = material.dispersion;
        if (material.iridescence > 0) {
            uniforms.iridescence.value = material.iridescence;
            uniforms.iridescenceIOR.value = material.iridescenceIOR;
            uniforms.iridescenceThicknessMinimum.value = material.iridescenceThicknessRange[0];
            uniforms.iridescenceThicknessMaximum.value = material.iridescenceThicknessRange[1];
            if (material.iridescenceMap) {
                uniforms.iridescenceMap.value = material.iridescenceMap;
                refreshTransformUniform(material.iridescenceMap, uniforms.iridescenceMapTransform);
            }
            if (material.iridescenceThicknessMap) {
                uniforms.iridescenceThicknessMap.value = material.iridescenceThicknessMap;
                refreshTransformUniform(material.iridescenceThicknessMap, uniforms.iridescenceThicknessMapTransform);
            }
        }
        if (material.transmission > 0) {
            uniforms.transmission.value = material.transmission;
            uniforms.transmissionSamplerMap.value = transmissionRenderTarget.texture;
            uniforms.transmissionSamplerSize.value.set(transmissionRenderTarget.width, transmissionRenderTarget.height);
            if (material.transmissionMap) {
                uniforms.transmissionMap.value = material.transmissionMap;
                refreshTransformUniform(material.transmissionMap, uniforms.transmissionMapTransform);
            }
            uniforms.thickness.value = material.thickness;
            if (material.thicknessMap) {
                uniforms.thicknessMap.value = material.thicknessMap;
                refreshTransformUniform(material.thicknessMap, uniforms.thicknessMapTransform);
            }
            uniforms.attenuationDistance.value = material.attenuationDistance;
            uniforms.attenuationColor.value.copy(material.attenuationColor);
        }
        if (material.anisotropy > 0) {
            uniforms.anisotropyVector.value.set(material.anisotropy * Math.cos(material.anisotropyRotation), material.anisotropy * Math.sin(material.anisotropyRotation));
            if (material.anisotropyMap) {
                uniforms.anisotropyMap.value = material.anisotropyMap;
                refreshTransformUniform(material.anisotropyMap, uniforms.anisotropyMapTransform);
            }
        }
        uniforms.specularIntensity.value = material.specularIntensity;
        uniforms.specularColor.value.copy(material.specularColor);
        if (material.specularColorMap) {
            uniforms.specularColorMap.value = material.specularColorMap;
            refreshTransformUniform(material.specularColorMap, uniforms.specularColorMapTransform);
        }
        if (material.specularIntensityMap) {
            uniforms.specularIntensityMap.value = material.specularIntensityMap;
            refreshTransformUniform(material.specularIntensityMap, uniforms.specularIntensityMapTransform);
        }
    }
    function refreshUniformsMatcap(uniforms, material) {
        if (material.matcap) uniforms.matcap.value = material.matcap;
    }
    function refreshUniformsDistance(uniforms, material) {
        const light = properties.get(material).light;
        uniforms.referencePosition.value.setFromMatrixPosition(light.matrixWorld);
        uniforms.nearDistance.value = light.shadow.camera.near;
        uniforms.farDistance.value = light.shadow.camera.far;
    }
    return {
        refreshFogUniforms: refreshFogUniforms,
        refreshMaterialUniforms: refreshMaterialUniforms
    };
}
function WebGLUniformsGroups(gl, info, capabilities, state) {
    let buffers = {};
    let updateList = {};
    let allocatedBindingPoints = [];
    const maxBindingPoints = gl.getParameter(gl.MAX_UNIFORM_BUFFER_BINDINGS); // binding points are global whereas block indices are per shader program
    function bind(uniformsGroup, program) {
        const webglProgram = program.program;
        state.uniformBlockBinding(uniformsGroup, webglProgram);
    }
    function update(uniformsGroup, program) {
        let buffer = buffers[uniformsGroup.id];
        if (buffer === undefined) {
            prepareUniformsGroup(uniformsGroup);
            buffer = createBuffer(uniformsGroup);
            buffers[uniformsGroup.id] = buffer;
            uniformsGroup.addEventListener('dispose', onUniformsGroupsDispose);
        }
        // ensure to update the binding points/block indices mapping for this program
        const webglProgram = program.program;
        state.updateUBOMapping(uniformsGroup, webglProgram);
        // update UBO once per frame
        const frame = info.render.frame;
        if (updateList[uniformsGroup.id] !== frame) {
            updateBufferData(uniformsGroup);
            updateList[uniformsGroup.id] = frame;
        }
    }
    function createBuffer(uniformsGroup) {
        // the setup of an UBO is independent of a particular shader program but global
        const bindingPointIndex = allocateBindingPointIndex();
        uniformsGroup.__bindingPointIndex = bindingPointIndex;
        const buffer = gl.createBuffer();
        const size = uniformsGroup.__size;
        const usage = uniformsGroup.usage;
        gl.bindBuffer(gl.UNIFORM_BUFFER, buffer);
        gl.bufferData(gl.UNIFORM_BUFFER, size, usage);
        gl.bindBuffer(gl.UNIFORM_BUFFER, null);
        gl.bindBufferBase(gl.UNIFORM_BUFFER, bindingPointIndex, buffer);
        return buffer;
    }
    function allocateBindingPointIndex() {
        for(let i = 0; i < maxBindingPoints; i++)if (allocatedBindingPoints.indexOf(i) === -1) {
            allocatedBindingPoints.push(i);
            return i;
        }
        (0, _threeCoreJs.error)('WebGLRenderer: Maximum number of simultaneously usable uniforms groups reached.');
        return 0;
    }
    function updateBufferData(uniformsGroup) {
        const buffer = buffers[uniformsGroup.id];
        const uniforms = uniformsGroup.uniforms;
        const cache = uniformsGroup.__cache;
        gl.bindBuffer(gl.UNIFORM_BUFFER, buffer);
        for(let i = 0, il = uniforms.length; i < il; i++){
            const uniformArray = Array.isArray(uniforms[i]) ? uniforms[i] : [
                uniforms[i]
            ];
            for(let j = 0, jl = uniformArray.length; j < jl; j++){
                const uniform = uniformArray[j];
                if (hasUniformChanged(uniform, i, j, cache) === true) {
                    const offset = uniform.__offset;
                    const values = Array.isArray(uniform.value) ? uniform.value : [
                        uniform.value
                    ];
                    let arrayOffset = 0;
                    for(let k = 0; k < values.length; k++){
                        const value = values[k];
                        const info = getUniformSize(value);
                        // TODO add integer and struct support
                        if (typeof value === 'number' || typeof value === 'boolean') {
                            uniform.__data[0] = value;
                            gl.bufferSubData(gl.UNIFORM_BUFFER, offset + arrayOffset, uniform.__data);
                        } else if (value.isMatrix3) {
                            // manually converting 3x3 to 3x4
                            uniform.__data[0] = value.elements[0];
                            uniform.__data[1] = value.elements[1];
                            uniform.__data[2] = value.elements[2];
                            uniform.__data[3] = 0;
                            uniform.__data[4] = value.elements[3];
                            uniform.__data[5] = value.elements[4];
                            uniform.__data[6] = value.elements[5];
                            uniform.__data[7] = 0;
                            uniform.__data[8] = value.elements[6];
                            uniform.__data[9] = value.elements[7];
                            uniform.__data[10] = value.elements[8];
                            uniform.__data[11] = 0;
                        } else {
                            value.toArray(uniform.__data, arrayOffset);
                            arrayOffset += info.storage / Float32Array.BYTES_PER_ELEMENT;
                        }
                    }
                    gl.bufferSubData(gl.UNIFORM_BUFFER, offset, uniform.__data);
                }
            }
        }
        gl.bindBuffer(gl.UNIFORM_BUFFER, null);
    }
    function hasUniformChanged(uniform, index, indexArray, cache) {
        const value = uniform.value;
        const indexString = index + '_' + indexArray;
        if (cache[indexString] === undefined) {
            // cache entry does not exist so far
            if (typeof value === 'number' || typeof value === 'boolean') cache[indexString] = value;
            else cache[indexString] = value.clone();
            return true;
        } else {
            const cachedObject = cache[indexString];
            // compare current value with cached entry
            if (typeof value === 'number' || typeof value === 'boolean') {
                if (cachedObject !== value) {
                    cache[indexString] = value;
                    return true;
                }
            } else if (cachedObject.equals(value) === false) {
                cachedObject.copy(value);
                return true;
            }
        }
        return false;
    }
    function prepareUniformsGroup(uniformsGroup) {
        // determine total buffer size according to the STD140 layout
        // Hint: STD140 is the only supported layout in WebGL 2
        const uniforms = uniformsGroup.uniforms;
        let offset = 0; // global buffer offset in bytes
        const chunkSize = 16; // size of a chunk in bytes
        for(let i = 0, l = uniforms.length; i < l; i++){
            const uniformArray = Array.isArray(uniforms[i]) ? uniforms[i] : [
                uniforms[i]
            ];
            for(let j = 0, jl = uniformArray.length; j < jl; j++){
                const uniform = uniformArray[j];
                const values = Array.isArray(uniform.value) ? uniform.value : [
                    uniform.value
                ];
                for(let k = 0, kl = values.length; k < kl; k++){
                    const value = values[k];
                    const info = getUniformSize(value);
                    const chunkOffset = offset % chunkSize; // offset in the current chunk
                    const chunkPadding = chunkOffset % info.boundary; // required padding to match boundary
                    const chunkStart = chunkOffset + chunkPadding; // the start position in the current chunk for the data
                    offset += chunkPadding;
                    // Check for chunk overflow
                    if (chunkStart !== 0 && chunkSize - chunkStart < info.storage) // Add padding and adjust offset
                    offset += chunkSize - chunkStart;
                    // the following two properties will be used for partial buffer updates
                    uniform.__data = new Float32Array(info.storage / Float32Array.BYTES_PER_ELEMENT);
                    uniform.__offset = offset;
                    // Update the global offset
                    offset += info.storage;
                }
            }
        }
        // ensure correct final padding
        const chunkOffset = offset % chunkSize;
        if (chunkOffset > 0) offset += chunkSize - chunkOffset;
        //
        uniformsGroup.__size = offset;
        uniformsGroup.__cache = {};
        return this;
    }
    function getUniformSize(value) {
        const info = {
            boundary: 0,
            storage: 0 // bytes
        };
        // determine sizes according to STD140
        if (typeof value === 'number' || typeof value === 'boolean') {
            // float/int/bool
            info.boundary = 4;
            info.storage = 4;
        } else if (value.isVector2) {
            // vec2
            info.boundary = 8;
            info.storage = 8;
        } else if (value.isVector3 || value.isColor) {
            // vec3
            info.boundary = 16;
            info.storage = 12; // evil: vec3 must start on a 16-byte boundary but it only consumes 12 bytes
        } else if (value.isVector4) {
            // vec4
            info.boundary = 16;
            info.storage = 16;
        } else if (value.isMatrix3) {
            // mat3 (in STD140 a 3x3 matrix is represented as 3x4)
            info.boundary = 48;
            info.storage = 48;
        } else if (value.isMatrix4) {
            // mat4
            info.boundary = 64;
            info.storage = 64;
        } else if (value.isTexture) (0, _threeCoreJs.warn)('WebGLRenderer: Texture samplers can not be part of an uniforms group.');
        else (0, _threeCoreJs.warn)('WebGLRenderer: Unsupported uniform value type.', value);
        return info;
    }
    function onUniformsGroupsDispose(event) {
        const uniformsGroup = event.target;
        uniformsGroup.removeEventListener('dispose', onUniformsGroupsDispose);
        const index = allocatedBindingPoints.indexOf(uniformsGroup.__bindingPointIndex);
        allocatedBindingPoints.splice(index, 1);
        gl.deleteBuffer(buffers[uniformsGroup.id]);
        delete buffers[uniformsGroup.id];
        delete updateList[uniformsGroup.id];
    }
    function dispose() {
        for(const id in buffers)gl.deleteBuffer(buffers[id]);
        allocatedBindingPoints = [];
        buffers = {};
        updateList = {};
    }
    return {
        bind: bind,
        update: update,
        dispose: dispose
    };
}
/**
 * Precomputed DFG LUT for Image-Based Lighting
 * Resolution: 16x16
 * Samples: 4096 per texel
 * Format: RG16F (2 half floats per texel: scale, bias)
 */ const DATA = new Uint16Array([
    0x30b5,
    0x3ad1,
    0x314c,
    0x3a4d,
    0x33d2,
    0x391c,
    0x35ef,
    0x3828,
    0x37f3,
    0x36a6,
    0x38d1,
    0x3539,
    0x3979,
    0x3410,
    0x39f8,
    0x3252,
    0x3a53,
    0x30f0,
    0x3a94,
    0x2fc9,
    0x3abf,
    0x2e35,
    0x3ada,
    0x2d05,
    0x3ae8,
    0x2c1f,
    0x3aed,
    0x2ae0,
    0x3aea,
    0x29d1,
    0x3ae1,
    0x28ff,
    0x3638,
    0x38e4,
    0x364a,
    0x38ce,
    0x3699,
    0x385e,
    0x374e,
    0x372c,
    0x3839,
    0x35a4,
    0x38dc,
    0x3462,
    0x396e,
    0x32c4,
    0x39de,
    0x3134,
    0x3a2b,
    0x3003,
    0x3a59,
    0x2e3a,
    0x3a6d,
    0x2ce1,
    0x3a6e,
    0x2bba,
    0x3a5f,
    0x2a33,
    0x3a49,
    0x290a,
    0x3a2d,
    0x2826,
    0x3a0a,
    0x26e8,
    0x3894,
    0x36d7,
    0x3897,
    0x36c9,
    0x38a3,
    0x3675,
    0x38bc,
    0x35ac,
    0x38ee,
    0x349c,
    0x393e,
    0x3332,
    0x3997,
    0x3186,
    0x39e2,
    0x3038,
    0x3a13,
    0x2e75,
    0x3a29,
    0x2cf5,
    0x3a2d,
    0x2bac,
    0x3a21,
    0x29ff,
    0x3a04,
    0x28bc,
    0x39dc,
    0x2790,
    0x39ad,
    0x261a,
    0x3978,
    0x24fa,
    0x39ac,
    0x34a8,
    0x39ac,
    0x34a3,
    0x39ae,
    0x3480,
    0x39ae,
    0x3423,
    0x39b1,
    0x330e,
    0x39c2,
    0x31a9,
    0x39e0,
    0x3063,
    0x39fc,
    0x2eb5,
    0x3a0c,
    0x2d1d,
    0x3a14,
    0x2bcf,
    0x3a07,
    0x29ff,
    0x39e9,
    0x28a3,
    0x39be,
    0x273c,
    0x3989,
    0x25b3,
    0x394a,
    0x2488,
    0x3907,
    0x2345,
    0x3a77,
    0x3223,
    0x3a76,
    0x321f,
    0x3a73,
    0x3204,
    0x3a6a,
    0x31b3,
    0x3a58,
    0x3114,
    0x3a45,
    0x303b,
    0x3a34,
    0x2eb6,
    0x3a26,
    0x2d31,
    0x3a1e,
    0x2bef,
    0x3a0b,
    0x2a0d,
    0x39ec,
    0x28a1,
    0x39c0,
    0x271b,
    0x3987,
    0x2580,
    0x3944,
    0x2449,
    0x38fa,
    0x22bd,
    0x38ac,
    0x2155,
    0x3b07,
    0x2fca,
    0x3b06,
    0x2fca,
    0x3b00,
    0x2fb8,
    0x3af4,
    0x2f7c,
    0x3adb,
    0x2eea,
    0x3ab4,
    0x2e00,
    0x3a85,
    0x2cec,
    0x3a5e,
    0x2bc5,
    0x3a36,
    0x2a00,
    0x3a0d,
    0x2899,
    0x39dc,
    0x2707,
    0x39a0,
    0x2562,
    0x395a,
    0x2424,
    0x390b,
    0x2268,
    0x38b7,
    0x20fd,
    0x385f,
    0x1fd1,
    0x3b69,
    0x2cb9,
    0x3b68,
    0x2cbb,
    0x3b62,
    0x2cbb,
    0x3b56,
    0x2cae,
    0x3b3b,
    0x2c78,
    0x3b0d,
    0x2c0a,
    0x3acf,
    0x2ae3,
    0x3a92,
    0x2998,
    0x3a54,
    0x2867,
    0x3a17,
    0x26d0,
    0x39d3,
    0x253c,
    0x3989,
    0x2402,
    0x3935,
    0x2226,
    0x38dc,
    0x20bd,
    0x387d,
    0x1f54,
    0x381d,
    0x1db3,
    0x3ba9,
    0x296b,
    0x3ba8,
    0x296f,
    0x3ba3,
    0x297b,
    0x3b98,
    0x2987,
    0x3b7f,
    0x2976,
    0x3b4e,
    0x2927,
    0x3b0e,
    0x2895,
    0x3ac2,
    0x27b7,
    0x3a73,
    0x263b,
    0x3a23,
    0x24e7,
    0x39d0,
    0x239b,
    0x3976,
    0x21d9,
    0x3917,
    0x207e,
    0x38b2,
    0x1ee7,
    0x384b,
    0x1d53,
    0x37c7,
    0x1c1e,
    0x3bd2,
    0x25cb,
    0x3bd1,
    0x25d3,
    0x3bcd,
    0x25f0,
    0x3bc2,
    0x261f,
    0x3bad,
    0x2645,
    0x3b7d,
    0x262d,
    0x3b3e,
    0x25c4,
    0x3aec,
    0x250f,
    0x3a93,
    0x243a,
    0x3a32,
    0x22ce,
    0x39d0,
    0x215b,
    0x3969,
    0x202a,
    0x38fe,
    0x1e6e,
    0x388f,
    0x1cf1,
    0x381f,
    0x1b9b,
    0x3762,
    0x19dd,
    0x3be9,
    0x21ab,
    0x3be9,
    0x21b7,
    0x3be5,
    0x21e5,
    0x3bdd,
    0x2241,
    0x3bc9,
    0x22a7,
    0x3ba0,
    0x22ec,
    0x3b62,
    0x22cd,
    0x3b0f,
    0x2247,
    0x3aae,
    0x2175,
    0x3a44,
    0x2088,
    0x39d4,
    0x1f49,
    0x3960,
    0x1dbe,
    0x38e9,
    0x1c77,
    0x3870,
    0x1ae8,
    0x37f1,
    0x1953,
    0x3708,
    0x181b,
    0x3bf6,
    0x1cea,
    0x3bf6,
    0x1cfb,
    0x3bf3,
    0x1d38,
    0x3bec,
    0x1dbd,
    0x3bda,
    0x1e7c,
    0x3bb7,
    0x1f25,
    0x3b7d,
    0x1f79,
    0x3b2c,
    0x1f4c,
    0x3ac6,
    0x1ea6,
    0x3a55,
    0x1dbb,
    0x39da,
    0x1cbd,
    0x395a,
    0x1b9d,
    0x38d8,
    0x1a00,
    0x3855,
    0x18ac,
    0x37ab,
    0x173c,
    0x36b7,
    0x1598,
    0x3bfc,
    0x1736,
    0x3bfc,
    0x1759,
    0x3bf9,
    0x17e7,
    0x3bf4,
    0x1896,
    0x3be4,
    0x1997,
    0x3bc6,
    0x1aa8,
    0x3b91,
    0x1b84,
    0x3b43,
    0x1bd2,
    0x3ade,
    0x1b8a,
    0x3a65,
    0x1acd,
    0x39e2,
    0x19d3,
    0x3957,
    0x18cd,
    0x38ca,
    0x17b3,
    0x383e,
    0x1613,
    0x376d,
    0x14bf,
    0x366f,
    0x135e,
    0x3bff,
    0x101b,
    0x3bff,
    0x1039,
    0x3bfc,
    0x10c8,
    0x3bf9,
    0x1226,
    0x3bea,
    0x1428,
    0x3bcf,
    0x1584,
    0x3b9f,
    0x16c5,
    0x3b54,
    0x179a,
    0x3af0,
    0x17ce,
    0x3a76,
    0x1771,
    0x39ea,
    0x16a4,
    0x3956,
    0x15a7,
    0x38bf,
    0x14a7,
    0x3829,
    0x1379,
    0x3735,
    0x11ea,
    0x362d,
    0x10a1,
    0x3c00,
    0x061b,
    0x3c00,
    0x066a,
    0x3bfe,
    0x081c,
    0x3bfa,
    0x0a4c,
    0x3bed,
    0x0d16,
    0x3bd5,
    0x0fb3,
    0x3ba9,
    0x114d,
    0x3b63,
    0x127c,
    0x3b01,
    0x132f,
    0x3a85,
    0x1344,
    0x39f4,
    0x12d2,
    0x3957,
    0x120d,
    0x38b5,
    0x1122,
    0x3817,
    0x103c,
    0x3703,
    0x0ed3,
    0x35f0,
    0x0d6d,
    0x3c00,
    0x007a,
    0x3c00,
    0x0089,
    0x3bfe,
    0x011d,
    0x3bfb,
    0x027c,
    0x3bf0,
    0x04fa,
    0x3bda,
    0x0881,
    0x3bb1,
    0x0acd,
    0x3b6f,
    0x0c97,
    0x3b10,
    0x0d7b,
    0x3a93,
    0x0df1,
    0x39fe,
    0x0def,
    0x3959,
    0x0d8a,
    0x38af,
    0x0ce9,
    0x3808,
    0x0c31,
    0x36d5,
    0x0af0,
    0x35b9,
    0x09a3,
    0x3c00,
    0x0000,
    0x3c00,
    0x0001,
    0x3bff,
    0x0015,
    0x3bfb,
    0x0059,
    0x3bf2,
    0x00fd,
    0x3bdd,
    0x01df,
    0x3bb7,
    0x031c,
    0x3b79,
    0x047c,
    0x3b1d,
    0x05d4,
    0x3aa0,
    0x06d5,
    0x3a08,
    0x075a,
    0x395d,
    0x075e,
    0x38aa,
    0x06f7,
    0x37f4,
    0x0648,
    0x36ac,
    0x0576,
    0x3586,
    0x049f
]);
let lut = null;
function getDFGLUT() {
    if (lut === null) {
        lut = new (0, _threeCoreJs.DataTexture)(DATA, 16, 16, (0, _threeCoreJs.RGFormat), (0, _threeCoreJs.HalfFloatType));
        lut.name = 'DFG_LUT';
        lut.minFilter = (0, _threeCoreJs.LinearFilter);
        lut.magFilter = (0, _threeCoreJs.LinearFilter);
        lut.wrapS = (0, _threeCoreJs.ClampToEdgeWrapping);
        lut.wrapT = (0, _threeCoreJs.ClampToEdgeWrapping);
        lut.generateMipmaps = false;
        lut.needsUpdate = true;
    }
    return lut;
}
/**
 * This renderer uses WebGL 2 to display scenes.
 *
 * WebGL 1 is not supported since `r163`.
 */ class WebGLRenderer {
    /**
	 * Constructs a new WebGL renderer.
	 *
	 * @param {WebGLRenderer~Options} [parameters] - The configuration parameter.
	 */ constructor(parameters = {}){
        const { canvas = (0, _threeCoreJs.createCanvasElement)(), context = null, depth = true, stencil = false, alpha = false, antialias = false, premultipliedAlpha = true, preserveDrawingBuffer = false, powerPreference = 'default', failIfMajorPerformanceCaveat = false, reversedDepthBuffer = false, outputBufferType = (0, _threeCoreJs.UnsignedByteType) } = parameters;
        /**
		 * This flag can be used for type testing.
		 *
		 * @type {boolean}
		 * @readonly
		 * @default true
		 */ this.isWebGLRenderer = true;
        let _alpha;
        if (context !== null) {
            if (typeof WebGLRenderingContext !== 'undefined' && context instanceof WebGLRenderingContext) throw new Error('THREE.WebGLRenderer: WebGL 1 is not supported since r163.');
            _alpha = context.getContextAttributes().alpha;
        } else _alpha = alpha;
        const _outputBufferType = outputBufferType;
        const INTEGER_FORMATS = new Set([
            (0, _threeCoreJs.RGBAIntegerFormat),
            (0, _threeCoreJs.RGIntegerFormat),
            (0, _threeCoreJs.RedIntegerFormat)
        ]);
        const UNSIGNED_TYPES = new Set([
            (0, _threeCoreJs.UnsignedByteType),
            (0, _threeCoreJs.UnsignedIntType),
            (0, _threeCoreJs.UnsignedShortType),
            (0, _threeCoreJs.UnsignedInt248Type),
            (0, _threeCoreJs.UnsignedShort4444Type),
            (0, _threeCoreJs.UnsignedShort5551Type)
        ]);
        const uintClearColor = new Uint32Array(4);
        const intClearColor = new Int32Array(4);
        let currentRenderList = null;
        let currentRenderState = null;
        // render() can be called from within a callback triggered by another render.
        // We track this so that the nested render call gets its list and state isolated from the parent render call.
        const renderListStack = [];
        const renderStateStack = [];
        // internal render target for non-UnsignedByteType color buffer
        let output = null;
        // public properties
        /**
		 * A canvas where the renderer draws its output.This is automatically created by the renderer
		 * in the constructor (if not provided already); you just need to add it to your page like so:
		 * ```js
		 * document.body.appendChild( renderer.domElement );
		 * ```
		 *
		 * @type {HTMLCanvasElement|OffscreenCanvas}
		 */ this.domElement = canvas;
        /**
		 * A object with debug configuration settings.
		 *
		 * - `checkShaderErrors`: If it is `true`, defines whether material shader programs are
		 * checked for errors during compilation and linkage process. It may be useful to disable
		 * this check in production for performance gain. It is strongly recommended to keep these
		 * checks enabled during development. If the shader does not compile and link - it will not
		 * work and associated material will not render.
		 * - `onShaderError(gl, program, glVertexShader,glFragmentShader)`: A callback function that
		 * can be used for custom error reporting. The callback receives the WebGL context, an instance
		 * of WebGLProgram as well two instances of WebGLShader representing the vertex and fragment shader.
		 * Assigning a custom function disables the default error reporting.
		 *
		 * @type {Object}
		 */ this.debug = {
            /**
			 * Enables error checking and reporting when shader programs are being compiled.
			 * @type {boolean}
			 */ checkShaderErrors: true,
            /**
			 * Callback for custom error reporting.
			 * @type {?Function}
			 */ onShaderError: null
        };
        // clearing
        /**
		 * Whether the renderer should automatically clear its output before rendering a frame or not.
		 *
		 * @type {boolean}
		 * @default true
		 */ this.autoClear = true;
        /**
		 * If {@link WebGLRenderer#autoClear} set to `true`, whether the renderer should clear
		 * the color buffer or not.
		 *
		 * @type {boolean}
		 * @default true
		 */ this.autoClearColor = true;
        /**
		 * If {@link WebGLRenderer#autoClear} set to `true`, whether the renderer should clear
		 * the depth buffer or not.
		 *
		 * @type {boolean}
		 * @default true
		 */ this.autoClearDepth = true;
        /**
		 * If {@link WebGLRenderer#autoClear} set to `true`, whether the renderer should clear
		 * the stencil buffer or not.
		 *
		 * @type {boolean}
		 * @default true
		 */ this.autoClearStencil = true;
        // scene graph
        /**
		 * Whether the renderer should sort objects or not.
		 *
		 * Note: Sorting is used to attempt to properly render objects that have some
		 * degree of transparency. By definition, sorting objects may not work in all
		 * cases. Depending on the needs of application, it may be necessary to turn
		 * off sorting and use other methods to deal with transparency rendering e.g.
		 * manually determining each object's rendering order.
		 *
		 * @type {boolean}
		 * @default true
		 */ this.sortObjects = true;
        // user-defined clipping
        /**
		 * User-defined clipping planes specified in world space. These planes apply globally.
		 * Points in space whose dot product with the plane is negative are cut away.
		 *
		 * @type {Array<Plane>}
		 */ this.clippingPlanes = [];
        /**
		 * Whether the renderer respects object-level clipping planes or not.
		 *
		 * @type {boolean}
		 * @default false
		 */ this.localClippingEnabled = false;
        // tone mapping
        /**
		 * The tone mapping technique of the renderer.
		 *
		 * @type {(NoToneMapping|LinearToneMapping|ReinhardToneMapping|CineonToneMapping|ACESFilmicToneMapping|CustomToneMapping|AgXToneMapping|NeutralToneMapping)}
		 * @default NoToneMapping
		 */ this.toneMapping = (0, _threeCoreJs.NoToneMapping);
        /**
		 * Exposure level of tone mapping.
		 *
		 * @type {number}
		 * @default 1
		 */ this.toneMappingExposure = 1.0;
        // transmission
        /**
		 * The normalized resolution scale for the transmission render target, measured in percentage
		 * of viewport dimensions. Lowering this value can result in significant performance improvements
		 * when using {@link MeshPhysicalMaterial#transmission}.
		 *
		 * @type {number}
		 * @default 1
		 */ this.transmissionResolutionScale = 1.0;
        // internal properties
        const _this = this;
        let _isContextLost = false;
        // internal state cache
        this._outputColorSpace = (0, _threeCoreJs.SRGBColorSpace);
        let _currentActiveCubeFace = 0;
        let _currentActiveMipmapLevel = 0;
        let _currentRenderTarget = null;
        let _currentMaterialId = -1;
        let _currentCamera = null;
        const _currentViewport = new (0, _threeCoreJs.Vector4)();
        const _currentScissor = new (0, _threeCoreJs.Vector4)();
        let _currentScissorTest = null;
        const _currentClearColor = new (0, _threeCoreJs.Color)(0x000000);
        let _currentClearAlpha = 0;
        //
        let _width = canvas.width;
        let _height = canvas.height;
        let _pixelRatio = 1;
        let _opaqueSort = null;
        let _transparentSort = null;
        const _viewport = new (0, _threeCoreJs.Vector4)(0, 0, _width, _height);
        const _scissor = new (0, _threeCoreJs.Vector4)(0, 0, _width, _height);
        let _scissorTest = false;
        // frustum
        const _frustum = new (0, _threeCoreJs.Frustum)();
        // clipping
        let _clippingEnabled = false;
        let _localClippingEnabled = false;
        // camera matrices cache
        const _projScreenMatrix = new (0, _threeCoreJs.Matrix4)();
        const _vector3 = new (0, _threeCoreJs.Vector3)();
        const _vector4 = new (0, _threeCoreJs.Vector4)();
        const _emptyScene = {
            background: null,
            fog: null,
            environment: null,
            overrideMaterial: null,
            isScene: true
        };
        let _renderBackground = false;
        function getTargetPixelRatio() {
            return _currentRenderTarget === null ? _pixelRatio : 1;
        }
        // initialize
        let _gl = context;
        function getContext(contextName, contextAttributes) {
            return canvas.getContext(contextName, contextAttributes);
        }
        try {
            const contextAttributes = {
                alpha: true,
                depth,
                stencil,
                antialias,
                premultipliedAlpha,
                preserveDrawingBuffer,
                powerPreference,
                failIfMajorPerformanceCaveat
            };
            // OffscreenCanvas does not have setAttribute, see #22811
            if ('setAttribute' in canvas) canvas.setAttribute('data-engine', `three.js r${(0, _threeCoreJs.REVISION)}`);
            // event listeners must be registered before WebGL context is created, see #12753
            canvas.addEventListener('webglcontextlost', onContextLost, false);
            canvas.addEventListener('webglcontextrestored', onContextRestore, false);
            canvas.addEventListener('webglcontextcreationerror', onContextCreationError, false);
            if (_gl === null) {
                const contextName = 'webgl2';
                _gl = getContext(contextName, contextAttributes);
                if (_gl === null) {
                    if (getContext(contextName)) throw new Error('Error creating WebGL context with your selected attributes.');
                    else throw new Error('Error creating WebGL context.');
                }
            }
        } catch (e) {
            (0, _threeCoreJs.error)('WebGLRenderer: ' + e.message);
            throw e;
        }
        let extensions, capabilities, state, info;
        let properties, textures, cubemaps, cubeuvmaps, attributes, geometries, objects;
        let programCache, materials, renderLists, renderStates, clipping, shadowMap;
        let background, morphtargets, bufferRenderer, indexedBufferRenderer;
        let utils, bindingStates, uniformsGroups;
        function initGLContext() {
            extensions = new WebGLExtensions(_gl);
            extensions.init();
            utils = new WebGLUtils(_gl, extensions);
            capabilities = new WebGLCapabilities(_gl, extensions, parameters, utils);
            state = new WebGLState(_gl, extensions);
            if (capabilities.reversedDepthBuffer && reversedDepthBuffer) state.buffers.depth.setReversed(true);
            info = new WebGLInfo(_gl);
            properties = new WebGLProperties();
            textures = new WebGLTextures(_gl, extensions, state, properties, capabilities, utils, info);
            cubemaps = new WebGLCubeMaps(_this);
            cubeuvmaps = new WebGLCubeUVMaps(_this);
            attributes = new WebGLAttributes(_gl);
            bindingStates = new WebGLBindingStates(_gl, attributes);
            geometries = new WebGLGeometries(_gl, attributes, info, bindingStates);
            objects = new WebGLObjects(_gl, geometries, attributes, info);
            morphtargets = new WebGLMorphtargets(_gl, capabilities, textures);
            clipping = new WebGLClipping(properties);
            programCache = new WebGLPrograms(_this, cubemaps, cubeuvmaps, extensions, capabilities, bindingStates, clipping);
            materials = new WebGLMaterials(_this, properties);
            renderLists = new WebGLRenderLists();
            renderStates = new WebGLRenderStates(extensions);
            background = new WebGLBackground(_this, cubemaps, cubeuvmaps, state, objects, _alpha, premultipliedAlpha);
            shadowMap = new WebGLShadowMap(_this, objects, capabilities);
            uniformsGroups = new WebGLUniformsGroups(_gl, info, capabilities, state);
            bufferRenderer = new WebGLBufferRenderer(_gl, extensions, info);
            indexedBufferRenderer = new WebGLIndexedBufferRenderer(_gl, extensions, info);
            info.programs = programCache.programs;
            /**
			 * Holds details about the capabilities of the current rendering context.
			 *
			 * @name WebGLRenderer#capabilities
			 * @type {WebGLRenderer~Capabilities}
			 */ _this.capabilities = capabilities;
            /**
			 * Provides methods for retrieving and testing WebGL extensions.
			 *
			 * - `get(extensionName:string)`: Used to check whether a WebGL extension is supported
			 * and return the extension object if available.
			 * - `has(extensionName:string)`: returns `true` if the extension is supported.
			 *
			 * @name WebGLRenderer#extensions
			 * @type {Object}
			 */ _this.extensions = extensions;
            /**
			 * Used to track properties of other objects like native WebGL objects.
			 *
			 * @name WebGLRenderer#properties
			 * @type {Object}
			 */ _this.properties = properties;
            /**
			 * Manages the render lists of the renderer.
			 *
			 * @name WebGLRenderer#renderLists
			 * @type {Object}
			 */ _this.renderLists = renderLists;
            /**
			 * Interface for managing shadows.
			 *
			 * @name WebGLRenderer#shadowMap
			 * @type {WebGLRenderer~ShadowMap}
			 */ _this.shadowMap = shadowMap;
            /**
			 * Interface for managing the WebGL state.
			 *
			 * @name WebGLRenderer#state
			 * @type {Object}
			 */ _this.state = state;
            /**
			 * Holds a series of statistical information about the GPU memory
			 * and the rendering process. Useful for debugging and monitoring.
			 *
			 * By default these data are reset at each render call but when having
			 * multiple render passes per frame (e.g. when using post processing) it can
			 * be preferred to reset with a custom pattern. First, set `autoReset` to
			 * `false`.
			 * ```js
			 * renderer.info.autoReset = false;
			 * ```
			 * Call `reset()` whenever you have finished to render a single frame.
			 * ```js
			 * renderer.info.reset();
			 * ```
			 *
			 * @name WebGLRenderer#info
			 * @type {WebGLRenderer~Info}
			 */ _this.info = info;
        }
        initGLContext();
        // initialize internal render target for non-UnsignedByteType color buffer
        if (_outputBufferType !== (0, _threeCoreJs.UnsignedByteType)) output = new WebGLOutput(_outputBufferType, canvas.width, canvas.height, depth, stencil);
        // xr
        const xr = new WebXRManager(_this, _gl);
        /**
		 * A reference to the XR manager.
		 *
		 * @type {WebXRManager}
		 */ this.xr = xr;
        /**
		 * Returns the rendering context.
		 *
		 * @return {WebGL2RenderingContext} The rendering context.
		 */ this.getContext = function() {
            return _gl;
        };
        /**
		 * Returns the rendering context attributes.
		 *
		 * @return {WebGLContextAttributes} The rendering context attributes.
		 */ this.getContextAttributes = function() {
            return _gl.getContextAttributes();
        };
        /**
		 * Simulates a loss of the WebGL context. This requires support for the `WEBGL_lose_context` extension.
		 */ this.forceContextLoss = function() {
            const extension = extensions.get('WEBGL_lose_context');
            if (extension) extension.loseContext();
        };
        /**
		 * Simulates a restore of the WebGL context. This requires support for the `WEBGL_lose_context` extension.
		 */ this.forceContextRestore = function() {
            const extension = extensions.get('WEBGL_lose_context');
            if (extension) extension.restoreContext();
        };
        /**
		 * Returns the pixel ratio.
		 *
		 * @return {number} The pixel ratio.
		 */ this.getPixelRatio = function() {
            return _pixelRatio;
        };
        /**
		 * Sets the given pixel ratio and resizes the canvas if necessary.
		 *
		 * @param {number} value - The pixel ratio.
		 */ this.setPixelRatio = function(value) {
            if (value === undefined) return;
            _pixelRatio = value;
            this.setSize(_width, _height, false);
        };
        /**
		 * Returns the renderer's size in logical pixels. This method does not honor the pixel ratio.
		 *
		 * @param {Vector2} target - The method writes the result in this target object.
		 * @return {Vector2} The renderer's size in logical pixels.
		 */ this.getSize = function(target) {
            return target.set(_width, _height);
        };
        /**
		 * Resizes the output canvas to (width, height) with device pixel ratio taken
		 * into account, and also sets the viewport to fit that size, starting in (0,
		 * 0). Setting `updateStyle` to false prevents any style changes to the output canvas.
		 *
		 * @param {number} width - The width in logical pixels.
		 * @param {number} height - The height in logical pixels.
		 * @param {boolean} [updateStyle=true] - Whether to update the `style` attribute of the canvas or not.
		 */ this.setSize = function(width, height, updateStyle = true) {
            if (xr.isPresenting) {
                (0, _threeCoreJs.warn)('WebGLRenderer: Can\'t change size while VR device is presenting.');
                return;
            }
            _width = width;
            _height = height;
            canvas.width = Math.floor(width * _pixelRatio);
            canvas.height = Math.floor(height * _pixelRatio);
            if (updateStyle === true) {
                canvas.style.width = width + 'px';
                canvas.style.height = height + 'px';
            }
            if (output !== null) output.setSize(canvas.width, canvas.height);
            this.setViewport(0, 0, width, height);
        };
        /**
		 * Returns the drawing buffer size in physical pixels. This method honors the pixel ratio.
		 *
		 * @param {Vector2} target - The method writes the result in this target object.
		 * @return {Vector2} The drawing buffer size.
		 */ this.getDrawingBufferSize = function(target) {
            return target.set(_width * _pixelRatio, _height * _pixelRatio).floor();
        };
        /**
		 * This method allows to define the drawing buffer size by specifying
		 * width, height and pixel ratio all at once. The size of the drawing
		 * buffer is computed with this formula:
		 * ```js
		 * size.x = width * pixelRatio;
		 * size.y = height * pixelRatio;
		 * ```
		 *
		 * @param {number} width - The width in logical pixels.
		 * @param {number} height - The height in logical pixels.
		 * @param {number} pixelRatio - The pixel ratio.
		 */ this.setDrawingBufferSize = function(width, height, pixelRatio) {
            _width = width;
            _height = height;
            _pixelRatio = pixelRatio;
            canvas.width = Math.floor(width * pixelRatio);
            canvas.height = Math.floor(height * pixelRatio);
            this.setViewport(0, 0, width, height);
        };
        /**
		 * Sets the post-processing effects to be applied after rendering.
		 *
		 * @param {Array} effects - An array of post-processing effects.
		 */ this.setEffects = function(effects) {
            if (_outputBufferType === (0, _threeCoreJs.UnsignedByteType)) {
                console.error('THREE.WebGLRenderer: setEffects() requires outputBufferType set to HalfFloatType or FloatType.');
                return;
            }
            if (effects) {
                for(let i = 0; i < effects.length; i++)if (effects[i].isOutputPass === true) {
                    console.warn('THREE.WebGLRenderer: OutputPass is not needed in setEffects(). Tone mapping and color space conversion are applied automatically.');
                    break;
                }
            }
            output.setEffects(effects || []);
        };
        /**
		 * Returns the current viewport definition.
		 *
		 * @param {Vector2} target - The method writes the result in this target object.
		 * @return {Vector2} The current viewport definition.
		 */ this.getCurrentViewport = function(target) {
            return target.copy(_currentViewport);
        };
        /**
		 * Returns the viewport definition.
		 *
		 * @param {Vector4} target - The method writes the result in this target object.
		 * @return {Vector4} The viewport definition.
		 */ this.getViewport = function(target) {
            return target.copy(_viewport);
        };
        /**
		 * Sets the viewport to render from `(x, y)` to `(x + width, y + height)`.
		 *
		 * @param {number | Vector4} x - The horizontal coordinate for the lower left corner of the viewport origin in logical pixel unit.
		 * Or alternatively a four-component vector specifying all the parameters of the viewport.
		 * @param {number} y - The vertical coordinate for the lower left corner of the viewport origin  in logical pixel unit.
		 * @param {number} width - The width of the viewport in logical pixel unit.
		 * @param {number} height - The height of the viewport in logical pixel unit.
		 */ this.setViewport = function(x, y, width, height) {
            if (x.isVector4) _viewport.set(x.x, x.y, x.z, x.w);
            else _viewport.set(x, y, width, height);
            state.viewport(_currentViewport.copy(_viewport).multiplyScalar(_pixelRatio).round());
        };
        /**
		 * Returns the scissor region.
		 *
		 * @param {Vector4} target - The method writes the result in this target object.
		 * @return {Vector4} The scissor region.
		 */ this.getScissor = function(target) {
            return target.copy(_scissor);
        };
        /**
		 * Sets the scissor region to render from `(x, y)` to `(x + width, y + height)`.
		 *
		 * @param {number | Vector4} x - The horizontal coordinate for the lower left corner of the scissor region origin in logical pixel unit.
		 * Or alternatively a four-component vector specifying all the parameters of the scissor region.
		 * @param {number} y - The vertical coordinate for the lower left corner of the scissor region origin  in logical pixel unit.
		 * @param {number} width - The width of the scissor region in logical pixel unit.
		 * @param {number} height - The height of the scissor region in logical pixel unit.
		 */ this.setScissor = function(x, y, width, height) {
            if (x.isVector4) _scissor.set(x.x, x.y, x.z, x.w);
            else _scissor.set(x, y, width, height);
            state.scissor(_currentScissor.copy(_scissor).multiplyScalar(_pixelRatio).round());
        };
        /**
		 * Returns `true` if the scissor test is enabled.
		 *
		 * @return {boolean} Whether the scissor test is enabled or not.
		 */ this.getScissorTest = function() {
            return _scissorTest;
        };
        /**
		 * Enable or disable the scissor test. When this is enabled, only the pixels
		 * within the defined scissor area will be affected by further renderer
		 * actions.
		 *
		 * @param {boolean} boolean - Whether the scissor test is enabled or not.
		 */ this.setScissorTest = function(boolean) {
            state.setScissorTest(_scissorTest = boolean);
        };
        /**
		 * Sets a custom opaque sort function for the render lists. Pass `null`
		 * to use the default `painterSortStable` function.
		 *
		 * @param {?Function} method - The opaque sort function.
		 */ this.setOpaqueSort = function(method) {
            _opaqueSort = method;
        };
        /**
		 * Sets a custom transparent sort function for the render lists. Pass `null`
		 * to use the default `reversePainterSortStable` function.
		 *
		 * @param {?Function} method - The opaque sort function.
		 */ this.setTransparentSort = function(method) {
            _transparentSort = method;
        };
        // Clearing
        /**
		 * Returns the clear color.
		 *
		 * @param {Color} target - The method writes the result in this target object.
		 * @return {Color} The clear color.
		 */ this.getClearColor = function(target) {
            return target.copy(background.getClearColor());
        };
        /**
		 * Sets the clear color and alpha.
		 *
		 * @param {Color} color - The clear color.
		 * @param {number} [alpha=1] - The clear alpha.
		 */ this.setClearColor = function() {
            background.setClearColor(...arguments);
        };
        /**
		 * Returns the clear alpha. Ranges within `[0,1]`.
		 *
		 * @return {number} The clear alpha.
		 */ this.getClearAlpha = function() {
            return background.getClearAlpha();
        };
        /**
		 * Sets the clear alpha.
		 *
		 * @param {number} alpha - The clear alpha.
		 */ this.setClearAlpha = function() {
            background.setClearAlpha(...arguments);
        };
        /**
		 * Tells the renderer to clear its color, depth or stencil drawing buffer(s).
		 * This method initializes the buffers to the current clear color values.
		 *
		 * @param {boolean} [color=true] - Whether the color buffer should be cleared or not.
		 * @param {boolean} [depth=true] - Whether the depth buffer should be cleared or not.
		 * @param {boolean} [stencil=true] - Whether the stencil buffer should be cleared or not.
		 */ this.clear = function(color = true, depth = true, stencil = true) {
            let bits = 0;
            if (color) {
                // check if we're trying to clear an integer target
                let isIntegerFormat = false;
                if (_currentRenderTarget !== null) {
                    const targetFormat = _currentRenderTarget.texture.format;
                    isIntegerFormat = INTEGER_FORMATS.has(targetFormat);
                }
                // use the appropriate clear functions to clear the target if it's a signed
                // or unsigned integer target
                if (isIntegerFormat) {
                    const targetType = _currentRenderTarget.texture.type;
                    const isUnsignedType = UNSIGNED_TYPES.has(targetType);
                    const clearColor = background.getClearColor();
                    const a = background.getClearAlpha();
                    const r = clearColor.r;
                    const g = clearColor.g;
                    const b = clearColor.b;
                    if (isUnsignedType) {
                        uintClearColor[0] = r;
                        uintClearColor[1] = g;
                        uintClearColor[2] = b;
                        uintClearColor[3] = a;
                        _gl.clearBufferuiv(_gl.COLOR, 0, uintClearColor);
                    } else {
                        intClearColor[0] = r;
                        intClearColor[1] = g;
                        intClearColor[2] = b;
                        intClearColor[3] = a;
                        _gl.clearBufferiv(_gl.COLOR, 0, intClearColor);
                    }
                } else bits |= _gl.COLOR_BUFFER_BIT;
            }
            if (depth) bits |= _gl.DEPTH_BUFFER_BIT;
            if (stencil) {
                bits |= _gl.STENCIL_BUFFER_BIT;
                this.state.buffers.stencil.setMask(0xffffffff);
            }
            _gl.clear(bits);
        };
        /**
		 * Clears the color buffer. Equivalent to calling `renderer.clear( true, false, false )`.
		 */ this.clearColor = function() {
            this.clear(true, false, false);
        };
        /**
		 * Clears the depth buffer. Equivalent to calling `renderer.clear( false, true, false )`.
		 */ this.clearDepth = function() {
            this.clear(false, true, false);
        };
        /**
		 * Clears the stencil buffer. Equivalent to calling `renderer.clear( false, false, true )`.
		 */ this.clearStencil = function() {
            this.clear(false, false, true);
        };
        /**
		 * Frees the GPU-related resources allocated by this instance. Call this
		 * method whenever this instance is no longer used in your app.
		 */ this.dispose = function() {
            canvas.removeEventListener('webglcontextlost', onContextLost, false);
            canvas.removeEventListener('webglcontextrestored', onContextRestore, false);
            canvas.removeEventListener('webglcontextcreationerror', onContextCreationError, false);
            background.dispose();
            renderLists.dispose();
            renderStates.dispose();
            properties.dispose();
            cubemaps.dispose();
            cubeuvmaps.dispose();
            objects.dispose();
            bindingStates.dispose();
            uniformsGroups.dispose();
            programCache.dispose();
            xr.dispose();
            xr.removeEventListener('sessionstart', onXRSessionStart);
            xr.removeEventListener('sessionend', onXRSessionEnd);
            animation.stop();
        };
        // Events
        function onContextLost(event) {
            event.preventDefault();
            (0, _threeCoreJs.log)('WebGLRenderer: Context Lost.');
            _isContextLost = true;
        }
        function onContextRestore() {
            (0, _threeCoreJs.log)('WebGLRenderer: Context Restored.');
            _isContextLost = false;
            const infoAutoReset = info.autoReset;
            const shadowMapEnabled = shadowMap.enabled;
            const shadowMapAutoUpdate = shadowMap.autoUpdate;
            const shadowMapNeedsUpdate = shadowMap.needsUpdate;
            const shadowMapType = shadowMap.type;
            initGLContext();
            info.autoReset = infoAutoReset;
            shadowMap.enabled = shadowMapEnabled;
            shadowMap.autoUpdate = shadowMapAutoUpdate;
            shadowMap.needsUpdate = shadowMapNeedsUpdate;
            shadowMap.type = shadowMapType;
        }
        function onContextCreationError(event) {
            (0, _threeCoreJs.error)('WebGLRenderer: A WebGL context could not be created. Reason: ', event.statusMessage);
        }
        function onMaterialDispose(event) {
            const material = event.target;
            material.removeEventListener('dispose', onMaterialDispose);
            deallocateMaterial(material);
        }
        // Buffer deallocation
        function deallocateMaterial(material) {
            releaseMaterialProgramReferences(material);
            properties.remove(material);
        }
        function releaseMaterialProgramReferences(material) {
            const programs = properties.get(material).programs;
            if (programs !== undefined) {
                programs.forEach(function(program) {
                    programCache.releaseProgram(program);
                });
                if (material.isShaderMaterial) programCache.releaseShaderCache(material);
            }
        }
        // Buffer rendering
        this.renderBufferDirect = function(camera, scene, geometry, material, object, group) {
            if (scene === null) scene = _emptyScene; // renderBufferDirect second parameter used to be fog (could be null)
            const frontFaceCW = object.isMesh && object.matrixWorld.determinant() < 0;
            const program = setProgram(camera, scene, geometry, material, object);
            state.setMaterial(material, frontFaceCW);
            //
            let index = geometry.index;
            let rangeFactor = 1;
            if (material.wireframe === true) {
                index = geometries.getWireframeAttribute(geometry);
                if (index === undefined) return;
                rangeFactor = 2;
            }
            //
            const drawRange = geometry.drawRange;
            const position = geometry.attributes.position;
            let drawStart = drawRange.start * rangeFactor;
            let drawEnd = (drawRange.start + drawRange.count) * rangeFactor;
            if (group !== null) {
                drawStart = Math.max(drawStart, group.start * rangeFactor);
                drawEnd = Math.min(drawEnd, (group.start + group.count) * rangeFactor);
            }
            if (index !== null) {
                drawStart = Math.max(drawStart, 0);
                drawEnd = Math.min(drawEnd, index.count);
            } else if (position !== undefined && position !== null) {
                drawStart = Math.max(drawStart, 0);
                drawEnd = Math.min(drawEnd, position.count);
            }
            const drawCount = drawEnd - drawStart;
            if (drawCount < 0 || drawCount === Infinity) return;
            //
            bindingStates.setup(object, material, program, geometry, index);
            let attribute;
            let renderer = bufferRenderer;
            if (index !== null) {
                attribute = attributes.get(index);
                renderer = indexedBufferRenderer;
                renderer.setIndex(attribute);
            }
            //
            if (object.isMesh) {
                if (material.wireframe === true) {
                    state.setLineWidth(material.wireframeLinewidth * getTargetPixelRatio());
                    renderer.setMode(_gl.LINES);
                } else renderer.setMode(_gl.TRIANGLES);
            } else if (object.isLine) {
                let lineWidth = material.linewidth;
                if (lineWidth === undefined) lineWidth = 1; // Not using Line*Material
                state.setLineWidth(lineWidth * getTargetPixelRatio());
                if (object.isLineSegments) renderer.setMode(_gl.LINES);
                else if (object.isLineLoop) renderer.setMode(_gl.LINE_LOOP);
                else renderer.setMode(_gl.LINE_STRIP);
            } else if (object.isPoints) renderer.setMode(_gl.POINTS);
            else if (object.isSprite) renderer.setMode(_gl.TRIANGLES);
            if (object.isBatchedMesh) {
                if (object._multiDrawInstances !== null) {
                    // @deprecated, r174
                    (0, _threeCoreJs.warnOnce)('WebGLRenderer: renderMultiDrawInstances has been deprecated and will be removed in r184. Append to renderMultiDraw arguments and use indirection.');
                    renderer.renderMultiDrawInstances(object._multiDrawStarts, object._multiDrawCounts, object._multiDrawCount, object._multiDrawInstances);
                } else if (!extensions.get('WEBGL_multi_draw')) {
                    const starts = object._multiDrawStarts;
                    const counts = object._multiDrawCounts;
                    const drawCount = object._multiDrawCount;
                    const bytesPerElement = index ? attributes.get(index).bytesPerElement : 1;
                    const uniforms = properties.get(material).currentProgram.getUniforms();
                    for(let i = 0; i < drawCount; i++){
                        uniforms.setValue(_gl, '_gl_DrawID', i);
                        renderer.render(starts[i] / bytesPerElement, counts[i]);
                    }
                } else renderer.renderMultiDraw(object._multiDrawStarts, object._multiDrawCounts, object._multiDrawCount);
            } else if (object.isInstancedMesh) renderer.renderInstances(drawStart, drawCount, object.count);
            else if (geometry.isInstancedBufferGeometry) {
                const maxInstanceCount = geometry._maxInstanceCount !== undefined ? geometry._maxInstanceCount : Infinity;
                const instanceCount = Math.min(geometry.instanceCount, maxInstanceCount);
                renderer.renderInstances(drawStart, drawCount, instanceCount);
            } else renderer.render(drawStart, drawCount);
        };
        // Compile
        function prepareMaterial(material, scene, object) {
            if (material.transparent === true && material.side === (0, _threeCoreJs.DoubleSide) && material.forceSinglePass === false) {
                material.side = (0, _threeCoreJs.BackSide);
                material.needsUpdate = true;
                getProgram(material, scene, object);
                material.side = (0, _threeCoreJs.FrontSide);
                material.needsUpdate = true;
                getProgram(material, scene, object);
                material.side = (0, _threeCoreJs.DoubleSide);
            } else getProgram(material, scene, object);
        }
        /**
		 * Compiles all materials in the scene with the camera. This is useful to precompile shaders
		 * before the first rendering. If you want to add a 3D object to an existing scene, use the third
		 * optional parameter for applying the target scene.
		 *
		 * Note that the (target) scene's lighting and environment must be configured before calling this method.
		 *
		 * @param {Object3D} scene - The scene or another type of 3D object to precompile.
		 * @param {Camera} camera - The camera.
		 * @param {?Scene} [targetScene=null] - The target scene.
		 * @return {Set<Material>} The precompiled materials.
		 */ this.compile = function(scene, camera, targetScene = null) {
            if (targetScene === null) targetScene = scene;
            currentRenderState = renderStates.get(targetScene);
            currentRenderState.init(camera);
            renderStateStack.push(currentRenderState);
            // gather lights from both the target scene and the new object that will be added to the scene.
            targetScene.traverseVisible(function(object) {
                if (object.isLight && object.layers.test(camera.layers)) {
                    currentRenderState.pushLight(object);
                    if (object.castShadow) currentRenderState.pushShadow(object);
                }
            });
            if (scene !== targetScene) scene.traverseVisible(function(object) {
                if (object.isLight && object.layers.test(camera.layers)) {
                    currentRenderState.pushLight(object);
                    if (object.castShadow) currentRenderState.pushShadow(object);
                }
            });
            currentRenderState.setupLights();
            // Only initialize materials in the new scene, not the targetScene.
            const materials = new Set();
            scene.traverse(function(object) {
                if (!(object.isMesh || object.isPoints || object.isLine || object.isSprite)) return;
                const material = object.material;
                if (material) {
                    if (Array.isArray(material)) for(let i = 0; i < material.length; i++){
                        const material2 = material[i];
                        prepareMaterial(material2, targetScene, object);
                        materials.add(material2);
                    }
                    else {
                        prepareMaterial(material, targetScene, object);
                        materials.add(material);
                    }
                }
            });
            currentRenderState = renderStateStack.pop();
            return materials;
        };
        // compileAsync
        /**
		 * Asynchronous version of {@link WebGLRenderer#compile}.
		 *
		 * This method makes use of the `KHR_parallel_shader_compile` WebGL extension. Hence,
		 * it is recommended to use this version of `compile()` whenever possible.
		 *
		 * @async
		 * @param {Object3D} scene - The scene or another type of 3D object to precompile.
		 * @param {Camera} camera - The camera.
		 * @param {?Scene} [targetScene=null] - The target scene.
		 * @return {Promise} A Promise that resolves when the given scene can be rendered without unnecessary stalling due to shader compilation.
		 */ this.compileAsync = function(scene, camera, targetScene = null) {
            const materials = this.compile(scene, camera, targetScene);
            // Wait for all the materials in the new object to indicate that they're
            // ready to be used before resolving the promise.
            return new Promise((resolve)=>{
                function checkMaterialsReady() {
                    materials.forEach(function(material) {
                        const materialProperties = properties.get(material);
                        const program = materialProperties.currentProgram;
                        if (program.isReady()) // remove any programs that report they're ready to use from the list
                        materials.delete(material);
                    });
                    // once the list of compiling materials is empty, call the callback
                    if (materials.size === 0) {
                        resolve(scene);
                        return;
                    }
                    // if some materials are still not ready, wait a bit and check again
                    setTimeout(checkMaterialsReady, 10);
                }
                if (extensions.get('KHR_parallel_shader_compile') !== null) // If we can check the compilation status of the materials without
                // blocking then do so right away.
                checkMaterialsReady();
                else // Otherwise start by waiting a bit to give the materials we just
                // initialized a chance to finish.
                setTimeout(checkMaterialsReady, 10);
            });
        };
        // Animation Loop
        let onAnimationFrameCallback = null;
        function onAnimationFrame(time) {
            if (onAnimationFrameCallback) onAnimationFrameCallback(time);
        }
        function onXRSessionStart() {
            animation.stop();
        }
        function onXRSessionEnd() {
            animation.start();
        }
        const animation = new WebGLAnimation();
        animation.setAnimationLoop(onAnimationFrame);
        if (typeof self !== 'undefined') animation.setContext(self);
        /**
		 * Applications are advised to always define the animation loop
		 * with this method and not manually with `requestAnimationFrame()`
		 * for best compatibility.
		 *
		 * @param {?onAnimationCallback} callback - The application's animation loop.
		 */ this.setAnimationLoop = function(callback) {
            onAnimationFrameCallback = callback;
            xr.setAnimationLoop(callback);
            callback === null ? animation.stop() : animation.start();
        };
        xr.addEventListener('sessionstart', onXRSessionStart);
        xr.addEventListener('sessionend', onXRSessionEnd);
        // Rendering
        /**
		 * Renders the given scene (or other type of 3D object) using the given camera.
		 *
		 * The render is done to a previously specified render target set by calling {@link WebGLRenderer#setRenderTarget}
		 * or to the canvas as usual.
		 *
		 * By default render buffers are cleared before rendering but you can prevent
		 * this by setting the property `autoClear` to `false`. If you want to prevent
		 * only certain buffers being cleared you can `autoClearColor`, `autoClearDepth`
		 * or `autoClearStencil` to `false`. To force a clear, use {@link WebGLRenderer#clear}.
		 *
		 * @param {Object3D} scene - The scene to render.
		 * @param {Camera} camera - The camera.
		 */ this.render = function(scene, camera) {
            if (camera !== undefined && camera.isCamera !== true) {
                (0, _threeCoreJs.error)('WebGLRenderer.render: camera is not an instance of THREE.Camera.');
                return;
            }
            if (_isContextLost === true) return;
            // use internal render target for HalfFloatType color buffer (only when tone mapping is enabled)
            const isXRPresenting = xr.enabled === true && xr.isPresenting === true;
            const useOutput = output !== null && (_currentRenderTarget === null || isXRPresenting) && output.begin(_this, _currentRenderTarget);
            // update scene graph
            if (scene.matrixWorldAutoUpdate === true) scene.updateMatrixWorld();
            // update camera matrices and frustum
            if (camera.parent === null && camera.matrixWorldAutoUpdate === true) camera.updateMatrixWorld();
            if (xr.enabled === true && xr.isPresenting === true && (output === null || output.isCompositing() === false)) {
                if (xr.cameraAutoUpdate === true) xr.updateCamera(camera);
                camera = xr.getCamera(); // use XR camera for rendering
            }
            //
            if (scene.isScene === true) scene.onBeforeRender(_this, scene, camera, _currentRenderTarget);
            currentRenderState = renderStates.get(scene, renderStateStack.length);
            currentRenderState.init(camera);
            renderStateStack.push(currentRenderState);
            _projScreenMatrix.multiplyMatrices(camera.projectionMatrix, camera.matrixWorldInverse);
            _frustum.setFromProjectionMatrix(_projScreenMatrix, (0, _threeCoreJs.WebGLCoordinateSystem), camera.reversedDepth);
            _localClippingEnabled = this.localClippingEnabled;
            _clippingEnabled = clipping.init(this.clippingPlanes, _localClippingEnabled);
            currentRenderList = renderLists.get(scene, renderListStack.length);
            currentRenderList.init();
            renderListStack.push(currentRenderList);
            if (xr.enabled === true && xr.isPresenting === true) {
                const depthSensingMesh = _this.xr.getDepthSensingMesh();
                if (depthSensingMesh !== null) projectObject(depthSensingMesh, camera, -Infinity, _this.sortObjects);
            }
            projectObject(scene, camera, 0, _this.sortObjects);
            currentRenderList.finish();
            if (_this.sortObjects === true) currentRenderList.sort(_opaqueSort, _transparentSort);
            _renderBackground = xr.enabled === false || xr.isPresenting === false || xr.hasDepthSensing() === false;
            if (_renderBackground) background.addToRenderList(currentRenderList, scene);
            //
            this.info.render.frame++;
            if (_clippingEnabled === true) clipping.beginShadows();
            const shadowsArray = currentRenderState.state.shadowsArray;
            shadowMap.render(shadowsArray, scene, camera);
            if (_clippingEnabled === true) clipping.endShadows();
            //
            if (this.info.autoReset === true) this.info.reset();
            // render scene (skip if first effect is a render pass - it will render the scene itself)
            const skipSceneRender = useOutput && output.hasRenderPass();
            if (skipSceneRender === false) {
                const opaqueObjects = currentRenderList.opaque;
                const transmissiveObjects = currentRenderList.transmissive;
                currentRenderState.setupLights();
                if (camera.isArrayCamera) {
                    const cameras = camera.cameras;
                    if (transmissiveObjects.length > 0) for(let i = 0, l = cameras.length; i < l; i++){
                        const camera2 = cameras[i];
                        renderTransmissionPass(opaqueObjects, transmissiveObjects, scene, camera2);
                    }
                    if (_renderBackground) background.render(scene);
                    for(let i = 0, l = cameras.length; i < l; i++){
                        const camera2 = cameras[i];
                        renderScene(currentRenderList, scene, camera2, camera2.viewport);
                    }
                } else {
                    if (transmissiveObjects.length > 0) renderTransmissionPass(opaqueObjects, transmissiveObjects, scene, camera);
                    if (_renderBackground) background.render(scene);
                    renderScene(currentRenderList, scene, camera);
                }
            }
            //
            if (_currentRenderTarget !== null && _currentActiveMipmapLevel === 0) {
                // resolve multisample renderbuffers to a single-sample texture if necessary
                textures.updateMultisampleRenderTarget(_currentRenderTarget);
                // Generate mipmap if we're using any kind of mipmap filtering
                textures.updateRenderTargetMipmap(_currentRenderTarget);
            }
            // copy from internal render target to canvas using fullscreen quad
            if (useOutput) output.end(_this);
            //
            if (scene.isScene === true) scene.onAfterRender(_this, scene, camera);
            // _gl.finish();
            bindingStates.resetDefaultState();
            _currentMaterialId = -1;
            _currentCamera = null;
            renderStateStack.pop();
            if (renderStateStack.length > 0) {
                currentRenderState = renderStateStack[renderStateStack.length - 1];
                if (_clippingEnabled === true) clipping.setGlobalState(_this.clippingPlanes, currentRenderState.state.camera);
            } else currentRenderState = null;
            renderListStack.pop();
            if (renderListStack.length > 0) currentRenderList = renderListStack[renderListStack.length - 1];
            else currentRenderList = null;
        };
        function projectObject(object, camera, groupOrder, sortObjects) {
            if (object.visible === false) return;
            const visible = object.layers.test(camera.layers);
            if (visible) {
                if (object.isGroup) groupOrder = object.renderOrder;
                else if (object.isLOD) {
                    if (object.autoUpdate === true) object.update(camera);
                } else if (object.isLight) {
                    currentRenderState.pushLight(object);
                    if (object.castShadow) currentRenderState.pushShadow(object);
                } else if (object.isSprite) {
                    if (!object.frustumCulled || _frustum.intersectsSprite(object)) {
                        if (sortObjects) _vector4.setFromMatrixPosition(object.matrixWorld).applyMatrix4(_projScreenMatrix);
                        const geometry = objects.update(object);
                        const material = object.material;
                        if (material.visible) currentRenderList.push(object, geometry, material, groupOrder, _vector4.z, null);
                    }
                } else if (object.isMesh || object.isLine || object.isPoints) {
                    if (!object.frustumCulled || _frustum.intersectsObject(object)) {
                        const geometry = objects.update(object);
                        const material = object.material;
                        if (sortObjects) {
                            if (object.boundingSphere !== undefined) {
                                if (object.boundingSphere === null) object.computeBoundingSphere();
                                _vector4.copy(object.boundingSphere.center);
                            } else {
                                if (geometry.boundingSphere === null) geometry.computeBoundingSphere();
                                _vector4.copy(geometry.boundingSphere.center);
                            }
                            _vector4.applyMatrix4(object.matrixWorld).applyMatrix4(_projScreenMatrix);
                        }
                        if (Array.isArray(material)) {
                            const groups = geometry.groups;
                            for(let i = 0, l = groups.length; i < l; i++){
                                const group = groups[i];
                                const groupMaterial = material[group.materialIndex];
                                if (groupMaterial && groupMaterial.visible) currentRenderList.push(object, geometry, groupMaterial, groupOrder, _vector4.z, group);
                            }
                        } else if (material.visible) currentRenderList.push(object, geometry, material, groupOrder, _vector4.z, null);
                    }
                }
            }
            const children = object.children;
            for(let i = 0, l = children.length; i < l; i++)projectObject(children[i], camera, groupOrder, sortObjects);
        }
        function renderScene(currentRenderList, scene, camera, viewport) {
            const { opaque: opaqueObjects, transmissive: transmissiveObjects, transparent: transparentObjects } = currentRenderList;
            currentRenderState.setupLightsView(camera);
            if (_clippingEnabled === true) clipping.setGlobalState(_this.clippingPlanes, camera);
            if (viewport) state.viewport(_currentViewport.copy(viewport));
            if (opaqueObjects.length > 0) renderObjects(opaqueObjects, scene, camera);
            if (transmissiveObjects.length > 0) renderObjects(transmissiveObjects, scene, camera);
            if (transparentObjects.length > 0) renderObjects(transparentObjects, scene, camera);
            // Ensure depth buffer writing is enabled so it can be cleared on next render
            state.buffers.depth.setTest(true);
            state.buffers.depth.setMask(true);
            state.buffers.color.setMask(true);
            state.setPolygonOffset(false);
        }
        function renderTransmissionPass(opaqueObjects, transmissiveObjects, scene, camera) {
            const overrideMaterial = scene.isScene === true ? scene.overrideMaterial : null;
            if (overrideMaterial !== null) return;
            if (currentRenderState.state.transmissionRenderTarget[camera.id] === undefined) {
                const hasHalfFloatSupport = extensions.has('EXT_color_buffer_half_float') || extensions.has('EXT_color_buffer_float');
                currentRenderState.state.transmissionRenderTarget[camera.id] = new (0, _threeCoreJs.WebGLRenderTarget)(1, 1, {
                    generateMipmaps: true,
                    type: hasHalfFloatSupport ? (0, _threeCoreJs.HalfFloatType) : (0, _threeCoreJs.UnsignedByteType),
                    minFilter: (0, _threeCoreJs.LinearMipmapLinearFilter),
                    samples: capabilities.samples,
                    stencilBuffer: stencil,
                    resolveDepthBuffer: false,
                    resolveStencilBuffer: false,
                    colorSpace: (0, _threeCoreJs.ColorManagement).workingColorSpace
                });
            // debug
            /*
				const geometry = new PlaneGeometry();
				const material = new MeshBasicMaterial( { map: _transmissionRenderTarget.texture } );

				const mesh = new Mesh( geometry, material );
				scene.add( mesh );
				*/ }
            const transmissionRenderTarget = currentRenderState.state.transmissionRenderTarget[camera.id];
            const activeViewport = camera.viewport || _currentViewport;
            transmissionRenderTarget.setSize(activeViewport.z * _this.transmissionResolutionScale, activeViewport.w * _this.transmissionResolutionScale);
            //
            const currentRenderTarget = _this.getRenderTarget();
            const currentActiveCubeFace = _this.getActiveCubeFace();
            const currentActiveMipmapLevel = _this.getActiveMipmapLevel();
            _this.setRenderTarget(transmissionRenderTarget);
            _this.getClearColor(_currentClearColor);
            _currentClearAlpha = _this.getClearAlpha();
            if (_currentClearAlpha < 1) _this.setClearColor(0xffffff, 0.5);
            _this.clear();
            if (_renderBackground) background.render(scene);
            // Turn off the features which can affect the frag color for opaque objects pass.
            // Otherwise they are applied twice in opaque objects pass and transmission objects pass.
            const currentToneMapping = _this.toneMapping;
            _this.toneMapping = (0, _threeCoreJs.NoToneMapping);
            // Remove viewport from camera to avoid nested render calls resetting viewport to it (e.g Reflector).
            // Transmission render pass requires viewport to match the transmissionRenderTarget.
            const currentCameraViewport = camera.viewport;
            if (camera.viewport !== undefined) camera.viewport = undefined;
            currentRenderState.setupLightsView(camera);
            if (_clippingEnabled === true) clipping.setGlobalState(_this.clippingPlanes, camera);
            renderObjects(opaqueObjects, scene, camera);
            textures.updateMultisampleRenderTarget(transmissionRenderTarget);
            textures.updateRenderTargetMipmap(transmissionRenderTarget);
            if (extensions.has('WEBGL_multisampled_render_to_texture') === false) {
                let renderTargetNeedsUpdate = false;
                for(let i = 0, l = transmissiveObjects.length; i < l; i++){
                    const renderItem = transmissiveObjects[i];
                    const { object, geometry, material, group } = renderItem;
                    if (material.side === (0, _threeCoreJs.DoubleSide) && object.layers.test(camera.layers)) {
                        const currentSide = material.side;
                        material.side = (0, _threeCoreJs.BackSide);
                        material.needsUpdate = true;
                        renderObject(object, scene, camera, geometry, material, group);
                        material.side = currentSide;
                        material.needsUpdate = true;
                        renderTargetNeedsUpdate = true;
                    }
                }
                if (renderTargetNeedsUpdate === true) {
                    textures.updateMultisampleRenderTarget(transmissionRenderTarget);
                    textures.updateRenderTargetMipmap(transmissionRenderTarget);
                }
            }
            _this.setRenderTarget(currentRenderTarget, currentActiveCubeFace, currentActiveMipmapLevel);
            _this.setClearColor(_currentClearColor, _currentClearAlpha);
            if (currentCameraViewport !== undefined) camera.viewport = currentCameraViewport;
            _this.toneMapping = currentToneMapping;
        }
        function renderObjects(renderList, scene, camera) {
            const overrideMaterial = scene.isScene === true ? scene.overrideMaterial : null;
            for(let i = 0, l = renderList.length; i < l; i++){
                const renderItem = renderList[i];
                const { object, geometry, group } = renderItem;
                let material = renderItem.material;
                if (material.allowOverride === true && overrideMaterial !== null) material = overrideMaterial;
                if (object.layers.test(camera.layers)) renderObject(object, scene, camera, geometry, material, group);
            }
        }
        function renderObject(object, scene, camera, geometry, material, group) {
            object.onBeforeRender(_this, scene, camera, geometry, material, group);
            object.modelViewMatrix.multiplyMatrices(camera.matrixWorldInverse, object.matrixWorld);
            object.normalMatrix.getNormalMatrix(object.modelViewMatrix);
            material.onBeforeRender(_this, scene, camera, geometry, object, group);
            if (material.transparent === true && material.side === (0, _threeCoreJs.DoubleSide) && material.forceSinglePass === false) {
                material.side = (0, _threeCoreJs.BackSide);
                material.needsUpdate = true;
                _this.renderBufferDirect(camera, scene, geometry, material, object, group);
                material.side = (0, _threeCoreJs.FrontSide);
                material.needsUpdate = true;
                _this.renderBufferDirect(camera, scene, geometry, material, object, group);
                material.side = (0, _threeCoreJs.DoubleSide);
            } else _this.renderBufferDirect(camera, scene, geometry, material, object, group);
            object.onAfterRender(_this, scene, camera, geometry, material, group);
        }
        function getProgram(material, scene, object) {
            if (scene.isScene !== true) scene = _emptyScene; // scene could be a Mesh, Line, Points, ...
            const materialProperties = properties.get(material);
            const lights = currentRenderState.state.lights;
            const shadowsArray = currentRenderState.state.shadowsArray;
            const lightsStateVersion = lights.state.version;
            const parameters = programCache.getParameters(material, lights.state, shadowsArray, scene, object);
            const programCacheKey = programCache.getProgramCacheKey(parameters);
            let programs = materialProperties.programs;
            // always update environment and fog - changing these trigger an getProgram call, but it's possible that the program doesn't change
            materialProperties.environment = material.isMeshStandardMaterial ? scene.environment : null;
            materialProperties.fog = scene.fog;
            materialProperties.envMap = (material.isMeshStandardMaterial ? cubeuvmaps : cubemaps).get(material.envMap || materialProperties.environment);
            materialProperties.envMapRotation = materialProperties.environment !== null && material.envMap === null ? scene.environmentRotation : material.envMapRotation;
            if (programs === undefined) {
                // new material
                material.addEventListener('dispose', onMaterialDispose);
                programs = new Map();
                materialProperties.programs = programs;
            }
            let program = programs.get(programCacheKey);
            if (program !== undefined) // early out if program and light state is identical
            {
                if (materialProperties.currentProgram === program && materialProperties.lightsStateVersion === lightsStateVersion) {
                    updateCommonMaterialProperties(material, parameters);
                    return program;
                }
            } else {
                parameters.uniforms = programCache.getUniforms(material);
                material.onBeforeCompile(parameters, _this);
                program = programCache.acquireProgram(parameters, programCacheKey);
                programs.set(programCacheKey, program);
                materialProperties.uniforms = parameters.uniforms;
            }
            const uniforms = materialProperties.uniforms;
            if (!material.isShaderMaterial && !material.isRawShaderMaterial || material.clipping === true) uniforms.clippingPlanes = clipping.uniform;
            updateCommonMaterialProperties(material, parameters);
            // store the light setup it was created for
            materialProperties.needsLights = materialNeedsLights(material);
            materialProperties.lightsStateVersion = lightsStateVersion;
            if (materialProperties.needsLights) {
                // wire up the material to this renderer's lighting state
                uniforms.ambientLightColor.value = lights.state.ambient;
                uniforms.lightProbe.value = lights.state.probe;
                uniforms.directionalLights.value = lights.state.directional;
                uniforms.directionalLightShadows.value = lights.state.directionalShadow;
                uniforms.spotLights.value = lights.state.spot;
                uniforms.spotLightShadows.value = lights.state.spotShadow;
                uniforms.rectAreaLights.value = lights.state.rectArea;
                uniforms.ltc_1.value = lights.state.rectAreaLTC1;
                uniforms.ltc_2.value = lights.state.rectAreaLTC2;
                uniforms.pointLights.value = lights.state.point;
                uniforms.pointLightShadows.value = lights.state.pointShadow;
                uniforms.hemisphereLights.value = lights.state.hemi;
                uniforms.directionalShadowMap.value = lights.state.directionalShadowMap;
                uniforms.directionalShadowMatrix.value = lights.state.directionalShadowMatrix;
                uniforms.spotShadowMap.value = lights.state.spotShadowMap;
                uniforms.spotLightMatrix.value = lights.state.spotLightMatrix;
                uniforms.spotLightMap.value = lights.state.spotLightMap;
                uniforms.pointShadowMap.value = lights.state.pointShadowMap;
                uniforms.pointShadowMatrix.value = lights.state.pointShadowMatrix;
            // TODO (abelnation): add area lights shadow info to uniforms
            }
            materialProperties.currentProgram = program;
            materialProperties.uniformsList = null;
            return program;
        }
        function getUniformList(materialProperties) {
            if (materialProperties.uniformsList === null) {
                const progUniforms = materialProperties.currentProgram.getUniforms();
                materialProperties.uniformsList = WebGLUniforms.seqWithValue(progUniforms.seq, materialProperties.uniforms);
            }
            return materialProperties.uniformsList;
        }
        function updateCommonMaterialProperties(material, parameters) {
            const materialProperties = properties.get(material);
            materialProperties.outputColorSpace = parameters.outputColorSpace;
            materialProperties.batching = parameters.batching;
            materialProperties.batchingColor = parameters.batchingColor;
            materialProperties.instancing = parameters.instancing;
            materialProperties.instancingColor = parameters.instancingColor;
            materialProperties.instancingMorph = parameters.instancingMorph;
            materialProperties.skinning = parameters.skinning;
            materialProperties.morphTargets = parameters.morphTargets;
            materialProperties.morphNormals = parameters.morphNormals;
            materialProperties.morphColors = parameters.morphColors;
            materialProperties.morphTargetsCount = parameters.morphTargetsCount;
            materialProperties.numClippingPlanes = parameters.numClippingPlanes;
            materialProperties.numIntersection = parameters.numClipIntersection;
            materialProperties.vertexAlphas = parameters.vertexAlphas;
            materialProperties.vertexTangents = parameters.vertexTangents;
            materialProperties.toneMapping = parameters.toneMapping;
        }
        function setProgram(camera, scene, geometry, material, object) {
            if (scene.isScene !== true) scene = _emptyScene; // scene could be a Mesh, Line, Points, ...
            textures.resetTextureUnits();
            const fog = scene.fog;
            const environment = material.isMeshStandardMaterial ? scene.environment : null;
            const colorSpace = _currentRenderTarget === null ? _this.outputColorSpace : _currentRenderTarget.isXRRenderTarget === true ? _currentRenderTarget.texture.colorSpace : (0, _threeCoreJs.LinearSRGBColorSpace);
            const envMap = (material.isMeshStandardMaterial ? cubeuvmaps : cubemaps).get(material.envMap || environment);
            const vertexAlphas = material.vertexColors === true && !!geometry.attributes.color && geometry.attributes.color.itemSize === 4;
            const vertexTangents = !!geometry.attributes.tangent && (!!material.normalMap || material.anisotropy > 0);
            const morphTargets = !!geometry.morphAttributes.position;
            const morphNormals = !!geometry.morphAttributes.normal;
            const morphColors = !!geometry.morphAttributes.color;
            let toneMapping = (0, _threeCoreJs.NoToneMapping);
            if (material.toneMapped) {
                if (_currentRenderTarget === null || _currentRenderTarget.isXRRenderTarget === true) toneMapping = _this.toneMapping;
            }
            const morphAttribute = geometry.morphAttributes.position || geometry.morphAttributes.normal || geometry.morphAttributes.color;
            const morphTargetsCount = morphAttribute !== undefined ? morphAttribute.length : 0;
            const materialProperties = properties.get(material);
            const lights = currentRenderState.state.lights;
            if (_clippingEnabled === true) {
                if (_localClippingEnabled === true || camera !== _currentCamera) {
                    const useCache = camera === _currentCamera && material.id === _currentMaterialId;
                    // we might want to call this function with some ClippingGroup
                    // object instead of the material, once it becomes feasible
                    // (#8465, #8379)
                    clipping.setState(material, camera, useCache);
                }
            }
            //
            let needsProgramChange = false;
            if (material.version === materialProperties.__version) {
                if (materialProperties.needsLights && materialProperties.lightsStateVersion !== lights.state.version) needsProgramChange = true;
                else if (materialProperties.outputColorSpace !== colorSpace) needsProgramChange = true;
                else if (object.isBatchedMesh && materialProperties.batching === false) needsProgramChange = true;
                else if (!object.isBatchedMesh && materialProperties.batching === true) needsProgramChange = true;
                else if (object.isBatchedMesh && materialProperties.batchingColor === true && object.colorTexture === null) needsProgramChange = true;
                else if (object.isBatchedMesh && materialProperties.batchingColor === false && object.colorTexture !== null) needsProgramChange = true;
                else if (object.isInstancedMesh && materialProperties.instancing === false) needsProgramChange = true;
                else if (!object.isInstancedMesh && materialProperties.instancing === true) needsProgramChange = true;
                else if (object.isSkinnedMesh && materialProperties.skinning === false) needsProgramChange = true;
                else if (!object.isSkinnedMesh && materialProperties.skinning === true) needsProgramChange = true;
                else if (object.isInstancedMesh && materialProperties.instancingColor === true && object.instanceColor === null) needsProgramChange = true;
                else if (object.isInstancedMesh && materialProperties.instancingColor === false && object.instanceColor !== null) needsProgramChange = true;
                else if (object.isInstancedMesh && materialProperties.instancingMorph === true && object.morphTexture === null) needsProgramChange = true;
                else if (object.isInstancedMesh && materialProperties.instancingMorph === false && object.morphTexture !== null) needsProgramChange = true;
                else if (materialProperties.envMap !== envMap) needsProgramChange = true;
                else if (material.fog === true && materialProperties.fog !== fog) needsProgramChange = true;
                else if (materialProperties.numClippingPlanes !== undefined && (materialProperties.numClippingPlanes !== clipping.numPlanes || materialProperties.numIntersection !== clipping.numIntersection)) needsProgramChange = true;
                else if (materialProperties.vertexAlphas !== vertexAlphas) needsProgramChange = true;
                else if (materialProperties.vertexTangents !== vertexTangents) needsProgramChange = true;
                else if (materialProperties.morphTargets !== morphTargets) needsProgramChange = true;
                else if (materialProperties.morphNormals !== morphNormals) needsProgramChange = true;
                else if (materialProperties.morphColors !== morphColors) needsProgramChange = true;
                else if (materialProperties.toneMapping !== toneMapping) needsProgramChange = true;
                else if (materialProperties.morphTargetsCount !== morphTargetsCount) needsProgramChange = true;
            } else {
                needsProgramChange = true;
                materialProperties.__version = material.version;
            }
            //
            let program = materialProperties.currentProgram;
            if (needsProgramChange === true) program = getProgram(material, scene, object);
            let refreshProgram = false;
            let refreshMaterial = false;
            let refreshLights = false;
            const p_uniforms = program.getUniforms(), m_uniforms = materialProperties.uniforms;
            if (state.useProgram(program.program)) {
                refreshProgram = true;
                refreshMaterial = true;
                refreshLights = true;
            }
            if (material.id !== _currentMaterialId) {
                _currentMaterialId = material.id;
                refreshMaterial = true;
            }
            if (refreshProgram || _currentCamera !== camera) {
                // common camera uniforms
                const reversedDepthBuffer = state.buffers.depth.getReversed();
                if (reversedDepthBuffer && camera.reversedDepth !== true) {
                    camera._reversedDepth = true;
                    camera.updateProjectionMatrix();
                }
                p_uniforms.setValue(_gl, 'projectionMatrix', camera.projectionMatrix);
                p_uniforms.setValue(_gl, 'viewMatrix', camera.matrixWorldInverse);
                const uCamPos = p_uniforms.map.cameraPosition;
                if (uCamPos !== undefined) uCamPos.setValue(_gl, _vector3.setFromMatrixPosition(camera.matrixWorld));
                if (capabilities.logarithmicDepthBuffer) p_uniforms.setValue(_gl, 'logDepthBufFC', 2.0 / (Math.log(camera.far + 1.0) / Math.LN2));
                // consider moving isOrthographic to UniformLib and WebGLMaterials, see https://github.com/mrdoob/three.js/pull/26467#issuecomment-1645185067
                if (material.isMeshPhongMaterial || material.isMeshToonMaterial || material.isMeshLambertMaterial || material.isMeshBasicMaterial || material.isMeshStandardMaterial || material.isShaderMaterial) p_uniforms.setValue(_gl, 'isOrthographic', camera.isOrthographicCamera === true);
                if (_currentCamera !== camera) {
                    _currentCamera = camera;
                    // lighting uniforms depend on the camera so enforce an update
                    // now, in case this material supports lights - or later, when
                    // the next material that does gets activated:
                    refreshMaterial = true; // set to true on material change
                    refreshLights = true; // remains set until update done
                }
            }
            // Pre-allocate texture units for shadow samplers before setting data textures
            if (materialProperties.needsLights) {
                // Set shadow map uniforms first to ensure they get the first texture units
                if (lights.state.directionalShadowMap.length > 0) p_uniforms.setValue(_gl, 'directionalShadowMap', lights.state.directionalShadowMap, textures);
                if (lights.state.spotShadowMap.length > 0) p_uniforms.setValue(_gl, 'spotShadowMap', lights.state.spotShadowMap, textures);
                if (lights.state.pointShadowMap.length > 0) p_uniforms.setValue(_gl, 'pointShadowMap', lights.state.pointShadowMap, textures);
            }
            // skinning and morph target uniforms must be set even if material didn't change
            // auto-setting of texture unit for bone and morph texture must go before other textures
            // otherwise textures used for skinning and morphing can take over texture units reserved for other material textures
            if (object.isSkinnedMesh) {
                p_uniforms.setOptional(_gl, object, 'bindMatrix');
                p_uniforms.setOptional(_gl, object, 'bindMatrixInverse');
                const skeleton = object.skeleton;
                if (skeleton) {
                    if (skeleton.boneTexture === null) skeleton.computeBoneTexture();
                    p_uniforms.setValue(_gl, 'boneTexture', skeleton.boneTexture, textures);
                }
            }
            if (object.isBatchedMesh) {
                p_uniforms.setOptional(_gl, object, 'batchingTexture');
                p_uniforms.setValue(_gl, 'batchingTexture', object._matricesTexture, textures);
                p_uniforms.setOptional(_gl, object, 'batchingIdTexture');
                p_uniforms.setValue(_gl, 'batchingIdTexture', object._indirectTexture, textures);
                p_uniforms.setOptional(_gl, object, 'batchingColorTexture');
                if (object._colorsTexture !== null) p_uniforms.setValue(_gl, 'batchingColorTexture', object._colorsTexture, textures);
            }
            const morphAttributes = geometry.morphAttributes;
            if (morphAttributes.position !== undefined || morphAttributes.normal !== undefined || morphAttributes.color !== undefined) morphtargets.update(object, geometry, program);
            if (refreshMaterial || materialProperties.receiveShadow !== object.receiveShadow) {
                materialProperties.receiveShadow = object.receiveShadow;
                p_uniforms.setValue(_gl, 'receiveShadow', object.receiveShadow);
            }
            // https://github.com/mrdoob/three.js/pull/24467#issuecomment-1209031512
            if (material.isMeshGouraudMaterial && material.envMap !== null) {
                m_uniforms.envMap.value = envMap;
                m_uniforms.flipEnvMap.value = envMap.isCubeTexture && envMap.isRenderTargetTexture === false ? -1 : 1;
            }
            if (material.isMeshStandardMaterial && material.envMap === null && scene.environment !== null) m_uniforms.envMapIntensity.value = scene.environmentIntensity;
            // Set DFG LUT for physically-based materials
            if (m_uniforms.dfgLUT !== undefined) m_uniforms.dfgLUT.value = getDFGLUT();
            if (refreshMaterial) {
                p_uniforms.setValue(_gl, 'toneMappingExposure', _this.toneMappingExposure);
                if (materialProperties.needsLights) // the current material requires lighting info
                // note: all lighting uniforms are always set correctly
                // they simply reference the renderer's state for their
                // values
                //
                // use the current material's .needsUpdate flags to set
                // the GL state when required
                markUniformsLightsNeedsUpdate(m_uniforms, refreshLights);
                // refresh uniforms common to several materials
                if (fog && material.fog === true) materials.refreshFogUniforms(m_uniforms, fog);
                materials.refreshMaterialUniforms(m_uniforms, material, _pixelRatio, _height, currentRenderState.state.transmissionRenderTarget[camera.id]);
                WebGLUniforms.upload(_gl, getUniformList(materialProperties), m_uniforms, textures);
            }
            if (material.isShaderMaterial && material.uniformsNeedUpdate === true) {
                WebGLUniforms.upload(_gl, getUniformList(materialProperties), m_uniforms, textures);
                material.uniformsNeedUpdate = false;
            }
            if (material.isSpriteMaterial) p_uniforms.setValue(_gl, 'center', object.center);
            // common matrices
            p_uniforms.setValue(_gl, 'modelViewMatrix', object.modelViewMatrix);
            p_uniforms.setValue(_gl, 'normalMatrix', object.normalMatrix);
            p_uniforms.setValue(_gl, 'modelMatrix', object.matrixWorld);
            // UBOs
            if (material.isShaderMaterial || material.isRawShaderMaterial) {
                const groups = material.uniformsGroups;
                for(let i = 0, l = groups.length; i < l; i++){
                    const group = groups[i];
                    uniformsGroups.update(group, program);
                    uniformsGroups.bind(group, program);
                }
            }
            return program;
        }
        // If uniforms are marked as clean, they don't need to be loaded to the GPU.
        function markUniformsLightsNeedsUpdate(uniforms, value) {
            uniforms.ambientLightColor.needsUpdate = value;
            uniforms.lightProbe.needsUpdate = value;
            uniforms.directionalLights.needsUpdate = value;
            uniforms.directionalLightShadows.needsUpdate = value;
            uniforms.pointLights.needsUpdate = value;
            uniforms.pointLightShadows.needsUpdate = value;
            uniforms.spotLights.needsUpdate = value;
            uniforms.spotLightShadows.needsUpdate = value;
            uniforms.rectAreaLights.needsUpdate = value;
            uniforms.hemisphereLights.needsUpdate = value;
        }
        function materialNeedsLights(material) {
            return material.isMeshLambertMaterial || material.isMeshToonMaterial || material.isMeshPhongMaterial || material.isMeshStandardMaterial || material.isShadowMaterial || material.isShaderMaterial && material.lights === true;
        }
        /**
		 * Returns the active cube face.
		 *
		 * @return {number} The active cube face.
		 */ this.getActiveCubeFace = function() {
            return _currentActiveCubeFace;
        };
        /**
		 * Returns the active mipmap level.
		 *
		 * @return {number} The active mipmap level.
		 */ this.getActiveMipmapLevel = function() {
            return _currentActiveMipmapLevel;
        };
        /**
		 * Returns the active render target.
		 *
		 * @return {?WebGLRenderTarget} The active render target. Returns `null` if no render target
		 * is currently set.
		 */ this.getRenderTarget = function() {
            return _currentRenderTarget;
        };
        this.setRenderTargetTextures = function(renderTarget, colorTexture, depthTexture) {
            const renderTargetProperties = properties.get(renderTarget);
            renderTargetProperties.__autoAllocateDepthBuffer = renderTarget.resolveDepthBuffer === false;
            if (renderTargetProperties.__autoAllocateDepthBuffer === false) // The multisample_render_to_texture extension doesn't work properly if there
            // are midframe flushes and an external depth buffer. Disable use of the extension.
            renderTargetProperties.__useRenderToTexture = false;
            properties.get(renderTarget.texture).__webglTexture = colorTexture;
            properties.get(renderTarget.depthTexture).__webglTexture = renderTargetProperties.__autoAllocateDepthBuffer ? undefined : depthTexture;
            renderTargetProperties.__hasExternalTextures = true;
        };
        this.setRenderTargetFramebuffer = function(renderTarget, defaultFramebuffer) {
            const renderTargetProperties = properties.get(renderTarget);
            renderTargetProperties.__webglFramebuffer = defaultFramebuffer;
            renderTargetProperties.__useDefaultFramebuffer = defaultFramebuffer === undefined;
        };
        const _scratchFrameBuffer = _gl.createFramebuffer();
        /**
		 * Sets the active rendertarget.
		 *
		 * @param {?WebGLRenderTarget} renderTarget - The render target to set. When `null` is given,
		 * the canvas is set as the active render target instead.
		 * @param {number} [activeCubeFace=0] - The active cube face when using a cube render target.
		 * Indicates the z layer to render in to when using 3D or array render targets.
		 * @param {number} [activeMipmapLevel=0] - The active mipmap level.
		 */ this.setRenderTarget = function(renderTarget, activeCubeFace = 0, activeMipmapLevel = 0) {
            _currentRenderTarget = renderTarget;
            _currentActiveCubeFace = activeCubeFace;
            _currentActiveMipmapLevel = activeMipmapLevel;
            let framebuffer = null;
            let isCube = false;
            let isRenderTarget3D = false;
            if (renderTarget) {
                const renderTargetProperties = properties.get(renderTarget);
                if (renderTargetProperties.__useDefaultFramebuffer !== undefined) {
                    // Externally-managed framebuffer (e.g. XR)
                    // Bind to the stored framebuffer (may be null for default, or a WebGLFramebuffer)
                    state.bindFramebuffer(_gl.FRAMEBUFFER, renderTargetProperties.__webglFramebuffer);
                    _currentViewport.copy(renderTarget.viewport);
                    _currentScissor.copy(renderTarget.scissor);
                    _currentScissorTest = renderTarget.scissorTest;
                    state.viewport(_currentViewport);
                    state.scissor(_currentScissor);
                    state.setScissorTest(_currentScissorTest);
                    _currentMaterialId = -1;
                    return;
                } else if (renderTargetProperties.__webglFramebuffer === undefined) textures.setupRenderTarget(renderTarget);
                else if (renderTargetProperties.__hasExternalTextures) // Color and depth texture must be rebound in order for the swapchain to update.
                textures.rebindTextures(renderTarget, properties.get(renderTarget.texture).__webglTexture, properties.get(renderTarget.depthTexture).__webglTexture);
                else if (renderTarget.depthBuffer) {
                    // check if the depth texture is already bound to the frame buffer and that it's been initialized
                    const depthTexture = renderTarget.depthTexture;
                    if (renderTargetProperties.__boundDepthTexture !== depthTexture) {
                        // check if the depth texture is compatible
                        if (depthTexture !== null && properties.has(depthTexture) && (renderTarget.width !== depthTexture.image.width || renderTarget.height !== depthTexture.image.height)) throw new Error('WebGLRenderTarget: Attached DepthTexture is initialized to the incorrect size.');
                        // Swap the depth buffer to the currently attached one
                        textures.setupDepthRenderbuffer(renderTarget);
                    }
                }
                const texture = renderTarget.texture;
                if (texture.isData3DTexture || texture.isDataArrayTexture || texture.isCompressedArrayTexture) isRenderTarget3D = true;
                const __webglFramebuffer = properties.get(renderTarget).__webglFramebuffer;
                if (renderTarget.isWebGLCubeRenderTarget) {
                    if (Array.isArray(__webglFramebuffer[activeCubeFace])) framebuffer = __webglFramebuffer[activeCubeFace][activeMipmapLevel];
                    else framebuffer = __webglFramebuffer[activeCubeFace];
                    isCube = true;
                } else if (renderTarget.samples > 0 && textures.useMultisampledRTT(renderTarget) === false) framebuffer = properties.get(renderTarget).__webglMultisampledFramebuffer;
                else if (Array.isArray(__webglFramebuffer)) framebuffer = __webglFramebuffer[activeMipmapLevel];
                else framebuffer = __webglFramebuffer;
                _currentViewport.copy(renderTarget.viewport);
                _currentScissor.copy(renderTarget.scissor);
                _currentScissorTest = renderTarget.scissorTest;
            } else {
                _currentViewport.copy(_viewport).multiplyScalar(_pixelRatio).floor();
                _currentScissor.copy(_scissor).multiplyScalar(_pixelRatio).floor();
                _currentScissorTest = _scissorTest;
            }
            // Use a scratch frame buffer if rendering to a mip level to avoid depth buffers
            // being bound that are different sizes.
            if (activeMipmapLevel !== 0) framebuffer = _scratchFrameBuffer;
            const framebufferBound = state.bindFramebuffer(_gl.FRAMEBUFFER, framebuffer);
            if (framebufferBound) state.drawBuffers(renderTarget, framebuffer);
            state.viewport(_currentViewport);
            state.scissor(_currentScissor);
            state.setScissorTest(_currentScissorTest);
            if (isCube) {
                const textureProperties = properties.get(renderTarget.texture);
                _gl.framebufferTexture2D(_gl.FRAMEBUFFER, _gl.COLOR_ATTACHMENT0, _gl.TEXTURE_CUBE_MAP_POSITIVE_X + activeCubeFace, textureProperties.__webglTexture, activeMipmapLevel);
            } else if (isRenderTarget3D) {
                const layer = activeCubeFace;
                for(let i = 0; i < renderTarget.textures.length; i++){
                    const textureProperties = properties.get(renderTarget.textures[i]);
                    _gl.framebufferTextureLayer(_gl.FRAMEBUFFER, _gl.COLOR_ATTACHMENT0 + i, textureProperties.__webglTexture, activeMipmapLevel, layer);
                }
            } else if (renderTarget !== null && activeMipmapLevel !== 0) {
                // Only bind the frame buffer if we are using a scratch frame buffer to render to a mipmap.
                // If we rebind the texture when using a multi sample buffer then an error about inconsistent samples will be thrown.
                const textureProperties = properties.get(renderTarget.texture);
                _gl.framebufferTexture2D(_gl.FRAMEBUFFER, _gl.COLOR_ATTACHMENT0, _gl.TEXTURE_2D, textureProperties.__webglTexture, activeMipmapLevel);
            }
            _currentMaterialId = -1; // reset current material to ensure correct uniform bindings
        };
        /**
		 * Reads the pixel data from the given render target into the given buffer.
		 *
		 * @param {WebGLRenderTarget} renderTarget - The render target to read from.
		 * @param {number} x - The `x` coordinate of the copy region's origin.
		 * @param {number} y - The `y` coordinate of the copy region's origin.
		 * @param {number} width - The width of the copy region.
		 * @param {number} height - The height of the copy region.
		 * @param {TypedArray} buffer - The result buffer.
		 * @param {number} [activeCubeFaceIndex] - The active cube face index.
		 * @param {number} [textureIndex=0] - The texture index of an MRT render target.
		 */ this.readRenderTargetPixels = function(renderTarget, x, y, width, height, buffer, activeCubeFaceIndex, textureIndex = 0) {
            if (!(renderTarget && renderTarget.isWebGLRenderTarget)) {
                (0, _threeCoreJs.error)('WebGLRenderer.readRenderTargetPixels: renderTarget is not THREE.WebGLRenderTarget.');
                return;
            }
            let framebuffer = properties.get(renderTarget).__webglFramebuffer;
            if (renderTarget.isWebGLCubeRenderTarget && activeCubeFaceIndex !== undefined) framebuffer = framebuffer[activeCubeFaceIndex];
            if (framebuffer) {
                state.bindFramebuffer(_gl.FRAMEBUFFER, framebuffer);
                try {
                    const texture = renderTarget.textures[textureIndex];
                    const textureFormat = texture.format;
                    const textureType = texture.type;
                    if (!capabilities.textureFormatReadable(textureFormat)) {
                        (0, _threeCoreJs.error)('WebGLRenderer.readRenderTargetPixels: renderTarget is not in RGBA or implementation defined format.');
                        return;
                    }
                    if (!capabilities.textureTypeReadable(textureType)) {
                        (0, _threeCoreJs.error)('WebGLRenderer.readRenderTargetPixels: renderTarget is not in UnsignedByteType or implementation defined type.');
                        return;
                    }
                    // the following if statement ensures valid read requests (no out-of-bounds pixels, see #8604)
                    if (x >= 0 && x <= renderTarget.width - width && y >= 0 && y <= renderTarget.height - height) {
                        // when using MRT, select the correct color buffer for the subsequent read command
                        if (renderTarget.textures.length > 1) _gl.readBuffer(_gl.COLOR_ATTACHMENT0 + textureIndex);
                        _gl.readPixels(x, y, width, height, utils.convert(textureFormat), utils.convert(textureType), buffer);
                    }
                } finally{
                    // restore framebuffer of current render target if necessary
                    const framebuffer = _currentRenderTarget !== null ? properties.get(_currentRenderTarget).__webglFramebuffer : null;
                    state.bindFramebuffer(_gl.FRAMEBUFFER, framebuffer);
                }
            }
        };
        /**
		 * Asynchronous, non-blocking version of {@link WebGLRenderer#readRenderTargetPixels}.
		 *
		 * It is recommended to use this version of `readRenderTargetPixels()` whenever possible.
		 *
		 * @async
		 * @param {WebGLRenderTarget} renderTarget - The render target to read from.
		 * @param {number} x - The `x` coordinate of the copy region's origin.
		 * @param {number} y - The `y` coordinate of the copy region's origin.
		 * @param {number} width - The width of the copy region.
		 * @param {number} height - The height of the copy region.
		 * @param {TypedArray} buffer - The result buffer.
		 * @param {number} [activeCubeFaceIndex] - The active cube face index.
		 * @param {number} [textureIndex=0] - The texture index of an MRT render target.
		 * @return {Promise<TypedArray>} A Promise that resolves when the read has been finished. The resolve provides the read data as a typed array.
		 */ this.readRenderTargetPixelsAsync = async function(renderTarget, x, y, width, height, buffer, activeCubeFaceIndex, textureIndex = 0) {
            if (!(renderTarget && renderTarget.isWebGLRenderTarget)) throw new Error('THREE.WebGLRenderer.readRenderTargetPixels: renderTarget is not THREE.WebGLRenderTarget.');
            let framebuffer = properties.get(renderTarget).__webglFramebuffer;
            if (renderTarget.isWebGLCubeRenderTarget && activeCubeFaceIndex !== undefined) framebuffer = framebuffer[activeCubeFaceIndex];
            if (framebuffer) {
                // the following if statement ensures valid read requests (no out-of-bounds pixels, see #8604)
                if (x >= 0 && x <= renderTarget.width - width && y >= 0 && y <= renderTarget.height - height) {
                    // set the active frame buffer to the one we want to read
                    state.bindFramebuffer(_gl.FRAMEBUFFER, framebuffer);
                    const texture = renderTarget.textures[textureIndex];
                    const textureFormat = texture.format;
                    const textureType = texture.type;
                    if (!capabilities.textureFormatReadable(textureFormat)) throw new Error('THREE.WebGLRenderer.readRenderTargetPixelsAsync: renderTarget is not in RGBA or implementation defined format.');
                    if (!capabilities.textureTypeReadable(textureType)) throw new Error('THREE.WebGLRenderer.readRenderTargetPixelsAsync: renderTarget is not in UnsignedByteType or implementation defined type.');
                    const glBuffer = _gl.createBuffer();
                    _gl.bindBuffer(_gl.PIXEL_PACK_BUFFER, glBuffer);
                    _gl.bufferData(_gl.PIXEL_PACK_BUFFER, buffer.byteLength, _gl.STREAM_READ);
                    // when using MRT, select the correct color buffer for the subsequent read command
                    if (renderTarget.textures.length > 1) _gl.readBuffer(_gl.COLOR_ATTACHMENT0 + textureIndex);
                    _gl.readPixels(x, y, width, height, utils.convert(textureFormat), utils.convert(textureType), 0);
                    // reset the frame buffer to the currently set buffer before waiting
                    const currFramebuffer = _currentRenderTarget !== null ? properties.get(_currentRenderTarget).__webglFramebuffer : null;
                    state.bindFramebuffer(_gl.FRAMEBUFFER, currFramebuffer);
                    // check if the commands have finished every 8 ms
                    const sync = _gl.fenceSync(_gl.SYNC_GPU_COMMANDS_COMPLETE, 0);
                    _gl.flush();
                    await (0, _threeCoreJs.probeAsync)(_gl, sync, 4);
                    // read the data and delete the buffer
                    _gl.bindBuffer(_gl.PIXEL_PACK_BUFFER, glBuffer);
                    _gl.getBufferSubData(_gl.PIXEL_PACK_BUFFER, 0, buffer);
                    _gl.deleteBuffer(glBuffer);
                    _gl.deleteSync(sync);
                    return buffer;
                } else throw new Error('THREE.WebGLRenderer.readRenderTargetPixelsAsync: requested read bounds are out of range.');
            }
        };
        /**
		 * Copies pixels from the current bound framebuffer into the given texture.
		 *
		 * @param {FramebufferTexture} texture - The texture.
		 * @param {?Vector2} [position=null] - The start position of the copy operation.
		 * @param {number} [level=0] - The mip level. The default represents the base mip.
		 */ this.copyFramebufferToTexture = function(texture, position = null, level = 0) {
            const levelScale = Math.pow(2, -level);
            const width = Math.floor(texture.image.width * levelScale);
            const height = Math.floor(texture.image.height * levelScale);
            const x = position !== null ? position.x : 0;
            const y = position !== null ? position.y : 0;
            textures.setTexture2D(texture, 0);
            _gl.copyTexSubImage2D(_gl.TEXTURE_2D, level, 0, 0, x, y, width, height);
            state.unbindTexture();
        };
        const _srcFramebuffer = _gl.createFramebuffer();
        const _dstFramebuffer = _gl.createFramebuffer();
        /**
		 * Copies data of the given source texture into a destination texture.
		 *
		 * When using render target textures as `srcTexture` and `dstTexture`, you must make sure both render targets are initialized
		 * {@link WebGLRenderer#initRenderTarget}.
		 *
		 * @param {Texture} srcTexture - The source texture.
		 * @param {Texture} dstTexture - The destination texture.
		 * @param {?(Box2|Box3)} [srcRegion=null] - A bounding box which describes the source region. Can be two or three-dimensional.
		 * @param {?(Vector2|Vector3)} [dstPosition=null] - A vector that represents the origin of the destination region. Can be two or three-dimensional.
		 * @param {number} [srcLevel=0] - The source mipmap level to copy.
		 * @param {?number} [dstLevel=null] - The destination mipmap level.
		 */ this.copyTextureToTexture = function(srcTexture, dstTexture, srcRegion = null, dstPosition = null, srcLevel = 0, dstLevel = null) {
            // support the previous signature with just a single dst mipmap level
            if (dstLevel === null) {
                if (srcLevel !== 0) {
                    // @deprecated, r171
                    (0, _threeCoreJs.warnOnce)('WebGLRenderer: copyTextureToTexture function signature has changed to support src and dst mipmap levels.');
                    dstLevel = srcLevel;
                    srcLevel = 0;
                } else dstLevel = 0;
            }
            // gather the necessary dimensions to copy
            let width, height, depth, minX, minY, minZ;
            let dstX, dstY, dstZ;
            const image = srcTexture.isCompressedTexture ? srcTexture.mipmaps[dstLevel] : srcTexture.image;
            if (srcRegion !== null) {
                width = srcRegion.max.x - srcRegion.min.x;
                height = srcRegion.max.y - srcRegion.min.y;
                depth = srcRegion.isBox3 ? srcRegion.max.z - srcRegion.min.z : 1;
                minX = srcRegion.min.x;
                minY = srcRegion.min.y;
                minZ = srcRegion.isBox3 ? srcRegion.min.z : 0;
            } else {
                const levelScale = Math.pow(2, -srcLevel);
                width = Math.floor(image.width * levelScale);
                height = Math.floor(image.height * levelScale);
                if (srcTexture.isDataArrayTexture) depth = image.depth;
                else if (srcTexture.isData3DTexture) depth = Math.floor(image.depth * levelScale);
                else depth = 1;
                minX = 0;
                minY = 0;
                minZ = 0;
            }
            if (dstPosition !== null) {
                dstX = dstPosition.x;
                dstY = dstPosition.y;
                dstZ = dstPosition.z;
            } else {
                dstX = 0;
                dstY = 0;
                dstZ = 0;
            }
            // Set up the destination target
            const glFormat = utils.convert(dstTexture.format);
            const glType = utils.convert(dstTexture.type);
            let glTarget;
            if (dstTexture.isData3DTexture) {
                textures.setTexture3D(dstTexture, 0);
                glTarget = _gl.TEXTURE_3D;
            } else if (dstTexture.isDataArrayTexture || dstTexture.isCompressedArrayTexture) {
                textures.setTexture2DArray(dstTexture, 0);
                glTarget = _gl.TEXTURE_2D_ARRAY;
            } else {
                textures.setTexture2D(dstTexture, 0);
                glTarget = _gl.TEXTURE_2D;
            }
            _gl.pixelStorei(_gl.UNPACK_FLIP_Y_WEBGL, dstTexture.flipY);
            _gl.pixelStorei(_gl.UNPACK_PREMULTIPLY_ALPHA_WEBGL, dstTexture.premultiplyAlpha);
            _gl.pixelStorei(_gl.UNPACK_ALIGNMENT, dstTexture.unpackAlignment);
            // used for copying data from cpu
            const currentUnpackRowLen = _gl.getParameter(_gl.UNPACK_ROW_LENGTH);
            const currentUnpackImageHeight = _gl.getParameter(_gl.UNPACK_IMAGE_HEIGHT);
            const currentUnpackSkipPixels = _gl.getParameter(_gl.UNPACK_SKIP_PIXELS);
            const currentUnpackSkipRows = _gl.getParameter(_gl.UNPACK_SKIP_ROWS);
            const currentUnpackSkipImages = _gl.getParameter(_gl.UNPACK_SKIP_IMAGES);
            _gl.pixelStorei(_gl.UNPACK_ROW_LENGTH, image.width);
            _gl.pixelStorei(_gl.UNPACK_IMAGE_HEIGHT, image.height);
            _gl.pixelStorei(_gl.UNPACK_SKIP_PIXELS, minX);
            _gl.pixelStorei(_gl.UNPACK_SKIP_ROWS, minY);
            _gl.pixelStorei(_gl.UNPACK_SKIP_IMAGES, minZ);
            // set up the src texture
            const isSrc3D = srcTexture.isDataArrayTexture || srcTexture.isData3DTexture;
            const isDst3D = dstTexture.isDataArrayTexture || dstTexture.isData3DTexture;
            if (srcTexture.isDepthTexture) {
                const srcTextureProperties = properties.get(srcTexture);
                const dstTextureProperties = properties.get(dstTexture);
                const srcRenderTargetProperties = properties.get(srcTextureProperties.__renderTarget);
                const dstRenderTargetProperties = properties.get(dstTextureProperties.__renderTarget);
                state.bindFramebuffer(_gl.READ_FRAMEBUFFER, srcRenderTargetProperties.__webglFramebuffer);
                state.bindFramebuffer(_gl.DRAW_FRAMEBUFFER, dstRenderTargetProperties.__webglFramebuffer);
                for(let i = 0; i < depth; i++){
                    // if the source or destination are a 3d target then a layer needs to be bound
                    if (isSrc3D) {
                        _gl.framebufferTextureLayer(_gl.READ_FRAMEBUFFER, _gl.COLOR_ATTACHMENT0, properties.get(srcTexture).__webglTexture, srcLevel, minZ + i);
                        _gl.framebufferTextureLayer(_gl.DRAW_FRAMEBUFFER, _gl.COLOR_ATTACHMENT0, properties.get(dstTexture).__webglTexture, dstLevel, dstZ + i);
                    }
                    _gl.blitFramebuffer(minX, minY, width, height, dstX, dstY, width, height, _gl.DEPTH_BUFFER_BIT, _gl.NEAREST);
                }
                state.bindFramebuffer(_gl.READ_FRAMEBUFFER, null);
                state.bindFramebuffer(_gl.DRAW_FRAMEBUFFER, null);
            } else if (srcLevel !== 0 || srcTexture.isRenderTargetTexture || properties.has(srcTexture)) {
                // get the appropriate frame buffers
                const srcTextureProperties = properties.get(srcTexture);
                const dstTextureProperties = properties.get(dstTexture);
                // bind the frame buffer targets
                state.bindFramebuffer(_gl.READ_FRAMEBUFFER, _srcFramebuffer);
                state.bindFramebuffer(_gl.DRAW_FRAMEBUFFER, _dstFramebuffer);
                for(let i = 0; i < depth; i++){
                    // assign the correct layers and mip maps to the frame buffers
                    if (isSrc3D) _gl.framebufferTextureLayer(_gl.READ_FRAMEBUFFER, _gl.COLOR_ATTACHMENT0, srcTextureProperties.__webglTexture, srcLevel, minZ + i);
                    else _gl.framebufferTexture2D(_gl.READ_FRAMEBUFFER, _gl.COLOR_ATTACHMENT0, _gl.TEXTURE_2D, srcTextureProperties.__webglTexture, srcLevel);
                    if (isDst3D) _gl.framebufferTextureLayer(_gl.DRAW_FRAMEBUFFER, _gl.COLOR_ATTACHMENT0, dstTextureProperties.__webglTexture, dstLevel, dstZ + i);
                    else _gl.framebufferTexture2D(_gl.DRAW_FRAMEBUFFER, _gl.COLOR_ATTACHMENT0, _gl.TEXTURE_2D, dstTextureProperties.__webglTexture, dstLevel);
                    // copy the data using the fastest function that can achieve the copy
                    if (srcLevel !== 0) _gl.blitFramebuffer(minX, minY, width, height, dstX, dstY, width, height, _gl.COLOR_BUFFER_BIT, _gl.NEAREST);
                    else if (isDst3D) _gl.copyTexSubImage3D(glTarget, dstLevel, dstX, dstY, dstZ + i, minX, minY, width, height);
                    else _gl.copyTexSubImage2D(glTarget, dstLevel, dstX, dstY, minX, minY, width, height);
                }
                // unbind read, draw buffers
                state.bindFramebuffer(_gl.READ_FRAMEBUFFER, null);
                state.bindFramebuffer(_gl.DRAW_FRAMEBUFFER, null);
            } else if (isDst3D) {
                // copy data into the 3d texture
                if (srcTexture.isDataTexture || srcTexture.isData3DTexture) _gl.texSubImage3D(glTarget, dstLevel, dstX, dstY, dstZ, width, height, depth, glFormat, glType, image.data);
                else if (dstTexture.isCompressedArrayTexture) _gl.compressedTexSubImage3D(glTarget, dstLevel, dstX, dstY, dstZ, width, height, depth, glFormat, image.data);
                else _gl.texSubImage3D(glTarget, dstLevel, dstX, dstY, dstZ, width, height, depth, glFormat, glType, image);
            } else {
                // copy data into the 2d texture
                if (srcTexture.isDataTexture) _gl.texSubImage2D(_gl.TEXTURE_2D, dstLevel, dstX, dstY, width, height, glFormat, glType, image.data);
                else if (srcTexture.isCompressedTexture) _gl.compressedTexSubImage2D(_gl.TEXTURE_2D, dstLevel, dstX, dstY, image.width, image.height, glFormat, image.data);
                else _gl.texSubImage2D(_gl.TEXTURE_2D, dstLevel, dstX, dstY, width, height, glFormat, glType, image);
            }
            // reset values
            _gl.pixelStorei(_gl.UNPACK_ROW_LENGTH, currentUnpackRowLen);
            _gl.pixelStorei(_gl.UNPACK_IMAGE_HEIGHT, currentUnpackImageHeight);
            _gl.pixelStorei(_gl.UNPACK_SKIP_PIXELS, currentUnpackSkipPixels);
            _gl.pixelStorei(_gl.UNPACK_SKIP_ROWS, currentUnpackSkipRows);
            _gl.pixelStorei(_gl.UNPACK_SKIP_IMAGES, currentUnpackSkipImages);
            // Generate mipmaps only when copying level 0
            if (dstLevel === 0 && dstTexture.generateMipmaps) _gl.generateMipmap(glTarget);
            state.unbindTexture();
        };
        /**
		 * Initializes the given WebGLRenderTarget memory. Useful for initializing a render target so data
		 * can be copied into it using {@link WebGLRenderer#copyTextureToTexture} before it has been
		 * rendered to.
		 *
		 * @param {WebGLRenderTarget} target - The render target.
		 */ this.initRenderTarget = function(target) {
            if (properties.get(target).__webglFramebuffer === undefined) textures.setupRenderTarget(target);
        };
        /**
		 * Initializes the given texture. Useful for preloading a texture rather than waiting until first
		 * render (which can cause noticeable lags due to decode and GPU upload overhead).
		 *
		 * @param {Texture} texture - The texture.
		 */ this.initTexture = function(texture) {
            if (texture.isCubeTexture) textures.setTextureCube(texture, 0);
            else if (texture.isData3DTexture) textures.setTexture3D(texture, 0);
            else if (texture.isDataArrayTexture || texture.isCompressedArrayTexture) textures.setTexture2DArray(texture, 0);
            else textures.setTexture2D(texture, 0);
            state.unbindTexture();
        };
        /**
		 * Can be used to reset the internal WebGL state. This method is mostly
		 * relevant for applications which share a single WebGL context across
		 * multiple WebGL libraries.
		 */ this.resetState = function() {
            _currentActiveCubeFace = 0;
            _currentActiveMipmapLevel = 0;
            _currentRenderTarget = null;
            state.reset();
            bindingStates.reset();
        };
        if (typeof __THREE_DEVTOOLS__ !== 'undefined') __THREE_DEVTOOLS__.dispatchEvent(new CustomEvent('observe', {
            detail: this
        }));
    }
    /**
	 * Defines the coordinate system of the renderer.
	 *
	 * In `WebGLRenderer`, the value is always `WebGLCoordinateSystem`.
	 *
	 * @type {WebGLCoordinateSystem|WebGPUCoordinateSystem}
	 * @default WebGLCoordinateSystem
	 * @readonly
	 */ get coordinateSystem() {
        return 0, _threeCoreJs.WebGLCoordinateSystem;
    }
    /**
	 * Defines the output color space of the renderer.
	 *
	 * @type {SRGBColorSpace|LinearSRGBColorSpace}
	 * @default SRGBColorSpace
	 */ get outputColorSpace() {
        return this._outputColorSpace;
    }
    set outputColorSpace(colorSpace) {
        this._outputColorSpace = colorSpace;
        const gl = this.getContext();
        gl.drawingBufferColorSpace = (0, _threeCoreJs.ColorManagement)._getDrawingBufferColorSpace(colorSpace);
        gl.unpackColorSpace = (0, _threeCoreJs.ColorManagement)._getUnpackColorSpace();
    }
}

},{"./three.core.js":"4TvK1","@parcel/transformer-js/src/esmodule-helpers.js":"jnFvT"}],"4TvK1":[function(require,module,exports,__globalThis) {
/**
 * @license
 * Copyright 2010-2025 Three.js Authors
 * SPDX-License-Identifier: MIT
 */ var parcelHelpers = require("@parcel/transformer-js/src/esmodule-helpers.js");
parcelHelpers.defineInteropFlag(exports);
parcelHelpers.export(exports, "ACESFilmicToneMapping", ()=>ACESFilmicToneMapping);
parcelHelpers.export(exports, "AddEquation", ()=>AddEquation);
parcelHelpers.export(exports, "AddOperation", ()=>AddOperation);
parcelHelpers.export(exports, "AdditiveAnimationBlendMode", ()=>AdditiveAnimationBlendMode);
parcelHelpers.export(exports, "AdditiveBlending", ()=>AdditiveBlending);
parcelHelpers.export(exports, "AgXToneMapping", ()=>AgXToneMapping);
parcelHelpers.export(exports, "AlphaFormat", ()=>AlphaFormat);
parcelHelpers.export(exports, "AlwaysCompare", ()=>AlwaysCompare);
parcelHelpers.export(exports, "AlwaysDepth", ()=>AlwaysDepth);
parcelHelpers.export(exports, "AlwaysStencilFunc", ()=>AlwaysStencilFunc);
parcelHelpers.export(exports, "AmbientLight", ()=>AmbientLight);
parcelHelpers.export(exports, "AnimationAction", ()=>AnimationAction);
parcelHelpers.export(exports, "AnimationClip", ()=>AnimationClip);
parcelHelpers.export(exports, "AnimationLoader", ()=>AnimationLoader);
parcelHelpers.export(exports, "AnimationMixer", ()=>AnimationMixer);
parcelHelpers.export(exports, "AnimationObjectGroup", ()=>AnimationObjectGroup);
parcelHelpers.export(exports, "AnimationUtils", ()=>AnimationUtils);
parcelHelpers.export(exports, "ArcCurve", ()=>ArcCurve);
parcelHelpers.export(exports, "ArrayCamera", ()=>ArrayCamera);
parcelHelpers.export(exports, "ArrowHelper", ()=>ArrowHelper);
parcelHelpers.export(exports, "AttachedBindMode", ()=>AttachedBindMode);
parcelHelpers.export(exports, "Audio", ()=>Audio);
parcelHelpers.export(exports, "AudioAnalyser", ()=>AudioAnalyser);
parcelHelpers.export(exports, "AudioContext", ()=>AudioContext);
parcelHelpers.export(exports, "AudioListener", ()=>AudioListener);
parcelHelpers.export(exports, "AudioLoader", ()=>AudioLoader);
parcelHelpers.export(exports, "AxesHelper", ()=>AxesHelper);
parcelHelpers.export(exports, "BackSide", ()=>BackSide);
parcelHelpers.export(exports, "BasicDepthPacking", ()=>BasicDepthPacking);
parcelHelpers.export(exports, "BasicShadowMap", ()=>BasicShadowMap);
parcelHelpers.export(exports, "BatchedMesh", ()=>BatchedMesh);
parcelHelpers.export(exports, "Bone", ()=>Bone);
parcelHelpers.export(exports, "BooleanKeyframeTrack", ()=>BooleanKeyframeTrack);
parcelHelpers.export(exports, "Box2", ()=>Box2);
parcelHelpers.export(exports, "Box3", ()=>Box3);
parcelHelpers.export(exports, "Box3Helper", ()=>Box3Helper);
parcelHelpers.export(exports, "BoxGeometry", ()=>BoxGeometry);
parcelHelpers.export(exports, "BoxHelper", ()=>BoxHelper);
parcelHelpers.export(exports, "BufferAttribute", ()=>BufferAttribute);
parcelHelpers.export(exports, "BufferGeometry", ()=>BufferGeometry);
parcelHelpers.export(exports, "BufferGeometryLoader", ()=>BufferGeometryLoader);
parcelHelpers.export(exports, "ByteType", ()=>ByteType);
parcelHelpers.export(exports, "Cache", ()=>Cache);
parcelHelpers.export(exports, "Camera", ()=>Camera);
parcelHelpers.export(exports, "CameraHelper", ()=>CameraHelper);
parcelHelpers.export(exports, "CanvasTexture", ()=>CanvasTexture);
parcelHelpers.export(exports, "CapsuleGeometry", ()=>CapsuleGeometry);
parcelHelpers.export(exports, "CatmullRomCurve3", ()=>CatmullRomCurve3);
parcelHelpers.export(exports, "CineonToneMapping", ()=>CineonToneMapping);
parcelHelpers.export(exports, "CircleGeometry", ()=>CircleGeometry);
parcelHelpers.export(exports, "ClampToEdgeWrapping", ()=>ClampToEdgeWrapping);
parcelHelpers.export(exports, "Clock", ()=>Clock);
parcelHelpers.export(exports, "Color", ()=>Color);
parcelHelpers.export(exports, "ColorKeyframeTrack", ()=>ColorKeyframeTrack);
parcelHelpers.export(exports, "ColorManagement", ()=>ColorManagement);
parcelHelpers.export(exports, "CompressedArrayTexture", ()=>CompressedArrayTexture);
parcelHelpers.export(exports, "CompressedCubeTexture", ()=>CompressedCubeTexture);
parcelHelpers.export(exports, "CompressedTexture", ()=>CompressedTexture);
parcelHelpers.export(exports, "CompressedTextureLoader", ()=>CompressedTextureLoader);
parcelHelpers.export(exports, "ConeGeometry", ()=>ConeGeometry);
parcelHelpers.export(exports, "ConstantAlphaFactor", ()=>ConstantAlphaFactor);
parcelHelpers.export(exports, "ConstantColorFactor", ()=>ConstantColorFactor);
parcelHelpers.export(exports, "Controls", ()=>Controls);
parcelHelpers.export(exports, "CubeCamera", ()=>CubeCamera);
parcelHelpers.export(exports, "CubeDepthTexture", ()=>CubeDepthTexture);
parcelHelpers.export(exports, "CubeReflectionMapping", ()=>CubeReflectionMapping);
parcelHelpers.export(exports, "CubeRefractionMapping", ()=>CubeRefractionMapping);
parcelHelpers.export(exports, "CubeTexture", ()=>CubeTexture);
parcelHelpers.export(exports, "CubeTextureLoader", ()=>CubeTextureLoader);
parcelHelpers.export(exports, "CubeUVReflectionMapping", ()=>CubeUVReflectionMapping);
parcelHelpers.export(exports, "CubicBezierCurve", ()=>CubicBezierCurve);
parcelHelpers.export(exports, "CubicBezierCurve3", ()=>CubicBezierCurve3);
parcelHelpers.export(exports, "CubicInterpolant", ()=>CubicInterpolant);
parcelHelpers.export(exports, "CullFaceBack", ()=>CullFaceBack);
parcelHelpers.export(exports, "CullFaceFront", ()=>CullFaceFront);
parcelHelpers.export(exports, "CullFaceFrontBack", ()=>CullFaceFrontBack);
parcelHelpers.export(exports, "CullFaceNone", ()=>CullFaceNone);
parcelHelpers.export(exports, "Curve", ()=>Curve);
parcelHelpers.export(exports, "CurvePath", ()=>CurvePath);
parcelHelpers.export(exports, "CustomBlending", ()=>CustomBlending);
parcelHelpers.export(exports, "CustomToneMapping", ()=>CustomToneMapping);
parcelHelpers.export(exports, "CylinderGeometry", ()=>CylinderGeometry);
parcelHelpers.export(exports, "Cylindrical", ()=>Cylindrical);
parcelHelpers.export(exports, "Data3DTexture", ()=>Data3DTexture);
parcelHelpers.export(exports, "DataArrayTexture", ()=>DataArrayTexture);
parcelHelpers.export(exports, "DataTexture", ()=>DataTexture);
parcelHelpers.export(exports, "DataTextureLoader", ()=>DataTextureLoader);
parcelHelpers.export(exports, "DataUtils", ()=>DataUtils);
parcelHelpers.export(exports, "DecrementStencilOp", ()=>DecrementStencilOp);
parcelHelpers.export(exports, "DecrementWrapStencilOp", ()=>DecrementWrapStencilOp);
parcelHelpers.export(exports, "DefaultLoadingManager", ()=>DefaultLoadingManager);
parcelHelpers.export(exports, "DepthFormat", ()=>DepthFormat);
parcelHelpers.export(exports, "DepthStencilFormat", ()=>DepthStencilFormat);
parcelHelpers.export(exports, "DepthTexture", ()=>DepthTexture);
parcelHelpers.export(exports, "DetachedBindMode", ()=>DetachedBindMode);
parcelHelpers.export(exports, "DirectionalLight", ()=>DirectionalLight);
parcelHelpers.export(exports, "DirectionalLightHelper", ()=>DirectionalLightHelper);
parcelHelpers.export(exports, "DiscreteInterpolant", ()=>DiscreteInterpolant);
parcelHelpers.export(exports, "DodecahedronGeometry", ()=>DodecahedronGeometry);
parcelHelpers.export(exports, "DoubleSide", ()=>DoubleSide);
parcelHelpers.export(exports, "DstAlphaFactor", ()=>DstAlphaFactor);
parcelHelpers.export(exports, "DstColorFactor", ()=>DstColorFactor);
parcelHelpers.export(exports, "DynamicCopyUsage", ()=>DynamicCopyUsage);
parcelHelpers.export(exports, "DynamicDrawUsage", ()=>DynamicDrawUsage);
parcelHelpers.export(exports, "DynamicReadUsage", ()=>DynamicReadUsage);
parcelHelpers.export(exports, "EdgesGeometry", ()=>EdgesGeometry);
parcelHelpers.export(exports, "EllipseCurve", ()=>EllipseCurve);
parcelHelpers.export(exports, "EqualCompare", ()=>EqualCompare);
parcelHelpers.export(exports, "EqualDepth", ()=>EqualDepth);
parcelHelpers.export(exports, "EqualStencilFunc", ()=>EqualStencilFunc);
parcelHelpers.export(exports, "EquirectangularReflectionMapping", ()=>EquirectangularReflectionMapping);
parcelHelpers.export(exports, "EquirectangularRefractionMapping", ()=>EquirectangularRefractionMapping);
parcelHelpers.export(exports, "Euler", ()=>Euler);
parcelHelpers.export(exports, "EventDispatcher", ()=>EventDispatcher);
parcelHelpers.export(exports, "ExternalTexture", ()=>ExternalTexture);
parcelHelpers.export(exports, "ExtrudeGeometry", ()=>ExtrudeGeometry);
parcelHelpers.export(exports, "FileLoader", ()=>FileLoader);
parcelHelpers.export(exports, "Float16BufferAttribute", ()=>Float16BufferAttribute);
parcelHelpers.export(exports, "Float32BufferAttribute", ()=>Float32BufferAttribute);
parcelHelpers.export(exports, "FloatType", ()=>FloatType);
parcelHelpers.export(exports, "Fog", ()=>Fog);
parcelHelpers.export(exports, "FogExp2", ()=>FogExp2);
parcelHelpers.export(exports, "FramebufferTexture", ()=>FramebufferTexture);
parcelHelpers.export(exports, "FrontSide", ()=>FrontSide);
parcelHelpers.export(exports, "Frustum", ()=>Frustum);
parcelHelpers.export(exports, "FrustumArray", ()=>FrustumArray);
parcelHelpers.export(exports, "GLBufferAttribute", ()=>GLBufferAttribute);
parcelHelpers.export(exports, "GLSL1", ()=>GLSL1);
parcelHelpers.export(exports, "GLSL3", ()=>GLSL3);
parcelHelpers.export(exports, "GreaterCompare", ()=>GreaterCompare);
parcelHelpers.export(exports, "GreaterDepth", ()=>GreaterDepth);
parcelHelpers.export(exports, "GreaterEqualCompare", ()=>GreaterEqualCompare);
parcelHelpers.export(exports, "GreaterEqualDepth", ()=>GreaterEqualDepth);
parcelHelpers.export(exports, "GreaterEqualStencilFunc", ()=>GreaterEqualStencilFunc);
parcelHelpers.export(exports, "GreaterStencilFunc", ()=>GreaterStencilFunc);
parcelHelpers.export(exports, "GridHelper", ()=>GridHelper);
parcelHelpers.export(exports, "Group", ()=>Group);
parcelHelpers.export(exports, "HalfFloatType", ()=>HalfFloatType);
parcelHelpers.export(exports, "HemisphereLight", ()=>HemisphereLight);
parcelHelpers.export(exports, "HemisphereLightHelper", ()=>HemisphereLightHelper);
parcelHelpers.export(exports, "IcosahedronGeometry", ()=>IcosahedronGeometry);
parcelHelpers.export(exports, "ImageBitmapLoader", ()=>ImageBitmapLoader);
parcelHelpers.export(exports, "ImageLoader", ()=>ImageLoader);
parcelHelpers.export(exports, "ImageUtils", ()=>ImageUtils);
parcelHelpers.export(exports, "IncrementStencilOp", ()=>IncrementStencilOp);
parcelHelpers.export(exports, "IncrementWrapStencilOp", ()=>IncrementWrapStencilOp);
parcelHelpers.export(exports, "InstancedBufferAttribute", ()=>InstancedBufferAttribute);
parcelHelpers.export(exports, "InstancedBufferGeometry", ()=>InstancedBufferGeometry);
parcelHelpers.export(exports, "InstancedInterleavedBuffer", ()=>InstancedInterleavedBuffer);
parcelHelpers.export(exports, "InstancedMesh", ()=>InstancedMesh);
parcelHelpers.export(exports, "Int16BufferAttribute", ()=>Int16BufferAttribute);
parcelHelpers.export(exports, "Int32BufferAttribute", ()=>Int32BufferAttribute);
parcelHelpers.export(exports, "Int8BufferAttribute", ()=>Int8BufferAttribute);
parcelHelpers.export(exports, "IntType", ()=>IntType);
parcelHelpers.export(exports, "InterleavedBuffer", ()=>InterleavedBuffer);
parcelHelpers.export(exports, "InterleavedBufferAttribute", ()=>InterleavedBufferAttribute);
parcelHelpers.export(exports, "Interpolant", ()=>Interpolant);
parcelHelpers.export(exports, "InterpolateDiscrete", ()=>InterpolateDiscrete);
parcelHelpers.export(exports, "InterpolateLinear", ()=>InterpolateLinear);
parcelHelpers.export(exports, "InterpolateSmooth", ()=>InterpolateSmooth);
parcelHelpers.export(exports, "InterpolationSamplingMode", ()=>InterpolationSamplingMode);
parcelHelpers.export(exports, "InterpolationSamplingType", ()=>InterpolationSamplingType);
parcelHelpers.export(exports, "InvertStencilOp", ()=>InvertStencilOp);
parcelHelpers.export(exports, "KeepStencilOp", ()=>KeepStencilOp);
parcelHelpers.export(exports, "KeyframeTrack", ()=>KeyframeTrack);
parcelHelpers.export(exports, "LOD", ()=>LOD);
parcelHelpers.export(exports, "LatheGeometry", ()=>LatheGeometry);
parcelHelpers.export(exports, "Layers", ()=>Layers);
parcelHelpers.export(exports, "LessCompare", ()=>LessCompare);
parcelHelpers.export(exports, "LessDepth", ()=>LessDepth);
parcelHelpers.export(exports, "LessEqualCompare", ()=>LessEqualCompare);
parcelHelpers.export(exports, "LessEqualDepth", ()=>LessEqualDepth);
parcelHelpers.export(exports, "LessEqualStencilFunc", ()=>LessEqualStencilFunc);
parcelHelpers.export(exports, "LessStencilFunc", ()=>LessStencilFunc);
parcelHelpers.export(exports, "Light", ()=>Light);
parcelHelpers.export(exports, "LightProbe", ()=>LightProbe);
parcelHelpers.export(exports, "Line", ()=>Line);
parcelHelpers.export(exports, "Line3", ()=>Line3);
parcelHelpers.export(exports, "LineBasicMaterial", ()=>LineBasicMaterial);
parcelHelpers.export(exports, "LineCurve", ()=>LineCurve);
parcelHelpers.export(exports, "LineCurve3", ()=>LineCurve3);
parcelHelpers.export(exports, "LineDashedMaterial", ()=>LineDashedMaterial);
parcelHelpers.export(exports, "LineLoop", ()=>LineLoop);
parcelHelpers.export(exports, "LineSegments", ()=>LineSegments);
parcelHelpers.export(exports, "LinearFilter", ()=>LinearFilter);
parcelHelpers.export(exports, "LinearInterpolant", ()=>LinearInterpolant);
parcelHelpers.export(exports, "LinearMipMapLinearFilter", ()=>LinearMipMapLinearFilter);
parcelHelpers.export(exports, "LinearMipMapNearestFilter", ()=>LinearMipMapNearestFilter);
parcelHelpers.export(exports, "LinearMipmapLinearFilter", ()=>LinearMipmapLinearFilter);
parcelHelpers.export(exports, "LinearMipmapNearestFilter", ()=>LinearMipmapNearestFilter);
parcelHelpers.export(exports, "LinearSRGBColorSpace", ()=>LinearSRGBColorSpace);
parcelHelpers.export(exports, "LinearToneMapping", ()=>LinearToneMapping);
parcelHelpers.export(exports, "LinearTransfer", ()=>LinearTransfer);
parcelHelpers.export(exports, "Loader", ()=>Loader);
parcelHelpers.export(exports, "LoaderUtils", ()=>LoaderUtils);
parcelHelpers.export(exports, "LoadingManager", ()=>LoadingManager);
parcelHelpers.export(exports, "LoopOnce", ()=>LoopOnce);
parcelHelpers.export(exports, "LoopPingPong", ()=>LoopPingPong);
parcelHelpers.export(exports, "LoopRepeat", ()=>LoopRepeat);
parcelHelpers.export(exports, "MOUSE", ()=>MOUSE);
parcelHelpers.export(exports, "Material", ()=>Material);
parcelHelpers.export(exports, "MaterialLoader", ()=>MaterialLoader);
parcelHelpers.export(exports, "MathUtils", ()=>MathUtils);
parcelHelpers.export(exports, "Matrix2", ()=>Matrix2);
parcelHelpers.export(exports, "Matrix3", ()=>Matrix3);
parcelHelpers.export(exports, "Matrix4", ()=>Matrix4);
parcelHelpers.export(exports, "MaxEquation", ()=>MaxEquation);
parcelHelpers.export(exports, "Mesh", ()=>Mesh);
parcelHelpers.export(exports, "MeshBasicMaterial", ()=>MeshBasicMaterial);
parcelHelpers.export(exports, "MeshDepthMaterial", ()=>MeshDepthMaterial);
parcelHelpers.export(exports, "MeshDistanceMaterial", ()=>MeshDistanceMaterial);
parcelHelpers.export(exports, "MeshLambertMaterial", ()=>MeshLambertMaterial);
parcelHelpers.export(exports, "MeshMatcapMaterial", ()=>MeshMatcapMaterial);
parcelHelpers.export(exports, "MeshNormalMaterial", ()=>MeshNormalMaterial);
parcelHelpers.export(exports, "MeshPhongMaterial", ()=>MeshPhongMaterial);
parcelHelpers.export(exports, "MeshPhysicalMaterial", ()=>MeshPhysicalMaterial);
parcelHelpers.export(exports, "MeshStandardMaterial", ()=>MeshStandardMaterial);
parcelHelpers.export(exports, "MeshToonMaterial", ()=>MeshToonMaterial);
parcelHelpers.export(exports, "MinEquation", ()=>MinEquation);
parcelHelpers.export(exports, "MirroredRepeatWrapping", ()=>MirroredRepeatWrapping);
parcelHelpers.export(exports, "MixOperation", ()=>MixOperation);
parcelHelpers.export(exports, "MultiplyBlending", ()=>MultiplyBlending);
parcelHelpers.export(exports, "MultiplyOperation", ()=>MultiplyOperation);
parcelHelpers.export(exports, "NearestFilter", ()=>NearestFilter);
parcelHelpers.export(exports, "NearestMipMapLinearFilter", ()=>NearestMipMapLinearFilter);
parcelHelpers.export(exports, "NearestMipMapNearestFilter", ()=>NearestMipMapNearestFilter);
parcelHelpers.export(exports, "NearestMipmapLinearFilter", ()=>NearestMipmapLinearFilter);
parcelHelpers.export(exports, "NearestMipmapNearestFilter", ()=>NearestMipmapNearestFilter);
parcelHelpers.export(exports, "NeutralToneMapping", ()=>NeutralToneMapping);
parcelHelpers.export(exports, "NeverCompare", ()=>NeverCompare);
parcelHelpers.export(exports, "NeverDepth", ()=>NeverDepth);
parcelHelpers.export(exports, "NeverStencilFunc", ()=>NeverStencilFunc);
parcelHelpers.export(exports, "NoBlending", ()=>NoBlending);
parcelHelpers.export(exports, "NoColorSpace", ()=>NoColorSpace);
parcelHelpers.export(exports, "NoNormalPacking", ()=>NoNormalPacking);
parcelHelpers.export(exports, "NoToneMapping", ()=>NoToneMapping);
parcelHelpers.export(exports, "NormalAnimationBlendMode", ()=>NormalAnimationBlendMode);
parcelHelpers.export(exports, "NormalBlending", ()=>NormalBlending);
parcelHelpers.export(exports, "NormalGAPacking", ()=>NormalGAPacking);
parcelHelpers.export(exports, "NormalRGPacking", ()=>NormalRGPacking);
parcelHelpers.export(exports, "NotEqualCompare", ()=>NotEqualCompare);
parcelHelpers.export(exports, "NotEqualDepth", ()=>NotEqualDepth);
parcelHelpers.export(exports, "NotEqualStencilFunc", ()=>NotEqualStencilFunc);
parcelHelpers.export(exports, "NumberKeyframeTrack", ()=>NumberKeyframeTrack);
parcelHelpers.export(exports, "Object3D", ()=>Object3D);
parcelHelpers.export(exports, "ObjectLoader", ()=>ObjectLoader);
parcelHelpers.export(exports, "ObjectSpaceNormalMap", ()=>ObjectSpaceNormalMap);
parcelHelpers.export(exports, "OctahedronGeometry", ()=>OctahedronGeometry);
parcelHelpers.export(exports, "OneFactor", ()=>OneFactor);
parcelHelpers.export(exports, "OneMinusConstantAlphaFactor", ()=>OneMinusConstantAlphaFactor);
parcelHelpers.export(exports, "OneMinusConstantColorFactor", ()=>OneMinusConstantColorFactor);
parcelHelpers.export(exports, "OneMinusDstAlphaFactor", ()=>OneMinusDstAlphaFactor);
parcelHelpers.export(exports, "OneMinusDstColorFactor", ()=>OneMinusDstColorFactor);
parcelHelpers.export(exports, "OneMinusSrcAlphaFactor", ()=>OneMinusSrcAlphaFactor);
parcelHelpers.export(exports, "OneMinusSrcColorFactor", ()=>OneMinusSrcColorFactor);
parcelHelpers.export(exports, "OrthographicCamera", ()=>OrthographicCamera);
parcelHelpers.export(exports, "PCFShadowMap", ()=>PCFShadowMap);
parcelHelpers.export(exports, "PCFSoftShadowMap", ()=>PCFSoftShadowMap);
parcelHelpers.export(exports, "Path", ()=>Path);
parcelHelpers.export(exports, "PerspectiveCamera", ()=>PerspectiveCamera);
parcelHelpers.export(exports, "Plane", ()=>Plane);
parcelHelpers.export(exports, "PlaneGeometry", ()=>PlaneGeometry);
parcelHelpers.export(exports, "PlaneHelper", ()=>PlaneHelper);
parcelHelpers.export(exports, "PointLight", ()=>PointLight);
parcelHelpers.export(exports, "PointLightHelper", ()=>PointLightHelper);
parcelHelpers.export(exports, "Points", ()=>Points);
parcelHelpers.export(exports, "PointsMaterial", ()=>PointsMaterial);
parcelHelpers.export(exports, "PolarGridHelper", ()=>PolarGridHelper);
parcelHelpers.export(exports, "PolyhedronGeometry", ()=>PolyhedronGeometry);
parcelHelpers.export(exports, "PositionalAudio", ()=>PositionalAudio);
parcelHelpers.export(exports, "PropertyBinding", ()=>PropertyBinding);
parcelHelpers.export(exports, "PropertyMixer", ()=>PropertyMixer);
parcelHelpers.export(exports, "QuadraticBezierCurve", ()=>QuadraticBezierCurve);
parcelHelpers.export(exports, "QuadraticBezierCurve3", ()=>QuadraticBezierCurve3);
parcelHelpers.export(exports, "Quaternion", ()=>Quaternion);
parcelHelpers.export(exports, "QuaternionKeyframeTrack", ()=>QuaternionKeyframeTrack);
parcelHelpers.export(exports, "QuaternionLinearInterpolant", ()=>QuaternionLinearInterpolant);
parcelHelpers.export(exports, "R11_EAC_Format", ()=>R11_EAC_Format);
parcelHelpers.export(exports, "RAD2DEG", ()=>RAD2DEG);
parcelHelpers.export(exports, "RED_GREEN_RGTC2_Format", ()=>RED_GREEN_RGTC2_Format);
parcelHelpers.export(exports, "RED_RGTC1_Format", ()=>RED_RGTC1_Format);
parcelHelpers.export(exports, "REVISION", ()=>REVISION);
parcelHelpers.export(exports, "RG11_EAC_Format", ()=>RG11_EAC_Format);
parcelHelpers.export(exports, "RGBADepthPacking", ()=>RGBADepthPacking);
parcelHelpers.export(exports, "RGBAFormat", ()=>RGBAFormat);
parcelHelpers.export(exports, "RGBAIntegerFormat", ()=>RGBAIntegerFormat);
parcelHelpers.export(exports, "RGBA_ASTC_10x10_Format", ()=>RGBA_ASTC_10x10_Format);
parcelHelpers.export(exports, "RGBA_ASTC_10x5_Format", ()=>RGBA_ASTC_10x5_Format);
parcelHelpers.export(exports, "RGBA_ASTC_10x6_Format", ()=>RGBA_ASTC_10x6_Format);
parcelHelpers.export(exports, "RGBA_ASTC_10x8_Format", ()=>RGBA_ASTC_10x8_Format);
parcelHelpers.export(exports, "RGBA_ASTC_12x10_Format", ()=>RGBA_ASTC_12x10_Format);
parcelHelpers.export(exports, "RGBA_ASTC_12x12_Format", ()=>RGBA_ASTC_12x12_Format);
parcelHelpers.export(exports, "RGBA_ASTC_4x4_Format", ()=>RGBA_ASTC_4x4_Format);
parcelHelpers.export(exports, "RGBA_ASTC_5x4_Format", ()=>RGBA_ASTC_5x4_Format);
parcelHelpers.export(exports, "RGBA_ASTC_5x5_Format", ()=>RGBA_ASTC_5x5_Format);
parcelHelpers.export(exports, "RGBA_ASTC_6x5_Format", ()=>RGBA_ASTC_6x5_Format);
parcelHelpers.export(exports, "RGBA_ASTC_6x6_Format", ()=>RGBA_ASTC_6x6_Format);
parcelHelpers.export(exports, "RGBA_ASTC_8x5_Format", ()=>RGBA_ASTC_8x5_Format);
parcelHelpers.export(exports, "RGBA_ASTC_8x6_Format", ()=>RGBA_ASTC_8x6_Format);
parcelHelpers.export(exports, "RGBA_ASTC_8x8_Format", ()=>RGBA_ASTC_8x8_Format);
parcelHelpers.export(exports, "RGBA_BPTC_Format", ()=>RGBA_BPTC_Format);
parcelHelpers.export(exports, "RGBA_ETC2_EAC_Format", ()=>RGBA_ETC2_EAC_Format);
parcelHelpers.export(exports, "RGBA_PVRTC_2BPPV1_Format", ()=>RGBA_PVRTC_2BPPV1_Format);
parcelHelpers.export(exports, "RGBA_PVRTC_4BPPV1_Format", ()=>RGBA_PVRTC_4BPPV1_Format);
parcelHelpers.export(exports, "RGBA_S3TC_DXT1_Format", ()=>RGBA_S3TC_DXT1_Format);
parcelHelpers.export(exports, "RGBA_S3TC_DXT3_Format", ()=>RGBA_S3TC_DXT3_Format);
parcelHelpers.export(exports, "RGBA_S3TC_DXT5_Format", ()=>RGBA_S3TC_DXT5_Format);
parcelHelpers.export(exports, "RGBDepthPacking", ()=>RGBDepthPacking);
parcelHelpers.export(exports, "RGBFormat", ()=>RGBFormat);
parcelHelpers.export(exports, "RGBIntegerFormat", ()=>RGBIntegerFormat);
parcelHelpers.export(exports, "RGB_BPTC_SIGNED_Format", ()=>RGB_BPTC_SIGNED_Format);
parcelHelpers.export(exports, "RGB_BPTC_UNSIGNED_Format", ()=>RGB_BPTC_UNSIGNED_Format);
parcelHelpers.export(exports, "RGB_ETC1_Format", ()=>RGB_ETC1_Format);
parcelHelpers.export(exports, "RGB_ETC2_Format", ()=>RGB_ETC2_Format);
parcelHelpers.export(exports, "RGB_PVRTC_2BPPV1_Format", ()=>RGB_PVRTC_2BPPV1_Format);
parcelHelpers.export(exports, "RGB_PVRTC_4BPPV1_Format", ()=>RGB_PVRTC_4BPPV1_Format);
parcelHelpers.export(exports, "RGB_S3TC_DXT1_Format", ()=>RGB_S3TC_DXT1_Format);
parcelHelpers.export(exports, "RGDepthPacking", ()=>RGDepthPacking);
parcelHelpers.export(exports, "RGFormat", ()=>RGFormat);
parcelHelpers.export(exports, "RGIntegerFormat", ()=>RGIntegerFormat);
parcelHelpers.export(exports, "RawShaderMaterial", ()=>RawShaderMaterial);
parcelHelpers.export(exports, "Ray", ()=>Ray);
parcelHelpers.export(exports, "Raycaster", ()=>Raycaster);
parcelHelpers.export(exports, "RectAreaLight", ()=>RectAreaLight);
parcelHelpers.export(exports, "RedFormat", ()=>RedFormat);
parcelHelpers.export(exports, "RedIntegerFormat", ()=>RedIntegerFormat);
parcelHelpers.export(exports, "ReinhardToneMapping", ()=>ReinhardToneMapping);
parcelHelpers.export(exports, "RenderTarget", ()=>RenderTarget);
parcelHelpers.export(exports, "RenderTarget3D", ()=>RenderTarget3D);
parcelHelpers.export(exports, "RepeatWrapping", ()=>RepeatWrapping);
parcelHelpers.export(exports, "ReplaceStencilOp", ()=>ReplaceStencilOp);
parcelHelpers.export(exports, "ReverseSubtractEquation", ()=>ReverseSubtractEquation);
parcelHelpers.export(exports, "RingGeometry", ()=>RingGeometry);
parcelHelpers.export(exports, "SIGNED_R11_EAC_Format", ()=>SIGNED_R11_EAC_Format);
parcelHelpers.export(exports, "SIGNED_RED_GREEN_RGTC2_Format", ()=>SIGNED_RED_GREEN_RGTC2_Format);
parcelHelpers.export(exports, "SIGNED_RED_RGTC1_Format", ()=>SIGNED_RED_RGTC1_Format);
parcelHelpers.export(exports, "SIGNED_RG11_EAC_Format", ()=>SIGNED_RG11_EAC_Format);
parcelHelpers.export(exports, "SRGBColorSpace", ()=>SRGBColorSpace);
parcelHelpers.export(exports, "SRGBTransfer", ()=>SRGBTransfer);
parcelHelpers.export(exports, "Scene", ()=>Scene);
parcelHelpers.export(exports, "ShaderMaterial", ()=>ShaderMaterial);
parcelHelpers.export(exports, "ShadowMaterial", ()=>ShadowMaterial);
parcelHelpers.export(exports, "Shape", ()=>Shape);
parcelHelpers.export(exports, "ShapeGeometry", ()=>ShapeGeometry);
parcelHelpers.export(exports, "ShapePath", ()=>ShapePath);
parcelHelpers.export(exports, "ShapeUtils", ()=>ShapeUtils);
parcelHelpers.export(exports, "ShortType", ()=>ShortType);
parcelHelpers.export(exports, "Skeleton", ()=>Skeleton);
parcelHelpers.export(exports, "SkeletonHelper", ()=>SkeletonHelper);
parcelHelpers.export(exports, "SkinnedMesh", ()=>SkinnedMesh);
parcelHelpers.export(exports, "Source", ()=>Source);
parcelHelpers.export(exports, "Sphere", ()=>Sphere);
parcelHelpers.export(exports, "SphereGeometry", ()=>SphereGeometry);
parcelHelpers.export(exports, "Spherical", ()=>Spherical);
parcelHelpers.export(exports, "SphericalHarmonics3", ()=>SphericalHarmonics3);
parcelHelpers.export(exports, "SplineCurve", ()=>SplineCurve);
parcelHelpers.export(exports, "SpotLight", ()=>SpotLight);
parcelHelpers.export(exports, "SpotLightHelper", ()=>SpotLightHelper);
parcelHelpers.export(exports, "Sprite", ()=>Sprite);
parcelHelpers.export(exports, "SpriteMaterial", ()=>SpriteMaterial);
parcelHelpers.export(exports, "SrcAlphaFactor", ()=>SrcAlphaFactor);
parcelHelpers.export(exports, "SrcAlphaSaturateFactor", ()=>SrcAlphaSaturateFactor);
parcelHelpers.export(exports, "SrcColorFactor", ()=>SrcColorFactor);
parcelHelpers.export(exports, "StaticCopyUsage", ()=>StaticCopyUsage);
parcelHelpers.export(exports, "StaticDrawUsage", ()=>StaticDrawUsage);
parcelHelpers.export(exports, "StaticReadUsage", ()=>StaticReadUsage);
parcelHelpers.export(exports, "StereoCamera", ()=>StereoCamera);
parcelHelpers.export(exports, "StreamCopyUsage", ()=>StreamCopyUsage);
parcelHelpers.export(exports, "StreamDrawUsage", ()=>StreamDrawUsage);
parcelHelpers.export(exports, "StreamReadUsage", ()=>StreamReadUsage);
parcelHelpers.export(exports, "StringKeyframeTrack", ()=>StringKeyframeTrack);
parcelHelpers.export(exports, "SubtractEquation", ()=>SubtractEquation);
parcelHelpers.export(exports, "SubtractiveBlending", ()=>SubtractiveBlending);
parcelHelpers.export(exports, "TOUCH", ()=>TOUCH);
parcelHelpers.export(exports, "TangentSpaceNormalMap", ()=>TangentSpaceNormalMap);
parcelHelpers.export(exports, "TetrahedronGeometry", ()=>TetrahedronGeometry);
parcelHelpers.export(exports, "Texture", ()=>Texture);
parcelHelpers.export(exports, "TextureLoader", ()=>TextureLoader);
parcelHelpers.export(exports, "TextureUtils", ()=>TextureUtils);
parcelHelpers.export(exports, "Timer", ()=>Timer);
parcelHelpers.export(exports, "TimestampQuery", ()=>TimestampQuery);
parcelHelpers.export(exports, "TorusGeometry", ()=>TorusGeometry);
parcelHelpers.export(exports, "TorusKnotGeometry", ()=>TorusKnotGeometry);
parcelHelpers.export(exports, "Triangle", ()=>Triangle);
parcelHelpers.export(exports, "TriangleFanDrawMode", ()=>TriangleFanDrawMode);
parcelHelpers.export(exports, "TriangleStripDrawMode", ()=>TriangleStripDrawMode);
parcelHelpers.export(exports, "TrianglesDrawMode", ()=>TrianglesDrawMode);
parcelHelpers.export(exports, "TubeGeometry", ()=>TubeGeometry);
parcelHelpers.export(exports, "UVMapping", ()=>UVMapping);
parcelHelpers.export(exports, "Uint16BufferAttribute", ()=>Uint16BufferAttribute);
parcelHelpers.export(exports, "Uint32BufferAttribute", ()=>Uint32BufferAttribute);
parcelHelpers.export(exports, "Uint8BufferAttribute", ()=>Uint8BufferAttribute);
parcelHelpers.export(exports, "Uint8ClampedBufferAttribute", ()=>Uint8ClampedBufferAttribute);
parcelHelpers.export(exports, "Uniform", ()=>Uniform);
parcelHelpers.export(exports, "UniformsGroup", ()=>UniformsGroup);
parcelHelpers.export(exports, "UniformsUtils", ()=>UniformsUtils);
parcelHelpers.export(exports, "UnsignedByteType", ()=>UnsignedByteType);
parcelHelpers.export(exports, "UnsignedInt101111Type", ()=>UnsignedInt101111Type);
parcelHelpers.export(exports, "UnsignedInt248Type", ()=>UnsignedInt248Type);
parcelHelpers.export(exports, "UnsignedInt5999Type", ()=>UnsignedInt5999Type);
parcelHelpers.export(exports, "UnsignedIntType", ()=>UnsignedIntType);
parcelHelpers.export(exports, "UnsignedShort4444Type", ()=>UnsignedShort4444Type);
parcelHelpers.export(exports, "UnsignedShort5551Type", ()=>UnsignedShort5551Type);
parcelHelpers.export(exports, "UnsignedShortType", ()=>UnsignedShortType);
parcelHelpers.export(exports, "VSMShadowMap", ()=>VSMShadowMap);
parcelHelpers.export(exports, "Vector2", ()=>Vector2);
parcelHelpers.export(exports, "Vector3", ()=>Vector3);
parcelHelpers.export(exports, "Vector4", ()=>Vector4);
parcelHelpers.export(exports, "VectorKeyframeTrack", ()=>VectorKeyframeTrack);
parcelHelpers.export(exports, "VideoFrameTexture", ()=>VideoFrameTexture);
parcelHelpers.export(exports, "VideoTexture", ()=>VideoTexture);
parcelHelpers.export(exports, "WebGL3DRenderTarget", ()=>WebGL3DRenderTarget);
parcelHelpers.export(exports, "WebGLArrayRenderTarget", ()=>WebGLArrayRenderTarget);
parcelHelpers.export(exports, "WebGLCoordinateSystem", ()=>WebGLCoordinateSystem);
parcelHelpers.export(exports, "WebGLCubeRenderTarget", ()=>WebGLCubeRenderTarget);
parcelHelpers.export(exports, "WebGLRenderTarget", ()=>WebGLRenderTarget);
parcelHelpers.export(exports, "WebGPUCoordinateSystem", ()=>WebGPUCoordinateSystem);
parcelHelpers.export(exports, "WebXRController", ()=>WebXRController);
parcelHelpers.export(exports, "WireframeGeometry", ()=>WireframeGeometry);
parcelHelpers.export(exports, "WrapAroundEnding", ()=>WrapAroundEnding);
parcelHelpers.export(exports, "ZeroCurvatureEnding", ()=>ZeroCurvatureEnding);
parcelHelpers.export(exports, "ZeroFactor", ()=>ZeroFactor);
parcelHelpers.export(exports, "ZeroSlopeEnding", ()=>ZeroSlopeEnding);
parcelHelpers.export(exports, "ZeroStencilOp", ()=>ZeroStencilOp);
parcelHelpers.export(exports, "arrayNeedsUint32", ()=>arrayNeedsUint32);
parcelHelpers.export(exports, "cloneUniforms", ()=>cloneUniforms);
parcelHelpers.export(exports, "createCanvasElement", ()=>createCanvasElement);
parcelHelpers.export(exports, "createElementNS", ()=>createElementNS);
parcelHelpers.export(exports, "error", ()=>error);
parcelHelpers.export(exports, "getByteLength", ()=>getByteLength);
parcelHelpers.export(exports, "getConsoleFunction", ()=>getConsoleFunction);
parcelHelpers.export(exports, "getUnlitUniformColorSpace", ()=>getUnlitUniformColorSpace);
parcelHelpers.export(exports, "isTypedArray", ()=>isTypedArray);
parcelHelpers.export(exports, "log", ()=>log);
parcelHelpers.export(exports, "mergeUniforms", ()=>mergeUniforms);
parcelHelpers.export(exports, "probeAsync", ()=>probeAsync);
parcelHelpers.export(exports, "setConsoleFunction", ()=>setConsoleFunction);
parcelHelpers.export(exports, "warn", ()=>warn);
parcelHelpers.export(exports, "warnOnce", ()=>warnOnce);
const REVISION = '182';
/**
 * Represents mouse buttons and interaction types in context of controls.
 *
 * @type {ConstantsMouse}
 * @constant
 */ const MOUSE = {
    LEFT: 0,
    MIDDLE: 1,
    RIGHT: 2,
    ROTATE: 0,
    DOLLY: 1,
    PAN: 2
};
/**
 * Represents touch interaction types in context of controls.
 *
 * @type {ConstantsTouch}
 * @constant
 */ const TOUCH = {
    ROTATE: 0,
    PAN: 1,
    DOLLY_PAN: 2,
    DOLLY_ROTATE: 3
};
/**
 * Disables face culling.
 *
 * @type {number}
 * @constant
 */ const CullFaceNone = 0;
/**
 * Culls back faces.
 *
 * @type {number}
 * @constant
 */ const CullFaceBack = 1;
/**
 * Culls front faces.
 *
 * @type {number}
 * @constant
 */ const CullFaceFront = 2;
/**
 * Culls both front and back faces.
 *
 * @type {number}
 * @constant
 */ const CullFaceFrontBack = 3;
/**
 * Gives unfiltered shadow maps - fastest, but lowest quality.
 *
 * @type {number}
 * @constant
 */ const BasicShadowMap = 0;
/**
 * Filters shadow maps using the Percentage-Closer Filtering (PCF) algorithm.
 *
 * @type {number}
 * @constant
 */ const PCFShadowMap = 1;
/**
 * Filters shadow maps using the Percentage-Closer Filtering (PCF) algorithm with
 * better soft shadows especially when using low-resolution shadow maps.
 *
 * @type {number}
 * @constant
 */ const PCFSoftShadowMap = 2;
/**
 * Filters shadow maps using the Variance Shadow Map (VSM) algorithm.
 * When using VSMShadowMap all shadow receivers will also cast shadows.
 *
 * @type {number}
 * @constant
 */ const VSMShadowMap = 3;
/**
 * Only front faces are rendered.
 *
 * @type {number}
 * @constant
 */ const FrontSide = 0;
/**
 * Only back faces are rendered.
 *
 * @type {number}
 * @constant
 */ const BackSide = 1;
/**
 * Both front and back faces are rendered.
 *
 * @type {number}
 * @constant
 */ const DoubleSide = 2;
/**
 * No blending is performed which effectively disables
 * alpha transparency.
 *
 * @type {number}
 * @constant
 */ const NoBlending = 0;
/**
 * The default blending.
 *
 * @type {number}
 * @constant
 */ const NormalBlending = 1;
/**
 * Represents additive blending.
 *
 * @type {number}
 * @constant
 */ const AdditiveBlending = 2;
/**
 * Represents subtractive blending.
 *
 * @type {number}
 * @constant
 */ const SubtractiveBlending = 3;
/**
 * Represents multiply blending.
 *
 * @type {number}
 * @constant
 */ const MultiplyBlending = 4;
/**
 * Represents custom blending.
 *
 * @type {number}
 * @constant
 */ const CustomBlending = 5;
/**
 * A `source + destination` blending equation.
 *
 * @type {number}
 * @constant
 */ const AddEquation = 100;
/**
 * A `source - destination` blending equation.
 *
 * @type {number}
 * @constant
 */ const SubtractEquation = 101;
/**
 * A `destination - source` blending equation.
 *
 * @type {number}
 * @constant
 */ const ReverseSubtractEquation = 102;
/**
 * A blend equation that uses the minimum of source and destination.
 *
 * @type {number}
 * @constant
 */ const MinEquation = 103;
/**
 * A blend equation that uses the maximum of source and destination.
 *
 * @type {number}
 * @constant
 */ const MaxEquation = 104;
/**
 * Multiplies all colors by `0`.
 *
 * @type {number}
 * @constant
 */ const ZeroFactor = 200;
/**
 * Multiplies all colors by `1`.
 *
 * @type {number}
 * @constant
 */ const OneFactor = 201;
/**
 * Multiplies all colors by the source colors.
 *
 * @type {number}
 * @constant
 */ const SrcColorFactor = 202;
/**
 * Multiplies all colors by `1` minus each source color.
 *
 * @type {number}
 * @constant
 */ const OneMinusSrcColorFactor = 203;
/**
 * Multiplies all colors by the source alpha value.
 *
 * @type {number}
 * @constant
 */ const SrcAlphaFactor = 204;
/**
 * Multiplies all colors by 1 minus the source alpha value.
 *
 * @type {number}
 * @constant
 */ const OneMinusSrcAlphaFactor = 205;
/**
 * Multiplies all colors by the destination alpha value.
 *
 * @type {number}
 * @constant
 */ const DstAlphaFactor = 206;
/**
 * Multiplies all colors by `1` minus the destination alpha value.
 *
 * @type {number}
 * @constant
 */ const OneMinusDstAlphaFactor = 207;
/**
 * Multiplies all colors by the destination color.
 *
 * @type {number}
 * @constant
 */ const DstColorFactor = 208;
/**
 * Multiplies all colors by `1` minus each destination color.
 *
 * @type {number}
 * @constant
 */ const OneMinusDstColorFactor = 209;
/**
 * Multiplies the RGB colors by the smaller of either the source alpha
 * value or the value of `1` minus the destination alpha value. The alpha
 * value is multiplied by `1`.
 *
 * @type {number}
 * @constant
 */ const SrcAlphaSaturateFactor = 210;
/**
 * Multiplies all colors by a constant color.
 *
 * @type {number}
 * @constant
 */ const ConstantColorFactor = 211;
/**
 * Multiplies all colors by `1` minus a constant color.
 *
 * @type {number}
 * @constant
 */ const OneMinusConstantColorFactor = 212;
/**
 * Multiplies all colors by a constant alpha value.
 *
 * @type {number}
 * @constant
 */ const ConstantAlphaFactor = 213;
/**
 * Multiplies all colors by 1 minus a constant alpha value.
 *
 * @type {number}
 * @constant
 */ const OneMinusConstantAlphaFactor = 214;
/**
 * Never pass.
 *
 * @type {number}
 * @constant
 */ const NeverDepth = 0;
/**
 * Always pass.
 *
 * @type {number}
 * @constant
 */ const AlwaysDepth = 1;
/**
 * Pass if the incoming value is less than the depth buffer value.
 *
 * @type {number}
 * @constant
 */ const LessDepth = 2;
/**
 * Pass if the incoming value is less than or equal to the depth buffer value.
 *
 * @type {number}
 * @constant
 */ const LessEqualDepth = 3;
/**
 * Pass if the incoming value equals the depth buffer value.
 *
 * @type {number}
 * @constant
 */ const EqualDepth = 4;
/**
 * Pass if the incoming value is greater than or equal to the depth buffer value.
 *
 * @type {number}
 * @constant
 */ const GreaterEqualDepth = 5;
/**
 * Pass if the incoming value is greater than the depth buffer value.
 *
 * @type {number}
 * @constant
 */ const GreaterDepth = 6;
/**
 * Pass if the incoming value is not equal to the depth buffer value.
 *
 * @type {number}
 * @constant
 */ const NotEqualDepth = 7;
/**
 * Multiplies the environment map color with the surface color.
 *
 * @type {number}
 * @constant
 */ const MultiplyOperation = 0;
/**
 * Uses reflectivity to blend between the two colors.
 *
 * @type {number}
 * @constant
 */ const MixOperation = 1;
/**
 * Adds the two colors.
 *
 * @type {number}
 * @constant
 */ const AddOperation = 2;
/**
 * No tone mapping is applied.
 *
 * @type {number}
 * @constant
 */ const NoToneMapping = 0;
/**
 * Linear tone mapping.
 *
 * @type {number}
 * @constant
 */ const LinearToneMapping = 1;
/**
 * Reinhard tone mapping.
 *
 * @type {number}
 * @constant
 */ const ReinhardToneMapping = 2;
/**
 * Cineon tone mapping.
 *
 * @type {number}
 * @constant
 */ const CineonToneMapping = 3;
/**
 * ACES Filmic tone mapping.
 *
 * @type {number}
 * @constant
 */ const ACESFilmicToneMapping = 4;
/**
 * Custom tone mapping.
 *
 * Expects a custom implementation by modifying shader code of the material's fragment shader.
 *
 * @type {number}
 * @constant
 */ const CustomToneMapping = 5;
/**
 * AgX tone mapping.
 *
 * @type {number}
 * @constant
 */ const AgXToneMapping = 6;
/**
 * Neutral tone mapping.
 *
 * Implementation based on the Khronos 3D Commerce Group standard tone mapping.
 *
 * @type {number}
 * @constant
 */ const NeutralToneMapping = 7;
/**
 * The skinned mesh shares the same world space as the skeleton.
 *
 * @type {string}
 * @constant
 */ const AttachedBindMode = 'attached';
/**
 * The skinned mesh does not share the same world space as the skeleton.
 * This is useful when a skeleton is shared across multiple skinned meshes.
 *
 * @type {string}
 * @constant
 */ const DetachedBindMode = 'detached';
/**
 * Maps textures using the geometry's UV coordinates.
 *
 * @type {number}
 * @constant
 */ const UVMapping = 300;
/**
 * Reflection mapping for cube textures.
 *
 * @type {number}
 * @constant
 */ const CubeReflectionMapping = 301;
/**
 * Refraction mapping for cube textures.
 *
 * @type {number}
 * @constant
 */ const CubeRefractionMapping = 302;
/**
 * Reflection mapping for equirectangular textures.
 *
 * @type {number}
 * @constant
 */ const EquirectangularReflectionMapping = 303;
/**
 * Refraction mapping for equirectangular textures.
 *
 * @type {number}
 * @constant
 */ const EquirectangularRefractionMapping = 304;
/**
 * Reflection mapping for PMREM textures.
 *
 * @type {number}
 * @constant
 */ const CubeUVReflectionMapping = 306;
/**
 * The texture will simply repeat to infinity.
 *
 * @type {number}
 * @constant
 */ const RepeatWrapping = 1000;
/**
 * The last pixel of the texture stretches to the edge of the mesh.
 *
 * @type {number}
 * @constant
 */ const ClampToEdgeWrapping = 1001;
/**
 * The texture will repeats to infinity, mirroring on each repeat.
 *
 * @type {number}
 * @constant
 */ const MirroredRepeatWrapping = 1002;
/**
 * Returns the value of the texture element that is nearest (in Manhattan distance)
 * to the specified texture coordinates.
 *
 * @type {number}
 * @constant
 */ const NearestFilter = 1003;
/**
 * Chooses the mipmap that most closely matches the size of the pixel being textured
 * and uses the `NearestFilter` criterion (the texel nearest to the center of the pixel)
 * to produce a texture value.
 *
 * @type {number}
 * @constant
 */ const NearestMipmapNearestFilter = 1004;
const NearestMipMapNearestFilter = 1004; // legacy
/**
 * Chooses the two mipmaps that most closely match the size of the pixel being textured and
 * uses the `NearestFilter` criterion to produce a texture value from each mipmap.
 * The final texture value is a weighted average of those two values.
 *
 * @type {number}
 * @constant
 */ const NearestMipmapLinearFilter = 1005;
const NearestMipMapLinearFilter = 1005; // legacy
/**
 * Returns the weighted average of the four texture elements that are closest to the specified
 * texture coordinates, and can include items wrapped or repeated from other parts of a texture,
 * depending on the values of `wrapS` and `wrapT`, and on the exact mapping.
 *
 * @type {number}
 * @constant
 */ const LinearFilter = 1006;
/**
 * Chooses the mipmap that most closely matches the size of the pixel being textured and uses
 * the `LinearFilter` criterion (a weighted average of the four texels that are closest to the
 * center of the pixel) to produce a texture value.
 *
 * @type {number}
 * @constant
 */ const LinearMipmapNearestFilter = 1007;
const LinearMipMapNearestFilter = 1007; // legacy
/**
 * Chooses the two mipmaps that most closely match the size of the pixel being textured and uses
 * the `LinearFilter` criterion to produce a texture value from each mipmap. The final texture value
 * is a weighted average of those two values.
 *
 * @type {number}
 * @constant
 */ const LinearMipmapLinearFilter = 1008;
const LinearMipMapLinearFilter = 1008; // legacy
/**
 * An unsigned byte data type for textures.
 *
 * @type {number}
 * @constant
 */ const UnsignedByteType = 1009;
/**
 * A byte data type for textures.
 *
 * @type {number}
 * @constant
 */ const ByteType = 1010;
/**
 * A short data type for textures.
 *
 * @type {number}
 * @constant
 */ const ShortType = 1011;
/**
 * An unsigned short data type for textures.
 *
 * @type {number}
 * @constant
 */ const UnsignedShortType = 1012;
/**
 * An int data type for textures.
 *
 * @type {number}
 * @constant
 */ const IntType = 1013;
/**
 * An unsigned int data type for textures.
 *
 * @type {number}
 * @constant
 */ const UnsignedIntType = 1014;
/**
 * A float data type for textures.
 *
 * @type {number}
 * @constant
 */ const FloatType = 1015;
/**
 * A half float data type for textures.
 *
 * @type {number}
 * @constant
 */ const HalfFloatType = 1016;
/**
 * An unsigned short 4_4_4_4 (packed) data type for textures.
 *
 * @type {number}
 * @constant
 */ const UnsignedShort4444Type = 1017;
/**
 * An unsigned short 5_5_5_1 (packed) data type for textures.
 *
 * @type {number}
 * @constant
 */ const UnsignedShort5551Type = 1018;
/**
 * An unsigned int 24_8 data type for textures.
 *
 * @type {number}
 * @constant
 */ const UnsignedInt248Type = 1020;
/**
 * An unsigned int 5_9_9_9 (packed) data type for textures.
 *
 * @type {number}
 * @constant
 */ const UnsignedInt5999Type = 35902;
/**
 * An unsigned int 10_11_11 (packed) data type for textures.
 *
 * @type {number}
 * @constant
 */ const UnsignedInt101111Type = 35899;
/**
 * Discards the red, green and blue components and reads just the alpha component.
 *
 * @type {number}
 * @constant
 */ const AlphaFormat = 1021;
/**
 * Discards the alpha component and reads the red, green and blue component.
 *
 * @type {number}
 * @constant
 */ const RGBFormat = 1022;
/**
 * Reads the red, green, blue and alpha components.
 *
 * @type {number}
 * @constant
 */ const RGBAFormat = 1023;
/**
 * Reads each element as a single depth value, converts it to floating point, and clamps to the range `[0,1]`.
 *
 * @type {number}
 * @constant
 */ const DepthFormat = 1026;
/**
 * Reads each element is a pair of depth and stencil values. The depth component of the pair is interpreted as
 * in `DepthFormat`. The stencil component is interpreted based on the depth + stencil internal format.
 *
 * @type {number}
 * @constant
 */ const DepthStencilFormat = 1027;
/**
 * Discards the green, blue and alpha components and reads just the red component.
 *
 * @type {number}
 * @constant
 */ const RedFormat = 1028;
/**
 * Discards the green, blue and alpha components and reads just the red component. The texels are read as integers instead of floating point.
 *
 * @type {number}
 * @constant
 */ const RedIntegerFormat = 1029;
/**
 * Discards the alpha, and blue components and reads the red, and green components.
 *
 * @type {number}
 * @constant
 */ const RGFormat = 1030;
/**
 * Discards the alpha, and blue components and reads the red, and green components. The texels are read as integers instead of floating point.
 *
 * @type {number}
 * @constant
 */ const RGIntegerFormat = 1031;
/**
 * Discards the alpha component and reads the red, green and blue component. The texels are read as integers instead of floating point.
 *
 * @type {number}
 * @constant
 */ const RGBIntegerFormat = 1032;
/**
 * Reads the red, green, blue and alpha components. The texels are read as integers instead of floating point.
 *
 * @type {number}
 * @constant
 */ const RGBAIntegerFormat = 1033;
/**
 * A DXT1-compressed image in an RGB image format.
 *
 * @type {number}
 * @constant
 */ const RGB_S3TC_DXT1_Format = 33776;
/**
 * A DXT1-compressed image in an RGB image format with a simple on/off alpha value.
 *
 * @type {number}
 * @constant
 */ const RGBA_S3TC_DXT1_Format = 33777;
/**
 * A DXT3-compressed image in an RGBA image format. Compared to a 32-bit RGBA texture, it offers 4:1 compression.
 *
 * @type {number}
 * @constant
 */ const RGBA_S3TC_DXT3_Format = 33778;
/**
 * A DXT5-compressed image in an RGBA image format. It also provides a 4:1 compression, but differs to the DXT3
 * compression in how the alpha compression is done.
 *
 * @type {number}
 * @constant
 */ const RGBA_S3TC_DXT5_Format = 33779;
/**
 * PVRTC RGB compression in 4-bit mode. One block for each 4×4 pixels.
 *
 * @type {number}
 * @constant
 */ const RGB_PVRTC_4BPPV1_Format = 35840;
/**
 * PVRTC RGB compression in 2-bit mode. One block for each 8×4 pixels.
 *
 * @type {number}
 * @constant
 */ const RGB_PVRTC_2BPPV1_Format = 35841;
/**
 * PVRTC RGBA compression in 4-bit mode. One block for each 4×4 pixels.
 *
 * @type {number}
 * @constant
 */ const RGBA_PVRTC_4BPPV1_Format = 35842;
/**
 * PVRTC RGBA compression in 2-bit mode. One block for each 8×4 pixels.
 *
 * @type {number}
 * @constant
 */ const RGBA_PVRTC_2BPPV1_Format = 35843;
/**
 * ETC1 RGB format.
 *
 * @type {number}
 * @constant
 */ const RGB_ETC1_Format = 36196;
/**
 * ETC2 RGB format.
 *
 * @type {number}
 * @constant
 */ const RGB_ETC2_Format = 37492;
/**
 * ETC2 RGBA format.
 *
 * @type {number}
 * @constant
 */ const RGBA_ETC2_EAC_Format = 37496;
/**
 * EAC R11 UNORM format.
 *
 * @type {number}
 * @constant
 */ const R11_EAC_Format = 37488; // 0x9270
/**
 * EAC R11 SNORM format.
 *
 * @type {number}
 * @constant
 */ const SIGNED_R11_EAC_Format = 37489; // 0x9271
/**
 * EAC RG11 UNORM format.
 *
 * @type {number}
 * @constant
 */ const RG11_EAC_Format = 37490; // 0x9272
/**
 * EAC RG11 SNORM format.
 *
 * @type {number}
 * @constant
 */ const SIGNED_RG11_EAC_Format = 37491; // 0x9273
/**
 * ASTC RGBA 4x4 format.
 *
 * @type {number}
 * @constant
 */ const RGBA_ASTC_4x4_Format = 37808;
/**
 * ASTC RGBA 5x4 format.
 *
 * @type {number}
 * @constant
 */ const RGBA_ASTC_5x4_Format = 37809;
/**
 * ASTC RGBA 5x5 format.
 *
 * @type {number}
 * @constant
 */ const RGBA_ASTC_5x5_Format = 37810;
/**
 * ASTC RGBA 6x5 format.
 *
 * @type {number}
 * @constant
 */ const RGBA_ASTC_6x5_Format = 37811;
/**
 * ASTC RGBA 6x6 format.
 *
 * @type {number}
 * @constant
 */ const RGBA_ASTC_6x6_Format = 37812;
/**
 * ASTC RGBA 8x5 format.
 *
 * @type {number}
 * @constant
 */ const RGBA_ASTC_8x5_Format = 37813;
/**
 * ASTC RGBA 8x6 format.
 *
 * @type {number}
 * @constant
 */ const RGBA_ASTC_8x6_Format = 37814;
/**
 * ASTC RGBA 8x8 format.
 *
 * @type {number}
 * @constant
 */ const RGBA_ASTC_8x8_Format = 37815;
/**
 * ASTC RGBA 10x5 format.
 *
 * @type {number}
 * @constant
 */ const RGBA_ASTC_10x5_Format = 37816;
/**
 * ASTC RGBA 10x6 format.
 *
 * @type {number}
 * @constant
 */ const RGBA_ASTC_10x6_Format = 37817;
/**
 * ASTC RGBA 10x8 format.
 *
 * @type {number}
 * @constant
 */ const RGBA_ASTC_10x8_Format = 37818;
/**
 * ASTC RGBA 10x10 format.
 *
 * @type {number}
 * @constant
 */ const RGBA_ASTC_10x10_Format = 37819;
/**
 * ASTC RGBA 12x10 format.
 *
 * @type {number}
 * @constant
 */ const RGBA_ASTC_12x10_Format = 37820;
/**
 * ASTC RGBA 12x12 format.
 *
 * @type {number}
 * @constant
 */ const RGBA_ASTC_12x12_Format = 37821;
/**
 * BPTC RGBA format.
 *
 * @type {number}
 * @constant
 */ const RGBA_BPTC_Format = 36492;
/**
 * BPTC Signed RGB format.
 *
 * @type {number}
 * @constant
 */ const RGB_BPTC_SIGNED_Format = 36494;
/**
 * BPTC Unsigned RGB format.
 *
 * @type {number}
 * @constant
 */ const RGB_BPTC_UNSIGNED_Format = 36495;
/**
 * RGTC1 Red format.
 *
 * @type {number}
 * @constant
 */ const RED_RGTC1_Format = 36283;
/**
 * RGTC1 Signed Red format.
 *
 * @type {number}
 * @constant
 */ const SIGNED_RED_RGTC1_Format = 36284;
/**
 * RGTC2 Red Green format.
 *
 * @type {number}
 * @constant
 */ const RED_GREEN_RGTC2_Format = 36285;
/**
 * RGTC2 Signed Red Green format.
 *
 * @type {number}
 * @constant
 */ const SIGNED_RED_GREEN_RGTC2_Format = 36286;
/**
 * Animations are played once.
 *
 * @type {number}
 * @constant
 */ const LoopOnce = 2200;
/**
 * Animations are played with a chosen number of repetitions, each time jumping from
 * the end of the clip directly to its beginning.
 *
 * @type {number}
 * @constant
 */ const LoopRepeat = 2201;
/**
 * Animations are played with a chosen number of repetitions, alternately playing forward
 * and backward.
 *
 * @type {number}
 * @constant
 */ const LoopPingPong = 2202;
/**
 * Discrete interpolation mode for keyframe tracks.
 *
 * @type {number}
 * @constant
 */ const InterpolateDiscrete = 2300;
/**
 * Linear interpolation mode for keyframe tracks.
 *
 * @type {number}
 * @constant
 */ const InterpolateLinear = 2301;
/**
 * Smooth interpolation mode for keyframe tracks.
 *
 * @type {number}
 * @constant
 */ const InterpolateSmooth = 2302;
/**
 * Zero curvature ending for animations.
 *
 * @type {number}
 * @constant
 */ const ZeroCurvatureEnding = 2400;
/**
 * Zero slope ending for animations.
 *
 * @type {number}
 * @constant
 */ const ZeroSlopeEnding = 2401;
/**
 * Wrap around ending for animations.
 *
 * @type {number}
 * @constant
 */ const WrapAroundEnding = 2402;
/**
 * Default animation blend mode.
 *
 * @type {number}
 * @constant
 */ const NormalAnimationBlendMode = 2500;
/**
 * Additive animation blend mode. Can be used to layer motions on top of
 * each other to build complex performances from smaller re-usable assets.
 *
 * @type {number}
 * @constant
 */ const AdditiveAnimationBlendMode = 2501;
/**
 * For every three vertices draw a single triangle.
 *
 * @type {number}
 * @constant
 */ const TrianglesDrawMode = 0;
/**
 * For each vertex draw a triangle from the last three vertices.
 *
 * @type {number}
 * @constant
 */ const TriangleStripDrawMode = 1;
/**
 * For each vertex draw a triangle from the first vertex and the last two vertices.
 *
 * @type {number}
 * @constant
 */ const TriangleFanDrawMode = 2;
/**
 * The depth value is inverted (1.0 - z) for visualization purposes.
 *
 * @type {number}
 * @constant
 */ const BasicDepthPacking = 3200;
/**
 * The depth value is packed into 32 bit RGBA.
 *
 * @type {number}
 * @constant
 */ const RGBADepthPacking = 3201;
/**
 * The depth value is packed into 24 bit RGB.
 *
 * @type {number}
 * @constant
 */ const RGBDepthPacking = 3202;
/**
 * The depth value is packed into 16 bit RG.
 *
 * @type {number}
 * @constant
 */ const RGDepthPacking = 3203;
/**
 * Normal information is relative to the underlying surface.
 *
 * @type {number}
 * @constant
 */ const TangentSpaceNormalMap = 0;
/**
 * Normal information is relative to the object orientation.
 *
 * @type {number}
 * @constant
 */ const ObjectSpaceNormalMap = 1;
// Color space string identifiers, matching CSS Color Module Level 4 and WebGPU names where available.
/**
 * No color space.
 *
 * @type {string}
 * @constant
 */ const NoColorSpace = '';
/**
 * sRGB color space.
 *
 * @type {string}
 * @constant
 */ const SRGBColorSpace = 'srgb';
/**
 * sRGB-linear color space.
 *
 * @type {string}
 * @constant
 */ const LinearSRGBColorSpace = 'srgb-linear';
/**
 * Linear transfer function.
 *
 * @type {string}
 * @constant
 */ const LinearTransfer = 'linear';
/**
 * sRGB transfer function.
 *
 * @type {string}
 * @constant
 */ const SRGBTransfer = 'srgb';
/**
 * No normal map packing.
 *
 * @type {string}
 * @constant
 */ const NoNormalPacking = '';
/**
 * Normal RG packing.
 *
 * @type {string}
 * @constant
 */ const NormalRGPacking = 'rg';
/**
 * Normal GA packing.
 *
 * @type {string}
 * @constant
 */ const NormalGAPacking = 'ga';
/**
 * Sets the stencil buffer value to `0`.
 *
 * @type {number}
 * @constant
 */ const ZeroStencilOp = 0;
/**
 * Keeps the current value.
 *
 * @type {number}
 * @constant
 */ const KeepStencilOp = 7680;
/**
 * Sets the stencil buffer value to the specified reference value.
 *
 * @type {number}
 * @constant
 */ const ReplaceStencilOp = 7681;
/**
 * Increments the current stencil buffer value. Clamps to the maximum representable unsigned value.
 *
 * @type {number}
 * @constant
 */ const IncrementStencilOp = 7682;
/**
 * Decrements the current stencil buffer value. Clamps to `0`.
 *
 * @type {number}
 * @constant
 */ const DecrementStencilOp = 7683;
/**
 * Increments the current stencil buffer value. Wraps stencil buffer value to zero when incrementing
 * the maximum representable unsigned value.
 *
 * @type {number}
 * @constant
 */ const IncrementWrapStencilOp = 34055;
/**
 * Decrements the current stencil buffer value. Wraps stencil buffer value to the maximum representable
 * unsigned value when decrementing a stencil buffer value of `0`.
 *
 * @type {number}
 * @constant
 */ const DecrementWrapStencilOp = 34056;
/**
 * Inverts the current stencil buffer value bitwise.
 *
 * @type {number}
 * @constant
 */ const InvertStencilOp = 5386;
/**
 * Will never return true.
 *
 * @type {number}
 * @constant
 */ const NeverStencilFunc = 512;
/**
 * Will return true if the stencil reference value is less than the current stencil value.
 *
 * @type {number}
 * @constant
 */ const LessStencilFunc = 513;
/**
 * Will return true if the stencil reference value is equal to the current stencil value.
 *
 * @type {number}
 * @constant
 */ const EqualStencilFunc = 514;
/**
 * Will return true if the stencil reference value is less than or equal to the current stencil value.
 *
 * @type {number}
 * @constant
 */ const LessEqualStencilFunc = 515;
/**
 * Will return true if the stencil reference value is greater than the current stencil value.
 *
 * @type {number}
 * @constant
 */ const GreaterStencilFunc = 516;
/**
 * Will return true if the stencil reference value is not equal to the current stencil value.
 *
 * @type {number}
 * @constant
 */ const NotEqualStencilFunc = 517;
/**
 * Will return true if the stencil reference value is greater than or equal to the current stencil value.
 *
 * @type {number}
 * @constant
 */ const GreaterEqualStencilFunc = 518;
/**
 * Will always return true.
 *
 * @type {number}
 * @constant
 */ const AlwaysStencilFunc = 519;
/**
 * Never pass.
 *
 * @type {number}
 * @constant
 */ const NeverCompare = 512;
/**
 * Pass if the incoming value is less than the texture value.
 *
 * @type {number}
 * @constant
 */ const LessCompare = 513;
/**
 * Pass if the incoming value equals the texture value.
 *
 * @type {number}
 * @constant
 */ const EqualCompare = 514;
/**
 * Pass if the incoming value is less than or equal to the texture value.
 *
 * @type {number}
 * @constant
 */ const LessEqualCompare = 515;
/**
 * Pass if the incoming value is greater than the texture value.
 *
 * @type {number}
 * @constant
 */ const GreaterCompare = 516;
/**
 * Pass if the incoming value is not equal to the texture value.
 *
 * @type {number}
 * @constant
 */ const NotEqualCompare = 517;
/**
 * Pass if the incoming value is greater than or equal to the texture value.
 *
 * @type {number}
 * @constant
 */ const GreaterEqualCompare = 518;
/**
 * Always pass.
 *
 * @type {number}
 * @constant
 */ const AlwaysCompare = 519;
/**
 * The contents are intended to be specified once by the application, and used many
 * times as the source for drawing and image specification commands.
 *
 * @type {number}
 * @constant
 */ const StaticDrawUsage = 35044;
/**
 * The contents are intended to be respecified repeatedly by the application, and
 * used many times as the source for drawing and image specification commands.
 *
 * @type {number}
 * @constant
 */ const DynamicDrawUsage = 35048;
/**
 * The contents are intended to be specified once by the application, and used at most
 * a few times as the source for drawing and image specification commands.
 *
 * @type {number}
 * @constant
 */ const StreamDrawUsage = 35040;
/**
 * The contents are intended to be specified once by reading data from the 3D API, and queried
 * many times by the application.
 *
 * @type {number}
 * @constant
 */ const StaticReadUsage = 35045;
/**
 * The contents are intended to be respecified repeatedly by reading data from the 3D API, and queried
 * many times by the application.
 *
 * @type {number}
 * @constant
 */ const DynamicReadUsage = 35049;
/**
 * The contents are intended to be specified once by reading data from the 3D API, and queried at most
 * a few times by the application
 *
 * @type {number}
 * @constant
 */ const StreamReadUsage = 35041;
/**
 * The contents are intended to be specified once by reading data from the 3D API, and used many times as
 * the source for WebGL drawing and image specification commands.
 *
 * @type {number}
 * @constant
 */ const StaticCopyUsage = 35046;
/**
 * The contents are intended to be respecified repeatedly by reading data from the 3D API, and used many times
 * as the source for WebGL drawing and image specification commands.
 *
 * @type {number}
 * @constant
 */ const DynamicCopyUsage = 35050;
/**
 * The contents are intended to be specified once by reading data from the 3D API, and used at most a few times
 * as the source for WebGL drawing and image specification commands.
 *
 * @type {number}
 * @constant
 */ const StreamCopyUsage = 35042;
/**
 * GLSL 1 shader code.
 *
 * @type {string}
 * @constant
 */ const GLSL1 = '100';
/**
 * GLSL 3 shader code.
 *
 * @type {string}
 * @constant
 */ const GLSL3 = '300 es';
/**
 * WebGL coordinate system.
 *
 * @type {number}
 * @constant
 */ const WebGLCoordinateSystem = 2000;
/**
 * WebGPU coordinate system.
 *
 * @type {number}
 * @constant
 */ const WebGPUCoordinateSystem = 2001;
/**
 * Represents the different timestamp query types.
 *
 * @type {ConstantsTimestampQuery}
 * @constant
 */ const TimestampQuery = {
    COMPUTE: 'compute',
    RENDER: 'render'
};
/**
 * Represents mouse buttons and interaction types in context of controls.
 *
 * @type {ConstantsInterpolationSamplingType}
 * @constant
 */ const InterpolationSamplingType = {
    PERSPECTIVE: 'perspective',
    LINEAR: 'linear',
    FLAT: 'flat'
};
/**
 * Represents the different interpolation sampling modes.
 *
 * @type {ConstantsInterpolationSamplingMode}
 * @constant
 */ const InterpolationSamplingMode = {
    NORMAL: 'normal',
    CENTROID: 'centroid',
    SAMPLE: 'sample',
    FIRST: 'first',
    EITHER: 'either'
};
/**
 * This type represents mouse buttons and interaction types in context of controls.
 *
 * @typedef {Object} ConstantsMouse
 * @property {number} MIDDLE - The left mouse button.
 * @property {number} LEFT - The middle mouse button.
 * @property {number} RIGHT - The right mouse button.
 * @property {number} ROTATE - A rotate interaction.
 * @property {number} DOLLY - A dolly interaction.
 * @property {number} PAN - A pan interaction.
 **/ /**
 * This type represents touch interaction types in context of controls.
 *
 * @typedef {Object} ConstantsTouch
 * @property {number} ROTATE - A rotate interaction.
 * @property {number} PAN - A pan interaction.
 * @property {number} DOLLY_PAN - The dolly-pan interaction.
 * @property {number} DOLLY_ROTATE - A dolly-rotate interaction.
 **/ /**
 * This type represents the different timestamp query types.
 *
 * @typedef {Object} ConstantsTimestampQuery
 * @property {string} COMPUTE - A `compute` timestamp query.
 * @property {string} RENDER - A `render` timestamp query.
 **/ /**
 * Represents the different interpolation sampling types.
 *
 * @typedef {Object} ConstantsInterpolationSamplingType
 * @property {string} PERSPECTIVE - Perspective-correct interpolation.
 * @property {string} LINEAR - Linear interpolation.
 * @property {string} FLAT - Flat interpolation.
 */ /**
 * Represents the different interpolation sampling modes.
 *
 * @typedef {Object} ConstantsInterpolationSamplingMode
 * @property {string} NORMAL - Normal sampling mode.
 * @property {string} CENTROID - Centroid sampling mode.
 * @property {string} SAMPLE - Sample-specific sampling mode.
 * @property {string} FIRST - Flat interpolation using the first vertex.
 * @property {string} EITHER - Flat interpolation using either vertex.
 */ function arrayNeedsUint32(array) {
    // assumes larger values usually on last
    for(let i = array.length - 1; i >= 0; --i){
        if (array[i] >= 65535) return true; // account for PRIMITIVE_RESTART_FIXED_INDEX, #24565
    }
    return false;
}
const TYPED_ARRAYS = {
    Int8Array: Int8Array,
    Uint8Array: Uint8Array,
    Uint8ClampedArray: Uint8ClampedArray,
    Int16Array: Int16Array,
    Uint16Array: Uint16Array,
    Int32Array: Int32Array,
    Uint32Array: Uint32Array,
    Float32Array: Float32Array,
    Float64Array: Float64Array
};
function getTypedArray(type, buffer) {
    return new TYPED_ARRAYS[type](buffer);
}
/**
 * Returns `true` if the given object is a typed array.
 *
 * @param {any} array - The object to check.
 * @return {boolean} Whether the given object is a typed array.
 */ function isTypedArray(array) {
    return ArrayBuffer.isView(array) && !(array instanceof DataView);
}
function createElementNS(name) {
    return document.createElementNS('http://www.w3.org/1999/xhtml', name);
}
function createCanvasElement() {
    const canvas = createElementNS('canvas');
    canvas.style.display = 'block';
    return canvas;
}
const _cache = {};
let _setConsoleFunction = null;
function setConsoleFunction(fn) {
    _setConsoleFunction = fn;
}
function getConsoleFunction() {
    return _setConsoleFunction;
}
function log(...params) {
    const message = 'THREE.' + params.shift();
    if (_setConsoleFunction) _setConsoleFunction('log', message, ...params);
    else console.log(message, ...params);
}
function warn(...params) {
    const message = 'THREE.' + params.shift();
    if (_setConsoleFunction) _setConsoleFunction('warn', message, ...params);
    else console.warn(message, ...params);
}
function error(...params) {
    const message = 'THREE.' + params.shift();
    if (_setConsoleFunction) _setConsoleFunction('error', message, ...params);
    else console.error(message, ...params);
}
function warnOnce(...params) {
    const message = params.join(' ');
    if (message in _cache) return;
    _cache[message] = true;
    warn(...params);
}
function probeAsync(gl, sync, interval) {
    return new Promise(function(resolve, reject) {
        function probe() {
            switch(gl.clientWaitSync(sync, gl.SYNC_FLUSH_COMMANDS_BIT, 0)){
                case gl.WAIT_FAILED:
                    reject();
                    break;
                case gl.TIMEOUT_EXPIRED:
                    setTimeout(probe, interval);
                    break;
                default:
                    resolve();
            }
        }
        setTimeout(probe, interval);
    });
}
/**
 * This modules allows to dispatch event objects on custom JavaScript objects.
 *
 * Main repository: [eventdispatcher.js](https://github.com/mrdoob/eventdispatcher.js/)
 *
 * Code Example:
 * ```js
 * class Car extends EventDispatcher {
 * 	start() {
 *		this.dispatchEvent( { type: 'start', message: 'vroom vroom!' } );
 *	}
 *};
 *
 * // Using events with the custom object
 * const car = new Car();
 * car.addEventListener( 'start', function ( event ) {
 * 	alert( event.message );
 * } );
 *
 * car.start();
 * ```
 */ class EventDispatcher {
    /**
	 * Adds the given event listener to the given event type.
	 *
	 * @param {string} type - The type of event to listen to.
	 * @param {Function} listener - The function that gets called when the event is fired.
	 */ addEventListener(type, listener) {
        if (this._listeners === undefined) this._listeners = {};
        const listeners = this._listeners;
        if (listeners[type] === undefined) listeners[type] = [];
        if (listeners[type].indexOf(listener) === -1) listeners[type].push(listener);
    }
    /**
	 * Returns `true` if the given event listener has been added to the given event type.
	 *
	 * @param {string} type - The type of event.
	 * @param {Function} listener - The listener to check.
	 * @return {boolean} Whether the given event listener has been added to the given event type.
	 */ hasEventListener(type, listener) {
        const listeners = this._listeners;
        if (listeners === undefined) return false;
        return listeners[type] !== undefined && listeners[type].indexOf(listener) !== -1;
    }
    /**
	 * Removes the given event listener from the given event type.
	 *
	 * @param {string} type - The type of event.
	 * @param {Function} listener - The listener to remove.
	 */ removeEventListener(type, listener) {
        const listeners = this._listeners;
        if (listeners === undefined) return;
        const listenerArray = listeners[type];
        if (listenerArray !== undefined) {
            const index = listenerArray.indexOf(listener);
            if (index !== -1) listenerArray.splice(index, 1);
        }
    }
    /**
	 * Dispatches an event object.
	 *
	 * @param {Object} event - The event that gets fired.
	 */ dispatchEvent(event) {
        const listeners = this._listeners;
        if (listeners === undefined) return;
        const listenerArray = listeners[event.type];
        if (listenerArray !== undefined) {
            event.target = this;
            // Make a copy, in case listeners are removed while iterating.
            const array = listenerArray.slice(0);
            for(let i = 0, l = array.length; i < l; i++)array[i].call(this, event);
            event.target = null;
        }
    }
}
const _lut = [
    '00',
    '01',
    '02',
    '03',
    '04',
    '05',
    '06',
    '07',
    '08',
    '09',
    '0a',
    '0b',
    '0c',
    '0d',
    '0e',
    '0f',
    '10',
    '11',
    '12',
    '13',
    '14',
    '15',
    '16',
    '17',
    '18',
    '19',
    '1a',
    '1b',
    '1c',
    '1d',
    '1e',
    '1f',
    '20',
    '21',
    '22',
    '23',
    '24',
    '25',
    '26',
    '27',
    '28',
    '29',
    '2a',
    '2b',
    '2c',
    '2d',
    '2e',
    '2f',
    '30',
    '31',
    '32',
    '33',
    '34',
    '35',
    '36',
    '37',
    '38',
    '39',
    '3a',
    '3b',
    '3c',
    '3d',
    '3e',
    '3f',
    '40',
    '41',
    '42',
    '43',
    '44',
    '45',
    '46',
    '47',
    '48',
    '49',
    '4a',
    '4b',
    '4c',
    '4d',
    '4e',
    '4f',
    '50',
    '51',
    '52',
    '53',
    '54',
    '55',
    '56',
    '57',
    '58',
    '59',
    '5a',
    '5b',
    '5c',
    '5d',
    '5e',
    '5f',
    '60',
    '61',
    '62',
    '63',
    '64',
    '65',
    '66',
    '67',
    '68',
    '69',
    '6a',
    '6b',
    '6c',
    '6d',
    '6e',
    '6f',
    '70',
    '71',
    '72',
    '73',
    '74',
    '75',
    '76',
    '77',
    '78',
    '79',
    '7a',
    '7b',
    '7c',
    '7d',
    '7e',
    '7f',
    '80',
    '81',
    '82',
    '83',
    '84',
    '85',
    '86',
    '87',
    '88',
    '89',
    '8a',
    '8b',
    '8c',
    '8d',
    '8e',
    '8f',
    '90',
    '91',
    '92',
    '93',
    '94',
    '95',
    '96',
    '97',
    '98',
    '99',
    '9a',
    '9b',
    '9c',
    '9d',
    '9e',
    '9f',
    'a0',
    'a1',
    'a2',
    'a3',
    'a4',
    'a5',
    'a6',
    'a7',
    'a8',
    'a9',
    'aa',
    'ab',
    'ac',
    'ad',
    'ae',
    'af',
    'b0',
    'b1',
    'b2',
    'b3',
    'b4',
    'b5',
    'b6',
    'b7',
    'b8',
    'b9',
    'ba',
    'bb',
    'bc',
    'bd',
    'be',
    'bf',
    'c0',
    'c1',
    'c2',
    'c3',
    'c4',
    'c5',
    'c6',
    'c7',
    'c8',
    'c9',
    'ca',
    'cb',
    'cc',
    'cd',
    'ce',
    'cf',
    'd0',
    'd1',
    'd2',
    'd3',
    'd4',
    'd5',
    'd6',
    'd7',
    'd8',
    'd9',
    'da',
    'db',
    'dc',
    'dd',
    'de',
    'df',
    'e0',
    'e1',
    'e2',
    'e3',
    'e4',
    'e5',
    'e6',
    'e7',
    'e8',
    'e9',
    'ea',
    'eb',
    'ec',
    'ed',
    'ee',
    'ef',
    'f0',
    'f1',
    'f2',
    'f3',
    'f4',
    'f5',
    'f6',
    'f7',
    'f8',
    'f9',
    'fa',
    'fb',
    'fc',
    'fd',
    'fe',
    'ff'
];
let _seed = 1234567;
const DEG2RAD = Math.PI / 180;
const RAD2DEG = 180 / Math.PI;
/**
 * Generate a [UUID](https://en.wikipedia.org/wiki/Universally_unique_identifier)
 * (universally unique identifier).
 *
 * @return {string} The UUID.
 */ function generateUUID() {
    // http://stackoverflow.com/questions/105034/how-to-create-a-guid-uuid-in-javascript/21963136#21963136
    const d0 = Math.random() * 0xffffffff | 0;
    const d1 = Math.random() * 0xffffffff | 0;
    const d2 = Math.random() * 0xffffffff | 0;
    const d3 = Math.random() * 0xffffffff | 0;
    const uuid = _lut[d0 & 0xff] + _lut[d0 >> 8 & 0xff] + _lut[d0 >> 16 & 0xff] + _lut[d0 >> 24 & 0xff] + '-' + _lut[d1 & 0xff] + _lut[d1 >> 8 & 0xff] + '-' + _lut[d1 >> 16 & 0x0f | 0x40] + _lut[d1 >> 24 & 0xff] + '-' + _lut[d2 & 0x3f | 0x80] + _lut[d2 >> 8 & 0xff] + '-' + _lut[d2 >> 16 & 0xff] + _lut[d2 >> 24 & 0xff] + _lut[d3 & 0xff] + _lut[d3 >> 8 & 0xff] + _lut[d3 >> 16 & 0xff] + _lut[d3 >> 24 & 0xff];
    // .toLowerCase() here flattens concatenated strings to save heap memory space.
    return uuid.toLowerCase();
}
/**
 * Clamps the given value between min and max.
 *
 * @param {number} value - The value to clamp.
 * @param {number} min - The min value.
 * @param {number} max - The max value.
 * @return {number} The clamped value.
 */ function clamp(value, min, max) {
    return Math.max(min, Math.min(max, value));
}
/**
 * Computes the Euclidean modulo of the given parameters that
 * is `( ( n % m ) + m ) % m`.
 *
 * @param {number} n - The first parameter.
 * @param {number} m - The second parameter.
 * @return {number} The Euclidean modulo.
 */ function euclideanModulo(n, m) {
    // https://en.wikipedia.org/wiki/Modulo_operation
    return (n % m + m) % m;
}
/**
 * Performs a linear mapping from range `<a1, a2>` to range `<b1, b2>`
 * for the given value.
 *
 * @param {number} x - The value to be mapped.
 * @param {number} a1 - Minimum value for range A.
 * @param {number} a2 - Maximum value for range A.
 * @param {number} b1 - Minimum value for range B.
 * @param {number} b2 - Maximum value for range B.
 * @return {number} The mapped value.
 */ function mapLinear(x, a1, a2, b1, b2) {
    return b1 + (x - a1) * (b2 - b1) / (a2 - a1);
}
/**
 * Returns the percentage in the closed interval `[0, 1]` of the given value
 * between the start and end point.
 *
 * @param {number} x - The start point
 * @param {number} y - The end point.
 * @param {number} value - A value between start and end.
 * @return {number} The interpolation factor.
 */ function inverseLerp(x, y, value) {
    // https://www.gamedev.net/tutorials/programming/general-and-gameplay-programming/inverse-lerp-a-super-useful-yet-often-overlooked-function-r5230/
    if (x !== y) return (value - x) / (y - x);
    else return 0;
}
/**
 * Returns a value linearly interpolated from two known points based on the given interval -
 * `t = 0` will return `x` and `t = 1` will return `y`.
 *
 * @param {number} x - The start point
 * @param {number} y - The end point.
 * @param {number} t - The interpolation factor in the closed interval `[0, 1]`.
 * @return {number} The interpolated value.
 */ function lerp(x, y, t) {
    return (1 - t) * x + t * y;
}
/**
 * Smoothly interpolate a number from `x` to `y` in  a spring-like manner using a delta
 * time to maintain frame rate independent movement. For details, see
 * [Frame rate independent damping using lerp](http://www.rorydriscoll.com/2016/03/07/frame-rate-independent-damping-using-lerp/).
 *
 * @param {number} x - The current point.
 * @param {number} y - The target point.
 * @param {number} lambda - A higher lambda value will make the movement more sudden,
 * and a lower value will make the movement more gradual.
 * @param {number} dt - Delta time in seconds.
 * @return {number} The interpolated value.
 */ function damp(x, y, lambda, dt) {
    return lerp(x, y, 1 - Math.exp(-lambda * dt));
}
/**
 * Returns a value that alternates between `0` and the given `length` parameter.
 *
 * @param {number} x - The value to pingpong.
 * @param {number} [length=1] - The positive value the function will pingpong to.
 * @return {number} The alternated value.
 */ function pingpong(x, length = 1) {
    // https://www.desmos.com/calculator/vcsjnyz7x4
    return length - Math.abs(euclideanModulo(x, length * 2) - length);
}
/**
 * Returns a value in the range `[0,1]` that represents the percentage that `x` has
 * moved between `min` and `max`, but smoothed or slowed down the closer `x` is to
 * the `min` and `max`.
 *
 * See [Smoothstep](http://en.wikipedia.org/wiki/Smoothstep) for more details.
 *
 * @param {number} x - The value to evaluate based on its position between min and max.
 * @param {number} min - The min value. Any x value below min will be `0`.
 * @param {number} max - The max value. Any x value above max will be `1`.
 * @return {number} The alternated value.
 */ function smoothstep(x, min, max) {
    if (x <= min) return 0;
    if (x >= max) return 1;
    x = (x - min) / (max - min);
    return x * x * (3 - 2 * x);
}
/**
 * A [variation on smoothstep](https://en.wikipedia.org/wiki/Smoothstep#Variations)
 * that has zero 1st and 2nd order derivatives at x=0 and x=1.
 *
 * @param {number} x - The value to evaluate based on its position between min and max.
 * @param {number} min - The min value. Any x value below min will be `0`.
 * @param {number} max - The max value. Any x value above max will be `1`.
 * @return {number} The alternated value.
 */ function smootherstep(x, min, max) {
    if (x <= min) return 0;
    if (x >= max) return 1;
    x = (x - min) / (max - min);
    return x * x * x * (x * (x * 6 - 15) + 10);
}
/**
 * Returns a random integer from `<low, high>` interval.
 *
 * @param {number} low - The lower value boundary.
 * @param {number} high - The upper value boundary
 * @return {number} A random integer.
 */ function randInt(low, high) {
    return low + Math.floor(Math.random() * (high - low + 1));
}
/**
 * Returns a random float from `<low, high>` interval.
 *
 * @param {number} low - The lower value boundary.
 * @param {number} high - The upper value boundary
 * @return {number} A random float.
 */ function randFloat(low, high) {
    return low + Math.random() * (high - low);
}
/**
 * Returns a random integer from `<-range/2, range/2>` interval.
 *
 * @param {number} range - Defines the value range.
 * @return {number} A random float.
 */ function randFloatSpread(range) {
    return range * (0.5 - Math.random());
}
/**
 * Returns a deterministic pseudo-random float in the interval `[0, 1]`.
 *
 * @param {number} [s] - The integer seed.
 * @return {number} A random float.
 */ function seededRandom(s) {
    if (s !== undefined) _seed = s;
    // Mulberry32 generator
    let t = _seed += 0x6D2B79F5;
    t = Math.imul(t ^ t >>> 15, t | 1);
    t ^= t + Math.imul(t ^ t >>> 7, t | 61);
    return ((t ^ t >>> 14) >>> 0) / 4294967296;
}
/**
 * Converts degrees to radians.
 *
 * @param {number} degrees - A value in degrees.
 * @return {number} The converted value in radians.
 */ function degToRad(degrees) {
    return degrees * DEG2RAD;
}
/**
 * Converts radians to degrees.
 *
 * @param {number} radians - A value in radians.
 * @return {number} The converted value in degrees.
 */ function radToDeg(radians) {
    return radians * RAD2DEG;
}
/**
 * Returns `true` if the given number is a power of two.
 *
 * @param {number} value - The value to check.
 * @return {boolean} Whether the given number is a power of two or not.
 */ function isPowerOfTwo(value) {
    return (value & value - 1) === 0 && value !== 0;
}
/**
 * Returns the smallest power of two that is greater than or equal to the given number.
 *
 * @param {number} value - The value to find a POT for.
 * @return {number} The smallest power of two that is greater than or equal to the given number.
 */ function ceilPowerOfTwo(value) {
    return Math.pow(2, Math.ceil(Math.log(value) / Math.LN2));
}
/**
 * Returns the largest power of two that is less than or equal to the given number.
 *
 * @param {number} value - The value to find a POT for.
 * @return {number} The largest power of two that is less than or equal to the given number.
 */ function floorPowerOfTwo(value) {
    return Math.pow(2, Math.floor(Math.log(value) / Math.LN2));
}
/**
 * Sets the given quaternion from the [Intrinsic Proper Euler Angles](https://en.wikipedia.org/wiki/Euler_angles)
 * defined by the given angles and order.
 *
 * Rotations are applied to the axes in the order specified by order:
 * rotation by angle `a` is applied first, then by angle `b`, then by angle `c`.
 *
 * @param {Quaternion} q - The quaternion to set.
 * @param {number} a - The rotation applied to the first axis, in radians.
 * @param {number} b - The rotation applied to the second axis, in radians.
 * @param {number} c - The rotation applied to the third axis, in radians.
 * @param {('XYX'|'XZX'|'YXY'|'YZY'|'ZXZ'|'ZYZ')} order - A string specifying the axes order.
 */ function setQuaternionFromProperEuler(q, a, b, c, order) {
    const cos = Math.cos;
    const sin = Math.sin;
    const c2 = cos(b / 2);
    const s2 = sin(b / 2);
    const c13 = cos((a + c) / 2);
    const s13 = sin((a + c) / 2);
    const c1_3 = cos((a - c) / 2);
    const s1_3 = sin((a - c) / 2);
    const c3_1 = cos((c - a) / 2);
    const s3_1 = sin((c - a) / 2);
    switch(order){
        case 'XYX':
            q.set(c2 * s13, s2 * c1_3, s2 * s1_3, c2 * c13);
            break;
        case 'YZY':
            q.set(s2 * s1_3, c2 * s13, s2 * c1_3, c2 * c13);
            break;
        case 'ZXZ':
            q.set(s2 * c1_3, s2 * s1_3, c2 * s13, c2 * c13);
            break;
        case 'XZX':
            q.set(c2 * s13, s2 * s3_1, s2 * c3_1, c2 * c13);
            break;
        case 'YXY':
            q.set(s2 * c3_1, c2 * s13, s2 * s3_1, c2 * c13);
            break;
        case 'ZYZ':
            q.set(s2 * s3_1, s2 * c3_1, c2 * s13, c2 * c13);
            break;
        default:
            warn('MathUtils: .setQuaternionFromProperEuler() encountered an unknown order: ' + order);
    }
}
/**
 * Denormalizes the given value according to the given typed array.
 *
 * @param {number} value - The value to denormalize.
 * @param {TypedArray} array - The typed array that defines the data type of the value.
 * @return {number} The denormalize (float) value in the range `[0,1]`.
 */ function denormalize(value, array) {
    switch(array.constructor){
        case Float32Array:
            return value;
        case Uint32Array:
            return value / 4294967295.0;
        case Uint16Array:
            return value / 65535.0;
        case Uint8Array:
            return value / 255.0;
        case Int32Array:
            return Math.max(value / 2147483647.0, -1);
        case Int16Array:
            return Math.max(value / 32767.0, -1);
        case Int8Array:
            return Math.max(value / 127.0, -1);
        default:
            throw new Error('Invalid component type.');
    }
}
/**
 * Normalizes the given value according to the given typed array.
 *
 * @param {number} value - The float value in the range `[0,1]` to normalize.
 * @param {TypedArray} array - The typed array that defines the data type of the value.
 * @return {number} The normalize value.
 */ function normalize(value, array) {
    switch(array.constructor){
        case Float32Array:
            return value;
        case Uint32Array:
            return Math.round(value * 4294967295.0);
        case Uint16Array:
            return Math.round(value * 65535.0);
        case Uint8Array:
            return Math.round(value * 255.0);
        case Int32Array:
            return Math.round(value * 2147483647.0);
        case Int16Array:
            return Math.round(value * 32767.0);
        case Int8Array:
            return Math.round(value * 127.0);
        default:
            throw new Error('Invalid component type.');
    }
}
/**
 * @class
 * @classdesc A collection of math utility functions.
 * @hideconstructor
 */ const MathUtils = {
    DEG2RAD: DEG2RAD,
    RAD2DEG: RAD2DEG,
    /**
	 * Generate a [UUID](https://en.wikipedia.org/wiki/Universally_unique_identifier)
	 * (universally unique identifier).
	 *
	 * @static
	 * @method
	 * @return {string} The UUID.
	 */ generateUUID: generateUUID,
    /**
	 * Clamps the given value between min and max.
	 *
	 * @static
	 * @method
	 * @param {number} value - The value to clamp.
	 * @param {number} min - The min value.
	 * @param {number} max - The max value.
	 * @return {number} The clamped value.
	 */ clamp: clamp,
    /**
	 * Computes the Euclidean modulo of the given parameters that
	 * is `( ( n % m ) + m ) % m`.
	 *
	 * @static
	 * @method
	 * @param {number} n - The first parameter.
	 * @param {number} m - The second parameter.
	 * @return {number} The Euclidean modulo.
	 */ euclideanModulo: euclideanModulo,
    /**
	 * Performs a linear mapping from range `<a1, a2>` to range `<b1, b2>`
	 * for the given value.
	 *
	 * @static
	 * @method
	 * @param {number} x - The value to be mapped.
	 * @param {number} a1 - Minimum value for range A.
	 * @param {number} a2 - Maximum value for range A.
	 * @param {number} b1 - Minimum value for range B.
	 * @param {number} b2 - Maximum value for range B.
	 * @return {number} The mapped value.
	 */ mapLinear: mapLinear,
    /**
	 * Returns the percentage in the closed interval `[0, 1]` of the given value
	 * between the start and end point.
	 *
	 * @static
	 * @method
	 * @param {number} x - The start point
	 * @param {number} y - The end point.
	 * @param {number} value - A value between start and end.
	 * @return {number} The interpolation factor.
	 */ inverseLerp: inverseLerp,
    /**
	 * Returns a value linearly interpolated from two known points based on the given interval -
	 * `t = 0` will return `x` and `t = 1` will return `y`.
	 *
	 * @static
	 * @method
	 * @param {number} x - The start point
	 * @param {number} y - The end point.
	 * @param {number} t - The interpolation factor in the closed interval `[0, 1]`.
	 * @return {number} The interpolated value.
	 */ lerp: lerp,
    /**
	 * Smoothly interpolate a number from `x` to `y` in  a spring-like manner using a delta
	 * time to maintain frame rate independent movement. For details, see
	 * [Frame rate independent damping using lerp](http://www.rorydriscoll.com/2016/03/07/frame-rate-independent-damping-using-lerp/).
	 *
	 * @static
	 * @method
	 * @param {number} x - The current point.
	 * @param {number} y - The target point.
	 * @param {number} lambda - A higher lambda value will make the movement more sudden,
	 * and a lower value will make the movement more gradual.
	 * @param {number} dt - Delta time in seconds.
	 * @return {number} The interpolated value.
	 */ damp: damp,
    /**
	 * Returns a value that alternates between `0` and the given `length` parameter.
	 *
	 * @static
	 * @method
	 * @param {number} x - The value to pingpong.
	 * @param {number} [length=1] - The positive value the function will pingpong to.
	 * @return {number} The alternated value.
	 */ pingpong: pingpong,
    /**
	 * Returns a value in the range `[0,1]` that represents the percentage that `x` has
	 * moved between `min` and `max`, but smoothed or slowed down the closer `x` is to
	 * the `min` and `max`.
	 *
	 * See [Smoothstep](http://en.wikipedia.org/wiki/Smoothstep) for more details.
	 *
	 * @static
	 * @method
	 * @param {number} x - The value to evaluate based on its position between min and max.
	 * @param {number} min - The min value. Any x value below min will be `0`.
	 * @param {number} max - The max value. Any x value above max will be `1`.
	 * @return {number} The alternated value.
	 */ smoothstep: smoothstep,
    /**
	 * A [variation on smoothstep](https://en.wikipedia.org/wiki/Smoothstep#Variations)
	 * that has zero 1st and 2nd order derivatives at x=0 and x=1.
	 *
	 * @static
	 * @method
	 * @param {number} x - The value to evaluate based on its position between min and max.
	 * @param {number} min - The min value. Any x value below min will be `0`.
	 * @param {number} max - The max value. Any x value above max will be `1`.
	 * @return {number} The alternated value.
	 */ smootherstep: smootherstep,
    /**
	 * Returns a random integer from `<low, high>` interval.
	 *
	 * @static
	 * @method
	 * @param {number} low - The lower value boundary.
	 * @param {number} high - The upper value boundary
	 * @return {number} A random integer.
	 */ randInt: randInt,
    /**
	 * Returns a random float from `<low, high>` interval.
	 *
	 * @static
	 * @method
	 * @param {number} low - The lower value boundary.
	 * @param {number} high - The upper value boundary
	 * @return {number} A random float.
	 */ randFloat: randFloat,
    /**
	 * Returns a random integer from `<-range/2, range/2>` interval.
	 *
	 * @static
	 * @method
	 * @param {number} range - Defines the value range.
	 * @return {number} A random float.
	 */ randFloatSpread: randFloatSpread,
    /**
	 * Returns a deterministic pseudo-random float in the interval `[0, 1]`.
	 *
	 * @static
	 * @method
	 * @param {number} [s] - The integer seed.
	 * @return {number} A random float.
	 */ seededRandom: seededRandom,
    /**
	 * Converts degrees to radians.
	 *
	 * @static
	 * @method
	 * @param {number} degrees - A value in degrees.
	 * @return {number} The converted value in radians.
	 */ degToRad: degToRad,
    /**
	 * Converts radians to degrees.
	 *
	 * @static
	 * @method
	 * @param {number} radians - A value in radians.
	 * @return {number} The converted value in degrees.
	 */ radToDeg: radToDeg,
    /**
	 * Returns `true` if the given number is a power of two.
	 *
	 * @static
	 * @method
	 * @param {number} value - The value to check.
	 * @return {boolean} Whether the given number is a power of two or not.
	 */ isPowerOfTwo: isPowerOfTwo,
    /**
	 * Returns the smallest power of two that is greater than or equal to the given number.
	 *
	 * @static
	 * @method
	 * @param {number} value - The value to find a POT for.
	 * @return {number} The smallest power of two that is greater than or equal to the given number.
	 */ ceilPowerOfTwo: ceilPowerOfTwo,
    /**
	 * Returns the largest power of two that is less than or equal to the given number.
	 *
	 * @static
	 * @method
	 * @param {number} value - The value to find a POT for.
	 * @return {number} The largest power of two that is less than or equal to the given number.
	 */ floorPowerOfTwo: floorPowerOfTwo,
    /**
	 * Sets the given quaternion from the [Intrinsic Proper Euler Angles](https://en.wikipedia.org/wiki/Euler_angles)
	 * defined by the given angles and order.
	 *
	 * Rotations are applied to the axes in the order specified by order:
	 * rotation by angle `a` is applied first, then by angle `b`, then by angle `c`.
	 *
	 * @static
	 * @method
	 * @param {Quaternion} q - The quaternion to set.
	 * @param {number} a - The rotation applied to the first axis, in radians.
	 * @param {number} b - The rotation applied to the second axis, in radians.
	 * @param {number} c - The rotation applied to the third axis, in radians.
	 * @param {('XYX'|'XZX'|'YXY'|'YZY'|'ZXZ'|'ZYZ')} order - A string specifying the axes order.
	 */ setQuaternionFromProperEuler: setQuaternionFromProperEuler,
    /**
	 * Normalizes the given value according to the given typed array.
	 *
	 * @static
	 * @method
	 * @param {number} value - The float value in the range `[0,1]` to normalize.
	 * @param {TypedArray} array - The typed array that defines the data type of the value.
	 * @return {number} The normalize value.
	 */ normalize: normalize,
    /**
	 * Denormalizes the given value according to the given typed array.
	 *
	 * @static
	 * @method
	 * @param {number} value - The value to denormalize.
	 * @param {TypedArray} array - The typed array that defines the data type of the value.
	 * @return {number} The denormalize (float) value in the range `[0,1]`.
	 */ denormalize: denormalize
};
/**
 * Class representing a 2D vector. A 2D vector is an ordered pair of numbers
 * (labeled x and y), which can be used to represent a number of things, such as:
 *
 * - A point in 2D space (i.e. a position on a plane).
 * - A direction and length across a plane. In three.js the length will
 * always be the Euclidean distance(straight-line distance) from `(0, 0)` to `(x, y)`
 * and the direction is also measured from `(0, 0)` towards `(x, y)`.
 * - Any arbitrary ordered pair of numbers.
 *
 * There are other things a 2D vector can be used to represent, such as
 * momentum vectors, complex numbers and so on, however these are the most
 * common uses in three.js.
 *
 * Iterating through a vector instance will yield its components `(x, y)` in
 * the corresponding order.
 * ```js
 * const a = new THREE.Vector2( 0, 1 );
 *
 * //no arguments; will be initialised to (0, 0)
 * const b = new THREE.Vector2( );
 *
 * const d = a.distanceTo( b );
 * ```
 */ class Vector2 {
    /**
	 * Constructs a new 2D vector.
	 *
	 * @param {number} [x=0] - The x value of this vector.
	 * @param {number} [y=0] - The y value of this vector.
	 */ constructor(x = 0, y = 0){
        /**
		 * This flag can be used for type testing.
		 *
		 * @type {boolean}
		 * @readonly
		 * @default true
		 */ Vector2.prototype.isVector2 = true;
        /**
		 * The x value of this vector.
		 *
		 * @type {number}
		 */ this.x = x;
        /**
		 * The y value of this vector.
		 *
		 * @type {number}
		 */ this.y = y;
    }
    /**
	 * Alias for {@link Vector2#x}.
	 *
	 * @type {number}
	 */ get width() {
        return this.x;
    }
    set width(value) {
        this.x = value;
    }
    /**
	 * Alias for {@link Vector2#y}.
	 *
	 * @type {number}
	 */ get height() {
        return this.y;
    }
    set height(value) {
        this.y = value;
    }
    /**
	 * Sets the vector components.
	 *
	 * @param {number} x - The value of the x component.
	 * @param {number} y - The value of the y component.
	 * @return {Vector2} A reference to this vector.
	 */ set(x, y) {
        this.x = x;
        this.y = y;
        return this;
    }
    /**
	 * Sets the vector components to the same value.
	 *
	 * @param {number} scalar - The value to set for all vector components.
	 * @return {Vector2} A reference to this vector.
	 */ setScalar(scalar) {
        this.x = scalar;
        this.y = scalar;
        return this;
    }
    /**
	 * Sets the vector's x component to the given value
	 *
	 * @param {number} x - The value to set.
	 * @return {Vector2} A reference to this vector.
	 */ setX(x) {
        this.x = x;
        return this;
    }
    /**
	 * Sets the vector's y component to the given value
	 *
	 * @param {number} y - The value to set.
	 * @return {Vector2} A reference to this vector.
	 */ setY(y) {
        this.y = y;
        return this;
    }
    /**
	 * Allows to set a vector component with an index.
	 *
	 * @param {number} index - The component index. `0` equals to x, `1` equals to y.
	 * @param {number} value - The value to set.
	 * @return {Vector2} A reference to this vector.
	 */ setComponent(index, value) {
        switch(index){
            case 0:
                this.x = value;
                break;
            case 1:
                this.y = value;
                break;
            default:
                throw new Error('index is out of range: ' + index);
        }
        return this;
    }
    /**
	 * Returns the value of the vector component which matches the given index.
	 *
	 * @param {number} index - The component index. `0` equals to x, `1` equals to y.
	 * @return {number} A vector component value.
	 */ getComponent(index) {
        switch(index){
            case 0:
                return this.x;
            case 1:
                return this.y;
            default:
                throw new Error('index is out of range: ' + index);
        }
    }
    /**
	 * Returns a new vector with copied values from this instance.
	 *
	 * @return {Vector2} A clone of this instance.
	 */ clone() {
        return new this.constructor(this.x, this.y);
    }
    /**
	 * Copies the values of the given vector to this instance.
	 *
	 * @param {Vector2} v - The vector to copy.
	 * @return {Vector2} A reference to this vector.
	 */ copy(v) {
        this.x = v.x;
        this.y = v.y;
        return this;
    }
    /**
	 * Adds the given vector to this instance.
	 *
	 * @param {Vector2} v - The vector to add.
	 * @return {Vector2} A reference to this vector.
	 */ add(v) {
        this.x += v.x;
        this.y += v.y;
        return this;
    }
    /**
	 * Adds the given scalar value to all components of this instance.
	 *
	 * @param {number} s - The scalar to add.
	 * @return {Vector2} A reference to this vector.
	 */ addScalar(s) {
        this.x += s;
        this.y += s;
        return this;
    }
    /**
	 * Adds the given vectors and stores the result in this instance.
	 *
	 * @param {Vector2} a - The first vector.
	 * @param {Vector2} b - The second vector.
	 * @return {Vector2} A reference to this vector.
	 */ addVectors(a, b) {
        this.x = a.x + b.x;
        this.y = a.y + b.y;
        return this;
    }
    /**
	 * Adds the given vector scaled by the given factor to this instance.
	 *
	 * @param {Vector2} v - The vector.
	 * @param {number} s - The factor that scales `v`.
	 * @return {Vector2} A reference to this vector.
	 */ addScaledVector(v, s) {
        this.x += v.x * s;
        this.y += v.y * s;
        return this;
    }
    /**
	 * Subtracts the given vector from this instance.
	 *
	 * @param {Vector2} v - The vector to subtract.
	 * @return {Vector2} A reference to this vector.
	 */ sub(v) {
        this.x -= v.x;
        this.y -= v.y;
        return this;
    }
    /**
	 * Subtracts the given scalar value from all components of this instance.
	 *
	 * @param {number} s - The scalar to subtract.
	 * @return {Vector2} A reference to this vector.
	 */ subScalar(s) {
        this.x -= s;
        this.y -= s;
        return this;
    }
    /**
	 * Subtracts the given vectors and stores the result in this instance.
	 *
	 * @param {Vector2} a - The first vector.
	 * @param {Vector2} b - The second vector.
	 * @return {Vector2} A reference to this vector.
	 */ subVectors(a, b) {
        this.x = a.x - b.x;
        this.y = a.y - b.y;
        return this;
    }
    /**
	 * Multiplies the given vector with this instance.
	 *
	 * @param {Vector2} v - The vector to multiply.
	 * @return {Vector2} A reference to this vector.
	 */ multiply(v) {
        this.x *= v.x;
        this.y *= v.y;
        return this;
    }
    /**
	 * Multiplies the given scalar value with all components of this instance.
	 *
	 * @param {number} scalar - The scalar to multiply.
	 * @return {Vector2} A reference to this vector.
	 */ multiplyScalar(scalar) {
        this.x *= scalar;
        this.y *= scalar;
        return this;
    }
    /**
	 * Divides this instance by the given vector.
	 *
	 * @param {Vector2} v - The vector to divide.
	 * @return {Vector2} A reference to this vector.
	 */ divide(v) {
        this.x /= v.x;
        this.y /= v.y;
        return this;
    }
    /**
	 * Divides this vector by the given scalar.
	 *
	 * @param {number} scalar - The scalar to divide.
	 * @return {Vector2} A reference to this vector.
	 */ divideScalar(scalar) {
        return this.multiplyScalar(1 / scalar);
    }
    /**
	 * Multiplies this vector (with an implicit 1 as the 3rd component) by
	 * the given 3x3 matrix.
	 *
	 * @param {Matrix3} m - The matrix to apply.
	 * @return {Vector2} A reference to this vector.
	 */ applyMatrix3(m) {
        const x = this.x, y = this.y;
        const e = m.elements;
        this.x = e[0] * x + e[3] * y + e[6];
        this.y = e[1] * x + e[4] * y + e[7];
        return this;
    }
    /**
	 * If this vector's x or y value is greater than the given vector's x or y
	 * value, replace that value with the corresponding min value.
	 *
	 * @param {Vector2} v - The vector.
	 * @return {Vector2} A reference to this vector.
	 */ min(v) {
        this.x = Math.min(this.x, v.x);
        this.y = Math.min(this.y, v.y);
        return this;
    }
    /**
	 * If this vector's x or y value is less than the given vector's x or y
	 * value, replace that value with the corresponding max value.
	 *
	 * @param {Vector2} v - The vector.
	 * @return {Vector2} A reference to this vector.
	 */ max(v) {
        this.x = Math.max(this.x, v.x);
        this.y = Math.max(this.y, v.y);
        return this;
    }
    /**
	 * If this vector's x or y value is greater than the max vector's x or y
	 * value, it is replaced by the corresponding value.
	 * If this vector's x or y value is less than the min vector's x or y value,
	 * it is replaced by the corresponding value.
	 *
	 * @param {Vector2} min - The minimum x and y values.
	 * @param {Vector2} max - The maximum x and y values in the desired range.
	 * @return {Vector2} A reference to this vector.
	 */ clamp(min, max) {
        // assumes min < max, componentwise
        this.x = clamp(this.x, min.x, max.x);
        this.y = clamp(this.y, min.y, max.y);
        return this;
    }
    /**
	 * If this vector's x or y values are greater than the max value, they are
	 * replaced by the max value.
	 * If this vector's x or y values are less than the min value, they are
	 * replaced by the min value.
	 *
	 * @param {number} minVal - The minimum value the components will be clamped to.
	 * @param {number} maxVal - The maximum value the components will be clamped to.
	 * @return {Vector2} A reference to this vector.
	 */ clampScalar(minVal, maxVal) {
        this.x = clamp(this.x, minVal, maxVal);
        this.y = clamp(this.y, minVal, maxVal);
        return this;
    }
    /**
	 * If this vector's length is greater than the max value, it is replaced by
	 * the max value.
	 * If this vector's length is less than the min value, it is replaced by the
	 * min value.
	 *
	 * @param {number} min - The minimum value the vector length will be clamped to.
	 * @param {number} max - The maximum value the vector length will be clamped to.
	 * @return {Vector2} A reference to this vector.
	 */ clampLength(min, max) {
        const length = this.length();
        return this.divideScalar(length || 1).multiplyScalar(clamp(length, min, max));
    }
    /**
	 * The components of this vector are rounded down to the nearest integer value.
	 *
	 * @return {Vector2} A reference to this vector.
	 */ floor() {
        this.x = Math.floor(this.x);
        this.y = Math.floor(this.y);
        return this;
    }
    /**
	 * The components of this vector are rounded up to the nearest integer value.
	 *
	 * @return {Vector2} A reference to this vector.
	 */ ceil() {
        this.x = Math.ceil(this.x);
        this.y = Math.ceil(this.y);
        return this;
    }
    /**
	 * The components of this vector are rounded to the nearest integer value
	 *
	 * @return {Vector2} A reference to this vector.
	 */ round() {
        this.x = Math.round(this.x);
        this.y = Math.round(this.y);
        return this;
    }
    /**
	 * The components of this vector are rounded towards zero (up if negative,
	 * down if positive) to an integer value.
	 *
	 * @return {Vector2} A reference to this vector.
	 */ roundToZero() {
        this.x = Math.trunc(this.x);
        this.y = Math.trunc(this.y);
        return this;
    }
    /**
	 * Inverts this vector - i.e. sets x = -x and y = -y.
	 *
	 * @return {Vector2} A reference to this vector.
	 */ negate() {
        this.x = -this.x;
        this.y = -this.y;
        return this;
    }
    /**
	 * Calculates the dot product of the given vector with this instance.
	 *
	 * @param {Vector2} v - The vector to compute the dot product with.
	 * @return {number} The result of the dot product.
	 */ dot(v) {
        return this.x * v.x + this.y * v.y;
    }
    /**
	 * Calculates the cross product of the given vector with this instance.
	 *
	 * @param {Vector2} v - The vector to compute the cross product with.
	 * @return {number} The result of the cross product.
	 */ cross(v) {
        return this.x * v.y - this.y * v.x;
    }
    /**
	 * Computes the square of the Euclidean length (straight-line length) from
	 * (0, 0) to (x, y). If you are comparing the lengths of vectors, you should
	 * compare the length squared instead as it is slightly more efficient to calculate.
	 *
	 * @return {number} The square length of this vector.
	 */ lengthSq() {
        return this.x * this.x + this.y * this.y;
    }
    /**
	 * Computes the  Euclidean length (straight-line length) from (0, 0) to (x, y).
	 *
	 * @return {number} The length of this vector.
	 */ length() {
        return Math.sqrt(this.x * this.x + this.y * this.y);
    }
    /**
	 * Computes the Manhattan length of this vector.
	 *
	 * @return {number} The length of this vector.
	 */ manhattanLength() {
        return Math.abs(this.x) + Math.abs(this.y);
    }
    /**
	 * Converts this vector to a unit vector - that is, sets it equal to a vector
	 * with the same direction as this one, but with a vector length of `1`.
	 *
	 * @return {Vector2} A reference to this vector.
	 */ normalize() {
        return this.divideScalar(this.length() || 1);
    }
    /**
	 * Computes the angle in radians of this vector with respect to the positive x-axis.
	 *
	 * @return {number} The angle in radians.
	 */ angle() {
        const angle = Math.atan2(-this.y, -this.x) + Math.PI;
        return angle;
    }
    /**
	 * Returns the angle between the given vector and this instance in radians.
	 *
	 * @param {Vector2} v - The vector to compute the angle with.
	 * @return {number} The angle in radians.
	 */ angleTo(v) {
        const denominator = Math.sqrt(this.lengthSq() * v.lengthSq());
        if (denominator === 0) return Math.PI / 2;
        const theta = this.dot(v) / denominator;
        // clamp, to handle numerical problems
        return Math.acos(clamp(theta, -1, 1));
    }
    /**
	 * Computes the distance from the given vector to this instance.
	 *
	 * @param {Vector2} v - The vector to compute the distance to.
	 * @return {number} The distance.
	 */ distanceTo(v) {
        return Math.sqrt(this.distanceToSquared(v));
    }
    /**
	 * Computes the squared distance from the given vector to this instance.
	 * If you are just comparing the distance with another distance, you should compare
	 * the distance squared instead as it is slightly more efficient to calculate.
	 *
	 * @param {Vector2} v - The vector to compute the squared distance to.
	 * @return {number} The squared distance.
	 */ distanceToSquared(v) {
        const dx = this.x - v.x, dy = this.y - v.y;
        return dx * dx + dy * dy;
    }
    /**
	 * Computes the Manhattan distance from the given vector to this instance.
	 *
	 * @param {Vector2} v - The vector to compute the Manhattan distance to.
	 * @return {number} The Manhattan distance.
	 */ manhattanDistanceTo(v) {
        return Math.abs(this.x - v.x) + Math.abs(this.y - v.y);
    }
    /**
	 * Sets this vector to a vector with the same direction as this one, but
	 * with the specified length.
	 *
	 * @param {number} length - The new length of this vector.
	 * @return {Vector2} A reference to this vector.
	 */ setLength(length) {
        return this.normalize().multiplyScalar(length);
    }
    /**
	 * Linearly interpolates between the given vector and this instance, where
	 * alpha is the percent distance along the line - alpha = 0 will be this
	 * vector, and alpha = 1 will be the given one.
	 *
	 * @param {Vector2} v - The vector to interpolate towards.
	 * @param {number} alpha - The interpolation factor, typically in the closed interval `[0, 1]`.
	 * @return {Vector2} A reference to this vector.
	 */ lerp(v, alpha) {
        this.x += (v.x - this.x) * alpha;
        this.y += (v.y - this.y) * alpha;
        return this;
    }
    /**
	 * Linearly interpolates between the given vectors, where alpha is the percent
	 * distance along the line - alpha = 0 will be first vector, and alpha = 1 will
	 * be the second one. The result is stored in this instance.
	 *
	 * @param {Vector2} v1 - The first vector.
	 * @param {Vector2} v2 - The second vector.
	 * @param {number} alpha - The interpolation factor, typically in the closed interval `[0, 1]`.
	 * @return {Vector2} A reference to this vector.
	 */ lerpVectors(v1, v2, alpha) {
        this.x = v1.x + (v2.x - v1.x) * alpha;
        this.y = v1.y + (v2.y - v1.y) * alpha;
        return this;
    }
    /**
	 * Returns `true` if this vector is equal with the given one.
	 *
	 * @param {Vector2} v - The vector to test for equality.
	 * @return {boolean} Whether this vector is equal with the given one.
	 */ equals(v) {
        return v.x === this.x && v.y === this.y;
    }
    /**
	 * Sets this vector's x value to be `array[ offset ]` and y
	 * value to be `array[ offset + 1 ]`.
	 *
	 * @param {Array<number>} array - An array holding the vector component values.
	 * @param {number} [offset=0] - The offset into the array.
	 * @return {Vector2} A reference to this vector.
	 */ fromArray(array, offset = 0) {
        this.x = array[offset];
        this.y = array[offset + 1];
        return this;
    }
    /**
	 * Writes the components of this vector to the given array. If no array is provided,
	 * the method returns a new instance.
	 *
	 * @param {Array<number>} [array=[]] - The target array holding the vector components.
	 * @param {number} [offset=0] - Index of the first element in the array.
	 * @return {Array<number>} The vector components.
	 */ toArray(array = [], offset = 0) {
        array[offset] = this.x;
        array[offset + 1] = this.y;
        return array;
    }
    /**
	 * Sets the components of this vector from the given buffer attribute.
	 *
	 * @param {BufferAttribute} attribute - The buffer attribute holding vector data.
	 * @param {number} index - The index into the attribute.
	 * @return {Vector2} A reference to this vector.
	 */ fromBufferAttribute(attribute, index) {
        this.x = attribute.getX(index);
        this.y = attribute.getY(index);
        return this;
    }
    /**
	 * Rotates this vector around the given center by the given angle.
	 *
	 * @param {Vector2} center - The point around which to rotate.
	 * @param {number} angle - The angle to rotate, in radians.
	 * @return {Vector2} A reference to this vector.
	 */ rotateAround(center, angle) {
        const c = Math.cos(angle), s = Math.sin(angle);
        const x = this.x - center.x;
        const y = this.y - center.y;
        this.x = x * c - y * s + center.x;
        this.y = x * s + y * c + center.y;
        return this;
    }
    /**
	 * Sets each component of this vector to a pseudo-random value between `0` and
	 * `1`, excluding `1`.
	 *
	 * @return {Vector2} A reference to this vector.
	 */ random() {
        this.x = Math.random();
        this.y = Math.random();
        return this;
    }
    *[Symbol.iterator]() {
        yield this.x;
        yield this.y;
    }
}
/**
 * Class for representing a Quaternion. Quaternions are used in three.js to represent rotations.
 *
 * Iterating through a vector instance will yield its components `(x, y, z, w)` in
 * the corresponding order.
 *
 * Note that three.js expects Quaternions to be normalized.
 * ```js
 * const quaternion = new THREE.Quaternion();
 * quaternion.setFromAxisAngle( new THREE.Vector3( 0, 1, 0 ), Math.PI / 2 );
 *
 * const vector = new THREE.Vector3( 1, 0, 0 );
 * vector.applyQuaternion( quaternion );
 * ```
 */ class Quaternion {
    /**
	 * Constructs a new quaternion.
	 *
	 * @param {number} [x=0] - The x value of this quaternion.
	 * @param {number} [y=0] - The y value of this quaternion.
	 * @param {number} [z=0] - The z value of this quaternion.
	 * @param {number} [w=1] - The w value of this quaternion.
	 */ constructor(x = 0, y = 0, z = 0, w = 1){
        /**
		 * This flag can be used for type testing.
		 *
		 * @type {boolean}
		 * @readonly
		 * @default true
		 */ this.isQuaternion = true;
        this._x = x;
        this._y = y;
        this._z = z;
        this._w = w;
    }
    /**
	 * Interpolates between two quaternions via SLERP. This implementation assumes the
	 * quaternion data are managed in flat arrays.
	 *
	 * @param {Array<number>} dst - The destination array.
	 * @param {number} dstOffset - An offset into the destination array.
	 * @param {Array<number>} src0 - The source array of the first quaternion.
	 * @param {number} srcOffset0 - An offset into the first source array.
	 * @param {Array<number>} src1 -  The source array of the second quaternion.
	 * @param {number} srcOffset1 - An offset into the second source array.
	 * @param {number} t - The interpolation factor in the range `[0,1]`.
	 * @see {@link Quaternion#slerp}
	 */ static slerpFlat(dst, dstOffset, src0, srcOffset0, src1, srcOffset1, t) {
        let x0 = src0[srcOffset0 + 0], y0 = src0[srcOffset0 + 1], z0 = src0[srcOffset0 + 2], w0 = src0[srcOffset0 + 3];
        let x1 = src1[srcOffset1 + 0], y1 = src1[srcOffset1 + 1], z1 = src1[srcOffset1 + 2], w1 = src1[srcOffset1 + 3];
        if (t <= 0) {
            dst[dstOffset + 0] = x0;
            dst[dstOffset + 1] = y0;
            dst[dstOffset + 2] = z0;
            dst[dstOffset + 3] = w0;
            return;
        }
        if (t >= 1) {
            dst[dstOffset + 0] = x1;
            dst[dstOffset + 1] = y1;
            dst[dstOffset + 2] = z1;
            dst[dstOffset + 3] = w1;
            return;
        }
        if (w0 !== w1 || x0 !== x1 || y0 !== y1 || z0 !== z1) {
            let dot = x0 * x1 + y0 * y1 + z0 * z1 + w0 * w1;
            if (dot < 0) {
                x1 = -x1;
                y1 = -y1;
                z1 = -z1;
                w1 = -w1;
                dot = -dot;
            }
            let s = 1 - t;
            if (dot < 0.9995) {
                // slerp
                const theta = Math.acos(dot);
                const sin = Math.sin(theta);
                s = Math.sin(s * theta) / sin;
                t = Math.sin(t * theta) / sin;
                x0 = x0 * s + x1 * t;
                y0 = y0 * s + y1 * t;
                z0 = z0 * s + z1 * t;
                w0 = w0 * s + w1 * t;
            } else {
                // for small angles, lerp then normalize
                x0 = x0 * s + x1 * t;
                y0 = y0 * s + y1 * t;
                z0 = z0 * s + z1 * t;
                w0 = w0 * s + w1 * t;
                const f = 1 / Math.sqrt(x0 * x0 + y0 * y0 + z0 * z0 + w0 * w0);
                x0 *= f;
                y0 *= f;
                z0 *= f;
                w0 *= f;
            }
        }
        dst[dstOffset] = x0;
        dst[dstOffset + 1] = y0;
        dst[dstOffset + 2] = z0;
        dst[dstOffset + 3] = w0;
    }
    /**
	 * Multiplies two quaternions. This implementation assumes the quaternion data are managed
	 * in flat arrays.
	 *
	 * @param {Array<number>} dst - The destination array.
	 * @param {number} dstOffset - An offset into the destination array.
	 * @param {Array<number>} src0 - The source array of the first quaternion.
	 * @param {number} srcOffset0 - An offset into the first source array.
	 * @param {Array<number>} src1 -  The source array of the second quaternion.
	 * @param {number} srcOffset1 - An offset into the second source array.
	 * @return {Array<number>} The destination array.
	 * @see {@link Quaternion#multiplyQuaternions}.
	 */ static multiplyQuaternionsFlat(dst, dstOffset, src0, srcOffset0, src1, srcOffset1) {
        const x0 = src0[srcOffset0];
        const y0 = src0[srcOffset0 + 1];
        const z0 = src0[srcOffset0 + 2];
        const w0 = src0[srcOffset0 + 3];
        const x1 = src1[srcOffset1];
        const y1 = src1[srcOffset1 + 1];
        const z1 = src1[srcOffset1 + 2];
        const w1 = src1[srcOffset1 + 3];
        dst[dstOffset] = x0 * w1 + w0 * x1 + y0 * z1 - z0 * y1;
        dst[dstOffset + 1] = y0 * w1 + w0 * y1 + z0 * x1 - x0 * z1;
        dst[dstOffset + 2] = z0 * w1 + w0 * z1 + x0 * y1 - y0 * x1;
        dst[dstOffset + 3] = w0 * w1 - x0 * x1 - y0 * y1 - z0 * z1;
        return dst;
    }
    /**
	 * The x value of this quaternion.
	 *
	 * @type {number}
	 * @default 0
	 */ get x() {
        return this._x;
    }
    set x(value) {
        this._x = value;
        this._onChangeCallback();
    }
    /**
	 * The y value of this quaternion.
	 *
	 * @type {number}
	 * @default 0
	 */ get y() {
        return this._y;
    }
    set y(value) {
        this._y = value;
        this._onChangeCallback();
    }
    /**
	 * The z value of this quaternion.
	 *
	 * @type {number}
	 * @default 0
	 */ get z() {
        return this._z;
    }
    set z(value) {
        this._z = value;
        this._onChangeCallback();
    }
    /**
	 * The w value of this quaternion.
	 *
	 * @type {number}
	 * @default 1
	 */ get w() {
        return this._w;
    }
    set w(value) {
        this._w = value;
        this._onChangeCallback();
    }
    /**
	 * Sets the quaternion components.
	 *
	 * @param {number} x - The x value of this quaternion.
	 * @param {number} y - The y value of this quaternion.
	 * @param {number} z - The z value of this quaternion.
	 * @param {number} w - The w value of this quaternion.
	 * @return {Quaternion} A reference to this quaternion.
	 */ set(x, y, z, w) {
        this._x = x;
        this._y = y;
        this._z = z;
        this._w = w;
        this._onChangeCallback();
        return this;
    }
    /**
	 * Returns a new quaternion with copied values from this instance.
	 *
	 * @return {Quaternion} A clone of this instance.
	 */ clone() {
        return new this.constructor(this._x, this._y, this._z, this._w);
    }
    /**
	 * Copies the values of the given quaternion to this instance.
	 *
	 * @param {Quaternion} quaternion - The quaternion to copy.
	 * @return {Quaternion} A reference to this quaternion.
	 */ copy(quaternion) {
        this._x = quaternion.x;
        this._y = quaternion.y;
        this._z = quaternion.z;
        this._w = quaternion.w;
        this._onChangeCallback();
        return this;
    }
    /**
	 * Sets this quaternion from the rotation specified by the given
	 * Euler angles.
	 *
	 * @param {Euler} euler - The Euler angles.
	 * @param {boolean} [update=true] - Whether the internal `onChange` callback should be executed or not.
	 * @return {Quaternion} A reference to this quaternion.
	 */ setFromEuler(euler, update = true) {
        const x = euler._x, y = euler._y, z = euler._z, order = euler._order;
        // http://www.mathworks.com/matlabcentral/fileexchange/
        // 	20696-function-to-convert-between-dcm-euler-angles-quaternions-and-euler-vectors/
        //	content/SpinCalc.m
        const cos = Math.cos;
        const sin = Math.sin;
        const c1 = cos(x / 2);
        const c2 = cos(y / 2);
        const c3 = cos(z / 2);
        const s1 = sin(x / 2);
        const s2 = sin(y / 2);
        const s3 = sin(z / 2);
        switch(order){
            case 'XYZ':
                this._x = s1 * c2 * c3 + c1 * s2 * s3;
                this._y = c1 * s2 * c3 - s1 * c2 * s3;
                this._z = c1 * c2 * s3 + s1 * s2 * c3;
                this._w = c1 * c2 * c3 - s1 * s2 * s3;
                break;
            case 'YXZ':
                this._x = s1 * c2 * c3 + c1 * s2 * s3;
                this._y = c1 * s2 * c3 - s1 * c2 * s3;
                this._z = c1 * c2 * s3 - s1 * s2 * c3;
                this._w = c1 * c2 * c3 + s1 * s2 * s3;
                break;
            case 'ZXY':
                this._x = s1 * c2 * c3 - c1 * s2 * s3;
                this._y = c1 * s2 * c3 + s1 * c2 * s3;
                this._z = c1 * c2 * s3 + s1 * s2 * c3;
                this._w = c1 * c2 * c3 - s1 * s2 * s3;
                break;
            case 'ZYX':
                this._x = s1 * c2 * c3 - c1 * s2 * s3;
                this._y = c1 * s2 * c3 + s1 * c2 * s3;
                this._z = c1 * c2 * s3 - s1 * s2 * c3;
                this._w = c1 * c2 * c3 + s1 * s2 * s3;
                break;
            case 'YZX':
                this._x = s1 * c2 * c3 + c1 * s2 * s3;
                this._y = c1 * s2 * c3 + s1 * c2 * s3;
                this._z = c1 * c2 * s3 - s1 * s2 * c3;
                this._w = c1 * c2 * c3 - s1 * s2 * s3;
                break;
            case 'XZY':
                this._x = s1 * c2 * c3 - c1 * s2 * s3;
                this._y = c1 * s2 * c3 - s1 * c2 * s3;
                this._z = c1 * c2 * s3 + s1 * s2 * c3;
                this._w = c1 * c2 * c3 + s1 * s2 * s3;
                break;
            default:
                warn('Quaternion: .setFromEuler() encountered an unknown order: ' + order);
        }
        if (update === true) this._onChangeCallback();
        return this;
    }
    /**
	 * Sets this quaternion from the given axis and angle.
	 *
	 * @param {Vector3} axis - The normalized axis.
	 * @param {number} angle - The angle in radians.
	 * @return {Quaternion} A reference to this quaternion.
	 */ setFromAxisAngle(axis, angle) {
        // http://www.euclideanspace.com/maths/geometry/rotations/conversions/angleToQuaternion/index.htm
        const halfAngle = angle / 2, s = Math.sin(halfAngle);
        this._x = axis.x * s;
        this._y = axis.y * s;
        this._z = axis.z * s;
        this._w = Math.cos(halfAngle);
        this._onChangeCallback();
        return this;
    }
    /**
	 * Sets this quaternion from the given rotation matrix.
	 *
	 * @param {Matrix4} m - A 4x4 matrix of which the upper 3x3 of matrix is a pure rotation matrix (i.e. unscaled).
	 * @return {Quaternion} A reference to this quaternion.
	 */ setFromRotationMatrix(m) {
        // http://www.euclideanspace.com/maths/geometry/rotations/conversions/matrixToQuaternion/index.htm
        // assumes the upper 3x3 of m is a pure rotation matrix (i.e, unscaled)
        const te = m.elements, m11 = te[0], m12 = te[4], m13 = te[8], m21 = te[1], m22 = te[5], m23 = te[9], m31 = te[2], m32 = te[6], m33 = te[10], trace = m11 + m22 + m33;
        if (trace > 0) {
            const s = 0.5 / Math.sqrt(trace + 1.0);
            this._w = 0.25 / s;
            this._x = (m32 - m23) * s;
            this._y = (m13 - m31) * s;
            this._z = (m21 - m12) * s;
        } else if (m11 > m22 && m11 > m33) {
            const s = 2.0 * Math.sqrt(1.0 + m11 - m22 - m33);
            this._w = (m32 - m23) / s;
            this._x = 0.25 * s;
            this._y = (m12 + m21) / s;
            this._z = (m13 + m31) / s;
        } else if (m22 > m33) {
            const s = 2.0 * Math.sqrt(1.0 + m22 - m11 - m33);
            this._w = (m13 - m31) / s;
            this._x = (m12 + m21) / s;
            this._y = 0.25 * s;
            this._z = (m23 + m32) / s;
        } else {
            const s = 2.0 * Math.sqrt(1.0 + m33 - m11 - m22);
            this._w = (m21 - m12) / s;
            this._x = (m13 + m31) / s;
            this._y = (m23 + m32) / s;
            this._z = 0.25 * s;
        }
        this._onChangeCallback();
        return this;
    }
    /**
	 * Sets this quaternion to the rotation required to rotate the direction vector
	 * `vFrom` to the direction vector `vTo`.
	 *
	 * @param {Vector3} vFrom - The first (normalized) direction vector.
	 * @param {Vector3} vTo - The second (normalized) direction vector.
	 * @return {Quaternion} A reference to this quaternion.
	 */ setFromUnitVectors(vFrom, vTo) {
        // assumes direction vectors vFrom and vTo are normalized
        let r = vFrom.dot(vTo) + 1;
        if (r < 1e-8) {
            // vFrom and vTo point in opposite directions
            r = 0;
            if (Math.abs(vFrom.x) > Math.abs(vFrom.z)) {
                this._x = -vFrom.y;
                this._y = vFrom.x;
                this._z = 0;
                this._w = r;
            } else {
                this._x = 0;
                this._y = -vFrom.z;
                this._z = vFrom.y;
                this._w = r;
            }
        } else {
            // crossVectors( vFrom, vTo ); // inlined to avoid cyclic dependency on Vector3
            this._x = vFrom.y * vTo.z - vFrom.z * vTo.y;
            this._y = vFrom.z * vTo.x - vFrom.x * vTo.z;
            this._z = vFrom.x * vTo.y - vFrom.y * vTo.x;
            this._w = r;
        }
        return this.normalize();
    }
    /**
	 * Returns the angle between this quaternion and the given one in radians.
	 *
	 * @param {Quaternion} q - The quaternion to compute the angle with.
	 * @return {number} The angle in radians.
	 */ angleTo(q) {
        return 2 * Math.acos(Math.abs(clamp(this.dot(q), -1, 1)));
    }
    /**
	 * Rotates this quaternion by a given angular step to the given quaternion.
	 * The method ensures that the final quaternion will not overshoot `q`.
	 *
	 * @param {Quaternion} q - The target quaternion.
	 * @param {number} step - The angular step in radians.
	 * @return {Quaternion} A reference to this quaternion.
	 */ rotateTowards(q, step) {
        const angle = this.angleTo(q);
        if (angle === 0) return this;
        const t = Math.min(1, step / angle);
        this.slerp(q, t);
        return this;
    }
    /**
	 * Sets this quaternion to the identity quaternion; that is, to the
	 * quaternion that represents "no rotation".
	 *
	 * @return {Quaternion} A reference to this quaternion.
	 */ identity() {
        return this.set(0, 0, 0, 1);
    }
    /**
	 * Inverts this quaternion via {@link Quaternion#conjugate}. The
	 * quaternion is assumed to have unit length.
	 *
	 * @return {Quaternion} A reference to this quaternion.
	 */ invert() {
        return this.conjugate();
    }
    /**
	 * Returns the rotational conjugate of this quaternion. The conjugate of a
	 * quaternion represents the same rotation in the opposite direction about
	 * the rotational axis.
	 *
	 * @return {Quaternion} A reference to this quaternion.
	 */ conjugate() {
        this._x *= -1;
        this._y *= -1;
        this._z *= -1;
        this._onChangeCallback();
        return this;
    }
    /**
	 * Calculates the dot product of this quaternion and the given one.
	 *
	 * @param {Quaternion} v - The quaternion to compute the dot product with.
	 * @return {number} The result of the dot product.
	 */ dot(v) {
        return this._x * v._x + this._y * v._y + this._z * v._z + this._w * v._w;
    }
    /**
	 * Computes the squared Euclidean length (straight-line length) of this quaternion,
	 * considered as a 4 dimensional vector. This can be useful if you are comparing the
	 * lengths of two quaternions, as this is a slightly more efficient calculation than
	 * {@link Quaternion#length}.
	 *
	 * @return {number} The squared Euclidean length.
	 */ lengthSq() {
        return this._x * this._x + this._y * this._y + this._z * this._z + this._w * this._w;
    }
    /**
	 * Computes the Euclidean length (straight-line length) of this quaternion,
	 * considered as a 4 dimensional vector.
	 *
	 * @return {number} The Euclidean length.
	 */ length() {
        return Math.sqrt(this._x * this._x + this._y * this._y + this._z * this._z + this._w * this._w);
    }
    /**
	 * Normalizes this quaternion - that is, calculated the quaternion that performs
	 * the same rotation as this one, but has a length equal to `1`.
	 *
	 * @return {Quaternion} A reference to this quaternion.
	 */ normalize() {
        let l = this.length();
        if (l === 0) {
            this._x = 0;
            this._y = 0;
            this._z = 0;
            this._w = 1;
        } else {
            l = 1 / l;
            this._x = this._x * l;
            this._y = this._y * l;
            this._z = this._z * l;
            this._w = this._w * l;
        }
        this._onChangeCallback();
        return this;
    }
    /**
	 * Multiplies this quaternion by the given one.
	 *
	 * @param {Quaternion} q - The quaternion.
	 * @return {Quaternion} A reference to this quaternion.
	 */ multiply(q) {
        return this.multiplyQuaternions(this, q);
    }
    /**
	 * Pre-multiplies this quaternion by the given one.
	 *
	 * @param {Quaternion} q - The quaternion.
	 * @return {Quaternion} A reference to this quaternion.
	 */ premultiply(q) {
        return this.multiplyQuaternions(q, this);
    }
    /**
	 * Multiplies the given quaternions and stores the result in this instance.
	 *
	 * @param {Quaternion} a - The first quaternion.
	 * @param {Quaternion} b - The second quaternion.
	 * @return {Quaternion} A reference to this quaternion.
	 */ multiplyQuaternions(a, b) {
        // from http://www.euclideanspace.com/maths/algebra/realNormedAlgebra/quaternions/code/index.htm
        const qax = a._x, qay = a._y, qaz = a._z, qaw = a._w;
        const qbx = b._x, qby = b._y, qbz = b._z, qbw = b._w;
        this._x = qax * qbw + qaw * qbx + qay * qbz - qaz * qby;
        this._y = qay * qbw + qaw * qby + qaz * qbx - qax * qbz;
        this._z = qaz * qbw + qaw * qbz + qax * qby - qay * qbx;
        this._w = qaw * qbw - qax * qbx - qay * qby - qaz * qbz;
        this._onChangeCallback();
        return this;
    }
    /**
	 * Performs a spherical linear interpolation between quaternions.
	 *
	 * @param {Quaternion} qb - The target quaternion.
	 * @param {number} t - The interpolation factor in the closed interval `[0, 1]`.
	 * @return {Quaternion} A reference to this quaternion.
	 */ slerp(qb, t) {
        if (t <= 0) return this;
        if (t >= 1) return this.copy(qb); // copy calls _onChangeCallback()
        let x = qb._x, y = qb._y, z = qb._z, w = qb._w;
        let dot = this.dot(qb);
        if (dot < 0) {
            x = -x;
            y = -y;
            z = -z;
            w = -w;
            dot = -dot;
        }
        let s = 1 - t;
        if (dot < 0.9995) {
            // slerp
            const theta = Math.acos(dot);
            const sin = Math.sin(theta);
            s = Math.sin(s * theta) / sin;
            t = Math.sin(t * theta) / sin;
            this._x = this._x * s + x * t;
            this._y = this._y * s + y * t;
            this._z = this._z * s + z * t;
            this._w = this._w * s + w * t;
            this._onChangeCallback();
        } else {
            // for small angles, lerp then normalize
            this._x = this._x * s + x * t;
            this._y = this._y * s + y * t;
            this._z = this._z * s + z * t;
            this._w = this._w * s + w * t;
            this.normalize(); // normalize calls _onChangeCallback()
        }
        return this;
    }
    /**
	 * Performs a spherical linear interpolation between the given quaternions
	 * and stores the result in this quaternion.
	 *
	 * @param {Quaternion} qa - The source quaternion.
	 * @param {Quaternion} qb - The target quaternion.
	 * @param {number} t - The interpolation factor in the closed interval `[0, 1]`.
	 * @return {Quaternion} A reference to this quaternion.
	 */ slerpQuaternions(qa, qb, t) {
        return this.copy(qa).slerp(qb, t);
    }
    /**
	 * Sets this quaternion to a uniformly random, normalized quaternion.
	 *
	 * @return {Quaternion} A reference to this quaternion.
	 */ random() {
        // Ken Shoemake
        // Uniform random rotations
        // D. Kirk, editor, Graphics Gems III, pages 124-132. Academic Press, New York, 1992.
        const theta1 = 2 * Math.PI * Math.random();
        const theta2 = 2 * Math.PI * Math.random();
        const x0 = Math.random();
        const r1 = Math.sqrt(1 - x0);
        const r2 = Math.sqrt(x0);
        return this.set(r1 * Math.sin(theta1), r1 * Math.cos(theta1), r2 * Math.sin(theta2), r2 * Math.cos(theta2));
    }
    /**
	 * Returns `true` if this quaternion is equal with the given one.
	 *
	 * @param {Quaternion} quaternion - The quaternion to test for equality.
	 * @return {boolean} Whether this quaternion is equal with the given one.
	 */ equals(quaternion) {
        return quaternion._x === this._x && quaternion._y === this._y && quaternion._z === this._z && quaternion._w === this._w;
    }
    /**
	 * Sets this quaternion's components from the given array.
	 *
	 * @param {Array<number>} array - An array holding the quaternion component values.
	 * @param {number} [offset=0] - The offset into the array.
	 * @return {Quaternion} A reference to this quaternion.
	 */ fromArray(array, offset = 0) {
        this._x = array[offset];
        this._y = array[offset + 1];
        this._z = array[offset + 2];
        this._w = array[offset + 3];
        this._onChangeCallback();
        return this;
    }
    /**
	 * Writes the components of this quaternion to the given array. If no array is provided,
	 * the method returns a new instance.
	 *
	 * @param {Array<number>} [array=[]] - The target array holding the quaternion components.
	 * @param {number} [offset=0] - Index of the first element in the array.
	 * @return {Array<number>} The quaternion components.
	 */ toArray(array = [], offset = 0) {
        array[offset] = this._x;
        array[offset + 1] = this._y;
        array[offset + 2] = this._z;
        array[offset + 3] = this._w;
        return array;
    }
    /**
	 * Sets the components of this quaternion from the given buffer attribute.
	 *
	 * @param {BufferAttribute} attribute - The buffer attribute holding quaternion data.
	 * @param {number} index - The index into the attribute.
	 * @return {Quaternion} A reference to this quaternion.
	 */ fromBufferAttribute(attribute, index) {
        this._x = attribute.getX(index);
        this._y = attribute.getY(index);
        this._z = attribute.getZ(index);
        this._w = attribute.getW(index);
        this._onChangeCallback();
        return this;
    }
    /**
	 * This methods defines the serialization result of this class. Returns the
	 * numerical elements of this quaternion in an array of format `[x, y, z, w]`.
	 *
	 * @return {Array<number>} The serialized quaternion.
	 */ toJSON() {
        return this.toArray();
    }
    _onChange(callback) {
        this._onChangeCallback = callback;
        return this;
    }
    _onChangeCallback() {}
    *[Symbol.iterator]() {
        yield this._x;
        yield this._y;
        yield this._z;
        yield this._w;
    }
}
/**
 * Class representing a 3D vector. A 3D vector is an ordered triplet of numbers
 * (labeled x, y and z), which can be used to represent a number of things, such as:
 *
 * - A point in 3D space.
 * - A direction and length in 3D space. In three.js the length will
 * always be the Euclidean distance(straight-line distance) from `(0, 0, 0)` to `(x, y, z)`
 * and the direction is also measured from `(0, 0, 0)` towards `(x, y, z)`.
 * - Any arbitrary ordered triplet of numbers.
 *
 * There are other things a 3D vector can be used to represent, such as
 * momentum vectors and so on, however these are the most
 * common uses in three.js.
 *
 * Iterating through a vector instance will yield its components `(x, y, z)` in
 * the corresponding order.
 * ```js
 * const a = new THREE.Vector3( 0, 1, 0 );
 *
 * //no arguments; will be initialised to (0, 0, 0)
 * const b = new THREE.Vector3( );
 *
 * const d = a.distanceTo( b );
 * ```
 */ class Vector3 {
    /**
	 * Constructs a new 3D vector.
	 *
	 * @param {number} [x=0] - The x value of this vector.
	 * @param {number} [y=0] - The y value of this vector.
	 * @param {number} [z=0] - The z value of this vector.
	 */ constructor(x = 0, y = 0, z = 0){
        /**
		 * This flag can be used for type testing.
		 *
		 * @type {boolean}
		 * @readonly
		 * @default true
		 */ Vector3.prototype.isVector3 = true;
        /**
		 * The x value of this vector.
		 *
		 * @type {number}
		 */ this.x = x;
        /**
		 * The y value of this vector.
		 *
		 * @type {number}
		 */ this.y = y;
        /**
		 * The z value of this vector.
		 *
		 * @type {number}
		 */ this.z = z;
    }
    /**
	 * Sets the vector components.
	 *
	 * @param {number} x - The value of the x component.
	 * @param {number} y - The value of the y component.
	 * @param {number} z - The value of the z component.
	 * @return {Vector3} A reference to this vector.
	 */ set(x, y, z) {
        if (z === undefined) z = this.z; // sprite.scale.set(x,y)
        this.x = x;
        this.y = y;
        this.z = z;
        return this;
    }
    /**
	 * Sets the vector components to the same value.
	 *
	 * @param {number} scalar - The value to set for all vector components.
	 * @return {Vector3} A reference to this vector.
	 */ setScalar(scalar) {
        this.x = scalar;
        this.y = scalar;
        this.z = scalar;
        return this;
    }
    /**
	 * Sets the vector's x component to the given value
	 *
	 * @param {number} x - The value to set.
	 * @return {Vector3} A reference to this vector.
	 */ setX(x) {
        this.x = x;
        return this;
    }
    /**
	 * Sets the vector's y component to the given value
	 *
	 * @param {number} y - The value to set.
	 * @return {Vector3} A reference to this vector.
	 */ setY(y) {
        this.y = y;
        return this;
    }
    /**
	 * Sets the vector's z component to the given value
	 *
	 * @param {number} z - The value to set.
	 * @return {Vector3} A reference to this vector.
	 */ setZ(z) {
        this.z = z;
        return this;
    }
    /**
	 * Allows to set a vector component with an index.
	 *
	 * @param {number} index - The component index. `0` equals to x, `1` equals to y, `2` equals to z.
	 * @param {number} value - The value to set.
	 * @return {Vector3} A reference to this vector.
	 */ setComponent(index, value) {
        switch(index){
            case 0:
                this.x = value;
                break;
            case 1:
                this.y = value;
                break;
            case 2:
                this.z = value;
                break;
            default:
                throw new Error('index is out of range: ' + index);
        }
        return this;
    }
    /**
	 * Returns the value of the vector component which matches the given index.
	 *
	 * @param {number} index - The component index. `0` equals to x, `1` equals to y, `2` equals to z.
	 * @return {number} A vector component value.
	 */ getComponent(index) {
        switch(index){
            case 0:
                return this.x;
            case 1:
                return this.y;
            case 2:
                return this.z;
            default:
                throw new Error('index is out of range: ' + index);
        }
    }
    /**
	 * Returns a new vector with copied values from this instance.
	 *
	 * @return {Vector3} A clone of this instance.
	 */ clone() {
        return new this.constructor(this.x, this.y, this.z);
    }
    /**
	 * Copies the values of the given vector to this instance.
	 *
	 * @param {Vector3} v - The vector to copy.
	 * @return {Vector3} A reference to this vector.
	 */ copy(v) {
        this.x = v.x;
        this.y = v.y;
        this.z = v.z;
        return this;
    }
    /**
	 * Adds the given vector to this instance.
	 *
	 * @param {Vector3} v - The vector to add.
	 * @return {Vector3} A reference to this vector.
	 */ add(v) {
        this.x += v.x;
        this.y += v.y;
        this.z += v.z;
        return this;
    }
    /**
	 * Adds the given scalar value to all components of this instance.
	 *
	 * @param {number} s - The scalar to add.
	 * @return {Vector3} A reference to this vector.
	 */ addScalar(s) {
        this.x += s;
        this.y += s;
        this.z += s;
        return this;
    }
    /**
	 * Adds the given vectors and stores the result in this instance.
	 *
	 * @param {Vector3} a - The first vector.
	 * @param {Vector3} b - The second vector.
	 * @return {Vector3} A reference to this vector.
	 */ addVectors(a, b) {
        this.x = a.x + b.x;
        this.y = a.y + b.y;
        this.z = a.z + b.z;
        return this;
    }
    /**
	 * Adds the given vector scaled by the given factor to this instance.
	 *
	 * @param {Vector3|Vector4} v - The vector.
	 * @param {number} s - The factor that scales `v`.
	 * @return {Vector3} A reference to this vector.
	 */ addScaledVector(v, s) {
        this.x += v.x * s;
        this.y += v.y * s;
        this.z += v.z * s;
        return this;
    }
    /**
	 * Subtracts the given vector from this instance.
	 *
	 * @param {Vector3} v - The vector to subtract.
	 * @return {Vector3} A reference to this vector.
	 */ sub(v) {
        this.x -= v.x;
        this.y -= v.y;
        this.z -= v.z;
        return this;
    }
    /**
	 * Subtracts the given scalar value from all components of this instance.
	 *
	 * @param {number} s - The scalar to subtract.
	 * @return {Vector3} A reference to this vector.
	 */ subScalar(s) {
        this.x -= s;
        this.y -= s;
        this.z -= s;
        return this;
    }
    /**
	 * Subtracts the given vectors and stores the result in this instance.
	 *
	 * @param {Vector3} a - The first vector.
	 * @param {Vector3} b - The second vector.
	 * @return {Vector3} A reference to this vector.
	 */ subVectors(a, b) {
        this.x = a.x - b.x;
        this.y = a.y - b.y;
        this.z = a.z - b.z;
        return this;
    }
    /**
	 * Multiplies the given vector with this instance.
	 *
	 * @param {Vector3} v - The vector to multiply.
	 * @return {Vector3} A reference to this vector.
	 */ multiply(v) {
        this.x *= v.x;
        this.y *= v.y;
        this.z *= v.z;
        return this;
    }
    /**
	 * Multiplies the given scalar value with all components of this instance.
	 *
	 * @param {number} scalar - The scalar to multiply.
	 * @return {Vector3} A reference to this vector.
	 */ multiplyScalar(scalar) {
        this.x *= scalar;
        this.y *= scalar;
        this.z *= scalar;
        return this;
    }
    /**
	 * Multiplies the given vectors and stores the result in this instance.
	 *
	 * @param {Vector3} a - The first vector.
	 * @param {Vector3} b - The second vector.
	 * @return {Vector3} A reference to this vector.
	 */ multiplyVectors(a, b) {
        this.x = a.x * b.x;
        this.y = a.y * b.y;
        this.z = a.z * b.z;
        return this;
    }
    /**
	 * Applies the given Euler rotation to this vector.
	 *
	 * @param {Euler} euler - The Euler angles.
	 * @return {Vector3} A reference to this vector.
	 */ applyEuler(euler) {
        return this.applyQuaternion(_quaternion$4.setFromEuler(euler));
    }
    /**
	 * Applies a rotation specified by an axis and an angle to this vector.
	 *
	 * @param {Vector3} axis - A normalized vector representing the rotation axis.
	 * @param {number} angle - The angle in radians.
	 * @return {Vector3} A reference to this vector.
	 */ applyAxisAngle(axis, angle) {
        return this.applyQuaternion(_quaternion$4.setFromAxisAngle(axis, angle));
    }
    /**
	 * Multiplies this vector with the given 3x3 matrix.
	 *
	 * @param {Matrix3} m - The 3x3 matrix.
	 * @return {Vector3} A reference to this vector.
	 */ applyMatrix3(m) {
        const x = this.x, y = this.y, z = this.z;
        const e = m.elements;
        this.x = e[0] * x + e[3] * y + e[6] * z;
        this.y = e[1] * x + e[4] * y + e[7] * z;
        this.z = e[2] * x + e[5] * y + e[8] * z;
        return this;
    }
    /**
	 * Multiplies this vector by the given normal matrix and normalizes
	 * the result.
	 *
	 * @param {Matrix3} m - The normal matrix.
	 * @return {Vector3} A reference to this vector.
	 */ applyNormalMatrix(m) {
        return this.applyMatrix3(m).normalize();
    }
    /**
	 * Multiplies this vector (with an implicit 1 in the 4th dimension) by m, and
	 * divides by perspective.
	 *
	 * @param {Matrix4} m - The matrix to apply.
	 * @return {Vector3} A reference to this vector.
	 */ applyMatrix4(m) {
        const x = this.x, y = this.y, z = this.z;
        const e = m.elements;
        const w = 1 / (e[3] * x + e[7] * y + e[11] * z + e[15]);
        this.x = (e[0] * x + e[4] * y + e[8] * z + e[12]) * w;
        this.y = (e[1] * x + e[5] * y + e[9] * z + e[13]) * w;
        this.z = (e[2] * x + e[6] * y + e[10] * z + e[14]) * w;
        return this;
    }
    /**
	 * Applies the given Quaternion to this vector.
	 *
	 * @param {Quaternion} q - The Quaternion.
	 * @return {Vector3} A reference to this vector.
	 */ applyQuaternion(q) {
        // quaternion q is assumed to have unit length
        const vx = this.x, vy = this.y, vz = this.z;
        const qx = q.x, qy = q.y, qz = q.z, qw = q.w;
        // t = 2 * cross( q.xyz, v );
        const tx = 2 * (qy * vz - qz * vy);
        const ty = 2 * (qz * vx - qx * vz);
        const tz = 2 * (qx * vy - qy * vx);
        // v + q.w * t + cross( q.xyz, t );
        this.x = vx + qw * tx + qy * tz - qz * ty;
        this.y = vy + qw * ty + qz * tx - qx * tz;
        this.z = vz + qw * tz + qx * ty - qy * tx;
        return this;
    }
    /**
	 * Projects this vector from world space into the camera's normalized
	 * device coordinate (NDC) space.
	 *
	 * @param {Camera} camera - The camera.
	 * @return {Vector3} A reference to this vector.
	 */ project(camera) {
        return this.applyMatrix4(camera.matrixWorldInverse).applyMatrix4(camera.projectionMatrix);
    }
    /**
	 * Unprojects this vector from the camera's normalized device coordinate (NDC)
	 * space into world space.
	 *
	 * @param {Camera} camera - The camera.
	 * @return {Vector3} A reference to this vector.
	 */ unproject(camera) {
        return this.applyMatrix4(camera.projectionMatrixInverse).applyMatrix4(camera.matrixWorld);
    }
    /**
	 * Transforms the direction of this vector by a matrix (the upper left 3 x 3
	 * subset of the given 4x4 matrix and then normalizes the result.
	 *
	 * @param {Matrix4} m - The matrix.
	 * @return {Vector3} A reference to this vector.
	 */ transformDirection(m) {
        // input: THREE.Matrix4 affine matrix
        // vector interpreted as a direction
        const x = this.x, y = this.y, z = this.z;
        const e = m.elements;
        this.x = e[0] * x + e[4] * y + e[8] * z;
        this.y = e[1] * x + e[5] * y + e[9] * z;
        this.z = e[2] * x + e[6] * y + e[10] * z;
        return this.normalize();
    }
    /**
	 * Divides this instance by the given vector.
	 *
	 * @param {Vector3} v - The vector to divide.
	 * @return {Vector3} A reference to this vector.
	 */ divide(v) {
        this.x /= v.x;
        this.y /= v.y;
        this.z /= v.z;
        return this;
    }
    /**
	 * Divides this vector by the given scalar.
	 *
	 * @param {number} scalar - The scalar to divide.
	 * @return {Vector3} A reference to this vector.
	 */ divideScalar(scalar) {
        return this.multiplyScalar(1 / scalar);
    }
    /**
	 * If this vector's x, y or z value is greater than the given vector's x, y or z
	 * value, replace that value with the corresponding min value.
	 *
	 * @param {Vector3} v - The vector.
	 * @return {Vector3} A reference to this vector.
	 */ min(v) {
        this.x = Math.min(this.x, v.x);
        this.y = Math.min(this.y, v.y);
        this.z = Math.min(this.z, v.z);
        return this;
    }
    /**
	 * If this vector's x, y or z value is less than the given vector's x, y or z
	 * value, replace that value with the corresponding max value.
	 *
	 * @param {Vector3} v - The vector.
	 * @return {Vector3} A reference to this vector.
	 */ max(v) {
        this.x = Math.max(this.x, v.x);
        this.y = Math.max(this.y, v.y);
        this.z = Math.max(this.z, v.z);
        return this;
    }
    /**
	 * If this vector's x, y or z value is greater than the max vector's x, y or z
	 * value, it is replaced by the corresponding value.
	 * If this vector's x, y or z value is less than the min vector's x, y or z value,
	 * it is replaced by the corresponding value.
	 *
	 * @param {Vector3} min - The minimum x, y and z values.
	 * @param {Vector3} max - The maximum x, y and z values in the desired range.
	 * @return {Vector3} A reference to this vector.
	 */ clamp(min, max) {
        // assumes min < max, componentwise
        this.x = clamp(this.x, min.x, max.x);
        this.y = clamp(this.y, min.y, max.y);
        this.z = clamp(this.z, min.z, max.z);
        return this;
    }
    /**
	 * If this vector's x, y or z values are greater than the max value, they are
	 * replaced by the max value.
	 * If this vector's x, y or z values are less than the min value, they are
	 * replaced by the min value.
	 *
	 * @param {number} minVal - The minimum value the components will be clamped to.
	 * @param {number} maxVal - The maximum value the components will be clamped to.
	 * @return {Vector3} A reference to this vector.
	 */ clampScalar(minVal, maxVal) {
        this.x = clamp(this.x, minVal, maxVal);
        this.y = clamp(this.y, minVal, maxVal);
        this.z = clamp(this.z, minVal, maxVal);
        return this;
    }
    /**
	 * If this vector's length is greater than the max value, it is replaced by
	 * the max value.
	 * If this vector's length is less than the min value, it is replaced by the
	 * min value.
	 *
	 * @param {number} min - The minimum value the vector length will be clamped to.
	 * @param {number} max - The maximum value the vector length will be clamped to.
	 * @return {Vector3} A reference to this vector.
	 */ clampLength(min, max) {
        const length = this.length();
        return this.divideScalar(length || 1).multiplyScalar(clamp(length, min, max));
    }
    /**
	 * The components of this vector are rounded down to the nearest integer value.
	 *
	 * @return {Vector3} A reference to this vector.
	 */ floor() {
        this.x = Math.floor(this.x);
        this.y = Math.floor(this.y);
        this.z = Math.floor(this.z);
        return this;
    }
    /**
	 * The components of this vector are rounded up to the nearest integer value.
	 *
	 * @return {Vector3} A reference to this vector.
	 */ ceil() {
        this.x = Math.ceil(this.x);
        this.y = Math.ceil(this.y);
        this.z = Math.ceil(this.z);
        return this;
    }
    /**
	 * The components of this vector are rounded to the nearest integer value
	 *
	 * @return {Vector3} A reference to this vector.
	 */ round() {
        this.x = Math.round(this.x);
        this.y = Math.round(this.y);
        this.z = Math.round(this.z);
        return this;
    }
    /**
	 * The components of this vector are rounded towards zero (up if negative,
	 * down if positive) to an integer value.
	 *
	 * @return {Vector3} A reference to this vector.
	 */ roundToZero() {
        this.x = Math.trunc(this.x);
        this.y = Math.trunc(this.y);
        this.z = Math.trunc(this.z);
        return this;
    }
    /**
	 * Inverts this vector - i.e. sets x = -x, y = -y and z = -z.
	 *
	 * @return {Vector3} A reference to this vector.
	 */ negate() {
        this.x = -this.x;
        this.y = -this.y;
        this.z = -this.z;
        return this;
    }
    /**
	 * Calculates the dot product of the given vector with this instance.
	 *
	 * @param {Vector3} v - The vector to compute the dot product with.
	 * @return {number} The result of the dot product.
	 */ dot(v) {
        return this.x * v.x + this.y * v.y + this.z * v.z;
    }
    /**
	 * Computes the square of the Euclidean length (straight-line length) from
	 * (0, 0, 0) to (x, y, z). If you are comparing the lengths of vectors, you should
	 * compare the length squared instead as it is slightly more efficient to calculate.
	 *
	 * @return {number} The square length of this vector.
	 */ lengthSq() {
        return this.x * this.x + this.y * this.y + this.z * this.z;
    }
    /**
	 * Computes the  Euclidean length (straight-line length) from (0, 0, 0) to (x, y, z).
	 *
	 * @return {number} The length of this vector.
	 */ length() {
        return Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
    }
    /**
	 * Computes the Manhattan length of this vector.
	 *
	 * @return {number} The length of this vector.
	 */ manhattanLength() {
        return Math.abs(this.x) + Math.abs(this.y) + Math.abs(this.z);
    }
    /**
	 * Converts this vector to a unit vector - that is, sets it equal to a vector
	 * with the same direction as this one, but with a vector length of `1`.
	 *
	 * @return {Vector3} A reference to this vector.
	 */ normalize() {
        return this.divideScalar(this.length() || 1);
    }
    /**
	 * Sets this vector to a vector with the same direction as this one, but
	 * with the specified length.
	 *
	 * @param {number} length - The new length of this vector.
	 * @return {Vector3} A reference to this vector.
	 */ setLength(length) {
        return this.normalize().multiplyScalar(length);
    }
    /**
	 * Linearly interpolates between the given vector and this instance, where
	 * alpha is the percent distance along the line - alpha = 0 will be this
	 * vector, and alpha = 1 will be the given one.
	 *
	 * @param {Vector3} v - The vector to interpolate towards.
	 * @param {number} alpha - The interpolation factor, typically in the closed interval `[0, 1]`.
	 * @return {Vector3} A reference to this vector.
	 */ lerp(v, alpha) {
        this.x += (v.x - this.x) * alpha;
        this.y += (v.y - this.y) * alpha;
        this.z += (v.z - this.z) * alpha;
        return this;
    }
    /**
	 * Linearly interpolates between the given vectors, where alpha is the percent
	 * distance along the line - alpha = 0 will be first vector, and alpha = 1 will
	 * be the second one. The result is stored in this instance.
	 *
	 * @param {Vector3} v1 - The first vector.
	 * @param {Vector3} v2 - The second vector.
	 * @param {number} alpha - The interpolation factor, typically in the closed interval `[0, 1]`.
	 * @return {Vector3} A reference to this vector.
	 */ lerpVectors(v1, v2, alpha) {
        this.x = v1.x + (v2.x - v1.x) * alpha;
        this.y = v1.y + (v2.y - v1.y) * alpha;
        this.z = v1.z + (v2.z - v1.z) * alpha;
        return this;
    }
    /**
	 * Calculates the cross product of the given vector with this instance.
	 *
	 * @param {Vector3} v - The vector to compute the cross product with.
	 * @return {Vector3} The result of the cross product.
	 */ cross(v) {
        return this.crossVectors(this, v);
    }
    /**
	 * Calculates the cross product of the given vectors and stores the result
	 * in this instance.
	 *
	 * @param {Vector3} a - The first vector.
	 * @param {Vector3} b - The second vector.
	 * @return {Vector3} A reference to this vector.
	 */ crossVectors(a, b) {
        const ax = a.x, ay = a.y, az = a.z;
        const bx = b.x, by = b.y, bz = b.z;
        this.x = ay * bz - az * by;
        this.y = az * bx - ax * bz;
        this.z = ax * by - ay * bx;
        return this;
    }
    /**
	 * Projects this vector onto the given one.
	 *
	 * @param {Vector3} v - The vector to project to.
	 * @return {Vector3} A reference to this vector.
	 */ projectOnVector(v) {
        const denominator = v.lengthSq();
        if (denominator === 0) return this.set(0, 0, 0);
        const scalar = v.dot(this) / denominator;
        return this.copy(v).multiplyScalar(scalar);
    }
    /**
	 * Projects this vector onto a plane by subtracting this
	 * vector projected onto the plane's normal from this vector.
	 *
	 * @param {Vector3} planeNormal - The plane normal.
	 * @return {Vector3} A reference to this vector.
	 */ projectOnPlane(planeNormal) {
        _vector$c.copy(this).projectOnVector(planeNormal);
        return this.sub(_vector$c);
    }
    /**
	 * Reflects this vector off a plane orthogonal to the given normal vector.
	 *
	 * @param {Vector3} normal - The (normalized) normal vector.
	 * @return {Vector3} A reference to this vect