Dntrade
===============
Модуль интеграции dntrade.com.ua для Drupal 10+ 
  для GET/POST-взаимодействия с точками входа одноимённой CRM.

Предоставляет сервисы:
  - \Drupal::service('dntrade.client')
  - \Drupal::service('dntrade.client.factory')
  - \Drupal::service('dntrade.order_place_subscriber')


Фичи
===============
Заказы:
- Создаёт заказ в crm Dntrade путём получения uuid товара отдельным запросом к API DNTrade.
  Записывает этот uuid товара в поле field_dntrade_code для уменьшения кол-ва будущих http-запросов.
  Сделано так п.ч. программно создать заказ в DNTrade нельзя, если не знаешь UUID товара.
- Геттер полей формы чекаута касательно перс. данных контрагента:
  - города, улицы, дома/квартиры (если стоит /commerce_novaposhta),
  - кастом-поля Вулиця / field_street, Будинок / field_house, Квартира / field_appartment).
  Т.е. передаёт в DNTrade данные о контрагенте от модуля Новой почты и полей курьера.
drush-скрипты (скопируйте в корень сайта сиблингом к папке web/):
  - env PATH="/opt/php81/bin:$PATH" ./bin/drush scr GET-orders-statuslist.php
  - env PATH="/opt/php81/bin:$PATH" ./bin/drush scr GET-partners-list.php
  - env PATH="/opt/php81/bin:$PATH" ./bin/drush scr GET-stores-ids.php
  - env PATH="/opt/php81/bin:$PATH" ./bin/drush scr POST-create-order.php
  - env PATH="/opt/php81/bin:$PATH" ./bin/drush scr POST-products-list.php > prods_list.txt
drush-команды:
  - env PATH="/opt/php81/bin:$PATH" ./bin/drush dntrade:test-connection
  - # Показать статус синхронизации
    env PATH="/opt/php81/bin:$PATH" ./bin/drush dntrade:sync-status
  - env PATH="/opt/php81/bin:$PATH" ./bin/drush dntrade:sync --type=full
  - env PATH="/opt/php81/bin:$PATH" ./bin/drush dntrade:sync --type=incremental
  - 2do: дополнить
Синхронизация товаров DNTrade > Drupal
  - Сайт должен содержать бандлы товаров, соответствующие рутовым категориям, созданным в DNTrade.
    Иначе в ВотчДоге Вы найдете сообщения типа:
      'Product "тестовий товар 1" (code: 100) skipped - parent category "" not mapped in bundles.yml'
      Это значит, например, что товар был в категории "-- БЕЗ КАТЕГОРІЇ --", у которой нет категории-родителя.
  - Пока что синхронизация идёт только в пределах одного склада – см. $dntrade_store_uuid.
    Т.е. работает только для режима "основной склад для синхронизации".
    Если в DNTrade товар просто перемещен на другой склад (store_id изменился), он может не попасть в ответ API.
    2do: учитывать все склады.
  - Статус.
    Если базовый товар Деактивований – все вариации в Друпал снимаются с публикации.
      Модуль в таком случае ставит галку в кастомном булиевом поле "Немає у наявності" / field_available.
      Такой путь хорош тем, что для SEO (людей, пришедших из поисковиков) мы не закрываем карточку товара.
    Если Деактивована какая-либо из вариаций – она снимается с публикации и в Друпал. Т.е. становится недоступной к покупке.
  - Атрибуты: размер и цвет.
    - Поддержка форматов: числовые, дробные, с миллиметрами, UK/EU.
    - Комбинированные размеры (S\S, M\R).
    - Числовые комбинации (26\28, 28\30).
    Умная догадка:
      - Если атрибут не подходит под правила, система пытается догадаться;
      - Приоритет отдается размеру (перед цветом) при наличии цифр.
    Если появляется атрибут, который не является ни размером, ни цветом (например, "специальная серия", "new", "limited edition"):
      - Он будет залогирован как "unknown".
      - Не будет назначен ни размеру, ни цвету.
      - Можно добавить третий тип атрибута (например, 'tag' или 'feature') при необходимости:
        $rules['tag'] = [
          'patterns' => [
            '/^(new|новинка|limited|special|exclusive|ексклюзив)$/i',
          ],
          'priority' => 3, // Низкий приоритет
        ];


Обратный импорт товаров Drupal > DNTrade c помощью convert_drupal_to_dntrade.py
===============
Cкрипт для конвертации *.csv-файла сделанного экспортом модуля /commerce_smart_importer
в xls-файл в формат приемлемый DNTrade.
Установка библиотек для него:
  pip install pandas openpyxl
Проверка, что установились:
  python -c "import pandas; print(f'pandas: {pandas.__version__}')"
  python -c "import openpyxl; print(f'openpyxl: {openpyxl.__version__}')"
Использование:
  - сохраняем файл как *.csv c разделителями "запятыми" (";"), 
  - переводим файл в utf8.
  - python convert_drupal_to_dntrade.py
  или
    python convert_drupal_to_dntrade.py Взуття.csv Взуття.xlsx 
Что делает:
  - из первого ряда товара создаёт базовый товар и вариацию;
  - поле ID(product) использует как "Код";
  - поле Розмір использует как поле Властивості "**Розмір";
  - создаёт поле "Модифікації" и заполняет его значениями "Так";
  - создаёт поле "Код товару модифікації" и заполняет его значениями родительского ID(product);
  - и т.д.
Название рутовой категории – поля "Група товарів" берётся из названия файла.
  Например: Взуття.csv > "Взуття".


Ограничения
===============
Заказы
- Если в вариации нет значения code в поле "Код DNTrade" / field_dntrade_code – нет и заказа на стороне DNTrade.
  Это обычно означает, что товар с таким code не создан на стороне dntrade.com.ua.
  Либо товар удалён в DNTrade.


Установка
===============
- В админке на стр. /admin/dntrade/settings вводим:
  - Базовый url API. Обычно https://api.dntrade.com.ua/
  - Токен авторизации – Ваш API key.
    Как получить:
      Опції > Інтеграції > выбираем "API DNTrade" > откроется поп-ап.
    см. ниже: Как проверить токен
- Для категорий используется поле с маш. именем field_ref_cat в типе товара (в каждом из типов товара, если их несколько).
- Создаём 2 *_dntrade_* поля в бандле вариаций типа "Текст простой":
  - "Код DNTrade" / field_dntrade_code                 55 символов (обычно хватает и 6) < uuid товара гетится на основе этого DNTrade` code.
  - "DNTrade product uuid" / field_dntrade_prod_uuid   36 символов
    Для синхронизации. Отключено в УОФ (управление отображением формы).
- Для создания заказов автоматически в DNTrade при заказе на Вашем сайте, в order`е 
  на /admin/commerce/config/order-types/default/edit/fields создаём:
  - поле "DNTrade order uuid" / field_dntrade_order_uuid    типа "Текст простой"  36 символов
    В него OrderPlaceSubscriber пишет uuid заказа для возможной синхронизации.
  - поле "uuid товара не найден на DNTrade"	/ field_no_uuid	типа "Булева змінна"  < для админки заказа на случай см. выше: товар с таким code не создан.
  - Если нужно поле комментариев, в order добавляем поле field_order_notes.
- Маппинг рутовая-категория:бандл меняем в settings/bundles.yml
  Это значит, что модуль написан из соображения, что каждая (из открытых для синхронизации с вебсайтом) рутовая категория в DNTrade 
  соответствует одному бандлу товара.
- В коде меняем под себя константы:
    - $dntrade_store_uuid
      Как его получить:
        drush scr GET-stores-ids.php
    - channel
        Канал сначала должен быть создан в админке/ЛК DNTrade
        Как создать канал продаж:
          вручну створити порожнє замовлення, вписати канал продаж та не зберігати замовлення.


Ограничения CRM
===============
Импорт / Экспорт
Изображений.
  - Импортировать более одного изображения нельзя. В том числе и в поле поле "Додаткові дані" > Зображення.
  - Импортировать изображения в модификации нельзя, – только в базовый товар.
  - Экспортируется то же: только 1 изображение.
Не импортируются поля:
  - Синхронізація з вебсайтом
  - Статус


Особенности CRM
===============
- uuid любой сущности – склада, заказа, товара – не увидеть в админке DNTrade – только программно.
- uuid товара можно получать:
  - в теории:
    - при создании товара в Друпал, прописав программное создание его в это время в DNTrade
      но категория должна быть обязательной и уже существовать в CRM;
    - интегрировав пейджинговый (запросы по 100 шт с офсетом) views, который тянет список товаров с CRM в Drupal;
  - как реализовано в этом модуле: по требованию.
- У товара с вариациями в DNTrade нет parent uuid.
- Покупателя идентифицируют по телефону, а потом по e-mail, п.ч. при создании заказа на те же перс. данные, не создаётся новый или дубль-контрагент.


Как проверить токен
===============
- на https://api.dntrade.com.ua/docs/
    Справа зелёная кнопка "Authorize" с замком > вводишь токен и закрываешь модалку.
    Делаешь запрос и жмёшь Execute > получаешь Responses:
      - 1-ый 200-ый – твой, нижние, с "No links" справа – это примеры ответов, а не реальные ответы.
      - выше него – пример для Curl.
- на сервере прямо задаёшь запрос в ком. строке, код берёшь с варианта выше (он будет после нажатия Execute, в регионе Responses):
curl -X 'POST' \
  'https://api.dntrade.com.ua/products/list?limit=12' \
  -H 'accept: application/json' \
  -H 'ApiKey: 9clet3lfti8oulus91h74yk1k5t2e31r37jhxsfu6eo01v8ffvqg' \
  -H 'Content-Type: application/json' \
  -d '{
}'


Папки и файлы:
===============
drush-scripts\  < drush-скрипты
src/
  DntradeClient.php < GuzzleHttp\Client
    • логируем сырой ответ для отладки
    • логируем структуру объекта
    • методы, предоставляемые этим сервисом
{src\EventSubscriber\OrderPlaceSubscriber.php
  
onPlaceTransition()
  prepareCartItems()
    getDntradeCode() - gets 'code' saved in Drupal
    getProductUuid() - gets product id from DNTrade in a request
  createOrderData()

}


API: кастом-использование
===============
В theme.theme или в кастом-модуле:
// Example: Get all centers.
```
use Drupal\dntrade\DntradeClientInterface;
// Get the DNTrade client service.
/** @var \Drupal\dntrade\DntradeClientInterface $client */
$client = \Drupal::service('dntrade.client');
try {
  $centers = $client->getCenters();
  print_r($centers); // This will print the data returned by the API.
}
catch (\Drupal\dntrade\DntradeClientException $e) {
  // Handle potential API errors.
  \Drupal::logger('dntrade')->error('Error fetching centers: @message', ['@message' => $e->getMessage()]);
}
```
или так:
```
  $client = \Drupal::service('dntrade.client.factory')->get();
  $orderData = [
    ..
  ];
  $response = $client->createOrder($orderData);
```


AUTHOR
===============
Dunot
Drupal: (https://www.drupal.org/u/dunot)
Email: dunot.job@gmail.com

Company: Zina Design Studio
Website: (https://zina.design/)  
Drupal: (https://www.drupal.org/user/361734/)
Email: mail@zina.design
