<?php
// запускать так: 
  // env PATH="/opt/php81/bin:$PATH" ./bin/drush scr POST-products-list.php > products-list.txt

use Drupal\dntrade\DntradeClientInterface;

// Get the DNTrade client service.
/** @var \Drupal\dntrade\DntradeClientInterface $client */
$client = \Drupal::service('dntrade.client.factory')->get();

$productsData = [
  'limit' => 100, // 100 максимум
  'website_synch' => 1, // Прапор синхронізації з веб-сайтом
  'store_id' => '833a605c-fa32-46b6-9735-067239c68634', // uuid cклада: без него у товаров категории будут пустыми
  // 'code' => 100, // поиск по полю 'Код товару'
  // 'offset' => 100, // integer
];

try {
  $response = $client->getProductsList($productsData);
  print_r($response); // This will print the data returned by the API.
}
catch (\Drupal\dntrade\DntradeClientException $e) {
  // Handle potential API errors
  $error_message = $e->getMessage();
  \Drupal::logger('dntrade')->error('Error getting products: @message', ['@message' => $error_message]);
  echo "Error: " . $error_message . "\n";
}
// "Error getting products: Failed to make a request for uri https://api.dntrade.com.ua/products/list with message API returned error status: error."
  // п.ч. "Не вірний ApiKey"
