<?php

namespace Drupal\dntrade\Controller;

use Drupal\Core\Controller\ControllerBase;

/**
 * Help page for DNTrade module.
 */
class HelpPageController extends ControllerBase {
  
  /**
   * Display help page.
   */
  public function helpPage() {
    $build = [];
    
    $build['intro'] = [
      '#markup' => '<h2>' . $this->t('DNTrade Integration Help') . '</h2>' .
        '<p>' . $this->t('This module integrates your Drupal commerce store with DNTrade API.') . '</p>',
    ];
    
    $build['sections'] = [
      '#type' => 'vertical_tabs',
    ];
    
    // Setup section
    $build['setup'] = [
      '#type' => 'details',
      '#title' => $this->t('Initial Setup'),
      '#group' => 'sections',
    ];
    
    $build['setup']['content'] = [
      '#markup' => '
        <h3>' . $this->t('Step 1: Configure API Settings') . '</h3>
        <ol>
          <li>' . $this->t('Go to <a href=":url">API Settings</a>', [
            ':url' => \Drupal\Core\Url::fromRoute('dntrade.settings_form')->toString()
          ]) . '</li>
          <li>' . $this->t('Enter your DNTrade API Base URI (usually https://api.dntrade.com.ua/)') . '</li>
          <li>' . $this->t('Enter your DNTrade API Key') . '</li>
          <li>' . $this->t('Click "Test Connection" to verify the settings') . '</li>
          <li>' . $this->t('Save the configuration') . '</li>
        </ol>
        
        <h3>' . $this->t('Step 2: Configure Sync Settings') . '</h3>
        <ol>
          <li>' . $this->t('Go to <a href=":url">Sync Settings</a>', [
            ':url' => \Drupal\Core\Url::fromRoute('dntrade.sync_settings_form')->toString()
          ]) . '</li>
          <li>' . $this->t('Set synchronization intervals') . '</li>
          <li>' . $this->t('Configure processing options') . '</li>
          <li>' . $this->t('Set up email notifications if desired') . '</li>
          <li>' . $this->t('Save the configuration') . '</li>
        </ol>
        
        <h3>' . $this->t('Step 3: Run Initial Sync') . '</h3>
        <ol>
          <li>' . $this->t('Go to the <a href=":url">DNTrade admin page</a>', [
            ':url' => \Drupal\Core\Url::fromRoute('dntrade.admin')->toString()
          ]) . '</li>
          <li>' . $this->t('Click "Run Full Synchronization"') . '</li>
          <li>' . $this->t('Wait for the batch process to complete') . '</li>
        </ol>
      ',
    ];
    
    // Sync types section
    $build['sync_types'] = [
      '#type' => 'details',
      '#title' => $this->t('Synchronization Types'),
      '#group' => 'sections',
    ];
    
    $build['sync_types']['content'] = [
      '#markup' => '
        <h3>' . $this->t('Full Synchronization') . '</h3>
        <ul>
          <li>' . $this->t('Processes ALL products from DNTrade') . '</li>
          <li>' . $this->t('Updates prices, stock, and availability') . '</li>
          <li>' . $this->t('Marks missing products as unavailable') . '</li>
          <li>' . $this->t('Runs less frequently (e.g., once per day)') . '</li>
        </ul>
        
        <h3>' . $this->t('Incremental Synchronization') . '</h3>
        <ul>
          <li>' . $this->t('Processes only MODIFIED products') . '</li>
          <li>' . $this->t('Faster than full sync') . '</li>
          <li>' . $this->t('Runs more frequently (e.g., every 15 minutes)') . '</li>
          <li>' . $this->t('Does not mark products as unavailable') . '</li>
        </ul>
      ',
    ];
    
    // Drush commands section
    $build['drush'] = [
      '#type' => 'details',
      '#title' => $this->t('Drush Commands'),
      '#group' => 'sections',
    ];
    
    $build['drush']['content'] = [
      '#markup' => '
        <h3>' . $this->t('Available Commands') . '</h3>
        <dl>
          <dt><code>drush dntrade:sync --type=full</code></dt>
          <dd>' . $this->t('Run full synchronization') . '</dd>
          
          <dt><code>drush dntrade:sync --type=incremental</code></dt>
          <dd>' . $this->t('Run incremental synchronization') . '</dd>
          
          <dt><code>drush dntrade:cron</code></dt>
          <dd>' . $this->t('Run scheduled synchronization') . '</dd>
          
          <dt><code>drush dntrade:status</code></dt>
          <dd>' . $this->t('Show synchronization status') . '</dd>
          
          <dt><code>drush dntrade:test-connection</code></dt>
          <dd>' . $this->t('Test API connection') . '</dd>
          
          <dt><code>drush dntrade:migrate</code></dt>
          <dd>' . $this->t('Migrate from old CSV system') . '</dd>
          
          <dt><code>drush dntrade:clear</code></dt>
          <dd>' . $this->t('Clear sync state and logs') . '</dd>
        </dl>
      ',
    ];
    
    // Troubleshooting section
    $build['troubleshooting'] = [
      '#type' => 'details',
      '#title' => $this->t('Troubleshooting'),
      '#group' => 'sections',
    ];
    
    $build['troubleshooting']['content'] = [
      '#markup' => '
        <h3>' . $this->t('Common Issues') . '</h3>
        
        <h4>' . $this->t('API Connection Failed') . '</h4>
        <ul>
          <li>' . $this->t('Verify your API Base URI and API Key') . '</li>
          <li>' . $this->t('Check if the API endpoint is accessible') . '</li>
          <li>' . $this->t('Verify that your IP is whitelisted in DNTrade') . '</li>
        </ul>
        
        <h4>' . $this->t('Rate Limiting Errors') . '</h4>
        <ul>
          <li>' . $this->t('DNTrade API allows 100 requests per minute') . '</li>
          <li>' . $this->t('The module automatically handles rate limiting') . '</li>
          <li>' . $this->t('If you see 429 errors, increase sync intervals') . '</li>
        </ul>
        
        <h4>' . $this->t('Products Not Appearing') . '</h4>
        <ul>
          <li>' . $this->t('Check if products have <code>website_synch = 1</code> in DNTrade') . '</li>
          <li>' . $this->t('Verify product categories are mapped correctly') . '</li>
          <li>' . $this->t('Check the sync log file at <code>/dntrade/dnt_posts.log</code>') . '</li>
        </ul>
        
        <h4>' . $this->t('Images Not Downloading') . '</h4>
        <ul>
          <li>' . $this->t('Check "Download Product Images" setting') . '</li>
          <li>' . $this->t('Verify file system permissions') . '</li>
          <li>' . $this->t('Check if images exist in DNTrade product data') . '</li>
        </ul>
      ',
    ];
    
    return $build;
  }
}
