<?php

namespace Drupal\dntrade;

use Drupal\Core\Config\ConfigFactoryInterface;

/**
 * Class for creating and configuring DntradeClient instances.
 *
 * @package Drupal\dntrade
 */
class DntradeClientFactory implements DntradeClientFactoryInterface {


  /**
   * Config factory.
   *
   * @var \Drupal\Core\Config\ConfigFactoryInterface
   */
  protected $configFactory;

  /**
   * Constructs a new Dntrade Client Factory instance.
   *
   * @param \Drupal\Core\Config\ConfigFactoryInterface $configFactory
   *   Config Factory.
   */
  public function __construct(ConfigFactoryInterface $configFactory) {
    $this->configFactory = $configFactory;
  }

  /**
   * {@inheritdoc}
   */
  public function get() {
    $settings = $this->configFactory->get('dntrade.settings');
    $config = [
      'base_uri' => $settings->get('base_uri'),
      'headers'  => [
        'Accept' => 'application/json',
        'ApiKey' => $settings->get('api_key'),
      ],
    ];
    $api_config = [
      'base_uri' => $settings->get('base_uri'),
      'api_key' => $settings->get('api_key'),
    ];
    $client = new DntradeClient($config);
    $client->setApi($api_config);
    return $client;
  }

}
