<?php

namespace Drupal\dntrade;

/**
 * Interface of DntradeClientInterface.
 *
 * @package Drupal\dntrade
 */
interface DntradeClientInterface {

  /**
   * Creates a new order.
   *
   * @param array $orderData
   *   Order data in the required format.
   *
   * @return mixed
   *   Response from the API.
   *
   * @throws \Drupal\dntrade\DntradeClientException
   */
  public function createOrder(array $orderData);

  /**
   * Gets products list.
   *
   * @param array $productsData
   *   Products filter data.
   *
   * @return mixed
   *   Products list.
   *
   * @throws \Drupal\dntrade\DntradeClientException
   */
  public function getProductsList(array $productsData);
  
}
