# Changelog

## 1.0.0-rc1 — 2025-11-20

### Added

- New **DOC to HTML Field Widget** for `text_with_summary` and `text_long`.
- Full support for **DOC/DOCX → HTML conversion** inside node edit forms.
- Integrated with **CKEditor 5** (full_html text format only).
- Added configurable **Body Regex** extraction system.
- Added **DOM Regex** post-processing pipeline.
- Implemented secure file handling using `managed_file`.
- Added DefaultService, ConversionManager, FileService improvements.
- New dedicated widget wrapper and restructured Form API logic.
- Textarea value injection during form rebuild now fully stable.

### Fixed

- CKEditor 5 AJAX integration conflicts.
- Missing or empty file ID from widget parents path.
- Multi-value field compatibility.
- Form rebuild losing text_format values.
- Deprecated or invalid API usages.
- Several PHPStan/Drupal-check issues.

### Changed

- Removed previous AJAX refresh flow, replaced with a more stable non-AJAX update mechanism.
- Improved conversion result handling and FormState propagation.

---

# 📝 **Drupal.org Release Notes**

*(These go into the Drupal.org "Release notes" box when you create the release.)*

**Doc to HTML – Release Candidate 1 (RC1)**

This is the first release candidate for the Doc to HTML module, rewritten for modern Drupal versions.

### **Highlights**

- Convert **DOC/DOCX files directly inside node edit forms**.
- Seamless integration with the **CKEditor 5** editing environment.
- Supports **text_with_summary** and **text_long** fields.
- Automatic extraction of the `<body>` section using configurable **Body Regex**.
- Optional **DOM Regex** transformation for advanced cleanup/sanitization.
- Improved performance and file safety.
- Stable Form API implementation without fragile AJAX refreshes.

### **Drupal Compatibility**

- Drupal **10.1+**
- Drupal **11.x**
- Requires PHP **8.1+**

### **Status**

This RC version is considered feature complete and suitable for testing in non-production environments.
A stable 1.0.0 release will follow after community feedback.

---

# 🏷️ **Git Tag Message (for `git tag -a 1.0.0-rc1 -m "..."`)**

