<?php

namespace Drupal\doc_to_html\Services;

/**
 * Defines the required methods for the command execution service.
 */
interface CmdServiceInterface
{

  /**
   * Returns the LibreOffice version string or NULL on failure.
   *
   * @return string|null
   *   The version string or NULL.
   */
  public function getLibreOfficeVersion(): ?string;

  /**
   * Converts a DOC/DOCX file and returns the final processed HTML.
   *
   * @param string $sourceUri
   *   The source file URI.
   * @param bool $applyRegex
   *   Whether the markup extraction should apply regex parsing.
   * @param string|null $overrideBodyRegex
   *   Optional override regex to extract the HTML body instead of using
   *   configured one.
   * @param int|null $overrideBodyMatchIndex
   *   Optional override match index to select a capture group from the body
   *   regex (defaults to 0 or the configured value if not provided).
   *
   * @return string|null
   *   The parsed HTML or NULL on failure.
   */
  public function convertFile(string $sourceUri, bool $applyRegex = FALSE, ?string $overrideBodyRegex = NULL, ?int $overrideBodyMatchIndex = NULL): ?string;

}
