<?php

namespace Drupal\doc_to_html\Services;

/**
 * Provides file and directory utilities for DOC to HTML conversion.
 */
interface FileServiceInterface
{

  /**
   * Cleans the module's HTML output directory.
   */
  public function cleanFolder(): void;

  /**
   * Resolves a stream wrapper URI into a real filesystem path.
   */
  public function realPath(string $uri): string;

  /**
   * Returns a shell-safe path (spaces escaped).
   */
  public function escapeRealPath(string $uri): string;

  /**
   * Converts a file URI to its expected .html result.
   */
  public function convertUriToHtml(string $uri): string;

  /**
   * Ensures the public output directory exists and returns its real path.
   *
   * @param string $folder
   *   Folder name relative to public:// (e.g. 'doc_to_html').
   *
   * @return string
   *   The real filesystem path of the directory.
   */
  public function prepareDirectory(string $folder): string;

}
