<?php

namespace Drupal\doc_to_html\Services;

/**
 * Provides markup parsing utilities for DOC→HTML conversion.
 */
interface MarkupServiceInterface
{

  /**
   * Reads a converted HTML file and applies module parsing rules.
   *
   * @param string $sourceUri
   *   The original file URI (e.g. public://file.docx).
   * @param bool $applyRegex
   *   Whether the regex filter should be applied.
   * @param string|null $overrideBodyRegex
   *   Optional. If provided, this regex will be used to extract the body
   *   instead of the configured one.
   *
   * @return string|null
   *   The parsed HTML or NULL on failure.
   */
  public function parseConvertedHtml(string $sourceUri, bool $applyRegex = FALSE, ?string $overrideBodyRegex = NULL, ?int $overrideBodyMatchIndex = NULL): ?string;

}
