This project enables the containerization of a Drupal project for use as a standalone Docker/Podman container, a Docker Compose/Swarm setup, or on Kubernetes.

It is designed for use in remote/production environments. For local development, there're already great solutions out there.

There are also several Dockerfile alternatives for production usage ([1](https://hub.docker.com/_/drupal), [2](https://hub.docker.com/r/bitnami/drupal), [3](https://github.com/wodby/drupal-php)). In our opinion, these alternatives are complex, highly opinionated, not suited for usage out-of-the-box or lack some of the features we provide here.


## Features

* Apache + `mod_php` based.
* Debian-based.
* Full project codebase included in the resulting image.
* Maximum flexibility: we try to not hardcode configuration.
* Allow to specify APT packages to install.
* Allow to specify PHP version and extensions to install in addition to Drupal required ones.
* PHP configuration is managed via environment variables. It is recommented to install [drupal/settingsphp](https://www.drupal.org/project/settingsphp) in order to manage also Drupal settings via environment variables.


## What is included

* `Dockerfile`.
* `.env.example`.
* System configuration files.
* Example Docker Compose files for local testing.


## Installation

Recommended method is to use composer, since it is the same process as any other Drupal package, and allows to get updates and perform customizations with patches.

<code>
composer require drupal/dockerize
rsync -av vendor/drupal/dockerize/assets/docker .
cp docker/.env.example docker/.env
git add .dockerignore docker/
</code>

Alternatively you could just copy the contents of `dist/` subdirectory from this repository over your Drupal project and commit files.


## Usage

### Composer patches and other custom files

The `Dockerfile` copies `assets/` subdirectory into the image. It is adviced to place composer patches at `assets/patches/` and any other custom files such as translations in a subdirectory of `assets/`.


### Build options

Available build arguments:

* `GIT_COMMIT`. SHA of the git commit related to this build.
* `PHP_VERSION`. Defaults to 8.3.
* `PHP_DEFAULT_EXTENSIONS`. Default set of extensions to install. See Dockerfile for details. You can redefine it and exclude extensions.
* `PHP_EXTRA_EXTENSIONS`. Set of extensions to install in addition to the default ones. Accepts a list such as `bcmath,redis,zip`.
* `PHP_ENVIRONMENT`. Accepted values: [`production`](https://github.com/php/php-src/blob/master/php.ini-production) or [`development`](https://github.com/php/php-src/blob/master/php.ini-development). It indicates which upstream `php.ini` file to use. Defaults to `production`.
* `APT_DEFAULT_PACKAGES`. Default set of system packages to install. See Dockerfile for details. You can redefine it and exclude packages.
* `APT_EXTRA_PACKAGES`. Extra set of packages to install in addition to the default ones. Accepts a list such as `curl,jq`.

#### Example

<code>
docker build --build-arg GIT_COMMIT=$(git rev-parse HEAD) --build-arg PHP_EXTRA_EXTENSIONS="bcmath,redis,zip" --build-arg APT_EXTRA_PACKAGES="curl,jq" . -f docker/Dockerfile -t mydrupalsite-web
</code>

### Manually build and push to a Docker registry

<code>
docker build . -f docker/Dockerfile -t registry.example.com/drupal:latest
docker push registry.example.com/drupal:latest
</code>

### Local testing with docker compose

Copy and adjust `.env` as needed:

<code>
cp docker/.env.example docker/.env
</code>

Build, launch and install:

<code>
export GIT_COMMIT=$(git rev-parse HEAD)
docker compose -f docker/compose.yml -f docker/compose.local.yml build
docker compose -f docker/compose.yml -f docker/compose.local.yml up
docker compose -f docker/compose.yml -f docker/compose.local.yml exec drupal drush site:install --existing-config --account-pass=admin -y
</code>

Visit: http://localhost:8080

### Gitlab CI

Basic example based on [Auto DevOps](https://docs.gitlab.com/topics/autodevops/).

<code>
include:
  - template: Jobs/Build.gitlab-ci.yml

stages:
  - build

build:
  variables:
    DOCKERFILE_PATH: docker/Dockerfile
    AUTO_DEVOPS_BUILD_IMAGE_EXTRA_ARGS: >-
      --build-arg GIT_COMMIT=$CI_COMMIT_SHA
      --build-arg APT_EXTRA_PACKAGES=curl,jq
      --build-arg PHP_EXTRA_EXTENSIONS=bcmath,redis,zip
</code>

### GitHub Actions

#TODO#
