<?php

namespace Drupal\domain_config\Config;

use Drupal\Component\EventDispatcher\Event;

/**
 * Provides a domain override event for event listeners.
 *
 * @see \Drupal\Core\Config\ConfigCrudEvent
 */
class DomainConfigOverrideCrudEvent extends Event {

  /**
   * Configuration object.
   *
   * @var \Drupal\domain_config\Config\DomainConfigOverride
   */
  protected $override;

  /**
   * Constructs a configuration event object.
   *
   * @param \Drupal\domain_config\Config\DomainConfigOverride $override
   *   Configuration object.
   */
  public function __construct(DomainConfigOverride $override) {
    $this->override = $override;
  }

  /**
   * Gets configuration object.
   *
   * @return \Drupal\domain_config\Config\DomainConfigOverride
   *   The configuration object that caused the event to fire.
   */
  public function getDomainConfigOverride() {
    return $this->override;
  }

}
