<?php

namespace Drupal\domain_config_ui;

use Drupal\domain_config\DomainConfigLanguageManager;

/**
 * Extends the language manager to set the current language on runtime.
 */
class DomainConfigUILanguageManager extends DomainConfigLanguageManager {

  /**
   * The Domain config UI manager.
   *
   * @var \Drupal\domain_config_ui\DomainConfigUIManagerInterface
   */
  protected $domainConfigUIManager;

  /**
   * Set the domain config UI manager.
   *
   * @param \Drupal\domain_config_ui\DomainConfigUIManagerInterface $config_ui_manager
   *   The domain config UI manager.
   */
  public function setDomainConfigUiManager(DomainConfigUIManagerInterface $config_ui_manager): void {
    $this->domainConfigUIManager = $config_ui_manager;
  }

  /**
   * {@inheritdoc}
   */
  public function getLanguageConfigOverride($langcode, $name) {
    if ($this->domain && $this->domainConfigUIManager->isRegisteredConfiguration($name)) {
      return $this->domainConfigFactoryOverride->getDomainOverride($this->domain->id(), $langcode, $name);
    }
    else {
      return $this->decoratedManager->getLanguageConfigOverride($langcode, $name);
    }
  }

}
