<?php

namespace Drupal\domain\Cache;

use Drupal\Core\Cache\CacheableMetadata;
use Drupal\Core\Cache\Context\CalculatedCacheContextInterface;
use Drupal\domain\DomainNegotiatorInterface;

/**
 * Defines the DomainCacheContext service for "per domain" caching.
 */
class DomainCacheContext implements CalculatedCacheContextInterface {

  /**
   * Constructs a new DomainCacheContext service.
   *
   * @param \Drupal\domain\DomainNegotiatorInterface $domainNegotiator
   *   The domain negotiator.
   */
  public function __construct(protected DomainNegotiatorInterface $domainNegotiator) {
  }

  /**
   * {@inheritdoc}
   */
  public static function getLabel() {
    return t('Domain');
  }

  /**
   * {@inheritdoc}
   */
  public function getContext($parameter = NULL) {
    return $this->domainNegotiator->getActiveId();
  }

  /**
   * {@inheritdoc}
   */
  public function getCacheableMetadata($parameter = NULL) {
    return new CacheableMetadata();
  }

}
