<?php

namespace Drupal\Tests\domain_config_ui\Functional;

use Drupal\Tests\domain\Traits\DomainLoginTestTrait;
use Drupal\Tests\domain\Traits\DomainTestTrait;
use Drupal\Tests\domain_config\Functional\DomainConfigTestBase;
use Drupal\Tests\domain_config_ui\Traits\DomainConfigUITestTrait;

/**
 * Tests the domain config user interface.
 *
 * @group domain_config_ui
 */
class DomainConfigUIOverrideTest extends DomainConfigTestBase {

  use DomainTestTrait;
  use DomainLoginTestTrait;
  use DomainConfigUITestTrait;

  /**
   * The default theme.
   *
   * @var string
   */
  protected $defaultTheme = 'stark';

  /**
   * {@inheritdoc}
   */
  protected static $modules = [
    'language',
    'user',
    'domain_config_ui',
    'domain_config_test',
  ];

  /**
   * {@inheritDoc}
   */
  protected function setUp(): void {
    parent::setUp();

    $this->createAdminUser();
    $this->createEditorUser();

    $this->setBaseHostname();
    $this->domainCreateTestDomains(5);

    $this->createLanguage();
  }

  /**
   * Tests that we can save domain and language-specific settings.
   */
  public function testOverrides() {
    // The domain override factory.
    /** @var \Drupal\domain_config\Config\DomainConfigFactoryOverrideInterface $domain_config_factory_override */
    $domain_config_factory_override = \Drupal::service('domain.config_factory_override');
    // The domain language override factory.
    /** @var \Drupal\domain_config\Config\DomainLanguageConfigFactoryOverrideInterface $domain_language_config_factory_override */
    $domain_language_config_factory_override = \Drupal::service('domain.language.config_factory_override');

    // Test base configuration.
    $config_name = 'system.site';
    $config = \Drupal::configFactory()->get($config_name)->getRawData();

    $this->assertEquals('Drupal', $config['name']);
    $this->assertEquals('/node', $config['page']['front']);

    // Use the one_example_com domain.
    $domains = $this->getDomains();
    $one = $domains['one_example_com'];

    // Test stored configuration.
    $config = $domain_config_factory_override->getOverride('one_example_com', 'system.site');
    $config_en = $domain_language_config_factory_override->getDomainOverride('one_example_com', 'en', 'system.site');

    $this->assertEquals('One', $config_en->get('name'));
    $this->assertEquals('/node/1', $config->get('page.front'));

    // $this->drupalLogin($this->adminUser);
    $this->drupalLoginOnHost($this->adminUser, rtrim($one->getPath(), '/'));
    $path = $one->getPath() . 'admin/config/system/site-information';

    // Visit the site information page.
    $this->drupalGet($path);
    $page = $this->getSession()->getPage();
    $page->clickLink('Enable domain configuration');

    // Needed, otherwise the form submit below fails because of a warning.
    $config = $domain_config_factory_override->getOverride('one_example_com', 'system.site');
    $config->set('langcode', 'en')->save();

    $this->drupalGet($path);

    // Test our form.
    $edit = [
      'site_name' => 'New name',
      'site_frontpage' => '/user',
    ];
    $this->submitForm($edit, 'Save configuration');

    // Check the site information values have been properly saved.
    $config = $domain_config_factory_override->getOverride('one_example_com', 'system.site');
    $this->assertEquals('New name', $config->get('name'));
    $this->assertEquals('/user', $config->get('page.front'));
  }

}
