<?php

namespace Drupal\domain;

use Drupal\Core\Config\BootstrapConfigStorageFactory;
use Drupal\Core\DependencyInjection\ContainerBuilder;
use Drupal\Core\DependencyInjection\ServiceProviderBase;
use Drupal\domain\EventSubscriber\DomainRedirectResponseSubscriber;

/**
 * Provides services overrides for Domain.
 */
class DomainServiceProvider extends ServiceProviderBase {

  /**
   * {@inheritdoc}
   */
  public function register(ContainerBuilder $container) {
    $config_storage = BootstrapConfigStorageFactory::get();
    $domain_settings = $config_storage->read('domain.settings');
    // Set the www_prefix parameter to the container so that we can avoid
    // reading from configuration during domain negotiation.
    // See https://www.drupal.org/i/3560725
    $container->setParameter('domain.www_prefix', $domain_settings['www_prefix'] ?? FALSE);
  }

  /**
   * {@inheritdoc}
   */
  public function alter(ContainerBuilder $container) {
    // Add the site context to the render cache.
    if ($container->hasParameter('renderer.config')) {
      $renderer_config = $container->getParameter('renderer.config');

      if (!in_array('url.site', $renderer_config['required_cache_contexts'], TRUE)) {
        $renderer_config['required_cache_contexts'][] = 'url.site';
      }

      $container->setParameter('renderer.config', $renderer_config);
    }
    // Overrides redirect_response_subscriber service to use our own
    // implementation.
    if ($container->hasDefinition('redirect_response_subscriber')) {
      $definition = $container->getDefinition('redirect_response_subscriber');
      $definition->setClass(DomainRedirectResponseSubscriber::class);
    }
  }

}
